/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;

public class UniTimeTable<T>
extends FlexTable
implements SimpleForm.HasMobileScroll,
HasEnabled {
    private List<MouseOverListener<T>> iMouseOverListeners = new ArrayList<MouseOverListener<T>>();
    private List<MouseOutListener<T>> iMouseOutListeners = new ArrayList<MouseOutListener<T>>();
    private List<MouseClickListener<T>> iMouseClickListeners = new ArrayList<MouseClickListener<T>>();
    private List<MouseDoubleClickListener<T>> iMouseDoubleClickListeners = new ArrayList<MouseDoubleClickListener<T>>();
    private List<DataChangedListener<T>> iDataChangedListeners = new ArrayList<DataChangedListener<T>>();
    private PopupPanel iHintPanel = null;
    protected HintProvider<T> iHintProvider = null;
    protected int iLastHoverRow = -1;
    protected Map<Integer, String> iLastHoverBackgroundColor = new HashMap<Integer, String>();
    private boolean iAllowSelection = false;
    private boolean iAllowMultiSelect = true;
    private boolean iEnabled = true;

    public UniTimeTable() {
        this.setCellPadding(2);
        this.setCellSpacing(0);
        this.sinkEvents(16);
        this.sinkEvents(32);
        this.sinkEvents(1);
        this.sinkEvents(128);
        this.sinkEvents(2);
        this.setStylePrimaryName("unitime-MainTable");
        this.iHintPanel = new PopupPanel();
        this.iHintPanel.setStyleName("unitime-PopupHint");
        Roles.getGridRole().set((Element)this.getElement());
    }

    public void setAllowSelection(boolean allow) {
        this.iAllowSelection = allow;
    }

    public boolean isAllowSelection() {
        return this.iAllowSelection;
    }

    public void setAllowMultiSelect(boolean allow) {
        this.iAllowMultiSelect = allow;
    }

    public boolean isAllowMultiSelect() {
        return this.iAllowMultiSelect;
    }

    public boolean isCanSelectRow(int row) {
        return true;
    }

    public void clearTable(int headerRows) {
        for (int row = this.getRowCount() - 1; row >= headerRows; --row) {
            this.removeRow(row);
        }
        this.iLastHoverBackgroundColor.clear();
    }

    public void clearTable() {
        this.clearTable(0);
    }

    public int addRow(T data, Widget ... widgets) {
        ArrayList<Widget> list = new ArrayList<Widget>();
        for (Widget widget : widgets) {
            list.add(widget);
        }
        return this.addRow(data, list);
    }

    public int addRow(T data, List<? extends Widget> widgets) {
        int row = this.getRowCount();
        this.setRow(row, data, widgets);
        return row;
    }

    public void setRow(int row, T data, List<? extends Widget> widgets) {
        SmartTableRow<T> oldRow = this.getSmartRow(row);
        if (oldRow != null && oldRow.getData() != null) {
            DataChangedEvent<T> event = new DataChangedEvent<T>(oldRow.getData(), row);
            for (DataChangedListener<T> listener : this.iDataChangedListeners) {
                listener.onDataRemoved(event);
            }
        }
        SmartTableRow<T> smartRow = new SmartTableRow<T>(data);
        int col = 0;
        int x = 0;
        for (Widget widget : widgets) {
            List<String> styleNames;
            SmartTableCell cell = new SmartTableCell(smartRow, widget);
            int colspan = 1;
            if (widget instanceof HasColSpan) {
                colspan = ((HasColSpan)widget).getColSpan();
                this.getFlexCellFormatter().setColSpan(row, col, colspan);
            }
            if (widget instanceof HasStyleName && ((HasStyleName)widget).getStyleName() != null) {
                this.getFlexCellFormatter().setStyleName(row, col, ((HasStyleName)widget).getStyleName());
            }
            if (widget instanceof HasAdditionalStyleNames && (styleNames = ((HasAdditionalStyleNames)widget).getAdditionalStyleNames()) != null) {
                for (String styleName : styleNames) {
                    this.getFlexCellFormatter().addStyleName(row, col, styleName);
                }
            }
            if (widget instanceof HasCellAlignment) {
                this.getFlexCellFormatter().setHorizontalAlignment(row, col, ((HasCellAlignment)widget).getCellAlignment());
            }
            if (widget instanceof HasVerticalCellAlignment) {
                this.getFlexCellFormatter().setVerticalAlignment(row, col, ((HasVerticalCellAlignment)widget).getVerticalCellAlignment());
            }
            if (widget instanceof HasColumn) {
                ((HasColumn)widget).setColumn(col);
            }
            this.setWidget(row, col, (Widget)cell);
            if (widget instanceof HasStyleChanges) {
                ((HasStyleChanges)widget).applyStyleChanegs(this.getFlexCellFormatter().getElement(row, col).getStyle());
            }
            if (widget instanceof AriaHiddenLabel) {
                this.getFlexCellFormatter().addStyleName(row, col, "rowheader");
                Roles.getRowheaderRole().set((Element)this.getCellFormatter().getElement(row, col));
            } else if (widget instanceof UniTimeTableHeader) {
                Roles.getColumnheaderRole().set((Element)this.getCellFormatter().getElement(row, col));
            } else {
                Roles.getGridcellRole().set((Element)this.getCellFormatter().getElement(row, col));
            }
            x += colspan;
            if (row > 0) {
                if (colspan == 1) {
                    this.getCellFormatter().setVisible(row, col, this.isColumnVisible(x - 1));
                } else {
                    int span = 0;
                    for (int h = x - colspan; h < x; ++h) {
                        if (!this.isColumnVisible(h)) continue;
                        ++span;
                    }
                    this.getCellFormatter().setVisible(row, col, span > 0);
                    this.getFlexCellFormatter().setColSpan(row, col, Math.max(1, span));
                }
            }
            ++col;
        }
        Roles.getRowRole().set((Element)this.getRowFormatter().getElement(row));
        if (data != null) {
            DataChangedEvent<T> event = new DataChangedEvent<T>(data, row);
            for (DataChangedListener<T> listener : this.iDataChangedListeners) {
                listener.onDataInserted(event);
            }
        }
    }

    public boolean isColumnVisible(int col) {
        if (this.getRowCount() <= 0) {
            return true;
        }
        for (int c = 0; c < this.getCellCount(0); ++c) {
            if ((col -= this.getFlexCellFormatter().getColSpan(0, c)) >= 0) continue;
            return this.getCellFormatter().isVisible(0, c);
        }
        return true;
    }

    public void setColumnVisible(int col, boolean visible) {
        block0: for (int r = 0; r < this.getRowCount(); ++r) {
            if (r == 0) {
                this.getCellFormatter().setVisible(r, col, visible);
                continue;
            }
            int x = 0;
            for (int c = 0; c < this.getCellCount(r); ++c) {
                int colSpan;
                Widget w = this.getWidget(r, c);
                int n = colSpan = w instanceof HasColSpan ? ((HasColSpan)w).getColSpan() : 1;
                if ((x += colSpan) <= col) continue;
                if (colSpan > 1) {
                    int span = 0;
                    for (int h = x - colSpan; h < x; ++h) {
                        if (!this.isColumnVisible(h)) continue;
                        ++span;
                    }
                    this.getCellFormatter().setVisible(r, c, span > 0);
                    this.getFlexCellFormatter().setColSpan(r, c, Math.max(1, span));
                    continue block0;
                }
                this.getCellFormatter().setVisible(r, c, visible);
                continue block0;
            }
        }
    }

    public Widget getWidget(int row, int col) {
        Widget w = super.getWidget(row, col);
        if (w == null) {
            return w;
        }
        if (w instanceof SmartTableCell) {
            return ((SmartTableCell)w).getInnerWidget();
        }
        return w;
    }

    public Widget replaceWidget(int row, int col, Widget widget) {
        Widget w = super.getWidget(row, col);
        if (w == null) {
            super.setWidget(row, col, widget);
        } else if (w instanceof SmartTableCell) {
            super.setWidget(row, col, (Widget)new SmartTableCell(((SmartTableCell)w).getRow(), widget));
        } else {
            super.setWidget(row, col, widget);
        }
        return w;
    }

    private boolean focus(int row, int col) {
        if (!this.getRowFormatter().isVisible(row) || col >= this.getCellCount(row)) {
            return false;
        }
        Widget w = super.getWidget(row, col);
        if (w == null || !w.isVisible()) {
            return false;
        }
        if (w instanceof SmartTableCell) {
            return ((SmartTableCell)w).focus();
        }
        if (w instanceof HasFocus) {
            return ((HasFocus)w).focus();
        }
        if (w instanceof Focusable) {
            ((Focusable)w).setFocus(true);
            if (w instanceof TextBoxBase) {
                ((TextBoxBase)w).selectAll();
            }
            return true;
        }
        return false;
    }

    public T getData(int row) {
        SmartTableRow<T> r = this.getSmartRow(row);
        return r == null ? null : (T)r.getData();
    }

    public List<T> getData() {
        ArrayList<T> ret = new ArrayList<T>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            T data = this.getData(row);
            if (data == null) continue;
            ret.add(data);
        }
        return ret;
    }

    public SmartTableRow<T> getSmartRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        for (int col = 0; col < this.getCellCount(row); ++col) {
            Widget w = super.getWidget(row, col);
            if (w == null || !(w instanceof SmartTableCell)) continue;
            return ((SmartTableCell)w).getRow();
        }
        return null;
    }

    private void swapRows(int r0, int r1) {
        if (r0 == r1) {
            return;
        }
        if (r0 > r1) {
            this.swapRows(r1, r0);
        } else {
            com.google.gwt.user.client.Element body = this.getBodyElement();
            com.google.gwt.user.client.Element a = DOM.getChild((Element)body, (int)r0);
            com.google.gwt.user.client.Element b = DOM.getChild((Element)body, (int)r1);
            body.removeChild((Node)a);
            body.removeChild((Node)b);
            DOM.insertChild((Element)body, (Element)b, (int)r0);
            DOM.insertChild((Element)body, (Element)a, (int)r1);
        }
    }

    public void sort(int column, Comparator<T> rowComparator) {
        this.sort(this.getHeader(column), rowComparator);
    }

    public void sort(String columnName, Comparator<T> rowComparator) {
        this.sort(this.getHeader(columnName), rowComparator);
    }

    public void sort(UniTimeTableHeader header, Comparator<T> rowComparator) {
        if (header != null) {
            this.sort(header, rowComparator, header.getOrder() == null ? true : header.getOrder() == false);
        } else {
            this.sort(header, rowComparator, true);
        }
    }

    public void sort(UniTimeTableHeader header, final Comparator<T> rowComparator, boolean asc) {
        if (header != null) {
            for (int i = 0; i < this.getCellCount(0); ++i) {
                Widget w = this.getWidget(0, i);
                if (w == null || !(w instanceof UniTimeTableHeader)) continue;
                UniTimeTableHeader h = (UniTimeTableHeader)w;
                h.setOrder(null);
            }
            header.setOrder(asc);
        }
        com.google.gwt.user.client.Element body = this.getBodyElement();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            SmartTableRow<T> r = this.getSmartRow(row);
            if (r == null || !r.hasData()) continue;
            rows.add(new Object[]{r, this.getRowFormatter().getElement(row)});
        }
        if (asc) {
            Collections.sort(rows, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] a, Object[] b) {
                    return rowComparator.compare(((SmartTableRow)a[0]).getData(), ((SmartTableRow)b[0]).getData());
                }
            });
        } else {
            Collections.sort(rows, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] a, Object[] b) {
                    return -rowComparator.compare(((SmartTableRow)a[0]).getData(), ((SmartTableRow)b[0]).getData());
                }
            });
        }
        int idx = 0;
        ArrayList changeEvents = new ArrayList();
        for (int row = 0; row < this.getRowCount(); ++row) {
            SmartTableRow<T> a = this.getSmartRow(row);
            if (a == null || !a.hasData()) continue;
            Object[] o = (Object[])rows.get(idx++);
            int otherRow = DOM.getChildIndex((Element)body, (Element)((Element)o[1]));
            this.swapRows(row, otherRow);
            changeEvents.add(new DataChangedEvent(((SmartTableRow)o[0]).getData(), row));
        }
        for (DataChangedListener listener : this.iDataChangedListeners) {
            listener.onDataSorted(changeEvents);
        }
    }

    public void sortByRow(int column, Comparator<Integer> rowComparator) {
        this.sortByRow(this.getHeader(column), rowComparator);
    }

    public void sortByRow(String columnName, Comparator<Integer> rowComparator) {
        this.sortByRow(this.getHeader(columnName), rowComparator);
    }

    public void sortByRow(UniTimeTableHeader header, Comparator<Integer> rowComparator) {
        if (header != null) {
            this.sortByRow(header, rowComparator, header.getOrder() == null ? true : header.getOrder() == false);
        } else {
            this.sortByRow(header, rowComparator, true);
        }
    }

    public void sortByRow(UniTimeTableHeader header, final Comparator<Integer> rowComparator, boolean asc) {
        if (header != null) {
            for (int i = 0; i < this.getCellCount(0); ++i) {
                Widget w = this.getWidget(0, i);
                if (w == null || !(w instanceof UniTimeTableHeader)) continue;
                UniTimeTableHeader h = (UniTimeTableHeader)w;
                h.setOrder(null);
            }
            header.setOrder(asc);
        }
        com.google.gwt.user.client.Element body = this.getBodyElement();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            SmartTableRow<T> r = this.getSmartRow(row);
            if (r == null || !r.hasData()) continue;
            rows.add(new Object[]{r, this.getRowFormatter().getElement(row), row});
        }
        if (asc) {
            Collections.sort(rows, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] a, Object[] b) {
                    return rowComparator.compare((Integer)a[2], (Integer)b[2]);
                }
            });
        } else {
            Collections.sort(rows, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] a, Object[] b) {
                    return -rowComparator.compare((Integer)a[2], (Integer)b[2]);
                }
            });
        }
        int idx = 0;
        ArrayList changeEvents = new ArrayList();
        for (int row = 0; row < this.getRowCount(); ++row) {
            SmartTableRow<T> a = this.getSmartRow(row);
            if (a == null || !a.hasData()) continue;
            Object[] o = (Object[])rows.get(idx++);
            int otherRow = DOM.getChildIndex((Element)body, (Element)((Element)o[1]));
            this.swapRows(row, otherRow);
            changeEvents.add(new DataChangedEvent(((SmartTableRow)o[0]).getData(), row));
        }
        for (DataChangedListener listener : this.iDataChangedListeners) {
            listener.onDataSorted(changeEvents);
        }
    }

    public boolean canSwapRows(T a, T b) {
        return true;
    }

    public void onBrowserEvent(Event event) {
        String html;
        com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
        if (td == null) {
            return;
        }
        com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
        int col = DOM.getChildIndex((Element)tr, (Element)td);
        com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
        int row = DOM.getChildIndex((Element)body, (Element)tr);
        Widget widget = this.getWidget(row, col);
        SmartTableRow<T> r = this.getSmartRow(row);
        boolean hasData = r != null && r.getData() != null;
        TableEvent<Object> tableEvent = new TableEvent<Object>(event, row, col, (Element)tr, (Element)td, (hasData ? (Object)r.getData() : null));
        Widget hint = null;
        if (widget instanceof HasHint && (html = ((HasHint)widget).getHint()) != null && !html.isEmpty()) {
            hint = new HTML(html, false);
        }
        if (hint == null && this.iHintProvider != null) {
            hint = this.iHintProvider.getHint(tableEvent);
        }
        String style = this.getRowFormatter().getStyleName(row);
        switch (DOM.eventGetType((Event)event)) {
            case 16: {
                if (hasData) {
                    if (!this.iMouseClickListeners.isEmpty()) {
                        this.getRowFormatter().getElement(row).getStyle().setCursor(Style.Cursor.POINTER);
                    }
                    boolean selected = false;
                    if (this.isAllowSelection()) {
                        if ("unitime-TableRowSelectedHover".equals(style)) {
                            selected = true;
                        } else if ("unitime-TableRowSelected".equals(style)) {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowSelectedHover");
                            selected = true;
                        } else {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowHover");
                        }
                    } else {
                        this.getRowFormatter().addStyleName(row, "unitime-TableRowHover");
                    }
                    this.iLastHoverRow = row;
                    if (!selected) {
                        String string = this.getRowFormatter().getElement(row).getStyle().getBackgroundColor();
                        if (string != null && !string.isEmpty()) {
                            this.getRowFormatter().getElement(row).getStyle().clearBackgroundColor();
                            this.iLastHoverBackgroundColor.put(row, string);
                        } else {
                            this.iLastHoverBackgroundColor.remove(row);
                        }
                    }
                }
                if (!this.iHintPanel.isShowing() && hint != null) {
                    this.iHintPanel.setWidget(hint);
                    this.iHintPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback((Element)tr, event){
                        final /* synthetic */ Element val$tr;
                        final /* synthetic */ Event val$event;
                        {
                            this.val$tr = element;
                            this.val$event = event;
                        }

                        public void setPosition(int offsetWidth, int offsetHeight) {
                            boolean top = this.val$tr.getAbsoluteBottom() - Window.getScrollTop() + 15 + offsetHeight > Window.getClientHeight();
                            UniTimeTable.this.iHintPanel.setPopupPosition(Math.max(Math.min(this.val$event.getClientX(), this.val$tr.getAbsoluteRight() - offsetWidth - 15), this.val$tr.getAbsoluteLeft() + 15), top ? this.val$tr.getAbsoluteTop() - offsetHeight - 15 : this.val$tr.getAbsoluteBottom() + 15);
                        }
                    });
                }
                for (MouseOverListener<Object> mouseOverListener : this.iMouseOverListeners) {
                    mouseOverListener.onMouseOver(tableEvent);
                }
                break;
            }
            case 32: {
                if (hasData) {
                    String string;
                    if (!this.iMouseClickListeners.isEmpty()) {
                        this.getRowFormatter().getElement(row).getStyle().clearCursor();
                    }
                    boolean selected = false;
                    if (this.isAllowSelection()) {
                        if ("unitime-TableRowHover".equals(style)) {
                            this.getRowFormatter().setStyleName(row, null);
                        } else if ("unitime-TableRowSelectedHover".equals(style)) {
                            this.getRowFormatter().setStyleName(row, "unitime-TableRowSelected");
                            selected = true;
                        }
                    } else {
                        this.getRowFormatter().removeStyleName(row, "unitime-TableRowHover");
                    }
                    if (!selected && (string = this.iLastHoverBackgroundColor.remove(row)) != null && !string.isEmpty()) {
                        this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(string);
                    }
                    this.iLastHoverRow = -1;
                }
                if (this.iHintPanel.isShowing()) {
                    this.iHintPanel.hide();
                }
                for (MouseOutListener<Object> mouseOutListener : this.iMouseOutListeners) {
                    mouseOutListener.onMouseOut(tableEvent);
                }
                break;
            }
            case 64: {
                if (!this.iHintPanel.isShowing()) break;
                boolean top = tr.getAbsoluteBottom() - Window.getScrollTop() + 15 + this.iHintPanel.getOffsetHeight() > Window.getClientHeight();
                this.iHintPanel.setPopupPosition(Math.max(Math.min(event.getClientX(), tr.getAbsoluteRight() - this.iHintPanel.getOffsetWidth() - 15), tr.getAbsoluteLeft() + 15), top ? tr.getAbsoluteTop() - this.iHintPanel.getOffsetHeight() - 15 : tr.getAbsoluteBottom() + 15);
                break;
            }
            case 1: {
                if (this.isAllowSelection() && hasData && this.isCanSelectRow(row) && this.isEnabled()) {
                    com.google.gwt.user.client.Element element = DOM.eventGetTarget((Event)event);
                    while (element.getPropertyString("tagName").equalsIgnoreCase("div")) {
                        element = DOM.getParent((Element)element);
                    }
                    if (this.isAllowMultiSelect()) {
                        if (element.getPropertyString("tagName").equalsIgnoreCase("td")) {
                            boolean bl = "unitime-TableRowHover".equals(style) || "unitime-TableRowSelectedHover".equals(style);
                            boolean selected = !"unitime-TableRowSelected".equals(style) && !"unitime-TableRowSelectedHover".equals(style);
                            this.getRowFormatter().setStyleName(row, "unitime-TableRow" + (selected ? "Selected" : "") + (bl ? "Hover" : ""));
                        }
                    } else {
                        int n = this.getSelectedRow();
                        if (n != row && n >= 0) {
                            this.setSelected(n, false);
                        }
                        boolean hover = "unitime-TableRowHover".equals(style) || "unitime-TableRowSelectedHover".equals(style);
                        this.getRowFormatter().setStyleName(row, "unitime-TableRowSelected" + (hover ? "Hover" : ""));
                    }
                }
                if (this.iHintPanel != null && this.iHintPanel.isShowing()) {
                    this.iHintPanel.hide();
                }
                for (MouseClickListener mouseClickListener : this.iMouseClickListeners) {
                    mouseClickListener.onMouseClick(tableEvent);
                }
                break;
            }
            case 2: {
                if (this.iHintPanel != null && this.iHintPanel.isShowing()) {
                    this.iHintPanel.hide();
                }
                for (MouseDoubleClickListener<Object> mouseDoubleClickListener : this.iMouseDoubleClickListeners) {
                    mouseDoubleClickListener.onMouseDoubleClick(tableEvent);
                }
                break;
            }
            case 128: {
                if (event.getKeyCode() == 39 && (event.getAltKey() || event.getMetaKey())) {
                    while (++col < this.getCellCount(row) && !this.focus(row, col)) {
                    }
                    event.stopPropagation();
                    event.preventDefault();
                }
                if (event.getKeyCode() == 37 && (event.getAltKey() || event.getMetaKey())) {
                    while (--col >= 0 && !this.focus(row, col)) {
                    }
                    event.stopPropagation();
                    event.preventDefault();
                }
                if (event.getKeyCode() == 38 && (event.getAltKey() || event.getMetaKey())) {
                    while (--row >= 0 && !this.focus(row, col)) {
                    }
                    event.stopPropagation();
                    event.preventDefault();
                } else if (hasData && event.getKeyCode() == 38 && event.getCtrlKey()) {
                    SmartTableRow<T> up = this.getSmartRow(row - 1);
                    if (up != null && up.getData() != null && this.canSwapRows(r.getData(), up.getData())) {
                        this.getRowFormatter().removeStyleName(row, "unitime-TableRowHover");
                        this.getRowFormatter().removeStyleName(row - 1, "unitime-TableRowHover");
                        this.swapRows(row - 1, row);
                        this.focus(row - 1, col);
                        if (!this.iDataChangedListeners.isEmpty()) {
                            ArrayList arrayList = new ArrayList();
                            arrayList.add(new DataChangedEvent<T>(up.getData(), row));
                            arrayList.add(new DataChangedEvent<T>(r.getData(), row - 1));
                            for (DataChangedListener listener : this.iDataChangedListeners) {
                                listener.onDataMoved(arrayList);
                            }
                        }
                    }
                    event.stopPropagation();
                    event.preventDefault();
                }
                if (event.getKeyCode() == 40 && (event.getAltKey() || event.getMetaKey())) {
                    while (++row < this.getRowCount() && !this.focus(row, col)) {
                    }
                    event.stopPropagation();
                    event.preventDefault();
                    break;
                }
                if (!hasData || event.getKeyCode() != 40 || !event.getCtrlKey()) break;
                SmartTableRow<T> dn = this.getSmartRow(row + 1);
                if (dn != null && dn.getData() != null && this.canSwapRows(r.getData(), dn.getData())) {
                    this.getRowFormatter().removeStyleName(row, "unitime-TableRowHover");
                    this.getRowFormatter().removeStyleName(row + 1, "unitime-TableRowHover");
                    this.swapRows(row + 1, row);
                    this.focus(row + 1, col);
                    if (!this.iDataChangedListeners.isEmpty()) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.add(new DataChangedEvent<T>(dn.getData(), row));
                        arrayList.add(new DataChangedEvent<T>(r.getData(), row + 1));
                        for (DataChangedListener listener : this.iDataChangedListeners) {
                            listener.onDataMoved(arrayList);
                        }
                    }
                }
                event.stopPropagation();
                event.preventDefault();
            }
        }
    }

    public void clearHover() {
        if (this.iLastHoverRow >= 0 && this.iLastHoverRow < this.getRowCount()) {
            String color;
            boolean selected = false;
            if (this.isAllowSelection()) {
                String style = this.getRowFormatter().getStyleName(this.iLastHoverRow);
                selected = "unitime-TableRowSelected".equals(style) || "unitime-TableRowSelectedHover".equals(style);
                this.getRowFormatter().setStyleName(this.iLastHoverRow, "unitime-TableRow" + (selected ? "Selected" : ""));
            } else {
                this.getRowFormatter().removeStyleName(this.iLastHoverRow, "unitime-TableRowHover");
            }
            if (!selected && (color = this.iLastHoverBackgroundColor.remove(this.iLastHoverRow)) != null && !color.isEmpty()) {
                this.getRowFormatter().getElement(this.iLastHoverRow).getStyle().setBackgroundColor(color);
            }
        }
        this.iLastHoverRow = -1;
    }

    public boolean isSelected(int row) {
        if (this.isAllowSelection()) {
            String style = this.getRowFormatter().getStyleName(row);
            return "unitime-TableRowSelected".equals(style) || "unitime-TableRowSelectedHover".equals(style);
        }
        return false;
    }

    public void setSelected(int row, boolean selected) {
        int old;
        if (!this.isCanSelectRow(row)) {
            return;
        }
        if (this.isAllowSelection() && !this.isAllowMultiSelect() && selected && (old = this.getSelectedRow()) >= 0 && old != row) {
            this.setSelected(old, false);
        }
        if (this.isAllowSelection()) {
            String style = this.getRowFormatter().getStyleName(row);
            boolean hover = "unitime-TableRowHover".equals(style) || "unitime-TableRowSelectedHover".equals(style);
            boolean wasSelected = "unitime-TableRowSelected".equals(style) || "unitime-TableRowSelectedHover".equals(style);
            this.getRowFormatter().setStyleName(row, "unitime-TableRow" + (selected ? "Selected" : "") + (hover ? "Hover" : ""));
            if (!hover && wasSelected != selected) {
                if (selected) {
                    String color = this.getRowFormatter().getElement(row).getStyle().getBackgroundColor();
                    if (color != null && !color.isEmpty()) {
                        this.getRowFormatter().getElement(row).getStyle().clearBackgroundColor();
                        this.iLastHoverBackgroundColor.put(row, color);
                    }
                } else {
                    String color = this.iLastHoverBackgroundColor.remove(row);
                    if (color != null && !color.isEmpty()) {
                        this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(color);
                    }
                }
            }
        }
    }

    public int getSelectedCount() {
        int selected = 0;
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!this.isSelected(row)) continue;
            ++selected;
        }
        return selected;
    }

    public int getSelectedRow() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!this.isSelected(row)) continue;
            return row;
        }
        return -1;
    }

    public void addMouseOverListener(MouseOverListener<T> mouseOverListener) {
        this.iMouseOverListeners.add(mouseOverListener);
    }

    public void addMouseOutListener(MouseOutListener<T> mouseOutListener) {
        this.iMouseOutListeners.add(mouseOutListener);
    }

    public void addMouseClickListener(MouseClickListener<T> mouseClickListener) {
        this.iMouseClickListeners.add(mouseClickListener);
    }

    public void addMouseDoubleClickListener(MouseDoubleClickListener<T> mouseDoubleClickListener) {
        this.iMouseDoubleClickListeners.add(mouseDoubleClickListener);
    }

    public void addDataChangedListener(DataChangedListener<T> listener) {
        this.iDataChangedListeners.add(listener);
    }

    public UniTimeTableHeader getHeader(String name) {
        if (this.getRowCount() <= 0) {
            return null;
        }
        if (name == null) {
            Widget w = this.getWidget(0, 0);
            return w != null && w instanceof UniTimeTableHeader ? (UniTimeTableHeader)w : null;
        }
        for (int i = 0; i < this.getCellCount(0); ++i) {
            UniTimeTableHeader h;
            Widget w = this.getWidget(0, i);
            if (w == null || !(w instanceof UniTimeTableHeader) || !(h = (UniTimeTableHeader)w).getHTML().equals(name)) continue;
            return h;
        }
        UniTimeNotifications.warn("Header named " + name + " does not exist!");
        return null;
    }

    public UniTimeTableHeader getHeader(int col) {
        if (this.getRowCount() <= 0 || this.getCellCount(0) <= col) {
            return null;
        }
        for (int c = 0; c < this.getCellCount(0); ++c) {
            if ((col -= this.getFlexCellFormatter().getColSpan(0, c)) >= 0) continue;
            Widget w = this.getWidget(0, c);
            return w != null && w instanceof UniTimeTableHeader ? (UniTimeTableHeader)w : null;
        }
        return null;
    }

    public void setHintProvider(HintProvider<T> hintProvider) {
        this.iHintProvider = hintProvider;
    }

    public void setBackGroundColor(int row, String color) {
        String style = this.getRowFormatter().getStyleName(row);
        if (style != null && !style.isEmpty()) {
            if (color == null || color.isEmpty()) {
                this.iLastHoverBackgroundColor.remove(row);
            } else {
                this.iLastHoverBackgroundColor.put(row, color);
            }
        } else if (color == null || color.isEmpty()) {
            this.getRowFormatter().getElement(row).getStyle().clearBackgroundColor();
        } else {
            this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(color);
        }
    }

    public void refreshTable() {
        for (int r = 1; r < this.getRowCount(); ++r) {
            for (int c = 0; c < this.getCellCount(r); ++c) {
                Widget w = this.getWidget(r, c);
                if (!(w instanceof HasRefresh)) continue;
                ((HasRefresh)w).refresh();
            }
        }
    }

    public int getRowForWidget(Widget w) {
        com.google.gwt.user.client.Element td = w.getElement();
        while (td != null) {
            com.google.gwt.user.client.Element tr;
            com.google.gwt.user.client.Element body;
            if (td.getPropertyString("tagName").equalsIgnoreCase("td") && (body = DOM.getParent((Element)(tr = DOM.getParent((Element)td)))) == this.getBodyElement()) {
                return DOM.getChildIndex((Element)body, (Element)tr);
            }
            if (td == this.getBodyElement()) {
                return -1;
            }
            td = DOM.getParent((Element)td);
        }
        return -1;
    }

    public void setEmptyMessage(String message) {
        this.addRow(null, new Widget[]{new EmptyRow(message)});
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public class EmptyRow
    extends P
    implements HasColSpan {
        public EmptyRow(String message) {
            super("empty-row");
            this.setText(message);
        }

        @Override
        public int getColSpan() {
            return UniTimeTable.this.getRowCount() == 0 ? 1 : UniTimeTable.this.getCellCount(0);
        }
    }

    public static interface HasRefresh {
        public void refresh();
    }

    public static class CheckBoxCell
    extends AriaCheckBox
    implements HasCellAlignment {
        public CheckBoxCell() {
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    public static class CenterredCell
    extends HTML
    implements HasCellAlignment {
        public CenterredCell(String text) {
            super(text, false);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    public static class NumberCell
    extends HTML
    implements HasCellAlignment {
        public NumberCell(String text) {
            super(text, false);
        }

        public NumberCell(int text) {
            super(String.valueOf(text), false);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static interface HintProvider<T> {
        public Widget getHint(TableEvent<T> var1);
    }

    public static interface HasColumn {
        public int getColumn();

        public void setColumn(int var1);
    }

    public static interface HasDataUpdate {
        public void update();
    }

    public static interface HasStyleChanges {
        public void applyStyleChanegs(Style var1);
    }

    public static interface HasAdditionalStyleNames {
        public List<String> getAdditionalStyleNames();
    }

    public static interface HasStyleName {
        public String getStyleName();
    }

    public static interface HasVerticalCellAlignment {
        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment();
    }

    public static interface HasCellAlignment {
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment();
    }

    public static interface HasColSpan {
        public int getColSpan();
    }

    public static interface HasHint {
        public String getHint();
    }

    public static interface HasFocus {
        public boolean focus();
    }

    public static interface DataChangedListener<T> {
        public void onDataInserted(DataChangedEvent<T> var1);

        public void onDataRemoved(DataChangedEvent<T> var1);

        public void onDataMoved(List<DataChangedEvent<T>> var1);

        public void onDataSorted(List<DataChangedEvent<T>> var1);
    }

    public static class DataChangedEvent<T> {
        private T iData;
        private int iRow;

        public DataChangedEvent(T data, int row) {
            this.iData = data;
            this.iRow = row;
        }

        public T getData() {
            return this.iData;
        }

        public int getRow() {
            return this.iRow;
        }
    }

    public static interface MouseDoubleClickListener<T> {
        public void onMouseDoubleClick(TableEvent<T> var1);
    }

    public static interface MouseClickListener<T> {
        public void onMouseClick(TableEvent<T> var1);
    }

    public static interface MouseOutListener<T> {
        public void onMouseOut(TableEvent<T> var1);
    }

    public static interface MouseOverListener<T> {
        public void onMouseOver(TableEvent<T> var1);
    }

    public static class TableEvent<T> {
        private Event iSourceEvent;
        private int iRow;
        private int iCol;
        private Element iTD;
        private Element iTR;
        private T iData;

        public TableEvent(Event sourceEvent, int row, int col, Element tr, Element td, T data) {
            this.iRow = row;
            this.iCol = col;
            this.iTR = tr;
            this.iTD = td;
            this.iData = data;
            this.iSourceEvent = sourceEvent;
        }

        public int getRow() {
            return this.iRow;
        }

        public int getCol() {
            return this.iCol;
        }

        public T getData() {
            return this.iData;
        }

        public Element getRowElement() {
            return this.iTR;
        }

        public Element getCellElement() {
            return this.iTD;
        }

        public Event getSourceEvent() {
            return this.iSourceEvent;
        }
    }

    public static class SmartTableCell
    extends Composite {
        SmartTableRow iRow;

        public SmartTableCell(SmartTableRow row, Widget widget) {
            this.iRow = row;
            row.getCells().add(this);
            this.initWidget(widget);
        }

        public SmartTableRow getRow() {
            return this.iRow;
        }

        public boolean focus() {
            if (this.getWidget() instanceof HasFocus) {
                return ((HasFocus)this.getWidget()).focus();
            }
            if (this.getWidget() instanceof Focusable) {
                ((Focusable)this.getWidget()).setFocus(true);
                if (this.getWidget() instanceof TextBoxBase) {
                    ((TextBoxBase)this.getWidget()).selectAll();
                }
                return true;
            }
            return false;
        }

        public Widget getInnerWidget() {
            return this.getWidget();
        }
    }

    public static class SmartTableRow<T> {
        private List<SmartTableCell> iCells = new ArrayList<SmartTableCell>();
        private T iData = null;

        public SmartTableRow(T data) {
            this.iData = data;
        }

        public T getData() {
            return this.iData;
        }

        public boolean hasData() {
            return this.iData != null;
        }

        public List<SmartTableCell> getCells() {
            return this.iCells;
        }

        public Comparator<SmartTableRow<T>> getComparator(final Comparator<T> cmp) {
            return new Comparator<SmartTableRow<T>>(){

                @Override
                public int compare(SmartTableRow<T> a, SmartTableRow<T> b) {
                    return cmp.compare(a.getData(), b.getData());
                }
            };
        }
    }
}

