/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.widgets.OpenCloseSectionImage;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.GwtResources;

public class UniTimeHeaderPanel
extends P {
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static RegExp sAcessKeyRegExp = RegExp.compile((String)"<u>(\\w)</u>", (String)"i");
    private static RegExp sStripAcessKeyRegExp = RegExp.compile((String)"(.*)<u>(\\w)</u>(.*)", (String)"i");
    private HashMap<String, Integer> iOperations = new HashMap();
    private HashMap<String, ClickHandler> iClickHandlers = new HashMap();
    private P iMessage;
    private P iTitle;
    private P iLeft;
    private P iContent;
    private P iRight;
    private P iButtons;
    private Image iLoadingImage;
    private OpenCloseSectionImage iOpenCloseImage;
    private boolean iRotateFocus = false;
    private KeyDownHandler iKeyDownHandler = null;
    private List<UniTimeHeaderPanel> iClones = new ArrayList<UniTimeHeaderPanel>();

    public UniTimeHeaderPanel(String title) {
        super("unitime-HeaderPanel");
        this.iLeft = new P("left");
        this.add((Widget)this.iLeft);
        this.iRight = new P("right", "unitime-NoPrint");
        this.add((Widget)this.iRight);
        this.iButtons = new P((Element)DOM.createSpan(), "buttons");
        this.iRight.add((Widget)this.iButtons);
        this.iContent = new P("content");
        this.add((Widget)this.iContent);
        this.iOpenCloseImage = new OpenCloseSectionImage(true);
        this.iOpenCloseImage.setVisible(false);
        this.iOpenCloseImage.addStyleName("open-close");
        this.iOpenCloseImage.addStyleName("unitime-NoPrint");
        this.iLeft.add((Widget)this.iOpenCloseImage);
        this.iLoadingImage = new Image(RESOURCES.loading_small());
        this.iLoadingImage.addStyleName("loading");
        this.iLoadingImage.addStyleName("unitime-NoPrint");
        this.iLoadingImage.setVisible(false);
        this.iLeft.add((Widget)this.iLoadingImage);
        this.iTitle = new P("title");
        this.iTitle.setHTML(title);
        this.iLeft.add((Widget)this.iTitle);
        this.iMessage = new P("message");
        this.iMessage.setVisible(false);
        this.iContent.add((Widget)this.iMessage);
        this.iKeyDownHandler = new KeyDownHandler(){

            private void focus(KeyDownEvent event, final Button buttonToFocus) {
                event.preventDefault();
                event.stopPropagation();
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        buttonToFocus.setFocus(true);
                    }
                });
            }

            public void onKeyDown(KeyDownEvent event) {
                if (UniTimeHeaderPanel.this.iRotateFocus && event.getNativeKeyCode() == 9 && event.getSource() != null && event.getSource() instanceof Button) {
                    P panel = UniTimeHeaderPanel.this.iButtons;
                    Button firstButton = null;
                    for (int i = 0; i < panel.getWidgetCount(); ++i) {
                        Button button = (Button)panel.getWidget(i);
                        if (!button.isEnabled()) continue;
                        firstButton = button;
                        break;
                    }
                    if (firstButton == null) {
                        return;
                    }
                    if (!UniTimeHeaderPanel.this.iClones.isEmpty()) {
                        panel = ((UniTimeHeaderPanel)((Object)UniTimeHeaderPanel.this.iClones.get(UniTimeHeaderPanel.this.iClones.size() - 1))).iButtons;
                    }
                    Object lastButton = null;
                    for (int i = panel.getWidgetCount() - 1; i >= 0; --i) {
                        Button button = (Button)panel.getWidget(i);
                        if (!button.isEnabled()) continue;
                        lastButton = button;
                        break;
                    }
                    if (lastButton == null) {
                        return;
                    }
                    if (lastButton.equals(event.getSource()) && !event.isShiftKeyDown()) {
                        this.focus(event, firstButton);
                    }
                    if (firstButton.equals(event.getSource()) && event.isShiftKeyDown()) {
                        this.focus(event, (Button)lastButton);
                    }
                }
            }
        };
    }

    public void setRotateFocus(boolean rotateFocus) {
        this.iRotateFocus = rotateFocus;
    }

    public void setTitleStyleName(String styleName) {
        this.iTitle.setStyleName(styleName);
    }

    public void addCollapsibleHandler(ValueChangeHandler<Boolean> handler) {
        this.iOpenCloseImage.addValueChangeHandler(handler);
    }

    public void setCollapsible(Boolean opened) {
        this.iOpenCloseImage.setVisible(opened != null);
        if (opened != null) {
            this.iOpenCloseImage.setValue(opened, false);
        }
    }

    public Boolean isCollapsible() {
        return this.iOpenCloseImage.isVisible() ? this.iOpenCloseImage.getValue() : null;
    }

    public void setHeaderTitle(String title) {
        this.iTitle.setHTML(title);
    }

    public String getHeaderTitle() {
        return this.iTitle.getHTML();
    }

    public P getHeaderTitlePanel() {
        return this.iTitle;
    }

    public UniTimeHeaderPanel() {
        this("&nbsp;");
    }

    public void clearMessage() {
        this.iMessage.setHTML("");
        this.iMessage.setVisible(false);
        this.iLoadingImage.setVisible(false);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.clearMessage();
        }
    }

    public void setErrorMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("error");
            this.iMessage.setVisible(true);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setErrorMessage(message);
            }
        }
    }

    public void setWarningMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("warning");
            this.iMessage.setVisible(true);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setWarningMessage(message);
            }
        }
    }

    public void setMessage(String message) {
        if (message == null || message.isEmpty()) {
            this.clearMessage();
        } else {
            this.iLoadingImage.setVisible(false);
            this.iMessage.setHTML(message);
            this.iMessage.setStyleName("message");
            this.iMessage.setVisible(true);
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setMessage(message);
            }
        }
    }

    public void showLoading() {
        this.iMessage.setHTML("");
        this.iMessage.setVisible(false);
        this.iLoadingImage.setVisible(true);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.showLoading();
        }
    }

    public void addButton(String operation, String name, ClickHandler clickHandler) {
        this.addButton(operation, name, null, clickHandler);
    }

    public void addButton(String operation, String name, Integer width, ClickHandler clickHandler) {
        this.addButton(operation, name, UniTimeHeaderPanel.guessAccessKey(name), width == null ? null : width + "px", clickHandler);
    }

    public static Character guessAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MatchResult result = sAcessKeyRegExp.exec(name);
        return result == null ? null : Character.valueOf(result.getGroup(1).toLowerCase().charAt(0));
    }

    public static String stripAccessKey(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        MatchResult result = sStripAcessKeyRegExp.exec(name);
        return result == null ? name : result.getGroup(1) + result.getGroup(2) + result.getGroup(3);
    }

    private Button addButton(String operation, String name, Character accessKey, String width, ClickHandler clickHandler) {
        AriaButton button = new AriaButton(name);
        button.addClickHandler(clickHandler);
        ToolBox.setWhiteSpace(button.getElement().getStyle(), "nowrap");
        if (accessKey != null) {
            button.setAccessKey(accessKey.charValue());
        }
        if (width != null) {
            ToolBox.setMinWidth(button.getElement().getStyle(), width);
        }
        this.iOperations.put(operation, this.iButtons.getWidgetCount());
        this.iClickHandlers.put(operation, clickHandler);
        this.iButtons.add((Widget)button);
        button.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
        for (UniTimeHeaderPanel clone : this.iClones) {
            Button clonedButton = clone.addButton(operation, name, null, width, clickHandler);
            clonedButton.addKeyDownHandler(this.iKeyDownHandler);
        }
        button.addKeyDownHandler(this.iKeyDownHandler);
        return button;
    }

    public void setEnabled(int button, boolean enabled) {
        Button b = (Button)this.iButtons.getWidget(button);
        b.setVisible(enabled);
        b.setEnabled(enabled);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.setEnabled(button, enabled);
        }
    }

    public void setEnabled(int button, boolean enabled, boolean visible) {
        Button b = (Button)this.iButtons.getWidget(button);
        b.setVisible(visible);
        b.setEnabled(enabled);
        for (UniTimeHeaderPanel clone : this.iClones) {
            clone.setEnabled(button, enabled, visible);
        }
    }

    public void setEnabled(String operation, boolean enabled) {
        Integer op = this.iOperations.get(operation);
        if (op != null) {
            this.setEnabled(this.iOperations.get(operation), enabled);
        }
    }

    public void setEnabled(String operation, boolean enabled, boolean visible) {
        Integer op = this.iOperations.get(operation);
        if (op != null) {
            this.setEnabled(this.iOperations.get(operation), enabled, visible);
        }
    }

    public boolean isEnabled(int button) {
        return ((Button)this.iButtons.getWidget(button)).isVisible();
    }

    public Boolean isEnabled(String operation) {
        Integer op = this.iOperations.get(operation);
        return op == null ? null : Boolean.valueOf(this.isEnabled(op));
    }

    public void setFocus(int button, boolean focus) {
        Button b = (Button)this.iButtons.getWidget(button);
        b.setFocus(focus);
    }

    public void setFocus(String operation, boolean focus) {
        Integer op = this.iOperations.get(operation);
        if (op != null) {
            this.setFocus(this.iOperations.get(operation), focus);
        }
    }

    public UniTimeHeaderPanel clonePanel(String newTitle) {
        UniTimeHeaderPanel clone = new UniTimeHeaderPanel(newTitle == null ? "&nbsp;" : newTitle);
        this.iClones.add(clone);
        clone.iMessage.setHTML(this.iMessage.getHTML());
        clone.iMessage.setVisible(this.iMessage.isVisible());
        clone.iMessage.setStyleName(this.iMessage.getStyleName());
        for (int i = 0; i < this.iOperations.size(); ++i) {
            String op = null;
            for (Map.Entry<String, Integer> entry : this.iOperations.entrySet()) {
                if (entry.getValue() != i) continue;
                op = entry.getKey();
            }
            if (op == null) continue;
            final Button button = (Button)this.iButtons.getWidget(i);
            ClickHandler clickHandler = this.iClickHandlers.get(op);
            if (clickHandler == null) {
                clickHandler = new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        button.click();
                    }
                };
            }
            String width = ToolBox.getMinWidth(button.getElement().getStyle());
            Button clonedButton = clone.addButton(op, button.getHTML(), null, width, clickHandler);
            clonedButton.addKeyDownHandler(this.iKeyDownHandler);
            if (button.isVisible()) continue;
            clone.setEnabled(op, false);
        }
        return clone;
    }

    public UniTimeHeaderPanel clonePanel() {
        return this.clonePanel(this.iTitle.getHTML());
    }

    public void setVisible(boolean visible, boolean propagate) {
        super.setVisible(visible);
        if (propagate) {
            for (UniTimeHeaderPanel clone : this.iClones) {
                clone.setVisible(visible, propagate);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
    }

    public void insertLeft(Widget widget, boolean first) {
        widget.addStyleName("left-widget");
        if (first) {
            this.iLeft.insert(widget, 0);
        } else {
            this.iLeft.add(widget);
        }
    }

    public void insertWidget(Widget widget) {
        widget.addStyleName("widget");
        this.iContent.insert(widget, 1);
    }

    public void insertRight(Widget widget, boolean first) {
        widget.addStyleName("right-widget");
        if (first) {
            this.iRight.insert(widget, 0);
        } else {
            this.iRight.add(widget);
        }
    }
}

