/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class AdvisorCourseRequestsTable
extends WebTable
implements TakesValue<CourseRequestInterface> {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private CourseRequestInterface iAdvisorRequests;
    private OnlineSectioningInterface.WaitListMode iMode;

    public AdvisorCourseRequestsTable() {
        this.setEmptyMessage(MESSAGES.emptyRequests());
        this.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPriority(), 1, "25px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "200px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "20px"), new WebTable.Cell(MESSAGES.colPreferences(), 1, "100px"), new WebTable.Cell(MESSAGES.colCritical(), 1, "20px"), new WebTable.Cell(MESSAGES.colWaitList(), 1, "20px"), new WebTable.Cell(MESSAGES.colNotes(), 1, "300px")));
        this.addStyleName("unitime-AdvisorCourseRequestsTable");
        this.setSelectSameIdRows(true);
    }

    public void setMode(OnlineSectioningInterface.WaitListMode mode) {
        this.iMode = mode;
        switch (this.iMode) {
            case None: {
                this.setColumnVisible(6, false);
                break;
            }
            case NoSubs: {
                this.getTable().setHTML(0, 6, MESSAGES.colNoSubs());
                break;
            }
            case WaitList: {
                this.getTable().setHTML(0, 6, MESSAGES.colWaitList());
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void setValue(CourseRequestInterface requests) {
        String noteMessage;
        WebTable.Row row;
        Object note;
        Object row2;
        this.iAdvisorRequests = requests;
        ArrayList<Object> rows = new ArrayList<Object>();
        boolean hasPref = false;
        boolean hasCrit = false;
        boolean hasWL = false;
        int priority = 1;
        for (CourseRequestInterface.Request request : this.iAdvisorRequests.getCourses()) {
            if (request.hasRequestedCourse()) {
                if (request.isCritical() || request.isImportant()) {
                    hasCrit = true;
                }
                if (request.isWaitList()) {
                    hasWL = true;
                }
                boolean first = true;
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    row2 = null;
                    if (rc.isCourse()) {
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        if (first) {
                            WebTable.Cell credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                            WebTable.NoteCell note2 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                            note2.setRowSpan(request.getRequestedCourse().size());
                            row2 = new WebTable.Row(new WebTable.Cell(MESSAGES.courseRequestsPriority(priority)), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), credit, new WebTable.Cell(ToolBox.toString(prefs), true), request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), "") : (request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), "") : new WebTable.Cell("")), request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), "") : new WebTable.Cell(""), note2);
                        } else {
                            row2 = new WebTable.Row(new WebTable.Cell(""), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), new WebTable.Cell(""), new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), new WebTable.Cell(""));
                        }
                    } else if (rc.isFreeTime()) {
                        Object free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!free.isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        if (first) {
                            WebTable.Cell credit = new WebTable.Cell(first && request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                            WebTable.NoteCell note3 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                            note3.setRowSpan(request.getRequestedCourse().size());
                            row2 = new WebTable.Row(new WebTable.Cell(MESSAGES.courseRequestsPriority(priority)), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 2, null), credit, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note3);
                        } else {
                            row2 = new WebTable.Row(new WebTable.Cell(""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 2, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""));
                        }
                    }
                    if (priority > 1 && first) {
                        for (WebTable.Cell cell : row2.getCells()) {
                            cell.setStyleName("top-border-dashed");
                        }
                    }
                    row2.setId("P" + priority);
                    rows.add(row2);
                    first = false;
                }
                ++priority;
                continue;
            }
            WebTable.Cell credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            note = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
            row = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(MESSAGES.courseRequestsPriority(priority)), new WebTable.Cell(""), new WebTable.Cell(""), credit, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note});
            if (priority > 1) {
                for (WebTable.Cell cell : row.getCells()) {
                    cell.setStyleName("top-border-dashed");
                }
            }
            row.setId("P" + priority);
            rows.add(row);
        }
        priority = 1;
        for (CourseRequestInterface.Request request : this.iAdvisorRequests.getAlternatives()) {
            if (request.hasRequestedCourse()) {
                if (request.isCritical() || request.isImportant()) {
                    hasCrit = true;
                }
                boolean first = true;
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    row2 = null;
                    if (rc.isCourse()) {
                        Object prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        if (first) {
                            WebTable.Cell credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
                            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                            WebTable.NoteCell note4 = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
                            note4.setRowSpan(request.getRequestedCourse().size());
                            row2 = new WebTable.Row(new WebTable.Cell(MESSAGES.courseRequestsAlternate(priority)), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), credit, new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), "") : (request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), "") : new WebTable.Cell("")), note4);
                        } else {
                            row2 = new WebTable.Row(new WebTable.Cell(""), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), new WebTable.Cell(""), new WebTable.Cell(ToolBox.toString(prefs), true), new WebTable.Cell(""), new WebTable.Cell(""));
                        }
                    }
                    if (first) {
                        for (WebTable.Cell cell : row2.getCells()) {
                            cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                        }
                    }
                    row2.setId("A" + priority);
                    rows.add(row2);
                    first = false;
                }
                ++priority;
                continue;
            }
            WebTable.Cell credit = new WebTable.Cell(request.hasAdvisorCredit() ? request.getAdvisorCredit() : "");
            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            note = new WebTable.NoteCell(request.hasAdvisorNote() ? request.getAdvisorNote() : "", null);
            row = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(MESSAGES.courseRequestsAlternate(priority)), new WebTable.Cell(""), new WebTable.Cell(""), credit, new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(""), note});
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
            }
            row.setId("A" + priority);
            rows.add(row);
        }
        float min = 0.0f;
        float max = 0.0f;
        for (CourseRequestInterface.Request request : this.iAdvisorRequests.getCourses()) {
            min += request.getAdvisorCreditMin();
            max += request.getAdvisorCreditMax();
        }
        WebTable.Cell credit = new WebTable.Cell(min < max ? MESSAGES.creditRange(min, max) : MESSAGES.credit(min));
        String string = noteMessage = this.iAdvisorRequests.hasCreditNote() ? this.iAdvisorRequests.getCreditNote() : "";
        if (this.iAdvisorRequests.hasReleasedPin() && !noteMessage.contains(this.iAdvisorRequests.getPin())) {
            noteMessage = noteMessage + (noteMessage.isEmpty() ? "" : "\n") + MESSAGES.advisorNotePin(this.iAdvisorRequests.getPin());
        }
        WebTable.NoteCell note5 = new WebTable.NoteCell(noteMessage, null);
        note5.setColSpan(4);
        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        WebTable.Row crow = new WebTable.Row(new WebTable.Cell(MESSAGES.rowTotalPriorityCreditHours(), 2, null), new WebTable.Cell(""), credit, note5);
        for (WebTable.Cell cell : crow.getCells()) {
            cell.setStyleName("top-border-solid");
        }
        crow.getCell(0).setStyleName("top-border-solid text-bold");
        crow.setId("C");
        rows.add(crow);
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row3 : rows) {
            rowArray[idx++] = row3;
        }
        this.setData(rowArray);
        this.setColumnVisible(4, hasPref);
        this.setColumnVisible(5, hasCrit);
        this.setColumnVisible(6, hasWL && (this.iMode == null || this.iMode != OnlineSectioningInterface.WaitListMode.None));
    }

    public CourseRequestInterface getValue() {
        return this.iAdvisorRequests;
    }
}

