/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.MapWidget;
import org.unitime.timetable.gwt.client.rooms.PeriodPreferencesWidget;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomDetail;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomEdit
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private RoomInterface.RoomDetailInterface iRoom = null;
    private RoomInterface.DepartmentInterface iLastControllingDept = null;
    private RoomInterface.DepartmentInterface iLastEventDept = null;
    private Long iLastSelectedDepartmentId = null;
    private UniTimeWidget<ListBox> iType;
    private UniTimeWidget<ListBox> iBuilding;
    private int iBuildingRow;
    private Label iNameLabel;
    private UniTimeWidget<TextBox> iName;
    private TextBox iDisplayName;
    private TextBox iExternalId;
    private UniTimeWidget<NumberBox> iCapacity;
    private UniTimeWidget<NumberBox> iExamCapacity;
    private UniTimeWidget<ListBox> iControllingDepartment;
    private NumberBox iX;
    private NumberBox iY;
    private UniTimeWidget<P> iCoordinates;
    private P iCoordinatesFormat;
    private UniTimeWidget<P> iAreaPanel;
    private NumberBox iArea;
    private P iAreaFormat;
    private CheckBox iDistanceCheck;
    private CheckBox iRoomCheck;
    private MapWidget iMap;
    private ListBox iEventDepartment;
    private UniTimeWidget<ListBox> iEventStatus;
    private P iBreakTimePanel;
    private NumberBox iBreakTime;
    private UniTimeWidget<TextArea> iNote;
    private P iExaminationRoomsPanel;
    private Map<Long, CheckBox> iExaminationRooms = new HashMap<Long, CheckBox>();
    private Map<Long, CheckBox> iGroups = new HashMap<Long, CheckBox>();
    private Map<Long, CheckBox> iFeatures = new HashMap<Long, CheckBox>();
    private P iGlobalGroupsPanel;
    private Map<Long, P> iGroupPanel = new HashMap<Long, P>();
    private UniTimeHeaderPanel iRoomSharingHeader;
    private RoomSharingWidget iRoomSharing;
    private UniTimeHeaderPanel iPeriodPreferencesHeader;
    private int iPeriodPreferencesHeaderRow;
    private Map<Long, PeriodPreferencesWidget> iPeriodPreferences = new HashMap<Long, PeriodPreferencesWidget>();
    private Map<Long, Integer> iPeriodPreferencesRow = new HashMap<Long, Integer>();
    private UniTimeHeaderPanel iEventAvailabilityHeader;
    private RoomSharingWidget iEventAvailability;
    private UniTimeHeaderPanel iPicturesHeader;
    private UniTimeFileUpload iFileUpload;
    private UniTimeTable<RoomInterface.RoomPictureInterface> iPictures;
    private UniTimeHeaderPanel iApplyToHeader;
    private UniTimeTable<RoomInterface.FutureRoomInterface> iApplyTo;
    private RoomInterface.RoomsPageMode iMode = null;
    private Map<Long, CheckBox> iServices = new HashMap<Long, CheckBox>();
    private P iServicesPanel;
    private int iServicesRow;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public RoomEdit(RoomInterface.RoomsPageMode mode) {
        this.iMode = mode;
        this.iHeader = new UniTimeHeaderPanel();
        ClickHandler clickCreateOrUpdate = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!RoomEdit.this.validate()) {
                    RoomEdit.this.iHeader.setErrorMessage(MESSAGES.failedValidationCheckForm());
                    UniTimeNotifications.error(MESSAGES.failedValidationCheckForm());
                } else {
                    RoomInterface.RoomUpdateRpcRequest request = RoomInterface.RoomUpdateRpcRequest.createSaveOrUpdateRequest(RoomEdit.this.getRoom());
                    String future = RoomEdit.this.generateAlsoUpdateMessage(false);
                    if (future != null) {
                        if (Window.confirm((String)(RoomEdit.this.getRoom().getUniqueId() == null ? MESSAGES.confirmCreateRoomInFutureSessions(future) : MESSAGES.confirmUpdateRoomInFutureSessions(future)))) {
                            RoomEdit.this.fillFutureFlags(request, false);
                        } else {
                            return;
                        }
                    }
                    LoadingWidget.getInstance().show(RoomEdit.this.getRoom().getUniqueId() == null ? MESSAGES.waitSavingRoom() : MESSAGES.waitUpdatingRoom());
                    RPC.execute(request, new AsyncCallback<RoomInterface.RoomDetailInterface>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            String message = null;
                            RoomInterface.RoomDetailInterface result = null;
                            if (caught instanceof RoomInterface.RoomException) {
                                message = caught.getMessage();
                                result = ((RoomInterface.RoomException)caught).getRoom();
                            } else {
                                message = RoomEdit.this.getRoom().getUniqueId() == null ? MESSAGES.errorFailedToSaveRoom(caught.getMessage()) : MESSAGES.errorFailedToUpdateRoom(caught.getMessage());
                            }
                            RoomEdit.this.iHeader.setErrorMessage(message);
                            UniTimeNotifications.error(message);
                            if (result != null) {
                                RoomEdit.this.hide(result, true, message);
                            }
                        }

                        public void onSuccess(RoomInterface.RoomDetailInterface result) {
                            LoadingWidget.getInstance().hide();
                            RoomEdit.this.hide(result, true, null);
                        }
                    });
                }
            }
        };
        this.iHeader.addButton("create", MESSAGES.buttonCreateRoom(), 100, clickCreateOrUpdate);
        this.iHeader.addButton("update", MESSAGES.buttonUpdateRoom(), 100, clickCreateOrUpdate);
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteRoom(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomInterface.RoomUpdateRpcRequest request = RoomInterface.RoomUpdateRpcRequest.createDeleteRequest(RoomEdit.this.getRoom().getSessionId(), RoomEdit.this.getRoom().getUniqueId());
                String future = RoomEdit.this.generateAlsoUpdateMessage(true);
                if (Window.confirm((String)(future == null ? MESSAGES.confirmDeleteRoom() : MESSAGES.confirmDeleteRoomInFutureSessions(future)))) {
                    if (future != null) {
                        RoomEdit.this.fillFutureFlags(request, true);
                    }
                } else {
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.waitDeletingRoom());
                RPC.execute(request, new AsyncCallback<RoomInterface.RoomDetailInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        String message = null;
                        RoomInterface.RoomDetailInterface result = null;
                        if (caught instanceof RoomInterface.RoomException) {
                            message = caught.getMessage();
                            result = ((RoomInterface.RoomException)caught).getRoom();
                        } else {
                            message = MESSAGES.errorFailedToDeleteRoom(caught.getMessage());
                        }
                        RoomEdit.this.iHeader.setErrorMessage(message);
                        UniTimeNotifications.error(message);
                        if (result != null) {
                            RoomEdit.this.hide(result, true, message);
                        }
                    }

                    public void onSuccess(RoomInterface.RoomDetailInterface result) {
                        LoadingWidget.getInstance().hide();
                        RoomEdit.this.hide(null, false, null);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomEdit.this.hide(null, true, null);
            }
        });
        this.iForm = new SimpleForm(2);
        this.iForm.addStyleName("unitime-RoomEdit");
        this.iType = new UniTimeWidget<ListBox>(new ListBox());
        this.iType.getWidget().setStyleName("unitime-TextBox");
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.typeChanged();
                RoomEdit.this.iType.clearHint();
                RoomEdit.this.iHeader.clearMessage();
            }
        });
        this.iBuilding = new UniTimeWidget<ListBox>(new ListBox());
        this.iBuilding.getWidget().setStyleName("unitime-TextBox");
        this.iBuilding.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.buildingChanged();
                RoomEdit.this.iBuilding.clearHint();
                RoomEdit.this.iHeader.clearMessage();
            }
        });
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(40);
        this.iName.getWidget().setWidth("300px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.iName.clearHint();
                RoomEdit.this.iHeader.clearMessage();
            }
        });
        this.iNameLabel = new Label(MESSAGES.propRoomName());
        this.iDisplayName = new TextBox();
        this.iDisplayName.setStyleName("unitime-TextBox");
        this.iDisplayName.setMaxLength(100);
        this.iDisplayName.setWidth("480px");
        this.iExternalId = new TextBox();
        this.iExternalId.setStyleName("unitime-TextBox");
        this.iExternalId.setMaxLength(40);
        this.iExternalId.setWidth("300px");
        this.iCapacity = new UniTimeWidget<NumberBox>(new NumberBox());
        this.iCapacity.getWidget().setDecimal(false);
        this.iCapacity.getWidget().setNegative(false);
        this.iCapacity.getWidget().setMaxLength(6);
        this.iCapacity.getWidget().setWidth("80px");
        this.iCapacity.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.iCapacity.clearHint();
                RoomEdit.this.iHeader.clearMessage();
            }
        });
        this.iControllingDepartment = new UniTimeWidget<ListBox>(new ListBox());
        this.iControllingDepartment.getWidget().setStyleName("unitime-TextBox");
        this.iX = new NumberBox();
        this.iX.setMaxLength(12);
        this.iX.setWidth("80px");
        this.iX.setDecimal(true);
        this.iX.setNegative(true);
        this.iX.addStyleName("number");
        this.iY = new NumberBox();
        this.iY.setMaxLength(12);
        this.iY.setWidth("80px");
        this.iY.setDecimal(true);
        this.iY.setNegative(true);
        this.iY.addStyleName("number");
        this.iX.getElement().setId("coordX");
        this.iY.getElement().setId("coordY");
        this.iCoordinates = new UniTimeWidget<P>(new P("coordinates"));
        this.iCoordinates.getWidget().add((Widget)this.iX);
        P comma = new P("comma");
        comma.setText(", ");
        this.iCoordinates.getWidget().add((Widget)comma);
        this.iCoordinates.getWidget().add((Widget)this.iY);
        this.iCoordinatesFormat = new P("format");
        this.iCoordinates.getWidget().add((Widget)this.iCoordinatesFormat);
        this.iArea = new NumberBox();
        this.iArea.setDecimal(true);
        this.iArea.setNegative(false);
        this.iArea.addStyleName("number");
        this.iArea.setWidth("80px");
        this.iArea.setMaxLength(12);
        this.iAreaPanel = new UniTimeWidget<P>(new P("area"));
        this.iAreaPanel.getWidget().add((Widget)this.iArea);
        this.iAreaFormat = new P("format");
        this.iAreaFormat.setText(this.iProperties != null && this.iProperties.isRoomAreaInMetricUnits() ? CONSTANTS.roomAreaMetricUnitsLong() : CONSTANTS.roomAreaUnitsLong());
        this.iAreaPanel.getWidget().add((Widget)this.iAreaFormat);
        this.iDistanceCheck = new CheckBox();
        this.iDistanceCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomEdit.this.distanceCheckChanged();
            }
        });
        this.iRoomCheck = new CheckBox();
        this.iRoomCheck.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomEdit.this.roomCheckChanged();
            }
        });
        this.iExaminationRoomsPanel = new P("exams");
        this.iExaminationRoomsPanel.setWidth("100%");
        this.iExamCapacity = new UniTimeWidget<NumberBox>(new NumberBox());
        this.iExamCapacity.getWidget().setDecimal(false);
        this.iExamCapacity.getWidget().setNegative(false);
        this.iExamCapacity.getWidget().setMaxLength(6);
        this.iExamCapacity.getWidget().setWidth("80px");
        this.iExamCapacity.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.iExamCapacity.clearHint();
                RoomEdit.this.iHeader.clearMessage();
            }
        });
        this.iEventDepartment = new ListBox();
        this.iEventDepartment.setStyleName("unitime-TextBox");
        this.iEventDepartment.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.iEventAvailabilityHeader.setVisible(RoomEdit.this.isEventRoom());
                RoomEdit.this.iEventAvailability.setVisible(RoomEdit.this.isEventRoom());
                if (RoomEdit.this.iProperties != null && RoomEdit.this.iProperties.hasEventServiceProviders()) {
                    Long deptId = Long.valueOf(RoomEdit.this.iEventDepartment.getValue(RoomEdit.this.iEventDepartment.getSelectedIndex()));
                    for (EventInterface.EventServiceProviderInterface service : RoomEdit.this.iProperties.getEventServiceProviders()) {
                        if (service.getDepartmentId() == null) continue;
                        ((CheckBox)RoomEdit.this.iServices.get(service.getId())).setVisible(service.getDepartmentId().equals(deptId));
                    }
                    RoomEdit.this.iForm.getRowFormatter().setVisible(RoomEdit.this.iServicesRow, deptId >= 0L);
                }
            }
        });
        this.iEventStatus = new UniTimeWidget<ListBox>(new ListBox());
        this.iEventStatus.getWidget().setStyleName("unitime-TextBox");
        this.iEventStatus.getWidget().addItem(MESSAGES.itemDefault(), "-1");
        for (int i = 0; i < CONSTANTS.eventStatusName().length; ++i) {
            this.iEventStatus.getWidget().addItem(CONSTANTS.eventStatusName()[i], String.valueOf(i));
        }
        this.iNote = new UniTimeWidget<TextArea>(new TextArea());
        this.iNote.getWidget().setStyleName("unitime-TextArea");
        this.iNote.getWidget().setVisibleLines(5);
        this.iNote.getWidget().setCharacterWidth(70);
        this.iBreakTime = new NumberBox();
        this.iBreakTime.setDecimal(false);
        this.iBreakTime.setNegative(false);
        this.iBreakTime.addStyleName("number");
        this.iBreakTime.setWidth("80px");
        this.iBreakTime.setMaxLength(12);
        this.iBreakTimePanel = new P("breaktime");
        this.iBreakTimePanel.add((Widget)this.iBreakTime);
        P f = new P("note");
        f.setText(MESSAGES.useDefaultBreakTimeWhenEmpty());
        this.iBreakTimePanel.add((Widget)f);
        this.iServicesPanel = new P("services");
        this.iServicesPanel.setWidth("100%");
        this.iRoomSharingHeader = new UniTimeHeaderPanel(MESSAGES.headerRoomSharing());
        this.iRoomSharing = new RoomSharingWidget(true, true);
        this.iRoomSharing.addValueChangeHandler(new ValueChangeHandler<RoomInterface.RoomSharingModel>(){

            public void onValueChange(ValueChangeEvent<RoomInterface.RoomSharingModel> event) {
                RoomEdit.this.iRoomSharingHeader.clearMessage();
            }
        });
        this.iControllingDepartment.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomEdit.this.iControllingDepartment.clearHint();
                if (RoomEdit.this.iRoom.getDepartment(RoomEdit.this.iLastSelectedDepartmentId) == null) {
                    RoomEdit.this.iRoomSharing.removeOption(RoomEdit.this.iLastSelectedDepartmentId);
                }
                RoomEdit.this.iLastSelectedDepartmentId = Long.valueOf(((ListBox)RoomEdit.this.iControllingDepartment.getWidget()).getValue(((ListBox)RoomEdit.this.iControllingDepartment.getWidget()).getSelectedIndex()));
                if (RoomEdit.this.iLastSelectedDepartmentId > 0L) {
                    RoomEdit.this.iRoomSharing.addOption(RoomEdit.this.iLastSelectedDepartmentId);
                }
            }
        });
        this.iPeriodPreferencesHeader = new UniTimeHeaderPanel(MESSAGES.headerExaminationPeriodPreferences());
        this.iEventAvailabilityHeader = new UniTimeHeaderPanel(MESSAGES.headerEventAvailability());
        this.iEventAvailability = new RoomSharingWidget(true);
        this.iPicturesHeader = new UniTimeHeaderPanel(MESSAGES.headerRoomPictures());
        this.iPictures = new UniTimeTable();
        this.iPictures.setStyleName("unitime-RoomPictures");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colPicture()));
        header.add(new UniTimeTableHeader(MESSAGES.colName()));
        header.add(new UniTimeTableHeader(MESSAGES.colContentType()));
        header.add(new UniTimeTableHeader(MESSAGES.colPictureType()));
        header.add(new UniTimeTableHeader("&nbsp;"));
        this.iPictures.addRow(null, header);
        this.iFileUpload = new UniTimeFileUpload();
        this.iFileUpload.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                RPC.execute(RoomInterface.RoomPictureRequest.upload(RoomEdit.this.iRoom.getSessionId(), RoomEdit.this.iRoom.getUniqueId()), new AsyncCallback<RoomInterface.RoomPictureResponse>(){

                    public void onFailure(Throwable caught) {
                        RoomEdit.this.iHeader.setErrorMessage(MESSAGES.failedToUploadRoomPicture(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.RoomPictureResponse result) {
                        if (result.hasPictures()) {
                            for (RoomInterface.RoomPictureInterface picture : result.getPictures()) {
                                for (int row = 1; row < RoomEdit.this.iPictures.getRowCount(); ++row) {
                                    if (!picture.getName().equals(((RoomInterface.RoomPictureInterface)RoomEdit.this.iPictures.getData(row)).getName())) continue;
                                    RoomEdit.this.iPictures.removeRow(row);
                                    break;
                                }
                                RoomEdit.this.iPictures.addRow(picture, RoomEdit.this.line(picture));
                            }
                            RoomEdit.this.iFileUpload.reset();
                        }
                    }
                });
            }
        });
        this.iApplyToHeader = new UniTimeHeaderPanel(MESSAGES.headerRoomApplyToFutureRooms());
        this.iApplyToHeader.setTitleStyleName("update-options");
        this.iApplyTo = new UniTimeTable();
        this.iApplyTo.setStyleName("unitime-RoomApplyTo");
        ArrayList<UniTimeTableHeader> ah = new ArrayList<UniTimeTableHeader>();
        ah.add(new UniTimeTableHeader("&nbsp;"));
        ah.add(new UniTimeTableHeader(MESSAGES.colName()));
        ah.add(new UniTimeTableHeader(MESSAGES.colExternalId()));
        ah.add(new UniTimeTableHeader(MESSAGES.colType()));
        ah.add(new UniTimeTableHeader(MESSAGES.colCapacity()));
        ah.add(new UniTimeTableHeader(MESSAGES.colSession()));
        for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
            ah.add(new UniTimeTableHeader(this.getFutureOperationLabel(op)));
        }
        this.iApplyTo.addRow(null, ah);
        this.iFooter = this.iHeader.clonePanel();
        this.initWidget((Widget)this.iForm);
    }

    protected boolean isEventRoom() {
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventProperties() || this.iRoom.isCanChangeEventProperties()) {
            return !"-1".equals(this.iEventDepartment.getValue(this.iEventDepartment.getSelectedIndex()));
        }
        return this.iRoom.getEventDepartment() != null;
    }

    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        CheckBox ch;
        this.iProperties = properties;
        this.iForm.setColSpan(this.iProperties.isGoogleMap() || this.iProperties.isLeafletMap() ? 3 : 2);
        this.iBuilding.getWidget().clear();
        this.iBuilding.getWidget().addItem(MESSAGES.itemSelect(), "-1");
        for (RoomInterface.BuildingInterface buildingInterface : this.iProperties.getBuildings()) {
            this.iBuilding.getWidget().addItem(buildingInterface.getAbbreviation() + " - " + buildingInterface.getName(), buildingInterface.getId().toString());
        }
        this.iCoordinatesFormat.setText(this.iProperties.getEllipsoid());
        this.iExaminationRooms.clear();
        this.iExaminationRoomsPanel.clear();
        for (final RoomInterface.ExamTypeInterface examTypeInterface : this.iProperties.getExamTypes()) {
            ch = new CheckBox(examTypeInterface.getLabel());
            ch.addStyleName("exam");
            this.iExaminationRooms.put(examTypeInterface.getId(), ch);
            this.iExaminationRoomsPanel.add((Widget)ch);
            ch.setValue(Boolean.valueOf(false));
            ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    Integer row = (Integer)RoomEdit.this.iPeriodPreferencesRow.get(examTypeInterface.getId());
                    if (row != null) {
                        PeriodPreferencesWidget pref = (PeriodPreferencesWidget)RoomEdit.this.iPeriodPreferences.get(examTypeInterface.getId());
                        RoomEdit.this.iForm.getRowFormatter().setVisible(row.intValue(), (Boolean)event.getValue() != false && pref != null && pref.getModel() != null && !pref.getModel().getPeriods().isEmpty());
                    }
                    boolean prefVisible = false;
                    for (RoomInterface.ExamTypeInterface t : RoomEdit.this.iProperties.getExamTypes()) {
                        PeriodPreferencesWidget pref;
                        if (!((CheckBox)RoomEdit.this.iExaminationRooms.get(t.getId())).getValue().booleanValue() || (pref = (PeriodPreferencesWidget)RoomEdit.this.iPeriodPreferences.get(t.getId())) == null || pref.getModel() == null || pref.getModel().getPeriods().isEmpty()) continue;
                        prefVisible = true;
                        break;
                    }
                    if (RoomEdit.this.iPeriodPreferencesHeaderRow > 0) {
                        RoomEdit.this.iForm.getRowFormatter().setVisible(RoomEdit.this.iPeriodPreferencesHeaderRow, prefVisible);
                    }
                    if (!((Boolean)event.getValue()).booleanValue()) {
                        RoomEdit.this.iExamCapacity.clearHint();
                        RoomEdit.this.iHeader.clearMessage();
                    }
                }
            });
        }
        this.iServices.clear();
        this.iServicesPanel.clear();
        if (this.iProperties.hasEventServiceProviders()) {
            for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : this.iProperties.getEventServiceProviders()) {
                ch = new CheckBox(eventServiceProviderInterface.getLabel() + (eventServiceProviderInterface.getDepartmentId() == null ? "" : " (" + MESSAGES.serviceProviderDepartmental() + ")"));
                if (eventServiceProviderInterface.hasMessage()) {
                    ch.setTitle(eventServiceProviderInterface.getMessage());
                }
                ch.addStyleName("service");
                this.iServices.put(eventServiceProviderInterface.getId(), ch);
                this.iServicesPanel.add((Widget)ch);
                ch.setValue(Boolean.valueOf(false));
                if (eventServiceProviderInterface.getDepartmentId() == null) continue;
                ch.setVisible(false);
            }
        }
        if (this.iMap == null) {
            this.iMap = MapWidget.createMap(this.iX, this.iY, this.iProperties);
        }
        this.iGroups.clear();
        this.iGroupPanel.clear();
        this.iGlobalGroupsPanel = null;
        if (!this.iProperties.getGroups().isEmpty()) {
            P groups = new P("groups");
            for (RoomInterface.GroupInterface group : this.iProperties.getGroups()) {
                CheckBox ch2 = new CheckBox(group.getLabel());
                ch2.addStyleName("group");
                this.iGroups.put(group.getId(), ch2);
                if (group.getDepartment() != null) {
                    P d = this.iGroupPanel.get(group.getDepartment().getId());
                    if (d == null) {
                        d = new P("groups");
                        d.setWidth("100%");
                        this.iGroupPanel.put(group.getDepartment().getId(), d);
                    }
                    d.add((Widget)ch2);
                    continue;
                }
                groups.add((Widget)ch2);
            }
            if (groups.getWidgetCount() > 0) {
                this.iGlobalGroupsPanel = groups;
            }
        }
        this.iFeatures.clear();
        if (!this.iProperties.getFeatures().isEmpty()) {
            for (RoomInterface.FeatureInterface featureInterface : this.iProperties.getFeatures()) {
                ch = new CheckBox(featureInterface.getTitle());
                ch.addStyleName("feature");
                this.iFeatures.put(featureInterface.getId(), ch);
            }
        }
        this.iPeriodPreferences.clear();
        for (RoomInterface.ExamTypeInterface examTypeInterface : this.iProperties.getExamTypes()) {
            PeriodPreferencesWidget pref = new PeriodPreferencesWidget(true);
            this.iPeriodPreferences.put(examTypeInterface.getId(), pref);
        }
    }

    public void setRoom(RoomInterface.RoomDetailInterface room) {
        this.iRoom = room;
        if (this.iRoom == null) {
            this.iRoom = new RoomInterface.RoomDetailInterface();
            this.iRoom.setSessionId(this.iProperties.getAcademicSessionId());
            this.iRoom.setSessionName(this.iProperties.getAcademicSessionName());
            this.iHeader.setEnabled("create", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
        } else {
            this.iHeader.setEnabled("create", false);
            this.iHeader.setEnabled("update", true);
            this.iHeader.setEnabled("delete", this.iRoom.isCanDelete());
        }
        this.iLastControllingDept = this.iRoom.getControlDepartment();
        this.iLastEventDept = this.iRoom.getEventDepartment();
        this.iForm.clear();
        this.iHeader.clearMessage();
        this.iForm.addHeaderRow((Widget)this.iHeader);
        int firstRow = this.iForm.getRowCount();
        if (this.iMode.hasSessionSelection()) {
            this.iForm.addRow(MESSAGES.propAcademicSession(), (Widget)new Label(this.iRoom.hasSessionName() ? this.iRoom.getSessionName() : this.iProperties.getAcademicSessionName()), 1);
        }
        if (this.iRoom.getRoomType() == null || this.iRoom.isCanChangeType()) {
            this.iType.clearHint();
            this.iType.getWidget().clear();
            if (this.iRoom.getRoomType() == null) {
                this.iType.getWidget().addItem(MESSAGES.itemSelect(), "-1");
                for (RoomInterface.RoomTypeInterface roomTypeInterface : this.iProperties.getRoomTypes()) {
                    if (roomTypeInterface.isRoom() && this.iProperties.isCanAddRoom()) {
                        this.iType.getWidget().addItem(roomTypeInterface.getLabel(), roomTypeInterface.getId().toString());
                        continue;
                    }
                    if (roomTypeInterface.isRoom() || !this.iProperties.isCanAddNonUniversity()) continue;
                    this.iType.getWidget().addItem(roomTypeInterface.getLabel(), roomTypeInterface.getId().toString());
                }
                this.iType.getWidget().setSelectedIndex(0);
            } else {
                for (RoomInterface.RoomTypeInterface roomTypeInterface : this.iProperties.getRoomTypes()) {
                    if (roomTypeInterface.isRoom() && this.iRoom.getBuilding() != null) {
                        this.iType.getWidget().addItem(roomTypeInterface.getLabel(), roomTypeInterface.getId().toString());
                        continue;
                    }
                    if (roomTypeInterface.isRoom() || this.iRoom.getBuilding() != null) continue;
                    this.iType.getWidget().addItem(roomTypeInterface.getLabel(), roomTypeInterface.getId().toString());
                }
                for (int i = 0; i < this.iType.getWidget().getItemCount(); ++i) {
                    if (!this.iType.getWidget().getValue(i).equals(this.iRoom.getRoomType().getId().toString())) continue;
                    this.iType.getWidget().setSelectedIndex(i);
                    break;
                }
            }
            this.iForm.addRow(MESSAGES.propRoomType(), (Widget)this.iType, 1);
        } else {
            this.iForm.addRow(MESSAGES.propRoomType(), (Widget)new Label(this.iRoom.getRoomType().getLabel(), false), 1);
        }
        if (this.iRoom.getUniqueId() != null && this.iRoom.getBuilding() == null) {
            this.iBuildingRow = -1;
        } else if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeRoomProperties()) {
            this.iBuilding.clearHint();
            if (this.iRoom.getBuilding() == null) {
                this.iBuilding.getWidget().setSelectedIndex(0);
            } else {
                this.iBuilding.getWidget().setSelectedIndex(1 + this.iProperties.getBuildings().indexOf(this.iRoom.getBuilding()));
            }
            this.iBuildingRow = this.iForm.addRow(MESSAGES.propBuilding(), (Widget)this.iBuilding, 1);
        } else {
            this.iBuildingRow = this.iForm.addRow(MESSAGES.propBuilding(), (Widget)new Label(this.iRoom.getBuilding().getAbbreviation() + " - " + this.iRoom.getBuilding().getName()), 1);
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeRoomProperties()) {
            this.iName.clearHint();
            this.iName.getWidget().setText(this.iRoom.getName() == null ? "" : this.iRoom.getName());
            this.iForm.addRow((Widget)this.iNameLabel, (Widget)this.iName, 1);
        } else {
            this.iForm.addRow((Widget)this.iNameLabel, (Widget)new Label(this.iRoom.getName()), 1);
        }
        if (this.iRoom.getRoomType() == null || this.iRoom.isCanChangeType()) {
            this.typeChanged();
        } else {
            if (this.iBuildingRow >= 0) {
                this.iForm.getRowFormatter().setVisible(this.iBuildingRow, this.iRoom.getRoomType() != null && this.iRoom.getRoomType().isRoom());
            }
            this.iNameLabel.setText(this.iRoom.getRoomType() != null && this.iRoom.getRoomType().isRoom() ? MESSAGES.propRoomNumber() : MESSAGES.propRoomName());
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeRoomProperties()) {
            this.iDisplayName.setText(this.iRoom.getDisplayName() == null ? "" : this.iRoom.getDisplayName());
            this.iForm.addRow(MESSAGES.propDisplayName(), (Widget)this.iDisplayName, 1);
        } else if (this.iRoom.hasDisplayName()) {
            this.iForm.addRow(MESSAGES.propDisplayName(), (Widget)new Label(this.iRoom.getDisplayName()), 1);
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeExternalId() || this.iRoom.isCanChangeExternalId()) {
            this.iExternalId.setText(this.iRoom.getExternalId() == null ? "" : this.iRoom.getExternalId());
            this.iForm.addRow(MESSAGES.propExternalId(), (Widget)this.iExternalId, 1);
        } else if (this.iRoom.hasExternalId()) {
            this.iForm.addRow(MESSAGES.propExternalId(), (Widget)new Label(this.iRoom.getExternalId()), 1);
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeCapacity()) {
            this.iCapacity.clearHint();
            this.iCapacity.getWidget().setValue(this.iRoom.getCapacity());
            this.iForm.addRow(MESSAGES.propCapacity(), (Widget)this.iCapacity, 1);
        } else if (this.iRoom.getCapacity() != null) {
            this.iForm.addRow(MESSAGES.propCapacity(), (Widget)new Label(this.iRoom.getCapacity().toString()), 1);
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeControll() || this.iRoom.isCanChangeControll()) {
            this.iControllingDepartment.clearHint();
            this.iControllingDepartment.getWidget().clear();
            this.iControllingDepartment.getWidget().addItem(MESSAGES.itemNoControlDepartment(), "-1");
            for (RoomInterface.DepartmentInterface departmentInterface : this.iProperties.getDepartments()) {
                this.iControllingDepartment.getWidget().addItem(departmentInterface.getExtAbbreviationOrCode() + " - " + departmentInterface.getExtLabelWhenExist(), departmentInterface.getId().toString());
            }
            if (this.iRoom.getControlDepartment() == null) {
                this.iControllingDepartment.getWidget().setSelectedIndex(0);
            } else {
                int index = this.iProperties.getDepartments().indexOf(this.iRoom.getControlDepartment());
                if (index >= 0) {
                    this.iControllingDepartment.getWidget().setSelectedIndex(1 + index);
                } else {
                    this.iControllingDepartment.getWidget().addItem(this.iRoom.getControlDepartment().getExtAbbreviationOrCode() + " - " + this.iRoom.getControlDepartment().getExtLabelWhenExist(), this.iRoom.getControlDepartment().getId().toString());
                    this.iControllingDepartment.getWidget().setSelectedIndex(this.iControllingDepartment.getWidget().getItemCount() - 1);
                }
            }
            if (this.iRoom.getUniqueId() == null && this.iControllingDepartment.getWidget().getItemCount() == 2) {
                this.iControllingDepartment.getWidget().setSelectedIndex(1);
            }
            this.iForm.addRow(MESSAGES.propControllingDepartment(), (Widget)this.iControllingDepartment, 1);
        } else if (this.iRoom.getControlDepartment() != null && this.iProperties.isCanSeeCourses()) {
            this.iForm.addRow(MESSAGES.propControllingDepartment(), (Widget)new Label(RoomDetail.toString(this.iRoom.getControlDepartment())), 1);
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeRoomProperties()) {
            this.iX.setValue(this.iRoom.getX());
            this.iY.setValue(this.iRoom.getY());
            this.iForm.addRow(MESSAGES.propCoordinates(), (Widget)this.iCoordinates, 1);
            this.iArea.setValue(this.iRoom.getArea());
            this.iAreaFormat.setText(this.iProperties != null && this.iProperties.isRoomAreaInMetricUnits() ? CONSTANTS.roomAreaMetricUnitsLong() : CONSTANTS.roomAreaUnitsLong());
            this.iForm.addRow(MESSAGES.propRoomArea(), (Widget)this.iAreaPanel, 1);
            if (this.iProperties.isCanSeeCourses()) {
                this.iDistanceCheck.setValue(Boolean.valueOf(!this.iRoom.isIgnoreTooFar()));
                this.distanceCheckChanged();
                this.iForm.addRow(MESSAGES.propDistanceCheck(), (Widget)this.iDistanceCheck, 1);
            }
            this.iRoomCheck.setValue(Boolean.valueOf(!this.iRoom.isIgnoreRoomCheck()));
            this.roomCheckChanged();
            this.iForm.addRow(MESSAGES.propRoomCheck(), (Widget)this.iRoomCheck, 1);
            if (this.iMap != null) {
                this.iMap.setEnabled(true);
            }
        } else {
            if (this.iRoom.hasCoordinates()) {
                P coordinates = new P("coordinates");
                if (this.iProperties != null && this.iProperties.hasEllipsoid()) {
                    coordinates.add((Widget)new HTML(MESSAGES.coordinatesWithEllipsoid(this.iRoom.getX(), this.iRoom.getY(), this.iProperties.getEllipsoid())));
                } else {
                    coordinates.add((Widget)new HTML(MESSAGES.coordinates(this.iRoom.getX(), this.iRoom.getY())));
                }
                Hidden hidden = new Hidden();
                hidden.getElement().setId("coordX");
                hidden.setValue(this.iRoom.getX() == null ? "" : this.iRoom.getX().toString());
                Hidden y = new Hidden();
                y.getElement().setId("coordY");
                y.setValue(this.iRoom.getY() == null ? "" : this.iRoom.getY().toString());
                coordinates.add((Widget)hidden);
                coordinates.add((Widget)y);
                this.iForm.addRow(MESSAGES.propCoordinates(), (Widget)coordinates, 1);
            }
            if (this.iRoom.getArea() != null) {
                this.iForm.addRow(MESSAGES.propRoomArea(), (Widget)new HTML(MESSAGES.roomArea(this.iRoom.getArea()) + " " + (this.iProperties != null && this.iProperties.isRoomAreaInMetricUnits() ? CONSTANTS.roomAreaMetricUnitsShort() : CONSTANTS.roomAreaUnitsShort())), 1);
            }
            if (this.iProperties.isCanSeeCourses()) {
                this.iForm.addRow(MESSAGES.propDistanceCheck(), (Widget)new RoomDetail.Check(!room.isIgnoreTooFar(), MESSAGES.infoDistanceCheckOn(), MESSAGES.infoDistanceCheckOff()), 1);
                this.iForm.addRow(MESSAGES.propRoomCheck(), (Widget)new RoomDetail.Check(!room.isIgnoreRoomCheck(), MESSAGES.infoRoomCheckOn(), MESSAGES.infoRoomCheckOff()), 1);
            } else if (this.iProperties.isCanSeeEvents()) {
                this.iForm.addRow(MESSAGES.propRoomCheck(), (Widget)new RoomDetail.Check(!room.isIgnoreRoomCheck(), MESSAGES.infoRoomCheckOn(), MESSAGES.infoRoomCheckOff()), 1);
            }
            if (this.iMap != null) {
                this.iMap.setEnabled(false);
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeExamStatus() || this.iRoom.isCanChangeExamStatus()) {
            for (Map.Entry<Long, CheckBox> entry : this.iExaminationRooms.entrySet()) {
                entry.getValue().setValue(Boolean.valueOf(false));
            }
            if (this.iRoom.hasExamTypes()) {
                for (RoomInterface.ExamTypeInterface examTypeInterface : this.iRoom.getExamTypes()) {
                    this.iExaminationRooms.get(examTypeInterface.getId()).setValue(Boolean.valueOf(true));
                }
            }
            this.iForm.addRow(MESSAGES.propExamRooms(), (Widget)this.iExaminationRoomsPanel, 1);
            this.iExamCapacity.getWidget().setValue(this.iRoom.getExamCapacity());
            this.iForm.addRow(MESSAGES.propExamCapacity(), (Widget)this.iExamCapacity, 1);
        } else if (this.iProperties.isCanSeeExams() && (this.iRoom.getExamCapacity() != null || this.iRoom.hasExamTypes())) {
            this.iForm.addRow(MESSAGES.propExamCapacity(), (Widget)new RoomDetail.ExamSeatingCapacityLabel(this.iRoom), 1);
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventProperties() || this.iRoom.isCanChangeEventProperties()) {
            this.iEventDepartment.clear();
            if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeControll() || this.iRoom.getUniqueId() != null && (this.iRoom.getEventDepartment() == null || this.iRoom.isCanChangeControll())) {
                this.iEventDepartment.addItem(MESSAGES.itemNoEventDepartment(), "-1");
            }
            for (RoomInterface.DepartmentInterface departmentInterface : this.iProperties.getDepartments()) {
                if (!departmentInterface.isEvent()) continue;
                this.iEventDepartment.addItem(departmentInterface.getDeptCode() + " - " + departmentInterface.getLabel(), departmentInterface.getId().toString());
            }
            if (this.iRoom.getEventDepartment() == null) {
                this.iEventDepartment.setSelectedIndex(0);
            } else {
                this.iEventDepartment.setSelectedIndex(0);
                for (int i = 1; i < this.iEventDepartment.getItemCount(); ++i) {
                    if (!this.iEventDepartment.getValue(i).equals(this.iRoom.getEventDepartment().getId().toString())) continue;
                    this.iEventDepartment.setSelectedIndex(i);
                    break;
                }
                if (this.iRoom.getEventDepartment() != null && "-1".equals(this.iEventDepartment.getValue(this.iEventDepartment.getSelectedIndex()))) {
                    this.iEventDepartment.addItem(this.iRoom.getEventDepartment().getDeptCode() + " - " + this.iRoom.getEventDepartment().getLabel(), this.iRoom.getEventDepartment().getId().toString());
                    this.iEventDepartment.setSelectedIndex(this.iEventDepartment.getItemCount() + -1);
                }
            }
            this.iForm.addRow(MESSAGES.propEventDepartment(), (Widget)this.iEventDepartment, 1);
            this.iEventStatus.getWidget().setSelectedIndex(this.iRoom.getEventStatus() == null ? 0 : this.iRoom.getEventStatus() + 1);
            this.iEventStatus.clearHint();
            this.iForm.addRow(MESSAGES.propEventStatus(), (Widget)this.iEventStatus, 1);
            this.iNote.getWidget().setText(this.iRoom.getEventNote() == null ? "" : this.iRoom.getEventNote());
            this.iForm.addRow(MESSAGES.propEventNote(), (Widget)this.iNote, 1);
            this.iBreakTime.setValue(this.iRoom.getBreakTime());
            this.iForm.addRow(MESSAGES.propBreakTime(), (Widget)this.iBreakTimePanel, 1);
            for (Map.Entry<Long, CheckBox> entry : this.iServices.entrySet()) {
                entry.getValue().setValue(Boolean.valueOf(false));
            }
            if (this.iRoom.hasServices()) {
                for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : this.iRoom.getServices()) {
                    this.iServices.get(eventServiceProviderInterface.getId()).setValue(Boolean.valueOf(true));
                }
            }
            if (this.iProperties.hasEventServiceProviders()) {
                Long deptId = Long.valueOf(this.iEventDepartment.getValue(this.iEventDepartment.getSelectedIndex()));
                for (EventInterface.EventServiceProviderInterface service : this.iProperties.getEventServiceProviders()) {
                    if (service.getDepartmentId() == null) continue;
                    this.iServices.get(service.getId()).setVisible(service.getDepartmentId().equals(deptId));
                }
                this.iServicesRow = this.iForm.addRow(MESSAGES.propAvailableServices(), (Widget)this.iServicesPanel, 1);
                this.iForm.getRowFormatter().setVisible(this.iServicesRow, deptId >= 0L);
            }
        } else if (this.iProperties.isCanSeeEvents()) {
            if (this.iRoom.getEventDepartment() != null) {
                this.iForm.addRow(MESSAGES.propEventDepartment(), (Widget)new Label(RoomDetail.toString(this.iRoom.getEventDepartment(), true)), 1);
            }
            if (this.iRoom.getEventStatus() != null || this.iRoom.getDefaultEventStatus() != null) {
                Label status = new Label(CONSTANTS.eventStatusName()[this.iRoom.getEventStatus() == null ? this.iRoom.getDefaultEventStatus() : this.iRoom.getEventStatus()]);
                if (this.iRoom.getEventStatus() == null) {
                    status.addStyleName("default");
                }
                this.iForm.addRow(MESSAGES.propEventStatus(), (Widget)status, 1);
            }
            if (this.iRoom.hasEventNote() || this.iRoom.hasDefaultEventNote()) {
                HTML note = new HTML(this.iRoom.hasEventNote() ? this.iRoom.getEventNote() : this.iRoom.getDefaultEventNote());
                if (!this.iRoom.hasEventNote()) {
                    note.addStyleName("default");
                }
                this.iForm.addRow(MESSAGES.propEventNote(), (Widget)note, 1);
            }
            if (this.iRoom.getBreakTime() != null || this.iRoom.getDefaultBreakTime() != null) {
                Label bt = new Label((this.iRoom.getBreakTime() == null ? this.iRoom.getDefaultBreakTime() : this.iRoom.getBreakTime()).toString());
                if (this.iRoom.getBreakTime() == null) {
                    bt.addStyleName("default");
                }
                this.iForm.addRow(MESSAGES.propBreakTime(), (Widget)bt, 1);
            }
            if (this.iRoom.hasServices()) {
                this.iForm.addRow(MESSAGES.propAvailableServices(), (Widget)new RoomDetail.ServicesCell(this.iRoom.getServices(), this.iRoom.getEventDepartment()), 1);
            }
        }
        if (this.iMap != null) {
            if (Window.getClientWidth() <= 800) {
                this.iForm.addRow(this.iMap.asWidget());
            } else {
                this.iForm.setWidget(firstRow, 2, this.iMap.asWidget());
                this.iForm.getFlexCellFormatter().setRowSpan(firstRow, 2, this.iForm.getRowCount() - firstRow - 1);
            }
        }
        if ((this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeGroups() || this.iRoom.isCanChangeGroups()) && !this.iProperties.getGroups().isEmpty()) {
            this.iForm.addHeaderRow(MESSAGES.headerRoomGroups());
            for (Map.Entry<Long, CheckBox> entry : this.iGroups.entrySet()) {
                entry.getValue().setValue(Boolean.valueOf(this.iRoom.hasGroup(entry.getKey())));
            }
            if (this.iGlobalGroupsPanel != null) {
                this.iForm.addRow(MESSAGES.propGlobalGroups(), (Widget)this.iGlobalGroupsPanel);
            } else {
                List<RoomInterface.GroupInterface> globalGroups = this.iRoom.getGlobalGroups();
                if (!globalGroups.isEmpty()) {
                    this.iForm.addRow(MESSAGES.propGlobalGroups(), (Widget)new RoomDetail.GroupsCell((List<? extends RoomInterface.GroupInterface>)globalGroups), 1);
                }
            }
            for (RoomInterface.DepartmentInterface departmentInterface : this.iProperties.getDepartments()) {
                Object d = this.iGroupPanel.get(departmentInterface.getId());
                if (d == null) continue;
                this.iForm.addRow(departmentInterface.getExtLabelWhenExist() + ":", (Widget)d);
            }
        } else if (this.iRoom.hasGroups()) {
            List<RoomInterface.GroupInterface> list;
            this.iForm.addHeaderRow(MESSAGES.headerRoomGroups());
            List<RoomInterface.GroupInterface> globalGroups = this.iRoom.getGlobalGroups();
            if (!globalGroups.isEmpty()) {
                this.iForm.addRow(MESSAGES.propGlobalGroups(), (Widget)new RoomDetail.GroupsCell(globalGroups));
            }
            if (!(list = this.iRoom.getDepartmentalGroups(null)).isEmpty()) {
                this.iForm.addRow(MESSAGES.propDepartmenalGroups(), (Widget)new RoomDetail.GroupsCell(list));
            }
        }
        if ((this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeFeatures() || this.iRoom.isCanChangeFeatures()) && !this.iProperties.getFeatures().isEmpty()) {
            P d;
            this.iForm.addHeaderRow(MESSAGES.headerRoomFeatures());
            for (Map.Entry<Long, CheckBox> entry : this.iFeatures.entrySet()) {
                entry.getValue().setValue(Boolean.valueOf(this.iRoom.hasFeature(entry.getKey())));
            }
            P features = new P("features");
            HashMap<Long, P> hashMap = new HashMap<Long, P>();
            for (RoomInterface.FeatureInterface feature : this.iProperties.getFeatures()) {
                CheckBox ch = this.iFeatures.get(feature.getId());
                if (feature.getType() != null) {
                    d = (P)((Object)hashMap.get(feature.getType().getId()));
                    if (d == null) {
                        d = new P("features");
                        d.setWidth("100%");
                        hashMap.put(feature.getType().getId(), d);
                    }
                    d.add((Widget)ch);
                    continue;
                }
                features.add((Widget)ch);
            }
            for (RoomInterface.FeatureInterface feature : this.iRoom.getFeatures()) {
                if (this.iFeatures.containsKey(feature.getId()) || feature.getDepartment() != null) continue;
                P f = new P("feature");
                f.setText(feature.getTitle());
                if (feature.getType() != null) {
                    d = (P)((Object)hashMap.get(feature.getType().getId()));
                    if (d == null) {
                        d = new P("features");
                        d.setWidth("100%");
                        hashMap.put(feature.getType().getId(), d);
                    }
                    d.add((Widget)f);
                    continue;
                }
                features.add((Widget)f);
            }
            if (features.getWidgetCount() > 0) {
                this.iForm.addRow(MESSAGES.propFeatures(), (Widget)features);
            }
            for (RoomInterface.FeatureTypeInterface type : this.iProperties.getFeatureTypes()) {
                P d2 = (P)((Object)hashMap.get(type.getId()));
                if (d2 == null) continue;
                this.iForm.addRow(type.getLabel() + ":", (Widget)d2);
            }
        } else if (this.iRoom.hasFeatures()) {
            this.iForm.addHeaderRow(MESSAGES.headerRoomFeatures());
            List<RoomInterface.FeatureInterface> features = this.iRoom.getFeatures((Long)null);
            if (!features.isEmpty()) {
                this.iForm.addRow(MESSAGES.propFeatures(), (Widget)new RoomDetail.FeaturesCell(features));
            }
            for (RoomInterface.FeatureTypeInterface type : this.iProperties.getFeatureTypes()) {
                List<RoomInterface.FeatureInterface> featuresOfType = this.iRoom.getFeatures(type);
                if (featuresOfType.isEmpty()) continue;
                this.iForm.addRow(type.getLabel() + ":", (Widget)new RoomDetail.FeaturesCell(featuresOfType));
            }
        }
        if (this.iRoom.hasRoomSharingModel()) {
            this.iRoomSharingHeader.clearMessage();
            this.iRoomSharing.setEditable(this.iProperties.isCanEditDepartments() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeAvailability() || this.iRoom.isCanChangeAvailability());
            this.iRoomSharing.setModel(this.iRoom.getRoomSharingModel());
            this.iRoomSharing.setVisible(true);
            if (this.iRoom.getUniqueId() == null) {
                this.iLastSelectedDepartmentId = Long.valueOf(this.iControllingDepartment.getWidget().getValue(this.iControllingDepartment.getWidget().getSelectedIndex()));
                if (this.iLastSelectedDepartmentId > 0L) {
                    this.iRoomSharing.addOption(this.iLastSelectedDepartmentId);
                }
            }
            this.iForm.addHeaderRow((Widget)this.iRoomSharingHeader);
            this.iForm.addRow((Widget)this.iRoomSharing);
        } else if (this.iProperties.isCanEditDepartments() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeAvailability() || this.iRoom.isCanChangeAvailability()) {
            this.iForm.addHeaderRow((Widget)this.iRoomSharingHeader);
            this.iForm.addRow((Widget)this.iRoomSharing);
            this.iRoomSharingHeader.showLoading();
            this.iRoomSharing.setVisible(false);
            RPC.execute(RoomInterface.RoomSharingRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), false, true), new AsyncCallback<RoomInterface.RoomSharingModel>(){

                public void onFailure(Throwable caught) {
                    RoomEdit.this.iRoomSharingHeader.setErrorMessage(MESSAGES.failedToLoadRoomAvailability(caught.getMessage()));
                }

                public void onSuccess(RoomInterface.RoomSharingModel result) {
                    RoomEdit.this.iRoomSharingHeader.clearMessage();
                    RoomEdit.this.iRoomSharing.setEditable(RoomEdit.this.iProperties.isCanEditDepartments() || RoomEdit.this.iRoom.getUniqueId() == null && RoomEdit.this.iProperties.isCanChangeAvailability() || RoomEdit.this.iRoom.isCanChangeAvailability());
                    RoomEdit.this.iRoomSharing.setModel(result);
                    RoomEdit.this.iRoomSharing.setVisible(true);
                    if (RoomEdit.this.iRoom.getUniqueId() == null) {
                        RoomEdit.this.iLastSelectedDepartmentId = Long.valueOf(((ListBox)RoomEdit.this.iControllingDepartment.getWidget()).getValue(((ListBox)RoomEdit.this.iControllingDepartment.getWidget()).getSelectedIndex()));
                        if (RoomEdit.this.iLastSelectedDepartmentId > 0L) {
                            RoomEdit.this.iRoomSharing.addOption(RoomEdit.this.iLastSelectedDepartmentId);
                        }
                    }
                }
            });
        }
        if (this.iProperties.isCanEditRoomExams() || this.iProperties.isCanSeeExams() && this.iRoom.isCanSeePeriodPreferences() && this.iRoom.hasExamTypes()) {
            PeriodPreferencesWidget pref;
            this.iPeriodPreferencesHeaderRow = this.iForm.addHeaderRow((Widget)this.iPeriodPreferencesHeader);
            this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesHeaderRow, false);
            for (RoomInterface.ExamTypeInterface examTypeInterface : this.iProperties.getExamTypes()) {
                pref = this.iPeriodPreferences.get(examTypeInterface.getId());
                int row = this.iForm.addRow(MESSAGES.propExaminationPreferences(examTypeInterface.getLabel()), (Widget)pref);
                this.iPeriodPreferencesRow.put(examTypeInterface.getId(), row);
                this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesRow.get(examTypeInterface.getId()).intValue(), false);
            }
            this.iPeriodPreferencesHeader.clearMessage();
            for (final RoomInterface.ExamTypeInterface examTypeInterface : this.iProperties.getExamTypes()) {
                pref = this.iPeriodPreferences.get(examTypeInterface.getId());
                if (this.iRoom.hasPeriodPreferenceModel(examTypeInterface.getId())) {
                    pref.setEditable(this.iProperties.isCanEditRoomExams());
                    pref.setModel(this.iRoom.getPeriodPreferenceModel(examTypeInterface.getId()));
                    boolean visible = this.iExaminationRooms.get(examTypeInterface.getId()).getValue() != false && !pref.getModel().getPeriods().isEmpty();
                    this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesRow.get(examTypeInterface.getId()).intValue(), visible);
                    if (!visible) continue;
                    this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesHeaderRow, true);
                    continue;
                }
                if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeExamStatus() || this.iRoom.isCanChangeExamStatus()) {
                    this.iPeriodPreferencesHeader.showLoading();
                    this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesRow.get(examTypeInterface.getId()).intValue(), false);
                    RPC.execute(RoomInterface.PeriodPreferenceRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), examTypeInterface.getId()), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

                        public void onFailure(Throwable caught) {
                            RoomEdit.this.iPeriodPreferencesHeader.setErrorMessage(MESSAGES.failedToLoadPeriodPreferences(caught.getMessage()));
                        }

                        public void onSuccess(RoomInterface.PeriodPreferenceModel result) {
                            RoomEdit.this.iPeriodPreferencesHeader.clearMessage();
                            pref.setEditable(RoomEdit.this.iProperties.isCanEditRoomExams());
                            pref.setModel(result);
                            boolean visible = ((CheckBox)RoomEdit.this.iExaminationRooms.get(examTypeInterface.getId())).getValue() != false && !pref.getModel().getPeriods().isEmpty();
                            RoomEdit.this.iForm.getRowFormatter().setVisible(((Integer)RoomEdit.this.iPeriodPreferencesRow.get(examTypeInterface.getId())).intValue(), visible);
                            if (visible) {
                                RoomEdit.this.iForm.getRowFormatter().setVisible(RoomEdit.this.iPeriodPreferencesHeaderRow, true);
                            }
                        }
                    });
                    continue;
                }
                this.iForm.getRowFormatter().setVisible(this.iPeriodPreferencesRow.get(examTypeInterface.getId()).intValue(), false);
            }
        } else {
            this.iPeriodPreferencesHeaderRow = -1;
            this.iPeriodPreferencesRow.clear();
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventAvailability() || this.iRoom.isCanChangeEventAvailability() || this.iProperties.isCanSeeEvents() && this.iRoom.isCanSeeEventAvailability()) {
            this.iForm.addHeaderRow((Widget)this.iEventAvailabilityHeader);
            this.iForm.addRow((Widget)this.iEventAvailability);
            this.iEventAvailabilityHeader.setVisible(this.isEventRoom());
            if (this.iRoom.hasEventAvailabilityModel()) {
                this.iEventAvailabilityHeader.clearMessage();
                this.iEventAvailability.setEditable(this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventAvailability() || this.iRoom.isCanChangeEventAvailability());
                this.iEventAvailability.setModel(this.iRoom.getEventAvailabilityModel());
                this.iEventAvailability.setVisible(this.isEventRoom());
            } else {
                this.iEventAvailabilityHeader.showLoading();
                this.iEventAvailability.setVisible(false);
                RPC.execute(RoomInterface.RoomSharingRequest.load(this.iRoom.getSessionId(), this.iRoom.getUniqueId(), true), new AsyncCallback<RoomInterface.RoomSharingModel>(){

                    public void onFailure(Throwable caught) {
                        RoomEdit.this.iEventAvailabilityHeader.setErrorMessage(MESSAGES.failedToLoadRoomAvailability(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.RoomSharingModel result) {
                        RoomEdit.this.iEventAvailabilityHeader.clearMessage();
                        RoomEdit.this.iEventAvailability.setEditable(RoomEdit.this.iRoom.getUniqueId() == null && RoomEdit.this.iProperties.isCanChangeEventAvailability() || RoomEdit.this.iRoom.isCanChangeEventAvailability());
                        RoomEdit.this.iEventAvailability.setModel(result);
                        RoomEdit.this.iEventAvailability.setVisible(RoomEdit.this.isEventRoom());
                    }
                });
            }
        }
        if (this.iRoom.hasPictures() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture()) {
            this.iForm.addHeaderRow((Widget)this.iPicturesHeader);
            if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture()) {
                this.iForm.addRow(MESSAGES.propNewPicture(), (Widget)this.iFileUpload);
            }
            this.iForm.addRow((Widget)this.iPictures);
            this.iPictures.clearTable(1);
            if (this.iRoom.hasPictures()) {
                for (RoomInterface.RoomPictureInterface roomPictureInterface : this.iRoom.getPictures()) {
                    this.iPictures.addRow(roomPictureInterface, this.line(roomPictureInterface));
                }
            }
        }
        this.iForm.addBottomRow((Widget)this.iFooter);
        if (this.iRoom.getUniqueId() == null && this.iProperties.hasFutureSessions()) {
            int row = this.iForm.addHeaderRow((Widget)this.iApplyToHeader);
            this.iForm.getRowFormatter().addStyleName(row, "space-above");
            this.iApplyTo.clearTable(1);
            long l = 0L;
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                ArrayList<Object> line = new ArrayList<Object>();
                CheckBox select = new CheckBox();
                line.add(select);
                select.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        RoomEdit.this.futureChanged();
                    }
                });
                line.add(new Label());
                line.add(new Label());
                line.add(new Label());
                line.add(new Label());
                line.add(new Label(session.getLabel()));
                Integer flags = RoomCookie.getInstance().getFutureFlags(session.getId());
                select.setValue(Boolean.valueOf(flags != null));
                for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                    CheckBox ch = new CheckBox();
                    ch.setValue(Boolean.valueOf(this.canFutureOperation(this.iRoom, op) && (flags == null && op.getDefaultSelectionNewRoom() || flags != null && op.in(flags))));
                    if (op == RoomInterface.FutureOperation.ROOM_PROPERTIES) {
                        ch.setValue(Boolean.valueOf(true));
                        ch.setEnabled(false);
                    }
                    line.add(ch);
                }
                RoomInterface.FutureRoomInterface fr = new RoomInterface.FutureRoomInterface();
                fr.setSession(session);
                fr.setId(--l);
                this.iApplyTo.addRow(fr, line);
            }
            for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                this.iApplyTo.setColumnVisible(6 + op.ordinal(), this.canFutureOperation(this.iRoom, op));
            }
            this.iApplyTo.setColumnVisible(1, false);
            this.iApplyTo.setColumnVisible(2, false);
            this.iApplyTo.setColumnVisible(3, false);
            this.iApplyTo.setColumnVisible(4, false);
            this.iForm.addRow((Widget)this.iApplyTo);
            this.futureChanged();
        } else if (this.iRoom.hasFutureRooms()) {
            boolean bl;
            int row = this.iForm.addHeaderRow((Widget)this.iApplyToHeader);
            this.iForm.getRowFormatter().addStyleName(row, "space-above");
            this.iApplyTo.clearTable(1);
            boolean bl2 = false;
            boolean hasType = false;
            boolean hasCapacity = false;
            for (RoomInterface.FutureRoomInterface fr : this.iRoom.getFutureRooms()) {
                ArrayList<Object> line = new ArrayList<Object>();
                CheckBox select = new CheckBox();
                line.add(select);
                select.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        RoomEdit.this.futureChanged();
                    }
                });
                line.add((Object)new FutureRoomNameCell(fr));
                if (fr.hasExternalId()) {
                    bl = true;
                }
                line.add(new Label(fr.hasExternalId() ? fr.getExternalId() : ""));
                if (fr.hasType()) {
                    hasType = true;
                }
                line.add(new Label(fr.hasType() ? fr.getType() : ""));
                if (fr.hasCapacity()) {
                    hasCapacity = true;
                }
                line.add(new Label(fr.hasCapacity() ? fr.getCapacity().toString() : ""));
                line.add(new Label(fr.getSession().getLabel()));
                Integer flags = RoomCookie.getInstance().getFutureFlags(fr.getSession().getId());
                select.setValue(Boolean.valueOf(flags != null));
                for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                    CheckBox ch = new CheckBox();
                    ch.setValue(Boolean.valueOf(this.canFutureOperation(this.iRoom, op) && (flags == null && op.getDefaultSelection() || flags != null && op.in(flags))));
                    line.add(ch);
                }
                this.iApplyTo.addRow(fr, line);
            }
            for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                this.iApplyTo.setColumnVisible(6 + op.ordinal(), this.canFutureOperation(this.iRoom, op));
            }
            this.iApplyTo.setColumnVisible(1, true);
            this.iApplyTo.setColumnVisible(2, bl);
            this.iApplyTo.setColumnVisible(3, hasType);
            this.iApplyTo.setColumnVisible(4, hasCapacity);
            this.iForm.addRow((Widget)this.iApplyTo);
            this.futureChanged();
        }
    }

    public RoomInterface.RoomDetailInterface getRoom() {
        return this.iRoom;
    }

    protected void buildingChanged() {
        RoomInterface.BuildingInterface building = this.iProperties.getBuilding(Long.valueOf(this.iBuilding.getWidget().getValue(this.iBuilding.getWidget().getSelectedIndex())));
        if (building != null) {
            this.iX.setValue(building.getX());
            this.iY.setValue(building.getY());
        }
        if (this.iMap != null) {
            this.iMap.setMarker();
        }
    }

    protected void futureChanged() {
        if (this.iRoom.getUniqueId() == null && this.iProperties.hasFutureSessions() || this.iRoom.hasFutureRooms()) {
            for (int i = 1; i < this.iApplyTo.getRowCount(); ++i) {
                CheckBox ch = (CheckBox)this.iApplyTo.getWidget(i, 0);
                if (!ch.getValue().booleanValue()) continue;
                this.iEventStatus.setHint(MESSAGES.eventStatusHint(this.iRoom.hasSessionName() ? this.iRoom.getSessionName() : this.iProperties.getAcademicSessionName()));
                return;
            }
        }
        this.iEventStatus.clearHint();
    }

    protected void typeChanged() {
        RoomInterface.RoomTypeInterface type = this.iProperties.getRoomType(Long.valueOf(this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex())));
        if (this.iBuildingRow >= 0) {
            this.iForm.getRowFormatter().setVisible(this.iBuildingRow, type != null && type.isRoom());
        }
        this.iNameLabel.setText(type != null && type.isRoom() ? MESSAGES.propRoomNumber() : MESSAGES.propRoomName());
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(this.iRoom.getUniqueId() == null ? MESSAGES.pageAddRoom() : MESSAGES.pageEditRoom());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
        if (this.iMap != null) {
            if (this.iMap.isEnabled() || this.iRoom.hasCoordinates()) {
                this.iMap.setVisible(true);
                this.iMap.onShow();
            } else {
                this.iMap.setVisible(false);
            }
        }
    }

    private List<Widget> line(final RoomInterface.RoomPictureInterface picture) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        Image image = null;
        if (picture.getPictureType() == null || picture.getPictureType().isImage()) {
            image = new Image(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
            image.addStyleName("image");
        } else {
            image = new Image(RESOURCES.download());
        }
        final ImageLink link = new ImageLink(image, GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
        if (picture.getPictureType() != null && !picture.getPictureType().isImage()) {
            link.setText(MESSAGES.roomPictureLink());
        }
        link.setTitle(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getLabel() + ")"));
        line.add(link);
        line.add((Widget)new Label(picture.getName()));
        line.add((Widget)new Label(picture.getType()));
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture()) {
            final ListBox type = new ListBox();
            type.setStyleName("unitime-TextBox");
            if (picture.getPictureType() == null) {
                type.addItem(MESSAGES.itemSelect(), "-1");
                for (RoomInterface.AttachmentTypeInterface t : this.iProperties.getPictureTypes()) {
                    type.addItem(t.getLabel(), t.getId().toString());
                }
                type.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        Long id = Long.valueOf(type.getValue(type.getSelectedIndex()));
                        picture.setPictureType(RoomEdit.this.iProperties.getPictureType(id));
                        if (picture.getPictureType() == null || picture.getPictureType().isImage()) {
                            link.setImage(new Image(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId()));
                            link.getImage().addStyleName("image");
                            link.setText("");
                        } else {
                            link.setImage(new Image(RESOURCES.download()));
                            link.setText(MESSAGES.roomPictureLink());
                        }
                        link.setTitle(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getLabel() + ")"));
                    }
                });
            } else {
                final RoomInterface.AttachmentTypeInterface last = picture.getPictureType();
                for (RoomInterface.AttachmentTypeInterface t : this.iProperties.getPictureTypes()) {
                    type.addItem(t.getLabel(), t.getId().toString());
                }
                boolean found = false;
                for (int i = 0; i < type.getItemCount(); ++i) {
                    if (!type.getValue(i).equals(picture.getPictureType().getId().toString())) continue;
                    type.setSelectedIndex(i);
                    found = true;
                    break;
                }
                if (!found) {
                    type.addItem(picture.getPictureType().getLabel(), picture.getPictureType().getId().toString());
                    type.setSelectedIndex(type.getItemCount() - 1);
                }
                type.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        Long id = Long.valueOf(type.getValue(type.getSelectedIndex()));
                        if (last.getId().equals(id)) {
                            picture.setPictureType(last);
                        } else {
                            picture.setPictureType(RoomEdit.this.iProperties.getPictureType(id));
                        }
                        if (picture.getPictureType() == null || picture.getPictureType().isImage()) {
                            link.setImage(new Image(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId()));
                            link.getImage().addStyleName("image");
                            link.setText("");
                        } else {
                            link.setImage(new Image(RESOURCES.download()));
                            link.setText(MESSAGES.roomPictureLink());
                        }
                        link.setTitle(picture.getName() + (picture.getPictureType() == null ? "" : " (" + picture.getPictureType().getLabel() + ")"));
                    }
                });
            }
            line.add((Widget)type);
        } else {
            line.add((Widget)new Label(picture.getPictureType() == null ? "" : picture.getPictureType().getLabel()));
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture()) {
            Image remove = new Image(RESOURCES.delete());
            remove.setTitle(MESSAGES.titleDeleteRow());
            remove.addStyleName("remove");
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    for (int row = 1; row < RoomEdit.this.iPictures.getRowCount(); ++row) {
                        if (!picture.getUniqueId().equals(((RoomInterface.RoomPictureInterface)RoomEdit.this.iPictures.getData(row)).getUniqueId())) continue;
                        RoomEdit.this.iPictures.removeRow(row);
                        break;
                    }
                    RoomEdit.this.iHeader.setEnabled("update", true);
                    event.stopPropagation();
                }
            });
            line.add((Widget)remove);
        }
        return line;
    }

    public boolean validate() {
        Object deptId;
        boolean result = true;
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeType()) {
            Long typeId = Long.valueOf(this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex()));
            if (typeId < 0L) {
                this.iType.setErrorHint(MESSAGES.errorRoomTypeMustBeSelected());
                result = false;
            }
            for (RoomInterface.RoomTypeInterface roomTypeInterface : this.iProperties.getRoomTypes()) {
                if (!roomTypeInterface.getId().equals(typeId)) continue;
                this.iRoom.setRoomType(roomTypeInterface);
            }
            if (this.iRoom.getRoomType() == null) {
                this.iType.setErrorHint(MESSAGES.errorRoomTypeMustBeSelected());
                result = false;
            }
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeRoomProperties()) {
            if (this.iRoom.getRoomType() != null && this.iRoom.getRoomType().isRoom()) {
                Long buildingId = Long.valueOf(this.iBuilding.getWidget().getValue(this.iBuilding.getWidget().getSelectedIndex()));
                if (buildingId < 0L) {
                    this.iBuilding.setErrorHint(MESSAGES.errorBuildingMustBeSelected(this.iRoom.getRoomType().getLabel()));
                    result = false;
                } else {
                    for (RoomInterface.BuildingInterface buildingInterface : this.iProperties.getBuildings()) {
                        if (!buildingInterface.getId().equals(buildingId)) continue;
                        this.iRoom.setBuilding(buildingInterface);
                    }
                    if (this.iRoom.getBuilding() == null) {
                        this.iBuilding.setErrorHint(MESSAGES.errorBuildingMustBeSelected(this.iRoom.getRoomType().getLabel()));
                        result = false;
                    }
                }
            }
            this.iRoom.setName(this.iName.getWidget().getText());
            if (this.iRoom.getName().isEmpty()) {
                if (this.iRoom.getRoomType() != null && this.iRoom.getRoomType().isRoom()) {
                    this.iName.setErrorHint(MESSAGES.errorRoomNumberIsEmpty());
                } else {
                    this.iName.setErrorHint(MESSAGES.errorLocationNameIsEmpty());
                }
                result = false;
            }
            this.iRoom.setDisplayName(this.iDisplayName.getText());
            this.iRoom.setX(this.iX.toDouble());
            this.iRoom.setY(this.iY.toDouble());
            this.iRoom.setArea(this.iArea.toDouble());
            if (this.iProperties.isCanSeeCourses()) {
                this.iRoom.setIgnoreTooFar(this.iDistanceCheck.getValue() == false);
            }
            this.iRoom.setIgnoreRoomCheck(this.iRoomCheck.getValue() == false);
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeExternalId() || this.iRoom.isCanChangeExternalId()) {
            this.iRoom.setExternalId(this.iExternalId.getText());
        }
        if (this.iRoom.getUniqueId() == null || this.iRoom.isCanChangeCapacity()) {
            this.iRoom.setCapacity(this.iCapacity.getWidget().toInteger());
            if (this.iRoom.getCapacity() == null) {
                this.iCapacity.setErrorHint(MESSAGES.errorRoomCapacityIsEmpty());
                result = false;
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeControll() || this.iRoom.isCanChangeControll()) {
            deptId = Long.valueOf(this.iControllingDepartment.getWidget().getValue(this.iControllingDepartment.getWidget().getSelectedIndex()));
            if ((Long)deptId < 0L) {
                this.iRoom.setControlDepartment(null);
            } else if (this.iLastControllingDept != null && ((Long)deptId).equals(this.iLastControllingDept.getId())) {
                this.iRoom.setControlDepartment(this.iLastControllingDept);
            } else {
                for (RoomInterface.DepartmentInterface departmentInterface : this.iProperties.getDepartments()) {
                    if (!((Long)deptId).equals(departmentInterface.getId())) continue;
                    this.iRoom.setControlDepartment(departmentInterface);
                }
            }
            if (this.iRoom.getControlDepartment() != null && this.iRoomSharing.getModel() != null) {
                boolean hasDepartment = false;
                if (this.iRoomSharing.getModel() != null) {
                    for (RoomInterface.RoomSharingOption opt : this.iRoomSharing.getModel().getOptions()) {
                        if (!this.iRoom.getControlDepartment().getId().equals(opt.getId())) continue;
                        hasDepartment = true;
                        break;
                    }
                }
                if (!hasDepartment) {
                    this.iControllingDepartment.setErrorHint(MESSAGES.errorControllingDepartmentNotAmongRoomSharing());
                    result = false;
                }
            }
        }
        if (this.iProperties.isCanEditRoomExams()) {
            this.iRoom.getExamTypes().clear();
            for (RoomInterface.ExamTypeInterface type : this.iProperties.getExamTypes()) {
                if (!this.iExaminationRooms.get(type.getId()).getValue().booleanValue()) continue;
                this.iRoom.getExamTypes().add(type);
                this.iRoom.setPeriodPreferenceModel(this.iPeriodPreferences.get(type.getId()).getModel());
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeExamStatus() || this.iRoom.isCanChangeExamStatus()) {
            this.iRoom.setExamCapacity(this.iExamCapacity.getWidget().toInteger());
            if (this.iRoom.hasExamTypes() && this.iRoom.getExamCapacity() == null) {
                this.iExamCapacity.setErrorHint(MESSAGES.errorRoomExamCapacityIsEmpty());
                result = false;
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventProperties() || this.iRoom.isCanChangeEventProperties()) {
            deptId = Long.valueOf(this.iEventDepartment.getValue(this.iEventDepartment.getSelectedIndex()));
            if ((Long)deptId < 0L) {
                this.iRoom.setEventDepartment(null);
            } else if (this.iLastEventDept != null && ((Long)deptId).equals(this.iLastEventDept.getId())) {
                this.iRoom.setEventDepartment(this.iLastEventDept);
            } else {
                for (RoomInterface.DepartmentInterface departmentInterface : this.iProperties.getDepartments()) {
                    if (!((Long)deptId).equals(departmentInterface.getId())) continue;
                    this.iRoom.setEventDepartment(departmentInterface);
                }
            }
            if (this.iEventStatus.getWidget().getSelectedIndex() == 0) {
                this.iRoom.setEventStatus(null);
            } else {
                this.iRoom.setEventStatus(this.iEventStatus.getWidget().getSelectedIndex() - 1);
            }
            this.iRoom.setEventNote(this.iNote.getWidget().getText().isEmpty() ? null : this.iNote.getWidget().getText());
            if (this.iNote.getWidget().getText().length() > 2048) {
                this.iNote.setErrorHint(MESSAGES.errorEventNoteTooLong());
                result = false;
            }
            this.iRoom.setBreakTime(this.iBreakTime.toInteger());
            this.iRoom.clearServices();
            if (this.iProperties.hasEventServiceProviders() && this.iRoom.getEventDepartment() != null) {
                for (EventInterface.EventServiceProviderInterface eventServiceProviderInterface : this.iProperties.getEventServiceProviders()) {
                    if (eventServiceProviderInterface.getDepartmentId() != null && !eventServiceProviderInterface.getDepartmentId().equals(this.iRoom.getEventDepartment().getId()) || !this.iServices.get(eventServiceProviderInterface.getId()).getValue().booleanValue()) continue;
                    this.iRoom.addService(eventServiceProviderInterface);
                }
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeGroups() || this.iRoom.isCanChangeGroups()) {
            for (RoomInterface.GroupInterface group : this.iProperties.getGroups()) {
                if (this.iGroups.get(group.getId()).getValue().booleanValue()) {
                    if (this.iRoom.hasGroup(group.getId())) continue;
                    this.iRoom.addGroup(group);
                    continue;
                }
                if (!this.iRoom.hasGroup(group.getId())) continue;
                this.iRoom.removeGroup(group);
            }
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeFeatures() || this.iRoom.isCanChangeFeatures()) {
            for (RoomInterface.FeatureInterface feature : this.iProperties.getFeatures()) {
                if (this.iFeatures.get(feature.getId()).getValue().booleanValue()) {
                    if (this.iRoom.hasFeature(feature.getId())) continue;
                    this.iRoom.addFeature(feature);
                    continue;
                }
                if (!this.iRoom.hasFeature(feature.getId())) continue;
                this.iRoom.removeFeature(feature);
            }
        }
        if (this.iProperties.isCanEditDepartments() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeAvailability() || this.iRoom.isCanChangeAvailability()) {
            this.iRoom.setRoomSharingModel(this.iRoomSharing.getModel());
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventAvailability() || this.iRoom.isCanChangeEventAvailability()) {
            this.iRoom.setEventAvailabilityModel(this.iEventAvailability.getModel());
        }
        if (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture()) {
            this.iRoom.getPictures().clear();
            this.iRoom.getPictures().addAll(this.iPictures.getData());
        }
        if (CONSTANTS.checkRoomHasNoDepartment() && (this.iProperties.isCanEditDepartments() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeAvailability() || this.iRoom.isCanChangeAvailability())) {
            boolean hasDepartment;
            boolean bl = hasDepartment = this.iRoom.getEventDepartment() != null;
            if (!hasDepartment && this.iRoomSharing.getModel() != null) {
                for (RoomInterface.RoomSharingOption roomSharingOption : this.iRoomSharing.getModel().getOptions()) {
                    if (roomSharingOption.getId() <= 0L) continue;
                    hasDepartment = true;
                    break;
                }
            }
            if (!hasDepartment) {
                this.iRoomSharingHeader.setErrorMessage(MESSAGES.errorRoomHasNoDepartment());
                result = false;
            } else {
                this.iRoomSharingHeader.clearMessage();
            }
        }
        return result;
    }

    public void hide(RoomInterface.RoomDetailInterface room, boolean canShowDetail, String message) {
        this.setVisible(false);
        this.onHide(room, canShowDetail, message);
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide(RoomInterface.RoomDetailInterface detail, boolean canShowDetail, String message) {
    }

    protected void onShow() {
    }

    protected String getFutureOperationLabel(RoomInterface.FutureOperation op) {
        switch (op) {
            case ROOM_PROPERTIES: {
                return MESSAGES.colChangeRoomProperties();
            }
            case EXAM_PROPERTIES: {
                return MESSAGES.colChangeExamProperties();
            }
            case EVENT_PROPERTIES: {
                return MESSAGES.colChangeEventProperties();
            }
            case GROUPS: {
                return MESSAGES.colChangeRoomGroups();
            }
            case FEATURES: {
                return MESSAGES.colChangeRoomFeatures();
            }
            case ROOM_SHARING: {
                return MESSAGES.colChangeRoomSharing();
            }
            case EXAM_PREFS: {
                return MESSAGES.colChangeRoomPeriodPreferences();
            }
            case EVENT_AVAILABILITY: {
                return MESSAGES.colChangeRoomEventAvailability();
            }
            case PICTURES: {
                return MESSAGES.colChangeRoomPictures();
            }
        }
        return op.name();
    }

    protected boolean canFutureOperation(RoomInterface.RoomDetailInterface room, RoomInterface.FutureOperation op) {
        switch (op) {
            case ROOM_PROPERTIES: {
                return this.iRoom.getRoomType() == null || this.iRoom.isCanChangeType() || this.iRoom.isCanChangeRoomProperties() || this.iRoom.isCanChangeExternalId() || this.iRoom.isCanChangeCapacity() || this.iRoom.isCanChangeControll();
            }
            case EXAM_PROPERTIES: {
                return this.iRoom.getRoomType() == null && this.iProperties.isCanChangeExamStatus() || this.iRoom.isCanChangeExamStatus();
            }
            case EVENT_PROPERTIES: {
                return this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventProperties() || this.iRoom.isCanChangeEventProperties();
            }
            case GROUPS: {
                return (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeGroups() || this.iRoom.isCanChangeGroups()) && !this.iProperties.getGroups().isEmpty();
            }
            case FEATURES: {
                return (this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeFeatures() || this.iRoom.isCanChangeFeatures()) && !this.iProperties.getFeatures().isEmpty();
            }
            case ROOM_SHARING: {
                return this.iProperties.isCanEditDepartments() || this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeAvailability() || this.iRoom.isCanChangeAvailability();
            }
            case EXAM_PREFS: {
                return this.iProperties.isCanEditRoomExams();
            }
            case EVENT_AVAILABILITY: {
                return this.iRoom.getUniqueId() == null && this.iProperties.isCanChangeEventAvailability() || this.iRoom.isCanChangeEventAvailability();
            }
            case PICTURES: {
                return this.iRoom.getUniqueId() == null && this.iProperties.isCanChangePicture() || this.iRoom.isCanChangePicture();
            }
        }
        return false;
    }

    protected void fillFutureFlags(RoomInterface.RoomUpdateRpcRequest request, boolean includeWhenNoFlags) {
        block7: {
            block6: {
                request.clearFutureFlags();
                if (this.iRoom.getUniqueId() != null || !this.iProperties.hasFutureSessions()) break block6;
                for (int i = 1; i < this.iApplyTo.getRowCount(); ++i) {
                    CheckBox ch = (CheckBox)this.iApplyTo.getWidget(i, 0);
                    if (ch.getValue().booleanValue()) {
                        int flags = 0;
                        for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                            CheckBox x = (CheckBox)this.iApplyTo.getWidget(i, 6 + op.ordinal());
                            if (!x.getValue().booleanValue()) continue;
                            flags = op.set(flags);
                        }
                        if (flags == 0 && !includeWhenNoFlags) continue;
                        request.setFutureFlag(-this.iApplyTo.getData(i).getSession().getId().longValue(), flags);
                        RoomCookie.getInstance().setFutureFlags(this.iApplyTo.getData(i).getSession().getId(), flags);
                        continue;
                    }
                    RoomCookie.getInstance().setFutureFlags(this.iApplyTo.getData(i).getSession().getId(), null);
                }
                break block7;
            }
            if (!this.iRoom.hasFutureRooms()) break block7;
            for (int i = 1; i < this.iApplyTo.getRowCount(); ++i) {
                CheckBox ch = (CheckBox)this.iApplyTo.getWidget(i, 0);
                if (ch.getValue().booleanValue()) {
                    int flags = 0;
                    for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                        CheckBox x = (CheckBox)this.iApplyTo.getWidget(i, 6 + op.ordinal());
                        if (!x.getValue().booleanValue()) continue;
                        flags = op.set(flags);
                    }
                    if (flags == 0 && !includeWhenNoFlags) continue;
                    request.setFutureFlag(this.iApplyTo.getData(i).getId(), flags);
                    RoomCookie.getInstance().setFutureFlags(this.iApplyTo.getData(i).getSession().getId(), flags);
                    continue;
                }
                RoomCookie.getInstance().setFutureFlags(this.iApplyTo.getData(i).getSession().getId(), null);
            }
        }
    }

    protected String generateAlsoUpdateMessage(boolean includeWhenNoFlags) {
        if (this.iRoom.getUniqueId() == null && this.iProperties.hasFutureSessions() || this.iRoom.hasFutureRooms()) {
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 1; i < this.iApplyTo.getRowCount(); ++i) {
                CheckBox ch = (CheckBox)this.iApplyTo.getWidget(i, 0);
                if (!ch.getValue().booleanValue()) continue;
                int flags = 0;
                for (RoomInterface.FutureOperation op : RoomInterface.FutureOperation.values()) {
                    CheckBox x = (CheckBox)this.iApplyTo.getWidget(i, 6 + op.ordinal());
                    if (!x.getValue().booleanValue()) continue;
                    flags = op.set(flags);
                }
                if (flags == 0 && !includeWhenNoFlags) continue;
                ret.add(this.iApplyTo.getData(i).getSession().getLabel());
            }
            if (!ret.isEmpty()) {
                return ToolBox.toString(ret);
            }
        }
        return null;
    }

    protected void roomCheckChanged() {
        this.iRoomCheck.setHTML(this.iRoomCheck.getValue() != false ? MESSAGES.infoRoomCheckOn() : MESSAGES.infoRoomCheckOff());
        if (this.iRoomCheck.getValue().booleanValue()) {
            this.iRoomCheck.addStyleName("check-enabled");
            this.iRoomCheck.removeStyleName("check-disabled");
        } else {
            this.iRoomCheck.addStyleName("check-disabled");
            this.iRoomCheck.removeStyleName("check-enabled");
        }
    }

    protected void distanceCheckChanged() {
        this.iDistanceCheck.setHTML(this.iDistanceCheck.getValue() != false ? MESSAGES.infoDistanceCheckOn() : MESSAGES.infoDistanceCheckOff());
        if (this.iDistanceCheck.getValue().booleanValue()) {
            this.iDistanceCheck.addStyleName("check-enabled");
            this.iDistanceCheck.removeStyleName("check-disabled");
        } else {
            this.iDistanceCheck.addStyleName("check-disabled");
            this.iDistanceCheck.removeStyleName("check-enabled");
        }
    }

    class FutureRoomNameCell
    extends Label {
        FutureRoomNameCell(final RoomInterface.FutureRoomInterface room) {
            super(room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel());
            this.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    RoomHint.showHint((Element)FutureRoomNameCell.this.getElement(), room.getId(), null, null, true);
                }
            });
            this.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    RoomHint.hideHint();
                }
            });
        }
    }
}

