/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.InstructorExternalIdCell;
import org.unitime.timetable.gwt.client.instructor.InstructorNameCell;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestDetailPage;
import org.unitime.timetable.gwt.client.instructor.TimePreferenceCell;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class TeachingAssignmentsChangesPage
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    private UniTimeHeaderPanel iFilterPanel = new UniTimeHeaderPanel(MESSAGES.propAssignmentChangesBase());
    private ListBox iFilter = new ListBox();
    private InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private UniTimeTable<SingleTeachingAssingment> iTable;
    private TeachingRequestDetailPage iDetail = null;

    public TeachingAssignmentsChangesPage() {
        this.iFilter.setStyleName("unitime-TextBox");
        this.iFilterPanel.insertLeft((Widget)this.iFilter, false);
        this.iFilter.getElement().getStyle().setMarginLeft(5.0, Style.Unit.PX);
        for (String base : CONSTANTS.assignmentChangesBase()) {
            this.iFilter.addItem(base);
        }
        this.iFilter.setSelectedIndex(InstructorCookie.getInstance().getAssignmentChangesBase());
        this.iFilterPanel.addButton("search", MESSAGES.buttonSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeachingAssignmentsChangesPage.this.search();
            }
        });
        this.iFilterPanel.setEnabled("search", false);
        this.addRow((Widget)this.iFilterPanel);
        this.iTable = new UniTimeTable();
        this.iTable.setVisible(false);
        this.iTable.addStyleName("unitime-TeachingAssignmentChanges");
        this.addRow((Widget)this.iTable);
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SingleTeachingAssingment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<SingleTeachingAssingment> event) {
                if (event.getData() != null) {
                    if (TeachingAssignmentsChangesPage.this.iDetail == null) {
                        TeachingAssignmentsChangesPage.this.iDetail = new TeachingRequestDetailPage(TeachingAssignmentsChangesPage.this.iProperties){

                            @Override
                            protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                                if (TeachingAssignmentsChangesPage.this.iTable.isVisible()) {
                                    TeachingAssignmentsChangesPage.this.search();
                                }
                            }
                        };
                        TeachingAssignmentsChangesPage.this.iDetail.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                            public void onClose(CloseEvent<PopupPanel> event) {
                                TeachingAssignmentsChangesPage.this.iTable.clearHover();
                            }
                        });
                    }
                    TeachingAssignmentsChangesPage.this.iDetail.showRequestDetail(event.getData().getRequest().getRequestId());
                }
            }
        });
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new InstructorInterface.TeachingRequestsPagePropertiesRequest(), new AsyncCallback<InstructorInterface.TeachingRequestsPagePropertiesResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsChangesPage.this.iFilterPanel.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.TeachingRequestsPagePropertiesResponse result) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsChangesPage.this.iProperties = result;
                TeachingAssignmentsChangesPage.this.iFilterPanel.setEnabled("search", true);
            }
        });
    }

    void search() {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingTeachingAssignments());
        InstructorCookie.getInstance().setAssignmentChangesBase(this.iFilter.getSelectedIndex());
        RPC.execute(new InstructorInterface.AssignmentChangesRequest(InstructorInterface.ChangesType.values()[this.iFilter.getSelectedIndex()]), new AsyncCallback<InstructorInterface.AssignmentChangesResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsChangesPage.this.iFilterPanel.setErrorMessage(MESSAGES.failedToLoadTeachingAssignments(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingAssignments(caught.getMessage()), caught);
            }

            public void onSuccess(InstructorInterface.AssignmentChangesResponse result) {
                LoadingWidget.getInstance().hide();
                TeachingAssignmentsChangesPage.this.populate(result.getChanges());
                TeachingAssignmentsChangesPage.this.iTable.setVisible(true);
            }
        });
    }

    void populate(List<InstructorInterface.AssignmentInfo> results) {
        int i;
        COLUMN[] h;
        this.iTable.clearTable();
        ArrayList<Object> header = new ArrayList<Object>();
        COLUMN[] sortHeader = null;
        COLUMN sortColumn = null;
        boolean asc = true;
        int sort = InstructorCookie.getInstance().getSortAssignmentChangesBy();
        for (COLUMN cOLUMN : COLUMN.values()) {
            h = this.getHeader(cOLUMN);
            h.addOperation(new UniTimeTableHeader.Operation((UniTimeTableHeader)h, cOLUMN){
                final /* synthetic */ UniTimeTableHeader val$h;
                final /* synthetic */ COLUMN val$column;
                {
                    this.val$h = uniTimeTableHeader;
                    this.val$column = cOLUMN;
                }

                public void execute() {
                    TeachingAssignmentsChangesPage.this.iTable.sort(this.val$h, new TableComparator(this.val$column));
                    InstructorCookie.getInstance().setSortAssignmentChangesBy(this.val$h.getOrder() != false ? 1 + this.val$column.ordinal() : -1 - this.val$column.ordinal());
                    TeachingAssignmentsChangesPage.this.hideDuplicateRequests();
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return true;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.val$h.getHTML().replace("<br>", " "));
                }
            });
            header.add(h);
            if (sort != 0 && Math.abs(sort) - 1 == cOLUMN.ordinal()) {
                sortHeader = h;
                sortColumn = cOLUMN;
                boolean bl = asc = sort > 0;
            }
            if (cOLUMN.getColSpan() <= 1) continue;
            for (i = 1; i < cOLUMN.getColSpan(); ++i) {
                header.add(new UniTimeTableHeader("&nbsp;"));
            }
        }
        this.iTable.addRow(null, header);
        for (InstructorInterface.AssignmentInfo assignment : results) {
            SingleTeachingAssingment sta = new SingleTeachingAssingment(assignment.getRequest(), assignment.getRequest().getInstructor(assignment.getIndex()), assignment.getInstructor());
            ArrayList<Widget> arrayList = new ArrayList<Widget>();
            for (COLUMN column : COLUMN.values()) {
                for (int i2 = 0; i2 < column.getColSpan(); ++i2) {
                    Widget cell = this.getCell(column, i2, sta);
                    if (cell == null) {
                        cell = new Label();
                    }
                    arrayList.add(cell);
                }
            }
            this.iTable.addRow(sta, arrayList);
        }
        if (sortHeader != null) {
            this.iTable.sort((UniTimeTableHeader)sortHeader, new TableComparator(sortColumn), asc);
        }
        for (final COLUMN cOLUMN : COLUMN.values()) {
            h = (UniTimeTableHeader)header.get(cOLUMN.getColIndex());
            if (!cOLUMN.isCanHide()) continue;
            ((UniTimeTableHeader)header.get(0)).getOperations().add(((UniTimeTableHeader)header.get(0)).getOperations().size() - 1, new UniTimeTableHeader.Operation((UniTimeTableHeader)h){
                final /* synthetic */ UniTimeTableHeader val$h;
                {
                    this.val$h = uniTimeTableHeader;
                }

                public void execute() {
                    block4: {
                        int i;
                        boolean visible;
                        block3: {
                            visible = !InstructorCookie.getInstance().isAssignmentChangesColumnVisible(cOLUMN.ordinal());
                            InstructorCookie.getInstance().setAssignmentChangesColumnVisible(cOLUMN.ordinal(), visible);
                            for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                                TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(cOLUMN.getColIndex() + i, visible);
                            }
                            if (COLUMN.NAME != cOLUMN || visible) break block3;
                            InstructorCookie.getInstance().setAssignmentChangesColumnVisible(COLUMN.EXTERNAL_ID.ordinal(), true);
                            for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                                TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(COLUMN.EXTERNAL_ID.getColIndex() + i, true);
                            }
                            break block4;
                        }
                        if (COLUMN.EXTERNAL_ID != cOLUMN || visible) break block4;
                        InstructorCookie.getInstance().setAssignmentChangesColumnVisible(COLUMN.NAME.ordinal(), true);
                        for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                            TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(COLUMN.NAME.getColIndex() + i, true);
                        }
                    }
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    if (InstructorCookie.getInstance().isAssignmentChangesColumnVisible(cOLUMN.ordinal())) {
                        return MESSAGES.opHide(this.val$h.getHTML().replace("<br>", " "));
                    }
                    return MESSAGES.opShow(this.val$h.getHTML().replace("<br>", " "));
                }
            });
            h.addOperation(new UniTimeTableHeader.Operation((UniTimeTableHeader)h){
                final /* synthetic */ UniTimeTableHeader val$h;
                {
                    this.val$h = uniTimeTableHeader;
                }

                public void execute() {
                    block4: {
                        int i;
                        boolean visible;
                        block3: {
                            visible = !InstructorCookie.getInstance().isAssignmentChangesColumnVisible(cOLUMN.ordinal());
                            InstructorCookie.getInstance().setAssignmentChangesColumnVisible(cOLUMN.ordinal(), visible);
                            for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                                TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(cOLUMN.getColIndex() + i, visible);
                            }
                            if (COLUMN.NAME != cOLUMN || visible) break block3;
                            InstructorCookie.getInstance().setAssignmentChangesColumnVisible(COLUMN.EXTERNAL_ID.ordinal(), true);
                            for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                                TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(COLUMN.EXTERNAL_ID.getColIndex() + i, true);
                            }
                            break block4;
                        }
                        if (COLUMN.EXTERNAL_ID != cOLUMN || visible) break block4;
                        InstructorCookie.getInstance().setAssignmentChangesColumnVisible(COLUMN.NAME.ordinal(), true);
                        for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                            TeachingAssignmentsChangesPage.this.iTable.setColumnVisible(COLUMN.NAME.getColIndex() + i, true);
                        }
                    }
                }

                @Override
                public boolean isApplicable() {
                    return true;
                }

                @Override
                public boolean hasSeparator() {
                    return true;
                }

                @Override
                public String getName() {
                    if (InstructorCookie.getInstance().isAssignmentChangesColumnVisible(cOLUMN.ordinal())) {
                        return MESSAGES.opHideItem(this.val$h.getHTML().replace("<br>", " "));
                    }
                    return MESSAGES.opShowItem(this.val$h.getHTML().replace("<br>", " "));
                }
            });
            for (i = 0; i < cOLUMN.getColSpan(); ++i) {
                this.iTable.setColumnVisible(cOLUMN.getColIndex() + i, !cOLUMN.isCanHide() || InstructorCookie.getInstance().isAssignmentChangesColumnVisible(cOLUMN.ordinal()));
            }
        }
        this.hideDuplicateRequests();
    }

    public void hideDuplicateRequests() {
        InstructorInterface.TeachingRequestInfo last = null;
        for (int i = 0; i < this.iTable.getRowCount(); ++i) {
            int j;
            int col;
            SingleTeachingAssingment ta = this.iTable.getData(i);
            if (ta == null) {
                last = null;
                continue;
            }
            if (ta.getRequest().equals(last)) {
                col = 0;
                for (COLUMN column : COLUMN.values()) {
                    for (j = 0; j < column.getColSpan(); ++j) {
                        this.iTable.getCellFormatter().setStyleName(i, col, null);
                        if (!column.isHasInstructor()) {
                            this.iTable.getWidget(i, col).setVisible(false);
                        }
                        ++col;
                    }
                }
            } else {
                col = 0;
                for (COLUMN column : COLUMN.values()) {
                    for (j = 0; j < column.getColSpan(); ++j) {
                        this.iTable.getCellFormatter().setStyleName(i, col, "first-line");
                        if (!column.isHasInstructor()) {
                            this.iTable.getWidget(i, col).setVisible(true);
                        }
                        ++col;
                    }
                }
            }
            last = ta.getRequest();
        }
    }

    public UniTimeTableHeader getHeader(COLUMN column) {
        switch (column) {
            case COURSE: {
                return new UniTimeTableHeader(MESSAGES.colCourse());
            }
            case SECTION: {
                return new UniTimeTableHeader(MESSAGES.colSection());
            }
            case TIME: {
                return new UniTimeTableHeader(MESSAGES.colTime());
            }
            case DATE: {
                return new UniTimeTableHeader(MESSAGES.colDate());
            }
            case ROOM: {
                return new UniTimeTableHeader(MESSAGES.colRoom());
            }
            case LOAD: {
                return new UniTimeTableHeader(MESSAGES.colTeachingLoad());
            }
            case ATTRIBUTE_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return new UniTimeTableHeader(MESSAGES.colInstructorPreferences());
            }
            case EXTERNAL_ID: {
                return new UniTimeTableHeader(MESSAGES.colExternalId());
            }
            case NAME: {
                return new UniTimeTableHeader(MESSAGES.colNamePerson());
            }
            case ATTRIBUTES: {
                return new UniTimeTableHeader(MESSAGES.colAttributes());
            }
            case COURSE_PREF: {
                return new UniTimeTableHeader(MESSAGES.colCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                return new UniTimeTableHeader(MESSAGES.colDistributionPreferences());
            }
            case TIME_PREF: {
                UniTimeTableHeader timePrefHeader = new UniTimeTableHeader(MESSAGES.colTimePreferences());
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(true, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingAssignmentsChangesPage.this.iTable.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationAsText();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, RoomCookie.getInstance().areRoomsHorizontal());
                        TeachingAssignmentsChangesPage.this.iTable.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return RoomCookie.getInstance().isGridAsText();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationAsGrid();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, true);
                        TeachingAssignmentsChangesPage.this.iTable.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && !RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationHorizontal();
                    }
                });
                timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        RoomCookie.getInstance().setOrientation(false, false);
                        TeachingAssignmentsChangesPage.this.iTable.refreshTable();
                    }

                    @Override
                    public boolean isApplicable() {
                        return !RoomCookie.getInstance().isGridAsText() && RoomCookie.getInstance().areRoomsHorizontal();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opOrientationVertical();
                    }
                });
                if (this.iProperties != null && this.iProperties.hasModes() && !RoomCookie.getInstance().isGridAsText()) {
                    int i = 0;
                    while (i < this.iProperties.getModes().size()) {
                        final RoomInterface.RoomSharingDisplayMode mode = this.iProperties.getModes().get(i);
                        final int index = i++;
                        timePrefHeader.addOperation(new UniTimeTableHeader.Operation(){

                            public void execute() {
                                RoomCookie.getInstance().setMode(RoomCookie.getInstance().areRoomsHorizontal(), mode.toHex());
                                TeachingAssignmentsChangesPage.this.iTable.refreshTable();
                            }

                            @Override
                            public boolean isApplicable() {
                                return !RoomCookie.getInstance().isGridAsText() && !mode.toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            @Override
                            public boolean hasSeparator() {
                                return index == 0 || index == 1 && TeachingAssignmentsChangesPage.this.iProperties.getModes().get(0).toHex().equals(RoomCookie.getInstance().getMode());
                            }

                            @Override
                            public String getName() {
                                return mode.getName();
                            }
                        });
                    }
                }
                return timePrefHeader;
            }
            case ASSIGNED_LOAD: {
                return new UniTimeTableHeader(MESSAGES.colAssignedLoad());
            }
            case OBJECTIVES: {
                return new UniTimeTableHeader(MESSAGES.colObjectives());
            }
            case ASSIGNED_INSTRUCTORS: {
                return new UniTimeTableHeader(MESSAGES.colAssignedInstructors());
            }
        }
        return new UniTimeTableHeader(column.name());
    }

    public Widget getCell(COLUMN column, int index, SingleTeachingAssingment assignment) {
        InstructorInterface.TeachingRequestInfo request = assignment.getRequest();
        InstructorInterface.InstructorInfo instructor = assignment.getInstructor();
        InstructorInterface.InstructorInfo baseInstructor = assignment.getBaseInstructor();
        switch (column) {
            case COURSE: {
                return new Label(request.getCourse().getCourseName());
            }
            case SECTION: {
                P p = new P("sections");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("section");
                    i.setText(s.getSectionType() + (s.getExternalId() == null ? "" : " " + s.getExternalId()));
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case TIME: {
                P p = new P("times");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("time");
                    i.setHTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case DATE: {
                P p = new P("dates");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("date");
                    i.setHTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case ROOM: {
                P p = new P("rooms");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P i = new P("room");
                    i.setHTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                    if (s.isCommon()) {
                        i.addStyleName("common");
                    }
                    p.add((Widget)i);
                }
                return p;
            }
            case LOAD: {
                return new Label(sTeachingLoadFormat.format((double)request.getLoad()));
            }
            case EXTERNAL_ID: {
                switch (index) {
                    case 0: {
                        InstructorExternalIdCell cell1 = new InstructorExternalIdCell(this.iProperties);
                        cell1.setValue(baseInstructor);
                        return cell1;
                    }
                    case 1: {
                        return new HTML(MESSAGES.assignmentArrow());
                    }
                    case 2: {
                        InstructorExternalIdCell cell2 = new InstructorExternalIdCell(this.iProperties);
                        cell2.setValue(instructor);
                        return cell2;
                    }
                }
            }
            case NAME: {
                switch (index) {
                    case 0: {
                        InstructorNameCell cell1 = new InstructorNameCell(this.iProperties);
                        cell1.setValue(baseInstructor);
                        return cell1;
                    }
                    case 1: {
                        return new HTML(MESSAGES.assignmentArrow());
                    }
                    case 2: {
                        InstructorNameCell cell2 = new InstructorNameCell(this.iProperties);
                        cell2.setValue(instructor);
                        return cell2;
                    }
                }
            }
            case ATTRIBUTE_PREFS: {
                return new PreferenceCell(this.iProperties, request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return new PreferenceCell(this.iProperties, request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                if (instructor != null) {
                    return new PreferenceCell(this.iProperties, instructor.getCoursePreferences());
                }
                if (baseInstructor != null) {
                    return new PreferenceCell(this.iProperties, baseInstructor.getCoursePreferences());
                }
                return null;
            }
            case DISTRIBUTION_PREF: {
                if (instructor != null) {
                    return new PreferenceCell(this.iProperties, instructor.getDistributionPreferences());
                }
                if (baseInstructor != null) {
                    return new PreferenceCell(this.iProperties, baseInstructor.getDistributionPreferences());
                }
                return null;
            }
            case TIME_PREF: {
                if (instructor != null) {
                    return new TimePreferenceCell(this.iProperties, instructor);
                }
                if (baseInstructor != null) {
                    return new TimePreferenceCell(this.iProperties, baseInstructor);
                }
                return null;
            }
            case ATTRIBUTES: {
                if (instructor != null) {
                    return new AttributesCell(instructor.getAttributes());
                }
                if (baseInstructor != null) {
                    return new AttributesCell(baseInstructor.getAttributes());
                }
                return null;
            }
            case ASSIGNED_LOAD: {
                if (instructor == null) {
                    return null;
                }
                return new Label(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad()));
            }
            case OBJECTIVES: {
                return new ObjectivesCell(this.iProperties, baseInstructor == null ? null : baseInstructor.getValues(), instructor == null ? null : instructor.getValues());
            }
            case ASSIGNED_INSTRUCTORS: {
                return new Label(request.getNrAssignedInstructors() + " / " + request.getNrInstructors());
            }
        }
        return null;
    }

    public static class SingleTeachingAssingment {
        InstructorInterface.InstructorInfo iBaseInstructor;
        InstructorInterface.InstructorInfo iInstructor;
        InstructorInterface.TeachingRequestInfo iRequest;

        public SingleTeachingAssingment(InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor, InstructorInterface.InstructorInfo base) {
            this.iInstructor = instructor;
            this.iRequest = request;
            this.iBaseInstructor = base;
        }

        public boolean hasInstructor() {
            return this.iInstructor != null;
        }

        public InstructorInterface.InstructorInfo getInstructor() {
            return this.iInstructor;
        }

        public boolean hasBaseInstructor() {
            return this.iBaseInstructor != null;
        }

        public InstructorInterface.InstructorInfo getBaseInstructor() {
            return this.iBaseInstructor;
        }

        public boolean hasRequest() {
            return this.iRequest != null;
        }

        public InstructorInterface.TeachingRequestInfo getRequest() {
            return this.iRequest;
        }
    }

    public static class TableComparator
    implements Comparator<SingleTeachingAssingment> {
        private COLUMN iColumn;

        public TableComparator(COLUMN column) {
            this.iColumn = column;
        }

        protected int compareSections(COLUMN column, InstructorInterface.SectionInfo s1, InstructorInterface.SectionInfo s2) {
            switch (column) {
                case SECTION: {
                    return this.compareOthers(s1, s2);
                }
                case TIME: {
                    return this.compareStrings(s1.getTime(), s2.getTime());
                }
                case DATE: {
                    return this.compareStrings(s1.getDate(), s2.getDate());
                }
                case ROOM: {
                    return this.compareStrings(s1.getRoom(), s2.getRoom());
                }
            }
            return 0;
        }

        protected int comparePreferences(List<InstructorInterface.PreferenceInfo> p1, List<InstructorInterface.PreferenceInfo> p2) {
            Iterator<InstructorInterface.PreferenceInfo> i1 = p1.iterator();
            Iterator<InstructorInterface.PreferenceInfo> i2 = p2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                int cmp = i1.next().compareTo(i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            if (i2.hasNext()) {
                return -1;
            }
            if (i1.hasNext()) {
                return 1;
            }
            return i1.hasNext() ? 1 : (i2.hasNext() ? -1 : 0);
        }

        private int compareByColumn(COLUMN column, SingleTeachingAssingment a1, SingleTeachingAssingment a2) {
            InstructorInterface.TeachingRequestInfo r1 = a1.getRequest();
            InstructorInterface.TeachingRequestInfo r2 = a2.getRequest();
            InstructorInterface.InstructorInfo i1 = a1.getInstructor();
            InstructorInterface.InstructorInfo i2 = a2.getInstructor();
            if (column.isHasInstructor() && i1 == null && i2 == null) {
                i1 = a1.getBaseInstructor();
                i2 = a2.getBaseInstructor();
            }
            if (column.isHasInstructor() && (i1 == null || i2 == null)) {
                return this.compareBooleans(i1 == null, i2 == null);
            }
            switch (column) {
                case COURSE: {
                    return this.compareOthers(r1.getCourse(), r2.getCourse());
                }
                case SECTION: 
                case TIME: 
                case DATE: 
                case ROOM: {
                    Iterator<InstructorInterface.SectionInfo> it1 = r1.getSections().iterator();
                    Iterator<InstructorInterface.SectionInfo> it2 = r2.getSections().iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        int cmp = this.compareSections(column, it1.next(), it2.next());
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    if (it2.hasNext()) {
                        return -1;
                    }
                    if (it1.hasNext()) {
                        return 1;
                    }
                    return it1.hasNext() ? 1 : (it2.hasNext() ? -1 : 0);
                }
                case ASSIGNED_LOAD: {
                    int cmp = this.compareNumbers(Float.valueOf(i1.getAssignedLoad()), Float.valueOf(i2.getAssignedLoad()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return this.compareNumbers(Float.valueOf(i1.getMaxLoad()), Float.valueOf(i2.getMaxLoad()));
                }
                case NAME: {
                    return this.compareStrings(i1.getInstructorName(), i2.getInstructorName());
                }
                case EXTERNAL_ID: {
                    return this.compareStrings(i1.getExternalId(), i2.getExternalId());
                }
                case LOAD: {
                    return this.compareNumbers(Float.valueOf(r1.getLoad()), Float.valueOf(r2.getLoad()));
                }
                case OBJECTIVES: {
                    TreeSet<String> keys = new TreeSet<String>(i1.getValues().keySet());
                    keys.addAll(i2.getValues().keySet());
                    for (String key : keys) {
                        Double d2;
                        Double d = i1.getValues().get(key);
                        int cmp = this.compareNumbers(d, d2 = i2.getValues().get(key));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTES: {
                    TreeSet<String> attributes = new TreeSet<String>();
                    for (InstructorInterface.AttributeInterface attributeInterface : i1.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (InstructorInterface.AttributeInterface attributeInterface : i2.getAttributes()) {
                        attributes.add(attributeInterface.getName());
                    }
                    for (String string : attributes) {
                        int cmp = this.compareBooleans(i1.hasAttribute(string), i2.hasAttribute(string));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
                case ATTRIBUTE_PREFS: {
                    return this.comparePreferences(r1.getAttributePreferences(), r2.getAttributePreferences());
                }
                case COURSE_PREF: {
                    return this.comparePreferences(i1.getCoursePreferences(), i2.getCoursePreferences());
                }
                case INSTRUCTOR_PREFS: {
                    return this.comparePreferences(r1.getInstructorPreferences(), r2.getInstructorPreferences());
                }
                case DISTRIBUTION_PREF: {
                    return this.comparePreferences(i1.getDistributionPreferences(), i2.getDistributionPreferences());
                }
                case TIME_PREF: {
                    return this.comparePreferences(i1.getTimePreferences(), i2.getTimePreferences());
                }
                case ASSIGNED_INSTRUCTORS: {
                    int cmp = this.compareNumbers(r1.getNrAssignedInstructors(), r2.getNrAssignedInstructors());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return -this.compareNumbers(r1.getNrInstructors(), r2.getNrInstructors());
                }
            }
            return 0;
        }

        @Override
        public int compare(SingleTeachingAssingment a1, SingleTeachingAssingment a2) {
            int cmp = this.compareByColumn(this.iColumn, a1, a2);
            if (cmp != 0) {
                return cmp;
            }
            return a1.getRequest().compareTo(a2.getRequest());
        }

        protected int compareStrings(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        protected int compareNumbers(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        protected int compareBooleans(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }

        protected int compareOthers(Comparable c1, Comparable c2) {
            return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
        }
    }

    public static enum COLUMN {
        COURSE(false),
        SECTION(false),
        TIME(true),
        DATE(true),
        ROOM(true),
        LOAD(true),
        ASSIGNED_INSTRUCTORS(true),
        ATTRIBUTE_PREFS(true),
        INSTRUCTOR_PREFS(true),
        EXTERNAL_ID(true, true, 3),
        NAME(true, true, 3),
        ASSIGNED_LOAD(true, true),
        ATTRIBUTES(true, true),
        COURSE_PREF(true, true),
        TIME_PREF(true, true),
        DISTRIBUTION_PREF(true, true),
        OBJECTIVES(true, true);

        private boolean iCanHide;
        private boolean iHasInstructor;
        private int iColSpan;

        private COLUMN(boolean canHide, boolean hasInstructor, int colSpan) {
            this.iCanHide = canHide;
            this.iHasInstructor = hasInstructor;
            this.iColSpan = colSpan;
        }

        private COLUMN(boolean canHide, boolean hasInstructor) {
            this(canHide, hasInstructor, 1);
        }

        private COLUMN(boolean canHide) {
            this(canHide, false, 1);
        }

        public boolean isVisible(boolean assigned) {
            return assigned || !this.iHasInstructor;
        }

        public boolean isHasInstructor() {
            return this.iHasInstructor;
        }

        public boolean isCanHide() {
            return this.iCanHide;
        }

        public int flag() {
            return 1 << this.ordinal();
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public int getColIndex() {
            int ret = 0;
            for (int i = 0; i < this.ordinal(); ++i) {
                ret += COLUMN.values()[i].getColSpan();
            }
            return ret;
        }
    }
}

