/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class SolverGroupEditForm
extends ActionForm {
    private static final long serialVersionUID = 150007237399797836L;
    private String iOp;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private boolean iDepartmentsEditable;
    private List iDepartmentIds;
    private List iDepartmentNames;
    private List iAssignedDepartments;
    private List iManagerIds;
    private List iManagerNames;
    private List iAssignedManagers;
    protected DynamicListObjectFactory iDynamicListFactory = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("-");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors;
        block11: {
            errors = new ActionErrors();
            try {
                SolverGroup g;
                Long sessionId = HttpSessionContext.getSessionContext(request.getSession().getServletContext()).getUser().getCurrentAcademicSessionId();
                if (this.iName == null || this.iName.trim().length() == 0) {
                    errors.add("name", new ActionMessage("errors.required", (Object)""));
                } else {
                    try {
                        g = SolverGroup.findBySessionIdName(sessionId, this.iName);
                        if (g != null && !g.getUniqueId().equals(this.iUniqueId)) {
                            errors.add("name", new ActionMessage("errors.exists", (Object)this.iName));
                        }
                    }
                    catch (Exception e) {
                        errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    }
                }
                if (this.iAbbv == null || this.iAbbv.trim().length() == 0) {
                    errors.add("abbv", new ActionMessage("errors.required", (Object)""));
                    break block11;
                }
                try {
                    g = SolverGroup.findBySessionIdAbbv(sessionId, this.iAbbv);
                    if (g != null && !g.getUniqueId().equals(this.iUniqueId)) {
                        errors.add("abbv", new ActionMessage("errors.exists", (Object)this.iAbbv));
                    }
                }
                catch (Exception e) {
                    errors.add("abbv", new ActionMessage("errors.generic", (Object)e.getMessage()));
                }
            }
            catch (Exception e) {
                Debug.error(e);
                errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iUniqueId = null;
        this.iName = null;
        this.iAbbv = null;
        this.iAssignedDepartments = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iAssignedManagers = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iManagerIds = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iManagerNames = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iDepartmentIds = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iDepartmentNames = DynamicList.getInstance(new Vector(), this.iDynamicListFactory);
        this.iDepartmentsEditable = false;
    }

    public void load(SolverGroup group, Session session) throws Exception {
        TreeSet<Department> departments = Department.findAllBeingUsed(session.getUniqueId());
        TreeSet managers = new TreeSet(new TimetableManagerDAO().findAll());
        this.iDepartmentIds.clear();
        this.iDepartmentNames.clear();
        this.iManagerIds.clear();
        this.iManagerNames.clear();
        this.iAssignedDepartments.clear();
        this.iAssignedManagers.clear();
        this.iDepartmentsEditable = true;
        if (group == null) {
            this.iUniqueId = new Long(-1L);
            this.iName = null;
            this.iAbbv = null;
            this.iOp = "Save";
            for (Department d : departments) {
                if (d.getSolverGroup() != null) continue;
                this.iAssignedDepartments.add(Boolean.FALSE);
                this.iDepartmentIds.add(d.getUniqueId().toString());
                this.iDepartmentNames.add(d.getDeptCode() + " - " + d.getName());
            }
            for (TimetableManager m : managers) {
                this.iAssignedManagers.add(Boolean.FALSE);
                this.iManagerIds.add(m.getUniqueId().toString());
                String deptStr = "";
                Iterator j = new TreeSet(m.departmentsForSession(session.getUniqueId())).iterator();
                while (j.hasNext()) {
                    Department d = (Department)j.next();
                    deptStr = deptStr + "<span title='" + d.getDeptCode() + " - " + d.getName() + "'>" + d.getDeptCode() + "</span>";
                    if (!j.hasNext()) continue;
                    deptStr = deptStr + ", ";
                }
                this.iManagerNames.add(m.getName() + (deptStr.length() == 0 ? "" : " (" + deptStr + ")"));
            }
        } else {
            this.iUniqueId = group.getUniqueId();
            this.iName = group.getName();
            this.iAbbv = group.getAbbv();
            this.iOp = "Update";
            Iterator i = departments.iterator();
            while (i.hasNext()) {
                Department d = (Department)i.next();
                if (group.equals(d.getSolverGroup())) {
                    this.iAssignedDepartments.add(Boolean.TRUE);
                    this.iDepartmentIds.add(d.getUniqueId().toString());
                    this.iDepartmentNames.add(d.getDeptCode() + " - " + d.getName());
                    continue;
                }
                if (d.getSolverGroup() == null) {
                    this.iAssignedDepartments.add(Boolean.FALSE);
                    this.iDepartmentIds.add(d.getUniqueId().toString());
                    this.iDepartmentNames.add(d.getDeptCode() + " - " + d.getName());
                    continue;
                }
                i.remove();
            }
            for (TimetableManager m : managers) {
                String deptStr = "";
                Iterator j = new TreeSet(m.departmentsForSession(session.getUniqueId())).iterator();
                while (j.hasNext()) {
                    Department d = (Department)j.next();
                    deptStr = deptStr + "<span title='" + d.getDeptCode() + " - " + d.getName() + "'>" + d.getDeptCode() + "</span>";
                    if (!j.hasNext()) continue;
                    deptStr = deptStr + ", ";
                }
                this.iManagerIds.add(m.getUniqueId().toString());
                this.iManagerNames.add(m.getName() + (deptStr.length() == 0 ? "" : " (" + deptStr + ")"));
                if (group.getTimetableManagers().contains(m)) {
                    this.iAssignedManagers.add(Boolean.TRUE);
                    continue;
                }
                this.iAssignedManagers.add(Boolean.FALSE);
            }
            if (!group.getSolutions().isEmpty()) {
                this.iDepartmentsEditable = false;
            }
        }
    }

    public SolverGroup saveOrUpdate(org.hibernate.Session hibSession, SessionContext context) throws Exception {
        SolverGroup group = null;
        if (this.iUniqueId >= 0L) {
            group = (SolverGroup)new SolverGroupDAO().get(this.iUniqueId);
        }
        if (group == null) {
            group = this.create(hibSession, context.getUser().getCurrentAcademicSessionId());
            ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.CREATE, null, null);
        } else {
            this.update(group, hibSession);
            ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        return group;
    }

    public SolverGroup create(org.hibernate.Session hibSession, Long sessionId) throws Exception {
        SolverGroup group = new SolverGroup();
        group.setName(this.iName);
        group.setAbbv(this.iAbbv);
        Session session = (Session)new SessionDAO().get(sessionId, hibSession);
        group.setSession(session);
        HashSet<Department> newDepartments = new HashSet<Department>();
        for (int i = 0; i < this.iAssignedDepartments.size(); ++i) {
            String add;
            String deptId = (String)this.iDepartmentIds.get(i);
            Department dept = (Department)new DepartmentDAO().get(Long.valueOf(deptId), hibSession);
            if (dept == null || !"on".equals(add = (String)this.iAssignedDepartments.get(i)) && !"true".equals(add) && !"1".equals(add)) continue;
            newDepartments.add(dept);
        }
        group.setDepartments(newDepartments);
        HashSet<TimetableManager> newManagers = new HashSet<TimetableManager>();
        for (int i = 0; i < this.iAssignedManagers.size(); ++i) {
            String add;
            String mgrId = (String)this.iManagerIds.get(i);
            TimetableManager mgr = (TimetableManager)new TimetableManagerDAO().get(Long.valueOf(mgrId), hibSession);
            if (mgr == null || !"on".equals(add = (String)this.iAssignedManagers.get(i)) && !"true".equals(add) && !"1".equals(add)) continue;
            newManagers.add(mgr);
        }
        group.setTimetableManagers(newManagers);
        group.setSolutions(new HashSet<Solution>());
        hibSession.save((Object)group);
        for (Department d : newDepartments) {
            d.setSolverGroup(group);
            hibSession.saveOrUpdate((Object)d);
        }
        for (TimetableManager mgr : newManagers) {
            mgr.getSolverGroups().add(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        this.iUniqueId = group.getUniqueId();
        return group;
    }

    public void update(SolverGroup group, org.hibernate.Session hibSession) throws Exception {
        String add;
        group.setName(this.iName);
        group.setAbbv(this.iAbbv);
        if (this.iDepartmentsEditable) {
            HashSet<Department> oldDepartments = new HashSet<Department>(group.getDepartments());
            for (int i = 0; i < this.iAssignedDepartments.size(); ++i) {
                String deptId = (String)this.iDepartmentIds.get(i);
                Department dept = (Department)new DepartmentDAO().get(Long.valueOf(deptId), hibSession);
                if (dept == null || !"on".equals(add = (String)this.iAssignedDepartments.get(i)) && !"true".equals(add) && !"1".equals(add) || oldDepartments.remove(dept)) continue;
                group.getDepartments().add(dept);
                dept.setSolverGroup(group);
                hibSession.saveOrUpdate((Object)dept);
            }
            for (Department dept : oldDepartments) {
                group.getDepartments().remove(dept);
                dept.setSolverGroup(null);
                hibSession.saveOrUpdate((Object)dept);
            }
        }
        HashSet<TimetableManager> oldManagers = new HashSet<TimetableManager>(group.getTimetableManagers());
        for (int i = 0; i < this.iAssignedManagers.size(); ++i) {
            String mgrId = (String)this.iManagerIds.get(i);
            TimetableManager mgr = (TimetableManager)new TimetableManagerDAO().get(Long.valueOf(mgrId), hibSession);
            if (mgr == null || !"on".equals(add = (String)this.iAssignedManagers.get(i)) && !"true".equals(add) && !"1".equals(add) || oldManagers.remove(mgr)) continue;
            group.getTimetableManagers().add(mgr);
        }
        for (TimetableManager mgr : oldManagers) {
            group.getTimetableManagers().remove(mgr);
            mgr.getSolverGroups().remove(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        hibSession.saveOrUpdate((Object)group);
        hibSession.flush();
        hibSession.refresh((Object)group);
        Iterator<Comparable> i = group.getDepartments().iterator();
        while (i.hasNext()) {
            hibSession.refresh((Object)i.next());
        }
        i = group.getTimetableManagers().iterator();
        while (i.hasNext()) {
            hibSession.refresh((Object)i.next());
        }
    }

    public void delete(org.hibernate.Session hibSession, SessionContext context) throws Exception {
        if (this.iUniqueId < 0L) {
            return;
        }
        if (!this.iDepartmentsEditable) {
            return;
        }
        SolverGroup group = (SolverGroup)new SolverGroupDAO().get(this.iUniqueId);
        if (group == null) {
            return;
        }
        for (Department dept : group.getDepartments()) {
            dept.setSolverGroup(null);
            hibSession.saveOrUpdate((Object)dept);
        }
        for (TimetableManager mgr : group.getTimetableManagers()) {
            mgr.getSolverGroups().remove(group);
            hibSession.saveOrUpdate((Object)mgr);
        }
        ChangeLog.addChange(hibSession, context, group, ChangeLog.Source.SOLVER_GROUP_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)group);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public boolean getDepartmentsEditable() {
        return this.iDepartmentsEditable;
    }

    public void setDepartmentsEditable(boolean departmentsEditable) {
        this.iDepartmentsEditable = departmentsEditable;
    }

    public List getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(List departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public List getDepartmentNames() {
        return this.iDepartmentNames;
    }

    public void setDepartmentNames(List departmentNames) {
        this.iDepartmentNames = departmentNames;
    }

    public List getAssignedDepartments() {
        return this.iAssignedDepartments;
    }

    public void setAssignedDepartments(List assignedDepartments) {
        this.iAssignedDepartments = assignedDepartments;
    }

    public List getManagerIds() {
        return this.iManagerIds;
    }

    public void setManagerIds(List managerIds) {
        this.iManagerIds = managerIds;
    }

    public List getManagerNames() {
        return this.iManagerNames;
    }

    public void setManagerNames(List managerNames) {
        this.iManagerNames = managerNames;
    }

    public List getAssignedManagers() {
        return this.iAssignedManagers;
    }

    public void setAssignedManagers(List assignedManagers) {
        this.iAssignedManagers = assignedManagers;
    }
}

