/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.JProf;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.QueryLog;
import org.unitime.timetable.model.dao.QueryLogDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.spring.gwt.GwtDispatcherServlet;

public class QueryLogFilter
implements Filter {
    private static Log sLog = LogFactory.getLog(QueryLogFilter.class);
    private Saver iSaver;
    private HashSet<String> iExclude = new HashSet();
    private Gson iGson = null;

    public void init(FilterConfig cfg) throws ServletException {
        this.iSaver = new Saver();
        this.iSaver.start();
        String exclude = cfg.getInitParameter("exclude");
        if (exclude != null) {
            for (String x : exclude.split(",")) {
                this.iExclude.add(x);
            }
        }
        this.iGson = new GsonBuilder().create();
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    private String getUserIdFromToken(ServletContext context, String token) {
        ApiToken apiToken = context == null ? null : (ApiToken)WebApplicationContextUtils.getWebApplicationContext((ServletContext)context).getBean("apiToken");
        return apiToken == null ? null : apiToken.getUserId(token);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Object ex;
        String sessionId = null;
        String userId = null;
        try {
            if (request instanceof HttpServletRequest) {
                String token;
                HttpServletRequest r = (HttpServletRequest)request;
                sessionId = r.getSession().getId();
                UserContext user = this.getUser();
                if (user != null) {
                    userId = user.getTrueExternalUserId();
                }
                if ((user == null || user instanceof AnonymousUserContext) && (token = request.getParameter("token")) != null && ApplicationProperty.ApiCanUseAPIToken.isTrue()) {
                    userId = this.getUserIdFromToken(request.getServletContext(), token);
                }
            }
        }
        catch (IllegalStateException r) {
        }
        catch (IllegalArgumentException r) {
            // empty catch block
        }
        long t0 = JProf.currentTimeMillis();
        Throwable exception = null;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            exception = t;
        }
        long t1 = JProf.currentTimeMillis();
        if (exception == null && (ex = request.getAttribute("__exception")) != null && ex instanceof Throwable) {
            exception = (Throwable)ex;
        }
        if (request instanceof HttpServletRequest) {
            Object params;
            HttpServletRequest r = (HttpServletRequest)request;
            QueryLog q = new QueryLog();
            String uri = r.getRequestURI();
            if (uri.indexOf(47) >= 0) {
                uri = uri.substring(uri.lastIndexOf(47) + 1);
            }
            if (uri.endsWith(".do")) {
                q.setType(QueryLog.Type.STRUCTS.ordinal());
            } else if (uri.endsWith(".gwt")) {
                q.setType(QueryLog.Type.GWT.ordinal());
            } else {
                q.setType(QueryLog.Type.OTHER.ordinal());
            }
            q.setUri(uri);
            q.setTimeStamp(new Date());
            q.setTimeSpent(t1 - t0);
            q.setSessionId(sessionId);
            q.setUid(userId);
            try {
                UserContext user;
                if (sessionId == null) {
                    q.setSessionId(r.getSession().getId());
                }
                if (userId == null && (user = this.getUser()) != null) {
                    q.setUid(user.getTrueExternalUserId());
                }
            }
            catch (IllegalStateException user) {
                // empty catch block
            }
            GwtDispatcherServlet.GwtCallInfo callInfo = GwtDispatcherServlet.getLastQuery();
            if (callInfo != null) {
                q.setQuery(callInfo.getQuery());
                q.setUri(q.getUri() + ": " + callInfo.getTarget());
            } else if (ApplicationProperty.QueryLogJSON.isTrue()) {
                try {
                    params = new HashMap();
                    for (Map.Entry e : r.getParameterMap().entrySet()) {
                        if ("password".equals(e.getKey()) || "noCacheTS".equals(e.getKey()) || e.getValue() == null || ((String[])e.getValue()).length == 0) continue;
                        if (((String[])e.getValue()).length == 1) {
                            params.put(e.getKey(), ((String[])e.getValue())[0]);
                            continue;
                        }
                        params.put(e.getKey(), e.getValue());
                    }
                    q.setQuery(this.iGson.toJson(params));
                }
                catch (Throwable params2) {}
            } else {
                params = "";
                Enumeration e = r.getParameterNames();
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    if ("password".equals(n) || "noCacheTS".equals(n)) continue;
                    if (!((String)params).isEmpty()) {
                        params = (String)params + "&";
                    }
                    params = (String)params + n + "=" + r.getParameter(n);
                }
                if (!((String)params).isEmpty()) {
                    q.setQuery((String)params);
                }
            }
            if (exception != null) {
                String ex2 = "";
                for (Throwable t = exception; t != null; t = t.getCause()) {
                    String clazz = t.getClass().getName();
                    if (clazz.indexOf(46) >= 0) {
                        clazz = clazz.substring(1 + clazz.lastIndexOf(46));
                    }
                    if (!ex2.isEmpty()) {
                        ex2 = ex2 + "\n";
                    }
                    ex2 = ex2 + clazz + ": " + t.getMessage();
                    if (t.getStackTrace() == null || t.getStackTrace().length <= 0) continue;
                    ex2 = ex2 + " (at " + t.getStackTrace()[0].getFileName() + ":" + t.getStackTrace()[0].getLineNumber() + ")";
                }
                if (!ex2.isEmpty()) {
                    q.setException(ex2);
                }
            }
            if (!(this.iExclude.contains(q.getUri()) && q.getException() == null || this.iSaver == null)) {
                this.iSaver.add(q);
            }
        }
        if (exception != null) {
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new ServletException(exception);
        }
    }

    public void destroy() {
        if (this.iSaver != null) {
            this.iSaver.interrupt();
        }
    }

    public static class Saver
    extends Thread {
        private List<QueryLog> iQueries = new Vector<QueryLog>();
        private boolean iActive = true;
        private int iLogLimit = ApplicationProperty.QueryLogLimit.intValue();

        public Saver() {
            super("QueryLogSaver");
            this.setDaemon(true);
        }

        @Override
        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(QueryLog q) {
            if (!this.iActive) {
                return;
            }
            List<QueryLog> list = this.iQueries;
            synchronized (list) {
                if (this.iLogLimit <= 0 || this.iQueries.size() < this.iLogLimit) {
                    this.iQueries.add(q);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            sLog.debug((Object)"Query Log Saver is up.");
            while (true) {
                try {
                    do {
                        try {
                            Saver.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ArrayList<QueryLog> queriesToSave = null;
                        List<QueryLog> list = this.iQueries;
                        synchronized (list) {
                            if (!this.iQueries.isEmpty()) {
                                queriesToSave = new ArrayList<QueryLog>(this.iQueries);
                                this.iQueries.clear();
                            }
                        }
                        if (queriesToSave == null) continue;
                        sLog.debug((Object)("Persisting " + queriesToSave.size() + " log entries..."));
                        if (this.iLogLimit > 0 && queriesToSave.size() >= this.iLogLimit) {
                            sLog.warn((Object)("The limit of " + this.iLogLimit + " unpersisted log messages was reached, some messages have been dropped."));
                        }
                        Session hibSession = QueryLogDAO.getInstance().createNewSession();
                        hibSession.setCacheMode(CacheMode.IGNORE);
                        Transaction tx = hibSession.beginTransaction();
                        try {
                            for (QueryLog q : queriesToSave) {
                                hibSession.save((Object)q);
                            }
                            hibSession.flush();
                            tx.commit();
                        }
                        catch (Exception e) {
                            tx.rollback();
                            sLog.error((Object)("Failed to persist " + queriesToSave.size() + " log entries:" + e.getMessage()), (Throwable)e);
                        }
                        finally {
                            hibSession.close();
                        }
                    } while (this.iActive);
                }
                catch (Exception e) {
                    sLog.error((Object)("Failed to persist log entries:" + e.getMessage()), (Throwable)e);
                    continue;
                }
                break;
            }
            sLog.debug((Object)"Query Log Saver is down.");
        }
    }
}

