/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.TilesUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;

public class PageAccessFilter
implements Filter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(PageAccessFilter.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    private ServletContext iContext;
    private Hashtable<String, String> iPath2Tile = new Hashtable();
    private long debugTime = 30000L;
    private long dumpTime = 300000L;
    private boolean dumpSessionAttribues = false;

    public void init(FilterConfig cfg) throws ServletException {
        this.iContext = cfg.getServletContext();
        try {
            Document config = new SAXReader().read(cfg.getServletContext().getResource(cfg.getInitParameter("config")));
            Iterator i = config.getRootElement().element("action-mappings").elementIterator("action");
            while (i.hasNext()) {
                Element action = (Element)i.next();
                String path = action.attributeValue("path");
                String input = action.attributeValue("input");
                if (path == null || input == null) continue;
                this.iPath2Tile.put(path + ".do", input);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to read config " + cfg.getInitParameter("config") + ", reason: " + e.getMessage()));
        }
        if (cfg.getInitParameter("debug-time") != null) {
            this.debugTime = Long.parseLong(cfg.getInitParameter("debug-time"));
        }
        if (cfg.getInitParameter("dump-time") != null) {
            this.dumpTime = Long.parseLong(cfg.getInitParameter("dump-time"));
        }
        if (cfg.getInitParameter("session-attributes") != null) {
            this.dumpSessionAttribues = Boolean.parseBoolean(cfg.getInitParameter("session-attributes"));
        }
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block33: {
            block29: {
                block32: {
                    block30: {
                        block31: {
                            t0 = System.currentTimeMillis();
                            user = this.getUser();
                            if (user != null) {
                                ApplicationProperties.setSessionId(user.getCurrentAcademicSessionId());
                            }
                            if (!(request instanceof HttpServletRequest) || !(r = (HttpServletRequest)request).getRequestURI().endsWith(".do")) ** GOTO lbl42
                            x = (HttpServletResponse)response;
                            def = r.getRequestURI().substring(r.getContextPath().length());
                            if (!this.iPath2Tile.containsKey(def)) break block29;
                            tile = this.iPath2Tile.get(def);
                            c = TilesUtil.getDefinition((String)tile, (ServletRequest)request, (ServletContext)this.iContext);
                            s = r.getSession();
                            if (c == null || !"true".equals(c.getAttribute("checkLogin")) || user != null) break block30;
                            PageAccessFilter.sLog.warn((Object)("Page " + r.getRequestURI() + " denied: user not logged in"));
                            if (s.isNew()) {
                                x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + PageAccessFilter.MESSAGES.authenticationExpired()));
                                break block31;
                            }
                            x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + PageAccessFilter.MESSAGES.authenticationRequired()));
                        }
                        ApplicationProperties.setSessionId(null);
                        return;
                    }
                    if (c == null || !"true".equals(c.getAttribute("checkRole")) || user != null && user.getCurrentAuthority() != null && user.getCurrentAuthority().hasRight(Right.HasRole)) break block32;
                    PageAccessFilter.sLog.warn((Object)("Page " + r.getRequestURI() + " denined: no role"));
                    x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + PageAccessFilter.MESSAGES.authenticationInsufficient()));
                    ApplicationProperties.setSessionId(null);
                    return;
                }
                if (c == null || !"true".equals(c.getAttribute("checkAdmin")) || user != null && user.getCurrentAuthority() != null && user.getCurrentAuthority().hasRight(Right.IsAdmin)) break block29;
                PageAccessFilter.sLog.warn((Object)("Page " + r.getRequestURI() + " denied: user not admin"));
                x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + PageAccessFilter.MESSAGES.authenticationInsufficient()));
                ApplicationProperties.setSessionId(null);
                return;
            }
            try {
                block34: {
                    break block34;
                    {
                        catch (Exception e) {
                            PageAccessFilter.sLog.warn((Object)("Unable to check page access for " + r.getRequestURI() + ", reason: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                exception = null;
                try {
                    chain.doFilter(request, response);
                }
                catch (Throwable t) {
                    exception = t;
                }
                t1 = System.currentTimeMillis();
                if (request instanceof HttpServletRequest && (t1 - t0 > this.debugTime || exception != null)) {
                    r = (HttpServletRequest)request;
                    message = "Page " + r.getRequestURI() + " took " + PageAccessFilter.sDF.format((double)(t1 - t0) / 1000.0) + " s.";
                    if (exception != null) {
                        message = exception + " seen on page " + r.getRequestURI() + " (page took " + PageAccessFilter.sDF.format((double)(t1 - t0) / 1000.0) + " s).";
                    }
                    if (exception != null || t1 - t0 > this.dumpTime) {
                        u = null;
                        try {
                            u = this.getUser();
                        }
                        catch (IllegalStateException var13_15) {
                            // empty catch block
                        }
                        message = u == null ? message + "\n  User: no user" : message + "\n  User: " + u.getUsername() + (u.getCurrentAuthority() != null ? " (" + u.getCurrentAuthority() + ")" : "");
                        message = message + "\n  Request parameters:";
                        e = r.getParameterNames();
                        while (e.hasMoreElements()) {
                            n = (String)e.nextElement();
                            if ("password".equals(n)) continue;
                            message = message + "\n    " + n + "=" + r.getParameter(n);
                        }
                        try {
                            if (!this.dumpSessionAttribues || r.getSession() == null) ** GOTO lbl84
                            message = message + "\n  Session attributes:";
                            e = r.getSession().getAttributeNames();
                            while (e.hasMoreElements()) {
                                n = (String)e.nextElement();
                                message = message + "\n    " + n + "=" + r.getSession().getAttribute(n);
                            }
                        }
                        catch (IllegalStateException e) {
                            message = message + "\n    INVALID SESSION";
                        }
                    } else {
                        u = this.getUser();
                        message = u == null ? message + "  (User: no user)" : message + "  (User: " + u.getUsername() + (u.getCurrentAuthority() != null ? " (" + u.getCurrentAuthority() + ")" : "");
                    }
lbl84:
                    // 4 sources

                    if (exception != null) {
                        PageAccessFilter.sLog.warn((Object)message);
                    } else {
                        PageAccessFilter.sLog.info((Object)message);
                    }
                }
                if (exception == null) break block33;
                if (exception instanceof PageAccessException && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                    r = (HttpServletRequest)request;
                    x = (HttpServletResponse)response;
                    message = exception.getMessage();
                    if (message == null || message.isEmpty()) {
                        s = r.getSession();
                        message = this.getUser() == null ? (s.isNew() ? PageAccessFilter.MESSAGES.authenticationExpired() : PageAccessFilter.MESSAGES.authenticationRequired()) : PageAccessFilter.MESSAGES.authenticationInsufficient();
                    }
                    x.sendRedirect(x.encodeURL(r.getContextPath() + "/loginRequired.do?message=" + message));
                    break block33;
                }
                if (exception instanceof ServletException) {
                    throw (ServletException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new ServletException(exception);
            }
            catch (Throwable var15_19) {
                throw var15_19;
            }
            finally {
                ApplicationProperties.setSessionId(null);
            }
        }
    }

    public void destroy() {
    }
}

