/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import com.lowagie.text.Image;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.rooms.RoomsExporter;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomPicture;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomPictureDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="org.unitime.timetable.export.Exporter:rooms.pdf")
public class RoomsExportPDF
extends RoomsExporter {
    @Override
    public String reference() {
        return "rooms.pdf";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.RoomDetailInterface> rooms, RoomsExporter.ExportContext context) throws IOException {
        helper.getSessionContext().checkPermission(Right.RoomsExportPdf);
        ArrayList<RoomsExporter.Column> columns = new ArrayList<RoomsExporter.Column>();
        for (RoomInterface.RoomsColumn column : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(column, context);
            for (int idx = 0; idx < nrCells; ++idx) {
                RoomsExporter.Column c = new RoomsExporter.Column(column, idx);
                if (!this.isColumnVisible(c, context)) continue;
                columns.add(c);
            }
        }
        PDFPrinter printer = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), this.reference(), false);
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((RoomsExporter.Column)columns.get(i), context).replace("<br>", "\n");
        }
        printer.printHeader(header);
        printer.flush();
        for (RoomInterface.RoomDetailInterface room : rooms) {
            PDFPrinter.A[] row = new PDFPrinter.A[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                row[i] = this.getCell(room, (RoomsExporter.Column)columns.get(i), context);
            }
            printer.printLine(row);
            printer.flush();
        }
        printer.close();
    }

    @Override
    protected boolean isColumnVisible(RoomsExporter.Column column, RoomsExporter.ExportContext context) {
        switch (column.getColumn()) {
            case PICTURES: {
                if (column.getIndex() <= 0 || context.getPictureTypes().get(column.getIndex() - 1).isImage()) break;
                return false;
            }
        }
        return super.isColumnVisible(column, context);
    }

    protected PDFPrinter.A getCell(RoomInterface.RoomDetailInterface room, RoomsExporter.Column column, RoomsExporter.ExportContext context) {
        switch (column.getColumn()) {
            case NAME: {
                PDFPrinter.A a = new PDFPrinter.A(room.hasDisplayName() ? MESSAGES.label(room.getLabel(), room.getDisplayName()) : room.getLabel(), new PDFPrinter.F[0]);
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    if (!d.getDeptCode().equals(context.getDepartment()) || d.getPreference() == null) continue;
                    a.setColor(d.getPreference().getColor());
                }
                return a;
            }
            case EXTERNAL_ID: {
                return new PDFPrinter.A(room.hasExternalId() ? room.getExternalId() : "", new PDFPrinter.F[0]);
            }
            case TYPE: {
                return new PDFPrinter.A(room.getRoomType().getLabel(), new PDFPrinter.F[0]);
            }
            case CAPACITY: {
                return new PDFPrinter.A((Number)(room.getCapacity() == null ? 0 : room.getCapacity()), new PDFPrinter.F[0]).right();
            }
            case EXAM_CAPACITY: {
                return new PDFPrinter.A((Number)room.getExamCapacity(), new PDFPrinter.F[0]).right();
            }
            case AREA: {
                return new PDFPrinter.A((Number)room.getArea(), context.getAreaFormat(), new PDFPrinter.F[0]).right();
            }
            case COORDINATES: {
                return new PDFPrinter.A(room.hasCoordinates() ? context.getCoordinateFormat().format(room.getX()) + "," + context.getCoordinateFormat().format(room.getY()) : "", new PDFPrinter.F[0]);
            }
            case ROOM_CHECK: {
                return new PDFPrinter.A(room.isIgnoreRoomCheck() ? MESSAGES.exportFalse() : MESSAGES.exportTrue(), new PDFPrinter.F[0]);
            }
            case DISTANCE_CHECK: {
                return new PDFPrinter.A(room.isIgnoreTooFar() ? MESSAGES.exportFalse() : MESSAGES.exportTrue(), new PDFPrinter.F[0]);
            }
            case PREFERENCE: {
                if (!room.hasDepartments()) {
                    return new PDFPrinter.A();
                }
                PDFPrinter.A a = new PDFPrinter.A();
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    if (d.getPreference() == null) continue;
                    a.add(new PDFPrinter.A(d.getPreference().getAbbv() + " " + context.dept2string(d, true), new PDFPrinter.F[0]).color(d.getPreference().getColor()));
                }
                return a;
            }
            case MAP: {
                if (room.hasMiniMapUrl()) {
                    try {
                        Image image = Image.getInstance((URL)new URL(room.getMiniMapUrl()));
                        image.scaleToFit(150.0f, 100.0f);
                        image.setBorder(15);
                        image.setBorderWidth(1.0f);
                        image.setBorderColor(new Color(Integer.parseInt("9CB0CE", 16)));
                        return new PDFPrinter.A(image);
                    }
                    catch (Exception e) {
                        return new PDFPrinter.A();
                    }
                }
                return new PDFPrinter.A();
            }
            case PICTURES: {
                RoomInterface.AttachmentTypeInterface type;
                RoomInterface.AttachmentTypeInterface attachmentTypeInterface = type = column.getIndex() == 0 ? null : context.getPictureTypes().get(column.getIndex() - 1);
                if (room.hasPictures(type)) {
                    PDFPrinter.A a = new PDFPrinter.A();
                    for (RoomInterface.RoomPictureInterface picture : room.getPictures(type)) {
                        RoomPicture rp = (RoomPicture)RoomPictureDAO.getInstance().get(picture.getUniqueId());
                        if (rp == null) continue;
                        try {
                            Image image = Image.getInstance((byte[])rp.getDataFile());
                            image.scaleToFit(150.0f, 100.0f);
                            image.setBorder(15);
                            image.setBorderWidth(1.0f);
                            image.setBorderColor(new Color(Integer.parseInt("9CB0CE", 16)));
                            a.add(new PDFPrinter.A(image));
                        }
                        catch (Exception exception) {}
                    }
                    return a;
                }
                return new PDFPrinter.A();
            }
            case AVAILABILITY: {
                return this.availability(room, false, context);
            }
            case DEPARTMENTS: {
                if (!room.hasDepartments()) {
                    return new PDFPrinter.A();
                }
                if (context.isAllDepartments(room.getDepartments())) {
                    return new PDFPrinter.A(MESSAGES.departmentsAllLabel(), new PDFPrinter.F[0]).set(PDFPrinter.F.ITALIC);
                }
                PDFPrinter.A a = new PDFPrinter.A();
                for (RoomInterface.DepartmentInterface d : room.getDepartments()) {
                    PDFPrinter.A b = new PDFPrinter.A(context.dept2string(d, true), new PDFPrinter.F[0]).color(d.getColor());
                    if (d.equals(room.getControlDepartment())) {
                        b.underline();
                    }
                    a.add(b);
                }
                return a;
            }
            case CONTROL_DEPT: {
                return new PDFPrinter.A(context.dept2string(room.getControlDepartment(), true), new PDFPrinter.F[0]).color(room.getControlDepartment() == null ? null : room.getControlDepartment().getColor());
            }
            case EXAM_TYPES: {
                if (!room.hasExamTypes()) {
                    return new PDFPrinter.A();
                }
                PDFPrinter.A a = new PDFPrinter.A();
                for (RoomInterface.ExamTypeInterface t : room.getExamTypes()) {
                    a.add(new PDFPrinter.A(t.getLabel(), new PDFPrinter.F[0]));
                }
                return a;
            }
            case PERIOD_PREF: {
                return this.periodPreferences(room, context);
            }
            case EVENT_DEPARTMENT: {
                return new PDFPrinter.A(context.dept2string(room.getEventDepartment(), false), new PDFPrinter.F[0]).color(room.getEventDepartment() == null ? null : room.getEventDepartment().getColor());
            }
            case EVENT_STATUS: {
                return room.getEventStatus() != null ? new PDFPrinter.A(CONSTANTS.eventStatusAbbv()[room.getEventStatus()], PDFPrinter.F.FIX_BR) : (room.getDefaultEventStatus() != null ? new PDFPrinter.A(CONSTANTS.eventStatusAbbv()[room.getDefaultEventStatus()], PDFPrinter.F.FIX_BR).italic() : new PDFPrinter.A());
            }
            case EVENT_AVAILABILITY: {
                return this.availability(room, true, context);
            }
            case EVENT_MESSAGE: {
                return room.getEventNote() != null ? new PDFPrinter.A(room.getEventNote(), new PDFPrinter.F[0]) : new PDFPrinter.A(room.getDefaultEventNote(), new PDFPrinter.F[0]).italic();
            }
            case BREAK_TIME: {
                return room.getBreakTime() != null ? new PDFPrinter.A(room.getBreakTime().toString(), new PDFPrinter.F[0]) : (room.getDefaultBreakTime() != null ? new PDFPrinter.A(room.getDefaultBreakTime().toString(), new PDFPrinter.F[0]).italic() : new PDFPrinter.A());
            }
            case GROUPS: {
                if (!room.hasGroups()) {
                    return new PDFPrinter.A();
                }
                PDFPrinter.A a = new PDFPrinter.A();
                for (RoomInterface.GroupInterface g : room.getGroups()) {
                    a.add(new PDFPrinter.A(g.getLabel() + (g.getDepartment() == null ? "" : " (" + context.dept2string(g.getDepartment(), true) + ")"), new PDFPrinter.F[0]).color(g.getDepartment() == null ? null : g.getDepartment().getColor()));
                }
                return a;
            }
            case FEATURES: {
                if (column.getIndex() == 0) {
                    return this.features(room.getFeatures(), null, context);
                }
                return this.features(room.getFeatures(), context.getRoomFeatureTypes().get(column.getIndex() - 1), context);
            }
            case SERVICES: {
                if (!room.hasServices()) {
                    return new PDFPrinter.A();
                }
                PDFPrinter.A a = new PDFPrinter.A();
                for (EventInterface.EventServiceProviderInterface s : room.getServices()) {
                    a.add(new PDFPrinter.A(s.getLabel() + (s.getDepartmentId() == null || room.getEventDepartment() == null ? "" : " (" + context.dept2string(room.getEventDepartment(), true) + ")"), new PDFPrinter.F[0]));
                }
                return a;
            }
        }
        return null;
    }

    protected PDFPrinter.A availability(RoomInterface.RoomDetailInterface room, boolean events, RoomsExporter.ExportContext context) {
        PDFPrinter.A ret = null;
        if (context.isGridAsText()) {
            ret = new PDFPrinter.A(events ? room.getEventAvailability() : room.getAvailability(), new PDFPrinter.F[0]);
        } else {
            Location location = (Location)LocationDAO.getInstance().get(room.getUniqueId());
            RequiredTimeTable rtt = events ? location.getEventAvailabilityTable() : location.getRoomSharingTable();
            rtt.getModel().setDefaultSelection(context.getMode());
            ret = new PDFPrinter.A(rtt.createBufferedImage(context.isVertical(), false));
        }
        if (!events && room.getRoomSharingNote() != null) {
            ret.add(new PDFPrinter.A(room.getRoomSharingNote(), new PDFPrinter.F[0]));
        }
        return ret;
    }

    protected PDFPrinter.A periodPreferences(RoomInterface.RoomDetailInterface room, RoomsExporter.ExportContext context) {
        Location location = (Location)LocationDAO.getInstance().get(room.getUniqueId());
        for (ExamType type : location.getExamTypes()) {
            if (!type.getReference().equals(context.getDepartment())) continue;
            if (type.getType() == 1) {
                return new PDFMidtermPeriodPreferenceModel(location, type).toA();
            }
            PDFPeriodPreferenceModel px = new PDFPeriodPreferenceModel(location, type);
            if (context.isGridAsText()) {
                return px.toA();
            }
            return new PDFPrinter.A(new RequiredTimeTable(px).createBufferedImage(true, false));
        }
        return new PDFPrinter.A();
    }

    protected PDFPrinter.A features(Collection<RoomInterface.FeatureInterface> features, RoomInterface.FeatureTypeInterface type, RoomsExporter.ExportContext context) {
        if (features == null || features.isEmpty()) {
            return new PDFPrinter.A();
        }
        PDFPrinter.A a = new PDFPrinter.A();
        for (RoomInterface.FeatureInterface f : features) {
            if (type == null && f.getType() == null) {
                a.add(new PDFPrinter.A(f.getLabel(), new PDFPrinter.F[0]));
            }
            if (type == null || !type.equals(f.getType())) continue;
            if (f.getDepartment() != null) {
                a.add(new PDFPrinter.A(f.getLabel() + " (" + context.dept2string(f.getDepartment(), true) + ")", new PDFPrinter.F[0]).color(f.getDepartment().getColor()));
                continue;
            }
            a.add(new PDFPrinter.A(f.getLabel(), new PDFPrinter.F[0]));
        }
        return a;
    }

    class PDFPeriodPreferenceModel
    extends PeriodPreferenceModel {
        PDFPeriodPreferenceModel(Location location, ExamType type) {
            super(location.getSession(), type.getUniqueId());
            this.load(location);
        }

        PDFPrinter.A toA() {
            PDFPrinter.A ret = new PDFPrinter.A();
            for (int d = 0; d < this.getNrDays(); ++d) {
                String pref = null;
                int a = 0;
                int b = 0;
                for (int t = 0; t < this.getNrTimes(); ++t) {
                    String p = this.getPreference(d, t);
                    if (pref == null || !pref.equals(p)) {
                        if (pref != null && !"@".equals(pref) && !PreferenceLevel.sNeutral.equals(pref)) {
                            ret.add(new PDFPrinter.A(PreferenceLevel.prolog2abbv(pref) + " " + this.getDayHeader(d).replace("<br>", " ") + " " + this.getStartTime(a) + " - " + this.getEndTime(b), new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(pref)));
                        }
                        pref = p;
                        a = b = t;
                        continue;
                    }
                    b = t;
                }
                if (pref == null || "@".equals(pref) || PreferenceLevel.sNeutral.equals(pref)) continue;
                ret.add(new PDFPrinter.A(PreferenceLevel.prolog2abbv(pref) + " " + this.getDayHeader(d).replace("<br>", " ") + " " + this.getStartTime(a) + " - " + this.getEndTime(b), new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(pref)));
            }
            return ret;
        }
    }

    static class PDFMidtermPeriodPreferenceModel
    extends MidtermPeriodPreferenceModel {
        PDFMidtermPeriodPreferenceModel(Location location, ExamType type) {
            super(location.getSession(), type);
            this.load(location);
        }

        List<PDFPrinter.A> toA(int fDate, int lDate, Hashtable<Integer, String> prefs) {
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
            String dates = df.format(this.getDate(fDate)) + (fDate == lDate ? "" : " - " + df.format(this.getDate(lDate)));
            String lastPref = null;
            int fStart = -1;
            int lStart = -1;
            ArrayList<PDFPrinter.A> ret = new ArrayList<PDFPrinter.A>();
            Iterator iterator = this.iStarts.iterator();
            while (iterator.hasNext()) {
                int start = (Integer)iterator.next();
                String pref = prefs.get(start);
                if (pref == null) continue;
                if (lastPref == null) {
                    lastPref = pref;
                    fStart = start;
                } else if (!pref.equals(lastPref)) {
                    if (!(this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
                        String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
                        String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + (Integer)this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
                        ret.add(new PDFPrinter.A(PreferenceLevel.prolog2abbv(lastPref) + " " + dates + " " + (this.iStarts.size() == 2 ? (fStart == (Integer)this.iStarts.first() ? "Early" : "Late") : startTime) + (fStart == lStart ? "" : " - " + endTime), new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(lastPref)));
                    }
                    lastPref = pref;
                    fStart = start;
                }
                lStart = start;
            }
            if (!(lastPref == null || this.iLocation && PreferenceLevel.sNeutral.equals(lastPref) || !this.iLocation && PreferenceLevel.sProhibited.equals(lastPref))) {
                String startTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * fStart + Constants.FIRST_SLOT_TIME_MIN);
                String endTime = Constants.toTime(Constants.SLOT_LENGTH_MIN * (lStart + (Integer)this.iLength.get(lStart)) + Constants.FIRST_SLOT_TIME_MIN);
                if (fStart == (Integer)this.iStarts.first()) {
                    ret.add(new PDFPrinter.A(PreferenceLevel.prolog2abbv(lastPref) + " " + dates, new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(lastPref)));
                } else {
                    ret.add(new PDFPrinter.A(PreferenceLevel.prolog2abbv(lastPref) + " " + dates + " " + (this.iStarts.size() == 2 ? (fStart == (Integer)this.iStarts.first() ? "Early" : "Late") : startTime) + (fStart == lStart ? "" : " - " + endTime), new PDFPrinter.F[0]).color(PreferenceLevel.prolog2color(lastPref)));
                }
            }
            return ret;
        }

        PDFPrinter.A toA() {
            if (this.iStarts.isEmpty()) {
                return new PDFPrinter.A();
            }
            PDFPrinter.A ret = new PDFPrinter.A();
            Hashtable fPref = null;
            int fDate = -1;
            int lDate = -1;
            for (Integer date : this.iDates) {
                Hashtable pref = (Hashtable)this.iPreferences.get(date);
                if (fPref == null) {
                    fPref = pref;
                    fDate = date;
                } else if (!fPref.equals(pref)) {
                    for (PDFPrinter.A b : this.toA(fDate, lDate, fPref)) {
                        ret.add(b);
                    }
                    fPref = pref;
                    fDate = date;
                }
                lDate = date;
            }
            if (fPref != null) {
                for (PDFPrinter.A b : this.toA(fDate, lDate, fPref)) {
                    ret.add(b);
                }
            }
            return ret;
        }
    }
}

