/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.util.Formats;

public class StudentSchedulingStatusImport
extends BaseImport {
    protected Formats.Format<Date> h24 = Formats.getDateFormat("HHmm");
    protected Formats.Format<Date> timeFormat = null;
    protected Formats.Format<Date> dateFormat = null;

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("studentStatuses")) {
            throw new Exception("Given XML file is not a Student Scheduling Statuses load file.");
        }
        try {
            this.beginTransaction();
            Session session = null;
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            if (campus != null && year != null && term != null && (session = Session.getSessionUsingInitiativeYearTerm(campus, year, term)) == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            boolean incremental = "true".equalsIgnoreCase(root.attributeValue("incremental", "true"));
            this.dateFormat = Formats.getDateFormat(root.attributeValue("dateFormat", "yyyy/M/d"));
            this.timeFormat = Formats.getDateFormat(root.attributeValue("timeFormat", "HHmm"));
            HashMap<String, StudentSectioningStatus> statuses = new HashMap<String, StudentSectioningStatus>();
            for (StudentSectioningStatus studentSectioningStatus : StudentSectioningStatus.findAll(session == null ? null : session.getUniqueId())) {
                statuses.put(studentSectioningStatus.getReference(), studentSectioningStatus);
            }
            HashMap<String, CourseType> courseTypes = new HashMap<String, CourseType>();
            for (CourseType type : CourseTypeDAO.getInstance().findAll(this.getHibSession())) {
                courseTypes.put(type.getReference(), type);
            }
            HashMap<StudentSectioningStatus, String> hashMap = new HashMap<StudentSectioningStatus, String>();
            HashMap<String, StudentSectioningStatus> all = new HashMap<String, StudentSectioningStatus>();
            Iterator i = root.elementIterator("status");
            while (i.hasNext()) {
                Element datesEl;
                Element element = (Element)i.next();
                String ref = element.attributeValue("reference");
                StudentSectioningStatus status = (StudentSectioningStatus)statuses.remove(ref);
                if (status == null) {
                    status = new StudentSectioningStatus();
                    status.setReference(ref);
                    status.setTypes(new HashSet<CourseType>());
                }
                status.setLabel(element.attributeValue("name"));
                status.setSession("true".equalsIgnoreCase(element.attributeValue("session", "false")) ? session : null);
                Element permissionsEl = element.element("permissions");
                status.setStatus(0);
                if (permissionsEl != null) {
                    for (StudentSectioningStatus.Option option : StudentSectioningStatus.Option.values()) {
                        if (!"true".equalsIgnoreCase(permissionsEl.attributeValue(StudentSchedulingStatusImport.getAttribute(option), "false"))) continue;
                        status.addOption(option);
                    }
                }
                if ((datesEl = element.element("effective-dates")) == null) {
                    status.setEffectiveStartDate(null);
                    status.setEffectiveStartPeriod(null);
                    status.setEffectiveStopDate(null);
                    status.setEffectiveStopPeriod(null);
                } else {
                    String stopPeriod;
                    String stopDate;
                    String startPeriod;
                    String startDate = datesEl.attributeValue("startDate");
                    if (startDate != null) {
                        try {
                            status.setEffectiveStartDate(this.dateFormat.parse(startDate));
                        }
                        catch (ParseException e) {
                            status.setEffectiveStartDate(null);
                            this.warn("Failed to parse start date " + startDate + " (status " + ref + ")");
                        }
                    }
                    if ((startPeriod = datesEl.attributeValue("startPeriod")) != null) {
                        try {
                            int time = Integer.parseInt(this.h24.format(this.timeFormat.parse(startPeriod)));
                            status.setEffectiveStartPeriod(12 * (time / 100) + time % 100 / 5);
                        }
                        catch (ParseException e) {
                            status.setEffectiveStartPeriod(null);
                            this.warn("Failed to parse start period " + startPeriod + " (status " + ref + ")");
                        }
                    }
                    if ((stopDate = datesEl.attributeValue("stopDate")) != null) {
                        try {
                            status.setEffectiveStopDate(this.dateFormat.parse(stopDate));
                        }
                        catch (ParseException e) {
                            status.setEffectiveStopDate(null);
                            this.warn("Failed to parse stop date " + stopDate + " (status " + ref + ")");
                        }
                    }
                    if ((stopPeriod = datesEl.attributeValue("stopPeriod")) != null) {
                        try {
                            int time = Integer.parseInt(this.h24.format(this.timeFormat.parse(stopPeriod)));
                            status.setEffectiveStopPeriod(12 * (time / 100) + time % 100 / 5);
                        }
                        catch (ParseException e) {
                            status.setEffectiveStopPeriod(null);
                            this.warn("Failed to parse stop period " + stopPeriod + " (status " + ref + ")");
                        }
                    }
                }
                status.getTypes().clear();
                Iterator j = element.elementIterator("course");
                while (j.hasNext()) {
                    Element courseEl = (Element)j.next();
                    CourseType type = (CourseType)courseTypes.get(courseEl.attributeValue("type"));
                    if (type == null) {
                        this.warn("Unknown course type " + courseEl.attributeValue("type") + " (status " + ref + ")");
                        continue;
                    }
                    status.getTypes().add(type);
                }
                Element messageEl = element.element("message");
                if (messageEl == null) {
                    status.setMessage(null);
                } else {
                    status.setMessage(messageEl.getText());
                }
                Element fallbackEl = element.element("fallback");
                if (fallbackEl == null) {
                    status.setFallBackStatus(null);
                } else {
                    hashMap.put(status, fallbackEl.attributeValue("reference"));
                }
                all.put(ref, status);
                this.getHibSession().saveOrUpdate((Object)status);
            }
            if (!incremental) {
                for (StudentSectioningStatus studentSectioningStatus : statuses.values()) {
                    this.getHibSession().delete((Object)studentSectioningStatus);
                }
            } else {
                for (StudentSectioningStatus studentSectioningStatus : statuses.values()) {
                    all.put(studentSectioningStatus.getReference(), studentSectioningStatus);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                StudentSectioningStatus fallback = (StudentSectioningStatus)all.get(entry.getValue());
                if (fallback == null) {
                    this.warn("Unknown fallback status " + (String)entry.getValue() + " (status " + ((StudentSectioningStatus)entry.getKey()).getReference() + ")");
                } else {
                    ((StudentSectioningStatus)entry.getKey()).setFallBackStatus(fallback);
                }
                this.getHibSession().saveOrUpdate(entry.getKey());
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected static String getAttribute(StudentSectioningStatus.Option option) {
        switch (option) {
            case enabled: {
                return "assistantEnabled";
            }
            case admin: {
                return "assistantAdminEdit";
            }
            case advisor: {
                return "assistantAdvisorEdit";
            }
            case enrollment: {
                return "assistantStudentEdit";
            }
            case regenabled: {
                return "requestsEnabled";
            }
            case regadmin: {
                return "requestsAdminEdit";
            }
            case regadvisor: {
                return "requestsAdvisorEdit";
            }
            case registration: {
                return "requestsStudentEdit";
            }
            case email: {
                return "emaiNotifications";
            }
            case nobatch: {
                return "doNotScheduleInBatch";
            }
            case notype: {
                return "mustHaveCourseType";
            }
            case waitlist: {
                return "waitListing";
            }
            case advcanset: {
                return "advisorCanSetStatus";
            }
            case specreg: {
                return "specialRegistration";
            }
            case reqval: {
                return "requestValidation";
            }
            case canreq: {
                return "canRequire";
            }
            case noschedule: {
                return "noSchedule";
            }
            case nosubs: {
                return "noSubs";
            }
        }
        return option.name();
    }
}

