/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.Degree;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMajorConcentration;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseStudentGroup;

public class StudentImport
extends BaseImport {
    @Override
    public void loadXml(Element rootElement) throws Exception {
        try {
            boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            boolean incremental = "true".equals(rootElement.attributeValue("incremental", "false"));
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (incremental) {
                this.info("Incremental mode enabled: only included students will be updated.");
            } else {
                this.info("Incremental mode disabled: students not included in this file will be deleted.");
            }
            this.beginTransaction();
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Object student : this.getHibSession().createQuery("from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId is not null").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                students.put(((BaseStudent)student).getExternalUniqueId(), (Student)student);
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (Object area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                abbv2area.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation(), (AcademicArea)area);
            }
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (Object clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2clasf.put(((BaseAcademicClassification)clasf).getCode(), (AcademicClassification)clasf);
            }
            Hashtable<String, PosMajor> code2major = new Hashtable<String, PosMajor>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea academicArea : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put(academicArea.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode(), (PosMajor)major);
                }
            }
            Hashtable<String, PosMajorConcentration> code2concentration = new Hashtable<String, PosMajorConcentration>();
            for (Object conc : this.getHibSession().createQuery("from PosMajorConcentration where major.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : ((BasePosMajorConcentration)conc).getMajor().getAcademicAreas()) {
                    code2concentration.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMajorConcentration)conc).getMajor().getCode() + ":" + ((BasePosMajorConcentration)conc).getCode(), (PosMajorConcentration)conc);
                }
            }
            Hashtable<String, Degree> code2degree = new Hashtable<String, Degree>();
            for (Degree degree : this.getHibSession().createQuery("from Degree where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2degree.put(degree.getReference(), degree);
            }
            Hashtable<String, PosMinor> code2minor = new Hashtable<String, PosMinor>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), (PosMinor)minor);
                }
            }
            Hashtable<String, StudentGroup> hashtable = new Hashtable<String, StudentGroup>();
            for (Object group : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                hashtable.put(((BaseStudentGroup)group).getGroupAbbreviation(), (StudentGroup)group);
            }
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (StudentAccomodation accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2accomodation.put(accomodation.getAbbreviation(), accomodation);
            }
            HashSet<Long> updatedStudents = new HashSet<Long>();
            Iterator i1 = rootElement.elementIterator();
            while (i1.hasNext()) {
                Element element = (Element)i1.next();
                String externalId = element.attributeValue("externalId");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                this.importStudent(element, externalId, students, session, updatedStudents, abbv2area, code2clasf, code2major, code2minor, hashtable, code2accomodation, code2concentration, code2degree);
            }
            if (!incremental) {
                for (Student student : students.values()) {
                    updatedStudents.add(student.getUniqueId());
                    this.getHibSession().delete((Object)student);
                }
            }
            this.info(updatedStudents.size() + " students changed");
            if (!updatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), updatedStudents);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected Student importStudent(Element element, String externalId, Hashtable<String, Student> students, Session session, Set<Long> updatedStudents, Map<String, AcademicArea> abbv2area, Map<String, AcademicClassification> code2clasf, Map<String, PosMajor> code2major, Map<String, PosMinor> code2minor, Map<String, StudentGroup> code2group, Map<String, StudentAccomodation> code2accomodation, Map<String, PosMajorConcentration> code2conc, Map<String, Degree> code2degree) {
        Student student = this.updateStudentInfo(element, externalId, students, session, updatedStudents);
        this.updateStudentMajors(element, student, updatedStudents, abbv2area, code2clasf, code2major, code2conc, code2degree);
        this.updateStudentMinors(element, student, updatedStudents, abbv2area, code2clasf, code2minor);
        this.updateStudentGroups(element, student, updatedStudents, code2group);
        this.updateStudentAccomodations(element, student, updatedStudents, code2accomodation);
        this.saveOrUpdateStudent(student, updatedStudents);
        return student;
    }

    protected Student updateStudentInfo(Element element, String externalId, Hashtable<String, Student> students, Session session, Set<Long> updatedStudents) {
        String fName = element.attributeValue("firstName", "Name");
        String mName = element.attributeValue("middleName");
        String lName = element.attributeValue("lastName", "Unknown");
        String email = element.attributeValue("email");
        String maxCred = element.attributeValue("maxCredit");
        String minCred = element.attributeValue("minCredit");
        Student student = students.remove(externalId);
        if (student == null) {
            student = new Student();
            student.setSession(session);
            student.setExternalUniqueId(externalId);
            student.setFreeTimeCategory(0);
            student.setSchedulePreference(0);
            student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
            student.setCourseDemands(new HashSet<CourseDemand>());
            student.setFirstName(fName);
            student.setMiddleName(mName);
            student.setLastName(lName);
            student.setEmail(email);
            student.setAreaClasfMajors(new HashSet<StudentAreaClassificationMajor>());
            student.setAreaClasfMinors(new HashSet<StudentAreaClassificationMinor>());
            student.setGroups(new HashSet<StudentGroup>());
            student.setAccomodations(new HashSet<StudentAccomodation>());
            student.setMinCredit(minCred == null ? null : Float.valueOf(minCred));
            student.setMaxCredit(maxCred == null ? null : Float.valueOf(maxCred));
        } else {
            if (!this.eq(fName, student.getFirstName())) {
                student.setFirstName(fName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(mName, student.getMiddleName())) {
                student.setMiddleName(mName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(lName, student.getLastName())) {
                student.setLastName(lName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(email, student.getEmail())) {
                student.setEmail(email);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(minCred == null ? null : Float.valueOf(minCred), student.getMinCredit())) {
                student.setMinCredit(minCred == null ? null : Float.valueOf(minCred));
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(maxCred == null ? null : Float.valueOf(maxCred), student.getMaxCredit())) {
                student.setMaxCredit(maxCred == null ? null : Float.valueOf(maxCred));
                updatedStudents.add(student.getUniqueId());
            }
        }
        return student;
    }

    protected void updateStudentMajors(Element element, Student student, Set<Long> updatedStudents, Map<String, AcademicArea> abbv2area, Map<String, AcademicClassification> code2clasf, Map<String, PosMajor> code2major, Map<String, PosMajorConcentration> code2conc, Map<String, Degree> code2degree) {
        AcademicArea a;
        String area;
        Element e;
        Iterator i2;
        HashMap<String, TreeSet<String>> area2classifications = new HashMap<String, TreeSet<String>>();
        if (element.element("studentAcadAreaClass") != null) {
            Iterator i22 = element.element("studentAcadAreaClass").elementIterator("acadAreaClass");
            while (i22.hasNext()) {
                Element e2 = (Element)i22.next();
                String area2 = e2.attributeValue("academicArea");
                String clasf = e2.attributeValue("academicClass");
                TreeSet<String> classifications = (TreeSet<String>)area2classifications.get(area2);
                if (classifications == null) {
                    classifications = new TreeSet<String>();
                    area2classifications.put(area2, classifications);
                }
                classifications.add(clasf);
            }
        }
        Hashtable<String, StudentAreaClassificationMajor> table = new Hashtable<String, StudentAreaClassificationMajor>();
        for (StudentAreaClassificationMajor acm : student.getAreaClasfMajors()) {
            table.put(acm.getAcademicArea().getAcademicAreaAbbreviation() + "|" + acm.getAcademicClassification().getCode() + "|" + acm.getMajor().getCode(), acm);
        }
        if (element.element("studentMajors") != null) {
            i2 = element.element("studentMajors").elementIterator("major");
            while (i2.hasNext()) {
                e = (Element)i2.next();
                area = e.attributeValue("academicArea");
                a = abbv2area.get(area);
                if (a == null) {
                    this.warn("Academic area " + area + " not known.");
                    continue;
                }
                String code = e.attributeValue("code");
                PosMajor m = code2major.get(area + ":" + code);
                if (m == null) {
                    this.warn("Major " + area + " " + code + " not known.");
                    continue;
                }
                String concentration = e.attributeValue("concentration");
                String degree = e.attributeValue("degree");
                Double weight = Double.valueOf(e.attributeValue("weight", "1.0"));
                String clasf = e.attributeValue("academicClass");
                if (clasf == null) {
                    Set classifications = (Set)area2classifications.get(area);
                    if (classifications == null) continue;
                    for (String cf : classifications) {
                        StudentAreaClassificationMajor acm = (StudentAreaClassificationMajor)table.remove(area + "|" + cf + "|" + code);
                        if (acm == null) {
                            AcademicClassification f = code2clasf.get(cf);
                            if (f == null) {
                                this.warn("Academic classification " + clasf + " not known.");
                                continue;
                            }
                            acm = new StudentAreaClassificationMajor();
                            acm.setAcademicArea(a);
                            acm.setAcademicClassification(f);
                            acm.setMajor(m);
                            acm.setStudent(student);
                            acm.setConcentration(concentration == null ? null : code2conc.get(area + ":" + code + ":" + concentration));
                            acm.setDegree(degree == null ? null : code2degree.get(degree));
                            acm.setWeight(weight);
                            student.getAreaClasfMajors().add(acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                            continue;
                        }
                        if (!ToolBox.equals((Object)concentration, acm.getConcentration() == null ? null : acm.getConcentration().getCode()) || !ToolBox.equals((Object)degree, acm.getDegree() == null ? null : acm.getDegree().getReference())) {
                            acm.setConcentration(concentration == null ? null : code2conc.get(area + ":" + code + ":" + concentration));
                            acm.setDegree(degree == null ? null : code2degree.get(degree));
                            acm.setWeight(weight);
                            this.iHibSession.update((Object)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                            continue;
                        }
                        if (ToolBox.equals((Object)acm.getWeight(), (Object)weight)) continue;
                        acm.setWeight(weight);
                        this.iHibSession.update((Object)acm);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    continue;
                }
                StudentAreaClassificationMajor acm = (StudentAreaClassificationMajor)table.remove(area + "|" + clasf + "|" + code);
                if (acm == null) {
                    AcademicClassification f = code2clasf.get(clasf);
                    if (f == null) {
                        this.warn("Academic classification " + clasf + " not known.");
                        continue;
                    }
                    acm = new StudentAreaClassificationMajor();
                    acm.setAcademicArea(a);
                    acm.setAcademicClassification(f);
                    acm.setMajor(m);
                    acm.setStudent(student);
                    acm.setConcentration(concentration == null ? null : code2conc.get(area + ":" + code + ":" + concentration));
                    acm.setDegree(degree == null ? null : code2degree.get(degree));
                    acm.setWeight(weight);
                    student.getAreaClasfMajors().add(acm);
                    if (student.getUniqueId() == null) continue;
                    updatedStudents.add(student.getUniqueId());
                    continue;
                }
                if (!ToolBox.equals((Object)concentration, acm.getConcentration() == null ? null : acm.getConcentration().getCode()) || !ToolBox.equals((Object)degree, acm.getDegree() == null ? null : acm.getDegree().getReference())) {
                    acm.setConcentration(concentration == null ? null : code2conc.get(area + ":" + code + ":" + concentration));
                    acm.setDegree(degree == null ? null : code2degree.get(degree));
                    acm.setWeight(weight);
                    this.iHibSession.update((Object)acm);
                    if (student.getUniqueId() == null) continue;
                    updatedStudents.add(student.getUniqueId());
                    continue;
                }
                if (ToolBox.equals((Object)acm.getWeight(), (Object)weight)) continue;
                acm.setWeight(weight);
                this.iHibSession.update((Object)acm);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
        for (StudentAreaClassificationMajor acm : student.getAreaClasfMajors()) {
            Set classifications = (Set)area2classifications.get(acm.getAcademicArea().getAcademicAreaAbbreviation());
            if (classifications == null || table.containsKey(acm.getAcademicArea().getAcademicAreaAbbreviation() + "|" + acm.getAcademicClassification().getCode() + "|" + acm.getMajor().getCode())) continue;
            classifications.remove(acm.getAcademicClassification().getCode());
        }
        if (element.element("studentMinors") != null) {
            i2 = element.element("studentMinors").elementIterator("minor");
            while (i2.hasNext()) {
                Set classifications;
                e = (Element)i2.next();
                area = e.attributeValue("academicArea");
                String clasf = e.attributeValue("academicClass");
                if (clasf == null || (classifications = (Set)area2classifications.get(area)) == null) continue;
                classifications.remove(clasf);
            }
        }
        for (Map.Entry a2c : area2classifications.entrySet()) {
            area = (String)a2c.getKey();
            if (((Set)a2c.getValue()).isEmpty()) continue;
            a = abbv2area.get(area);
            if (a == null) {
                this.warn("Academic area " + area + " not known.");
                continue;
            }
            for (String clasf : (Set)a2c.getValue()) {
                AcademicClassification f = code2clasf.get(clasf);
                if (f == null) {
                    this.warn("Academic classification " + clasf + " not known.");
                    continue;
                }
                String major = "-";
                PosMajor m = code2major.get(area + ":" + major);
                if (m == null) {
                    m = new PosMajor();
                    m.addToacademicAreas(a);
                    m.setExternalUniqueId("-");
                    m.setCode("-");
                    m.setName("No Major");
                    m.setSession(a.getSession());
                    a.addToposMajors(m);
                    this.getHibSession().saveOrUpdate((Object)m);
                    code2major.put(area + ":" + major, m);
                }
                if (table.remove(area + "|" + clasf + "|" + major) != null) continue;
                StudentAreaClassificationMajor acm = new StudentAreaClassificationMajor();
                acm.setAcademicArea(a);
                acm.setAcademicClassification(f);
                acm.setMajor(m);
                acm.setStudent(student);
                acm.setWeight(1.0);
                student.getAreaClasfMajors().add(acm);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
        for (StudentAreaClassificationMajor acm : table.values()) {
            student.getAreaClasfMajors().remove(acm);
            this.getHibSession().delete((Object)acm);
            if (student.getUniqueId() == null) continue;
            updatedStudents.add(student.getUniqueId());
        }
    }

    protected void updateStudentMinors(Element element, Student student, Set<Long> updatedStudents, Map<String, AcademicArea> abbv2area, Map<String, AcademicClassification> code2clasf, Map<String, PosMinor> code2minor) {
        HashMap<String, TreeSet<String>> area2classifications = new HashMap<String, TreeSet<String>>();
        if (element.element("studentAcadAreaClass") != null) {
            Iterator i2 = element.element("studentAcadAreaClass").elementIterator("acadAreaClass");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String area = e.attributeValue("academicArea");
                String clasf = e.attributeValue("academicClass");
                TreeSet<String> classifications = (TreeSet<String>)area2classifications.get(area);
                if (classifications == null) {
                    classifications = new TreeSet<String>();
                    area2classifications.put(area, classifications);
                }
                classifications.add(clasf);
            }
        }
        Hashtable<String, StudentAreaClassificationMinor> table = new Hashtable<String, StudentAreaClassificationMinor>();
        for (StudentAreaClassificationMinor acm : student.getAreaClasfMinors()) {
            table.put(acm.getAcademicArea().getAcademicAreaAbbreviation() + "|" + acm.getAcademicClassification().getCode() + "|" + acm.getMinor().getCode(), acm);
        }
        if (element.element("studentMinors") != null) {
            Iterator i2 = element.element("studentMinors").elementIterator("minor");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String area = e.attributeValue("academicArea");
                AcademicArea a = abbv2area.get(area);
                if (a == null) {
                    this.warn("Academic area " + area + " not known.");
                    continue;
                }
                String code = e.attributeValue("code");
                PosMinor m = code2minor.get(area + ":" + code);
                if (m == null) {
                    this.warn("Minor " + area + " " + code + " not known.");
                    continue;
                }
                String clasf = e.attributeValue("academicClass");
                if (clasf == null) {
                    Set classifications = (Set)area2classifications.get(area);
                    if (classifications == null) continue;
                    for (String cf : classifications) {
                        if (table.remove(area + "|" + cf + "|" + code) != null) continue;
                        AcademicClassification f = code2clasf.get(cf);
                        if (f == null) {
                            this.warn("Academic classification " + clasf + " not known.");
                            continue;
                        }
                        StudentAreaClassificationMinor acm = new StudentAreaClassificationMinor();
                        acm.setAcademicArea(a);
                        acm.setAcademicClassification(f);
                        acm.setMinor(m);
                        acm.setStudent(student);
                        student.getAreaClasfMinors().add(acm);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    continue;
                }
                if (table.remove(area + "|" + clasf + "|" + code) != null) continue;
                AcademicClassification f = code2clasf.get(clasf);
                if (f == null) {
                    this.warn("Academic classification " + clasf + " not known.");
                    continue;
                }
                StudentAreaClassificationMinor acm = new StudentAreaClassificationMinor();
                acm.setAcademicArea(a);
                acm.setAcademicClassification(f);
                acm.setMinor(m);
                acm.setStudent(student);
                student.getAreaClasfMinors().add(acm);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
        for (StudentAreaClassificationMinor acm : table.values()) {
            student.getAreaClasfMinors().remove(acm);
            this.getHibSession().delete((Object)acm);
            if (student.getUniqueId() == null) continue;
            updatedStudents.add(student.getUniqueId());
        }
    }

    protected void updateStudentGroups(Element element, Student student, Set<Long> updatedStudents, Map<String, StudentGroup> code2group) {
        if (element.element("studentGroups") != null) {
            Hashtable<String, StudentGroup> sGroups = new Hashtable<String, StudentGroup>();
            for (StudentGroup group : student.getGroups()) {
                sGroups.put(group.getGroupAbbreviation(), group);
            }
            Iterator i2 = element.element("studentGroups").elementIterator("studentGroup");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String code = e.attributeValue("group");
                if (sGroups.remove(code) != null) continue;
                StudentGroup group = code2group.get(code);
                if (group == null) {
                    this.warn("Student group " + code + " not known.");
                    continue;
                }
                student.getGroups().add(group);
                group.getStudents().add(student);
                this.getHibSession().saveOrUpdate((Object)group);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (StudentGroup group : sGroups.values()) {
                if (group.getExternalUniqueId() == null) continue;
                student.getGroups().remove(group);
                group.getStudents().remove(student);
                this.getHibSession().saveOrUpdate((Object)group);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void updateStudentAccomodations(Element element, Student student, Set<Long> updatedStudents, Map<String, StudentAccomodation> code2accomodation) {
        if (element.element("studentAccomodations") != null) {
            Hashtable<String, StudentAccomodation> sAccomodations = new Hashtable<String, StudentAccomodation>();
            for (StudentAccomodation accomodation : student.getAccomodations()) {
                sAccomodations.put(accomodation.getAbbreviation(), accomodation);
            }
            Iterator i2 = element.element("studentAccomodations").elementIterator("studentAccomodation");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String code = e.attributeValue("accomodation");
                if (sAccomodations.remove(code) != null) continue;
                StudentAccomodation accomodation = code2accomodation.get(code);
                if (accomodation == null) {
                    this.warn("Student accomodation " + code + " not known.");
                    continue;
                }
                student.getAccomodations().add(accomodation);
                accomodation.getStudents().add(student);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (StudentAccomodation accomodation : sAccomodations.values()) {
                student.getAccomodations().remove(accomodation);
                accomodation.getStudents().remove(student);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void saveOrUpdateStudent(Student student, Set<Long> updatedStudents) {
        if (student.getUniqueId() == null) {
            updatedStudents.add((Long)this.getHibSession().save((Object)student));
        } else {
            this.getHibSession().update((Object)student);
        }
    }

    protected boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    protected boolean eq(Float a, Float b) {
        return a == null ? b == null : a.equals(b);
    }
}

