/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Element;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.unitime.commons.Debug;
import org.unitime.timetable.dataexchange.EventRelatedImports;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseExam;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.test.MakeAssignmentsForClassEvents;
import org.unitime.timetable.test.UpdateExamConflicts;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;
import org.unitime.timetable.util.duration.DurationModel;

public abstract class BaseCourseOfferingImport
extends EventRelatedImports {
    HashSet<Long> existingInstructionalOfferings = new HashSet();
    HashSet<Long> existingCourseOfferings = new HashSet();
    HashSet<Long> existingClasses = new HashSet();
    HashMap<String, SubjectArea> subjectAreas = new HashMap();
    HashMap<String, TimePattern> timePatterns = new HashMap();
    HashMap<String, ItypeDesc> itypes = new HashMap();
    HashMap<String, ItypeDesc> itypesBySisRef = new HashMap();
    protected DistributionType meetsWithType = null;
    protected DistributionType canShareRoomType = null;
    boolean useMeetsWithElement = false;
    boolean useCanShareRoomElement = false;
    boolean incremental = false;
    PreferenceLevel requiredPrefLevel = null;
    MakeAssignmentsForClassEvents assignmentHelper = null;
    protected String rootElementName;
    int changeCount = 0;
    protected boolean courseNumbersMustBeUnique = ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue();
    protected Integer defaultMaxNbrRooms = null;
    protected boolean examPeriodChanged = false;
    protected String includeExams = null;

    @Override
    public void loadXml(Element rootElement) throws Exception {
        this.initializeTrimLeadingZeros();
        try {
            SolverParameterDef maxRoomsParam;
            if (!rootElement.getName().equalsIgnoreCase(this.rootElementName)) {
                throw new Exception("Given XML file is not a Course Offerings load file.");
            }
            this.beginTransaction();
            this.incremental = "true".equalsIgnoreCase(rootElement.attributeValue("incremental", "false"));
            if (this.incremental) {
                this.info("Incremental mode.");
            }
            this.includeExams = rootElement.attributeValue("includeExams", "none");
            if (!"none".equals(this.includeExams)) {
                this.info("Includes " + this.includeExams + " exams.");
            }
            if ((maxRoomsParam = SolverParameterDef.findByNameType(this.getHibSession(), "Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM)) != null && maxRoomsParam.getDefault() != null) {
                this.defaultMaxNbrRooms = Integer.valueOf(maxRoomsParam.getDefault());
            }
            this.initializeLoad(rootElement, this.rootElementName);
            this.preLoadAction();
            this.loadOfferings(rootElement);
            if (!this.incremental) {
                this.deleteUnmatchedInstructionalOfferings();
                this.deleteUnmatchedCourseOfferings();
            }
            this.deleteUnmatchedClasses();
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
        finally {
            this.postLoadAction();
        }
        if (this.examPeriodChanged && this.session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsFinal.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(0)) {
                    new UpdateExamConflicts(this).update(this.session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
        if (this.examPeriodChanged && this.session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsMidterm.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(1)) {
                    new UpdateExamConflicts(this).update(this.session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
        this.addNote("Records Changed: " + this.changeCount);
        this.updateChangeList(true);
        this.reportMissingLocations();
        this.mailLoadResults();
    }

    protected abstract void preLoadAction();

    protected abstract void postLoadAction();

    protected void loadOfferings(Element rootElement) throws Exception {
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            try {
                this.elementOffering(element);
                this.flush(true);
            }
            catch (Exception e) {
                this.addNote("Not Loading 'offering' Error:  " + e.getMessage());
                e.printStackTrace();
                this.addNote("\t " + element.asXML());
                this.updateChangeList(true);
            }
        }
    }

    protected void elementOffering(Element element) throws Exception {
        String offeringElementName = "offering";
        if (!element.getName().equalsIgnoreCase(offeringElementName)) {
            throw new Exception("Expecting to find an '" + offeringElementName + "' at this level, instead found '" + element.getName() + "'.");
        }
        String externalId = this.getOptionalStringAttribute(element, "id");
        String action = this.getOptionalStringAttribute(element, "action");
        BaseInstructionalOffering io = null;
        boolean existingIo = false;
        if (externalId != null && (io = this.findInstrOffrForExternalId(externalId, this.session.getUniqueId())) != null) {
            existingIo = true;
        }
        if (io == null) {
            ArrayList<ImportCourseOffering> courses = this.getCourses(element);
            if (courses == null || courses.isEmpty()) {
                throw new Exception("Expected an 'offering' to have at least one course.");
            }
            if (courses.size() == 1) {
                ImportCourseOffering ico = courses.get(0);
                CourseOffering co = ico.getCourseOffering();
                CourseOffering existingCourseOffering = this.findExistingCourseOffering(co, this.session.getUniqueId());
                if (existingCourseOffering == null) {
                    io = new InstructionalOffering();
                    io.setSession(this.session);
                    io.setExternalUniqueId(externalId);
                    io.setByReservationOnly(false);
                } else {
                    io = existingCourseOffering.getInstructionalOffering();
                    existingIo = true;
                }
            } else {
                HashSet<InstructionalOffering> possibleOfferings = new HashSet<InstructionalOffering>();
                for (ImportCourseOffering ico : courses) {
                    CourseOffering co = ico.getCourseOffering();
                    CourseOffering existingCourseOffering = this.findExistingCourseOffering(co, this.session.getUniqueId());
                    if (existingCourseOffering == null) continue;
                    possibleOfferings.add(existingCourseOffering.getInstructionalOffering());
                }
                if (possibleOfferings.isEmpty()) {
                    io = new InstructionalOffering();
                    io.setSession(this.session);
                    io.setExternalUniqueId(externalId);
                    io.setByReservationOnly(false);
                } else if (possibleOfferings.size() == 1) {
                    io = (InstructionalOffering)possibleOfferings.iterator().next();
                    existingIo = true;
                } else {
                    CourseOffering control = null;
                    for (ImportCourseOffering ico : courses) {
                        CourseOffering co = ico.getCourseOffering();
                        if (!co.isIsControl().booleanValue()) continue;
                        control = co;
                        break;
                    }
                    if (control == null) {
                        throw new Exception("Expected an 'offering' to have a controlling course.");
                    }
                    InstructionalOffering offeringForControllingCourse = null;
                    for (InstructionalOffering possibleIntructionalOffering : possibleOfferings) {
                        if (!this.isSameCourseOffering(possibleIntructionalOffering.getControllingCourseOffering(), control)) continue;
                        offeringForControllingCourse = possibleIntructionalOffering;
                        break;
                    }
                    if (offeringForControllingCourse != null) {
                        io = offeringForControllingCourse;
                        possibleOfferings.remove(io);
                        existingIo = true;
                        for (InstructionalOffering oldIo : possibleOfferings) {
                            this.deleteInstructionalOffering(oldIo);
                        }
                    } else {
                        io = new InstructionalOffering();
                        io.setSession(this.session);
                        io.setExternalUniqueId(externalId);
                        io.setByReservationOnly(false);
                        for (InstructionalOffering oldIo : possibleOfferings) {
                            this.deleteInstructionalOffering(oldIo);
                        }
                    }
                }
            }
        }
        if (externalId != null && io.getExternalUniqueId() != null && !io.getExternalUniqueId().equals(externalId)) {
            existingIo = false;
            this.deleteInstructionalOffering((InstructionalOffering)io);
            io = new InstructionalOffering();
            io.setSession(this.session);
            io.setExternalUniqueId(externalId);
            io.setByReservationOnly(false);
        }
        if (existingIo && action != null && action.equalsIgnoreCase("delete")) {
            this.addNote("Deleted instructional offering: " + ((InstructionalOffering)io).getCourseName());
            this.deleteInstructionalOffering((InstructionalOffering)io);
            this.updateChangeList(true);
            ++this.changeCount;
        } else {
            if (!existingIo && action != null && action.equalsIgnoreCase("delete")) {
                return;
            }
            if (io != null) {
                if (existingIo) {
                    if (!this.existingInstructionalOfferings.remove(io.getUniqueId())) {
                        throw new Exception("could not remove io uniqueid from existing");
                    }
                    if (!"create-if-not-exists".equalsIgnoreCase(action)) {
                        action = "update";
                    }
                    this.addNote("Changes for instructional offering: " + ((InstructionalOffering)io).getCourseName());
                } else {
                    action = "insert";
                }
                if (this.doAddUpdate(element, (InstructionalOffering)io, action) || action.equalsIgnoreCase("insert")) {
                    ++this.changeCount;
                    if (action.equals("insert")) {
                        this.clearNotes();
                        this.addNote("Added instructional offering: " + ((InstructionalOffering)io).getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation() + " " + ((InstructionalOffering)io).getControllingCourseOffering().getCourseNbr());
                    }
                    this.updateChangeList(true);
                } else {
                    this.updateChangeList(false);
                }
            } else {
                return;
            }
        }
    }

    protected void deleteUnmatchedInstructionalOfferings() {
        if (this.existingInstructionalOfferings.size() > 0) {
            HashSet<Long> deleteOfferings = new HashSet<Long>();
            deleteOfferings.addAll(this.existingInstructionalOfferings);
            this.addNote("Deleted Instructional Offerings that were not in the input file:");
            for (Long uniqueId : deleteOfferings) {
                InstructionalOffering unusedIo = this.findInstrOffrForUniqueId(uniqueId);
                if (unusedIo == null) continue;
                this.addNote("\tdeleted: " + unusedIo.getCourseName());
                this.deleteInstructionalOffering(unusedIo);
                ++this.changeCount;
            }
            this.flushIfNeeded(true);
            this.updateChangeList(true);
        }
    }

    protected void deleteUnmatchedCourseOfferings() {
        if (this.existingCourseOfferings.size() > 0) {
            HashSet<Long> deleteOfferings = new HashSet<Long>();
            deleteOfferings.addAll(this.existingCourseOfferings);
            this.addNote("Deleted Course Offerings that were not in the input file:");
            for (Long uniqueId : deleteOfferings) {
                CourseOffering unusedCo = this.findCourseOffrForUniqueId(uniqueId);
                if (unusedCo == null) continue;
                this.addNote("\tDeleted: " + unusedCo.getCourseName());
                this.deleteCourseOffering(unusedCo);
                ++this.changeCount;
            }
            this.flushIfNeeded(true);
            this.updateChangeList(true);
        }
    }

    protected void deleteUnmatchedClasses() {
        if (this.existingClasses.size() > 0) {
            HashSet<Long> deleteClasses = new HashSet<Long>();
            deleteClasses.addAll(this.existingClasses);
            this.addNote("Deleted Classes that were not in the input file:");
            for (Long uniqueId : deleteClasses) {
                Class_ unusedC = this.findClassForUniqueId(uniqueId);
                if (unusedC == null) continue;
                if (this.incremental) {
                    try {
                        if (this.existingInstructionalOfferings.contains(unusedC.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId()) || this.existingCourseOfferings.contains(unusedC.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getUniqueId())) {
                            continue;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                this.addNote("\tDeleted: " + unusedC.getClassLabel());
                this.deleteClass(unusedC);
                ++this.changeCount;
            }
            this.flushIfNeeded(true);
            this.updateChangeList(true);
        }
    }

    protected void initializeLoad(Element rootElement, String rootElementName) throws Exception {
        this.initializeDateTimeFormats(rootElement);
        this.initializeSessionData(rootElement, rootElementName);
        this.initializeMeetsWith(rootElement);
        this.initializeCanShareRoom(rootElement);
        this.initializeAssignmentHelper();
        this.loadSetupData();
        this.logXmlFileCreateInformation(rootElement);
    }

    protected void logXmlFileCreateInformation(Element rootElement) {
        String created = this.getOptionalStringAttribute(rootElement, "created");
        if (created != null) {
            this.addNote("Loading offerings XML file created on: " + created);
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, this.session, created, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, null, null);
            this.updateChangeList(true);
        }
    }

    protected void initializeAssignmentHelper() {
        this.assignmentHelper = new MakeAssignmentsForClassEvents(this.session, this.getHibSession());
    }

    protected void initializeMeetsWith(Element rootElement) {
        Boolean useMeetsWith = this.getOptionalBooleanAttribute(rootElement, "useMeetsWith");
        if (useMeetsWith != null && useMeetsWith.booleanValue()) {
            this.useMeetsWithElement = true;
        }
    }

    protected void initializeCanShareRoom(Element rootElement) {
        Boolean useCanShareRoom = this.getOptionalBooleanAttribute(rootElement, "useCanShareRoom");
        if (useCanShareRoom != null && useCanShareRoom.booleanValue()) {
            this.useCanShareRoomElement = true;
        }
    }

    protected void initializeSessionData(Element rootElement, String rootElementName) throws Exception {
        String campus = this.getRequiredStringAttribute(rootElement, "campus", rootElementName);
        String year = this.getRequiredStringAttribute(rootElement, "year", rootElementName);
        String term = this.getRequiredStringAttribute(rootElement, "term", rootElementName);
        this.session = this.findSession(campus, year, term);
        if (this.session == null) {
            throw new Exception("No session found for the given campus, year, and term.");
        }
    }

    protected void initializeDateTimeFormats(Element rootElement) {
        this.dateFormat = this.getOptionalStringAttribute(rootElement, "dateFormat");
        this.timeFormat = this.getOptionalStringAttribute(rootElement, "timeFormat");
        if (this.timeFormat == null) {
            this.timeFormat = "HHmm";
        }
    }

    protected void initializeTrimLeadingZeros() {
        this.trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
    }

    protected void loadSetupData() throws Exception {
        this.loadItypes();
        this.loadSubjectAreas(this.session.getUniqueId());
        this.loadTimePatterns(this.session.getUniqueId());
        this.loadExistingInstructionalOfferings(this.session.getUniqueId());
        this.loadExistingCourseOfferings(this.session.getUniqueId());
        this.loadExistingClasses(this.session.getUniqueId());
        this.loadRequiredPrefLevel();
        this.loadMeetsWithDistributionType();
        this.loadCanShareRoomDistributionType();
    }

    private void loadTimePatterns(Long sessionId) {
        List patterns = new ArrayList();
        patterns = this.getHibSession().createQuery("select distinct tp from TimePattern as tp where tp.session.uniqueId=:sessionId and ( tp.type = :standard or tp.type = :evening )").setLong("sessionId", sessionId.longValue()).setInteger("standard", 0).setInteger("evening", 1).setCacheable(true).list();
        for (TimePattern tp : patterns) {
            for (TimePatternDays tpd : tp.getDays()) {
                for (TimePatternTime tpt : tp.getTimes()) {
                    this.timePatterns.put(tpd.getDayCode().toString() + "x" + tp.getMinPerMtg().toString() + "x" + tpt.getStartSlot(), tp);
                }
            }
        }
    }

    private boolean isSameCourseOffering(CourseOffering originalCourseOffering, CourseOffering newCourseOffering) {
        boolean isSame = false;
        if (originalCourseOffering.getExternalUniqueId() != null && originalCourseOffering.getExternalUniqueId().equals(newCourseOffering.getExternalUniqueId())) {
            isSame = true;
        } else if (this.courseNumbersMustBeUnique) {
            if (originalCourseOffering.getSubjectArea().getUniqueId().equals(newCourseOffering.getSubjectArea().getUniqueId()) && originalCourseOffering.getCourseNbr().equals(newCourseOffering.getCourseNbr())) {
                isSame = true;
            }
        } else if (originalCourseOffering.getSubjectArea().getUniqueId().equals(newCourseOffering.getSubjectArea().getUniqueId()) && originalCourseOffering.getCourseNbr().equals(newCourseOffering.getCourseNbr()) && originalCourseOffering.getTitle().equals(newCourseOffering.getTitle())) {
            isSame = true;
        }
        return isSame;
    }

    private boolean isSameCreditConfig(CourseCreditUnitConfig originalCourseCreditUnitConfig, CourseCreditUnitConfig courseCreditUnitConfig) {
        boolean different = false;
        if (originalCourseCreditUnitConfig.getCreditFormat() == null || courseCreditUnitConfig.getCreditFormat() == null || originalCourseCreditUnitConfig.getCreditFormat().equals(courseCreditUnitConfig.getCreditFormat())) {
            if (!originalCourseCreditUnitConfig.getCreditType().getUniqueId().equals(courseCreditUnitConfig.getCreditType().getUniqueId())) {
                different = true;
            } else if (!originalCourseCreditUnitConfig.getCreditUnitType().getUniqueId().equals(courseCreditUnitConfig.getCreditUnitType().getUniqueId())) {
                different = true;
            } else if (originalCourseCreditUnitConfig instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)originalCourseCreditUnitConfig;
                FixedCreditUnitConfig newFcuc = (FixedCreditUnitConfig)courseCreditUnitConfig;
                if (!fcuc.getFixedUnits().equals(newFcuc.getFixedUnits())) {
                    different = true;
                }
            } else if (originalCourseCreditUnitConfig instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig vrcuc = (VariableRangeCreditUnitConfig)originalCourseCreditUnitConfig;
                VariableRangeCreditUnitConfig newVrcuc = (VariableRangeCreditUnitConfig)courseCreditUnitConfig;
                if (!vrcuc.getMinUnits().equals(newVrcuc.getMinUnits())) {
                    different = true;
                } else if (!vrcuc.getMaxUnits().equals(newVrcuc.getMaxUnits())) {
                    different = true;
                } else if (!vrcuc.isFractionalIncrementsAllowed().equals(newVrcuc.isFractionalIncrementsAllowed())) {
                    different = true;
                }
            } else if (originalCourseCreditUnitConfig instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)originalCourseCreditUnitConfig;
                VariableFixedCreditUnitConfig newVfcuc = (VariableFixedCreditUnitConfig)courseCreditUnitConfig;
                if (!vfcuc.getMinUnits().equals(newVfcuc.getMinUnits())) {
                    different = true;
                } else if (!vfcuc.getMaxUnits().equals(newVfcuc.getMaxUnits())) {
                    different = true;
                }
            }
        } else {
            different = true;
        }
        return !different;
    }

    private boolean isSameMeeting(Meeting originalMeeting, Meeting newMeeting) {
        boolean isSame = false;
        if (this.getDateString(originalMeeting.getMeetingDate()).equals(this.getDateString(newMeeting.getMeetingDate())) && (originalMeeting.getLocationPermanentId() != null && newMeeting.getLocationPermanentId() != null && originalMeeting.getLocationPermanentId().longValue() == newMeeting.getLocationPermanentId().longValue() || originalMeeting.getLocationPermanentId() == null && newMeeting.getLocationPermanentId() == null) && originalMeeting.getStartOffset().intValue() == newMeeting.getStartOffset().intValue() && originalMeeting.getStartPeriod().intValue() == newMeeting.getStartPeriod().intValue() && originalMeeting.getStopOffset().intValue() == newMeeting.getStopOffset().intValue() && originalMeeting.getStopPeriod().intValue() == newMeeting.getStopPeriod().intValue()) {
            isSame = true;
        }
        return isSame;
    }

    private boolean doAddUpdate(Element element, InstructionalOffering io, String action) throws Exception {
        boolean changed = false;
        if (io.getInstrOfferingPermId() == null) {
            io.generateInstrOfferingPermId();
        }
        Boolean offered = this.getRequiredBooleanAttribute(element, "offered", "offered");
        if (io.isNotOffered() == null || !"create-if-not-exists".equals(action) && io.isNotOffered().equals(offered)) {
            io.setNotOffered(new Boolean(offered == false));
            this.addNote("\toffered status changed");
            changed = true;
        }
        if (this.elementCourse(element, io, action)) {
            this.addNote("\tcourses changed");
            changed = true;
        }
        if (changed) {
            this.getHibSession().saveOrUpdate((Object)io);
        }
        if ("create-if-not-exists".equals(action)) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        this.existingClasses.remove(clazz.getUniqueId());
                    }
                }
            }
        } else {
            if (this.elementInstrOffrConfig(element, io)) {
                changed = true;
            }
            if (this.elementExam(element, io)) {
                changed = true;
            }
        }
        if (changed) {
            this.getHibSession().saveOrUpdate((Object)io);
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, io, ChangeLog.Source.DATA_IMPORT_OFFERINGS, action.equalsIgnoreCase("insert") ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), io.getDepartment());
        }
        return changed;
    }

    private DepartmentalInstructor findDepartmentalInstructorWithExternalUniqueId(String externalId, Department department) {
        return (DepartmentalInstructor)this.getHibSession().createQuery("select distinct di from DepartmentalInstructor di where di.externalUniqueId=:externalId and di.department.uniqueId=:departmentId").setString("externalId", externalId).setLong("departmentId", department.getUniqueId().longValue()).setCacheable(true).uniqueResult();
    }

    private String createPatternString(Vector<Calendar> startDates, Vector<Calendar> endDates) {
        Iterator<Calendar> startDateIt = startDates.iterator();
        Iterator<Calendar> endDateIt = endDates.iterator();
        StringBuffer patternString = new StringBuffer();
        Calendar lastDate = null;
        while (startDateIt.hasNext() && endDateIt.hasNext()) {
            Calendar startDate = Calendar.getInstance();
            startDate.setTime(startDateIt.next().getTime());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(endDateIt.next().getTime());
            if (lastDate != null) {
                lastDate.add(5, 1);
                while (this.getCalendarDateString(lastDate).compareTo(this.getCalendarDateString(startDate)) < 0) {
                    patternString.append("0");
                    lastDate.add(5, 1);
                }
            }
            lastDate = endDate;
            while (this.getCalendarDateString(startDate).compareTo(this.getCalendarDateString(endDate)) <= 0) {
                patternString.append("1");
                startDate.add(5, 1);
            }
        }
        return patternString.toString();
    }

    private DatePattern findDatePattern(Vector<Calendar> startDates, Vector<Calendar> endDates, Class_ c) {
        Calendar firstDate = Calendar.getInstance();
        firstDate.setTime(startDates.firstElement().getTime());
        Calendar sessionStartDate = Calendar.getInstance();
        sessionStartDate.setTime(this.session.getSessionBeginDateTime());
        int offset = 0;
        if (this.getCalendarDateString(firstDate).compareTo(this.getCalendarDateString(sessionStartDate)) < 0) {
            while (this.getCalendarDateString(firstDate).compareTo(this.getCalendarDateString(sessionStartDate)) < 0) {
                ++offset;
                firstDate.add(5, 1);
            }
        } else if (this.getCalendarDateString(firstDate).compareTo(this.getCalendarDateString(sessionStartDate)) > 0) {
            while (this.getCalendarDateString(firstDate).compareTo(this.getCalendarDateString(sessionStartDate)) > 0) {
                --offset;
                firstDate.add(5, -1);
            }
        }
        String pattern = this.createPatternString(startDates, endDates);
        DatePattern dp = null;
        List patterns = this.getHibSession().createQuery("from DatePattern as d where d.session.uniqueId = :sessionId and d.pattern = :pattern and d.offset = :offset and d.type = (select min(dd.type) from DatePattern as dd where dd.session.uniqueId = :sessionId and dd.pattern = :pattern and dd.offset = :offset)").setLong("sessionId", this.session.getUniqueId().longValue()).setString("pattern", pattern).setInteger("offset", offset).setCacheable(true).list();
        if (!patterns.isEmpty()) {
            dp = (DatePattern)patterns.get(0);
        } else {
            dp = new DatePattern();
            dp.setName("import - " + c.getClassLabel());
            dp.setPattern(pattern);
            dp.setOffset(new Integer(offset));
            dp.setSession(this.session);
            dp.setType(new Integer(3));
            dp.setVisible(new Boolean(false));
            this.getHibSession().save((Object)dp);
            this.getHibSession().flush();
            this.getHibSession().refresh((Object)dp);
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, dp, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
        }
        if (dp.isDefault()) {
            return null;
        }
        return dp;
    }

    protected ArrayList<ImportCourseOffering> getCourses(Element element) throws Exception {
        ArrayList<ImportCourseOffering> courses = new ArrayList<ImportCourseOffering>();
        String elementName = "course";
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                String reserved;
                Element consentElement;
                Element courseElement = (Element)it.next();
                String externalUid = this.getOptionalStringAttribute(courseElement, "id");
                Boolean controlling = this.getRequiredBooleanAttribute(courseElement, "controlling", elementName);
                String courseNbr = this.getRequiredStringAttribute(courseElement, "courseNbr", elementName);
                String scheduleBookNote = this.getOptionalStringAttribute(courseElement, "scheduleBookNote");
                String subjAbbv = this.getRequiredStringAttribute(courseElement, "subject", elementName);
                SubjectArea subjectArea = this.subjectAreas.get(subjAbbv);
                String title = this.getOptionalStringAttribute(courseElement, "title");
                CourseOffering newCourseOffering = new CourseOffering();
                newCourseOffering.setSubjectArea(subjectArea);
                if (courseNbr != null && courseNbr.trim().length() > 0) {
                    newCourseOffering.setCourseNbr(courseNbr.trim());
                }
                if (externalUid != null && externalUid.trim().length() > 0) {
                    newCourseOffering.setExternalUniqueId(externalUid.trim());
                }
                newCourseOffering.setIsControl(controlling);
                if (scheduleBookNote != null && scheduleBookNote.trim().length() > 0) {
                    newCourseOffering.setScheduleBookNote(scheduleBookNote.trim());
                }
                if (title != null && title.trim().length() > 0) {
                    newCourseOffering.setTitle(title.trim());
                }
                if ((consentElement = courseElement.element("consent")) == null) {
                    consentElement = element.element("consent");
                }
                if (consentElement != null) {
                    String consentType = this.getRequiredStringAttribute(consentElement, "type", "consent");
                    newCourseOffering.setConsentType(OfferingConsentType.getOfferingConsentTypeForReference(consentType));
                }
                if ((reserved = this.getOptionalStringAttribute(courseElement, "reserved")) != null) {
                    try {
                        newCourseOffering.setReservation(Integer.parseInt(reserved));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.elementCourseCredit(courseElement, newCourseOffering);
                ImportCourseOffering importcourseOffering = new ImportCourseOffering(newCourseOffering, courseElement);
                courses.add(importcourseOffering);
            }
        } else {
            throw new Exception("'course' element is required.");
        }
        return courses;
    }

    private String getDateString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(date);
    }

    private String getCalendarDateString(Calendar calendar) {
        return this.getDateString(calendar.getTime());
    }

    private Calendar getCalendarForDate(String date) {
        if (date.length() < 3 || date.indexOf("/") < 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int index1 = date.indexOf("/");
        int index2 = date.lastIndexOf("/");
        if (index2 == index1) {
            index2 = date.length();
        }
        int month = Integer.parseInt(date.substring(0, index1));
        int day = Integer.parseInt(date.substring(index1 + 1, index2));
        int year = index2 == date.length() ? this.session.getSessionStartYear() : Integer.parseInt(date.substring(index2 + 1, date.length()));
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal;
    }

    private HashMap<String, Vector<Calendar>> elementDates(Element element) throws Exception {
        Vector<Calendar> startDates = new Vector<Calendar>();
        Vector<Calendar> endDates = new Vector<Calendar>();
        String elementName = "date";
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element dateElement = (Element)it.next();
                Calendar startDate = null;
                Calendar endDate = null;
                if (this.dateFormat == null) {
                    startDate = this.getCalendarForDate(this.getRequiredStringAttribute(dateElement, "startDate", elementName));
                    endDate = this.getCalendarForDate(this.getRequiredStringAttribute(dateElement, "endDate", elementName));
                } else {
                    startDate = Calendar.getInstance();
                    startDate.setTime(CalendarUtils.getDate(this.getRequiredStringAttribute(dateElement, "startDate", elementName), this.dateFormat));
                    endDate = Calendar.getInstance();
                    endDate.setTime(CalendarUtils.getDate(this.getRequiredStringAttribute(dateElement, "endDate", elementName), this.dateFormat));
                }
                if (startDate == null) {
                    throw new Exception("For element 'date' a 'startDate' is required, unable to parse given date");
                }
                if (endDate == null) {
                    throw new Exception("For element 'date' a 'endDate' is required, unable to parse given date");
                }
                if (endDate.before(startDate)) {
                    endDate.add(1, 1);
                }
                startDates.add(startDate);
                endDates.add(endDate);
            }
        }
        if (startDates.size() > 0) {
            HashMap<String, Vector<Calendar>> dates = new HashMap<String, Vector<Calendar>>();
            dates.put("startDates", startDates);
            dates.put("endDates", endDates);
            return dates;
        }
        return null;
    }

    private EventRelatedImports.TimeObject elementTime(Element element) throws Exception {
        String name;
        String days;
        String endTime;
        Element timeElement;
        String startTime;
        EventRelatedImports.TimeObject meetingTime = null;
        String elementName = "time";
        if (element.element(elementName) != null && ((meetingTime = new EventRelatedImports.TimeObject(this, startTime = this.getRequiredStringAttribute(timeElement = element.element(elementName), "startTime", elementName), endTime = this.getRequiredStringAttribute(timeElement, "endTime", elementName), days = this.getRequiredStringAttribute(timeElement, "days", elementName), name = this.getOptionalStringAttribute(timeElement, "timePattern"))).getDays() == null || meetingTime.getDays().isEmpty())) {
            meetingTime = null;
        }
        return meetingTime;
    }

    private Vector<Room> elementRoom(Element element, Class_ c) throws Exception {
        Vector<Room> rooms = new Vector<Room>();
        String elementName = "room";
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element roomElement = (Element)it.next();
                String building = this.getRequiredStringAttribute(roomElement, "building", elementName);
                String roomNbr = this.getRequiredStringAttribute(roomElement, "roomNbr", elementName);
                String id = this.getOptionalStringAttribute(roomElement, "id");
                Room room = this.findRoom(id, building, roomNbr);
                if (room != null) {
                    rooms.add(room);
                    continue;
                }
                this.addMissingLocation(building + " " + roomNbr + " - " + c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation());
            }
        }
        if (rooms.isEmpty()) {
            return null;
        }
        return rooms;
    }

    private Vector<NonUniversityLocation> elementLocation(Element element, Class_ c) throws Exception {
        Vector<NonUniversityLocation> locations = new Vector<NonUniversityLocation>();
        String elementName = "location";
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element roomElement = (Element)it.next();
                String name = this.getRequiredStringAttribute(roomElement, "name", elementName);
                String id = this.getOptionalStringAttribute(roomElement, "id");
                NonUniversityLocation location = this.findNonUniversityLocation(id, name, c.getManagingDept());
                if (location != null) {
                    locations.add(location);
                    continue;
                }
                this.addMissingLocation(name + " - " + c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation());
            }
        }
        if (locations.isEmpty()) {
            return null;
        }
        return locations;
    }

    private boolean elementMeetings(Element element, Class_ c) throws Exception {
        String elementName = "meeting";
        boolean changed = false;
        Vector<Meeting> meetings = new Vector<Meeting>();
        if (element.element(elementName) != null) {
            Calendar sessionStartDate = Calendar.getInstance();
            sessionStartDate.setTime(this.session.getSessionBeginDateTime());
            Calendar sessionClassesEndDate = Calendar.getInstance();
            sessionClassesEndDate.setTime(this.session.getExamBeginDate());
            sessionClassesEndDate.add(5, -1);
            Calendar sessionEndDate = Calendar.getInstance();
            sessionEndDate.setTime(this.session.getSessionEndDateTime());
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element meetingElement = (Element)it.next();
                String startDateStr = this.getOptionalStringAttribute(meetingElement, "startDate");
                String endDateStr = this.getOptionalStringAttribute(meetingElement, "endDate");
                String startTime = this.getRequiredStringAttribute(meetingElement, "startTime", elementName);
                String endTime = this.getRequiredStringAttribute(meetingElement, "endTime", elementName);
                String days = this.getRequiredStringAttribute(meetingElement, "days", elementName);
                String building = this.getOptionalStringAttribute(meetingElement, "building");
                String roomNbr = this.getOptionalStringAttribute(meetingElement, "room");
                String location = this.getOptionalStringAttribute(meetingElement, "location");
                Calendar startDate = null;
                Calendar endDate = null;
                if (startDateStr == null && endDateStr == null) {
                    startDate = sessionStartDate;
                    endDate = sessionClassesEndDate;
                } else if (this.dateFormat != null) {
                    startDate = Calendar.getInstance();
                    startDate.setTime(CalendarUtils.getDate(startDateStr, this.dateFormat));
                    endDate = Calendar.getInstance();
                    endDate.setTime(CalendarUtils.getDate(endDateStr, this.dateFormat));
                } else {
                    startDate = this.getCalendarForDate(startDateStr);
                    endDate = this.getCalendarForDate(endDateStr);
                }
                if (endDate.before(startDate)) {
                    endDate.add(1, 1);
                }
                if ((endDate.equals(sessionEndDate) || endDate.before(sessionEndDate) && endDate.after(sessionClassesEndDate)) && startDate.before(sessionClassesEndDate)) {
                    endDate = sessionClassesEndDate;
                }
                EventRelatedImports.TimeObject timeObject = new EventRelatedImports.TimeObject(this, startTime, endTime, days);
                Vector<Room> rooms = new Vector<Room>();
                Vector<NonUniversityLocation> nonUniversityLocations = new Vector<NonUniversityLocation>();
                if (building != null && roomNbr != null) {
                    Room r = this.findRoom(null, building, roomNbr);
                    if (r != null) {
                        rooms.add(r);
                    } else {
                        this.addMissingLocation(building + " " + roomNbr + " - " + c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation());
                    }
                } else if (location != null) {
                    NonUniversityLocation nul = this.findNonUniversityLocation(null, location, c.getManagingDept());
                    if (nul != null) {
                        nonUniversityLocations.add(nul);
                    } else {
                        this.addMissingLocation(location + " - " + c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getSubjectAreaAbbreviation());
                    }
                }
                Vector<Calendar> startDates = new Vector<Calendar>();
                startDates.add(startDate);
                Vector<Calendar> endDates = new Vector<Calendar>();
                endDates.add(endDate);
                Vector<Meeting> m = null;
                m = startDate.equals(sessionStartDate) && (endDate.equals(sessionClassesEndDate) || endDate.equals(sessionEndDate)) ? this.getMeetings(this.session.getDefaultDatePattern(), timeObject, rooms, nonUniversityLocations) : this.getMeetings(startDate.getTime(), endDate.getTime(), this.createPatternString(startDates, endDates), timeObject, rooms, nonUniversityLocations);
                if (m == null || m.isEmpty()) continue;
                meetings.addAll(m);
            }
            changed = this.addUpdateClassEvent(c, meetings, null, null);
            if (changed) {
                c.setDatePattern(this.assignmentHelper.getDatePattern(c.getEvent()));
            }
        }
        return changed;
    }

    private boolean elementInstructor(Element element, Class_ c) throws Exception {
        boolean changed = false;
        String elementName = "instructor";
        ArrayList<ClassInstructor> existingInstructors = new ArrayList<ClassInstructor>(c.getClassInstructors());
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element instructorElement = (Element)it.next();
                String id = this.getRequiredStringAttribute(instructorElement, "id", elementName);
                if (this.trimLeadingZerosFromExternalId) {
                    try {
                        Integer num = new Integer(id);
                        id = num.toString();
                    }
                    catch (Exception num) {
                        // empty catch block
                    }
                }
                String responsibility = this.getOptionalStringAttribute(instructorElement, "responsibility");
                ClassInstructor instructor = null;
                Iterator ciIt = existingInstructors.iterator();
                while (ciIt.hasNext()) {
                    ClassInstructor ci = (ClassInstructor)ciIt.next();
                    if (!id.equals(ci.getInstructor().getExternalUniqueId()) || !ToolBox.equals((Object)responsibility, ci.getResponsibility() == null ? null : ci.getResponsibility().getReference())) continue;
                    instructor = ci;
                    ciIt.remove();
                    break;
                }
                String firstName = this.getOptionalStringAttribute(instructorElement, "fname");
                String middleName = this.getOptionalStringAttribute(instructorElement, "mname");
                String lastName = this.getOptionalStringAttribute(instructorElement, "lname");
                String acadTitle = this.getOptionalStringAttribute(instructorElement, "title");
                Integer share = this.getOptionalIntegerAttribute(instructorElement, "share");
                boolean lead = this.getOptionalBooleanAttribute(instructorElement, "lead", true);
                boolean addNew = false;
                if (instructor == null) {
                    DepartmentalInstructor di = this.findDepartmentalInstructorWithExternalUniqueId(id, c.getSchedulingSubpart().getControllingDept());
                    if (di == null) {
                        Staff staffData;
                        di = new DepartmentalInstructor();
                        di.setDepartment(c.getSchedulingSubpart().getControllingDept());
                        di.setExternalUniqueId(id);
                        if (lastName == null && (staffData = this.findStaffMember(id, c.getSchedulingSubpart().getControllingDept())) != null) {
                            firstName = staffData.getFirstName();
                            middleName = staffData.getMiddleName();
                            lastName = staffData.getLastName();
                            acadTitle = staffData.getAcademicTitle();
                        }
                        di.setFirstName(firstName);
                        di.setMiddleName(middleName);
                        di.setAcademicTitle(acadTitle);
                        di.setLastName(lastName != null ? lastName : "Unknown Name");
                        di.setIgnoreToFar(new Boolean(false));
                        this.getHibSession().save((Object)di);
                        this.getHibSession().flush();
                        this.getHibSession().refresh((Object)di);
                        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, di, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
                    }
                    instructor = new ClassInstructor();
                    instructor.setClassInstructing(c);
                    c.addToclassInstructors(instructor);
                    instructor.setInstructor(di);
                    di.addToclasses(instructor);
                    changed = true;
                    addNew = true;
                }
                if (instructor.getPercentShare() == null || !instructor.getPercentShare().equals(share)) {
                    instructor.setPercentShare(share);
                    changed = true;
                }
                if (instructor.isLead() == null || !instructor.isLead().equals(lead)) {
                    instructor.setLead(lead);
                    changed = true;
                }
                if (!ToolBox.equals((Object)(instructor.getResponsibility() == null ? null : instructor.getResponsibility().getReference()), (Object)responsibility)) {
                    instructor.setResponsibility(TeachingResponsibility.getTeachingResponsibility(responsibility, this.getHibSession()));
                    changed = true;
                }
                if (!changed) continue;
                this.getHibSession().saveOrUpdate((Object)c);
                this.getHibSession().flush();
                this.getHibSession().refresh((Object)c);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, instructor, ChangeLog.Source.DATA_IMPORT_OFFERINGS, addNew ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
            }
        }
        if (!existingInstructors.isEmpty()) {
            for (ClassInstructor ci : existingInstructors) {
                this.deleteClassInstructor(ci);
                changed = true;
            }
        }
        return changed;
    }

    private Staff findStaffMember(String id, Department department) {
        Staff staff;
        if (department != null && (staff = (Staff)this.getHibSession().createQuery("select distinct s from Staff s where s.externalUniqueId=:externalId and s.dept=:dept").setString("externalId", id).setString("dept", department.getDeptCode()).setCacheable(true).uniqueResult()) != null) {
            return staff;
        }
        List staffs = this.getHibSession().createQuery("select distinct s from Staff s where s.externalUniqueId=:externalId").setString("externalId", id).setCacheable(true).list();
        if (!staffs.isEmpty()) {
            return (Staff)staffs.get(0);
        }
        return null;
    }

    private void elementCourseCredit(Element element, CourseOffering co) throws Exception {
        String elementName = "courseCredit";
        Element credit = element.element(elementName);
        if (credit == null) {
            credit = element.getParent().element(elementName);
        }
        if (credit != null) {
            CourseCreditUnitConfig ccuc;
            String creditFormat = this.getRequiredStringAttribute(credit, "creditFormat", elementName);
            String creditType = this.getRequiredStringAttribute(credit, "creditType", elementName);
            String creditUnitType = this.getRequiredStringAttribute(credit, "creditUnitType", elementName);
            Boolean fractionalIncrementsAllowed = this.getOptionalBooleanAttribute(credit, "fractionalCreditAllowed", true);
            String minCreditStr = this.getOptionalStringAttribute(credit, "fixedCredit");
            if (minCreditStr == null) {
                minCreditStr = this.getOptionalStringAttribute(credit, "minimumCredit");
            }
            Float minCredit = null;
            if (minCreditStr != null) {
                minCredit = new Float(minCreditStr);
            }
            String maxCreditStr = this.getOptionalStringAttribute(credit, "maximumCredit");
            Float maxCredit = null;
            if (maxCreditStr != null) {
                maxCredit = Float.valueOf(Float.parseFloat(maxCreditStr));
            }
            if ((ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(creditFormat, creditType, creditUnitType, minCredit, maxCredit, fractionalIncrementsAllowed, (Boolean)true)) != null) {
                co.setCredit(ccuc);
                ccuc.setOwner(co);
            }
        }
    }

    private boolean elementSubpartCredit(Element element, SchedulingSubpart ss) throws Exception {
        boolean changed = false;
        String elementName = "subpartCredit";
        Element credit = element.element(elementName);
        if (credit != null) {
            String creditFormat = this.getRequiredStringAttribute(credit, "creditFormat", elementName);
            String creditType = this.getRequiredStringAttribute(credit, "creditType", elementName);
            String creditUnitType = this.getRequiredStringAttribute(credit, "creditUnitType", elementName);
            Boolean fractionalIncrementsAllowed = this.getOptionalBooleanAttribute(credit, "fractionalCreditAllowed", true);
            String minCreditStr = this.getOptionalStringAttribute(credit, "fixedCredit");
            if (minCreditStr == null) {
                minCreditStr = this.getOptionalStringAttribute(credit, "minimumCredit");
            }
            Float minCredit = null;
            if (minCreditStr != null) {
                minCredit = new Float(minCreditStr);
            }
            String maxCreditStr = this.getOptionalStringAttribute(credit, "maximumCredit");
            Float maxCredit = null;
            if (maxCreditStr != null) {
                maxCredit = Float.valueOf(Float.parseFloat(maxCreditStr));
            }
            CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(creditFormat, creditType, creditUnitType, minCredit, maxCredit, fractionalIncrementsAllowed, (Boolean)false);
            if (ss.getCredit() == null && ccuc != null) {
                this.addNote("\tadded subpart credit");
                changed = true;
            } else if (ss.getCredit() != null && !this.isSameCreditConfig(ss.getCredit(), ccuc)) {
                this.addNote("\tsubpart credit values changed");
                changed = true;
            }
            if (changed) {
                ss.setCredit(ccuc);
                ccuc.setOwner(ss);
                this.getHibSession().saveOrUpdate((Object)ss);
                this.getHibSession().flush();
                this.getHibSession().refresh((Object)ss);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ss.getCredit(), ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, ss.getControllingCourseOffering().getSubjectArea(), ss.getControllingCourseOffering().getDepartment());
            }
        }
        return changed;
    }

    private boolean handleDistributionPrefElement(Element element, Class_ c, String elementName, DistributionType distributionType) throws Exception {
        boolean changed = false;
        Vector<DistributionPref> existingDistPrefs = new Vector<DistributionPref>();
        if (c.getDistributionPreferences() != null) {
            for (DistributionPref dp : c.getDistributionPreferences()) {
                if (!dp.getDistributionType().getUniqueId().equals(distributionType.getUniqueId())) continue;
                existingDistPrefs.add(dp);
            }
        }
        Vector<String> classIds = new Vector<String>();
        if (element.element(elementName) != null) {
            classIds.add(this.getExternalUniqueId(c));
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element distPrefElement = (Element)it.next();
                classIds.add(this.getRequiredStringAttribute(distPrefElement, "id", elementName));
            }
        }
        if (existingDistPrefs.size() != 1) {
            if (existingDistPrefs.size() > 1) {
                this.addNote("\tMultiple " + distributionType.getLabel() + " distribution preferences exist -- deleted them");
                for (DistributionPref dp : existingDistPrefs) {
                    this.addNote("\t\tdeleted '" + dp.preferenceText() + "'");
                    this.deleteDistributionPref(dp);
                }
                changed = true;
            }
            if (classIds.size() > 1) {
                this.addDistributionPref(classIds, c, distributionType);
                changed = true;
            }
        } else {
            DistributionPref dp;
            dp = (DistributionPref)existingDistPrefs.firstElement();
            if (classIds.size() > 1) {
                if (!this.isMatchingDistPref(dp, classIds)) {
                    changed = true;
                    this.deleteDistributionPref(dp);
                    this.addDistributionPref(classIds, c, distributionType);
                }
            } else {
                this.addNote("Class  " + c.getClassLabel() + " is no longer a " + distributionType.getLabel() + ", removed" + dp.toString());
                this.deleteDistributionPref(dp);
                changed = true;
            }
        }
        return changed;
    }

    private boolean elementCanShareRoom(Element element, Class_ c) throws Exception {
        if (!this.useCanShareRoomElement) {
            return false;
        }
        return this.handleDistributionPrefElement(element, c, "canShareRoom", this.canShareRoomType);
    }

    private boolean elementMeetsWith(Element element, Class_ c) throws Exception {
        if (!this.useMeetsWithElement) {
            return false;
        }
        return this.handleDistributionPrefElement(element, c, "meetsWith", this.meetsWithType);
    }

    private boolean isMatchingDistPref(DistributionPref dp, Vector<String> classExternalIds) {
        boolean isSame = false;
        DistributionObject distObj2 = null;
        String cei2 = null;
        boolean allFound = true;
        HashSet<DistributionObject> existingDistObjs = new HashSet<DistributionObject>();
        existingDistObjs.addAll(dp.getDistributionObjects());
        for (String cei2 : classExternalIds) {
            boolean found = false;
            for (DistributionObject distObj2 : dp.getDistributionObjects()) {
                Class_ c;
                if (!(distObj2.getPrefGroup() instanceof Class_) || !cei2.equals(this.getExternalUniqueId(c = (Class_)distObj2.getPrefGroup()))) continue;
                found = true;
                existingDistObjs.remove(distObj2);
                break;
            }
            if (found) continue;
            allFound = false;
            break;
        }
        if (allFound && existingDistObjs.isEmpty()) {
            isSame = true;
        }
        return isSame;
    }

    protected abstract boolean handleCustomCourseChildElements(CourseOffering var1, Element var2) throws Exception;

    private boolean elementCourse(Element element, InstructionalOffering io, String action) throws Exception {
        boolean changed = false;
        if (io.getControllingCourseOffering() != null) {
            Debug.info("Checking Offering:  " + io.getCourseName());
        }
        ArrayList<ImportCourseOffering> courses = this.getCourses(element);
        if (action.equalsIgnoreCase("insert")) {
            for (ImportCourseOffering ico : courses) {
                CourseOffering co = ico.getCourseOffering();
                co.setInstructionalOffering(io);
                if (co.getNbrExpectedStudents() == null) {
                    co.setNbrExpectedStudents(new Integer(0));
                }
                if (co.getDemand() == null) {
                    co.setDemand(new Integer(0));
                }
                io.addTocourseOfferings(co);
                co.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SessionImplementor)new CourseOfferingDAO().getSession(), (Object)this).toString());
                co.setSubjectAreaAbbv(co.getSubjectArea().getSubjectAreaAbbreviation());
                this.addNote("\tadded course: " + co.getSubjectArea().getSubjectAreaAbbreviation() + " " + co.getCourseNbr());
                if (co.getCredit() != null) {
                    this.addNote("\tadded credit: " + co.getCredit().creditAbbv());
                }
                this.getHibSession().saveOrUpdate((Object)io);
                this.getHibSession().flush();
                this.getHibSession().refresh((Object)io);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, co, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, co.getSubjectArea(), co.getDepartment());
                this.handleCustomCourseChildElements(co, ico.getElement());
            }
            changed = true;
        } else {
            CourseOffering nco = null;
            CourseOffering oco2 = null;
            for (ImportCourseOffering ico : courses) {
                nco = ico.getCourseOffering();
                boolean exists = false;
                for (CourseOffering oco2 : io.getCourseOfferings()) {
                    CourseCreditUnitConfig old;
                    if (!this.isSameCourseOffering(oco2, nco)) continue;
                    exists = true;
                    this.existingCourseOfferings.remove(oco2.getUniqueId());
                    if (!oco2.getSubjectArea().getUniqueId().equals(nco.getSubjectArea().getUniqueId())) {
                        oco2.setSubjectArea(nco.getSubjectArea());
                        this.addNote("\tchanged subject area: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (!oco2.getCourseNbr().equals(nco.getCourseNbr())) {
                        oco2.setCourseNbr(nco.getCourseNbr());
                        this.addNote("\tchanged course number: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (!oco2.isIsControl().equals(nco.getIsControl())) {
                        oco2.setIsControl(nco.getIsControl());
                        this.addNote("\tchanged control flag: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (oco2.getScheduleBookNote() == null && nco.getScheduleBookNote() != null) {
                        oco2.setScheduleBookNote(nco.getScheduleBookNote());
                        this.addNote("\tadded schedule book note: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    } else if (oco2.getScheduleBookNote() != null && (nco.getScheduleBookNote() == null || nco.getScheduleBookNote().length() == 0)) {
                        if (!this.incremental) {
                            oco2.setScheduleBookNote(null);
                            this.addNote("\tremoved schedule book note: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                            changed = true;
                        }
                    } else if (oco2.getScheduleBookNote() != null && nco.getScheduleBookNote() != null && !oco2.getScheduleBookNote().equals(nco.getScheduleBookNote())) {
                        oco2.setScheduleBookNote(nco.getScheduleBookNote());
                        this.addNote("\tchanged schedule book note: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (oco2.getTitle() == null && nco.getTitle() != null && nco.getTitle().length() > 0) {
                        oco2.setTitle(nco.getTitle());
                        this.addNote("\tadded title: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    } else if (oco2.getTitle() != null && (nco.getTitle() == null || nco.getTitle().length() == 0)) {
                        oco2.setTitle(null);
                        this.addNote("\tremoved title: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    } else if (oco2.getTitle() != null && nco.getTitle() != null && !oco2.getTitle().equals(nco.getTitle())) {
                        oco2.setTitle(nco.getTitle());
                        this.addNote("\tchanged title: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (oco2.getConsentType() == null && nco.getConsentType() != null) {
                        oco2.setConsentType(nco.getConsentType());
                        this.addNote("\tadded consent: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    } else if (oco2.getConsentType() != null && nco.getConsentType() == null) {
                        if (!this.incremental) {
                            oco2.setConsentType(null);
                            this.addNote("\tremoved consent: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                            changed = true;
                        }
                    } else if (oco2.getConsentType() != null && nco.getConsentType() != null && !oco2.getConsentType().equals(nco.getConsentType())) {
                        oco2.setConsentType(nco.getConsentType());
                        this.addNote("\tchanged consent: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (oco2.getCredit() == null && nco.getCredit() != null) {
                        CourseCreditUnitConfig credit = nco.getCredit();
                        oco2.setCredit(credit);
                        credit.setOwner(oco2);
                        this.addNote("\tadded credit: " + nco.getCredit().creditAbbv());
                        changed = true;
                    } else if (oco2.getCredit() != null && nco.getCredit() == null) {
                        if (!this.incremental) {
                            old = oco2.getCredit();
                            this.getHibSession().delete((Object)old);
                            oco2.setCredit(null);
                            this.addNote("\tremoved credit: " + old);
                            changed = true;
                        }
                    } else if (oco2.getCredit() != null && !this.isSameCreditConfig(oco2.getCredit(), nco.getCredit())) {
                        old = oco2.getCredit();
                        this.getHibSession().delete((Object)old);
                        CourseCreditUnitConfig credit = nco.getCredit();
                        oco2.setCredit(credit);
                        credit.setOwner(oco2);
                        this.addNote("\tchanged credit: " + oco2.getCredit().creditAbbv());
                        changed = true;
                    }
                    if (oco2.getPermId() == null) {
                        oco2.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SessionImplementor)new CourseOfferingDAO().getSession(), (Object)this).toString());
                        this.addNote("\tadded missing permId: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (oco2.getReservation() == null && nco.getReservation() != null) {
                        oco2.setReservation(nco.getReservation());
                        this.addNote("\tadded reservation: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    } else if (oco2.getReservation() != null && nco.getReservation() == null) {
                        if (!this.incremental) {
                            oco2.setReservation(null);
                            this.addNote("\tremoved reservation: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                            changed = true;
                        }
                    } else if (oco2.getReservation() != null && nco.getReservation() != null && !oco2.getReservation().equals(nco.getReservation())) {
                        oco2.setReservation(nco.getReservation());
                        this.addNote("\tchanged reservation: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                        changed = true;
                    }
                    if (this.handleCustomCourseChildElements(oco2, ico.getElement())) {
                        changed = true;
                    }
                    if (!changed) continue;
                    ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, oco2, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, oco2.getSubjectArea(), oco2.getDepartment());
                }
                if (exists) continue;
                this.addNote("\tmatching course offering not found, added new: " + nco.getSubjectArea().getSubjectAreaAbbreviation() + " " + nco.getCourseNbr());
                if (nco.getNbrExpectedStudents() == null) {
                    nco.setNbrExpectedStudents(new Integer(0));
                }
                if (nco.getDemand() == null) {
                    nco.setDemand(new Integer(0));
                }
                nco.setSubjectAreaAbbv(nco.getSubjectArea().getSubjectAreaAbbreviation());
                nco.setInstructionalOffering(io);
                if (nco.getCredit() != null) {
                    this.addNote("\tadded credit: " + nco.getCredit().creditAbbv());
                }
                io.addTocourseOfferings(nco);
                changed = true;
                this.getHibSession().saveOrUpdate((Object)io);
                this.getHibSession().flush();
                this.getHibSession().refresh((Object)io);
                this.handleCustomCourseChildElements(nco, ico.getElement());
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, nco, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, nco.getSubjectArea(), nco.getDepartment());
            }
            ArrayList<CourseOffering> removeCourses = new ArrayList<CourseOffering>();
            removeCourses.addAll(io.getCourseOfferings());
            for (CourseOffering co : removeCourses) {
                if (co.getUniqueId() == null || !this.existingCourseOfferings.contains(co.getUniqueId())) continue;
                this.addNote("\tremoved course offering from instructional offering: " + co.getCourseName());
                this.deleteCourseOffering(co);
                changed = true;
            }
            boolean hasControl = false;
            for (CourseOffering co : io.getCourseOfferings()) {
                if (!co.isIsControl().booleanValue()) continue;
                hasControl = true;
            }
            if (!hasControl) {
                throw new Exception("Expected 'offering' to have a course marked as control.");
            }
        }
        return changed;
    }

    private boolean elementInstrOffrConfig(Element element, InstructionalOffering io) throws Exception {
        String elementName;
        boolean changed = false;
        HashMap<String, InstrOfferingConfig> existingConfigs = new HashMap<String, InstrOfferingConfig>();
        if (io.getInstrOfferingConfigs() != null) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                existingConfigs.put(ioc.getName(), ioc);
            }
        }
        if (element.element(elementName = "config") != null) {
            Iterator<InstrOfferingConfig> it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element configElement = (Element)it.next();
                boolean addNew = false;
                String name = this.getRequiredStringAttribute(configElement, "name", elementName);
                String limitStr = this.getRequiredStringAttribute(configElement, "limit", elementName);
                Integer limit = new Integer(0);
                Boolean unlimited = new Boolean(false);
                if (limitStr.equalsIgnoreCase("inf")) {
                    unlimited = new Boolean(true);
                } else {
                    limit = Integer.valueOf(limitStr);
                }
                InstrOfferingConfig ioc = null;
                if (existingConfigs.containsKey(name)) {
                    ioc = (InstrOfferingConfig)existingConfigs.get(name);
                    existingConfigs.remove(name);
                } else {
                    this.addNote("\tdid not find matching config element, adding new config: " + name);
                    ioc = new InstrOfferingConfig();
                    ioc.setName(name);
                    ioc.setInstructionalOffering(io);
                    io.addToinstrOfferingConfigs(ioc);
                    changed = true;
                    addNew = true;
                }
                if (ioc.getLimit() == null || !ioc.getLimit().equals(limit)) {
                    this.addNote("\tconfig limit changed");
                    ioc.setLimit(limit);
                    changed = true;
                }
                if (ioc.isUnlimitedEnrollment() == null || !ioc.isUnlimitedEnrollment().equals(unlimited)) {
                    this.addNote("\tconfig unlimited changed");
                    ioc.setUnlimitedEnrollment(unlimited);
                    changed = true;
                }
                String durationTypeStr = this.getOptionalStringAttribute(configElement, "durationType");
                if (ioc.getClassDurationType() == null && durationTypeStr != null || ioc.getClassDurationType() != null && !ioc.getClassDurationType().getReference().equals(durationTypeStr)) {
                    ioc.setClassDurationType(durationTypeStr == null ? null : ClassDurationType.findByReference(durationTypeStr, this.getHibSession()));
                    this.addNote("\tduration type changed");
                    changed = true;
                }
                String instructionalMethodStr = this.getOptionalStringAttribute(configElement, "instructionalMethod");
                if (ioc.getInstructionalMethod() == null && instructionalMethodStr != null || ioc.getInstructionalMethod() != null && !ioc.getInstructionalMethod().getReference().equals(instructionalMethodStr)) {
                    ioc.setInstructionalMethod(instructionalMethodStr == null ? null : InstructionalMethod.findByReference(instructionalMethodStr, this.getHibSession()));
                    this.addNote("\tinstructional method changed");
                    changed = true;
                }
                if (changed) {
                    this.getHibSession().saveOrUpdate((Object)ioc);
                }
                if (this.handleCustomInstrOffrConfigChildElements(ioc, configElement)) {
                    this.addNote("\tconfig changed by custom element");
                    changed = true;
                }
                if (this.elementSubpart(configElement, ioc, null, null)) {
                    this.addNote("\tconfig subparts changed");
                    changed = true;
                }
                if (changed) {
                    this.getHibSession().saveOrUpdate((Object)ioc);
                }
                if (this.elementClass(configElement, ioc, null, null)) {
                    this.addNote("\tconfig classes changed");
                    changed = true;
                }
                if (!changed) continue;
                this.addNote("\tconfig element changed: " + name);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ioc, ChangeLog.Source.DATA_IMPORT_OFFERINGS, addNew ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getControllingCourseOffering().getDepartment());
                this.getHibSession().saveOrUpdate((Object)ioc);
            }
        } else if (this.incremental) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
                    for (Class_ clazz : subpart.getClasses()) {
                        this.existingClasses.remove(clazz.getUniqueId());
                    }
                }
            }
            return changed;
        }
        if (existingConfigs.size() > 0) {
            for (InstrOfferingConfig ioc : existingConfigs.values()) {
                this.deleteInstrOffrConfig(ioc);
            }
            changed = true;
        }
        return changed;
    }

    private boolean elementClass(Element element, InstrOfferingConfig ioc, Class_ parentClass, HashSet<Class_> allExistingClasses) throws Exception {
        String elementName;
        boolean changed = false;
        HashMap<String, Class_> possibleClassesAtThisLevel = new HashMap<String, Class_>();
        ArrayList<SchedulingSubpart> possibleSubpartsAtThisLevel = new ArrayList<SchedulingSubpart>();
        if (parentClass == null) {
            allExistingClasses = new HashSet();
            if (ioc.getSchedulingSubparts() != null) {
                for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                    if (ss.getClasses() != null) {
                        for (Class_ c : ss.getClasses()) {
                            allExistingClasses.add(c);
                            if (c.getParentClass() != null) continue;
                            possibleClassesAtThisLevel.put(this.getExternalUniqueId(c), c);
                        }
                    }
                    if (ss.getParentSubpart() != null) continue;
                    possibleSubpartsAtThisLevel.add(ss);
                }
            }
        } else {
            if (parentClass.getChildClasses() != null) {
                for (Class_ c : parentClass.getChildClasses()) {
                    possibleClassesAtThisLevel.put(this.getExternalUniqueId(c), c);
                }
            }
            if (parentClass.getSchedulingSubpart().getChildSubparts() != null) {
                possibleSubpartsAtThisLevel.addAll(parentClass.getSchedulingSubpart().getChildSubparts());
            }
        }
        if (element.element(elementName = "class") != null) {
            if (parentClass == null && (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().isEmpty())) {
                throw new Exception(ioc.getCourseName() + " - If a 'config' has 'class' elements it must also have matching 'subpart' elements");
            }
            Iterator<PreferenceGroup> cIt = element.elementIterator(elementName);
            while (cIt.hasNext()) {
                Element classElement = (Element)cIt.next();
                boolean isAdd = false;
                String id = this.getOptionalStringAttribute(classElement, "id");
                String managingDeptStr = this.getOptionalStringAttribute(classElement, "managingDept");
                Department managingDept = null;
                if (managingDeptStr != null && managingDeptStr.trim().length() > 0) {
                    managingDept = Department.findByDeptCode(managingDeptStr.trim(), this.session.getUniqueId());
                }
                String limitStr = this.getRequiredStringAttribute(classElement, "limit", elementName);
                Integer limit = new Integer(0);
                if (!limitStr.equalsIgnoreCase("inf")) {
                    limit = Integer.valueOf(limitStr);
                }
                String suffix = this.getRequiredStringAttribute(classElement, "suffix", elementName);
                String type = this.getRequiredStringAttribute(classElement, "type", elementName);
                String scheduleNote = this.getOptionalStringAttribute(classElement, "scheduleNote");
                Boolean enabledForStudentScheduling = this.getOptionalBooleanAttribute(classElement, "studentScheduling", this.getOptionalBooleanAttribute(classElement, "displayInScheduleBook", true));
                boolean cancelled = this.getOptionalBooleanAttribute(classElement, "cancelled", false);
                Integer itypeId = this.findItypeForString(type).getItype();
                Integer nbrRooms = this.getOptionalIntegerAttribute(classElement, "nbrRooms");
                Class_ clazz = null;
                Class_ origClass = null;
                if (id != null && (origClass = (Class_)possibleClassesAtThisLevel.get(id)) != null) {
                    possibleClassesAtThisLevel.remove(id);
                    if (!BaseCourseOfferingImport.equals(origClass.getClassSuffix(), suffix)) {
                        changed = true;
                        origClass.setClassSuffix(suffix);
                        Integer origSectionNbr = origClass.getSectionNumberCache();
                        try {
                            origClass.setSectionNumberCache(new Integer(suffix));
                        }
                        catch (Exception e) {
                            origClass.setSectionNumberCache(origSectionNbr);
                        }
                        this.addNote("\t suffix for class changed: " + origClass.getClassLabel());
                    }
                }
                if (origClass == null) {
                    origClass = (Class_)possibleClassesAtThisLevel.get(ioc.getInstructionalOffering().getControllingCourseOffering().getCourseName() + " " + type + " " + suffix);
                    if (origClass != null && this.getExternalUniqueId(origClass) != null && id != null && !this.getExternalUniqueId(origClass).equals(id)) {
                        origClass = null;
                    } else if (origClass != null) {
                        possibleClassesAtThisLevel.remove(type + suffix);
                    }
                }
                if (origClass != null) {
                    clazz = origClass;
                    allExistingClasses.remove(origClass);
                    this.existingClasses.remove(clazz.getUniqueId());
                    SchedulingSubpart prevSubpart = clazz.getSchedulingSubpart();
                    if (!clazz.getSchedulingSubpart().getItype().getItype().equals(itypeId) || !possibleSubpartsAtThisLevel.contains(clazz.getSchedulingSubpart())) {
                        for (SchedulingSubpart ss : possibleSubpartsAtThisLevel) {
                            if (!ss.getItype().getItype().equals(itypeId)) continue;
                            Session hSess = this.getHibSession();
                            clazz.setSchedulingSubpart(ss);
                            ss.addToclasses(clazz);
                            hSess.update((Object)ss);
                            hSess.flush();
                            hSess.refresh((Object)ss);
                            hSess.refresh((Object)prevSubpart);
                            break;
                        }
                        prevSubpart.getClasses().remove(clazz);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' itype changed");
                        changed = true;
                    }
                    if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().equals(scheduleNote) || clazz.getSchedulePrintNote() == null && scheduleNote != null) {
                        clazz.setSchedulePrintNote(scheduleNote);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' schedule note changed");
                        changed = true;
                    }
                    if (clazz.getExpectedCapacity() != null && !clazz.getExpectedCapacity().equals(limit) || clazz.getExpectedCapacity() == null && limit != null) {
                        clazz.setExpectedCapacity(limit);
                        clazz.setMaxExpectedCapacity(limit);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' limit changed");
                        changed = true;
                    }
                    if (clazz.getManagingDept() != null && managingDept != null && !clazz.getManagingDept().getUniqueId().equals(managingDept.getUniqueId()) || clazz.getManagingDept() == null && managingDept != null) {
                        clazz.setManagingDept(managingDept);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' managing department changed");
                        changed = true;
                    }
                    if (!enabledForStudentScheduling.equals(clazz.isEnabledForStudentScheduling())) {
                        clazz.setEnabledForStudentScheduling(enabledForStudentScheduling);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' display in schedule book changed");
                        changed = true;
                    }
                    if (nbrRooms != null && !nbrRooms.equals(clazz.getNbrRooms())) {
                        clazz.setNbrRooms(nbrRooms);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' number of rooms changed");
                        changed = true;
                    }
                    if (cancelled != clazz.isCancelled()) {
                        clazz.setCancelled(cancelled);
                        if (cancelled) {
                            this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' cancelled");
                        } else {
                            this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' reopened");
                        }
                        changed = true;
                    }
                } else {
                    isAdd = true;
                    clazz = new Class_();
                    clazz.setExternalUniqueId(id);
                    clazz.setClassSuffix(suffix);
                    clazz.setCancelled(false);
                    try {
                        clazz.setSectionNumberCache(new Integer(suffix));
                    }
                    catch (Exception prevSubpart) {
                        // empty catch block
                    }
                    clazz.setExpectedCapacity(limit);
                    clazz.setMaxExpectedCapacity(limit);
                    clazz.setRoomRatio(new Float(1.0));
                    if (nbrRooms != null) {
                        clazz.setNbrRooms(nbrRooms);
                    } else {
                        clazz.setNbrRooms(new Integer(1));
                    }
                    clazz.setEnabledForStudentScheduling(enabledForStudentScheduling);
                    clazz.setSchedulePrintNote(scheduleNote);
                    clazz.setCancelled(cancelled);
                    clazz.setDisplayInstructor(new Boolean(true));
                    if (parentClass != null) {
                        clazz.setParentClass(parentClass);
                        parentClass.addTochildClasses(clazz);
                    }
                    for (SchedulingSubpart ss : possibleSubpartsAtThisLevel) {
                        if (!ss.getItype().getItype().equals(itypeId)) continue;
                        clazz.setSchedulingSubpart(ss);
                        ss.addToclasses(clazz);
                        break;
                    }
                    if (managingDept != null) {
                        clazz.setManagingDept(managingDept);
                    }
                    clazz.setClassInstructors(new HashSet<ClassInstructor>());
                    this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' matching class not found adding new class");
                    changed = true;
                }
                if (clazz.getSchedulingSubpart() == null) {
                    throw new Exception(ioc.getCourseName() + " " + type + " " + suffix + " 'class' does not have matching 'subpart'");
                }
                if (this.elementInstructor(classElement, clazz)) {
                    this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' instructor data changed");
                    changed = true;
                }
                DatePattern dp = null;
                if (classElement.element("time") != null && classElement.element("time").attributeValue("datePattern") != null) {
                    dp = DatePattern.findByName(this.session, classElement.element("time").attributeValue("datePattern"));
                }
                HashMap<String, Vector<Calendar>> dates = this.elementDates(classElement);
                if (dp == null && dates != null) {
                    dp = this.findDatePattern(dates.get("startDates"), dates.get("endDates"), clazz);
                }
                if (classElement.element("meeting") == null) {
                    if (dp == null && clazz.getDatePattern() != null) {
                        if (!clazz.getDatePattern().isDefault() && clazz.getSchedulingSubpart().effectiveDatePattern().isDefault()) {
                            clazz.setDatePattern(dp);
                            this.addNote("\t" + ioc.getCourseName() + " " + type + suffix + " 'class' date pattern changed back to default");
                            changed = true;
                        } else if (!clazz.getDatePattern().isDefault() && !clazz.getSchedulingSubpart().effectiveDatePattern().isDefault()) {
                            clazz.setDatePattern(this.session.getDefaultDatePatternNotNull());
                            this.addNote("\t" + ioc.getCourseName() + " " + type + suffix + " 'class' date pattern changed to default");
                            changed = true;
                        }
                    } else if (dp != null && clazz.getDatePattern() == null) {
                        clazz.setDatePattern(dp);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + "'class' date pattern changed from default");
                        changed = true;
                    } else if (dp != null && clazz.getDatePattern() != null && !clazz.getDatePattern().getUniqueId().equals(dp.getUniqueId())) {
                        clazz.setDatePattern(dp);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' date pattern changed");
                        changed = true;
                    }
                    if (dp == null) {
                        dp = clazz.effectiveDatePattern();
                    }
                }
                if (changed) {
                    this.getHibSession().saveOrUpdate((Object)clazz);
                }
                if (this.elementMeetsWith(classElement, clazz)) {
                    this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' meets with preferences changed");
                    changed = true;
                }
                if (this.elementCanShareRoom(classElement, clazz)) {
                    this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' can share room preferences changed");
                    changed = true;
                }
                if (classElement.element("meeting") != null) {
                    if (this.elementMeetings(classElement, clazz)) {
                        changed = true;
                    }
                    int numRooms = 1;
                    if (nbrRooms == null && clazz.getNbrRooms() != null && !clazz.getNbrRooms().equals(new Integer(numRooms))) {
                        clazz.setNbrRooms(new Integer(numRooms));
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " number of rooms changed");
                        changed = true;
                    }
                } else if (classElement.element("time") != null) {
                    TimePref tpref;
                    TimePattern tp;
                    EventRelatedImports.TimeObject meetingTime = this.elementTime(classElement);
                    Vector<Room> rooms = this.elementRoom(classElement, clazz);
                    Vector<NonUniversityLocation> locations = this.elementLocation(classElement, clazz);
                    int numRooms = 0;
                    if (rooms != null && !rooms.isEmpty()) {
                        numRooms += rooms.size();
                    }
                    if (locations != null && !locations.isEmpty()) {
                        numRooms += locations.size();
                    }
                    if (nbrRooms == null && clazz.getNbrRooms() != null && !clazz.getNbrRooms().equals(new Integer(numRooms))) {
                        clazz.setNbrRooms(new Integer(numRooms));
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " number of rooms changed");
                        changed = true;
                    }
                    if (this.addUpdateClassEvent(clazz, meetingTime, rooms, locations, tp = this.findTimePatternForMeetingInfo(clazz, meetingTime), dp)) {
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' events for class changed");
                        changed = true;
                    }
                    if (tp != null && clazz.effectiveTimePatterns() != null && !clazz.effectiveTimePatterns().contains(tp)) {
                        if (clazz.getTimePreferences() != null) {
                            for (TimePref pref : clazz.getTimePreferences()) {
                                clazz.getPreferences().remove(pref);
                            }
                        }
                        tpref = new TimePref();
                        tpref.setTimePattern(tp);
                        tpref.setOwner(clazz);
                        tpref.setPrefLevel(this.requiredPrefLevel);
                        clazz.addTopreferences(tpref);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' time pattern for class changed");
                        changed = true;
                    } else if (tp != null && (clazz.getTimePatterns() == null || clazz.getTimePatterns().isEmpty())) {
                        tpref = new TimePref();
                        tpref.setTimePattern(tp);
                        tpref.setOwner(clazz);
                        tpref.setPrefLevel(this.requiredPrefLevel);
                        clazz.addTopreferences(tpref);
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' time pattern for class added");
                        changed = true;
                    } else if (tp == null && clazz.getTimePatterns() != null && !clazz.getTimePatterns().isEmpty()) {
                        for (TimePref pref : clazz.getTimePreferences()) {
                            clazz.getPreferences().remove(pref);
                        }
                        this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' time pattern for class removed");
                        changed = true;
                    }
                }
                if (this.handleCustomClassChildElements(classElement, ioc, clazz)) {
                    changed = true;
                }
                if (this.elementClass(classElement, ioc, clazz, allExistingClasses)) {
                    this.addNote("\t" + ioc.getCourseName() + " " + type + " " + suffix + " 'class' child classes changed");
                    changed = true;
                }
                if (changed) {
                    this.getHibSession().saveOrUpdate((Object)clazz);
                    this.getHibSession().flush();
                    this.getHibSession().refresh((Object)clazz);
                }
                if (!changed) continue;
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, clazz, ChangeLog.Source.DATA_IMPORT_OFFERINGS, isAdd ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getDepartment());
            }
        } else if (this.incremental && parentClass == null) {
            for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
                if (subpart.getClasses() == null) continue;
                for (Class_ clazz : subpart.getClasses()) {
                    this.existingClasses.remove(clazz.getUniqueId());
                }
            }
            return changed;
        }
        if (possibleClassesAtThisLevel.size() > 0) {
            this.addNote("\t" + ioc.getCourseName() + " 'class' not all classes at this level had matches");
            for (Class_ c : possibleClassesAtThisLevel.values()) {
                if (c.getParentClass() == null || !c.getParentClass().equals(parentClass)) continue;
                parentClass.getChildClasses().remove(c);
                c.setParentClass(null);
            }
            changed = true;
        }
        if (parentClass == null && allExistingClasses.size() > 0) {
            this.info(ioc.getCourseName() + " 'class' not all classes had matches, removing those without matches");
            for (Class_ c : allExistingClasses) {
                this.deleteClass(c);
            }
        }
        return changed;
    }

    private TimePattern findTimePatternForMeetingInfo(Class_ clazz, EventRelatedImports.TimeObject timeObject) {
        TimePattern tp;
        if (timeObject.getPatternName() != null && (tp = TimePattern.findByName(this.session, timeObject.getPatternName())) != null) {
            return tp;
        }
        int days = 0;
        for (Integer dayOfWeek : timeObject.getDays()) {
            if (dayOfWeek == 2) {
                days += Constants.DAY_CODES[0];
                continue;
            }
            if (dayOfWeek == 3) {
                days += Constants.DAY_CODES[1];
                continue;
            }
            if (dayOfWeek == 4) {
                days += Constants.DAY_CODES[2];
                continue;
            }
            if (dayOfWeek == 5) {
                days += Constants.DAY_CODES[3];
                continue;
            }
            if (dayOfWeek == 6) {
                days += Constants.DAY_CODES[4];
                continue;
            }
            if (dayOfWeek == 7) {
                days += Constants.DAY_CODES[5];
                continue;
            }
            if (dayOfWeek != 1) continue;
            days += Constants.DAY_CODES[6];
        }
        DatePattern datePattern = clazz.effectiveDatePattern();
        if (datePattern == null) {
            return null;
        }
        DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        if (datePattern.getType() != null && datePattern.getType() == 4) {
            for (DatePattern child : datePattern.findChildren(this.getHibSession())) {
                String timePatternLookupString = days + "x" + dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), child, days) + "x" + timeObject.getStartPeriod().toString();
                TimePattern pattern = this.timePatterns.get(timePatternLookupString);
                if (pattern == null) continue;
                return pattern;
            }
            return null;
        }
        String timePatternLookupString = days + "x" + dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), datePattern, days) + "x" + timeObject.getStartPeriod().toString();
        return this.timePatterns.get(timePatternLookupString);
    }

    protected abstract boolean handleCustomClassChildElements(Element var1, InstrOfferingConfig var2, Class_ var3) throws Exception;

    protected abstract boolean handleCustomInstrOffrConfigChildElements(InstrOfferingConfig var1, Element var2) throws Exception;

    private Vector<Meeting> getMeetings(Date startDate, Date stopDate, String pattern, EventRelatedImports.TimeObject meetingTime, Vector<Room> rooms, Vector<NonUniversityLocation> locations) {
        if (meetingTime != null) {
            Meeting roomMeeting;
            Meeting meeting = meetingTime.asMeeting();
            meeting.setStatus(Meeting.Status.APPROVED);
            meeting.setApprovalDate(Calendar.getInstance().getTime());
            Calendar startDateCal = Calendar.getInstance();
            startDateCal.setTime(startDate);
            Calendar stopDateCal = Calendar.getInstance();
            stopDateCal.setTime(stopDate);
            int index = 0;
            Vector<Meeting> meetingsForDates = new Vector<Meeting>();
            while (!startDateCal.after(stopDateCal)) {
                if (meetingTime.getDays().contains(startDateCal.get(7)) && pattern.charAt(index) == '1') {
                    Meeting dateMeeting = (Meeting)meeting.clone();
                    dateMeeting.setMeetingDate(startDateCal.getTime());
                    meetingsForDates.add(dateMeeting);
                }
                ++index;
                startDateCal.add(5, 1);
            }
            if ((rooms == null || rooms.isEmpty()) && (locations == null || locations.isEmpty())) {
                return meetingsForDates;
            }
            Vector<Meeting> meetingsForLocations = new Vector<Meeting>();
            if (rooms != null) {
                for (Room r : rooms) {
                    for (Meeting dateMeeting : meetingsForDates) {
                        roomMeeting = (Meeting)dateMeeting.clone();
                        roomMeeting.setLocationPermanentId(r.getPermanentId());
                        meetingsForLocations.add(roomMeeting);
                    }
                }
            }
            if (locations != null) {
                for (NonUniversityLocation nul : locations) {
                    for (Meeting dateMeeting : meetingsForDates) {
                        roomMeeting = (Meeting)dateMeeting.clone();
                        roomMeeting.setLocationPermanentId(nul.getPermanentId());
                        meetingsForLocations.add(roomMeeting);
                    }
                }
            }
            if (!meetingsForLocations.isEmpty()) {
                return meetingsForLocations;
            }
        }
        return null;
    }

    private Vector<Meeting> getMeetings(DatePattern dp, EventRelatedImports.TimeObject meetingTime, Vector<Room> rooms, Vector<NonUniversityLocation> locations) {
        return this.getMeetings(dp.getStartDate(), dp.getEndDate(), dp.getPattern(), meetingTime, rooms, locations);
    }

    private void addDistributionPref(Vector<String> classIds, Class_ clazz, DistributionType distributionType) throws Exception {
        if (classIds.size() <= 1) {
            throw new Exception("There must be at least two classes to have a meets with distribution preference: " + clazz.getClassLabel());
        }
        Class_ c2 = null;
        Vector<String> tmpClassIds = new Vector<String>();
        tmpClassIds.addAll(classIds);
        Vector<Class_> classes = new Vector<Class_>();
        String externalId2 = null;
        for (String externalId2 : classIds) {
            if (externalId2.equals(this.getExternalUniqueId(clazz))) {
                classes.add(clazz);
                tmpClassIds.remove(externalId2);
                continue;
            }
            c2 = this.findClassForExternalUniqueId(externalId2);
            if (c2 == null) break;
            classes.add(c2);
            tmpClassIds.remove(externalId2);
        }
        if (!tmpClassIds.isEmpty()) {
            this.addNote("\t not all classes for this meets with pref exist yet, will add it later:" + clazz.getClassLabel());
        } else {
            DistributionPref dp = new DistributionPref();
            dp.setDistributionType(distributionType);
            dp.setStructure(DistributionPref.Structure.AllClasses);
            dp.setPrefLevel(this.requiredPrefLevel);
            dp.setOwner(clazz.getSchedulingSubpart().getControllingDept());
            for (Class_ c2 : classes) {
                DistributionObject distObj = new DistributionObject();
                distObj.setDistributionPref(dp);
                distObj.setPrefGroup(c2);
                dp.addTodistributionObjects(distObj);
                c2.addTodistributionObjects(distObj);
            }
            this.getHibSession().save((Object)dp);
            this.getHibSession().flush();
            this.getHibSession().refresh((Object)dp);
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, dp, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, null, clazz.getSchedulingSubpart().getControllingDept());
        }
    }

    private boolean addUpdateClassEvent(Class_ c, EventRelatedImports.TimeObject meetingTime, Vector<Room> rooms, Vector<NonUniversityLocation> locations, TimePattern tp, DatePattern dp) {
        return this.addUpdateClassEvent(c, this.getMeetings(c.effectiveDatePattern(), meetingTime, rooms, locations), tp, dp);
    }

    private boolean addUpdateClassEvent(Class_ c, Vector<Meeting> meetings, TimePattern tp, DatePattern dp) {
        Meeting.Status status;
        boolean changed = false;
        Date approvedTime = new Date();
        ClassEvent origEvent = c.getEvent();
        Meeting.Status status2 = status = c.isCancelled() != false ? Meeting.Status.CANCELLED : Meeting.Status.APPROVED;
        if (meetings != null && !meetings.isEmpty() && origEvent == null) {
            ClassEvent newEvent = new ClassEvent();
            newEvent.setClazz(c);
            c.setEvent(newEvent);
            newEvent.setMaxCapacity(c.getMaxExpectedCapacity());
            newEvent.setMinCapacity(c.getExpectedCapacity());
            newEvent.setEventName(c.getSchedulingSubpart().getInstrOfferingConfig().getCourseName() + " " + c.getSchedulingSubpart().getItype().getAbbv().trim() + " " + c.getClassSuffix());
            for (Meeting meeting : meetings) {
                meeting.setEvent(newEvent);
                meeting.setStatus(status);
                meeting.setApprovalDate(approvedTime);
                newEvent.addTomeetings(meeting);
            }
            this.getHibSession().save((Object)newEvent);
            this.assignmentHelper.createAssignment(newEvent, tp, dp);
            changed = true;
            this.addNote("\tdid not find matching event, added new event: " + c.getSchedulingSubpart().getInstrOfferingConfig().getCourseName() + " " + c.getSchedulingSubpart().getItype().getAbbv().trim() + " " + c.getClassSuffix());
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, newEvent, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
        } else if (origEvent != null) {
            if (!origEvent.getEventName().equals(c.getSchedulingSubpart().getInstrOfferingConfig().getCourseName() + " " + c.getSchedulingSubpart().getItype().getAbbv().trim() + " " + c.getClassSuffix())) {
                origEvent.setEventName(c.getSchedulingSubpart().getInstrOfferingConfig().getCourseName() + " " + c.getSchedulingSubpart().getItype().getAbbv().trim() + " " + c.getClassSuffix());
                changed = true;
                this.addNote("\tevent name changed");
            }
            if (origEvent.getMinCapacity() != null && c.getExpectedCapacity() != null && !origEvent.getMinCapacity().equals(c.getExpectedCapacity()) || origEvent.getMinCapacity() != null && c.getExpectedCapacity() == null || origEvent.getMinCapacity() == null && c.getExpectedCapacity() != null) {
                origEvent.setMinCapacity(c.getExpectedCapacity());
                changed = true;
                this.addNote("\tevent minimum capacity changed.");
            }
            if (origEvent.getMaxCapacity() != null && c.getMaxExpectedCapacity() != null && !origEvent.getMaxCapacity().equals(c.getMaxExpectedCapacity()) || origEvent.getMaxCapacity() != null && c.getMaxExpectedCapacity() == null || origEvent.getMaxCapacity() == null && c.getMaxExpectedCapacity() != null) {
                origEvent.setMaxCapacity(c.getMaxExpectedCapacity());
                changed = true;
                this.addNote("\tevent maximum capacity changed.");
            }
            TreeSet<Meeting> origMeetings = new TreeSet<Meeting>();
            origMeetings.addAll(origEvent.getMeetings());
            if (meetings != null) {
                for (Meeting newMeeting : meetings) {
                    boolean found = false;
                    for (Meeting origMeeting : origMeetings) {
                        if (!this.isSameMeeting(origMeeting, newMeeting)) continue;
                        found = true;
                        origMeetings.remove(origMeeting);
                        if (status == origMeeting.getStatus()) break;
                        origMeeting.setStatus(status);
                        changed = true;
                        break;
                    }
                    if (found) continue;
                    this.addNote("\tdid not find matching meeting, adding new meeting to event: " + c.getClassLabel());
                    newMeeting.setEvent(origEvent);
                    newMeeting.setStatus(status);
                    newMeeting.setApprovalDate(approvedTime);
                    origEvent.addTomeetings(newMeeting);
                    changed = true;
                }
            }
            if (!origMeetings.isEmpty()) {
                this.addNote("\tsome existing meetings did not have matches in input, deleted them: " + c.getClassLabel());
                for (Meeting m : origMeetings) {
                    origEvent.getMeetings().remove(m);
                    m.setEvent(null);
                    ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, m, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
                    this.getHibSession().delete((Object)m);
                    changed = true;
                }
            }
            if (changed) {
                this.assignmentHelper.createAssignment(origEvent, tp, dp);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, origEvent, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), c.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
                this.getHibSession().update((Object)origEvent);
            }
        }
        return changed;
    }

    private boolean elementSubpart(Element element, InstrOfferingConfig ioc, SchedulingSubpart parentSubpart, HashSet<SchedulingSubpart> allExistingSubparts) throws Exception {
        String elementName;
        boolean changed = false;
        HashMap<String, SchedulingSubpart> thisLevelSubparts = new HashMap<String, SchedulingSubpart>();
        if (parentSubpart == null) {
            allExistingSubparts = new HashSet();
            if (ioc.getSchedulingSubparts() != null) {
                for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                    allExistingSubparts.add(ss);
                    if (ss.getParentSubpart() != null) continue;
                    thisLevelSubparts.put(ss.getItype().getAbbv().trim() + (ss.getSchedulingSubpartSuffixCache() == null ? "" : (ss.getSchedulingSubpartSuffixCache().equals("-") ? "" : ss.getSchedulingSubpartSuffixCache())), ss);
                }
            }
        } else if (parentSubpart.getChildSubparts() != null) {
            for (SchedulingSubpart ss : parentSubpart.getChildSubparts()) {
                thisLevelSubparts.put(ss.getItype().getAbbv().trim() + (ss.getSchedulingSubpartSuffixCache() == null ? "" : (ss.getSchedulingSubpartSuffixCache().equals("-") ? "" : ss.getSchedulingSubpartSuffixCache())), ss);
            }
        }
        if (element.element(elementName = "subpart") != null) {
            Iterator<Object> it = element.elementIterator(elementName);
            while (it.hasNext()) {
                String suffix;
                Element subpart = (Element)it.next();
                boolean isAdd = false;
                Integer minPerWeek = this.getOptionalIntegerAttribute(subpart, "minPerWeek");
                if (minPerWeek == null) {
                    minPerWeek = new Integer(0);
                }
                String typeStr = this.getRequiredStringAttribute(subpart, "type", elementName);
                ItypeDesc itype = this.findItypeForString(typeStr);
                String type = "";
                if (itype != null) {
                    type = itype.getAbbv().trim();
                }
                suffix = (suffix = this.getOptionalStringAttribute(subpart, "suffix")) != null ? suffix.trim() : "";
                SchedulingSubpart ss = null;
                if (thisLevelSubparts.containsKey(type + suffix)) {
                    ss = (SchedulingSubpart)thisLevelSubparts.get(type + suffix);
                    allExistingSubparts.remove(ss);
                    if (thisLevelSubparts.containsKey(type + suffix)) {
                        thisLevelSubparts.remove(type + suffix);
                    }
                } else if (parentSubpart != null && parentSubpart.getItype().getAbbv().trim().equals(type) && suffix.length() == 0 && thisLevelSubparts.containsKey(type + "a")) {
                    ss = (SchedulingSubpart)thisLevelSubparts.get(type + "a");
                    allExistingSubparts.remove(ss);
                    if (thisLevelSubparts.containsKey(type + "a")) {
                        thisLevelSubparts.remove(type + "a");
                    }
                } else {
                    ss = new SchedulingSubpart();
                    ss.setItype(itype);
                    ss.setSchedulingSubpartSuffixCache(suffix);
                    ss.setInstrOfferingConfig(ioc);
                    ss.setSession(ioc.getSession());
                    ss.setCourseName(ioc.getInstructionalOffering().getCourseName());
                    ioc.addToschedulingSubparts(ss);
                    if (parentSubpart != null) {
                        ss.setParentSubpart(parentSubpart);
                        parentSubpart.addTochildSubparts(ss);
                    }
                    changed = true;
                    isAdd = true;
                    this.addNote("\tdid not find existing matching scheduling subpart, created new one: " + ss.getItypeDesc());
                }
                if (ss.isAutoSpreadInTime() == null) {
                    ss.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
                }
                if (ss.isStudentAllowOverlap() == null) {
                    ss.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
                }
                if (ss.getMinutesPerWk() == null || !ss.getMinutesPerWk().equals(minPerWeek)) {
                    ss.setMinutesPerWk(minPerWeek);
                    this.addNote("\tsubpart minutes per week changed");
                    changed = true;
                }
                if (parentSubpart != null && ss.getParentSubpart() == null) {
                    ss.setParentSubpart(parentSubpart);
                    parentSubpart.addTochildSubparts(ss);
                    this.addNote("\tsubpart now has parent");
                    changed = true;
                } else if (parentSubpart != null && !ss.getParentSubpart().getUniqueId().equals(parentSubpart.getUniqueId())) {
                    ss.getParentSubpart().getChildSubparts().remove(ss);
                    ss.setParentSubpart(parentSubpart);
                    parentSubpart.addTochildSubparts(ss);
                    this.addNote("\tsubpart has different parent");
                    changed = true;
                } else if (parentSubpart == null && ss.getParentSubpart() != null) {
                    ss.getParentSubpart().getChildSubparts().remove(ss);
                    ss.setParentSubpart(null);
                    this.addNote("\tsubpart no longer has parent");
                    changed = true;
                }
                if (this.elementSubpartCredit(subpart, ss)) {
                    this.addNote("\tsubpart credit changed");
                    changed = true;
                }
                if (changed) {
                    this.getHibSession().saveOrUpdate((Object)ss);
                }
                if (this.elementSubpart(subpart, ioc, ss, allExistingSubparts)) {
                    changed = true;
                }
                if (!changed) continue;
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ss, ChangeLog.Source.DATA_IMPORT_OFFERINGS, isAdd ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getDepartment());
            }
        } else if (this.incremental && parentSubpart == null) {
            return changed;
        }
        if (!thisLevelSubparts.isEmpty()) {
            this.addNote("\tnot all subparts at this level had matches, deleted them");
            for (SchedulingSubpart ss : thisLevelSubparts.values()) {
                allExistingSubparts.remove(ss);
                this.deleteSchedulingSubpart(ss);
            }
            if (parentSubpart != null) {
                this.getHibSession().saveOrUpdate((Object)parentSubpart);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, parentSubpart, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getDepartment());
            }
            changed = true;
        }
        if (parentSubpart == null && !allExistingSubparts.isEmpty()) {
            this.addNote("\tnot all existing subparts had matches, deleted them");
            for (SchedulingSubpart ss : allExistingSubparts) {
                if (ss.getParentSubpart() != null) {
                    ss.getParentSubpart().getChildSubparts().remove(ss);
                }
                this.deleteSchedulingSubpart(ss);
            }
            changed = true;
        }
        return changed;
    }

    private void deleteDistributionPref(DistributionPref dp) {
        this.addNote("\tdeleting meets with distribution preference:  " + dp.preferenceText(true, false, "", ", ", ""));
        HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
        Department dept = (Department)dp.getOwner();
        dept.getPreferences().remove(dp);
        for (DistributionObject dObj : dp.getDistributionObjects()) {
            PreferenceGroup pg = dObj.getPrefGroup();
            relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
            pg.getDistributionObjects().remove(dObj);
            this.getHibSession().saveOrUpdate((Object)pg);
        }
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, dp, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, null, dept);
        this.getHibSession().delete((Object)dp);
        this.getHibSession().saveOrUpdate((Object)dept);
    }

    private void deleteCourseOffering(CourseOffering co) {
        InstructionalOffering io = co.getInstructionalOffering();
        if (io.getCourseOfferings().size() == 1) {
            this.deleteInstructionalOffering(io);
        } else if (io.getCourseOfferings().size() > 1) {
            io.getCourseOfferings().remove(co);
            if (co.isIsControl().booleanValue()) {
                CourseOffering newControl = io.getCourseOfferings().iterator().next();
                newControl.setIsControl(new Boolean(true));
            }
            co.setInstructionalOffering(null);
            this.existingCourseOfferings.remove(co.getUniqueId());
            this.getHibSession().delete((Object)co);
        } else {
            this.existingCourseOfferings.remove(co.getUniqueId());
            this.getHibSession().delete((Object)co);
        }
    }

    private void deleteInstructionalOffering(InstructionalOffering io) {
        this.existingInstructionalOfferings.remove(io.getUniqueId());
        for (CourseOffering co : io.getCourseOfferings()) {
            this.existingCourseOfferings.remove(co.getUniqueId());
        }
        if (io.getInstrOfferingConfigs() != null) {
            for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
                if (ioc.getSchedulingSubparts() == null) continue;
                for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                    if (ss.getClasses() == null) continue;
                    for (Class_ c : ss.getClasses()) {
                        this.existingClasses.remove(c.getUniqueId());
                        c.deleteAllDependentObjects(this.getHibSession(), false);
                    }
                }
            }
        }
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, io, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, io.getControllingCourseOffering() == null ? null : io.getControllingCourseOffering().getSubjectArea(), io.getControllingCourseOffering() == null ? null : io.getControllingCourseOffering().getDepartment());
        this.getHibSession().delete((Object)io);
        this.flush(true);
    }

    private void deleteInstrOffrConfig(InstrOfferingConfig ioc) {
        if (ioc.getSchedulingSubparts() != null) {
            for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                if (ss.getClasses() == null) continue;
                for (Class_ c : ss.getClasses()) {
                    this.existingClasses.remove(c.getUniqueId());
                    c.deleteAllDependentObjects(this.getHibSession(), false);
                }
            }
        }
        ioc.getInstructionalOffering().getInstrOfferingConfigs().remove(ioc);
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ioc, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getControllingCourseOffering().getDepartment());
        this.getHibSession().delete((Object)ioc);
    }

    private void deleteSchedulingSubpart(SchedulingSubpart ss) {
        if (ss.getChildSubparts() != null) {
            for (SchedulingSubpart css : ss.getChildSubparts()) {
                this.deleteSchedulingSubpart(css);
            }
        }
        if (ss.getClasses() != null) {
            for (Class_ c : ss.getClasses()) {
                this.existingClasses.remove(c.getUniqueId());
                c.deleteAllDependentObjects(this.getHibSession(), false);
            }
        }
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        SchedulingSubpart parentSubpart = ss.getParentSubpart();
        if (parentSubpart != null) {
            parentSubpart.getChildSubparts().remove(ss);
            ss.setParentSubpart(null);
        }
        ioc.getSchedulingSubparts().remove(ss);
        this.getHibSession().update((Object)ioc);
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ss, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, ioc.getControllingCourseOffering().getSubjectArea(), ioc.getControllingCourseOffering().getDepartment());
    }

    private void deleteClassInstructor(ClassInstructor ci) {
        ci.getInstructor().getClasses().remove(ci);
        ci.getClassInstructing().getClassInstructors().remove(ci);
        Class_ clazz = ci.getClassInstructing();
        ci.setClassInstructing(null);
        ci.setInstructor(null);
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, ci, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), clazz.getSchedulingSubpart().getControllingCourseOffering().getDepartment());
        this.getHibSession().delete((Object)ci);
    }

    private void deleteClass(Class_ c) {
        c.deleteAllDependentObjects(this.getHibSession(), false);
        c.getSchedulingSubpart().getClasses().remove(c);
        SchedulingSubpart ss = c.getSchedulingSubpart();
        ss.getClasses().remove(c);
        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, c, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.DELETE, ss.getControllingCourseOffering().getSubjectArea(), ss.getControllingCourseOffering().getDepartment());
        this.existingClasses.remove(c.getUniqueId());
        this.getHibSession().delete((Object)c);
    }

    private CourseOffering findExistingCourseOffering(CourseOffering courseOffering, Long sessionId) {
        CourseOffering existingCo = null;
        if (courseOffering.getExternalUniqueId() != null) {
            existingCo = this.findCrsOffrForExternalId(courseOffering.getExternalUniqueId(), sessionId);
        }
        if (existingCo == null) {
            existingCo = this.courseNumbersMustBeUnique ? this.findCrsOffrForSubjCrs(courseOffering.getSubjectArea().getSubjectAreaAbbreviation(), courseOffering.getCourseNbr(), sessionId) : this.findCrsOffrForSubjCrsTitle(courseOffering.getSubjectArea().getSubjectAreaAbbreviation(), courseOffering.getCourseNbr(), courseOffering.getTitle(), sessionId);
        }
        return existingCo;
    }

    private CourseOffering findCrsOffrForExternalId(String externalId, Long sessionId) {
        return (CourseOffering)this.getHibSession().createQuery("select distinct co from CourseOffering as co where co.externalUniqueId=:externalId and co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }

    private CourseOffering findCrsOffrForSubjCrsTitle(String subjectAbbv, String crsNbr, String title, Long sessionId) {
        return (CourseOffering)this.getHibSession().createQuery("select distinct co from CourseOffering as co where co.subjectArea.session.uniqueId=:sessionId and co.subjectArea.subjectAreaAbbreviation=:subjectAbbv and co.courseNbr=:courseNbr and co.title=:title").setLong("sessionId", sessionId.longValue()).setString("subjectAbbv", subjectAbbv).setString("courseNbr", crsNbr).setString("title", title).setCacheable(true).uniqueResult();
    }

    private CourseOffering findCrsOffrForSubjCrs(String subjectAbbv, String crsNbr, Long sessionId) {
        return (CourseOffering)this.getHibSession().createQuery("select distinct co from CourseOffering as co where co.subjectArea.session.uniqueId=:sessionId and co.subjectArea.subjectAreaAbbreviation=:subjectAbbv and co.courseNbr=:courseNbr").setLong("sessionId", sessionId.longValue()).setString("subjectAbbv", subjectAbbv).setString("courseNbr", crsNbr).setCacheable(true).uniqueResult();
    }

    private InstructionalOffering findInstrOffrForExternalId(String externalId, Long sessionId) {
        return (InstructionalOffering)this.getHibSession().createQuery("select distinct io from InstructionalOffering as io where io.externalUniqueId=:externalId and io.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).setFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    private InstructionalOffering findInstrOffrForUniqueId(Long uniqueId) {
        return (InstructionalOffering)this.getHibSession().createQuery("select distinct io from InstructionalOffering as io where io.uniqueId=:uniqueId").setLong("uniqueId", uniqueId.longValue()).setCacheable(true).uniqueResult();
    }

    private CourseOffering findCourseOffrForUniqueId(Long uniqueId) {
        return (CourseOffering)this.getHibSession().createQuery("select distinct co from CourseOffering as co where co.uniqueId=:uniqueId").setLong("uniqueId", uniqueId.longValue()).setCacheable(true).uniqueResult();
    }

    private Class_ findClassForUniqueId(Long uniqueId) {
        return (Class_)this.getHibSession().createQuery("select distinct c from Class_ as c where c.uniqueId=:uniqueId").setLong("uniqueId", uniqueId.longValue()).setCacheable(true).uniqueResult();
    }

    private Class_ findClassForExternalUniqueId(String externalUniqueId) {
        return (Class_)this.getHibSession().createQuery("select distinct c from Class_ as c where c.externalUniqueId=:externalUniqueId and c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId").setString("externalUniqueId", externalUniqueId).setLong("sessionId", this.session.getUniqueId().longValue()).setCacheable(true).uniqueResult();
    }

    private Room findRoom(String id, String building, String roomNbr) {
        Room room = null;
        if (id != null) {
            room = (Room)this.getHibSession().createQuery("select distinct r from Room as r where r.externalUniqueId=:externalId and r.building.session.uniqueId=:sessionId").setLong("sessionId", this.session.getUniqueId().longValue()).setString("externalId", id).setCacheable(true).uniqueResult();
        }
        if (room == null) {
            room = (Room)this.getHibSession().createQuery("select distinct r from Room as r where r.roomNumber=:roomNbr and r.building.abbreviation = :building and r.session.uniqueId=:sessionId").setLong("sessionId", this.session.getUniqueId().longValue()).setString("building", building).setString("roomNbr", roomNbr).setCacheable(true).uniqueResult();
            if (id != null && room != null && room.getExternalUniqueId() != null && !room.getExternalUniqueId().equals(id)) {
                room = null;
            }
        }
        return room;
    }

    private NonUniversityLocation findNonUniversityLocation(String id, String name, Department dept) {
        NonUniversityLocation location = null;
        List possibleLocations = this.findNonUniversityLocationsWithIdOrName(id, name);
        if (possibleLocations != null) {
            for (NonUniversityLocation l : possibleLocations) {
                if (l.getRoomDepts() != null) {
                    for (RoomDept rd : l.getRoomDepts()) {
                        if (!rd.getDepartment().getUniqueId().equals(dept.getUniqueId())) continue;
                        location = l;
                        break;
                    }
                }
                if (location == null) continue;
                break;
            }
        }
        return location;
    }

    private void loadSubjectAreas(Long sessionId) {
        List subjects = new ArrayList();
        subjects = this.getHibSession().createQuery("select distinct sa from SubjectArea as sa where sa.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        for (SubjectArea sa : subjects) {
            this.subjectAreas.put(sa.getSubjectAreaAbbreviation(), sa);
        }
    }

    private void loadItypes() {
        TreeSet<ItypeDesc> itypeDescs = ItypeDesc.findAll(false);
        for (ItypeDesc itype : itypeDescs) {
            this.itypes.put(itype.getAbbv().trim(), itype);
            this.itypesBySisRef.put(itype.getSis_ref(), itype);
        }
    }

    private ItypeDesc findItypeForString(String itypeRef) {
        ItypeDesc itype = this.itypes.get(itypeRef);
        if (itype == null) {
            itype = this.itypesBySisRef.get(itypeRef);
        }
        return itype;
    }

    private void loadExistingInstructionalOfferings(Long sessionId) throws Exception {
        for (InstructionalOffering io : InstructionalOffering.findAll(sessionId)) {
            this.existingInstructionalOfferings.add(io.getUniqueId());
        }
    }

    private void loadExistingCourseOfferings(Long sessionId) throws Exception {
        for (CourseOffering courseOffering : CourseOffering.findAll(sessionId)) {
            this.existingCourseOfferings.add(courseOffering.getUniqueId());
        }
    }

    private void loadMeetsWithDistributionType() {
        this.meetsWithType = (DistributionType)this.getHibSession().createQuery("from DistributionType dt where dt.reference = 'MEET_WITH'").uniqueResult();
    }

    private void loadCanShareRoomDistributionType() {
        this.canShareRoomType = (DistributionType)this.getHibSession().createQuery("from DistributionType dt where dt.reference = 'CAN_SHARE_ROOM'").uniqueResult();
    }

    private void loadRequiredPrefLevel() {
        this.requiredPrefLevel = (PreferenceLevel)this.getHibSession().createQuery("from PreferenceLevel pl where pl.prefProlog = :pref").setString("pref", PreferenceLevel.sRequired).uniqueResult();
    }

    private void loadExistingClasses(Long sessionId) throws Exception {
        for (Class_ c : Class_.findAll(sessionId)) {
            this.existingClasses.add(c.getUniqueId());
        }
    }

    @Override
    protected String getEmailSubject() {
        return "Course Offering Import Results - " + this.session.getAcademicYearTerm();
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private boolean elementExam(Element element, InstructionalOffering io) throws Exception {
        boolean changed = false;
        TreeSet exams = new TreeSet(this.getHibSession().createQuery("select distinct x from Exam x inner join x.owners o inner join o.course co inner join co.instructionalOffering io left outer join io.instrOfferingConfigs ioc left outer join ioc.schedulingSubparts ss left outer join ss.classes c where io.uniqueId=:instructionalOfferingId and ((o.ownerType=1 and o.ownerId=co.uniqueId) or (o.ownerType=0 and o.ownerId=io.uniqueId) or (o.ownerType=2 and o.ownerId=ioc.uniqueId) or (o.ownerType=3 and o.ownerId=c.uniqueId) ) order by x.uniqueId").setLong("instructionalOfferingId", io.getUniqueId().longValue()).setCacheable(true).list());
        String elementName = "exam";
        if (element.element(elementName) != null) {
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element examElement = (Element)it.next();
                String name = this.getRequiredStringAttribute(examElement, "name", elementName);
                Integer size = this.getOptionalIntegerAttribute(examElement, "size");
                Integer length = this.getRequiredIntegerAttribute(examElement, "length", elementName);
                String seating = this.getOptionalStringAttribute(examElement, "seatingType");
                int seatingType = "normal".equals(seating) ? 0 : 0;
                String type = this.getRequiredStringAttribute(examElement, "type", elementName);
                String note = this.getOptionalStringAttribute(examElement, "note");
                Integer printOffset = this.getOptionalIntegerAttribute(examElement, "printOffset");
                String maxRooms = this.getOptionalStringAttribute(examElement, "maxRooms");
                Integer maxNbrRooms = maxRooms == null ? this.defaultMaxNbrRooms : Integer.valueOf(maxRooms);
                ExamType et = ExamType.findByReference(type);
                if (et == null) {
                    throw new Exception("Examination type " + type + " does not exist.");
                }
                BaseExam exam = null;
                Iterator i = exams.iterator();
                while (i.hasNext()) {
                    Exam x = (Exam)i.next();
                    if (!x.getExamType().equals(et) || !x.getLabel().equals(name)) continue;
                    exam = x;
                    i.remove();
                    break;
                }
                boolean addNew = false;
                if (exam == null) {
                    this.addNote("\t did not find matching exam element, adding new exam: " + name + " (" + et.getReference() + ")");
                    exam = new Exam();
                    exam.setSession(io.getSession());
                    exam.setName(name);
                    exam.setExamType(et);
                    exam.setSeatingType(seatingType);
                    exam.setExamSize(size);
                    exam.setLength(length);
                    exam.setNote(note);
                    exam.setMaxNbrRooms(maxNbrRooms);
                    exam.setPrintOffset(printOffset);
                    exam.setOwners(new HashSet<ExamOwner>());
                    exam.setInstructors(new HashSet<DepartmentalInstructor>());
                    exam.setAssignedRooms(new HashSet<Location>());
                    changed = true;
                    addNew = true;
                } else {
                    if (exam.getSeatingType() != seatingType) {
                        this.addNote("\tseating type changed");
                        exam.setSeatingType(seatingType);
                        changed = true;
                    }
                    if (!length.equals(exam.getLength())) {
                        this.addNote("\t length changed");
                        exam.setLength(length);
                        changed = true;
                    }
                    if (!BaseCourseOfferingImport.equals(size, exam.getExamSize())) {
                        this.addNote("\t size changed");
                        exam.setExamSize(size);
                        changed = true;
                    }
                    if (!BaseCourseOfferingImport.equals(note, exam.getNote())) {
                        this.addNote("\t note changed");
                        exam.setNote(note);
                        changed = true;
                    }
                    if (!BaseCourseOfferingImport.equals(maxNbrRooms, exam.getMaxNbrRooms())) {
                        this.addNote("\t max rooms changed");
                        exam.setMaxNbrRooms(maxNbrRooms);
                        changed = true;
                    }
                    if (!BaseCourseOfferingImport.equals(printOffset, exam.getPrintOffset())) {
                        this.addNote("\t print offset changed");
                        exam.setPrintOffset(printOffset);
                        changed = true;
                    }
                }
                HashSet<ExamOwner> owners = new HashSet<ExamOwner>(exam.getOwners());
                for (Object obj : this.getExamOwners(examElement, io)) {
                    ExamOwner owner = null;
                    Iterator i2 = owners.iterator();
                    while (i2.hasNext()) {
                        ExamOwner own = (ExamOwner)i2.next();
                        if (own.getOwnerType() == 3 && obj instanceof Class_ && own.getOwnerId().equals(((Class_)obj).getUniqueId())) {
                            owner = own;
                            i2.remove();
                            break;
                        }
                        if (own.getOwnerType() == 2 && obj instanceof InstrOfferingConfig && own.getOwnerId().equals(((InstrOfferingConfig)obj).getUniqueId())) {
                            owner = own;
                            i2.remove();
                            break;
                        }
                        if (own.getOwnerType() == 1 && obj instanceof CourseOffering && own.getOwnerId().equals(((CourseOffering)obj).getUniqueId())) {
                            owner = own;
                            i2.remove();
                            break;
                        }
                        if (own.getOwnerType() != 0 || !(obj instanceof InstructionalOffering) || !own.getOwnerId().equals(((InstructionalOffering)obj).getUniqueId())) continue;
                        owner = own;
                        i2.remove();
                        break;
                    }
                    if (owner != null) continue;
                    owner = new ExamOwner();
                    if (obj instanceof Class_) {
                        owner.setOwner((Class_)obj);
                    } else if (obj instanceof InstrOfferingConfig) {
                        owner.setOwner((InstrOfferingConfig)obj);
                    } else if (obj instanceof CourseOffering) {
                        owner.setOwner((CourseOffering)obj);
                    } else if (obj instanceof InstructionalOffering) {
                        owner.setOwner((InstructionalOffering)obj);
                    }
                    owner.setExam((Exam)exam);
                    exam.getOwners().add(owner);
                    this.addNote("\t exam owner changed (" + owner.getLabel() + ")");
                    changed = true;
                }
                if (!owners.isEmpty()) {
                    for (ExamOwner owner : owners) {
                        owner.setExam(null);
                        exam.getOwners().remove(owner);
                        this.getHibSession().delete((Object)owner);
                        this.addNote("\t exam owner removed (" + owner.getLabel() + ")");
                        changed = true;
                    }
                }
                if (this.elementInstructor(examElement, (Exam)exam, io)) {
                    this.addNote("\t exam instructor(s) changed");
                    changed = true;
                }
                ExamPeriod period = null;
                Element periodElement = examElement.element("period");
                if (periodElement != null) {
                    Element roomElement;
                    Calendar date = null;
                    if (this.dateFormat == null) {
                        date = this.getCalendarForDate(this.getRequiredStringAttribute(periodElement, "date", "period"));
                    } else {
                        date = Calendar.getInstance();
                        date.setTime(CalendarUtils.getDate(this.getRequiredStringAttribute(periodElement, "date", "period"), this.dateFormat));
                    }
                    if (date == null) {
                        throw new Exception("For element 'period' a 'date' is required, unable to parse given date.");
                    }
                    long diff = date.getTimeInMillis() - io.getSession().getExamBeginDate().getTime();
                    int dateOffset = (int)Math.round((double)diff / 8.64E7);
                    int startSlot = this.str2Slot(this.getRequiredStringAttribute(periodElement, "startTime", "period"), exam.getPrintOffset());
                    period = ExamPeriod.findByDateStart(io.getSessionId(), dateOffset, startSlot, exam.getExamType().getUniqueId());
                    if (period == null) {
                        this.addNote("\t failed to find matchin examination period for " + new SimpleDateFormat(this.dateFormat == null ? "yyyy/M/d" : this.dateFormat).format(date) + " " + Constants.slot2str(startSlot));
                    } else if (!BaseCourseOfferingImport.equals(period, exam.getAssignedPeriod())) {
                        this.addNote("\t exam assigned period changed");
                        exam.setAssignedPeriod(period);
                        this.examPeriodChanged = true;
                        changed = true;
                    }
                    HashSet<Location> rooms = new HashSet<Location>(exam.getAssignedRooms());
                    Iterator j = examElement.elementIterator("room");
                    while (j.hasNext()) {
                        roomElement = (Element)j.next();
                        String building = this.getRequiredStringAttribute(roomElement, "building", "room");
                        String roomNbr = this.getRequiredStringAttribute(roomElement, "roomNbr", "room");
                        String id = this.getOptionalStringAttribute(roomElement, "id");
                        Room room = this.findRoom(id, building, roomNbr);
                        if (room != null) {
                            if (rooms.remove(room)) continue;
                            exam.getAssignedRooms().add(room);
                            this.addNote("\t exam assigned room(s) changed");
                            changed = true;
                            continue;
                        }
                        this.addMissingLocation(building + " " + roomNbr + " - " + ((Exam)exam).getLabel());
                    }
                    j = examElement.elementIterator("location");
                    while (j.hasNext()) {
                        roomElement = (Element)j.next();
                        String locName = this.getRequiredStringAttribute(roomElement, "name", "location");
                        String id = this.getOptionalStringAttribute(roomElement, "id");
                        NonUniversityLocation location = this.findNonUniversityLocation(id, locName, io.getDepartment());
                        if (location != null) {
                            if (rooms.remove(location)) continue;
                            exam.getAssignedRooms().add(location);
                            this.addNote("\t exam assigned room(s) changed");
                            changed = true;
                            continue;
                        }
                        this.addMissingLocation(name + " - " + ((Exam)exam).getLabel());
                    }
                    if (!rooms.isEmpty()) {
                        this.addNote("\t exam assigned room(s) changed");
                        exam.getAssignedRooms().removeAll(rooms);
                        changed = true;
                    }
                }
                if (!changed) continue;
                this.addNote("\texam element changed: " + name);
                this.getHibSession().saveOrUpdate((Object)exam);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, exam, ChangeLog.Source.DATA_IMPORT_OFFERINGS, addNew ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), io.getControllingCourseOffering().getDepartment());
                if (periodElement == null) continue;
                ExamEvent event = ((Exam)exam).generateEvent(((Exam)exam).getEvent(), true);
                if (event != null) {
                    event.setEventName(((Exam)exam).getLabel());
                    event.setMinCapacity(((Exam)exam).getSize());
                    event.setMaxCapacity(((Exam)exam).getSize());
                    this.getHibSession().saveOrUpdate((Object)event);
                    continue;
                }
                if (((Exam)exam).getEvent() == null) continue;
                this.getHibSession().delete((Object)((Exam)exam).getEvent());
                ((Exam)exam).setEvent(null);
            }
        } else if (this.incremental) {
            return changed;
        }
        if (!exams.isEmpty() && !"none".equals(this.includeExams)) {
            for (Exam exam : exams) {
                if ("final".equals(this.includeExams) && exam.getExamType().getType() != 0 || "midterm".equals(this.includeExams) && exam.getExamType().getType() != 1) continue;
                this.addNote("\tremoved exam: " + exam.getLabel() + " (" + exam.getExamType().getReference() + ")");
                exam.deleteDependentObjects(this.getHibSession(), false);
                this.getHibSession().delete((Object)exam);
                changed = true;
            }
        }
        return changed;
    }

    private boolean elementInstructor(Element element, Exam exam, InstructionalOffering offering) throws Exception {
        boolean changed = false;
        HashMap<String, DepartmentalInstructor> existingInstructors = new HashMap<String, DepartmentalInstructor>();
        for (DepartmentalInstructor i : exam.getInstructors()) {
            existingInstructors.put(i.getExternalUniqueId(), i);
        }
        String elementName = "instructor";
        if (element.element(elementName) != null) {
            HashSet<String> ids = new HashSet<String>();
            HashMap<String, String> firstNames = new HashMap<String, String>();
            HashMap<String, String> middleNames = new HashMap<String, String>();
            HashMap<String, String> lastNames = new HashMap<String, String>();
            HashMap<String, String> acadTitles = new HashMap<String, String>();
            Iterator it = element.elementIterator(elementName);
            while (it.hasNext()) {
                Element instructorElement = (Element)it.next();
                String id = this.getRequiredStringAttribute(instructorElement, "id", elementName);
                if (this.trimLeadingZerosFromExternalId) {
                    try {
                        Integer num = new Integer(id);
                        id = num.toString();
                    }
                    catch (Exception num) {
                        // empty catch block
                    }
                }
                ids.add(id);
                firstNames.put(id, this.getOptionalStringAttribute(instructorElement, "fname"));
                middleNames.put(id, this.getOptionalStringAttribute(instructorElement, "mname"));
                lastNames.put(id, this.getOptionalStringAttribute(instructorElement, "lname"));
                acadTitles.put(id, this.getOptionalStringAttribute(instructorElement, "title"));
            }
            for (String id : ids) {
                DepartmentalInstructor di = (DepartmentalInstructor)existingInstructors.get(id);
                if (di == null) {
                    di = this.findDepartmentalInstructorWithExternalUniqueId(id, offering.getControllingCourseOffering().getDepartment());
                    if (di == null) {
                        Staff staffData;
                        di = new DepartmentalInstructor();
                        di.setDepartment(offering.getControllingCourseOffering().getDepartment());
                        di.setExternalUniqueId(id);
                        if (lastNames.get(id) == null && (staffData = this.findStaffMember(id, offering.getControllingCourseOffering().getDepartment())) != null) {
                            firstNames.put(id, staffData.getFirstName());
                            middleNames.put(id, staffData.getMiddleName());
                            lastNames.put(id, staffData.getLastName());
                            acadTitles.put(id, staffData.getAcademicTitle());
                        }
                        di.setFirstName((String)firstNames.get(id));
                        di.setMiddleName((String)middleNames.get(id));
                        di.setAcademicTitle((String)acadTitles.get(id));
                        String lastName = (String)lastNames.get(id);
                        di.setLastName(lastName != null ? lastName : "Unknown Name");
                        di.setIgnoreToFar(new Boolean(false));
                        this.getHibSession().save((Object)di);
                        this.getHibSession().flush();
                        this.getHibSession().refresh((Object)di);
                        ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, di, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.CREATE, offering.getControllingCourseOffering().getSubjectArea(), offering.getControllingCourseOffering().getDepartment());
                    }
                    exam.getInstructors().add(di);
                    di.getExams().add(exam);
                    changed = true;
                    continue;
                }
                existingInstructors.remove(id);
            }
        }
        if (!existingInstructors.isEmpty()) {
            for (DepartmentalInstructor di : existingInstructors.values()) {
                di.getExams().remove(exam);
                exam.getInstructors().remove(di);
                changed = true;
            }
        }
        return changed;
    }

    protected List<Object> getExamOwners(Element examElement, InstructionalOffering offering) throws Exception {
        Iterator it;
        ArrayList<Object> owners = new ArrayList<Object>();
        boolean hasThisOffering = false;
        if (offering != null) {
            it = examElement.elementIterator("class");
            while (it.hasNext()) {
                Element classElement = (Element)it.next();
                Class_ clazz = this.lookupClass(offering, this.getOptionalStringAttribute(classElement, "id"), this.getOptionalStringAttribute(classElement, "type"), this.getOptionalStringAttribute(classElement, "suffix"));
                if (clazz == null) continue;
                owners.add(clazz);
                hasThisOffering = true;
            }
        }
        it = examElement.elementIterator("course");
        while (it.hasNext()) {
            Element courseElement = (Element)it.next();
            CourseOffering course = this.findCrsOffrForSubjCrs(this.getRequiredStringAttribute(courseElement, "subject", "course"), this.getRequiredStringAttribute(courseElement, "courseNbr", "course"), offering.getSessionId());
            if (course == null) continue;
            ArrayList<Class_> classes = new ArrayList<Class_>();
            Iterator j = courseElement.elementIterator("class");
            while (j.hasNext()) {
                Element classElement = (Element)j.next();
                Class_ clazz = this.lookupClass(course.getInstructionalOffering(), this.getOptionalStringAttribute(classElement, "id"), this.getOptionalStringAttribute(classElement, "type"), this.getOptionalStringAttribute(classElement, "suffix"));
                if (clazz == null) continue;
                classes.add(clazz);
            }
            if (classes.isEmpty()) {
                if (course.getInstructionalOffering().getCourseOfferings().size() == 1) {
                    owners.add(course.getInstructionalOffering());
                } else {
                    owners.add(course);
                }
            } else {
                owners.addAll(classes);
            }
            if (!course.getInstructionalOffering().equals(offering)) continue;
            hasThisOffering = true;
        }
        if (offering != null && !hasThisOffering) {
            owners.add(offering);
        }
        return owners;
    }

    protected Class_ lookupClass(InstructionalOffering offering, String id, String type, String suffix) {
        Object course;
        if (id != null) {
            for (InstrOfferingConfig instrOfferingConfig : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart schedulingSubpart : instrOfferingConfig.getSchedulingSubparts()) {
                    for (Class_ class_ : schedulingSubpart.getClasses()) {
                        if (!id.equals(this.getExternalUniqueId(class_))) continue;
                        return class_;
                    }
                }
            }
            course = offering.getControllingCourseOffering();
            for (InstrOfferingConfig instrOfferingConfig : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart schedulingSubpart : instrOfferingConfig.getSchedulingSubparts()) {
                    for (Class_ clazz : schedulingSubpart.getClasses()) {
                        if (!id.equals(clazz.getExternalId((CourseOffering)course))) continue;
                        return clazz;
                    }
                }
            }
        }
        if (type != null && suffix != null) {
            for (InstrOfferingConfig instrOfferingConfig : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart schedulingSubpart : instrOfferingConfig.getSchedulingSubparts()) {
                    if (!type.equals(schedulingSubpart.getItypeDesc().trim())) continue;
                    for (Class_ class_ : schedulingSubpart.getClasses()) {
                        if (!suffix.equals(class_.getClassSuffix())) continue;
                        return class_;
                    }
                }
            }
            course = offering.getControllingCourseOffering();
            for (InstrOfferingConfig instrOfferingConfig : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart schedulingSubpart : instrOfferingConfig.getSchedulingSubparts()) {
                    if (!type.equals(schedulingSubpart.getItypeDesc().trim())) continue;
                    for (Class_ clazz : schedulingSubpart.getClasses()) {
                        if (!suffix.equals(clazz.getClassSuffix((CourseOffering)course))) continue;
                        return clazz;
                    }
                }
            }
        }
        return null;
    }

    public Integer str2Slot(String timeString, Integer printOffset) throws Exception {
        int slot = -1;
        try {
            Date date = CalendarUtils.getDate(timeString, this.timeFormat);
            SimpleDateFormat df = new SimpleDateFormat("HHmm");
            int time = Integer.parseInt(df.format(date));
            if (printOffset != null) {
                time -= printOffset.intValue();
            }
            int hour = time / 100;
            int min = time % 100;
            if (hour >= 24) {
                throw new Exception("Invalid time '" + timeString + "' -- hour (" + hour + ") must be between 0 and 23.");
            }
            if (min >= 60) {
                throw new Exception("Invalid time '" + timeString + "' -- minute (" + min + ") must be between 0 and 59.");
            }
            if (min % Constants.SLOT_LENGTH_MIN != 0) {
                min -= min % Constants.SLOT_LENGTH_MIN;
            }
            slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        }
        catch (NumberFormatException ex) {
            throw new Exception("Invalid time '" + timeString + "' -- not a number.");
        }
        if (slot < 0) {
            throw new Exception("Invalid time '" + timeString + "', did not meet format: " + this.timeFormat);
        }
        return slot;
    }

    protected class ImportCourseOffering {
        private CourseOffering courseOffering;
        private Element element;

        public ImportCourseOffering(CourseOffering courseOffering, Element element) {
            this.courseOffering = courseOffering;
            this.element = element;
        }

        public CourseOffering getCourseOffering() {
            return this.courseOffering;
        }

        public void setCourseOffering(CourseOffering courseOffering) {
            this.courseOffering = courseOffering;
        }

        public Element getElement() {
            return this.element;
        }

        public void setElement(Element element) {
            this.element = element;
        }
    }
}

