/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.CbsForm;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.ConflictStatisticsInfo;

@Service(value="/cbs")
public class CbsAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        CbsForm myForm = (CbsForm)form;
        this.sessionContext.checkPermission(Right.ConflictStatistics);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null) {
            op = "Refresh";
        }
        if ("Refresh".equals(op)) {
            myForm.reset(mapping, request);
        }
        if ("Change".equals(op)) {
            this.sessionContext.getUser().setProperty("Cbs.limit", String.valueOf(myForm.getLimit()));
            this.sessionContext.getUser().setProperty("Cbs.type", String.valueOf(myForm.getTypeInt()));
        } else {
            myForm.setLimit(Double.parseDouble(this.sessionContext.getUser().getProperty("Cbs.limit", String.valueOf(CbsForm.sDefaultLimit))));
            myForm.setTypeInt(Integer.parseInt(this.sessionContext.getUser().getProperty("Cbs.type", String.valueOf(CbsForm.sDefaultType))));
        }
        ConflictStatisticsInfo cbs = null;
        if (this.courseTimetablingSolverService.getSolver() != null) {
            cbs = this.courseTimetablingSolverService.getSolver().getCbsInfo();
        } else {
            String solutionIdsStr = (String)this.sessionContext.getAttribute(SessionAttribute.SelectedSolution);
            if (solutionIdsStr != null) {
                for (String solutionId : solutionIdsStr.split(",")) {
                    ConflictStatisticsInfo x;
                    Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                    if (solution == null || (x = (ConflictStatisticsInfo)solution.getInfo("CBSInfo")) == null) continue;
                    if (cbs == null) {
                        cbs = x;
                        continue;
                    }
                    cbs.merge(x);
                }
            }
        }
        if (cbs != null) {
            request.setAttribute("cbs", (Object)cbs);
        }
        return mapping.findForward("showCbs");
    }
}

