/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.IcalObject;
import com.google.ical.values.IcalParseUtil;
import com.google.ical.values.IcalSchema;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIcalObject
implements IcalObject {
    private static final Pattern CONTENT_LINE_RE = Pattern.compile("^((?:[^:;\"]|\"[^\"]*\")+)(;(?:[^:\"]|\"[^\"]*\")+)?:(.*)$");
    private static final Pattern PARAM_RE = Pattern.compile("^;([^=]+)=(?:\"([^\"]*)\"|([^\";:]*))");
    static final Pattern ICAL_SPECIALS = Pattern.compile("[:;]");
    private String name;
    private Map<String, String> extParams = null;

    AbstractIcalObject() {
    }

    protected void parse(String icalString, IcalSchema schema) throws ParseException {
        String unfolded = IcalParseUtil.unfoldIcal(icalString);
        Matcher m = CONTENT_LINE_RE.matcher(unfolded);
        if (!m.matches()) {
            schema.badContent(icalString);
        }
        this.setName(m.group(1).toUpperCase());
        String paramText = m.group(2);
        if (null == paramText) {
            paramText = "";
        }
        String content = m.group(3);
        HashMap<String, String> params = new HashMap<String, String>();
        String rest = paramText;
        while (!"".equals(rest)) {
            Matcher m2 = PARAM_RE.matcher(rest);
            if (!m2.find()) {
                schema.badPart(rest, null);
            }
            rest = rest.substring(m2.end(0));
            String k = m2.group(1).toUpperCase();
            String v = m2.group(2);
            if (null == v) {
                v = m2.group(3);
            }
            if (params.containsKey(k)) {
                schema.dupePart(k);
            }
            params.put(k, v);
        }
        schema.applyObjectSchema(this.name, params, content, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, String> getExtParams() {
        if (null == this.extParams) {
            this.extParams = new LinkedHashMap<String, String>();
        }
        return this.extParams;
    }

    public boolean hasExtParams() {
        return null != this.extParams && !this.extParams.isEmpty();
    }
}

