/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalVersion;
import biweekly.io.text.FoldedLineReader;
import biweekly.io.text.ICalParseException;
import biweekly.io.text.ICalRawLine;
import biweekly.parameter.ICalParameters;
import biweekly.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ICalRawReader
implements Closeable {
    private final FoldedLineReader reader;
    private final List<String> components = new ArrayList<String>();
    private boolean caretDecodingEnabled = true;
    private ICalVersion version = null;

    public ICalRawReader(Reader reader) {
        this.reader = new FoldedLineReader(reader);
    }

    public int getLineNum() {
        return this.reader.getLineNum();
    }

    public ICalVersion getVersion() {
        return this.version;
    }

    public ICalRawLine readLine() throws IOException {
        ICalVersion version;
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        String propertyName = null;
        ICalParameters parameters = new ICalParameters();
        String value = null;
        char escapeChar = '\u0000';
        boolean inQuotes = false;
        StringBuilder buffer = new StringBuilder();
        String curParamName = null;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (escapeChar != '\u0000') {
                if (escapeChar == '\\') {
                    if (ch == '\\') {
                        buffer.append(ch);
                    } else if (ch == 'n' || ch == 'N') {
                        buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\"' && this.version != ICalVersion.V1_0) {
                        buffer.append(ch);
                    } else if (ch == ';' && this.version == ICalVersion.V1_0) {
                        buffer.append(ch);
                    } else {
                        buffer.append(escapeChar).append(ch);
                    }
                } else if (escapeChar == '^') {
                    if (ch == '^') {
                        buffer.append(ch);
                    } else if (ch == 'n') {
                        buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\'') {
                        buffer.append('\"');
                    } else {
                        buffer.append(escapeChar).append(ch);
                    }
                }
                escapeChar = '\u0000';
                continue;
            }
            if (ch == '\\' || ch == '^' && this.version != ICalVersion.V1_0 && this.caretDecodingEnabled) {
                escapeChar = ch;
                continue;
            }
            if (!(ch != ';' && ch != ':' || inQuotes)) {
                if (propertyName == null) {
                    propertyName = buffer.toString();
                } else {
                    String paramValue = buffer.toString();
                    if (this.version == ICalVersion.V1_0) {
                        paramValue = StringUtils.ltrim(paramValue);
                    }
                    parameters.put(curParamName, paramValue);
                    curParamName = null;
                }
                buffer.setLength(0);
                if (ch != ':') continue;
                if (i < line.length() - 1) {
                    value = line.substring(i + 1);
                    break;
                }
                value = "";
                break;
            }
            if (ch == ',' && !inQuotes && this.version != ICalVersion.V1_0) {
                parameters.put(curParamName, buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch == '=' && curParamName == null) {
                curParamName = buffer.toString();
                if (this.version == ICalVersion.V1_0) {
                    curParamName = StringUtils.rtrim(curParamName);
                }
                buffer.setLength(0);
                continue;
            }
            if (ch == '\"' && this.version != ICalVersion.V1_0) {
                inQuotes = !inQuotes;
                continue;
            }
            buffer.append(ch);
        }
        if (propertyName == null || value == null) {
            throw new ICalParseException(line);
        }
        if ("BEGIN".equalsIgnoreCase(propertyName)) {
            this.components.add(value.toUpperCase());
        } else if ("END".equalsIgnoreCase(propertyName)) {
            int index = this.components.lastIndexOf(value.toUpperCase());
            if (index >= 0) {
                this.components.subList(index, this.components.size()).clear();
            }
        } else if ("VERSION".equalsIgnoreCase(propertyName) && this.isUnderVCalendar() && (version = ICalVersion.get(value)) != null) {
            this.version = version;
            return this.readLine();
        }
        return new ICalRawLine(propertyName, parameters, value);
    }

    private boolean isUnderVCalendar() {
        int firstIndex = this.components.indexOf("VCALENDAR");
        if (firstIndex < 0) {
            return false;
        }
        int lastIndex = this.components.lastIndexOf("VCALENDAR");
        return firstIndex == lastIndex && firstIndex == this.components.size() - 1;
    }

    public boolean isCaretDecodingEnabled() {
        return this.caretDecodingEnabled;
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.caretDecodingEnabled = enable;
    }

    public Charset getEncoding() {
        return this.reader.getEncoding();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

