/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.FreeBusy;
import biweekly.property.ICalProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeBusyScribe
extends ICalPropertyScribe<FreeBusy> {
    public FreeBusyScribe() {
        super(FreeBusy.class, "FREEBUSY");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.PERIOD;
    }

    @Override
    protected String _writeText(final FreeBusy property, final WriteContext context) {
        List<Period> values = property.getValues();
        return FreeBusyScribe.list(values, new ICalPropertyScribe.ListCallback<Period>(){

            @Override
            public String asString(Period period) {
                StringBuilder sb = new StringBuilder();
                Date start = period.getStartDate();
                if (start != null) {
                    String dateStr = ICalPropertyScribe.date(start, (ICalProperty)property, context).extended(false).write();
                    sb.append(dateStr);
                }
                sb.append('/');
                Date end = period.getEndDate();
                if (end != null) {
                    String dateStr = ICalPropertyScribe.date(end, (ICalProperty)property, context).extended(false).write();
                    sb.append(dateStr);
                } else if (period.getDuration() != null) {
                    sb.append(period.getDuration());
                }
                return sb.toString();
            }
        });
    }

    @Override
    protected FreeBusy _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(FreeBusyScribe.list(value), parameters, context);
    }

    @Override
    protected void _writeXml(FreeBusy property, XCalElement element, WriteContext context) {
        for (Period period : property.getValues()) {
            Duration duration;
            Date end;
            XCalElement periodElement = element.append(ICalDataType.PERIOD);
            Date start = period.getStartDate();
            if (start != null) {
                String dateStr = FreeBusyScribe.date(start, (ICalProperty)property, context).extended(true).write();
                periodElement.append("start", dateStr);
            }
            if ((end = period.getEndDate()) != null) {
                String dateStr = FreeBusyScribe.date(end, (ICalProperty)property, context).extended(true).write();
                periodElement.append("end", dateStr);
            }
            if ((duration = period.getDuration()) == null) continue;
            periodElement.append("duration", duration.toString());
        }
    }

    @Override
    protected FreeBusy _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        List<XCalElement> periodElements = element.children(ICalDataType.PERIOD);
        if (periodElements.isEmpty()) {
            throw FreeBusyScribe.missingXmlElements(ICalDataType.PERIOD);
        }
        FreeBusy property = new FreeBusy();
        for (XCalElement periodElement : periodElements) {
            String startStr = periodElement.first("start");
            if (startStr == null) {
                throw new CannotParseException(9, new Object[0]);
            }
            ICalDate start = null;
            try {
                start = FreeBusyScribe.date(startStr).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(10, startStr);
            }
            String endStr = periodElement.first("end");
            if (endStr != null) {
                try {
                    ICalDate end = FreeBusyScribe.date(endStr).parse();
                    property.addValue((Date)start, end);
                    context.addDate(start, property, parameters);
                    context.addDate(end, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(11, endStr);
                }
            }
            String durationStr = periodElement.first("duration");
            if (durationStr != null) {
                try {
                    Duration duration = Duration.parse(durationStr);
                    property.addValue((Date)start, duration);
                    context.addDate(start, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(12, durationStr);
                }
            }
            throw new CannotParseException(13, new Object[0]);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(FreeBusy property, WriteContext context) {
        List<Period> values = property.getValues();
        if (values.isEmpty()) {
            return JCalValue.single("");
        }
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Period period : values) {
            StringBuilder sb = new StringBuilder();
            Date start = period.getStartDate();
            if (start != null) {
                String dateStr = FreeBusyScribe.date(start, (ICalProperty)property, context).extended(true).write();
                sb.append(dateStr);
            }
            sb.append('/');
            Date end = period.getEndDate();
            if (end != null) {
                String dateStr = FreeBusyScribe.date(end, (ICalProperty)property, context).extended(true).write();
                sb.append(dateStr);
            } else if (period.getDuration() != null) {
                sb.append(period.getDuration());
            }
            valuesStr.add(sb.toString());
        }
        return JCalValue.multi(valuesStr);
    }

    @Override
    protected FreeBusy _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asMulti(), parameters, context);
    }

    private FreeBusy parse(List<String> periods, ICalParameters parameters, ParseContext context) {
        FreeBusy property = new FreeBusy();
        for (String period : periods) {
            String[] periodSplit = period.split("/");
            if (periodSplit.length < 2) {
                throw new CannotParseException(13, new Object[0]);
            }
            String startStr = periodSplit[0];
            ICalDate start = null;
            try {
                start = FreeBusyScribe.date(startStr).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(10, startStr);
            }
            String endStr = periodSplit[1];
            ICalDate end = null;
            try {
                end = FreeBusyScribe.date(endStr).parse();
                property.addValue((Date)start, end);
                context.addDate(start, property, parameters);
                context.addDate(end, property, parameters);
            }
            catch (IllegalArgumentException e) {
                try {
                    Duration duration = Duration.parse(endStr);
                    property.addValue((Date)start, duration);
                    context.addDate(start, property, parameters);
                }
                catch (IllegalArgumentException e2) {
                    throw new CannotParseException(14, endStr);
                }
            }
        }
        return property;
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

