/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ValidationWarnings;
import biweekly.Warning;
import biweekly.component.RawComponent;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.Status;
import biweekly.util.ListMultimap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ICalComponent {
    protected final ListMultimap<Class<? extends ICalComponent>, ICalComponent> components = new ListMultimap();
    protected final ListMultimap<Class<? extends ICalProperty>, ICalProperty> properties = new ListMultimap();

    public <T extends ICalProperty> T getProperty(Class<T> clazz) {
        return (T)((ICalProperty)clazz.cast(this.properties.first(clazz)));
    }

    public <T extends ICalProperty> List<T> getProperties(Class<T> clazz) {
        List<ICalProperty> props = this.properties.get(clazz);
        ArrayList<T> ret = new ArrayList<T>(props.size());
        for (ICalProperty property : props) {
            ret.add(clazz.cast(property));
        }
        return ret;
    }

    public ListMultimap<Class<? extends ICalProperty>, ICalProperty> getProperties() {
        return this.properties;
    }

    public void addProperty(ICalProperty property) {
        this.properties.put(property.getClass(), property);
    }

    public void setProperty(ICalProperty property) {
        this.properties.replace(property.getClass(), property);
    }

    public <T extends ICalProperty> void setProperty(Class<T> clazz, T property) {
        this.properties.replace(clazz, property);
    }

    public void removeProperties(Class<? extends ICalProperty> clazz) {
        this.properties.removeAll(clazz);
    }

    public void removeComponents(Class<? extends ICalComponent> clazz) {
        this.components.removeAll(clazz);
    }

    public RawProperty getExperimentalProperty(String name) {
        for (RawProperty raw : this.getProperties(RawProperty.class)) {
            if (!raw.getName().equalsIgnoreCase(name)) continue;
            return raw;
        }
        return null;
    }

    public List<RawProperty> getExperimentalProperties(String name) {
        ArrayList<RawProperty> props = new ArrayList<RawProperty>();
        for (RawProperty raw : this.getProperties(RawProperty.class)) {
            if (!raw.getName().equalsIgnoreCase(name)) continue;
            props.add(raw);
        }
        return props;
    }

    public List<RawProperty> getExperimentalProperties() {
        return this.getProperties(RawProperty.class);
    }

    public RawProperty addExperimentalProperty(String name, String value) {
        return this.addExperimentalProperty(name, null, value);
    }

    public RawProperty addExperimentalProperty(String name, ICalDataType dataType, String value) {
        RawProperty raw = new RawProperty(name, dataType, value);
        this.addProperty(raw);
        return raw;
    }

    public RawProperty setExperimentalProperty(String name, String value) {
        return this.setExperimentalProperty(name, null, value);
    }

    public RawProperty setExperimentalProperty(String name, ICalDataType dataType, String value) {
        this.removeExperimentalProperty(name);
        return this.addExperimentalProperty(name, dataType, value);
    }

    public void removeExperimentalProperty(String name) {
        List<RawProperty> xproperties = this.getExperimentalProperties(name);
        for (RawProperty xproperty : xproperties) {
            this.properties.remove(xproperty.getClass(), xproperty);
        }
    }

    public <T extends ICalComponent> T getComponent(Class<T> clazz) {
        return (T)((ICalComponent)clazz.cast(this.components.first(clazz)));
    }

    public <T extends ICalComponent> List<T> getComponents(Class<T> clazz) {
        List<ICalComponent> comp = this.components.get(clazz);
        ArrayList<T> ret = new ArrayList<T>(comp.size());
        for (ICalComponent property : comp) {
            ret.add(clazz.cast(property));
        }
        return ret;
    }

    public ListMultimap<Class<? extends ICalComponent>, ICalComponent> getComponents() {
        return this.components;
    }

    public void addComponent(ICalComponent component) {
        this.components.put(component.getClass(), component);
    }

    public void setComponent(ICalComponent component) {
        this.components.replace(component.getClass(), component);
    }

    public <T extends ICalComponent> void setComponent(Class<T> clazz, T component) {
        this.components.replace(clazz, component);
    }

    public RawComponent getExperimentalComponent(String name) {
        for (RawComponent raw : this.getComponents(RawComponent.class)) {
            if (!raw.getName().equalsIgnoreCase(name)) continue;
            return raw;
        }
        return null;
    }

    public List<RawComponent> getExperimentalComponents(String name) {
        ArrayList<RawComponent> props = new ArrayList<RawComponent>();
        for (RawComponent raw : this.getComponents(RawComponent.class)) {
            if (!raw.getName().equalsIgnoreCase(name)) continue;
            props.add(raw);
        }
        return props;
    }

    public List<RawComponent> getExperimentalComponents() {
        return this.getComponents(RawComponent.class);
    }

    public RawComponent addExperimentalComponent(String name) {
        RawComponent raw = new RawComponent(name);
        this.addComponent(raw);
        return raw;
    }

    public RawComponent setExperimentalComponents(String name) {
        this.removeExperimentalComponents(name);
        return this.addExperimentalComponent(name);
    }

    public void removeExperimentalComponents(String name) {
        List<RawComponent> xcomponents = this.getExperimentalComponents(name);
        for (RawComponent xcomponent : xcomponents) {
            this.components.remove(xcomponent.getClass(), xcomponent);
        }
    }

    public final List<ValidationWarnings.WarningsGroup> validate(List<ICalComponent> hierarchy, ICalVersion version) {
        ArrayList<ValidationWarnings.WarningsGroup> warnings = new ArrayList<ValidationWarnings.WarningsGroup>();
        ArrayList<Warning> warningsBuf = new ArrayList<Warning>(0);
        this.validate(hierarchy, version, warningsBuf);
        if (!warningsBuf.isEmpty()) {
            warnings.add(new ValidationWarnings.WarningsGroup(this, hierarchy, warningsBuf));
        }
        hierarchy = new ArrayList<ICalComponent>(hierarchy);
        hierarchy.add(this);
        for (ICalProperty property : this.properties.values()) {
            List<Warning> propWarnings = property.validate(hierarchy, version);
            if (propWarnings.isEmpty()) continue;
            warnings.add(new ValidationWarnings.WarningsGroup(property, hierarchy, propWarnings));
        }
        for (ICalComponent component : this.components.values()) {
            warnings.addAll(component.validate(hierarchy, version));
        }
        return warnings;
    }

    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
    }

    protected void checkRequiredCardinality(List<Warning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = this.getProperties(clazz);
            if (props.isEmpty()) {
                warnings.add(Warning.validate(2, clazz.getSimpleName()));
                continue;
            }
            if (props.size() <= 1) continue;
            warnings.add(Warning.validate(3, clazz.getSimpleName()));
        }
    }

    protected void checkOptionalCardinality(List<Warning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = this.getProperties(clazz);
            if (props.size() <= 1) continue;
            warnings.add(Warning.validate(3, clazz.getSimpleName()));
        }
    }

    protected void checkStatus(List<Warning> warnings, Status ... allowed) {
        Status actual = this.getProperty(Status.class);
        if (actual == null) {
            return;
        }
        ArrayList<String> allowedValues = new ArrayList<String>(allowed.length);
        for (Status status : allowed) {
            String value = ((String)status.getValue()).toLowerCase();
            allowedValues.add(value);
        }
        String actualValue = ((String)actual.getValue()).toLowerCase();
        if (!allowedValues.contains(actualValue)) {
            warnings.add(Warning.validate(13, actual.getValue(), allowedValues));
        }
    }
}

