/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class FoldedLineReader
extends BufferedReader {
    private final Pattern foldedQuotedPrintableValueRegex = Pattern.compile("[^:]*?QUOTED-PRINTABLE.*?:.*?=", 2);
    private String lastLine;
    private boolean singleSpaceFolding = true;
    private int lastLineNum = 0;
    private int lineCount = 0;
    private final Charset charset;

    public FoldedLineReader(Reader reader) {
        super(reader);
        InputStreamReader isr;
        String charsetStr;
        this.charset = reader instanceof InputStreamReader ? ((charsetStr = (isr = (InputStreamReader)reader).getEncoding()) == null ? null : Charset.forName(charsetStr)) : null;
    }

    public FoldedLineReader(String text) {
        this(new StringReader(text));
    }

    public void setSingleSpaceFoldingEnabled(boolean enabled) {
        this.singleSpaceFolding = enabled;
    }

    public boolean isSingleSpaceFoldingEnabled() {
        return this.singleSpaceFolding;
    }

    public int getLineNum() {
        return this.lastLineNum;
    }

    public Charset getEncoding() {
        return this.charset;
    }

    private String readNonEmptyLine() throws IOException {
        String line;
        do {
            if ((line = super.readLine()) == null) {
                return null;
            }
            ++this.lineCount;
        } while (line.length() <= 0);
        return line;
    }

    public String readLine() throws IOException {
        StringBuilder unfoldedLine;
        block8: {
            String line;
            String wholeLine = this.lastLine == null ? this.readNonEmptyLine() : this.lastLine;
            this.lastLine = null;
            if (wholeLine == null) {
                return null;
            }
            boolean foldedQuotedPrintableLine = this.foldedQuotedPrintableValueRegex.matcher(wholeLine).matches();
            if (foldedQuotedPrintableLine) {
                wholeLine = FoldedLineReader.chop(wholeLine);
            }
            this.lastLineNum = this.lineCount;
            unfoldedLine = new StringBuilder(wholeLine);
            while (true) {
                int lastWhitespace;
                String string = line = foldedQuotedPrintableLine ? super.readLine() : this.readNonEmptyLine();
                if (line == null) break block8;
                if (foldedQuotedPrintableLine) {
                    boolean endsInEquals = (line = StringUtils.ltrim(line)).endsWith("=");
                    if (endsInEquals) {
                        line = FoldedLineReader.chop(line);
                    }
                    unfoldedLine.append(line);
                    if (endsInEquals) {
                        continue;
                    }
                    break block8;
                }
                if (line.length() <= 0 || !Character.isWhitespace(line.charAt(0))) break;
                if (!this.singleSpaceFolding) {
                    for (lastWhitespace = 1; lastWhitespace < line.length() && Character.isWhitespace(line.charAt(lastWhitespace)); ++lastWhitespace) {
                    }
                }
                unfoldedLine.append(line.substring(lastWhitespace));
            }
            this.lastLine = line;
        }
        return unfoldedLine.toString();
    }

    private static String chop(String string) {
        return string.length() > 0 ? string.substring(0, string.length() - 1) : string;
    }
}

