/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SoftCache<K, V>
implements Map<K, V> {
    private static Logger sLogger = Logger.getLogger(SoftCache.class);
    private HashMap<K, Reference<V>> iCache = new HashMap();
    private ReferenceQueue<V> iQueue = new ReferenceQueue();

    public SoftCache() {
        new SoftCacheCleanupThread().start();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.iCache.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.iCache.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.iCache.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        for (Reference<V> ref : this.iCache.values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        Reference<V> ref = this.iCache.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public synchronized V remove(Object key) {
        Reference<V> ref = this.iCache.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        return this.putReference(key, new SoftReference<V>(value, this.iQueue));
    }

    public Object putSoft(K key, V value) {
        return this.putReference(key, new SoftReference<V>(value, this.iQueue));
    }

    public Object putWeak(K key, V value) {
        return this.putReference(key, new WeakReference<V>(value, this.iQueue));
    }

    private synchronized V putReference(K key, Reference<V> ref) {
        Reference<V> old = this.iCache.put(key, ref);
        return old == null ? null : (V)old.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized int size() {
        return this.iCache.size();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.iCache.keySet();
    }

    @Override
    public synchronized Collection<V> values() {
        ArrayList<V> ret = new ArrayList<V>(this.iCache.size());
        for (Reference<V> ref : this.iCache.values()) {
            V value = ref.get();
            if (value == null) continue;
            ret.add(value);
        }
        return ret;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> ret = new HashSet<Map.Entry<K, V>>(this.iCache.size());
        for (Map.Entry<K, Reference<V>> entry : this.iCache.entrySet()) {
            if (entry.getValue().get() == null) continue;
            ret.add(new Entry(entry.getKey(), entry.getValue().get()));
        }
        return ret;
    }

    public synchronized void cleanDeallocated() {
        int nrCleaned = 0;
        Iterator<Map.Entry<K, Reference<V>>> i = this.iCache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, Reference<V>> entry = i.next();
            if (entry.getValue().get() != null) continue;
            i.remove();
            ++nrCleaned;
        }
        sLogger.debug("cleaned " + nrCleaned + " of " + (this.iCache.size() + nrCleaned) + " items.");
    }

    private ReferenceQueue<V> getQueue() {
        return this.iQueue;
    }

    public static void test() {
        for (int t = 0; t < 10; ++t) {
            SoftCache<Integer, byte[]> x = new SoftCache<Integer, byte[]>();
            for (int i = 0; i < 1000000; ++i) {
                x.put(new Integer(i), new byte[1024]);
            }
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private K iKey = null;
        private V iValue = null;

        private Entry(K key, V value) {
            this.iKey = key;
            this.iValue = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public K getKey() {
            return this.iKey;
        }

        @Override
        public V getValue() {
            return this.iValue;
        }

        @Override
        public V setValue(V value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private class SoftCacheCleanupThread
    extends Thread {
        private SoftCacheCleanupThread() {
            this.setDaemon(true);
            this.setName("SoftCacheCleanup");
        }

        @Override
        public void run() {
            try {
                ReferenceQueue q;
                while ((q = SoftCache.this.getQueue()) != null) {
                    if (q.remove(10000L) == null) continue;
                    while (q.poll() != null) {
                    }
                    SoftCache.this.cleanDeallocated();
                }
                sLogger.debug("cache terminated");
            }
            catch (Exception e) {
                sLogger.error("cleanup thread failed, reason:" + e.getMessage(), e);
            }
        }
    }
}

