/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

public class MakeAssignmentsForClassEvents {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private Session iSession = null;
    private Vector<Date> iWeekDate = null;
    private org.hibernate.Session iHibSession = null;
    private Hashtable<String, DatePattern> iDatePatterns = null;
    private TimePattern iExactTimePattern = null;
    private Hashtable<Long, Location> iLocations = null;

    public MakeAssignmentsForClassEvents(Session session, org.hibernate.Session hibSession) {
        this.iHibSession = hibSession;
        this.iSession = session;
        Calendar date = Calendar.getInstance(Locale.US);
        date.setLenient(true);
        date.setTime(this.iSession.getSessionBeginDateTime());
        this.iWeekDate = new Vector();
        while (date.getTime().compareTo(this.iSession.getSessionEndDateTime()) <= 0) {
            this.iWeekDate.add(date.getTime());
            int idx = 0;
            while (idx < 7) {
                date.add(6, 1);
                if (this.iSession.getHoliday(date.get(5), date.get(2)) == 2) continue;
                ++idx;
            }
        }
        this.iWeekDate.add(date.getTime());
        this.iDatePatterns = new Hashtable();
        for (DatePattern dp : DatePattern.findAll(this.iSession, true, null, null)) {
            this.iDatePatterns.put(dp.getName(), dp);
        }
        this.iExactTimePattern = TimePattern.findExactTime(this.iSession.getUniqueId());
        this.iLocations = new Hashtable();
        for (Location location : Location.findAll(this.iSession.getUniqueId())) {
            if (location.getPermanentId() == null) continue;
            this.iLocations.put(location.getPermanentId(), location);
        }
    }

    protected int getWeek(Date date) {
        int idx = 0;
        while (idx + 1 < this.iWeekDate.size()) {
            if (date.compareTo(this.iWeekDate.elementAt(idx)) < 0) {
                return idx;
            }
            ++idx;
        }
        return this.iWeekDate.size() - 1;
    }

    protected TreeSet<Integer> getWeeks(Event event) {
        TreeSet<Integer> weeks = new TreeSet<Integer>();
        for (Meeting meeting : event.getMeetings()) {
            weeks.add(this.getWeek(meeting.getMeetingDate()));
        }
        return weeks;
    }

    protected DatePattern getDefaultDatePattern() {
        TreeSet<Integer> weeks = new TreeSet<Integer>();
        int i = 1;
        while (i + 2 < this.iWeekDate.size()) {
            weeks.add(i);
            ++i;
        }
        return this.getDatePattern(weeks);
    }

    protected DatePattern getDatePattern(TreeSet<Integer> weeks) {
        if (weeks.isEmpty()) {
            return this.getDefaultDatePattern();
        }
        String patternName = null;
        int firstWeek = -1;
        int lastWeek = -1;
        for (Integer week : weeks) {
            if (lastWeek < 0) {
                firstWeek = week;
            } else if (lastWeek + 1 != week) {
                patternName = (patternName == null ? "" : patternName + ",") + (lastWeek == firstWeek ? String.valueOf(lastWeek) : firstWeek + "-" + lastWeek);
                firstWeek = week;
            }
            lastWeek = week;
        }
        patternName = "Week " + (patternName == null ? "" : patternName + ",") + (lastWeek == firstWeek ? String.valueOf(lastWeek) : firstWeek + "-" + lastWeek);
        DatePattern dp = this.iDatePatterns.get(patternName);
        if (dp != null) {
            return dp;
        }
        dp = new DatePattern();
        dp.setName(patternName);
        dp.setSession(this.iSession);
        dp.setType(0);
        dp.setVisible(true);
        Calendar date = Calendar.getInstance(Locale.US);
        int week = weeks.first();
        date.setTime(this.iWeekDate.get(week == 0 ? 0 : week - 1));
        if (week == 0) {
            date.add(6, -7);
        }
        dp.setPatternOffset(date.getTime());
        String pattern = "";
        while (week <= weeks.last()) {
            while (date.getTime().compareTo(this.iWeekDate.elementAt(week)) < 0) {
                pattern = pattern + (!weeks.contains(week) ? "0" : (this.iSession.getHoliday(date.get(5), date.get(2)) == 0 ? "1" : "0"));
                date.add(6, 1);
            }
            ++week;
        }
        dp.setPattern(pattern);
        this.iHibSession.save((Object)dp);
        this.iDatePatterns.put(patternName, dp);
        return dp;
    }

    public int getStartSlot(Event event) {
        Iterator<Meeting> i = event.getMeetings().iterator();
        if (i.hasNext()) {
            Meeting meeting = i.next();
            return meeting.getStartPeriod();
        }
        return 0;
    }

    public int getDaysCode(Event event) {
        int daysCode = 0;
        for (Meeting meeting : event.getMeetings()) {
            Calendar date = Calendar.getInstance(Locale.US);
            date.setTime(meeting.getMeetingDate());
            switch (date.get(7)) {
                case 2: {
                    daysCode |= Constants.DAY_CODES[0];
                    break;
                }
                case 3: {
                    daysCode |= Constants.DAY_CODES[1];
                    break;
                }
                case 4: {
                    daysCode |= Constants.DAY_CODES[2];
                    break;
                }
                case 5: {
                    daysCode |= Constants.DAY_CODES[3];
                    break;
                }
                case 6: {
                    daysCode |= Constants.DAY_CODES[4];
                    break;
                }
                case 7: {
                    daysCode |= Constants.DAY_CODES[5];
                    break;
                }
                case 1: {
                    daysCode |= Constants.DAY_CODES[6];
                }
            }
        }
        return daysCode;
    }

    protected SolverGroup getSolverGroup(Department department) {
        if (department.getSolverGroup() != null) {
            return department.getSolverGroup();
        }
        SolverGroup sg = new SolverGroup();
        sg.setDepartments(new HashSet<Department>());
        sg.getDepartments().add(department);
        department.setSolverGroup(sg);
        sg.setAbbv(department.getAbbreviation() == null ? department.getDeptCode() : department.getAbbreviation());
        sg.setName(department.getName());
        sg.setSession(this.iSession);
        sg.setTimetableManagers(new HashSet<TimetableManager>(department.getTimetableManagers()));
        sg.setSolutions(new HashSet<Solution>());
        this.iHibSession.save((Object)sg);
        this.iHibSession.update((Object)department);
        return sg;
    }

    protected Solution getSolution(SolverGroup sg) {
        if (sg.getCommittedSolution() != null) {
            return sg.getCommittedSolution();
        }
        Solution solution = new Solution();
        solution.setCommitDate(new Date());
        solution.setCommited(true);
        solution.setCreated(new Date());
        solution.setCreator("MakeAssignmentsForClassEvents");
        solution.setOwner(sg);
        sg.getSolutions().add(solution);
        solution.setValid(true);
        solution.setAssignments(new HashSet<Assignment>());
        this.iHibSession.save((Object)solution);
        this.iHibSession.update((Object)sg);
        return solution;
    }

    public Solution getSolution(Department dept) {
        return this.getSolution(this.getSolverGroup(dept));
    }

    public Set<Location> getRooms(Event event) {
        HashSet<Location> rooms = new HashSet<Location>();
        for (Meeting meeting : event.getMeetings()) {
            Location location;
            if (meeting.getLocationPermanentId() == null || (location = this.iLocations.get(meeting.getLocationPermanentId())) == null) continue;
            rooms.add(location);
        }
        return rooms;
    }

    public TimePattern getTimePattern(Event event) {
        if (this.iExactTimePattern != null) {
            return this.iExactTimePattern;
        }
        this.iExactTimePattern = new TimePattern();
        this.iExactTimePattern.setName("Exact Time");
        this.iExactTimePattern.setBreakTime(0);
        this.iExactTimePattern.setMinPerMtg(0);
        this.iExactTimePattern.setNrMeetings(0);
        this.iExactTimePattern.setSession(this.iSession);
        this.iExactTimePattern.setSlotsPerMtg(0);
        this.iExactTimePattern.setType(5);
        this.iExactTimePattern.setVisible(true);
        this.iHibSession.save((Object)this.iExactTimePattern);
        return this.iExactTimePattern;
    }

    public Assignment createAssignment(ClassEvent event, TimePattern tp, DatePattern dp) {
        if (event == null || event.getClazz() == null || event.getMeetings().isEmpty()) {
            return null;
        }
        Class_ clazz = event.getClazz();
        Assignment assignment = clazz.getCommittedAssignment();
        if (assignment == null) {
            assignment = new Assignment();
            assignment.setClazz(clazz);
            Department dept = clazz.getManagingDept();
            if (dept == null) {
                dept = clazz.getSchedulingSubpart().getControllingDept();
            }
            assignment.setSolution(this.getSolution(dept));
            assignment.setClassName(clazz.getClassLabel(ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue()));
            assignment.setClassId(clazz.getUniqueId());
            clazz.setCommittedAssignment(assignment);
        }
        assignment.setDays(this.getDaysCode(event));
        assignment.setStartSlot(this.getStartSlot(event));
        assignment.setRooms(this.getRooms(event));
        assignment.setTimePattern(tp != null ? tp : this.getTimePattern(event));
        assignment.setDatePattern(dp != null ? dp : this.getDatePattern(event));
        this.iHibSession.saveOrUpdate((Object)clazz);
        this.iHibSession.saveOrUpdate((Object)assignment);
        return assignment;
    }

    public DatePattern getDatePattern(Event event) {
        return this.getDatePattern(this.getWeeks(event));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(new Properties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            List subjects = new SubjectAreaDAO().findAll();
            boolean excludeCommittedAssignments = !"true".equals(System.getProperty("redo"));
            for (SubjectArea sa : subjects) {
                System.out.println("Procession subject area " + sa.getSubjectAreaAbbreviation() + " for " + sa.getSession().getLabel());
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    MakeAssignmentsForClassEvents m = new MakeAssignmentsForClassEvents((Session)new SessionDAO().get(sa.getSession().getUniqueId()), hibSession);
                    Iterator j = hibSession.createQuery("select e from ClassEvent e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl=true and co.subjectArea.uniqueId=:subjectId " + (excludeCommittedAssignments ? " and c.committedAssignment is null" : "")).setLong("subjectId", sa.getUniqueId().longValue()).iterate();
                    while (j.hasNext()) {
                        ClassEvent e = (ClassEvent)j.next();
                        Assignment a = m.createAssignment(e, null, null);
                        e.getClazz().setDatePattern(m.getDatePattern(e));
                        System.out.println("  " + e.getEventName() + " -- " + (a == null ? "Not Assigned" : a.getPlacement().getLongName(CONSTANTS.useAmPm())));
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx == null) throw e;
                    tx.rollback();
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

