/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.extension.AssignedValue;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.model.Constraint;
import org.dom4j.Element;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.ui.TimetableInfo;

public class ExamConflictStatisticsInfo
implements TimetableInfo,
Serializable {
    private static final long serialVersionUID = 7L;
    public static int sVersion = 7;
    public static final int sConstraintTypeRoom = 1;
    public static final int sConstraintTypeInstructor = 2;
    public static final int sConstraintTypeGroup = 3;
    public static final int sConstraintTypeStudent = 4;
    private Hashtable iVariables = new Hashtable();
    private static String IMG_BASE = "images/";
    private static String IMG_EXPAND = IMG_BASE + "expand_node_btn.gif";
    private static String IMG_COLLAPSE = IMG_BASE + "collapse_node_btn.gif";
    private static String IMG_LEAF = IMG_BASE + "end_node_btn.gif";
    public static int TYPE_VARIABLE_BASED = 0;
    public static int TYPE_CONSTRAINT_BASED = 1;

    public Collection getCBS() {
        return this.iVariables.values();
    }

    public CBSVariable getCBS(Long classId) {
        return (CBSVariable)this.iVariables.get(classId);
    }

    public void load(ConflictStatistics cbs) {
        this.load(cbs, null);
    }

    public ExamConflictStatisticsInfo getConflictStatisticsSubInfo(Vector variables) {
        ExamConflictStatisticsInfo ret = new ExamConflictStatisticsInfo();
        Enumeration e = variables.elements();
        while (e.hasMoreElements()) {
            Exam exam = (Exam)e.nextElement();
            CBSVariable var = (CBSVariable)this.iVariables.get(exam.getId());
            if (var == null) continue;
            ret.iVariables.put(exam.getId(), var);
        }
        return ret;
    }

    public void merge(ExamConflictStatisticsInfo info) {
        if (info != null) {
            this.iVariables.putAll(info.iVariables);
        }
    }

    public void load(ConflictStatistics cbs, Long examId) {
        this.iVariables.clear();
        for (Map.Entry entry : cbs.getNoGoods().entrySet()) {
            AssignedValue assignment = (AssignedValue)entry.getKey();
            ExamPlacement placement = (ExamPlacement)assignment.getValue();
            Exam exam = (Exam)placement.variable();
            if (examId != null && !examId.equals(exam.getId())) continue;
            CBSVariable var = (CBSVariable)this.iVariables.get(exam.getId());
            if (var == null) {
                String pref = PreferenceLevel.sNeutral;
                var = new CBSVariable(exam.getId(), exam.getName(), pref);
                this.iVariables.put(exam.getId(), var);
            }
            Vector<Long> roomIds = new Vector<Long>();
            Vector<String> roomNames = new Vector<String>();
            Vector<Integer> roomPrefs = new Vector<Integer>();
            for (ExamRoomPlacement room : new TreeSet(placement.getRoomPlacements())) {
                roomIds.add(room.getId());
                roomNames.add(room.getName());
                roomPrefs.add(exam.getRoomPlacements().size() == placement.getRoomPlacements().size() ? PreferenceLevel.sIntLevelRequired : room.getPenalty(placement.getPeriod()));
            }
            CBSValue val = new CBSValue(var, placement.getPeriod().getId(), placement.getPeriod().getDayStr() + " " + placement.getPeriod().getTimeStr(), exam.getPeriodPlacements().size() == 1 ? PreferenceLevel.sIntLevelRequired : placement.getPeriodPlacement().getPenalty(), roomIds, roomNames, roomPrefs);
            var.values().add(val);
            List noGoods = (List)entry.getValue();
            Hashtable<Constraint, Vector<AssignedValue>> constr2assignments = new Hashtable<Constraint, Vector<AssignedValue>>();
            for (AssignedValue noGood : noGoods) {
                if (noGood.getConstraint() == null) continue;
                Vector<AssignedValue> aaa = (Vector<AssignedValue>)constr2assignments.get(noGood.getConstraint());
                if (aaa == null) {
                    aaa = new Vector<AssignedValue>();
                    constr2assignments.put(noGood.getConstraint(), aaa);
                }
                aaa.addElement(noGood);
            }
            for (Map.Entry entry2 : constr2assignments.entrySet()) {
                Constraint constraint = (Constraint)entry2.getKey();
                Vector noGoodsThisConstraint = (Vector)entry2.getValue();
                CBSConstraint con = null;
                con = constraint instanceof ExamRoom ? new CBSConstraint(val, 1, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof ExamInstructor ? new CBSConstraint(val, 2, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof ExamStudent ? new CBSConstraint(val, 4, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired) : (constraint instanceof ExamDistributionConstraint ? new CBSConstraint(val, 3, constraint.getId(), ((ExamDistributionConstraint)constraint).getTypeString(), constraint.isHard() ? PreferenceLevel.sRequired : PreferenceLevel.int2prolog(((ExamDistributionConstraint)constraint).getWeight())) : new CBSConstraint(val, -1, constraint.getId(), constraint.getName(), PreferenceLevel.sRequired))));
                val.constraints().add(con);
                Enumeration e3 = noGoodsThisConstraint.elements();
                while (e3.hasMoreElements()) {
                    AssignedValue ass = (AssignedValue)e3.nextElement();
                    ExamPlacement p = (ExamPlacement)ass.getValue();
                    Exam x = (Exam)p.variable();
                    String pr = PreferenceLevel.sNeutral;
                    Vector<Long> aroomIds = new Vector<Long>();
                    Vector<String> aroomNames = new Vector<String>();
                    Vector<Integer> aroomPrefs = new Vector<Integer>();
                    for (ExamRoomPlacement room : new TreeSet(p.getRoomPlacements())) {
                        aroomIds.add(room.getId());
                        aroomNames.add(room.getName());
                        aroomPrefs.add(x.getRoomPlacements().size() == p.getRoomPlacements().size() ? PreferenceLevel.sIntLevelRequired : room.getPenalty(p.getPeriod()));
                    }
                    CBSAssignment a = new CBSAssignment(con, x.getId(), x.getName(), pr, p.getPeriod().getId(), p.getPeriod().getDayStr() + " " + p.getPeriod().getTimeStr(), x.getPeriodPlacements().size() == 1 ? PreferenceLevel.sIntLevelRequired : p.getPeriodPlacement().getPenalty(), aroomIds, aroomNames, aroomPrefs);
                    con.assignments().add(a);
                    a.incCounter((int)ass.getCounter(0L));
                }
            }
        }
    }

    @Override
    public void load(Element root) {
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == sVersion) {
            this.iVariables.clear();
            Iterator i1 = root.elementIterator("var");
            while (i1.hasNext()) {
                CBSVariable var = new CBSVariable((Element)i1.next());
                this.iVariables.put(new Long(var.getId()), var);
            }
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        Iterator i1 = this.iVariables.values().iterator();
        while (i1.hasNext()) {
            ((CBSVariable)i1.next()).save(root.addElement("var"));
        }
    }

    private static int combine(int a, int b) {
        int ret = 0;
        for (int i = 0; i < 15; ++i) {
            ret = ret | (a & 1 << i) << i | (b & 1 << i) << i + 1;
        }
        return ret;
    }

    private void menu_item(PrintWriter out, String id, String name, String description, String page, boolean isCollapsed) {
        out.println("<div style=\"margin-left:5px;\">");
        out.println("<A style=\"border:0;background:0\" id=\"__idMenu" + id + "\" href=\"javascript:toggle('" + id + "')\" name=\"" + name + "\">");
        out.println("<img id=\"__idMenuImg" + id + "\" border=\"0\" src=\"" + (isCollapsed ? IMG_EXPAND : IMG_COLLAPSE) + "\" align=\"absmiddle\"></A>");
        out.println("&nbsp;<A class='noFancyLinks' target=\"__idContentFrame\" " + (page == null ? "" : page + " onmouseover=\"this.style.cursor='hand';this.style.cursor='pointer';\" ") + "title=\"" + (description == null ? "" : description) + "\" >" + name + (description == null ? "" : " <font color='gray'>[" + description + "]</font>") + "</A><br>");
        out.println("</div>");
        out.println("<div ID=\"__idMenuDiv" + id + "\" style=\"display:" + (isCollapsed ? "none" : "block") + ";position:relative;margin-left:18px;\">");
    }

    private void leaf_item(PrintWriter out, String name, String description, String page) {
        out.println("<div style=\"margin-left:5px;\">");
        out.println("<img border=\"0\" src=\"" + IMG_LEAF + "\" align=\"absmiddle\">");
        out.println("&nbsp;<A class='noFancyLinks' target=\"__idContentFrame\" " + (page == null ? "" : page + " onmouseover=\"this.style.cursor='hand';this.style.cursor='pointer';\" ") + "title=\"" + (description == null ? "" : description) + "\" >" + name + (description == null ? "" : " <font color='gray'>[" + description + "]</font>") + "</A><br>");
        out.println("</div>");
    }

    private void end_item(PrintWriter out) {
        out.println("</div>");
    }

    private void unassignedVariableMenuItem(PrintWriter out, String menuId, CBSVariable variable, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(variable.getPref()) + "'>" + variable.getName() + "</font>";
        String description = null;
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + variable.getId() + "&op=Reset','900','90%');\"";
        }
        this.menu_item(out, menuId, variable.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void unassignmentMenuItem(PrintWriter out, String menuId, CBSValue value, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.int2color(value.getPeriodPref()) + "'>" + value.getPeriodName() + "</font> ";
        String roomLink = "";
        for (int i = 0; i < value.getRoomIds().size(); ++i) {
            name = name + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color((Integer)value.getRoomPrefs().elementAt(i)) + "'>" + value.getRoomNames().elementAt(i) + "</font>";
            roomLink = roomLink + (i > 0 ? ":" : "") + value.getRoomIds().elementAt(i);
        }
        String description = null;
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + value.variable().getId() + "&period=" + value.getPeriodId() + "&room=" + roomLink + "&op=Try&reset=1','900','90%');\"";
        }
        this.menu_item(out, menuId, value.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void constraintMenuItem(PrintWriter out, String menuId, CBSConstraint constraint, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(constraint.getPref()) + "'>";
        String link = null;
        switch (constraint.getType()) {
            case 3: {
                name = name + "Distribution " + constraint.getName();
                break;
            }
            case 2: {
                name = name + "Instructor " + constraint.getName();
                if (!clickable) break;
                link = "examGrid.do?filter=" + constraint.getName() + "&resource=" + 1 + "&op=Cbs";
                break;
            }
            case 1: {
                name = name + "Room " + constraint.getName();
                if (!clickable) break;
                link = "examGrid.do?filter=" + constraint.getName() + "&resource=" + 0 + "&op=Cbs";
                break;
            }
            case 4: {
                name = name + "Student " + constraint.getName();
                break;
            }
            default: {
                name = name + (constraint.getName() == null ? "Unknown" : constraint.getName());
            }
        }
        name = name + "</font>";
        String description = null;
        String onClick = null;
        if (link != null) {
            onClick = "href=\"" + link + "\"";
        }
        this.menu_item(out, menuId, constraint.getCounter() + "&times; " + name, description, onClick, true);
    }

    private void assignmentLeafItem(PrintWriter out, CBSAssignment assignment, boolean clickable) {
        String name = "<font color='" + PreferenceLevel.prolog2color(assignment.getPref()) + "'>" + assignment.getName() + "</font> &larr; <font color='" + PreferenceLevel.int2color(assignment.getPeriodPref()) + "'>" + assignment.getPeriodName() + "</font> ";
        String roomLink = "";
        for (int i = 0; i < assignment.getRoomIds().size(); ++i) {
            name = name + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color((Integer)assignment.getRoomPrefs().elementAt(i)) + "'>" + assignment.getRoomNames().elementAt(i) + "</font>";
            roomLink = roomLink + (i > 0 ? ":" : "") + assignment.getRoomIds().elementAt(i);
        }
        String onClick = null;
        if (clickable) {
            onClick = "onclick=\"(parent ? parent : window).showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + assignment.getId() + "&period=" + assignment.getPeriodId() + "&room=" + roomLink + "&op=Try&reset=1','900','90%');\"";
        }
        this.leaf_item(out, assignment.getCounter() + "&times; " + name, null, onClick);
    }

    public static void printHtmlHeader(JspWriter jsp) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        ExamConflictStatisticsInfo.printHtmlHeader(out, false);
    }

    public static void printHtmlHeader(PrintWriter out, boolean style) {
        if (style) {
            out.println("<style type=\"text/css\">");
            out.println("<!--");
            out.println("A:link     { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:visited  { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:active   { color: blue; text-decoration: none; border:0; background:0; }");
            out.println("A:hover    { color: blue; text-decoration: none; border:0; background:0; }");
            out.println(".TextBody  { background-color: white; color:black; font-size: 12px; }");
            out.println(".WelcomeHead { color: black; margin-top: 0px; margin-left: 0px; font-weight: bold; text-align: right; font-size: 30px; font-family: Comic Sans MS}");
            out.println("-->");
            out.println("</style>");
            out.println();
        }
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        out.println("function toggle(item) {");
        out.println("\tobj=document.getElementById(\"__idMenuDiv\"+item);");
        out.println("\tvisible=(obj.style.display!=\"none\");");
        out.println("\timg=document.getElementById(\"__idMenuImg\" + item);");
        out.println("\tmenu=document.getElementById(\"__idMenu\" + item);");
        out.println("\tif (visible) {obj.style.display=\"none\";img.src=\"" + IMG_EXPAND + "\";}");
        out.println("\telse {obj.style.display=\"block\";img.src=\"" + IMG_COLLAPSE + "\";}");
        out.println("}");
        out.println("</script>");
        out.flush();
    }

    private Vector filter(Collection counters, double limit) {
        Vector cnt = new Vector(counters);
        Collections.sort(cnt);
        int total = 0;
        Enumeration e = cnt.elements();
        while (e.hasMoreElements()) {
            total += ((Counter)e.nextElement()).getCounter();
        }
        int totalLimit = (int)Math.ceil(limit * (double)total);
        int current = 0;
        Vector<Counter> ret = new Vector<Counter>();
        Enumeration e2 = cnt.elements();
        while (e2.hasMoreElements()) {
            Counter c = (Counter)e2.nextElement();
            ret.addElement(c);
            if ((current += c.getCounter()) < totalLimit) continue;
            break;
        }
        return ret;
    }

    public void printHtml(JspWriter jsp, double limit, int type, boolean clickable) {
        this.printHtml(jsp, null, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(PrintWriter out, double limit, int type, boolean clickable) {
        this.printHtml(out, null, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(JspWriter jsp, double[] limit, int type, boolean clickable) {
        this.printHtml(jsp, null, limit, type, clickable);
    }

    public void printHtml(PrintWriter out, double[] limit, int type, boolean clickable) {
        this.printHtml(out, null, limit, type, clickable);
    }

    public void printHtml(JspWriter jsp, Long classId, double limit, int type, boolean clickable) {
        this.printHtml(jsp, classId, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(PrintWriter out, Long classId, double limit, int type, boolean clickable) {
        this.printHtml(out, classId, new double[]{limit, limit, limit, limit}, type, clickable);
    }

    public void printHtml(JspWriter jsp, Long classId, double[] limit, int type, boolean clickable) {
        PrintWriter out = new PrintWriter((Writer)jsp);
        this.printHtml(out, classId, limit, type, clickable);
    }

    public void printHtml(PrintWriter out, Long classId, double[] limit, int type, boolean clickable) {
        if (type == TYPE_VARIABLE_BASED) {
            Vector vars = this.filter(this.iVariables.values(), limit[0]);
            if (classId != null) {
                CBSVariable var = (CBSVariable)this.iVariables.get(classId);
                vars.clear();
                if (var != null) {
                    vars.add(var);
                }
            }
            Enumeration e1 = vars.elements();
            while (e1.hasMoreElements()) {
                CBSVariable variable = (CBSVariable)e1.nextElement();
                String m1 = String.valueOf(variable.getId());
                if (classId == null) {
                    this.unassignedVariableMenuItem(out, m1, variable, clickable);
                }
                Vector vals = this.filter(variable.values(), limit[1]);
                int id = 0;
                Enumeration e2 = vals.elements();
                while (e2.hasMoreElements()) {
                    CBSValue value = (CBSValue)e2.nextElement();
                    String m2 = m1 + "." + id++;
                    this.unassignmentMenuItem(out, m2, value, clickable);
                    Vector constraints = this.filter(value.constraints(), limit[2]);
                    Enumeration e3 = constraints.elements();
                    while (e3.hasMoreElements()) {
                        CBSConstraint constraint = (CBSConstraint)e3.nextElement();
                        String m3 = m2 + constraint.getType() + "." + constraint.getId();
                        this.constraintMenuItem(out, m3, constraint, clickable);
                        Vector assignments = this.filter(constraint.assignments(), limit[3]);
                        Enumeration e4 = assignments.elements();
                        while (e4.hasMoreElements()) {
                            CBSAssignment assignment = (CBSAssignment)e4.nextElement();
                            this.assignmentLeafItem(out, assignment, clickable);
                        }
                        this.end_item(out);
                    }
                    this.end_item(out);
                }
                this.end_item(out);
            }
        } else if (type == TYPE_CONSTRAINT_BASED) {
            Hashtable<String, CBSConstraint> constraints = new Hashtable<String, CBSConstraint>();
            Enumeration e1 = this.iVariables.elements();
            while (e1.hasMoreElements()) {
                CBSVariable variable = (CBSVariable)e1.nextElement();
                if (classId != null && classId.longValue() != variable.getId()) continue;
                for (CBSValue value : variable.values()) {
                    for (CBSConstraint constraint : value.constraints()) {
                        CBSConstraint xConstraint = (CBSConstraint)constraints.get(constraint.getType() + "." + constraint.getId());
                        if (xConstraint == null) {
                            xConstraint = new CBSConstraint(constraint.getType(), constraint.getId(), constraint.getName(), constraint.getPref());
                            constraints.put(constraint.getType() + "." + constraint.getId(), xConstraint);
                        }
                        CBSVariable xVariable = null;
                        for (CBSVariable v : xConstraint.variables()) {
                            if (v.getId() != variable.getId()) continue;
                            xVariable = v;
                            break;
                        }
                        if (xVariable == null) {
                            xVariable = new CBSVariable(xConstraint, variable.getId(), variable.getName(), variable.getPref());
                            xConstraint.variables().add(xVariable);
                        }
                        CBSValue xValue = new CBSValue(xVariable, value.getPeriodId(), value.getPeriodName(), value.getPeriodPref(), value.getRoomIds(), value.getRoomNames(), value.getRoomPrefs());
                        xVariable.values().add(xValue);
                        for (CBSAssignment assignment : constraint.assignments()) {
                            xValue.assignments().add(assignment);
                            xValue.incCounter(assignment.getCounter());
                        }
                    }
                }
            }
            Vector consts = this.filter(constraints.values(), limit[0]);
            Enumeration e12 = consts.elements();
            while (e12.hasMoreElements()) {
                CBSConstraint constraint = (CBSConstraint)e12.nextElement();
                String m1 = constraint.getType() + "." + constraint.getId();
                this.constraintMenuItem(out, m1, constraint, clickable);
                Vector variables = this.filter(constraint.variables(), limit[1]);
                Collections.sort(variables);
                Enumeration e2 = variables.elements();
                while (e2.hasMoreElements()) {
                    CBSVariable variable = (CBSVariable)e2.nextElement();
                    String m2 = m1 + "." + variable.getId();
                    if (classId == null) {
                        this.unassignedVariableMenuItem(out, m2, variable, clickable);
                    }
                    Vector vals = this.filter(variable.values(), limit[2]);
                    int id = 0;
                    Enumeration e3 = vals.elements();
                    while (e3.hasMoreElements()) {
                        CBSValue value = (CBSValue)e3.nextElement();
                        String m3 = m2 + "." + id++;
                        this.unassignmentMenuItem(out, m3, value, clickable);
                        Vector assignments = this.filter(value.assignments(), limit[3]);
                        Enumeration e4 = assignments.elements();
                        while (e4.hasMoreElements()) {
                            CBSAssignment assignment = (CBSAssignment)e4.nextElement();
                            this.assignmentLeafItem(out, assignment, clickable);
                        }
                        this.end_item(out);
                    }
                    if (classId != null) continue;
                    this.end_item(out);
                }
                this.end_item(out);
            }
        }
        out.flush();
    }

    @Override
    public boolean saveToFile() {
        return true;
    }

    public static class CBSAssignment
    implements Counter,
    Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        CBSConstraint iConstraint;
        Long iExamId;
        String iExamName;
        String iExamPref;
        Long iPeriodId;
        String iPeriodName;
        int iPeriodPref;
        int iCounter = 0;
        Vector iRoomIds;
        Vector iRoomPrefs;
        Vector iRoomNames;

        CBSAssignment(CBSConstraint constraint, Long examId, String examName, String examPref, Long periodId, String periodName, int periodPref, Vector roomIds, Vector roomNames, Vector roomPrefs) {
            this.iExamId = examId;
            this.iExamName = examName;
            this.iExamPref = examPref;
            this.iPeriodId = periodId;
            this.iPeriodName = periodName;
            this.iPeriodPref = periodPref;
            this.iRoomIds = roomIds;
            this.iRoomNames = roomNames;
            this.iRoomPrefs = roomPrefs;
            this.iConstraint = constraint;
        }

        CBSAssignment(CBSConstraint constraint, Element element) {
            this.iConstraint = constraint;
            this.iExamId = Long.valueOf(element.attributeValue("exam"));
            this.iExamName = element.attributeValue("name");
            this.iExamPref = element.attributeValue("pref");
            this.iRoomIds = new Vector();
            this.iRoomNames = new Vector();
            this.iRoomPrefs = new Vector();
            Iterator i = element.elementIterator("room");
            while (i.hasNext()) {
                Element r = (Element)i.next();
                this.iRoomIds.addElement(Integer.valueOf(r.attributeValue("id")));
                this.iRoomNames.addElement(r.attributeValue("name"));
                this.iRoomPrefs.addElement(Integer.valueOf(r.attributeValue("pref")));
            }
            this.iPeriodId = Long.valueOf(element.attributeValue("period"));
            this.iPeriodName = element.attributeValue("periodName");
            this.iPeriodPref = Integer.parseInt(element.attributeValue("periodPref"));
            this.incCounter(Integer.parseInt(element.attributeValue("cnt")));
        }

        public Long getId() {
            return this.iExamId;
        }

        public CBSConstraint getConstraint() {
            return this.iConstraint;
        }

        public String getName() {
            return this.iExamName;
        }

        public String getPref() {
            return this.iExamPref;
        }

        public Long getPeriodId() {
            return this.iPeriodId;
        }

        public String getPeriodName() {
            return this.iPeriodName;
        }

        public int getPeriodPref() {
            return this.iPeriodPref;
        }

        public String toString() {
            return this.iExamName + " " + this.iPeriodName + " " + this.iRoomNames;
        }

        public Vector getRoomNames() {
            return this.iRoomNames;
        }

        public Vector getRoomIds() {
            return this.iRoomIds;
        }

        public Vector getRoomPrefs() {
            return this.iRoomPrefs;
        }

        public int hashCode() {
            return ExamConflictStatisticsInfo.combine(this.iExamId.hashCode(), ExamConflictStatisticsInfo.combine(this.iRoomIds.hashCode(), this.iPeriodId.hashCode()));
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iConstraint != null) {
                this.iConstraint.incCounter(value);
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSAssignment)) {
                return false;
            }
            CBSAssignment a = (CBSAssignment)o;
            return a.getId().equals(this.getId()) && a.getRoomIds().equals(this.getRoomIds()) && a.getPeriodId().equals(this.getPeriodId());
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof CBSAssignment)) {
                return -1;
            }
            int ret = -new Integer(this.iCounter).compareTo(new Integer(((CBSAssignment)o).getCounter()));
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("exam", String.valueOf(this.iExamId));
            element.addAttribute("name", this.iExamName);
            element.addAttribute("pref", this.iExamPref);
            for (int i = 0; i < this.iRoomIds.size(); ++i) {
                Element r = element.addElement("room");
                r.addAttribute("id", this.iRoomIds.elementAt(i).toString());
                r.addAttribute("name", this.iRoomNames.elementAt(i).toString());
                r.addAttribute("pref", this.iRoomPrefs.elementAt(i).toString());
            }
            element.addAttribute("period", String.valueOf(this.iPeriodId));
            element.addAttribute("periodName", this.iPeriodName);
            element.addAttribute("periodPref", String.valueOf(this.iPeriodPref));
            element.addAttribute("cnt", String.valueOf(this.iCounter));
        }
    }

    public static class CBSConstraint
    implements Counter,
    Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        CBSValue iValue;
        int iCounter = 0;
        long iId;
        String iName = null;
        int iType;
        HashSet iAssignments = new HashSet();
        HashSet iVariables = new HashSet();
        String iPref;

        CBSConstraint(int type, long id, String name, String pref) {
            this.iId = id;
            this.iType = type;
            this.iName = name;
            this.iPref = pref;
        }

        CBSConstraint(CBSValue value, int type, long id, String name, String pref) {
            this.iId = id;
            this.iType = type;
            this.iValue = value;
            this.iName = name;
            this.iPref = pref;
        }

        CBSConstraint(CBSValue value, Element element) {
            this.iValue = value;
            this.iId = Integer.parseInt(element.attributeValue("id"));
            this.iType = Integer.parseInt(element.attributeValue("type"));
            this.iName = element.attributeValue("name");
            this.iPref = element.attributeValue("pref");
            Iterator i = element.elementIterator("nogood");
            while (i.hasNext()) {
                this.iAssignments.add(new CBSAssignment(this, (Element)i.next()));
            }
        }

        public long getId() {
            return this.iId;
        }

        public int getType() {
            return this.iType;
        }

        public String getName() {
            return this.iName;
        }

        public CBSValue value() {
            return this.iValue;
        }

        public Set variables() {
            return this.iVariables;
        }

        public Set assignments() {
            return this.iAssignments;
        }

        public String getPref() {
            return this.iPref;
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iValue != null) {
                this.iValue.incCounter(value);
            }
        }

        public int hashCode() {
            return ExamConflictStatisticsInfo.combine((int)this.iId, this.iType);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSConstraint)) {
                return false;
            }
            CBSConstraint c = (CBSConstraint)o;
            return c.getId() == this.getId() && c.getType() == this.getType();
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof CBSConstraint)) {
                return -1;
            }
            int ret = -new Integer(this.iCounter).compareTo(new Integer(((CBSConstraint)o).getCounter()));
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("id", String.valueOf(this.iId));
            element.addAttribute("type", String.valueOf(this.iType));
            if (this.iName != null) {
                element.addAttribute("name", this.iName);
            }
            if (this.iPref != null) {
                element.addAttribute("pref", this.iPref);
            }
            Iterator i = this.iAssignments.iterator();
            while (i.hasNext()) {
                ((CBSAssignment)i.next()).save(element.addElement("nogood"));
            }
        }
    }

    public static class CBSValue
    implements Counter,
    Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        int iCounter = 0;
        Long iPeriodId;
        String iPeriodName;
        int iPeriodPref;
        Vector iRoomIds;
        String iInstructorName = null;
        Vector iRoomNames;
        Vector iRoomPrefs;
        CBSVariable iVariable = null;
        HashSet iConstraints = new HashSet();
        HashSet iAssignments = new HashSet();
        int iLength;

        CBSValue(CBSVariable var, Long periodId, String periodName, int periodPref, Vector roomIds, Vector roomNames, Vector roomPrefs) {
            this.iVariable = var;
            this.iRoomIds = roomIds;
            this.iRoomNames = roomNames;
            this.iRoomPrefs = roomPrefs;
            this.iPeriodId = periodId;
            this.iPeriodName = periodName;
            this.iPeriodPref = periodPref;
        }

        CBSValue(CBSVariable var, Element element) {
            this.iVariable = var;
            this.iPeriodId = Long.valueOf(element.attributeValue("period"));
            this.iPeriodName = element.attributeValue("name");
            this.iPeriodPref = Integer.parseInt(element.attributeValue("pref"));
            this.iRoomIds = new Vector();
            this.iRoomNames = new Vector();
            this.iRoomPrefs = new Vector();
            Iterator i = element.elementIterator("room");
            while (i.hasNext()) {
                Element r = (Element)i.next();
                this.iRoomIds.addElement(Integer.valueOf(r.attributeValue("id")));
                this.iRoomNames.addElement(r.attributeValue("name"));
                this.iRoomPrefs.addElement(Integer.valueOf(r.attributeValue("pref")));
            }
            i = element.elementIterator("cons");
            while (i.hasNext()) {
                this.iConstraints.add(new CBSConstraint(this, (Element)i.next()));
            }
        }

        public CBSVariable variable() {
            return this.iVariable;
        }

        public Long getPeriodId() {
            return this.iPeriodId;
        }

        public String getPeriodName() {
            return this.iPeriodName;
        }

        public int getPeriodPref() {
            return this.iPeriodPref;
        }

        public Vector getRoomNames() {
            return this.iRoomNames;
        }

        public Vector getRoomPrefs() {
            return this.iRoomPrefs;
        }

        public String toString() {
            return this.iPeriodName + " " + this.iRoomNames;
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iVariable != null) {
                this.iVariable.incCounter(value);
            }
        }

        public Vector getRoomIds() {
            return this.iRoomIds;
        }

        public Set constraints() {
            return this.iConstraints;
        }

        public Set assignments() {
            return this.iAssignments;
        }

        public int hashCode() {
            return ExamConflictStatisticsInfo.combine(this.iPeriodId.hashCode(), this.iRoomIds == null ? 0 : this.iRoomIds.hashCode());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSValue)) {
                return false;
            }
            CBSValue v = (CBSValue)o;
            return v.getRoomIds().equals(this.getRoomIds()) && v.getPeriodId().equals(this.getPeriodId());
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof CBSValue)) {
                return -1;
            }
            int ret = -new Integer(this.iCounter).compareTo(new Integer(((CBSValue)o).getCounter()));
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public void save(Element element) {
            element.addAttribute("period", String.valueOf(this.iPeriodId));
            element.addAttribute("pref", String.valueOf(this.iPeriodPref));
            element.addAttribute("name", this.iPeriodName);
            for (int i = 0; i < this.iRoomIds.size(); ++i) {
                Element r = element.addElement("room");
                r.addAttribute("id", this.iRoomIds.elementAt(i).toString());
                r.addAttribute("name", this.iRoomNames.elementAt(i).toString());
                r.addAttribute("pref", this.iRoomPrefs.elementAt(i).toString());
            }
            Iterator i = this.iConstraints.iterator();
            while (i.hasNext()) {
                ((CBSConstraint)i.next()).save(element.addElement("cons"));
            }
        }
    }

    public static class CBSVariable
    implements Counter,
    Comparable,
    Serializable {
        private static final long serialVersionUID = 1L;
        int iCounter = 0;
        long iExamId;
        String iName;
        HashSet iValues = new HashSet();
        CBSConstraint iConstraint = null;
        String iPref = null;

        CBSVariable(long examId, String name, String pref) {
            this.iExamId = examId;
            this.iName = name;
            this.iPref = pref;
        }

        CBSVariable(CBSConstraint constraint, long classId, String examId, String pref) {
            this.iConstraint = constraint;
            this.iExamId = classId;
            this.iName = examId;
            this.iPref = pref;
        }

        CBSVariable(Element element) {
            this.iExamId = Long.parseLong(element.attributeValue("exam"));
            this.iName = element.attributeValue("name");
            this.iPref = element.attributeValue("pref");
            Iterator i = element.elementIterator("val");
            while (i.hasNext()) {
                this.iValues.add(new CBSValue(this, (Element)i.next()));
            }
        }

        public long getId() {
            return this.iExamId;
        }

        @Override
        public int getCounter() {
            return this.iCounter;
        }

        public String getName() {
            return this.iName;
        }

        public String getPref() {
            return this.iPref;
        }

        @Override
        public void incCounter(int value) {
            this.iCounter += value;
            if (this.iConstraint != null) {
                this.iConstraint.incCounter(value);
            }
        }

        public Set values() {
            return this.iValues;
        }

        public int hashCode() {
            return new Long(this.iExamId).hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CBSVariable)) {
                return false;
            }
            return ((CBSVariable)o).getId() == this.getId();
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof CBSVariable)) {
                return -1;
            }
            int ret = -new Integer(this.iCounter).compareTo(new Integer(((CBSVariable)o).getCounter()));
            if (ret != 0) {
                return ret;
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.iName;
        }

        public void save(Element element) {
            element.addAttribute("exam", String.valueOf(this.iExamId));
            element.addAttribute("name", this.iName);
            if (this.iPref != null) {
                element.addAttribute("pref", this.iPref);
            }
            Iterator i = this.iValues.iterator();
            while (i.hasNext()) {
                ((CBSValue)i.next()).save(element.addElement("val"));
            }
        }
    }

    public static interface Counter {
        public int getCounter();

        public void incCounter(int var1);
    }
}

