/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.exam.model.PredefinedExamRoomSharing;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.CacheMode;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.exam.ExamModel;
import org.unitime.timetable.solver.exam.ExamResourceUnavailability;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.RoomAvailability;

public class ExamDatabaseLoader
extends ProblemLoader<Exam, ExamPlacement, ExamModel> {
    private static Log sLog = LogFactory.getLog(ExamDatabaseLoader.class);
    private Long iSessionId;
    private Long iExamTypeId;
    private boolean iLoadSolution;
    private String iInstructorFormat;
    private Progress iProgress = null;
    private Hashtable<Long, org.cpsolver.exam.model.ExamPeriod> iPeriods = new Hashtable();
    private Hashtable<Long, ExamRoom> iRooms = new Hashtable();
    private Hashtable<Long, ExamRoom> iPermId2Room = new Hashtable();
    private Hashtable<Long, ExamOwner> iOwners = new Hashtable();
    private Hashtable iExams = new Hashtable();
    private Hashtable iInstructors = new Hashtable();
    private Hashtable iStudents = new Hashtable();
    private Set iAllRooms = null;
    private Set<org.cpsolver.exam.model.ExamPeriod> iProhibitedPeriods = new HashSet<org.cpsolver.exam.model.ExamPeriod>();
    private PredefinedExamRoomSharing iSharing = null;
    private boolean iRoomAvailabilityTimeStampIsSet = false;

    public ExamDatabaseLoader(ExamModel model, Assignment<Exam, ExamPlacement> assignment) {
        super((Model)model, assignment);
        this.iProgress = Progress.getInstance((Object)((Object)model));
        this.iSessionId = model.getProperties().getPropertyLong("General.SessionId", (Long)null);
        this.iExamTypeId = model.getProperties().getPropertyLong("Exam.Type", null);
        this.iLoadSolution = model.getProperties().getPropertyBoolean("General.LoadSolution", true);
        this.iInstructorFormat = ((ExamModel)this.getModel()).getProperties().getProperty("General.InstructorFormat", DepartmentalInstructor.sNameFormatLastFist);
    }

    private String getExamLabel(org.unitime.timetable.model.Exam exam) {
        return "<A href='examDetail.do?examId=" + exam.getUniqueId() + "'>" + exam.getLabel() + "</A>";
    }

    private String getExamLabel(Exam exam) {
        return "<A href='examDetail.do?examId=" + exam.getId() + "'>" + exam.getName() + "</A>";
    }

    public void load() throws Exception {
        ApplicationProperties.setSessionId(this.iSessionId);
        this.iProgress.setStatus("Loading input data ...");
        org.hibernate.Session hibSession = new ExamDAO().getSession();
        hibSession.setCacheMode(CacheMode.IGNORE);
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            TravelTime.populateTravelTimes(((ExamModel)this.getModel()).getDistanceMetric(), this.iSessionId, hibSession);
            this.loadPeriods();
            this.loadRooms();
            RoomAvailabilityInterface availability = null;
            availability = SolverServerImplementation.getInstance() != null ? SolverServerImplementation.getInstance().getRoomAvailability() : RoomAvailability.getInstance();
            if (availability != null) {
                this.loadRoomAvailability(availability);
            }
            this.loadExams();
            this.loadStudents();
            this.loadDistributions();
            ExamType type = (ExamType)ExamTypeDAO.getInstance().get(this.iExamTypeId, hibSession);
            if (ApplicationProperty.ExaminationConsiderEventConflicts.isTrue(type.getReference())) {
                this.loadAvailabilitiesFromEvents();
            }
            if (ApplicationProperty.ExaminationCreateSameRoomConstraints.isTrue(type.getReference())) {
                this.makeupSameRoomConstraints();
            }
            ((ExamModel)this.getModel()).init();
            ((ExamModel)this.getModel()).clearAssignmentContexts(this.getAssignment());
            this.checkConsistency();
            this.assignInitial();
            tx.commit();
        }
        catch (Exception e) {
            this.iProgress.fatal("Unable to load examination problem, reason: " + e.getMessage(), (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (hibSession != null && hibSession.isOpen()) {
                hibSession.close();
            }
        }
    }

    public int pref2weight(String pref) {
        if (pref == null) {
            return 0;
        }
        if (PreferenceLevel.sStronglyPreferred.equals(pref)) {
            return -4;
        }
        if (PreferenceLevel.sPreferred.equals(pref)) {
            return -1;
        }
        if (PreferenceLevel.sDiscouraged.equals(pref)) {
            return 1;
        }
        if (PreferenceLevel.sStronglyDiscouraged.equals(pref)) {
            return 4;
        }
        return 0;
    }

    protected void loadPeriods() {
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(this.iSessionId, this.iExamTypeId);
        this.iProgress.setPhase("Loading periods...", (long)periods.size());
        Iterator i = periods.iterator();
        while (i.hasNext()) {
            this.iProgress.incProgress();
            ExamPeriod period = (ExamPeriod)i.next();
            String pref = period.getPrefLevel().getPrefProlog();
            org.cpsolver.exam.model.ExamPeriod p = ((ExamModel)this.getModel()).addPeriod(period.getUniqueId(), period.getStartDateLabel(), period.getStartTimeLabel() + " - " + period.getEndTimeLabel(), Constants.SLOT_LENGTH_MIN * period.getLength(), this.pref2weight(pref));
            p.setStartTime(Integer.valueOf(Constants.SLOT_LENGTH_MIN * period.getStartSlot() + Constants.FIRST_SLOT_TIME_MIN));
            if (PreferenceLevel.sProhibited.equals(pref)) {
                this.iProhibitedPeriods.add(p);
            }
            this.iPeriods.put(period.getUniqueId(), p);
        }
    }

    protected void loadRooms() {
        this.iAllRooms = Location.findAllExamLocations(this.iSessionId, this.iExamTypeId);
        this.iProgress.setPhase("Loading rooms...", (long)this.iAllRooms.size());
        Iterator i = this.iAllRooms.iterator();
        while (i.hasNext()) {
            this.iProgress.incProgress();
            Location location = (Location)i.next();
            ExamRoom room = new ExamRoom((org.cpsolver.exam.model.ExamModel)this.getModel(), location.getUniqueId().longValue(), location.getLabel(), location.getCapacity().intValue(), location.getExamCapacity().intValue(), location.getCoordinateX(), location.getCoordinateY());
            if (location.isIgnoreRoomCheck().booleanValue()) {
                room.setHard(false);
            }
            ((ExamModel)this.getModel()).addConstraint((Constraint)room);
            ((ExamModel)this.getModel()).getRooms().add(room);
            this.iRooms.put(room.getId(), room);
            if (location.getPermanentId() != null) {
                this.iPermId2Room.put(location.getPermanentId(), room);
            }
            for (Map.Entry<ExamPeriod, PreferenceLevel> entry : location.getExamPreferences(this.iExamTypeId).entrySet()) {
                org.cpsolver.exam.model.ExamPeriod period = this.iPeriods.get(entry.getKey().getUniqueId());
                String pref = entry.getValue().getPrefProlog();
                if (period == null) continue;
                if (PreferenceLevel.sProhibited.equals(pref)) {
                    room.setAvailable(period.getIndex(), false);
                    continue;
                }
                room.setPenalty(period.getIndex(), this.pref2weight(pref));
            }
        }
    }

    protected void loadExams() {
        List exams = org.unitime.timetable.model.Exam.findAll(this.iSessionId, this.iExamTypeId);
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(this.iExamTypeId);
        boolean considerLimit = ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue(type.getReference(), type.getType() != 0);
        this.iProgress.setPhase("Loading exams...", (long)exams.size());
        Iterator i = exams.iterator();
        while (i.hasNext()) {
            ExamPeriodPlacement periodPlacement;
            this.iProgress.incProgress();
            org.unitime.timetable.model.Exam exam = (org.unitime.timetable.model.Exam)i.next();
            ArrayList<ExamPeriodPlacement> periodPlacements = new ArrayList<ExamPeriodPlacement>();
            boolean hasReqPeriod = false;
            Set periodPrefs = exam.getPreferences(ExamPeriodPref.class);
            for (org.cpsolver.exam.model.ExamPeriod period : ((ExamModel)this.getModel()).getPeriods()) {
                if (this.iProhibitedPeriods.contains(period) || period.getLength() < exam.getLength()) continue;
                String pref = null;
                for (ExamPeriodPref periodPref : periodPrefs) {
                    if (!period.getId().equals(periodPref.getExamPeriod().getUniqueId())) continue;
                    pref = periodPref.getPrefLevel().getPrefProlog();
                    break;
                }
                if (type.getType() == 1 && pref == null || PreferenceLevel.sProhibited.equals(pref)) continue;
                if (PreferenceLevel.sRequired.equals(pref)) {
                    if (!hasReqPeriod) {
                        periodPlacements.clear();
                    }
                    hasReqPeriod = true;
                    periodPlacements.add(new ExamPeriodPlacement(period, 0));
                    continue;
                }
                if (hasReqPeriod) continue;
                periodPlacements.add(new ExamPeriodPlacement(period, this.pref2weight(pref)));
            }
            if (periodPlacements.isEmpty()) {
                this.iProgress.warn("Exam " + this.getExamLabel(exam) + " has no period available, it is not loaded.");
                continue;
            }
            Exam x = new Exam(exam.getUniqueId().longValue(), exam.getLabel(), exam.getLength().intValue(), exam.getSeatingType() == 1, exam.getMaxNbrRooms().intValue(), 0, periodPlacements, this.findRooms(exam));
            if (type.getType() == 0) {
                if (exam.getAvgPeriod() != null) {
                    x.setAveragePeriod(exam.getAvgPeriod().intValue());
                } else {
                    x.setAveragePeriod(((ExamModel)this.getModel()).getPeriods().size() / 2);
                }
            }
            x.setModel(this.getModel());
            int minSize = 0;
            for (ExamOwner owner : new TreeSet<ExamOwner>(exam.getOwners())) {
                org.cpsolver.exam.model.ExamOwner cs = new org.cpsolver.exam.model.ExamOwner(x, owner.getUniqueId().longValue(), owner.getLabel());
                this.iOwners.put(owner.getUniqueId(), owner);
                minSize += owner.getLimit();
                x.getOwners().add(cs);
            }
            x.setSizeOverride(exam.getExamSize());
            x.setPrintOffset(Integer.valueOf(exam.examOffset()));
            if (considerLimit && minSize > 0) {
                x.setMinSize(minSize);
            }
            if (x.getMaxRooms() > 0) {
                if (x.getRoomPlacements().isEmpty()) {
                    this.iProgress.warn("Exam " + this.getExamLabel(exam) + " has no room available, it is not loaded.");
                    continue;
                }
                boolean hasAssignment = false;
                Iterator ep = x.getPeriodPlacements().iterator();
                while (!hasAssignment && ep.hasNext()) {
                    ExamPeriodPlacement period = (ExamPeriodPlacement)ep.next();
                    if (x.findRoomsRandom(this.getAssignment(), period) == null) continue;
                    hasAssignment = true;
                }
                if (!hasAssignment) {
                    this.iProgress.warn("Exam " + this.getExamLabel(exam) + " has no available assignment, it is not loaded.");
                    continue;
                }
            }
            this.iExams.put(exam.getUniqueId(), x);
            ((ExamModel)this.getModel()).addVariable((Variable)x);
            Iterator<DepartmentalInstructor> j = exam.getInstructors().iterator();
            while (j.hasNext()) {
                this.loadInstructor(j.next()).addVariable((Variable)x);
            }
            if (exam.getAssignedPeriod() == null) continue;
            boolean fail = false;
            org.cpsolver.exam.model.ExamPeriod period = this.iPeriods.get(exam.getAssignedPeriod().getUniqueId());
            if (period == null) {
                this.iProgress.warn("Unable assign exam " + this.getExamLabel(exam) + " to period " + exam.getAssignedPeriod().getName() + ": period not allowed.");
                fail = true;
            }
            ExamPeriodPlacement examPeriodPlacement = periodPlacement = period == null ? null : x.getPeriodPlacement(period);
            if (!fail && periodPlacement == null) {
                this.iProgress.warn("Unable to assign exam " + this.getExamLabel(exam) + " to period " + exam.getAssignedPeriod().getName() + ": period prohibited.");
                fail = true;
            }
            HashSet<ExamRoomPlacement> roomPlacements = new HashSet<ExamRoomPlacement>();
            if (!fail && x.getMaxRooms() > 0) {
                for (Location location : exam.getAssignedRooms()) {
                    ExamRoom room = this.iRooms.get(location.getUniqueId());
                    if (room == null) {
                        this.iProgress.warn("Unable to assign exam " + this.getExamLabel(exam) + " to room " + location.getLabel() + ": not an examination room.");
                        fail = true;
                        break;
                    }
                    ExamRoomPlacement roomPlacement = x.getRoomPlacement(room);
                    if (roomPlacement == null) {
                        this.iProgress.warn("Unable to assign exam " + this.getExamLabel(exam) + " to room " + location.getLabel() + ": room not valid for this exam.");
                        fail = true;
                        break;
                    }
                    if (!roomPlacement.isAvailable(period)) {
                        this.iProgress.warn("Unable to assign exam " + this.getExamLabel(exam) + " to room " + location.getLabel() + ": room not available at " + period + ".");
                        fail = true;
                        break;
                    }
                    roomPlacements.add(roomPlacement);
                }
            }
            if (!fail && roomPlacements.size() > x.getMaxRooms()) {
                this.iProgress.warn("Unable to assign exam " + this.getExamLabel(exam) + " to room" + (roomPlacements.size() > 1 ? "s" : "") + " " + roomPlacements + ": number of assigned rooms exceeds the current limit (" + roomPlacements.size() + ">" + x.getMaxRooms() + ").");
                fail = true;
            }
            if (fail) continue;
            x.setInitialAssignment((Value)new ExamPlacement(x, periodPlacement, roomPlacements));
        }
    }

    protected ExamInstructor loadInstructor(DepartmentalInstructor instructor) {
        if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().trim().length() > 0) {
            ExamInstructor i = (ExamInstructor)this.iInstructors.get(instructor.getExternalUniqueId());
            if (i == null) {
                i = new ExamInstructor((org.cpsolver.exam.model.ExamModel)this.getModel(), instructor.getUniqueId().longValue(), instructor.getName(this.iInstructorFormat));
                this.iInstructors.put(instructor.getExternalUniqueId(), i);
                ((ExamModel)this.getModel()).addConstraint((Constraint)i);
                ((ExamModel)this.getModel()).getInstructors().add(i);
            }
            return i;
        }
        ExamInstructor i = (ExamInstructor)this.iInstructors.get(instructor.getUniqueId());
        if (i == null) {
            i = new ExamInstructor((org.cpsolver.exam.model.ExamModel)this.getModel(), instructor.getUniqueId().longValue(), instructor.getName(this.iInstructorFormat));
            this.iInstructors.put(instructor.getUniqueId(), i);
            ((ExamModel)this.getModel()).addConstraint((Constraint)i);
            ((ExamModel)this.getModel()).getInstructors().add(i);
        }
        return i;
    }

    protected ExamInstructor getInstructor(DepartmentalInstructor instructor) {
        ExamInstructor i;
        if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().trim().length() > 0 && (i = (ExamInstructor)this.iInstructors.get(instructor.getExternalUniqueId())) != null) {
            return i;
        }
        return (ExamInstructor)this.iInstructors.get(instructor.getUniqueId());
    }

    protected List<ExamRoomPlacement> findRooms(org.unitime.timetable.model.Exam exam) {
        ArrayList<ExamRoomPlacement> rooms = new ArrayList<ExamRoomPlacement>();
        boolean reqRoom = false;
        boolean reqBldg = false;
        boolean reqGroup = false;
        Set groupPrefs = exam.getPreferences(RoomGroupPref.class);
        Set roomPrefs = exam.getPreferences(RoomPref.class);
        Set bldgPrefs = exam.getPreferences(BuildingPref.class);
        Set featurePrefs = exam.getPreferences(RoomFeaturePref.class);
        for (Location room : this.iAllRooms) {
            ExamRoom roomEx = this.iRooms.get(room.getUniqueId());
            if (roomEx == null) continue;
            boolean add = true;
            SumPreferenceCombination pref = new SumPreferenceCombination();
            PreferenceCombination groupPref = PreferenceCombination.getDefault();
            for (RoomGroupPref p : groupPrefs) {
                if (!p.getRoomGroup().getRooms().contains(room)) continue;
                groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
            }
            if (groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited)) {
                add = false;
            }
            if (reqGroup && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                add = false;
            }
            if (!reqGroup && groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                reqGroup = true;
                rooms.clear();
            }
            if (!groupPref.getPreferenceProlog().equals(PreferenceLevel.sProhibited) && !groupPref.getPreferenceProlog().equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(groupPref.getPreferenceProlog());
            }
            String roomPref = null;
            for (RoomPref p : roomPrefs) {
                if (!room.equals(p.getRoom())) continue;
                roomPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (roomPref != null && roomPref.equals(PreferenceLevel.sProhibited)) {
                add = false;
            }
            if (reqRoom && (roomPref == null || !roomPref.equals(PreferenceLevel.sRequired))) {
                add = false;
            }
            if (!reqRoom && roomPref != null && roomPref.equals(PreferenceLevel.sRequired)) {
                reqRoom = true;
                rooms.clear();
            }
            if (roomPref != null && !roomPref.equals(PreferenceLevel.sProhibited) && !roomPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(roomPref);
            }
            Building bldg = room instanceof Room ? ((Room)room).getBuilding() : null;
            String bldgPref = null;
            for (BuildingPref p : bldgPrefs) {
                if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                bldgPref = p.getPrefLevel().getPrefProlog();
                break;
            }
            if (bldgPref != null && bldgPref.equals(PreferenceLevel.sProhibited)) {
                add = false;
            }
            if (reqBldg && (bldgPref == null || !bldgPref.equals(PreferenceLevel.sRequired))) {
                add = false;
            }
            if (!reqBldg && bldgPref != null && bldgPref.equals(PreferenceLevel.sRequired)) {
                reqBldg = true;
                rooms.clear();
            }
            if (bldgPref != null && !bldgPref.equals(PreferenceLevel.sProhibited) && !bldgPref.equals(PreferenceLevel.sRequired)) {
                pref.addPreferenceProlog(bldgPref);
            }
            boolean acceptableFeatures = true;
            MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
            for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                RoomFeature feature = roomFeaturePref.getRoomFeature();
                String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                boolean hasFeature = feature.getRooms().contains(room);
                if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                    acceptableFeatures = false;
                }
                if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                    acceptableFeatures = false;
                }
                if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                featurePref.addPreferenceProlog(p);
            }
            pref.addPreferenceInt(featurePref.getPreferenceInt());
            if (!acceptableFeatures) {
                add = false;
            }
            int prefInt = pref.getPreferenceInt();
            if (!add) continue;
            boolean hasStrongDisc = false;
            boolean allStrongDisc = true;
            for (org.cpsolver.exam.model.ExamPeriod period : ((ExamModel)this.getModel()).getPeriods()) {
                if (!roomEx.isAvailable(period)) continue;
                if (roomEx.getPenalty(period) == 4) {
                    hasStrongDisc = true;
                    continue;
                }
                allStrongDisc = false;
            }
            if (hasStrongDisc && reqGroup && roomPref == null) {
                roomPref = PreferenceLevel.sNeutral;
            }
            if (allStrongDisc && roomPref == null) continue;
            rooms.add(new ExamRoomPlacement(roomEx, prefInt, hasStrongDisc && roomPref == null ? 3 : 100));
        }
        return rooms;
    }

    protected void loadStudents() {
        this.loadStudents(new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId").setLong("sessionId", this.iSessionId.longValue()).setLong("examTypeId", this.iExamTypeId.longValue()).list(), "class");
        this.loadStudents(new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId").setLong("sessionId", this.iSessionId.longValue()).setLong("examTypeId", this.iExamTypeId.longValue()).list(), "config");
        this.loadStudents(new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId").setLong("sessionId", this.iSessionId.longValue()).setLong("examTypeId", this.iExamTypeId.longValue()).list(), "course");
        this.loadStudents(new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId").setLong("sessionId", this.iSessionId.longValue()).setLong("examTypeId", this.iExamTypeId.longValue()).list(), "offering");
    }

    protected void loadStudents(Collection enrl, String phase) {
        HashSet<Long> notLoaded = new HashSet<Long>();
        this.iProgress.setPhase("Loading students (" + phase + ")...", (long)enrl.size());
        Iterator i = enrl.iterator();
        while (i.hasNext()) {
            Exam exam;
            this.iProgress.incProgress();
            Object[] o = (Object[])i.next();
            Long examId = (Long)o[0];
            Long ownerId = (Long)o[1];
            Long studentId = (Long)o[2];
            ExamStudent student = (ExamStudent)this.iStudents.get(studentId);
            if (student == null) {
                student = new ExamStudent((org.cpsolver.exam.model.ExamModel)this.getModel(), studentId.longValue());
                ((ExamModel)this.getModel()).addConstraint((Constraint)student);
                ((ExamModel)this.getModel()).getStudents().add(student);
                this.iStudents.put(studentId, student);
            }
            if ((exam = (Exam)this.iExams.get(examId)) == null) {
                if (!notLoaded.add(examId)) continue;
                this.iProgress.info("Exam " + this.getExamLabel((org.unitime.timetable.model.Exam)new ExamDAO().get(examId)) + " not loaded.");
                continue;
            }
            if (!student.variables().contains(exam)) {
                student.addVariable((Variable)exam);
            }
            for (org.cpsolver.exam.model.ExamOwner owner : exam.getOwners()) {
                if (owner.getId() != ownerId.longValue()) continue;
                owner.getStudents().add(student);
                student.getOwners().add(owner);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAvailabilitiesFromEvents() {
        Object student;
        ExamResourceUnavailability unavailability;
        ExamRoom room;
        ExamInstructor instructor;
        HashSet<Long> instructorIds;
        HashSet<Long> studentIds;
        Object instructorsThisEvent;
        Set<ExamStudent> studentsThisEvent;
        Meeting meeting;
        org.cpsolver.exam.model.ExamPeriod period;
        Long eventId;
        Object[] o;
        List overlappingClassEvents = new EventDAO().getSession().createQuery("select distinct e.uniqueId, p.uniqueId, m from ClassEvent e inner join e.meetings m, ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and (exists elements(e.clazz.studentEnrollments) or exists elements(e.clazz.classInstructors))").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("examTypeId", this.iExamTypeId.longValue()).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list();
        List overlappingCourseEvents = new EventDAO().getSession().createQuery("select distinct e.uniqueId, p.uniqueId, m from CourseEvent e inner join e.meetings m, ExamPeriod p where e.reqAttendance=true and m.approvalStatus = 1 and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeCourse.intValue().intValue()).setLong("examTypeId", this.iExamTypeId.longValue()).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list();
        List overlappingExamEvents = new EventDAO().getSession().createQuery("select distinct e.uniqueId, p.uniqueId, m from ExamEvent e inner join e.meetings m, ExamPeriod p where m.approvalStatus = 1 and e.exam.examType.uniqueId != :examTypeId and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeCourse.intValue().intValue()).setLong("examTypeId", this.iExamTypeId.longValue()).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list();
        this.iProgress.setPhase("Loading availabilities...", (long)(overlappingClassEvents.size() + overlappingCourseEvents.size() + overlappingExamEvents.size()));
        Hashtable<Long, Set<ExamStudent>> students = new Hashtable<Long, Set<ExamStudent>>();
        for (Object[] o2 : new EventDAO().getSession().createQuery("select e.uniqueId, s.student.uniqueId from ClassEvent e inner join e.meetings m inner join e.clazz.studentEnrollments s, ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("examTypeId", this.iExamTypeId.longValue()).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list()) {
            Long eventId2 = (Long)o2[0];
            Long studentId = (Long)o2[1];
            ExamStudent student2 = (ExamStudent)this.iStudents.get(studentId);
            if (student2 == null) continue;
            HashSet<ExamStudent> studentsThisEvent2 = (HashSet<ExamStudent>)students.get(eventId2);
            if (studentsThisEvent2 == null) {
                studentsThisEvent2 = new HashSet<ExamStudent>();
                students.put(eventId2, studentsThisEvent2);
            }
            studentsThisEvent2.add(student2);
        }
        Hashtable<Long, Object> instructors = new Hashtable<Long, Object>();
        for (Object[] o3 : new EventDAO().getSession().createQuery("select e.uniqueId, i.instructor from ClassEvent e inner join e.meetings m inner join e.clazz.classInstructors i, ExamPeriod p where p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId and m.approvalStatus = 1 and i.lead=true and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("examTypeId", this.iExamTypeId.longValue()).setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list()) {
            Long eventId3 = (Long)o3[0];
            ExamInstructor instructor2 = this.getInstructor((DepartmentalInstructor)o3[1]);
            if (instructor2 == null) continue;
            HashSet<ExamInstructor> instructorsThisEvent2 = (HashSet<ExamInstructor>)instructors.get(eventId3);
            if (instructorsThisEvent2 == null) {
                instructorsThisEvent2 = new HashSet<ExamInstructor>();
                instructors.put(eventId3, instructorsThisEvent2);
            }
            instructorsThisEvent2.add(instructor2);
        }
        Hashtable unavailabilities = new Hashtable();
        Iterator i = overlappingClassEvents.iterator();
        while (i.hasNext()) {
            void var16_21;
            this.iProgress.incProgress();
            o = (Object[])i.next();
            eventId = (Long)o[0];
            period = this.iPeriods.get((Long)o[1]);
            meeting = (Meeting)o[2];
            if (period == null) continue;
            studentsThisEvent = (HashSet)students.get(eventId);
            instructorsThisEvent = (Set)instructors.get(eventId);
            if (!(studentsThisEvent != null && !studentsThisEvent.isEmpty() || instructorsThisEvent != null && !instructorsThisEvent.isEmpty())) continue;
            studentIds = new HashSet<Long>();
            instructorIds = new HashSet<Long>();
            if (studentsThisEvent != null) {
                for (ExamStudent student3 : studentsThisEvent) {
                    student3.setAvailable(period.getIndex(), false);
                    studentIds.add(student3.getId());
                }
            }
            if (instructorsThisEvent != null) {
                Iterator iterator = instructorsThisEvent.iterator();
                while (iterator.hasNext()) {
                    instructor = (ExamInstructor)iterator.next();
                    instructor.setAvailable(period.getIndex(), false);
                    instructorIds.add(instructor.getId());
                }
            }
            if (studentIds.isEmpty() && instructorIds.isEmpty()) continue;
            Hashtable hashtable = (Hashtable)unavailabilities.get(eventId);
            if (hashtable == null) {
                Hashtable hashtable2 = new Hashtable();
                unavailabilities.put(eventId, hashtable2);
            }
            room = meeting.getLocationPermanentId() == null ? null : this.iPermId2Room.get(meeting.getLocationPermanentId());
            unavailability = (ExamResourceUnavailability)var16_21.get(period);
            if (unavailability != null) {
                if (room == null) continue;
                unavailability.addRoom(room.getName());
                continue;
            }
            unavailability = new ExamResourceUnavailability(period, meeting.getEvent().getUniqueId(), "class", meeting.getEvent().getEventName(), meeting.dateStr(), meeting.startTime() + " - " + meeting.stopTime(), room == null ? "" : room.getName(), studentsThisEvent == null ? 0 : studentsThisEvent.size(), studentIds, instructorIds);
            this.iProgress.debug("Class event " + meeting.getEvent().getEventName() + " " + meeting.getTimeLabel() + " overlaps with period " + period + " (" + studentIds.size() + " students, " + instructorIds.size() + " instructors)");
            var16_21.put(period, unavailability);
            ((ExamModel)this.getModel()).addUnavailability(unavailability);
        }
        i = overlappingCourseEvents.iterator();
        while (i.hasNext()) {
            void var16_27;
            this.iProgress.incProgress();
            o = (Object[])i.next();
            eventId = (Long)o[0];
            period = this.iPeriods.get((Long)o[1]);
            meeting = (Meeting)o[2];
            if (period == null) continue;
            studentsThisEvent = (Set)students.get(eventId);
            if (studentsThisEvent == null) {
                studentsThisEvent = new HashSet();
                for (Long studentId : meeting.getEvent().getStudentIds()) {
                    student = (ExamStudent)this.iStudents.get(studentId);
                    if (student == null) continue;
                    studentsThisEvent.add((ExamStudent)student);
                }
                students.put(eventId, studentsThisEvent);
            }
            instructorsThisEvent = (Set)instructors.get(eventId);
            if (!(studentsThisEvent != null && !studentsThisEvent.isEmpty() || instructorsThisEvent != null && !instructorsThisEvent.isEmpty())) continue;
            studentIds = new HashSet();
            instructorIds = new HashSet();
            if (studentsThisEvent != null) {
                for (ExamStudent student2 : studentsThisEvent) {
                    student2.setAvailable(period.getIndex(), false);
                    studentIds.add(student2.getId());
                }
            }
            if (instructorsThisEvent != null) {
                Iterator iterator = instructorsThisEvent.iterator();
                while (iterator.hasNext()) {
                    instructor = (ExamInstructor)iterator.next();
                    instructor.setAvailable(period.getIndex(), false);
                    instructorIds.add(instructor.getId());
                }
            }
            if (studentIds.isEmpty() && instructorIds.isEmpty()) continue;
            Hashtable hashtable = (Hashtable)unavailabilities.get(eventId);
            if (hashtable == null) {
                Hashtable hashtable3 = new Hashtable();
                unavailabilities.put(eventId, hashtable3);
            }
            room = meeting.getLocationPermanentId() == null ? null : this.iPermId2Room.get(meeting.getLocationPermanentId());
            unavailability = (ExamResourceUnavailability)var16_27.get(period);
            if (unavailability != null) {
                if (room == null) continue;
                unavailability.addRoom(room.getName());
                continue;
            }
            unavailability = new ExamResourceUnavailability(period, meeting.getEvent().getUniqueId(), "event", meeting.getEvent().getEventName(), meeting.dateStr(), meeting.startTime() + " - " + meeting.stopTime(), room == null ? "" : room.getName(), studentsThisEvent == null ? 0 : studentsThisEvent.size(), studentIds, instructorIds);
            this.iProgress.debug("Course-related event " + meeting.getEvent().getEventName() + "/" + meeting.getTimeLabel() + " overlaps with period " + period + " (" + studentIds.size() + " students, " + instructorIds.size() + " instructors)");
            var16_27.put(period, unavailability);
            ((ExamModel)this.getModel()).addUnavailability(unavailability);
        }
        i = overlappingExamEvents.iterator();
        while (i.hasNext()) {
            void var16_34;
            this.iProgress.incProgress();
            o = (Object[])i.next();
            eventId = (Long)o[0];
            period = this.iPeriods.get((Long)o[1]);
            meeting = (Meeting)o[2];
            if (period == null) continue;
            studentsThisEvent = (Set)students.get(eventId);
            if (studentsThisEvent == null) {
                studentsThisEvent = new HashSet();
                instructorsThisEvent = meeting.getEvent().getStudentIds().iterator();
                while (instructorsThisEvent.hasNext()) {
                    Long studentId;
                    studentId = (Long)instructorsThisEvent.next();
                    student = (ExamStudent)this.iStudents.get(studentId);
                    if (student == null) continue;
                    studentsThisEvent.add((ExamStudent)student);
                }
                students.put(eventId, studentsThisEvent);
            }
            if ((instructorsThisEvent = (Set)instructors.get(eventId)) == null) {
                instructorsThisEvent = new HashSet();
                ExamEvent event = (ExamEvent)ExamEventDAO.getInstance().get(meeting.getEvent().getUniqueId());
                for (DepartmentalInstructor departmentalInstructor : event.getInstructors()) {
                    instructor = this.getInstructor(departmentalInstructor);
                    if (instructor == null) continue;
                    instructorsThisEvent.add(instructor);
                }
                instructors.put(eventId, instructorsThisEvent);
            }
            if (!(studentsThisEvent != null && !studentsThisEvent.isEmpty() || instructorsThisEvent != null && !instructorsThisEvent.isEmpty())) continue;
            studentIds = new HashSet();
            instructorIds = new HashSet();
            if (studentsThisEvent != null) {
                for (ExamStudent student2 : studentsThisEvent) {
                    student2.setAvailable(period.getIndex(), false);
                    studentIds.add(student2.getId());
                }
            }
            if (instructorsThisEvent != null) {
                Iterator iterator = instructorsThisEvent.iterator();
                while (iterator.hasNext()) {
                    instructor = (ExamInstructor)iterator.next();
                    instructor.setAvailable(period.getIndex(), false);
                    instructorIds.add(instructor.getId());
                }
            }
            if (studentIds.isEmpty() && instructorIds.isEmpty()) continue;
            Hashtable hashtable = (Hashtable)unavailabilities.get(eventId);
            if (hashtable == null) {
                Hashtable hashtable4 = new Hashtable();
                unavailabilities.put(eventId, hashtable4);
            }
            room = meeting.getLocationPermanentId() == null ? null : this.iPermId2Room.get(meeting.getLocationPermanentId());
            unavailability = (ExamResourceUnavailability)var16_34.get(period);
            if (unavailability != null) {
                if (room == null) continue;
                unavailability.addRoom(room.getName());
                continue;
            }
            unavailability = new ExamResourceUnavailability(period, meeting.getEvent().getUniqueId(), "event", meeting.getEvent().getEventName(), meeting.dateStr(), meeting.startTime() + " - " + meeting.stopTime(), room == null ? "" : room.getName(), studentsThisEvent == null ? 0 : studentsThisEvent.size(), studentIds, instructorIds);
            this.iProgress.debug("Examination event " + meeting.getEvent().getEventName() + "/" + meeting.getTimeLabel() + " overlaps with period " + period + " (" + studentIds.size() + " students, " + instructorIds.size() + " instructors)");
            var16_34.put(period, unavailability);
            ((ExamModel)this.getModel()).addUnavailability(unavailability);
        }
    }

    protected void loadDistributions() {
        List distPrefs = new DistributionPrefDAO().getSession().createQuery("select distinct d from DistributionPref d inner join d.distributionObjects o, Exam x where d.distributionType.examPref=true and o.prefGroup=x and x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and d.owner.uniqueId=:sessionId").setLong("sessionId", this.iSessionId.longValue()).setLong("examTypeId", this.iExamTypeId.longValue()).list();
        this.iProgress.setPhase("Loading distributions...", (long)distPrefs.size());
        Iterator i = distPrefs.iterator();
        while (i.hasNext()) {
            Exam exam;
            this.iProgress.incProgress();
            DistributionPref pref = (DistributionPref)i.next();
            if ("EX_SHARE_ROOM".equals(pref.getDistributionType().getReference())) {
                if (this.iSharing == null) {
                    if (((ExamModel)this.getModel()).hasRoomSharing() && ((ExamModel)this.getModel()).getRoomSharing() instanceof PredefinedExamRoomSharing) {
                        this.iSharing = (PredefinedExamRoomSharing)((ExamModel)this.getModel()).getRoomSharing();
                    } else {
                        this.iSharing = new PredefinedExamRoomSharing(this.getModel(), ((ExamModel)this.getModel()).getProperties());
                        ((ExamModel)this.getModel()).getProperties().setProperty("Exams.RoomSharingClass", PredefinedExamRoomSharing.class.getName());
                        ((ExamModel)this.getModel()).setRoomSharing((ExamRoomSharing)this.iSharing);
                    }
                }
                ArrayList<Exam> exams = new ArrayList<Exam>();
                for (DistributionObject distObj : new TreeSet<DistributionObject>(pref.getDistributionObjects())) {
                    exam = (Exam)this.iExams.get(distObj.getPrefGroup().getUniqueId());
                    if (exam == null) {
                        this.iProgress.info("Exam " + this.getExamLabel((org.unitime.timetable.model.Exam)new ExamDAO().get(distObj.getPrefGroup().getUniqueId())) + " not loaded.");
                        continue;
                    }
                    exams.add(exam);
                }
                for (int a = 0; a < exams.size(); ++a) {
                    for (int b = a + 1; b < exams.size(); ++b) {
                        this.iSharing.addPair((Exam)exams.get(a), (Exam)exams.get(b));
                    }
                }
                continue;
            }
            ExamDistributionConstraint constraint = new ExamDistributionConstraint(pref.getUniqueId().longValue(), pref.getDistributionType().getReference(), pref.getPrefLevel().getPrefProlog());
            for (DistributionObject distObj : new TreeSet<DistributionObject>(pref.getDistributionObjects())) {
                exam = (Exam)this.iExams.get(distObj.getPrefGroup().getUniqueId());
                if (exam == null) {
                    this.iProgress.info("Exam " + this.getExamLabel((org.unitime.timetable.model.Exam)new ExamDAO().get(distObj.getPrefGroup().getUniqueId())) + " not loaded.");
                    continue;
                }
                constraint.addVariable((Variable)exam);
            }
            if (constraint.variables().isEmpty()) continue;
            ((ExamModel)this.getModel()).addConstraint((Constraint)constraint);
            ((ExamModel)this.getModel()).getDistributionConstraints().add(constraint);
        }
    }

    protected void assignInitial() {
        if (this.iLoadSolution) {
            this.iProgress.setPhase("Assigning loaded solution...", (long)((ExamModel)this.getModel()).variables().size());
            for (Exam exam : ((ExamModel)this.getModel()).variables()) {
                this.iProgress.incProgress();
                ExamPlacement placement = (ExamPlacement)exam.getInitialAssignment();
                if (placement == null) continue;
                Set conf = ((ExamModel)this.getModel()).conflictValues(this.getAssignment(), (Value)placement);
                if (!conf.isEmpty()) {
                    for (Map.Entry entry : ((ExamModel)this.getModel()).conflictConstraints(this.getAssignment(), (Value)placement).entrySet()) {
                        Constraint constraint = (Constraint)entry.getKey();
                        Set values = (Set)entry.getValue();
                        if (!(constraint instanceof ExamStudent)) continue;
                        ((ExamStudent)constraint).setAllowDirectConflicts(true);
                        exam.setAllowDirectConflicts(true);
                        Iterator j = values.iterator();
                        while (j.hasNext()) {
                            ((Exam)((ExamPlacement)j.next()).variable()).setAllowDirectConflicts(true);
                        }
                    }
                    conf = ((ExamModel)this.getModel()).conflictValues(this.getAssignment(), (Value)placement);
                }
                if (conf.isEmpty()) {
                    this.getAssignment().assign(0L, (Value)placement);
                    continue;
                }
                this.iProgress.warn("Unable to assign " + ((ExamPlacement)exam.getInitialAssignment()).getName() + " to exam " + exam.getName());
                this.iProgress.info("Conflicts:" + ToolBox.dict2string((Map)((ExamModel)this.getModel()).conflictConstraints(this.getAssignment(), exam.getInitialAssignment()), (int)2));
            }
        }
    }

    protected void checkConsistency() {
        this.iProgress.setPhase("Checking consistency...", (long)((ExamModel)this.getModel()).variables().size());
        for (Exam exam : ((ExamModel)this.getModel()).variables()) {
            this.iProgress.incProgress();
            if (exam.getPeriodPlacements().isEmpty()) {
                this.iProgress.error("Exam " + this.getExamLabel(exam) + " has no period available.");
                continue;
            }
            if (exam.getMaxRooms() <= 0) continue;
            int capacity = 0;
            for (int i = 0; i < Math.min(exam.getMaxRooms(), exam.getRoomPlacements().size()); ++i) {
                ExamRoomPlacement r = (ExamRoomPlacement)exam.getRoomPlacements().get(i);
                capacity += r.getSize(exam.hasAltSeating());
            }
            if (capacity < exam.getSize()) {
                this.iProgress.error("Exam " + this.getExamLabel(exam) + " has no room placement available.");
                continue;
            }
            boolean hasValue = false;
            Iterator f = exam.getPeriodPlacements().iterator();
            while (!hasValue && f.hasNext()) {
                ExamPeriodPlacement period = (ExamPeriodPlacement)f.next();
                if (exam.findBestAvailableRooms(this.getAssignment(), period) == null) continue;
                hasValue = true;
            }
            if (hasValue) continue;
            this.iProgress.error("Exam " + this.getExamLabel(exam) + " has no assignment available.");
        }
    }

    public void loadRoomAvailability(RoomAvailabilityInterface availability) {
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(this.iSessionId, this.iExamTypeId);
        Date[] bounds = ExamPeriod.getBounds((Session)new SessionDAO().get(this.iSessionId), this.iExamTypeId);
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(this.iExamTypeId);
        String exclude = type.getReference();
        this.roomAvailabilityActivate(availability, bounds[0], bounds[1], exclude);
        this.iProgress.setPhase("Loading room availability...", (long)this.iAllRooms.size());
        Iterator i = this.iAllRooms.iterator();
        while (i.hasNext()) {
            Collection<RoomAvailabilityInterface.TimeBlock> times;
            ExamRoom roomEx;
            this.iProgress.incProgress();
            Location location = (Location)i.next();
            if (location.isIgnoreRoomCheck().booleanValue() || (roomEx = this.iRooms.get(location.getUniqueId())) == null || (times = this.getRoomAvailability(availability, location, bounds[0], bounds[1], exclude)) == null) continue;
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                for (ExamPeriod period : periods) {
                    org.cpsolver.exam.model.ExamPeriod periodEx = this.iPeriods.get(period.getUniqueId());
                    if (periodEx == null || !period.overlap(time)) continue;
                    this.iProgress.debug(roomEx.getName() + " not available during " + period.getName() + " due to " + time);
                    roomEx.setAvailable(periodEx, false);
                }
            }
        }
    }

    public Collection<RoomAvailabilityInterface.TimeBlock> getRoomAvailability(RoomAvailabilityInterface availability, Location location, Date startTime, Date endTime, String exclude) {
        Collection<RoomAvailabilityInterface.TimeBlock> ret = null;
        String ts = null;
        try {
            ret = availability.getRoomAvailability(location.getUniqueId(), startTime, endTime, exclude);
            if (!this.iRoomAvailabilityTimeStampIsSet) {
                ts = availability.getTimeStamp(startTime, endTime, exclude);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.warn("Unable to access room availability service, reason:" + e.getMessage());
        }
        if (!this.iRoomAvailabilityTimeStampIsSet) {
            this.iRoomAvailabilityTimeStampIsSet = true;
            if (ts != null) {
                ((ExamModel)this.getModel()).getProperties().setProperty("RoomAvailability.TimeStamp", ts);
                this.iProgress.info("Using room availability that was updated on " + ts + ".");
            } else {
                this.iProgress.error("Room availability is not available.");
            }
        }
        return ret;
    }

    public void roomAvailabilityActivate(RoomAvailabilityInterface availability, Date startTime, Date endTime, String exclude) {
        try {
            availability.activate((Session)new SessionDAO().get(this.iSessionId), startTime, endTime, exclude, ApplicationProperty.RoomAvailabilitySolverWaitForSync.isTrue());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            this.iProgress.warn("Unable to access room availability service, reason:" + e.getMessage());
        }
    }

    private boolean sameOwners(Exam x1, Exam x2) {
        if (x1.getOwners().isEmpty() || x1.getOwners().size() != x2.getOwners().size()) {
            return false;
        }
        block0: for (org.cpsolver.exam.model.ExamOwner o1 : x1.getOwners()) {
            ExamOwner w1 = this.iOwners.get(o1.getId());
            for (org.cpsolver.exam.model.ExamOwner o2 : x2.getOwners()) {
                ExamOwner w2 = this.iOwners.get(o2.getId());
                if (!w1.getOwnerType().equals(w2.getOwnerType()) || !w1.getOwnerId().equals(w2.getOwnerId())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public void makeupSameRoomConstraints() {
        this.iProgress.setPhase("Posting same rooms...", (long)((ExamModel)this.getModel()).variables().size());
        long dc = 0L;
        for (Exam first : ((ExamModel)this.getModel()).variables()) {
            this.iProgress.incProgress();
            for (Exam second : ((ExamModel)this.getModel()).variables()) {
                if (first.getId() >= second.getId() || !this.sameOwners(first, second)) continue;
                this.iProgress.debug("Posting same room constraint between " + first.getName() + " and " + second.getName());
                ExamDistributionConstraint constraint = new ExamDistributionConstraint(--dc, 0, false, 4);
                constraint.addVariable((Variable)first);
                constraint.addVariable((Variable)second);
                ((ExamModel)this.getModel()).addConstraint((Constraint)constraint);
                ((ExamModel)this.getModel()).getDistributionConstraints().add(constraint);
            }
        }
    }
}

