/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.ProjectedStudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseRequests;

public class CourseRequestsWithProjectedLastLikes
extends ProjectedStudentCourseDemands {
    private StudentCourseRequests iCouseRequests;
    private Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> iAreaClasfMajor2LastLike = new Hashtable();
    private Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> iAreaClasfMajor2Real = new Hashtable();

    public CourseRequestsWithProjectedLastLikes(DataProperties properties) {
        super(properties);
        this.iCouseRequests = new StudentCourseRequests(properties);
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        Hashtable<String, Integer> major2ll;
        Hashtable<String, Hashtable<String, Integer>> clasfMajor2ll;
        int students;
        String clasf;
        String major;
        String area;
        this.iCouseRequests.init(hibSession, progress, session, offerings);
        super.init(hibSession, progress, session, offerings);
        for (Object[] o : hibSession.createQuery("select a.academicAreaAbbreviation, m.code, f.code, sum(ac.weight) from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors ac inner join ac.academicClassification f inner join ac.academicArea a inner join ac.major m where x.subjectArea.session.uniqueId = :sessionId group by a.academicAreaAbbreviation, m.code, f.code").setLong("sessionId", session.getUniqueId().longValue()).setCacheable(true).list()) {
            area = (String)o[0];
            major = (String)o[1];
            clasf = (String)o[2];
            students = Math.round(((Number)o[3]).floatValue());
            clasfMajor2ll = this.iAreaClasfMajor2LastLike.get(area);
            if (clasfMajor2ll == null) {
                clasfMajor2ll = new Hashtable();
                this.iAreaClasfMajor2LastLike.put(area, clasfMajor2ll);
            }
            if ((major2ll = clasfMajor2ll.get(clasf)) == null) {
                major2ll = new Hashtable();
                clasfMajor2ll.put(clasf, major2ll);
            }
            major2ll.put(major, students);
        }
        for (Object[] o : hibSession.createQuery("select a.academicAreaAbbreviation, m.code, f.code, sum(ac.weight) from CourseRequest x inner join x.courseDemand.student s inner join s.areaClasfMajors ac inner join ac.academicClassification f inner join ac.academicArea a inner join ac.major m where s.session.uniqueId = :sessionId group by a.academicAreaAbbreviation, m.code, f.code").setLong("sessionId", session.getUniqueId().longValue()).setCacheable(true).list()) {
            area = (String)o[0];
            major = (String)o[1];
            clasf = (String)o[2];
            students = Math.round(((Number)o[3]).floatValue());
            clasfMajor2ll = this.iAreaClasfMajor2Real.get(area);
            if (clasfMajor2ll == null) {
                clasfMajor2ll = new Hashtable();
                this.iAreaClasfMajor2Real.put(area, clasfMajor2ll);
            }
            if ((major2ll = clasfMajor2ll.get(clasf)) == null) {
                major2ll = new Hashtable();
                clasfMajor2ll.put(clasf, major2ll);
            }
            major2ll.put(major, students);
        }
    }

    public int getLastLikes(String areaAbbv, String clasfCode, String majorCode) {
        Hashtable<String, Integer> major2ll;
        Hashtable<String, Hashtable<String, Integer>> clasf2major2ll;
        if (this.iAreaClasfMajor2LastLike.isEmpty()) {
            return 0;
        }
        Hashtable<String, Hashtable<String, Integer>> hashtable = clasf2major2ll = areaAbbv == null ? null : this.iAreaClasfMajor2LastLike.get(areaAbbv);
        if (clasf2major2ll == null || clasf2major2ll.isEmpty()) {
            return 0;
        }
        Hashtable<String, Integer> hashtable2 = major2ll = clasfCode == null ? null : clasf2major2ll.get(clasfCode);
        if (major2ll == null || major2ll.isEmpty()) {
            return 0;
        }
        Integer lastLike = majorCode == null ? null : major2ll.get(majorCode);
        return lastLike == null ? 0 : lastLike;
    }

    public int getCourseReqs(String areaAbbv, String clasfCode, String majorCode) {
        Hashtable<String, Integer> major2ll;
        Hashtable<String, Hashtable<String, Integer>> clasf2major2ll;
        if (this.iAreaClasfMajor2Real.isEmpty()) {
            return 0;
        }
        Hashtable<String, Hashtable<String, Integer>> hashtable = clasf2major2ll = areaAbbv == null ? null : this.iAreaClasfMajor2Real.get(areaAbbv);
        if (clasf2major2ll == null || clasf2major2ll.isEmpty()) {
            return 0;
        }
        Hashtable<String, Integer> hashtable2 = major2ll = clasfCode == null ? null : clasf2major2ll.get(clasfCode);
        if (major2ll == null || major2ll.isEmpty()) {
            return 0;
        }
        Integer lastLike = majorCode == null ? null : major2ll.get(majorCode);
        return lastLike == null ? 0 : lastLike;
    }

    @Override
    public float getProjection(String areaAbbv, String clasfCode, String majorCode) {
        int lastLikes = this.getLastLikes(areaAbbv, clasfCode, majorCode);
        float estimate = (float)lastLikes * super.getProjection(areaAbbv, clasfCode, majorCode) - (float)this.getCourseReqs(areaAbbv, clasfCode, majorCode);
        if (estimate >= 0.0f) {
            return estimate / (float)lastLikes;
        }
        return 0.0f;
    }

    protected <A> Set<A> merge(Set<A> a, Set<A> b) {
        if (a == null || a.isEmpty()) {
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        HashSet<A> c = new HashSet<A>(a);
        c.addAll(b);
        return c;
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        return this.merge(this.iCouseRequests.getDemands(course), super.getDemands(course));
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Double priority = this.iCouseRequests.getEnrollmentPriority(studentId, courseId);
        if (priority != null) {
            return priority;
        }
        return super.getEnrollmentPriority(studentId, courseId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        return this.merge(this.iCouseRequests.getCourses(studentId), super.getCourses(studentId));
    }
}

