/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ListSolutionsForm;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.interfaces.ExternalSolutionCommitAction;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.base.BaseSolution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.LogInfo;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.ListSolutionsRequest.class)
public class ListSolutionsBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.ListSolutionsRequest, CourseTimetablingSolverInterface.ListSolutionsResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static CPSolverMessages SOLVERMSG = Localization.create(CPSolverMessages.class);
    protected static Formats.Format<Date> sTS = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverServerService solverServerService;

    /*
     * WARNING - void declaration
     */
    @Override
    public CourseTimetablingSolverInterface.ListSolutionsResponse execute(CourseTimetablingSolverInterface.ListSolutionsRequest request, SessionContext context) {
        context.checkPermission(Right.Timetables);
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        CourseTimetablingSolverInterface.ListSolutionsResponse response = new CourseTimetablingSolverInterface.ListSolutionsResponse();
        response.setOperation(request.getOperation());
        HashSet<Long> selectedSolutionIds = new HashSet<Long>();
        String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
        if (solutionIdsStr != null) {
            for (String string : solutionIdsStr.split(",")) {
                if (string.isEmpty()) continue;
                selectedSolutionIds.add(Long.valueOf(string));
            }
        }
        Transaction tx = null;
        Session hibSession = SolutionDAO.getInstance().getSession();
        try {
            switch (request.getOperation()) {
                case UPDATE_NOTE: {
                    Object solution;
                    if (!request.hasSolutionIds()) break;
                    tx = hibSession.beginTransaction();
                    for (Long l : request.getSolutionIds()) {
                        solution = (Solution)SolutionDAO.getInstance().get(l, hibSession);
                        context.checkPermission(solution, Right.TimetablesSolutionChangeNote);
                        String note = request.getNote();
                        if (note != null && note.length() > 1000) {
                            note = note.substring(0, 1000);
                        }
                        ((BaseSolution)solution).setNote(note);
                        hibSession.saveOrUpdate(solution);
                    }
                    break;
                }
                case COMMIT: {
                    Solution solution;
                    if (!request.hasSolutionIds()) break;
                    tx = hibSession.beginTransaction();
                    HashSet<Long> ids = new HashSet<Long>();
                    for (Long solutionId : request.getSolutionIds()) {
                        solution = (Solution)SolutionDAO.getInstance().get(solutionId, hibSession);
                        context.checkPermission(solution.getOwner(), Right.TimetablesSolutionCommit);
                        ids.add(solutionId);
                        List solutions = hibSession.createCriteria(Solution.class).add((Criterion)Restrictions.eq((String)"owner", (Object)solution.getOwner())).list();
                        HashSet<Solution> touchedSolutionSet = new HashSet<Solution>();
                        for (Solution s : solutions) {
                            if (s.equals(solution) || !s.isCommited().booleanValue()) continue;
                            touchedSolutionSet.add(s);
                            ids.add(s.getUniqueId());
                        }
                        touchedSolutionSet.add(solution);
                        if (context.hasPermission(solution, Right.TimetablesSolutionChangeNote)) {
                            String note = request.getNote();
                            if (note != null && note.length() > 1000) {
                                note = note.substring(0, 1000);
                            }
                            solution.setNote(note);
                        }
                        response.setSuccess(solution.commitSolution(response.getErrors(), hibSession, context.getUser().getExternalUserId()));
                        hibSession.update((Object)solution);
                        String className = ApplicationProperty.ExternalActionSolutionCommit.value();
                        if (className == null || className.isEmpty()) continue;
                        ExternalSolutionCommitAction commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                        commitAction.performExternalSolutionCommitAction(touchedSolutionSet, hibSession);
                    }
                    this.solverServerService.getLocalServer().refreshCourseSolution(ids.toArray(new Long[ids.size()]));
                    break;
                }
                case UNCOMMIT: {
                    Solution solution;
                    if (!request.hasSolutionIds()) break;
                    HashSet<Long> ids = new HashSet<Long>();
                    tx = hibSession.beginTransaction();
                    for (Long solutionId : request.getSolutionIds()) {
                        solution = (Solution)SolutionDAO.getInstance().get(solutionId, hibSession);
                        context.checkPermission(solution.getOwner(), Right.TimetablesSolutionCommit);
                        ids.add(solutionId);
                        if (context.hasPermission(solution, Right.TimetablesSolutionChangeNote)) {
                            String note = request.getNote();
                            if (note != null && note.length() > 1000) {
                                note = note.substring(0, 1000);
                            }
                            solution.setNote(note);
                        }
                        solution.uncommitSolution(hibSession, context.getUser().getExternalUserId());
                        String className = ApplicationProperty.ExternalActionSolutionCommit.value();
                        if (className == null || className.isEmpty()) continue;
                        ExternalSolutionCommitAction commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                        HashSet<Solution> solutions = new HashSet<Solution>();
                        solutions.add(solution);
                        commitAction.performExternalSolutionCommitAction(solutions, hibSession);
                    }
                    this.solverServerService.getLocalServer().refreshCourseSolution(ids.toArray(new Long[ids.size()]));
                    break;
                }
                case DELETE: {
                    Object solution;
                    if (!request.hasSolutionIds()) break;
                    tx = hibSession.beginTransaction();
                    for (Long l : request.getSolutionIds()) {
                        solution = (Solution)SolutionDAO.getInstance().get(l, hibSession);
                        if (((BaseSolution)solution).isCommited().booleanValue()) {
                            context.checkPermission(((BaseSolution)solution).getOwner(), Right.TimetablesSolutionCommit);
                            ((Solution)solution).uncommitSolution(hibSession, context.getUser().getExternalUserId());
                            String className = ApplicationProperty.ExternalActionSolutionCommit.value();
                            if (className != null && !className.isEmpty()) {
                                ExternalSolutionCommitAction commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                                HashSet<Solution> solutions = new HashSet<Solution>();
                                solutions.add((Solution)solution);
                                commitAction.performExternalSolutionCommitAction(solutions, hibSession);
                            }
                        }
                        context.checkPermission(solution, Right.TimetablesSolutionDelete);
                        selectedSolutionIds.remove(((BaseSolution)solution).getUniqueId());
                        ((Solution)solution).delete(hibSession);
                    }
                    break;
                }
                case LOAD: {
                    void var10_26;
                    if (solver != null && solver.isWorking()) {
                        throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                    }
                    if (selectedSolutionIds.isEmpty()) {
                        throw new GwtRpcException(MESSAGES.errorListSolutionsNoSolutionSelected());
                    }
                    context.checkPermission(new ArrayList(selectedSolutionIds), "Solution", Right.TimetablesSolutionLoad);
                    String solutionIds = "";
                    String string = "";
                    for (Long solutionId : selectedSolutionIds) {
                        Solution solution = (Solution)SolutionDAO.getInstance().get(solutionId, hibSession);
                        solutionIds = solutionIds + (solutionIds.isEmpty() ? "" : ",") + solution.getUniqueId();
                        String string2 = (String)var10_26 + (var10_26.isEmpty() ? "" : ",") + solution.getOwner().getUniqueId();
                    }
                    DataProperties configLoad = this.courseTimetablingSolverService.createConfig(request.getConfigurationId(), null);
                    configLoad.setProperty("General.SolverGroupId", (String)var10_26);
                    configLoad.setProperty("General.SolutionId", solutionIds);
                    if (request.getHost() != null) {
                        configLoad.setProperty("General.Host", request.getHost());
                    }
                    solver = this.courseTimetablingSolverService.createSolver(configLoad);
                    break;
                }
                case LOAD_EMPTY: {
                    if (solver != null && solver.isWorking()) {
                        throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                    }
                    if (!request.hasOwner()) {
                        throw new GwtRpcException(MESSAGES.errorListSolutionsNoOwnerSelected());
                    }
                    context.checkPermission(request.getOwnerId(), "SolverGroup", Right.TimetablesSolutionLoadEmpty);
                    DataProperties configLoadEmpty = this.courseTimetablingSolverService.createConfig(request.getConfigurationId(), null);
                    configLoadEmpty.setProperty("General.SolverGroupId", request.getOwnerId().toString());
                    if (request.getHost() != null) {
                        configLoadEmpty.setProperty("General.Host", request.getHost());
                    }
                    solver = this.courseTimetablingSolverService.createSolver(configLoadEmpty);
                    break;
                }
                case SELECT: {
                    if (!request.hasSolutionIds()) break;
                    for (Long solutionId : request.getSolutionIds()) {
                        Solution solution = (Solution)SolutionDAO.getInstance().get(solutionId, hibSession);
                        if (solution == null) continue;
                        Iterator i = selectedSolutionIds.iterator();
                        while (i.hasNext()) {
                            Solution other = (Solution)SolutionDAO.getInstance().get((Serializable)i.next(), hibSession);
                            if (other == null || !other.getOwner().equals(solution.getOwner())) continue;
                            i.remove();
                        }
                        selectedSolutionIds.add(solutionId);
                    }
                    break;
                }
                case DESELECT: {
                    if (!request.hasSolutionIds()) break;
                    for (Long solutionId : request.getSolutionIds()) {
                        selectedSolutionIds.remove(solutionId);
                    }
                    break;
                }
                case UNLOAD: {
                    if (solver == null) {
                        throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                    }
                    if (solver.isWorking()) {
                        throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                    }
                    this.courseTimetablingSolverService.removeSolver();
                    solver = null;
                    break;
                }
                case RELOAD: {
                    if (solver == null) {
                        throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                    }
                    if (solver.isWorking()) {
                        throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                    }
                    this.courseTimetablingSolverService.reload(this.courseTimetablingSolverService.createConfig(solver.getProperties().getPropertyLong("General.SettingsId", null), null));
                    break;
                }
                case SAVE: 
                case SAVE_AS_NEW: 
                case SAVE_COMMIT: 
                case SAVE_AS_NEW_COMMIT: {
                    if (solver == null) {
                        throw new GwtRpcException(MESSAGES.warnSolverNotStarted());
                    }
                    if (solver.isWorking()) {
                        throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
                    }
                    solver.setNote(request.getNote());
                    boolean isNew = request.getOperation() == CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW || request.getOperation() == CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW_COMMIT;
                    boolean isCommit = request.getOperation() == CourseTimetablingSolverInterface.SolutionOperation.SAVE_COMMIT || request.getOperation() == CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW_COMMIT;
                    this.courseTimetablingSolverService.getSolver().save(isNew, isCommit);
                }
            }
            if (tx != null && tx.isActive()) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
        solutionIdsStr = "";
        for (Long l : selectedSolutionIds) {
            solutionIdsStr = solutionIdsStr + (solutionIdsStr.isEmpty() ? "" : ",") + l;
        }
        context.setAttribute(SessionAttribute.SelectedSolution, (Object)(solutionIdsStr.isEmpty() ? null : solutionIdsStr));
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        this.fillSelectedSolutions(response, context, selectedSolutionIds, solver);
        this.fillSolutions(response, context, selectedSolutionIds);
        this.fillHosts(response, context);
        this.fillConfigurations(response, context);
        this.fillSolverStatus(response, context, solver);
        this.fillSolverLog(response, context, solver);
        this.fillOwners(response, context);
        this.fillAvailableOperations(response, context, solver);
        this.fillSolverInfos(response, context, solver);
        BackTracker.markForBack(context, "gwt.jsp?page=listSolutions", MESSAGES.pageListSolutions(), true, true);
        return response;
    }

    protected void fillHosts(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context) {
        if (context.hasPermission(Right.CanSelectSolverServer)) {
            for (SolverServer server : this.solverServerService.getServers(true)) {
                response.addHost(server.getHost());
            }
            if (response.hasHosts()) {
                Collections.sort(response.getHosts());
            }
            if (!(!ApplicationProperty.SolverLocalEnabled.isTrue() || response.hasHosts() && response.getHosts().contains("local"))) {
                response.addHost(0, "local");
            }
            response.addHost(0, "auto");
        }
    }

    protected void fillConfigurations(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context) {
        int appearance = 0;
        String defaultConfig = "Interactive";
        List configs = SolverPredefinedSettingDAO.getInstance().getSession().createQuery("from SolverPredefinedSetting s where s.appearance = :appearance").setInteger("appearance", appearance).setCacheable(true).list();
        for (SolverPredefinedSetting config : configs) {
            SolverInterface.SolverConfiguration c = new SolverInterface.SolverConfiguration();
            c.setId(config.getUniqueId());
            c.setName(config.getDescription());
            response.addConfiguration(c);
            if (response.getConfigurationId() != null || !defaultConfig.equals(config.getName())) continue;
            response.setConfigurationId(c.getId());
        }
    }

    protected static String fix(String pref) {
        if (!MESSAGES.notApplicable().equals(pref) && pref.indexOf(47) >= 0) {
            pref = pref.substring(0, pref.indexOf(47)).trim();
        }
        if (!MESSAGES.notApplicable().equals(pref) && pref.indexOf(32) >= 0) {
            pref = pref.substring(0, pref.indexOf(32)).trim();
        }
        return pref;
    }

    protected void fillSolutions(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, Set<Long> selectedIds) {
        boolean committedOnly = !context.hasPermission(Right.Solver);
        boolean listAll = context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        Collection solutions = null;
        if (listAll) {
            solutions = Solution.findBySessionId(context.getUser().getCurrentAcademicSessionId());
        } else {
            ArrayList<Serializable> solverGroupIds = new ArrayList<Serializable>();
            for (Qualifiable qualifiable : context.getUser().getCurrentAuthority().getQualifiers("SolverGroup")) {
                solverGroupIds.add(qualifiable.getQualifierId());
            }
            solutions = SolutionDAO.getInstance().getSession().createQuery("from Solution where owner.uniqueId in :solverGroupIds").setParameterList("solverGroupIds", solverGroupIds).list();
        }
        if (solutions == null || solutions.isEmpty()) {
            response.setMessage(committedOnly ? MESSAGES.errorListSolutionsNoCommitted() : MESSAGES.errorListSolutionsNoSaved());
            return;
        }
        for (Solution solution : solutions) {
            if (committedOnly && !solution.isCommited().booleanValue()) continue;
            String string = solution.getSolverConfiguration() != null ? solution.getSolverConfiguration() : (solution.getSolverMode() != null ? solution.getSolverMode() : MESSAGES.listSolutionsUnknown());
            PropertiesInfo globalInfo = (PropertiesInfo)solution.getInfo("GlobalInfo");
            response.addRow(new TableInterface.TableRowInterface(solution.getUniqueId(), selectedIds != null && selectedIds.contains(solution.getUniqueId()), new TableInterface.TableCellInterface<Date>(solution.getCreated(), sTS.format(solution.getCreated())), new TableInterface.TableCellInterface<String>(string), new TableInterface.TableCellInterface<Date>(solution.isCommited() != false ? solution.getCommitDate() : null, solution.isCommited() != false ? sTS.format(solution.getCommitDate()) : ""), new TableInterface.TableCellInterface<String>(solution.getOwner().getAbbv()).setTitle(solution.getOwner().getName()), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Assigned variables", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Overall solution value", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Time preferences", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : globalInfo.getProperty("Student conflicts", MESSAGES.notApplicable()).replaceAll(" \\[", "(").replaceAll("\\]", ")").replaceAll(", ", ",").replaceAll("hard:", "h").replaceAll("distance:", "d").replaceAll("commited:", "c").replaceAll("committed:", "c")), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Room preferences", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Distribution preferences", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Back-to-back instructor preferences", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Too big rooms", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Useless half-hours", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(globalInfo == null ? MESSAGES.listSolutionsUnknown() : ListSolutionsBackend.fix(globalInfo.getProperty("Perturbations: Total penalty", MESSAGES.notApplicable()))), new TableInterface.TableCellInterface<String>(solution.getNote())));
        }
        response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colCreated()), new TableInterface.TableHeaderIterface(MESSAGES.colSolverConfiguration()), new TableInterface.TableHeaderIterface(MESSAGES.colCommitted()), new TableInterface.TableHeaderIterface(MESSAGES.colOwner()), new TableInterface.TableHeaderIterface(MESSAGES.colShortAssignedVariables()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTotalValue()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTimePref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortStudentConflicts()), new TableInterface.TableHeaderIterface(MESSAGES.colShortRoomPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDistPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortInstructorBtbPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTooBigRooms()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUselessHalfHours()), new TableInterface.TableHeaderIterface(MESSAGES.colShortPerturbations()), new TableInterface.TableHeaderIterface(MESSAGES.colNote()));
    }

    protected void fillSelectedSolutions(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, Set<Long> selectedIds, SolverProxy solver) {
        if (selectedIds == null) {
            return;
        }
        for (Long solutionId : selectedIds) {
            PropertiesInfo propInfo;
            Solution solution = (Solution)SolutionDAO.getInstance().get(solutionId);
            if (solution == null) continue;
            SolverInterface.SolutionInfo si = new SolverInterface.SolutionInfo();
            si.setCreated(sTS.format(solution.getCreated()));
            if (solution.isCommited().booleanValue()) {
                si.setCommitted(sTS.format(solution.getCommitDate()));
            }
            si.setNote(solution.getNote());
            si.setOwner(solution.getOwner().getName());
            si.setId(solutionId);
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE, context.hasPermission(solution, Right.TimetablesSolutionChangeNote));
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.COMMIT, solution.isCommited() == false && context.hasPermission(solution.getOwner(), Right.TimetablesSolutionCommit));
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.UNCOMMIT, solution.isCommited() != false && context.hasPermission(solution.getOwner(), Right.TimetablesSolutionCommit));
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.DELETE, solution.isCommited() == false && context.hasPermission(solution, Right.TimetablesSolutionDelete));
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.EXPORT, context.hasPermission(solution, Right.TimetablesSolutionExportCsv));
            response.setCanExecute(solutionId, CourseTimetablingSolverInterface.SolutionOperation.LOAD, solver == null && context.hasPermission(solution, Right.TimetablesSolutionLoad));
            si.setName(solution.getOwner().getName());
            LogInfo logInfo = (LogInfo)solution.getInfo("LogInfo");
            if (logInfo != null) {
                for (Progress.Message m : logInfo.getLog()) {
                    if (m.getLevel() == SolverInterface.ProgressLogLevel.STAGE.ordinal() && (SOLVERMSG.statusLoadingInputData().equals(m.getMessage()) || "Loading input data ...".equals(m.getMessage())) && si.hasLog()) {
                        si.getLog().clear();
                    }
                    if (m.getLevel() < SolverInterface.ProgressLogLevel.WARN.ordinal()) continue;
                    si.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
                }
            }
            if ((propInfo = (PropertiesInfo)solution.getInfo("GlobalInfo")) == null) continue;
            Map<String, String> translations = SOLVERMSG.courseInfoMessages();
            TreeSet<String> keys = new TreeSet<String>(new ListSolutionsForm.InfoComparator());
            for (Object o : propInfo.keySet()) {
                keys.add((String)o);
            }
            for (String key : keys) {
                String translatedKey;
                String string = translatedKey = translations == null ? null : translations.get(key);
                if (translatedKey != null) {
                    si.addPair(translatedKey, propInfo.getProperty(key));
                    continue;
                }
                si.addPair(key, propInfo.getProperty(key));
            }
            response.addSelectedSolution(si);
        }
    }

    protected void fillSolverStatus(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, SolverProxy solver) {
        if (solver != null) {
            SolverPredefinedSetting cfg;
            response.setLoadDate(solver.getLoadedDate());
            response.setWorking(solver.isRunning() || solver.isWorking());
            try {
                Map p = solver.getProgress();
                response.setSolverStatus((String)p.get("STATUS"));
                long progressMax = (Long)p.get("MAX_PROGRESS");
                if (progressMax > 0L) {
                    String progress = (String)p.get("PHASE");
                    long progressCur = (Long)p.get("PROGRESS");
                    double progressPercent = 100.0 * (double)(progressCur < progressMax ? progressCur : progressMax) / (double)progressMax;
                    progress = progress + " (" + new DecimalFormat("0.0").format(progressPercent) + "%)";
                    response.setSolverProgress(progress);
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            DataProperties config = solver.getProperties();
            response.setConfigurationId(config.getPropertyLong("General.SettingsId", null));
            if (response.getConfigurationId() != null && response.getConfiguration(response.getConfigurationId()) == null && (cfg = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(response.getConfigurationId())) != null && cfg.getAppearance() == 1) {
                SolverInterface.SolverConfiguration c = new SolverInterface.SolverConfiguration();
                c.setId(cfg.getUniqueId());
                c.setName(cfg.getDescription());
                response.addConfiguration(c);
            }
        } else {
            response.setSolverStatus(MESSAGES.solverStatusNotStarted());
        }
    }

    protected void fillSolverLog(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, SolverProxy solver) {
        List<Progress.Message> log;
        if (solver != null && (log = solver.getProgressLog(SolverInterface.ProgressLogLevel.WARN.ordinal(), SOLVERMSG.statusLoadingInputData(), null)) != null) {
            for (Progress.Message m : log) {
                response.addMessage(m.getLevel(), m.getDate(), m.getMessage(), m.getTrace());
            }
        }
    }

    protected void fillOwners(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context) {
        for (SolverGroup owner : SolverGroup.getUserSolverGroups(context.getUser())) {
            if (!context.hasPermission(owner, Right.TimetablesSolutionLoadEmpty)) continue;
            response.addSolverOwner(new SolverInterface.SolverOwner(owner.getUniqueId(), owner.getName()));
        }
    }

    protected void fillAvailableOperations(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, SolverProxy solver) {
        if (solver != null) {
            response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.CHECK, solver.isWorking());
            response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.UPDATE_NOTE, !solver.isWorking());
            if (!solver.isWorking()) {
                response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.UNLOAD, true);
                response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.RELOAD, true);
                Long[] owners = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
                if (context.hasPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionExportCsv)) {
                    response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.EXPORT, true);
                }
                Long[] iSolutionIds = solver.getProperties().getPropertyLongArry("General.SolutionId", null);
                boolean hasSolution = false;
                boolean canOverwrite = true;
                if (iSolutionIds != null && iSolutionIds.length > 0) {
                    for (int i = 0; i < iSolutionIds.length; ++i) {
                        Solution solution;
                        Solution solution2 = solution = iSolutionIds[i] == null ? null : (Solution)SolutionDAO.getInstance().get(iSolutionIds[i]);
                        if (solution == null) continue;
                        hasSolution = true;
                        if (!solution.getCommited().booleanValue()) continue;
                        canOverwrite = false;
                    }
                }
                if (context.hasPermission((Serializable)owners, "SolverGroup", Right.SolverSolutionSave)) {
                    response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW, true);
                    if (hasSolution && canOverwrite) {
                        response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE, true);
                    }
                }
                if (context.hasPermission((Serializable)owners, "SolverGroup", Right.TimetablesSolutionCommit)) {
                    response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_AS_NEW_COMMIT, true);
                    if (hasSolution) {
                        response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.SAVE_COMMIT, true);
                    }
                }
            }
        } else {
            response.setCanExecute((Long)-1L, CourseTimetablingSolverInterface.SolutionOperation.LOAD_EMPTY, context.hasPermission(Right.TimetablesSolutionLoadEmpty));
        }
    }

    protected void fillSolverInfos(CourseTimetablingSolverInterface.ListSolutionsResponse response, SessionContext context, SolverProxy solver) {
        Map<String, String> info;
        Map<String, String> map = info = solver == null ? null : solver.currentSolutionInfo();
        if (info != null) {
            Map<String, String> translations = SOLVERMSG.courseInfoMessages();
            SolverInterface.SolutionInfo si = new SolverInterface.SolutionInfo();
            Date loaded = solver.getLoadedDate();
            si.setCreated(loaded == null ? null : sTS.format(loaded));
            si.setNote(solver.getNote());
            TreeSet<String> keys = new TreeSet<String>(new ListSolutionsForm.InfoComparator());
            keys.addAll(info.keySet());
            for (String key : keys) {
                String translatedKey;
                String string = translatedKey = translations == null ? null : translations.get(key);
                if (translatedKey != null) {
                    si.addPair(translatedKey, info.get(key));
                    continue;
                }
                si.addPair(key, info.get(key));
            }
            response.setCurrentSolution(si);
        }
        if (solver != null) {
            if (response.hasOwerIds()) {
                response.getOwnerIds().clear();
            }
            Long[] owners = solver.getProperties().getPropertyLongArry("General.SolverGroupId", null);
            String ownerString = "";
            if (owners != null) {
                for (Long owner : owners) {
                    response.addOwnerId(owner);
                    SolverGroup g = (SolverGroup)SolverGroupDAO.getInstance().get(owner);
                    if (g == null) continue;
                    ownerString = ownerString + (ownerString.isEmpty() ? "" : "<br>") + g.getName();
                }
            }
            if (!ownerString.isEmpty() && response.hasCurrentSolution()) {
                response.getCurrentSolution().setOwner(ownerString);
            }
        }
    }
}

