/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class StudentSchedulingSolutionStatisticsReport
implements StudentSectioningReport {
    private StudentSectioningModel iModel = null;
    protected static DecimalFormat sIntFormat = new DecimalFormat("#,##0");
    protected static DecimalFormat sPercentFormat = new DecimalFormat("0.00");
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00");
    private static StudentFilter FILTER_ALL = new AndFilter(new NotFilter(new DummyOrNoRequestsFilter()), new NotFilter(new OnlineLateFilter()));
    private static StudentFilter FILTER_ALL_RES = new AndFilter(new NotFilter(new DummyOrNoRequestsFilter()), new NotFilter(new OnlineFilter()));

    public StudentSchedulingSolutionStatisticsReport(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    /*
     * WARNING - void declaration
     */
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        ArrayList<CSVFile.CSVField> header = new ArrayList<CSVFile.CSVField>();
        ArrayList<StudentGroup> groups = new ArrayList<StudentGroup>();
        header.add(new CSVFile.CSVField((Object)""));
        HashMap<Integer, StudentGroup> counts = new HashMap<Integer, StudentGroup>();
        for (StudentGroup studentGroup : StudentGroup.values()) {
            int nrStudents = 0;
            for (Object student : this.getModel().getStudents()) {
                if (!studentGroup.matches((Student)student)) continue;
                ++nrStudents;
            }
            if (nrStudents <= 0 || counts.containsKey(nrStudents)) continue;
            groups.add(studentGroup);
            header.add(new CSVFile.CSVField((Object)studentGroup.getName()));
            counts.put(nrStudents, studentGroup);
        }
        header.add(new CSVFile.CSVField((Object)"Note"));
        csv.setHeader(header);
        for (Enum enum_ : Statistics.values()) {
            void var15_22;
            Object student;
            String[] names = ((Statistics)enum_).getNames();
            ArrayList table = new ArrayList();
            student = names;
            int n = ((String[])student).length;
            boolean bl = false;
            while (var15_22 < n) {
                String name = student[var15_22];
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField((Object)name));
                table.add(line);
                ++var15_22;
            }
            for (StudentGroup g : groups) {
                String[] stringArray = ((Statistics)enum_).getValues(g, this.getModel(), assignment);
                for (int i = 0; i < stringArray.length; ++i) {
                    ((List)table.get(i)).add(new CSVFile.CSVField((Object)stringArray[i]));
                }
            }
            String[] notes = ((Statistics)enum_).getNotes();
            for (int i = 0; i < notes.length; ++i) {
                ((List)table.get(i)).add(new CSVFile.CSVField((Object)notes[i]));
            }
            for (List list : table) {
                csv.addLine((Collection)list);
            }
            if (!((Statistics)enum_).isNewLine()) continue;
            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)" ")});
        }
        return csv;
    }

    static /* synthetic */ StudentFilter access$000() {
        return FILTER_ALL;
    }

    public static enum Statistics {
        NBR_STUDENTS("Number of Students", "Number of students for which a schedule was computed", new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int count = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    ++count;
                }
                return new String[]{sIntFormat.format(count)};
            }
        }),
        COMPL_SCHEDULE(new String[]{"Complete Schedule", "- missing one course", "- missing two courses", "- missing three courses", "- missing four or more courses"}, new String[]{"Percentage of students with a complete schedule (all requested courses assigned or reaching max credit)", "Students that did not get a requested course", "Students that did not get two requested courses"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int total = 0;
                int[] missing = new int[]{0, 0, 0, 0};
                int complete = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    ++total;
                    int nrRequests = 0;
                    int nrAssignedRequests = 0;
                    for (Request r : student.getRequests()) {
                        if (!(r instanceof CourseRequest)) continue;
                        if (!r.isAlternative()) {
                            ++nrRequests;
                        }
                        if (!r.isAssigned(assignment)) continue;
                        ++nrAssignedRequests;
                    }
                    if (nrAssignedRequests < nrRequests) {
                        int n = Math.min(nrRequests - nrAssignedRequests, missing.length) - 1;
                        missing[n] = missing[n] + 1;
                    }
                    if (!student.isComplete(assignment)) continue;
                    ++complete;
                }
                return new String[]{sPercentFormat.format(100.0 * (double)complete / (double)total) + "%", sPercentFormat.format(100.0 * (double)missing[0] / (double)total) + "%", sPercentFormat.format(100.0 * (double)missing[1] / (double)total) + "%", sPercentFormat.format(100.0 * (double)missing[2] / (double)total) + "%", sPercentFormat.format(100.0 * (double)missing[3] / (double)total) + "%"};
            }
        }),
        REQUESTED_COURSES(new String[]{"Requested Courses", "- pre-enrolled", "Courses per Student", "Assigned Courses", "- 1st choice", "- 2nd choice", "- 3rd choice", "- 4th+ choice"}, new String[]{"Total number of requested courses by all students (not counting substitutes or alternatives)", "Percentage of requested courses that were already enrolled (solver was not allowed to change)", "The average number of course requested per student", "Percentage of all course requests satisfied", "Out of the above, the percentage of cases where the 1st choice course was given"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int requests = 0;
                int students = 0;
                int assigned = 0;
                int fixed = 0;
                int initial = 0;
                int[] assignedChoice = new int[]{0, 0, 0, 0};
                int assignedChoiceTotal = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    ++students;
                    for (Request r : student.getRequests()) {
                        if (!(r instanceof CourseRequest)) continue;
                        if (!r.isAlternative()) {
                            ++requests;
                        }
                        if (!r.isAlternative() && ((CourseRequest)r).isFixed()) {
                            ++fixed;
                        }
                        Enrollment e = (Enrollment)r.getAssignment(assignment);
                        if (r.getInitialAssignment() != null && ((Enrollment)r.getInitialAssignment()).equals((Object)e)) {
                            ++initial;
                        }
                        if (e == null) continue;
                        ++assigned;
                        int n = Math.min(e.getTruePriority(), assignedChoice.length - 1);
                        assignedChoice[n] = assignedChoice[n] + 1;
                        ++assignedChoiceTotal;
                    }
                }
                if (fixed == 0 && initial > 0) {
                    fixed = initial;
                }
                if (requests == 0) {
                    return new String[]{sIntFormat.format(requests), "", "", "", "", "", "", ""};
                }
                return new String[]{sIntFormat.format(requests), fixed == 0 ? "" : sPercentFormat.format(100.0 * (double)fixed / (double)requests) + "%", sDoubleFormat.format((double)requests / (double)students), sPercentFormat.format(100.0 * (double)assigned / (double)requests) + "%", sPercentFormat.format(100.0 * (double)assignedChoice[0] / (double)assignedChoiceTotal) + "%", sPercentFormat.format(100.0 * (double)assignedChoice[1] / (double)assignedChoiceTotal) + "%", sPercentFormat.format(100.0 * (double)assignedChoice[2] / (double)assignedChoiceTotal) + "%", sPercentFormat.format(100.0 * (double)assignedChoice[3] / (double)assignedChoiceTotal) + "%"};
            }
        }),
        NOT_ASSIGNED_PRIORITY(new String[]{"Not-assigned priority", "- 1st priority not assigned", "- 2nd priority not assigned", "- 3rd priority not assigned", "- 4th priority not assigned", "- 5th priority not assigned", "- 6th or later priority not assigned"}, new String[]{"The average priority of the course requests that were not satisfied", "Number of cases where a student did not get a 1st priority course", "Number of cases where a student did not get a 2nd priority course"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int[] notAssignedPriority = new int[]{0, 0, 0, 0, 0, 0};
                int notAssignedTotal = 0;
                int avgPriority = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    for (Request r : student.getRequests()) {
                        Enrollment e;
                        if (!(r instanceof CourseRequest) || (e = (Enrollment)r.getAssignment(assignment)) != null || r.isAlternative()) continue;
                        int n = Math.min(r.getPriority(), notAssignedPriority.length - 1);
                        notAssignedPriority[n] = notAssignedPriority[n] + 1;
                        ++notAssignedTotal;
                        avgPriority += r.getPriority();
                    }
                }
                if (notAssignedTotal == 0) {
                    return new String[]{"", "", "", "", "", "", ""};
                }
                return new String[]{sDoubleFormat.format(1.0 + (double)avgPriority / (double)notAssignedTotal), sIntFormat.format(notAssignedPriority[0]), sIntFormat.format(notAssignedPriority[1]), sIntFormat.format(notAssignedPriority[2]), sIntFormat.format(notAssignedPriority[3]), sIntFormat.format(notAssignedPriority[4]), sIntFormat.format(notAssignedPriority[5])};
            }
        }, true),
        ASSIGNED_COM(new String[]{"Assigned WC/OC", "Missing space in WC/OC"}, new String[]{"Number of students enrolled in a WC/OC course", "Number of unassigned course requests in written/oral communication courses"}, new Statistic(){
            String[] sComCourses = new String[]{"AMST 10100", "CLCS 23100", "CLCS 23700", "CLCS 33900", "COM 11400", "COM 20400", "COM 21700", "EDCI 20500", "EDPS 31500", "ENGL 10600", "ENGL 10800", "HONR 19903", "PHIL 26000", "SCLA 10100", "SCLA 10200", "SPAN 33000"};

            private boolean isComCourse(Course course) {
                for (String c : this.sComCourses) {
                    if (!course.getName().startsWith(c)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int assigned = 0;
                int notAssigned = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    for (Request r : student.getRequests()) {
                        if (!(r instanceof CourseRequest)) continue;
                        CourseRequest cr = (CourseRequest)r;
                        Enrollment e = (Enrollment)cr.getAssignment(assignment);
                        if (e != null && this.isComCourse(e.getCourse())) {
                            ++assigned;
                            continue;
                        }
                        if (e != null || !this.isComCourse((Course)cr.getCourses().get(0)) || !student.canAssign(assignment, r) || r.isAlternative()) continue;
                        ++notAssigned;
                    }
                }
                return new String[]{sIntFormat.format(assigned), sIntFormat.format(notAssigned)};
            }
        }, true),
        CRITICAL(new String[]{"Critical courses", "Assigned critical courses"}, new String[]{"Number of course requests marked as critical (~ course/group/placeholder critical in degree plan)"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int assigned = 0;
                int total = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    for (Request r : student.getRequests()) {
                        CourseRequest cr;
                        if (!(r instanceof CourseRequest) || (cr = (CourseRequest)r).isAlternative() || cr.getRequestPriority() != Request.RequestPriority.Critical) continue;
                        ++total;
                        if (!cr.isAssigned(assignment)) continue;
                        ++assigned;
                    }
                }
                if (total == 0) {
                    return new String[]{"N/A", ""};
                }
                return new String[]{sIntFormat.format(total), sPercentFormat.format(100.0 * (double)assigned / (double)total) + "%"};
            }
        }),
        IMPORTANT(new String[]{"Important courses", "Assigned important courses"}, new String[]{"Number of course requests marked as important (~ course/group/placeholder critical in the first choice major)"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int assigned = 0;
                int total = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    for (Request r : student.getRequests()) {
                        CourseRequest cr;
                        if (!(r instanceof CourseRequest) || (cr = (CourseRequest)r).isAlternative() || cr.getRequestPriority() != Request.RequestPriority.Important) continue;
                        ++total;
                        if (!cr.isAssigned(assignment)) continue;
                        ++assigned;
                    }
                }
                if (total == 0) {
                    return new String[]{"N/A", ""};
                }
                return new String[]{sIntFormat.format(total), sPercentFormat.format(100.0 * (double)assigned / (double)total) + "%"};
            }
        }, true),
        PREFERENCES(new String[]{"Course requests with preferences", "Satisfied preferences", "- instructional method", "- classes"}, new String[]{"Course requests with IM or section preferences", "Percentage of satisfied preferences (both class and IM)", "Percentage of cases when the preferred instructional method was given to the student", "Percentage of cases when the preferred class was given to the student"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int prefs = 0;
                int configPrefs = 0;
                int sectionPrefs = 0;
                double sectionPref = 0.0;
                double configPref = 0.0;
                double satisfied = 0.0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    block1: for (Request r : student.getRequests()) {
                        if (!(r instanceof CourseRequest)) continue;
                        CourseRequest cr = (CourseRequest)r;
                        Enrollment e = (Enrollment)r.getAssignment(assignment);
                        if (e == null || !r.hasSelection()) continue;
                        ++prefs;
                        satisfied += e.percentSelected();
                        for (Choice ch : cr.getSelectedChoices()) {
                            if (ch.getConfigId() == null) continue;
                            ++configPrefs;
                            configPref += e.percentSelectedSameConfig();
                            break;
                        }
                        for (Choice ch : cr.getSelectedChoices()) {
                            if (ch.getSectionId() == null) continue;
                            ++sectionPrefs;
                            sectionPref += e.percentSelectedSameSection();
                            continue block1;
                        }
                    }
                }
                if (prefs == 0) {
                    return new String[]{"N/A", "", "", ""};
                }
                return new String[]{sIntFormat.format(prefs), sPercentFormat.format(100.0 * satisfied / (double)prefs) + "%", sPercentFormat.format(100.0 * sectionPref / (double)sectionPrefs) + "%", sPercentFormat.format(100.0 * configPref / (double)configPrefs) + "%"};
            }
        }, true),
        BALANCING(new String[]{"Unbalanced sections", "- average disbalance"}, new String[]{"Classes dis-balanced by 10% or more", "Average difference between target and actual enrollment in the section"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                double disbWeight = 0.0;
                int disb10Sections = 0;
                int totalSections = 0;
                for (Offering offering : model.getOfferings()) {
                    for (Config config : offering.getConfigs()) {
                        double enrl = 0.0;
                        for (Enrollment e : config.getEnrollments(assignment)) {
                            if (!group.matches(e.getStudent())) continue;
                            enrl += e.getRequest().getWeight();
                        }
                        for (Subpart subpart : config.getSubparts()) {
                            if (subpart.getSections().size() <= 1) continue;
                            if (subpart.getLimit() > 0) {
                                double ratio = enrl / (double)subpart.getLimit();
                                for (Section section : subpart.getSections()) {
                                    double sectEnrl = 0.0;
                                    for (Enrollment e : section.getEnrollments(assignment)) {
                                        if (!group.matches(e.getStudent())) continue;
                                        sectEnrl += e.getRequest().getWeight();
                                    }
                                    double desired = ratio * (double)section.getLimit();
                                    disbWeight += Math.abs(sectEnrl - desired);
                                    if (Math.abs(desired - sectEnrl) >= Math.max(1.0, 0.1 * (double)section.getLimit())) {
                                        ++disb10Sections;
                                    }
                                    ++totalSections;
                                }
                                continue;
                            }
                            for (Section section : subpart.getSections()) {
                                double sectEnrl = 0.0;
                                for (Enrollment e : section.getEnrollments(assignment)) {
                                    if (!group.matches(e.getStudent())) continue;
                                    sectEnrl += e.getRequest().getWeight();
                                }
                                double desired = enrl / (double)subpart.getSections().size();
                                disbWeight += Math.abs(sectEnrl - desired);
                                if (Math.abs(desired - sectEnrl) >= Math.max(1.0, 0.1 * desired)) {
                                    ++disb10Sections;
                                }
                                ++totalSections;
                            }
                        }
                    }
                }
                return new String[]{sPercentFormat.format(100.0 * (double)disb10Sections / (double)totalSections) + "%", sDoubleFormat.format(disbWeight / (double)totalSections)};
            }
        }, true),
        DISTANCE(new String[]{"Distance conflicts", "- students with distance conflicts", "- average distance in minutes", "Distance conflicts (SD)", "- students with distance conflicts", "- average distance in minutes"}, new String[]{"Total number of distance conflicts", "Total number of students with one or more distance conflicts", "Average distance between two classes in minutes per conflict", "Total number of distance conflicts (students needed short distances)", "Total number of SD students with one or more distance conflicts", "Average distance between two classes in minutes per conflict"}, new Statistic(){

            protected int getDistanceInMinutes(StudentSectioningModel model, RoomLocation r1, RoomLocation r2) {
                if (r1.getId().compareTo(r2.getId()) > 0) {
                    return this.getDistanceInMinutes(model, r2, r1);
                }
                if (r1.getId().equals(r2.getId()) || r1.getIgnoreTooFar() || r2.getIgnoreTooFar()) {
                    return 0;
                }
                if (r1.getPosX() == null || r1.getPosY() == null || r2.getPosX() == null || r2.getPosY() == null) {
                    return model.getDistanceMetric().getMaxTravelDistanceInMinutes();
                }
                return model.getDistanceMetric().getDistanceInMinutes(r1.getId(), r1.getPosX(), r1.getPosY(), r2.getId(), r2.getPosX(), r2.getPosY());
            }

            protected int getDistanceInMinutes(StudentSectioningModel model, Placement p1, Placement p2) {
                if (p1.isMultiRoom()) {
                    if (p2.isMultiRoom()) {
                        int dist = 0;
                        for (RoomLocation r1 : p1.getRoomLocations()) {
                            for (RoomLocation r2 : p2.getRoomLocations()) {
                                dist = Math.max(dist, this.getDistanceInMinutes(model, r1, r2));
                            }
                        }
                        return dist;
                    }
                    if (p2.getRoomLocation() == null) {
                        return 0;
                    }
                    int dist = 0;
                    for (RoomLocation r1 : p1.getRoomLocations()) {
                        dist = Math.max(dist, this.getDistanceInMinutes(model, r1, p2.getRoomLocation()));
                    }
                    return dist;
                }
                if (p2.isMultiRoom()) {
                    if (p1.getRoomLocation() == null) {
                        return 0;
                    }
                    int dist = 0;
                    for (RoomLocation r2 : p2.getRoomLocations()) {
                        dist = Math.max(dist, this.getDistanceInMinutes(model, p1.getRoomLocation(), r2));
                    }
                    return dist;
                }
                if (p1.getRoomLocation() == null || p2.getRoomLocation() == null) {
                    return 0;
                }
                return this.getDistanceInMinutes(model, p1.getRoomLocation(), p2.getRoomLocation());
            }

            public boolean inConflict(StudentSectioningModel model, Student student, Section s1, Section s2) {
                int dist;
                TimeLocation t2;
                if (s1.getPlacement() == null || s2.getPlacement() == null) {
                    return false;
                }
                TimeLocation t1 = s1.getTime();
                if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
                    return false;
                }
                int a1 = t1.getStartSlot();
                int a2 = t2.getStartSlot();
                if (student.isNeedShortDistances()) {
                    int dist2;
                    return model.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist2 = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > 0 : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > 0);
                }
                return model.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() ? (a1 + t1.getNrSlotsPerMeeting() <= a2 ? (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength()) : a2 + t2.getNrSlotsPerMeeting() <= a1 && (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a1 - a2 - t2.getLength())) : (a1 + t1.getNrSlotsPerMeeting() == a2 ? (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > t1.getBreakTime() : a2 + t2.getNrSlotsPerMeeting() == a1 && (dist = this.getDistanceInMinutes(model, s1.getPlacement(), s2.getPlacement())) > t2.getBreakTime());
            }

            public Set<DistanceConflict.Conflict> conflicts(StudentSectioningModel model, Enrollment e1) {
                HashSet<DistanceConflict.Conflict> ret = new HashSet<DistanceConflict.Conflict>();
                if (!e1.isCourseRequest()) {
                    return ret;
                }
                for (Section s1 : e1.getSections()) {
                    for (Section s2 : e1.getSections()) {
                        if (s1.getId() >= s2.getId() || !this.inConflict(model, e1.getStudent(), s1, s2)) continue;
                        ret.add(new DistanceConflict.Conflict(e1.getStudent(), e1, s1, e1, s2));
                    }
                }
                return ret;
            }

            public Set<DistanceConflict.Conflict> conflicts(StudentSectioningModel model, Enrollment e1, Enrollment e2) {
                HashSet<DistanceConflict.Conflict> ret = new HashSet<DistanceConflict.Conflict>();
                if (!(e1.isCourseRequest() && e2.isCourseRequest() && e1.getStudent().equals((Object)e2.getStudent()))) {
                    return ret;
                }
                for (Section s1 : e1.getSections()) {
                    for (Section s2 : e2.getSections()) {
                        if (!this.inConflict(model, e1.getStudent(), s1, s2)) continue;
                        ret.add(new DistanceConflict.Conflict(e1.getStudent(), e1, s1, e2, s2));
                    }
                }
                return ret;
            }

            public Set<DistanceConflict.Conflict> computeAllConflicts(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                HashSet<DistanceConflict.Conflict> ret = new HashSet<DistanceConflict.Conflict>();
                for (Request r1 : model.variables()) {
                    Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                    if (e1 == null || !(r1 instanceof CourseRequest)) continue;
                    ret.addAll(this.conflicts(model, e1));
                    for (Request r2 : r1.getStudent().getRequests()) {
                        Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                        if (e2 == null || r1.getId() >= r2.getId() || !(r2 instanceof CourseRequest)) continue;
                        ret.addAll(this.conflicts(model, e1, e2));
                    }
                }
                return ret;
            }

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                if (model.getDistanceMetric() == null) {
                    return new String[]{"N/A", "", ""};
                }
                Set<DistanceConflict.Conflict> conflicts = this.computeAllConflicts(model, assignment);
                HashSet<Student> students = new HashSet<Student>();
                HashSet<Student> studentsSD = new HashSet<Student>();
                double distance = 0.0;
                double distanceSD = 0.0;
                int total = 0;
                int totalSD = 0;
                for (DistanceConflict.Conflict conflict : conflicts) {
                    if (!group.matches(conflict.getStudent())) continue;
                    if (conflict.getStudent().isNeedShortDistances()) {
                        ++totalSD;
                        studentsSD.add(conflict.getStudent());
                        distanceSD += (double)Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)conflict.getS1().getPlacement(), (Placement)conflict.getS2().getPlacement());
                        continue;
                    }
                    ++total;
                    students.add(conflict.getStudent());
                    distance += (double)Placement.getDistanceInMinutes((DistanceMetric)model.getDistanceMetric(), (Placement)conflict.getS1().getPlacement(), (Placement)conflict.getS2().getPlacement());
                }
                return new String[]{sIntFormat.format(total), sIntFormat.format(students.size()), total == 0 ? "" : sDoubleFormat.format(distance / (double)total), sIntFormat.format(totalSD), sIntFormat.format(studentsSD.size()), totalSD == 0 ? "" : sDoubleFormat.format(distanceSD / (double)totalSD)};
            }
        }, true),
        OVERLAP(new String[]{"Free time conflict", "- students in conflict", "- average minutes", "Course time conflict", "- students in conflict", "- average minutes", "Teaching conflicts", "- students in conflict", "- average minutes"}, new String[]{"Total number of free time conflicts", "Total number of students with a free time conflict", "For students with a free time conflict, the average number of overlapping minutes per student", "Total number of course time conflicts", "Total number of students with a course time conflict", "For students with a course time conflict, the average number of overlapping minutes per student", "Total number of teaching time conflicts", "Total number of students with a teaching conflict", "For students with a teaching time conflict, the average number of overlapping minutes per student"}, new Statistic(){

            public boolean inConflict(SctAssignment a1, SctAssignment a2) {
                if (a1.getTime() == null || a2.getTime() == null) {
                    return false;
                }
                if (a1 instanceof Section && a2 instanceof Section && ((Section)a1).isToIgnoreStudentConflictsWith(a2.getId())) {
                    return false;
                }
                return a1.getTime().hasIntersection(a2.getTime());
            }

            public int share(SctAssignment a1, SctAssignment a2) {
                if (!this.inConflict(a1, a2)) {
                    return 0;
                }
                return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
            }

            public Set<TimeOverlapsCounter.Conflict> conflicts(Enrollment e1, Enrollment e2) {
                HashSet<TimeOverlapsCounter.Conflict> ret = new HashSet<TimeOverlapsCounter.Conflict>();
                if (!e1.getStudent().equals((Object)e2.getStudent())) {
                    return ret;
                }
                if (e1.getRequest() instanceof FreeTimeRequest && e2.getRequest() instanceof FreeTimeRequest) {
                    return ret;
                }
                for (SctAssignment s1 : e1.getAssignments()) {
                    for (SctAssignment s2 : e2.getAssignments()) {
                        if (!this.inConflict(s1, s2)) continue;
                        ret.add(new TimeOverlapsCounter.Conflict(e1.getStudent(), this.share(s1, s2), e1, s1, e2, s2));
                    }
                }
                return ret;
            }

            public Set<TimeOverlapsCounter.Conflict> computeAllConflicts(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                HashSet<TimeOverlapsCounter.Conflict> ret = new HashSet<TimeOverlapsCounter.Conflict>();
                for (Request r1 : model.variables()) {
                    Enrollment e1 = (Enrollment)assignment.getValue((Variable)r1);
                    if (e1 == null || r1 instanceof FreeTimeRequest) continue;
                    for (Request r2 : r1.getStudent().getRequests()) {
                        Enrollment e2 = (Enrollment)assignment.getValue((Variable)r2);
                        if (r2 instanceof FreeTimeRequest) {
                            FreeTimeRequest ft = (FreeTimeRequest)r2;
                            ret.addAll(this.conflicts(e1, ft.createEnrollment()));
                            continue;
                        }
                        if (e2 == null || r1.getId() >= r2.getId()) continue;
                        ret.addAll(this.conflicts(e1, e2));
                    }
                    for (Unavailability unavailability : e1.getStudent().getUnavailabilities()) {
                        for (SctAssignment section : e1.getAssignments()) {
                            if (!this.inConflict(section, (SctAssignment)unavailability)) continue;
                            ret.add(new TimeOverlapsCounter.Conflict(e1.getStudent(), this.share(section, (SctAssignment)unavailability), e1, section, unavailability.createEnrollment(), (SctAssignment)unavailability));
                        }
                    }
                }
                return ret;
            }

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                HashSet<Student> timeFt = new HashSet<Student>();
                HashSet<Student> timeCourse = new HashSet<Student>();
                HashSet<Student> timeUnav = new HashSet<Student>();
                int ftMin = 0;
                int courseMin = 0;
                int unavMin = 0;
                int totFt = 0;
                int totCourse = 0;
                int totUn = 0;
                Set<TimeOverlapsCounter.Conflict> conf = this.computeAllConflicts(model, assignment);
                for (TimeOverlapsCounter.Conflict c : conf) {
                    if (!group.matches(c.getStudent())) continue;
                    if (c.getR1() instanceof CourseRequest && c.getR2() instanceof CourseRequest) {
                        ++totCourse;
                        courseMin += 5 * c.getShare();
                        timeCourse.add(c.getStudent());
                        continue;
                    }
                    if (c.getS2() instanceof Unavailability) {
                        ++totUn;
                        unavMin += 5 * c.getShare();
                        timeUnav.add(c.getStudent());
                        continue;
                    }
                    ++totFt;
                    ftMin += 5 * c.getShare();
                    timeFt.add(c.getStudent());
                }
                return new String[]{sIntFormat.format(totFt), sIntFormat.format(timeFt.size()), timeFt.isEmpty() ? "" : sDoubleFormat.format((double)ftMin / (double)timeFt.size()), sIntFormat.format(totCourse), sIntFormat.format(timeCourse.size()), timeCourse.isEmpty() ? "" : sDoubleFormat.format((double)courseMin / (double)timeCourse.size()), sIntFormat.format(totUn), sIntFormat.format(timeUnav.size()), timeUnav.isEmpty() ? "" : sDoubleFormat.format((double)unavMin / (double)timeUnav.size())};
            }
        }, true),
        CREDITS(new String[]{"Students requesting 12+ credits", "- 12+ credits assigned", "Students requesting 15+ credits", "- 15+ credits assigned"}, new String[]{"Total number of students requesting 12 or more credit hours", "Out of these, the percentage of students having 12 or more credits assigned", "Total number of students requesting 15 or more credit hours", "Out of these, the percentage of students having 15 or more credits assigned"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int total12 = 0;
                int assigned12 = 0;
                int total15 = 0;
                int assigned15 = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student)) continue;
                    float credit = 0.0f;
                    float assignedCredit = 0.0f;
                    for (Request r : student.getRequests()) {
                        Enrollment e;
                        if (!(r instanceof CourseRequest)) continue;
                        CourseRequest cr = (CourseRequest)r;
                        if (!cr.isAlternative()) {
                            Course c = (Course)cr.getCourses().get(0);
                            credit = c.hasCreditValue() ? (credit += c.getCreditValue().floatValue()) : (credit += cr.getMinCredit());
                        }
                        if ((e = (Enrollment)cr.getAssignment(assignment)) == null) continue;
                        assignedCredit += e.getCredit();
                    }
                    if (credit >= 12.0f) {
                        ++total12;
                        if (assignedCredit >= 12.0f) {
                            ++assigned12;
                        }
                    }
                    if (!(credit >= 15.0f)) continue;
                    ++total15;
                    if (!(assignedCredit >= 15.0f)) continue;
                    ++assigned15;
                }
                return new String[]{sIntFormat.format(total12), total12 == 0 ? "" : sPercentFormat.format(100.0 * (double)assigned12 / (double)total12) + "%", sIntFormat.format(total15), total15 == 0 ? "" : sPercentFormat.format(100.0 * (double)assigned15 / (double)total15) + "%"};
            }
        }, true),
        F2F(new String[]{"Residential Students", "Arranged Hours Assignments", "- percentage of all assignments", "Online Assignments", "- percentage of all assignments", "Students with no face-to-face classes", "- percentage of all undergrad students", "Students with <50% classes face-to-face", "- percentage of all undergrad students"}, new String[]{"Number of students that are NOT online-only (only residential students are counted in the following numbers)", "Number of class assignments that are Arranged Hours", "Percentage of all class assignments", "Number of class assignments that are Online (no time, time with no room, or time with ONLINE room)", "Percentage of all class assignments", "Total number of undergraduate students with no face-to-face classes.", "Percentage of all undergraduate students", "Total number of undergraduate students with less than half of their schedule face-to-face.", "Percentage of all undergraduate students"}, new Statistic(){

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int arrClass = 0;
                int onlineClass = 0;
                int allClass = 0;
                int residentialStudents = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student) || !FILTER_ALL_RES.matches(student)) continue;
                    ++residentialStudents;
                    for (Request r : student.getRequests()) {
                        Enrollment e = (Enrollment)r.getAssignment(assignment);
                        if (e == null || !e.isCourseRequest()) continue;
                        for (Section section : e.getSections()) {
                            if (section.isOnline()) {
                                ++onlineClass;
                            }
                            if (section.getTime() == null) {
                                ++arrClass;
                            }
                            ++allClass;
                        }
                    }
                }
                int online = 0;
                int half = 0;
                int total = 0;
                for (Student student : model.getStudents()) {
                    if (!group.matches(student) || !FILTER_ALL_RES.matches(student)) continue;
                    boolean gr = false;
                    for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
                        if (!acm.getClassification().startsWith("G") && !acm.getClassification().startsWith("P")) continue;
                        gr = true;
                    }
                    if (gr) continue;
                    int sections = 0;
                    int onlineSections = 0;
                    for (Request r : student.getRequests()) {
                        Enrollment e;
                        if (!(r instanceof CourseRequest) || (e = (Enrollment)r.getAssignment(assignment)) == null) continue;
                        for (Section s : e.getSections()) {
                            ++sections;
                            if (!s.isOnline()) continue;
                            ++onlineSections;
                        }
                    }
                    if (sections <= 0) continue;
                    ++total;
                    if (onlineSections == sections) {
                        ++online;
                    }
                    if (!((double)onlineSections > 0.5 * (double)sections)) continue;
                    ++half;
                }
                return new String[]{sIntFormat.format(residentialStudents), residentialStudents == 0 ? "" : sIntFormat.format(arrClass), residentialStudents == 0 ? "" : sPercentFormat.format(100.0 * (double)arrClass / (double)allClass) + "%", onlineClass == 0 ? "" : sIntFormat.format(onlineClass), onlineClass == 0 ? "" : sPercentFormat.format(100.0 * (double)onlineClass / (double)allClass) + "%", online == 0 ? "" : sIntFormat.format(online), online == 0 ? "" : sPercentFormat.format(100.0 * (double)online / (double)total) + "%", half == 0 ? "" : sIntFormat.format(half), half == 0 ? "" : sPercentFormat.format(100.0 * (double)half / (double)total) + "%"};
            }
        }, true),
        FULL_OFFERINGS(new String[]{"Full Offerings", "- percentage of all requested offerings", "- percentage of all assignments", "Offerings with \u2264 2% available", "- percentage of all requested offerings", "- percentage of all assignments", "Offerings with \u2264 5% available", "- percentage of all requested offerings", "- percentage of all assignments", "Offerings with \u2264 10% available", "- percentage of all requested offerings", "- percentage of all assignments", "Full Sections", "- percentage of all sections", "- percentage of all assignments", "Disabled Sections", "- percentage of all sections", "- percentage of all assignments", "Sections with \u2264 2% available", "- percentage of all sections", "- percentage of all assignments", "Sections with \u2264 5% available", "- percentage of all sections", "- percentage of all assignments", "Sections with \u2264 10% available", "- percentage of all sections", "- percentage of all assignments"}, new String[]{"Number of instructional offerings that are completely full (only counting courses that are requested by the students)", "Percentage full offerings vs all requested offerings", "Percentage of all course assignments that are for courses that are full", "Number of instructional offerings that have 2% or less space available", "", "", "Number of instructional offerings that have 5% or less space available", "", "", "Number of instructional offerings that have 10% or less space available", "", "", "Number of sections that have no space available (only counting sections from courses that are requested by the students)", "Percentage full sections vs all sections of the requested courses", "Percentage of all class assignments that are in sections that are full", "Number of sections that are disabled", "Percentage disabled sections vs all sections of the requested courses", "Percentage of all class assignments that are in sections that are disabled", "Number of sections that have 2% or less space available", "", "", "Number of sections that have 5% or less space available", "", "", "Number of sections that have 10% or less space available", "", ""}, new Statistic(){

            protected int getEnrollments(StudentGroup group, Section section, Assignment<Request, Enrollment> assignment) {
                int enrl = 0;
                for (Enrollment e : section.getEnrollments(assignment)) {
                    if (!group.matches(e.getStudent())) continue;
                    ++enrl;
                }
                return enrl;
            }

            protected int getEnrollments(StudentGroup group, Config config, Assignment<Request, Enrollment> assignment) {
                int enrl = 0;
                for (Enrollment e : config.getEnrollments(assignment)) {
                    if (!group.matches(e.getStudent())) continue;
                    ++enrl;
                }
                return enrl;
            }

            @Override
            public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
                int nbrSections = 0;
                int nbrFullSections = 0;
                int nbrSections98 = 0;
                int nbrSections95 = 0;
                int nbrSections90 = 0;
                int nbrSectionsDis = 0;
                int enrlSections = 0;
                int enrlFullSections = 0;
                int enrlSections98 = 0;
                int enrlSections95 = 0;
                int enrlSections90 = 0;
                int enrlSectionsDis = 0;
                int nbrOfferings = 0;
                int nbrFullOfferings = 0;
                int nbrOfferings98 = 0;
                int nbrOfferings95 = 0;
                int nbrOfferings90 = 0;
                int enrlOfferings = 0;
                int enrlOfferingsFull = 0;
                int enrlOfferings98 = 0;
                int enrlOfferings95 = 0;
                int enrlOfferings90 = 0;
                for (Offering offering : model.getOfferings()) {
                    if (group == StudentGroup.ALL) {
                        // empty if block
                    }
                    int crs = 0;
                    for (Course course : offering.getCourses()) {
                        for (CourseRequest cr : course.getRequests()) {
                            if (!group.matches(cr.getStudent())) continue;
                            ++crs;
                        }
                    }
                    if (crs == 0) continue;
                    int offeringLimit = 0;
                    int offeringEnrollment = 0;
                    int offeringMatchingEnrollment = 0;
                    for (Config config : offering.getConfigs()) {
                        int configLimit = config.getLimit();
                        for (Subpart subpart : config.getSubparts()) {
                            int subpartLimit = 0;
                            for (Section section : subpart.getSections()) {
                                int matchingEnrl;
                                if (section.isCancelled()) continue;
                                int enrl = section.getEnrollments(assignment).size();
                                int n = matchingEnrl = group == StudentGroup.ALL ? section.getEnrollments(assignment).size() : this.getEnrollments(group, section, assignment);
                                subpartLimit = section.getLimit() < 0 || subpartLimit < 0 ? -1 : (subpartLimit += section.isEnabled() ? section.getLimit() : enrl);
                                ++nbrSections;
                                enrlSections += matchingEnrl;
                                if (section.getLimit() >= 0 && section.getLimit() <= enrl) {
                                    ++nbrFullSections;
                                    enrlFullSections += matchingEnrl;
                                }
                                if (!section.isEnabled()) {
                                    ++nbrSectionsDis;
                                    enrlSectionsDis += matchingEnrl;
                                }
                                if (section.getLimit() >= 0 && (long)(section.getLimit() - enrl) <= Math.round(0.02 * (double)section.getLimit())) {
                                    ++nbrSections98;
                                    enrlSections98 += matchingEnrl;
                                }
                                if (section.getLimit() >= 0 && (long)(section.getLimit() - enrl) <= Math.round(0.05 * (double)section.getLimit())) {
                                    ++nbrSections95;
                                    enrlSections95 += matchingEnrl;
                                }
                                if (section.getLimit() < 0 || (long)(section.getLimit() - enrl) > Math.round(0.1 * (double)section.getLimit())) continue;
                                ++nbrSections90;
                                enrlSections90 += matchingEnrl;
                            }
                            if (configLimit < 0 || subpartLimit < 0) {
                                configLimit = -1;
                                continue;
                            }
                            configLimit = Math.min(configLimit, subpartLimit);
                        }
                        offeringLimit = offeringLimit < 0 || configLimit < 0 ? -1 : (offeringLimit += configLimit);
                        offeringEnrollment += config.getEnrollments(assignment).size();
                        offeringMatchingEnrollment += group == StudentGroup.ALL ? config.getEnrollments(assignment).size() : this.getEnrollments(group, config, assignment);
                    }
                    ++nbrOfferings;
                    enrlOfferings += offeringMatchingEnrollment;
                    if (offeringLimit >= 0 && offeringEnrollment >= offeringLimit) {
                        ++nbrFullOfferings;
                        enrlOfferingsFull += offeringMatchingEnrollment;
                    }
                    if (offeringLimit >= 0 && (long)(offeringLimit - offeringEnrollment) <= Math.round(0.02 * (double)offeringLimit)) {
                        ++nbrOfferings98;
                        enrlOfferings98 += offeringMatchingEnrollment;
                    }
                    if (offeringLimit >= 0 && (long)(offeringLimit - offeringEnrollment) <= Math.round(0.05 * (double)offeringLimit)) {
                        ++nbrOfferings95;
                        enrlOfferings95 += offeringMatchingEnrollment;
                    }
                    if (offeringLimit < 0 || (long)(offeringLimit - offeringEnrollment) > Math.round(0.1 * (double)offeringLimit)) continue;
                    ++nbrOfferings90;
                    enrlOfferings90 += offeringMatchingEnrollment;
                }
                return new String[]{sIntFormat.format(nbrFullOfferings), sPercentFormat.format(100.0 * (double)nbrFullOfferings / (double)nbrOfferings) + "%", sPercentFormat.format(100.0 * (double)enrlOfferingsFull / (double)enrlOfferings) + "%", sIntFormat.format(nbrOfferings98), sPercentFormat.format(100.0 * (double)nbrOfferings98 / (double)nbrOfferings) + "%", sPercentFormat.format(100.0 * (double)enrlOfferings98 / (double)enrlOfferings) + "%", sIntFormat.format(nbrOfferings95), sPercentFormat.format(100.0 * (double)nbrOfferings95 / (double)nbrOfferings) + "%", sPercentFormat.format(100.0 * (double)enrlOfferings95 / (double)enrlOfferings) + "%", sIntFormat.format(nbrOfferings90), sPercentFormat.format(100.0 * (double)nbrOfferings90 / (double)nbrOfferings) + "%", sPercentFormat.format(100.0 * (double)enrlOfferings90 / (double)enrlOfferings) + "%", sIntFormat.format(nbrFullSections), sPercentFormat.format(100.0 * (double)nbrFullSections / (double)nbrSections) + "%", sPercentFormat.format(100.0 * (double)enrlFullSections / (double)enrlSections) + "%", sIntFormat.format(nbrSectionsDis), sPercentFormat.format(100.0 * (double)nbrSectionsDis / (double)nbrSections) + "%", sPercentFormat.format(100.0 * (double)enrlSectionsDis / (double)enrlSections) + "%", sIntFormat.format(nbrSections98), sPercentFormat.format(100.0 * (double)nbrSections98 / (double)nbrSections) + "%", sPercentFormat.format(100.0 * (double)enrlSections98 / (double)enrlSections) + "%", sIntFormat.format(nbrSections95), sPercentFormat.format(100.0 * (double)nbrSections95 / (double)nbrSections) + "%", sPercentFormat.format(100.0 * (double)enrlSections95 / (double)enrlSections) + "%", sIntFormat.format(nbrSections90), sPercentFormat.format(100.0 * (double)nbrSections90 / (double)nbrSections) + "%", sPercentFormat.format(100.0 * (double)enrlSections90 / (double)enrlSections) + "%"};
            }
        });

        String[] iNames;
        String[] iNotes;
        Statistic iStatistic;
        boolean iNewLine = false;

        private Statistics(String[] names, String[] notes, Statistic stat, boolean nl) {
            this.iNames = names;
            this.iNotes = notes;
            this.iStatistic = stat;
            this.iNewLine = nl;
        }

        private Statistics(String name, String note, Statistic stat, boolean nl) {
            this(new String[]{name}, new String[]{note}, stat, nl);
        }

        private Statistics(String[] names, String[] notes, Statistic stat) {
            this(names, notes, stat, false);
        }

        private Statistics(String name, String note, Statistic stat) {
            this(name, note, stat, false);
        }

        public String[] getNames() {
            return this.iNames;
        }

        public String[] getNotes() {
            return this.iNotes;
        }

        public String[] getValues(StudentGroup group, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
            return this.iStatistic.getValues(group, model, assignment);
        }

        public boolean isNewLine() {
            return this.iNewLine;
        }
    }

    public static interface Statistic {
        public String[] getValues(StudentGroup var1, StudentSectioningModel var2, Assignment<Request, Enrollment> var3);
    }

    public static enum StudentGroup implements StudentFilter
    {
        ALL("All Students", StudentSchedulingSolutionStatisticsReport.access$000()),
        DUMMY("Projected", new DummyFilter()),
        PRIORITY("Priority", new AndFilter(new PriorityFilter(Student.StudentPriority.Priority), StudentSchedulingSolutionStatisticsReport.access$000())),
        SENIOR("Seniors", new AndFilter(new PriorityFilter(Student.StudentPriority.Senior), StudentSchedulingSolutionStatisticsReport.access$000())),
        JUNIOR("Juniors", new AndFilter(new PriorityFilter(Student.StudentPriority.Junior), StudentSchedulingSolutionStatisticsReport.access$000())),
        SOPHOMORE("Sophomores", new AndFilter(new PriorityFilter(Student.StudentPriority.Sophomore), StudentSchedulingSolutionStatisticsReport.access$000())),
        FRESHMEN("Freshmen", new AndFilter(new PriorityFilter(Student.StudentPriority.Freshmen), StudentSchedulingSolutionStatisticsReport.access$000())),
        NORMAL("Non-priority", new AndFilter(new PriorityFilter(Student.StudentPriority.Normal), StudentSchedulingSolutionStatisticsReport.access$000())),
        REBATCH("RE-BATCH", new AndFilter(new GroupFilter("RE-BATCH"), StudentSchedulingSolutionStatisticsReport.access$100())),
        ONLINE("Online", new AndFilter(new OnlineFilter(), StudentSchedulingSolutionStatisticsReport.access$000())),
        GR_SCONTONL("SCONTONL", new AndFilter(new GroupFilter("SCONTONL"), StudentSchedulingSolutionStatisticsReport.access$000())),
        GR_SCOVIDONL("SCOVIDONL", new AndFilter(new GroupFilter("SCOVIDONL"), StudentSchedulingSolutionStatisticsReport.access$000())),
        GR_SCOVIDPMPE("SCOVIDPMPE", new AndFilter(new GroupFilter("SCOVIDPMPE"), StudentSchedulingSolutionStatisticsReport.access$000())),
        PREREG("PREREG", new AndFilter(new GroupFilter("PREREG"), StudentSchedulingSolutionStatisticsReport.access$100(), new NotFilter(new StarFilter()))),
        STAR("STAR", new AndFilter(new StarFilter(), StudentSchedulingSolutionStatisticsReport.access$100(), new NotFilter(new GroupFilter("RE-BATCH")))),
        GR_STAR("On-campus STAR", new AndFilter(new GroupFilter("STAR"), StudentSchedulingSolutionStatisticsReport.access$100(), new NotFilter(new GroupFilter("RE-BATCH")))),
        GR_VSTAR("Virtual STAR", new AndFilter(new GroupFilter("VSTAR"), StudentSchedulingSolutionStatisticsReport.access$100(), new NotFilter(new GroupFilter("RE-BATCH")))),
        OTHER("Other", new AndFilter(StudentSchedulingSolutionStatisticsReport.access$100(), new NotFilter(new GroupFilter("RE-BATCH")), new NotFilter(new GroupFilter("PREREG")), new NotFilter(new StarFilter())));

        String iName;
        StudentFilter iFilter;

        private StudentGroup(String name, StudentFilter filter) {
            this.iName = name;
            this.iFilter = filter;
        }

        public String getName() {
            return this.iName;
        }

        @Override
        public boolean matches(Student student) {
            return this.iFilter.matches(student);
        }
    }

    public static class StarFilter
    implements StudentFilter {
        @Override
        public boolean matches(Student student) {
            for (org.cpsolver.studentsct.model.StudentGroup aac : student.getGroups()) {
                if (aac.getReference() != null && aac.getReference().startsWith("STAR")) {
                    return true;
                }
                if (aac.getReference() == null || !aac.getReference().startsWith("VSTAR")) continue;
                return true;
            }
            return false;
        }
    }

    public static class OnlineLateFilter
    extends OnlineFilter {
        @Override
        public boolean matches(Student student) {
            if (!super.matches(student)) {
                return false;
            }
            boolean hasOL = false;
            boolean hasRS = false;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                for (Course c : cr.getCourses()) {
                    if (c.getName().matches(".* [0-9]+I?OL(\\-[A-Za-z]+)?")) {
                        hasOL = true;
                        continue;
                    }
                    hasRS = true;
                }
            }
            return hasRS && !hasOL;
        }
    }

    public static class OnlineFilter
    implements StudentFilter {
        @Override
        public boolean matches(Student student) {
            for (org.cpsolver.studentsct.model.StudentGroup aac : student.getGroups()) {
                if ("SCOVIDONL".equalsIgnoreCase(aac.getReference())) {
                    return true;
                }
                if ("SCONTONL".equalsIgnoreCase(aac.getReference())) {
                    return true;
                }
                if (!"SCOVIDPMPE".equalsIgnoreCase(aac.getReference())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DummyOrNoRequestsFilter
    implements StudentFilter {
        @Override
        public boolean matches(Student student) {
            return student.isDummy() || student.getRequests().isEmpty();
        }
    }

    public static class DummyFilter
    implements StudentFilter {
        @Override
        public boolean matches(Student student) {
            return student.isDummy();
        }
    }

    public static class PriorityFilter
    implements StudentFilter {
        private Student.StudentPriority iPriority;

        public PriorityFilter(Student.StudentPriority p) {
            this.iPriority = p;
        }

        @Override
        public boolean matches(Student student) {
            return student.getPriority() == this.iPriority;
        }
    }

    public static class GroupFilter
    implements StudentFilter {
        private String iGroup;

        public GroupFilter(String group) {
            this.iGroup = group;
        }

        @Override
        public boolean matches(Student student) {
            for (org.cpsolver.studentsct.model.StudentGroup g : student.getGroups()) {
                if (!this.iGroup.equalsIgnoreCase(g.getReference())) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndFilter
    implements StudentFilter {
        StudentFilter[] iFilters;

        public AndFilter(StudentFilter ... filters) {
            this.iFilters = filters;
        }

        @Override
        public boolean matches(Student student) {
            for (StudentFilter filter : this.iFilters) {
                if (filter.matches(student)) continue;
                return false;
            }
            return true;
        }
    }

    public static class OrFilter
    implements StudentFilter {
        StudentFilter[] iFilters;

        public OrFilter(StudentFilter ... filters) {
            this.iFilters = filters;
        }

        @Override
        public boolean matches(Student student) {
            for (StudentFilter filter : this.iFilters) {
                if (!filter.matches(student)) continue;
                return true;
            }
            return false;
        }
    }

    public static class NotFilter
    implements StudentFilter {
        StudentFilter iFilter;

        public NotFilter(StudentFilter filter) {
            this.iFilter = filter;
        }

        @Override
        public boolean matches(Student student) {
            return !this.iFilter.matches(student);
        }
    }

    public static interface StudentFilter {
        public boolean matches(Student var1);
    }
}

