/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.UniTimePrincipal;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

@GwtRpcImplements(value=SectioningStatusFilterBox.SectioningStatusFilterRpcRequest.class)
public class SectioningStatusFilterBackend
implements GwtRpcImplementation<SectioningStatusFilterBox.SectioningStatusFilterRpcRequest, EventInterface.FilterRpcResponse> {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static Logger sLog = Logger.getLogger(SectioningStatusFilterBackend.class);
    @Autowired
    private SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    private SolverServerService solverServerService;

    @Override
    public EventInterface.FilterRpcResponse execute(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest request, SessionContext context) {
        try {
            boolean online = "true".equals(request.getOption("online"));
            if (context.isAuthenticated()) {
                request.setOption("user", context.getUser().getExternalUserId());
                if (context.getUser().getCurrentAuthority() != null && context.getUser().getCurrentAuthority().hasRight(Right.ConsentApproval)) {
                    request.setOption("approval", "true");
                }
                if (context.getUser().getCurrentAuthority() != null) {
                    request.setOption("role", context.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId(context);
                OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
                if (server == null) {
                    ProxyHolder h = (ProxyHolder)context.getAttribute(SessionAttribute.OnlineSchedulingDummyServer);
                    if (h != null && h.isValid(sessionId)) {
                        server = (OnlineSectioningServer)h.getProxy();
                    } else {
                        Session session = (Session)SessionDAO.getInstance().get(sessionId);
                        if (session == null) {
                            throw new SectioningException(MSG.exceptionBadSession());
                        }
                        server = new DatabaseServer(new AcademicSessionInfo(session), false);
                        context.setAttribute(SessionAttribute.OnlineSchedulingDummyServer, new ProxyHolder<Long, OnlineSectioningServer>(sessionId, server));
                    }
                }
                context.checkPermission(server.getAcademicSession().getUniqueId(), "Session", Right.SchedulingDashboard);
                request.setSessionId(server.getAcademicSession().getUniqueId());
                return server.execute(server.createAction(SectioningStatusFilterAction.class).forRequest(request), this.currentUser(context));
            }
            OnlineSectioningServer server = this.studentSectioningSolverService.getSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            context.checkPermission(server.getAcademicSession().getUniqueId(), "Session", Right.StudentSectioningSolverDashboard);
            request.setSessionId(server.getAcademicSession().getUniqueId());
            return server.execute(server.createAction(SectioningStatusFilterAction.class).forRequest(request), this.currentUser(context));
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private Long getStatusPageSessionId(SessionContext context) throws SectioningException, PageAccessException {
        UserContext user = context.getUser();
        if (user == null) {
            throw new PageAccessException(context.isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (user.getCurrentAcademicSessionId() == null) {
            Long sessionId = (Long)context.getAttribute(SessionAttribute.OnlineSchedulingLastSession);
            if (sessionId != null) {
                return sessionId;
            }
        } else {
            return user.getCurrentAcademicSessionId();
        }
        throw new SectioningException(MSG.exceptionNoAcademicSession());
    }

    private OnlineSectioningLog.Entity currentUser(SessionContext context) {
        UserContext user = context.getUser();
        UniTimePrincipal principal = (UniTimePrincipal)context.getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (user != null) {
            return OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getTrueExternalUserId()).setName(user.getTrueName() == null ? user.getUsername() : user.getTrueName()).setType(context.hasPermission(Right.StudentSchedulingAdvisor) ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT).build();
        }
        if (principal != null) {
            return OnlineSectioningLog.Entity.newBuilder().setExternalId(principal.getExternalId()).setName(principal.getName()).setType(OnlineSectioningLog.Entity.EntityType.STUDENT).build();
        }
        return null;
    }
}

