/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.criterion.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.Formats;

@Service(value="gwtAdminTable[type=sectioning]")
public class StudentSchedulingStatusTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentSchedulingStatusType(), MESSAGES.pageStudentSchedulingStatusTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypes')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        SimpleEditInterface.Field[] fields = new SimpleEditInterface.Field[courseTypes.isEmpty() ? 9 + StatusOption.values().length : 10 + StatusOption.values().length + courseTypes.size()];
        int idx = 0;
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE);
        for (StatusOption t : StatusOption.values()) {
            fields[idx++] = new SimpleEditInterface.Field(t.getLabel(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldMessage(), SimpleEditInterface.FieldType.textarea, 40, 500, new SimpleEditInterface.Flag[0]);
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                fields[idx++] = new SimpleEditInterface.Field(((CourseType)courseTypes.get(i)).getReference(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
            }
            fields[idx++] = new SimpleEditInterface.Field(MESSAGES.toggleNoCourseType(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        }
        ArrayList<SimpleEditInterface.ListItem> fallbacks = new ArrayList<SimpleEditInterface.ListItem>();
        List<StudentSectioningStatus> statuses = StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId());
        fallbacks.add(new SimpleEditInterface.ListItem("", ""));
        for (StudentSectioningStatus status : statuses) {
            fallbacks.add(new SimpleEditInterface.ListItem(status.getUniqueId().toString(), status.getLabel()));
        }
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveStartDate(), SimpleEditInterface.FieldType.date, 80, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveStartTime(), SimpleEditInterface.FieldType.time, 50, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveEndDate(), SimpleEditInterface.FieldType.date, 80, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusEffectiveEndTime(), SimpleEditInterface.FieldType.time, 50, new SimpleEditInterface.Flag[0]);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldStudentStatusFallback(), SimpleEditInterface.FieldType.list, 100, fallbacks, SimpleEditInterface.Flag.NO_CYCLE);
        fields[idx++] = new SimpleEditInterface.Field(MESSAGES.fieldSession(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]);
        SimpleEditInterface data = new SimpleEditInterface(fields);
        data.setSortBy(0, 1);
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        for (StudentSectioningStatus status : statuses) {
            SimpleEditInterface.Record r = data.addRecord(status.getUniqueId());
            idx = 0;
            r.setField(idx++, status.getReference());
            r.setField(idx++, status.getLabel());
            for (StatusOption t : StatusOption.values()) {
                r.setField(idx++, status.hasOption(t.getOption()) ? "true" : "false");
            }
            r.setField(idx++, status.getMessage());
            if (!courseTypes.isEmpty()) {
                for (int i = 0; i < courseTypes.size(); ++i) {
                    r.setField(idx++, status.getTypes().contains(courseTypes.get(i)) ? "true" : "false");
                }
                r.setField(idx++, status.hasOption(StudentSectioningStatus.Option.notype) ? "false" : "true");
            }
            r.setField(idx++, status.getEffectiveStartDate() == null ? "" : dateFormat.format(status.getEffectiveStartDate()));
            r.setField(idx++, status.getEffectiveStartPeriod() == null ? "" : status.getEffectiveStartPeriod().toString());
            r.setField(idx++, status.getEffectiveStopDate() == null ? "" : dateFormat.format(status.getEffectiveStopDate()));
            r.setField(idx++, status.getEffectiveStopPeriod() == null ? "" : status.getEffectiveStopPeriod().toString());
            r.setField(idx++, status.getFallBackStatus() == null ? "" : status.getFallBackStatus().getUniqueId().toString());
            r.setField(idx++, status.getSession() == null ? "false" : "true");
        }
        data.setEditable(context.hasPermission(Right.StudentSchedulingStatusTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (StudentSectioningStatus status : StudentSectioningStatus.findAll(context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(status.getUniqueId());
            if (r == null) {
                this.delete(status, context, hibSession);
                continue;
            }
            this.update(status, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        StudentSectioningStatus status = new StudentSectioningStatus();
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        status.setTypes(new HashSet<CourseType>());
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                if (!"true".equals(record.getField(3 + StatusOption.values().length + i))) continue;
                status.getTypes().add((CourseType)courseTypes.get(i));
            }
            if (!"true".equals(record.getField(3 + StatusOption.values().length + courseTypes.size()))) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
        }
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        int idx = courseTypes.isEmpty() ? 3 + StatusOption.values().length : 4 + StatusOption.values().length + courseTypes.size();
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        Date startDate = null;
        try {
            startDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Integer startTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        ++idx;
        Date endDate = null;
        try {
            endDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Integer endTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        Long fallBackId = record.getField(++idx) == null || record.getField(idx).isEmpty() ? null : Long.valueOf(record.getField(idx));
        boolean session = "true".equals(record.getField(++idx));
        ++idx;
        status.setEffectiveStartDate(startDate);
        status.setEffectiveStartPeriod(startTime);
        status.setEffectiveStopDate(endDate);
        status.setEffectiveStopPeriod(endTime);
        status.setFallBackStatus(fallBackId == null ? null : (StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(fallBackId, hibSession));
        status.setSession(session ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : null);
        record.setUniqueId((Long)hibSession.save((Object)status));
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel() + (status.getSession() == null ? " (global)" : " (" + status.getSession().getLabel() + ")"), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(StudentSectioningStatus status, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (status == null) {
            return;
        }
        int value = 0;
        for (int i = 0; i < StatusOption.values().length; ++i) {
            if (!"true".equals(record.getField(2 + i))) continue;
            value += StatusOption.values()[i].getOption().toggle();
        }
        HashSet<CourseType> types = new HashSet<CourseType>();
        List courseTypes = CourseTypeDAO.getInstance().findAll(Order.asc((String)"reference"));
        if (!courseTypes.isEmpty()) {
            for (int i = 0; i < courseTypes.size(); ++i) {
                if (!"true".equals(record.getField(3 + StatusOption.values().length + i))) continue;
                types.add((CourseType)courseTypes.get(i));
            }
            if (!"true".equals(record.getField(3 + StatusOption.values().length + courseTypes.size()))) {
                value += StudentSectioningStatus.Option.notype.toggle();
            }
        }
        int idx = courseTypes.isEmpty() ? 3 + StatusOption.values().length : 4 + StatusOption.values().length + courseTypes.size();
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        Date startDate = null;
        try {
            startDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Integer startTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        ++idx;
        Date endDate = null;
        try {
            endDate = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : dateFormat.parse(record.getField(idx));
            ++idx;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Integer endTime = record.getField(idx) == null || record.getField(idx).isEmpty() ? null : Integer.valueOf(record.getField(idx));
        Long fallBackId = record.getField(++idx) == null || record.getField(idx).isEmpty() ? null : Long.valueOf(record.getField(idx));
        boolean session = "true".equals(record.getField(++idx));
        ++idx;
        boolean changed = !ToolBox.equals((Object)status.getReference(), (Object)record.getField(0)) || !ToolBox.equals((Object)status.getLabel(), (Object)record.getField(1)) || !ToolBox.equals((Object)status.getStatus(), (Object)value) || !ToolBox.equals(status.getTypes(), types) || !ToolBox.equals((Object)status.getMessage(), (Object)record.getField(2 + StatusOption.values().length)) || !ToolBox.equals((Object)status.getEffectiveStartDate(), (Object)startDate) || !ToolBox.equals((Object)status.getEffectiveStartPeriod(), (Object)startTime) || !ToolBox.equals((Object)status.getEffectiveStopDate(), (Object)endDate) || !ToolBox.equals((Object)status.getEffectiveStopPeriod(), (Object)endTime) || !ToolBox.equals((Object)(status.getFallBackStatus() == null ? null : status.getFallBackStatus().getUniqueId()), (Object)fallBackId) || session && status.getSession() == null || !session && status.getSession() != null;
        status.setReference(record.getField(0));
        status.setLabel(record.getField(1));
        status.setStatus(value);
        status.setTypes(types);
        status.setMessage(record.getField(2 + StatusOption.values().length));
        status.setEffectiveStartDate(startDate);
        status.setEffectiveStartPeriod(startTime);
        status.setEffectiveStopDate(endDate);
        status.setEffectiveStopPeriod(endTime);
        status.setFallBackStatus(fallBackId == null ? null : (StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(fallBackId, hibSession));
        status.setSession(session ? (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()) : null);
        hibSession.saveOrUpdate((Object)status);
        if (changed) {
            ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel() + (status.getSession() == null ? " (global)" : " (" + status.getSession().getLabel() + ")"), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        if (session) {
            StudentSectioningStatus other;
            HashMap<Long, StudentSectioningStatus> others = new HashMap<Long, StudentSectioningStatus>();
            for (Session s : hibSession.createQuery("select distinct s.session from Student s where s.sectioningStatus = :uniqueId and s.session != :sessionId").setLong("uniqueId", status.getUniqueId().longValue()).setLong("sessionId", status.getSession().getUniqueId().longValue()).list()) {
                other = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus where session = :sessionId and reference = :reference").setLong("sessionId", s.getUniqueId().longValue()).setString("reference", status.getReference()).uniqueResult();
                if (other == null) {
                    System.out.println("Creating " + status.getReference() + " for " + s.getLabel());
                    other = new StudentSectioningStatus();
                    other.setSession(s);
                    other.setReference(status.getReference());
                    other.setLabel(status.getLabel());
                    other.setMessage(status.getMessage());
                    other.setStatus(status.getStatus());
                    other.setEffectiveStartDate(status.getEffectiveStartDate());
                    other.setEffectiveStartPeriod(status.getEffectiveStartPeriod());
                    other.setEffectiveStopDate(status.getEffectiveStopDate());
                    other.setEffectiveStopPeriod(status.getEffectiveStopPeriod());
                    other.setFallBackStatus(status.getFallBackStatus() == null ? null : StudentSectioningStatus.getStatus(status.getFallBackStatus().getReference(), s.getUniqueId(), hibSession));
                    other.setTypes(new HashSet<CourseType>(status.getTypes()));
                    hibSession.save((Object)other);
                    others.put(s.getUniqueId(), other);
                    hibSession.flush();
                }
                hibSession.createQuery("update Student set sectioningStatus = :newId where sectioningStatus = :oldId and session = :sessionId").setLong("newId", other.getUniqueId().longValue()).setLong("oldId", status.getUniqueId().longValue()).setLong("sessionId", s.getUniqueId().longValue()).executeUpdate();
            }
            for (Session s : hibSession.createQuery("from Session where defaultSectioningStatus = :uniqueId and uniqueId != :sessionId").setLong("uniqueId", status.getUniqueId().longValue()).setLong("sessionId", status.getSession().getUniqueId().longValue()).list()) {
                other = (StudentSectioningStatus)others.get(s.getUniqueId());
                if (other == null) {
                    other = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus where session = :sessionId and reference = :reference").setLong("sessionId", s.getUniqueId().longValue()).setString("reference", status.getReference()).uniqueResult();
                }
                if (other == null) {
                    System.out.println("Creating " + status.getReference() + " for " + s.getLabel());
                    other = new StudentSectioningStatus();
                    other.setSession(s);
                    other.setReference(status.getReference());
                    other.setLabel(status.getLabel());
                    other.setMessage(status.getMessage());
                    other.setStatus(status.getStatus());
                    other.setEffectiveStartDate(status.getEffectiveStartDate());
                    other.setEffectiveStartPeriod(status.getEffectiveStartPeriod());
                    other.setEffectiveStopDate(status.getEffectiveStopDate());
                    other.setEffectiveStopPeriod(status.getEffectiveStopPeriod());
                    other.setFallBackStatus(status.getFallBackStatus() == null ? null : StudentSectioningStatus.getStatus(status.getFallBackStatus().getReference(), s.getUniqueId(), hibSession));
                    other.setTypes(new HashSet<CourseType>(status.getTypes()));
                    hibSession.save((Object)other);
                }
                s.setDefaultSectioningStatus(other);
                hibSession.update((Object)s);
            }
        } else {
            for (StudentSectioningStatus other : hibSession.createQuery("from StudentSectioningStatus where uniqueId != :uniqueId and reference = :reference").setLong("uniqueId", status.getUniqueId().longValue()).setString("reference", status.getReference()).list()) {
                System.out.println("Removing " + other.getReference() + " from " + (other.getSession() == null ? "GLOBAL" : other.getSession().getLabel()));
                hibSession.createQuery("update Student set sectioningStatus = :newId where sectioningStatus = :oldId").setLong("newId", status.getUniqueId().longValue()).setLong("oldId", other.getUniqueId().longValue()).executeUpdate();
                hibSession.createQuery("update Session set defaultSectioningStatus = :newId where defaultSectioningStatus = :oldId").setLong("newId", status.getUniqueId().longValue()).setLong("oldId", other.getUniqueId().longValue()).executeUpdate();
                hibSession.delete((Object)other);
            }
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(StudentSectioningStatus status, SessionContext context, org.hibernate.Session hibSession) {
        if (status == null) {
            return;
        }
        for (StudentSectioningStatus s : hibSession.createQuery("from StudentSectioningStatus s where s.fallBackStatus.uniqueId = :statusId").setLong("statusId", status.getUniqueId().longValue()).list()) {
            s.setFallBackStatus(null);
            hibSession.saveOrUpdate((Object)s);
        }
        ChangeLog.addChange(hibSession, context, status, status.getReference() + " " + status.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)status);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingStatusTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((StudentSectioningStatus)StudentSectioningStatusDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }

    static enum StatusOption {
        Access(MESSAGES.toggleAccess(), StudentSectioningStatus.Option.enabled),
        Enrollment(MESSAGES.toggleEnrollment(), StudentSectioningStatus.Option.enrollment),
        Advisor(MESSAGES.toggleAdvisor(), StudentSectioningStatus.Option.advisor),
        Admin(MESSAGES.toggleAdmin(), StudentSectioningStatus.Option.admin),
        RegAccess(MESSAGES.toggleRegAccess(), StudentSectioningStatus.Option.regenabled),
        Registration(MESSAGES.toggleRegistration(), StudentSectioningStatus.Option.registration),
        RegAdvisor(MESSAGES.toggleRegAdvisor(), StudentSectioningStatus.Option.regadvisor),
        RegAdmin(MESSAGES.toggleRegAdmin(), StudentSectioningStatus.Option.regadmin),
        Email(MESSAGES.toggleEmail(), StudentSectioningStatus.Option.email),
        WaitListing(MESSAGES.toggleWaitList(), StudentSectioningStatus.Option.waitlist),
        NoSubs(MESSAGES.toggleNoSubs(), StudentSectioningStatus.Option.nosubs),
        NoBatch(MESSAGES.toggleNoBatch(), StudentSectioningStatus.Option.nobatch),
        AdvisorCanSet(MESSAGES.toggleAdvisorCanSetStatus(), StudentSectioningStatus.Option.advcanset),
        CReqValidation(MESSAGES.toggleCourseRequestValidation(), StudentSectioningStatus.Option.reqval),
        SpecReg(MESSAGES.toggleSpecialRequests(), StudentSectioningStatus.Option.specreg),
        CanReq(MESSAGES.toggleCanRequire(), StudentSectioningStatus.Option.canreq),
        NoSchedule(MESSAGES.toggleNoSchedule(), StudentSectioningStatus.Option.noschedule);

        private StudentSectioningStatus.Option iOption;
        private String iLabel;

        private StatusOption(String label, StudentSectioningStatus.Option option) {
            this.iLabel = label;
            this.iOption = option;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public StudentSectioningStatus.Option getOption() {
            return this.iOption;
        }
    }
}

