/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.PointInTimeDataReports;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DemandOfferingType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.reports.pointintimedata.AllWSCHByDepartment;
import org.unitime.timetable.reports.pointintimedata.AllWSCHForDepartmentByClass;
import org.unitime.timetable.reports.pointintimedata.AllWSCHForDepartmentByInstructor;
import org.unitime.timetable.reports.pointintimedata.AllWSCHForDepartmentByInstructorPosition;
import org.unitime.timetable.reports.pointintimedata.RoomTypeUtilizationByDepartment;
import org.unitime.timetable.reports.pointintimedata.RoomUtilization;
import org.unitime.timetable.reports.pointintimedata.WSCHByBuildingDayOfWeekHourOfDay;
import org.unitime.timetable.reports.pointintimedata.WSCHByDayOfWeekAndHourOfDay;
import org.unitime.timetable.reports.pointintimedata.WSCHByDepartmentDayOfWeekHourOfDay;
import org.unitime.timetable.reports.pointintimedata.WSCHByItypeDayOfWeekHourOfDay;
import org.unitime.timetable.reports.pointintimedata.WSCHBySubjectAreaDayOfWeekHourOfDay;
import org.unitime.timetable.reports.pointintimedata.WSEByDayOfWeekAndPeriod;
import org.unitime.timetable.security.UserContext;

public abstract class BasePointInTimeDataReports {
    protected static PointInTimeDataReports MSG = Localization.create(PointInTimeDataReports.class);
    private Float standardMinutesInReportingHour = null;
    private Float standardWeeksInReportingTerm = null;
    private Long pointInTimeDataUniqueId = null;
    public static Hashtable<String, Class> sPointInTimeDataReportRegister = new Hashtable();
    private ArrayList<Parameter> parameters = new ArrayList();
    private String[] header;
    private ArrayList<String[]> data = new ArrayList();
    private HashMap<Parameter, ArrayList<Object>> parameterValues = new HashMap();

    public BasePointInTimeDataReports() {
        this.getParameters().add(Parameter.PITD);
        this.getParameters().add(Parameter.MINUTES_IN_REPORTING_HOUR);
        this.getParameters().add(Parameter.WEEKS_IN_REPORTING_TERM);
        this.intializeHeader();
    }

    public abstract String reportName();

    public abstract String reportDescription();

    protected abstract void intializeHeader();

    protected void setHeader(ArrayList<String> header) {
        this.header = new String[header.size()];
        for (int i = 0; i < header.size(); ++i) {
            this.header[i] = header.get(i);
        }
    }

    public String[] getHeader() {
        return this.header;
    }

    protected void addDataRow(ArrayList<String> row) {
        String[] r = new String[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            r[i] = row.get(i);
        }
        this.data.add(r);
    }

    public ArrayList<String[]> getData() {
        return this.data;
    }

    public HashMap<Parameter, ArrayList<Object>> getParameterValues() {
        return this.parameterValues;
    }

    public Long getPointInTimeDataUniqueId() {
        return this.pointInTimeDataUniqueId;
    }

    public void setPointInTimeDataUniqueId(Long pointInTimeDataUniqueId) {
        this.pointInTimeDataUniqueId = pointInTimeDataUniqueId;
    }

    public Float getStandardMinutesInReportingHour() {
        return this.standardMinutesInReportingHour;
    }

    public void setStandardMinutesInReportingHour(Float standardMinutesInReportingHour) {
        this.standardMinutesInReportingHour = standardMinutesInReportingHour;
    }

    public Float getStandardWeeksInReportingTerm() {
        return this.standardWeeksInReportingTerm;
    }

    public void setStandardWeeksInReportingTerm(Float standardWeeksInReportingTerm) {
        this.standardWeeksInReportingTerm = standardWeeksInReportingTerm;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
    }

    protected void parseParameters() {
        if (this.getParameterValues().get((Object)Parameter.PITD).size() == 1) {
            this.setPointInTimeDataUniqueId((Long)this.getParameterValues().get((Object)Parameter.PITD).get(0));
        }
        if (this.getParameterValues().get((Object)Parameter.MINUTES_IN_REPORTING_HOUR).size() == 1) {
            this.setStandardMinutesInReportingHour((Float)this.getParameterValues().get((Object)Parameter.MINUTES_IN_REPORTING_HOUR).get(0));
        }
        if (this.getParameterValues().get((Object)Parameter.WEEKS_IN_REPORTING_TERM).size() == 1) {
            this.setStandardWeeksInReportingTerm((Float)this.getParameterValues().get((Object)Parameter.WEEKS_IN_REPORTING_TERM).get(0));
        }
    }

    protected abstract void runReport(org.hibernate.Session var1);

    private ArrayList<String[]> outputReport() {
        ArrayList<String[]> report = new ArrayList<String[]>();
        report.add(this.getHeader());
        for (String[] row : this.getData()) {
            report.add(row);
        }
        return report;
    }

    private void setParameterValues(HashMap<Parameter, String> parameterValues) {
        for (Parameter p : parameterValues.keySet()) {
            this.getParameterValues().put(p, p.parseSetValue(parameterValues.get((Object)p)));
        }
    }

    public ArrayList<String[]> execute(HashMap<Parameter, String> parameterValues, org.hibernate.Session hibSession) {
        this.setParameterValues(parameterValues);
        this.parseParameters();
        this.runReport(hibSession);
        return this.outputReport();
    }

    protected List<Long> findAllPitInstructionalOfferingUniqueIdsForDepartment(PointInTimeData pointInTimeData, Long departmentId, org.hibernate.Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select pio.uniqueId").append(" from PitInstructionalOffering pio").append(" inner join pio.pitCourseOfferings as pco").append(" where pio.pointInTimeData.uniqueId = :pitdUid").append(" and pco.isControl = true").append(" and pco.subjectArea.department.uniqueId = :deptUid");
        return hibSession.createQuery(sb.toString()).setLong("pitdUid", pointInTimeData.getUniqueId().longValue()).setLong("deptUid", departmentId.longValue()).setCacheable(true).list();
    }

    protected List<PitClass> findAllPitClassesForPitInstructionalOfferingId(PointInTimeData pointInTimeData, Long pitOfferingId, org.hibernate.Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select pc").append(" from PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append(" inner join pc.pitSchedulingSubpart as pss").append(" inner join pss.pitInstrOfferingConfig as pioc").append(" inner join pioc.pitInstructionalOffering as pio").append(" inner join pio.pitCourseOfferings as pco").append(" inner join pco.subjectArea as sa").append(" where pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.uniqueId = :offrId").append(" and pco.isControl = true").append(" and pc.pitClassEvents is not empty");
        ArrayList<PitClass> pitClasses = new ArrayList<PitClass>();
        pitClasses.addAll(hibSession.createQuery(sb.toString()).setLong("offrId", pitOfferingId.longValue()).setCacheable(true).list());
        return pitClasses;
    }

    static {
        sPointInTimeDataReportRegister.put("allWSCHbyDept", AllWSCHByDepartment.class);
        sPointInTimeDataReportRegister.put("allWSCHforDeptbyClass", AllWSCHForDepartmentByClass.class);
        sPointInTimeDataReportRegister.put("allWSCHforDeptbyPosition", AllWSCHForDepartmentByInstructorPosition.class);
        sPointInTimeDataReportRegister.put("allWSCHforDeptbyInstructor", AllWSCHForDepartmentByInstructor.class);
        sPointInTimeDataReportRegister.put("roomUtilization", RoomUtilization.class);
        sPointInTimeDataReportRegister.put("roomTypeUtilization", RoomTypeUtilizationByDepartment.class);
        sPointInTimeDataReportRegister.put("wschByDayOfWeekAndPeriod", WSEByDayOfWeekAndPeriod.class);
        sPointInTimeDataReportRegister.put("wschByDayOfWeekAndHourOfDay", WSCHByDayOfWeekAndHourOfDay.class);
        sPointInTimeDataReportRegister.put("wschByItypeDayOfWeekAndHourOfDay", WSCHByItypeDayOfWeekHourOfDay.class);
        sPointInTimeDataReportRegister.put("wschByDeptDayOfWeekAndHourOfDay", WSCHByDepartmentDayOfWeekHourOfDay.class);
        sPointInTimeDataReportRegister.put("wschBySubjectAreaDayOfWeekAndHourOfDay", WSCHBySubjectAreaDayOfWeekHourOfDay.class);
        sPointInTimeDataReportRegister.put("wschByBuildingDayOfWeekAndHourOfDay", WSCHByBuildingDayOfWeekHourOfDay.class);
    }

    public static enum Parameter {
        PITD("Point In Time Data", true, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                ArrayList<PointInTimeData> pitdList = PointInTimeData.findAllSavedSuccessfullyForSession(sessionId);
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (PointInTimeData pitd : pitdList) {
                    ret.put(pitd.getUniqueId(), pitd.getName());
                }
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return null;
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        PITD2("Point In Time Data Comparison", true, false, false, Parameter.PITD.iImplementation),
        SESSION("Academic Session", false, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                ret.put(session.getUniqueId(), session.getLabel());
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                return sessionId.toString();
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        DEPARTMENT("Department", true, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Department d : Department.getUserDepartments(user)) {
                    ret.put(d.getUniqueId(), d.htmlLabel());
                }
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return null;
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        DEPARTMENTS("Departments", true, true, false, Parameter.DEPARTMENT.iImplementation),
        SUBJECT("Subject Area", true, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                try {
                    for (SubjectArea s : SubjectArea.getUserSubjectAreas(user)) {
                        ret.put(s.getUniqueId(), s.getSubjectAreaAbbreviation());
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return null;
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        SUBJECTS("Subject Areas", true, true, false, Parameter.SUBJECT.iImplementation),
        BUILDING("Building", true, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Building b : Building.findAll(session.getUniqueId())) {
                    ret.put(b.getUniqueId(), b.getAbbrName());
                }
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return null;
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        BUILDINGS("Buildings", true, true, false, Parameter.BUILDING.iImplementation),
        ROOM("Room", true, false, false, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Room r : Room.findAllRooms(session.getUniqueId())) {
                    ret.put(r.getUniqueId(), r.getLabel());
                }
                return ret;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return null;
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Long.parseLong(value));
                }
                return parameterValues;
            }
        }),
        ROOMS("Rooms", true, true, false, Parameter.ROOM.iImplementation),
        MINUTES_IN_REPORTING_HOUR("Minutes in Reporting Hour", true, false, true, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                return null;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return ApplicationProperty.StandardMinutesInReportingHour.value().toString();
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Float.valueOf(Float.parseFloat(value)));
                }
                return parameterValues;
            }
        }),
        WEEKS_IN_REPORTING_TERM("Weeks in Reporting Term", true, false, true, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                return null;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return ApplicationProperty.StandardWeeksInReportingTerm.value().toString();
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Float.valueOf(Float.parseFloat(value)));
                }
                return parameterValues;
            }
        }),
        MINIMUM_LOCATION_CAPACITY("Minimum Location Capacity", true, false, true, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                return null;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return "0";
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Integer.parseInt(value));
                }
                return parameterValues;
            }
        }),
        MAXIMUM_LOCATION_CAPACITY("Maximum Location Capacity", true, false, true, new ParameterImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                return null;
            }

            @Override
            public String getDefaultValue(UserContext user) {
                return "999999";
            }

            @Override
            public ArrayList<Object> parseSetValue(String valueString) {
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                for (String value : valueString.split(",")) {
                    parameterValues.add(Integer.parseInt(value));
                }
                return parameterValues;
            }
        }),
        DistributionType(DistributionType.class, false, false),
        DistributionTypes(DistributionType.class, true, false),
        DemandOfferingType(DemandOfferingType.class, false, false),
        DemandOfferingTypes(DemandOfferingType.class, true, false),
        OfferingConsentType(OfferingConsentType.class, false, false),
        OfferingConsentTypes(OfferingConsentType.class, true, false),
        CourseCreditFormat(CourseCreditFormat.class, false, false),
        CourseCreditFormats(CourseCreditFormat.class, true, false),
        CourseCreditType(CourseCreditType.class, false, false),
        CourseCreditTypes(CourseCreditType.class, true, false),
        CourseCreditUnitType(CourseCreditUnitType.class, false, false),
        CourseCreditUnitTypes(CourseCreditUnitType.class, true, false),
        PositionType(PositionType.class, false, true),
        PositionTypes(PositionType.class, true, true),
        DepartmentStatusType(DepartmentStatusType.class, false, false),
        DepartmentStatusTypes(DepartmentStatusType.class, true, false),
        RoomType(RoomType.class, false, false),
        RoomTypes(RoomType.class, true, false),
        StudentSectioningStatus(StudentSectioningStatus.class, false, false),
        StudentSectioningStatuses(StudentSectioningStatus.class, true, false),
        ExamType(ExamType.class, false, false),
        ExamTypes(ExamType.class, true, false),
        RoomFeatureType(RoomFeatureType.class, false, false),
        RoomFeatureTypes(RoomFeatureType.class, true, false),
        CourseType(CourseType.class, false, false),
        CourseTypes(CourseType.class, true, false);

        String iName;
        ParameterImplementation iImplementation;
        boolean iAllowSelection;
        boolean iMultiSelect;
        boolean iTextField;

        private Parameter(String name, boolean allowSelection, boolean multiSelect, boolean isText, ParameterImplementation impl) {
            this.iName = name;
            this.iAllowSelection = allowSelection;
            this.iMultiSelect = multiSelect;
            this.iTextField = isText;
            this.iImplementation = impl;
        }

        private Parameter(Class<? extends RefTableEntry> reference, boolean multiSelect, boolean addUnknownValue) {
            this.iName = this.name().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
            this.iAllowSelection = true;
            this.iMultiSelect = multiSelect;
            this.iTextField = false;
            this.iImplementation = addUnknownValue ? new RefTableParametersPlusUnknown(reference) : new RefTableParameters(reference);
        }

        public String text() {
            return this.iName;
        }

        public boolean allowSingleSelection() {
            return this.iAllowSelection;
        }

        public boolean allowMultiSelection() {
            return this.iAllowSelection && this.iMultiSelect;
        }

        public boolean isTextField() {
            return this.iTextField;
        }

        public Map<Long, String> values(UserContext user) {
            return this.iImplementation.getValues(user);
        }

        public String defaultValue(UserContext user) {
            return this.iImplementation.getDefaultValue(user);
        }

        public ArrayList<Object> parseSetValue(String valueString) {
            return this.iImplementation.parseSetValue(valueString);
        }
    }

    private static class RefTableParametersPlusUnknown
    extends RefTableParameters {
        RefTableParametersPlusUnknown(Class<? extends RefTableEntry> reference) {
            super(reference);
        }

        @Override
        public Map<Long, String> getValues(UserContext user) {
            Map<Long, String> map = super.getValues(user);
            map.put(new Long(-1L), MSG.labelUnknown());
            return map;
        }
    }

    private static class RefTableParameters
    implements ParameterImplementation {
        protected Class<? extends RefTableEntry> iReference;

        RefTableParameters(Class<? extends RefTableEntry> reference) {
            this.iReference = reference;
        }

        @Override
        public Map<Long, String> getValues(UserContext user) {
            Hashtable<Long, String> ret = new Hashtable<Long, String>();
            if (StudentSectioningStatus.class.equals(this.iReference)) {
                for (StudentSectioningStatus ref : StudentSectioningStatus.findAll(user.getCurrentAcademicSessionId())) {
                    ret.put(ref.getUniqueId(), ref.getLabel());
                }
            } else {
                for (RefTableEntry ref : SessionDAO.getInstance().getSession().createCriteria(this.iReference).list()) {
                    ret.put(ref.getUniqueId(), ref.getLabel());
                }
            }
            return ret;
        }

        @Override
        public String getDefaultValue(UserContext user) {
            return null;
        }

        @Override
        public ArrayList<Object> parseSetValue(String valueString) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (String value : valueString.split(",")) {
                parameterValues.add(Long.parseLong(value));
            }
            return parameterValues;
        }
    }

    private static interface ParameterImplementation {
        public Map<Long, String> getValues(UserContext var1);

        public String getDefaultValue(UserContext var1);

        public ArrayList<Object> parseSetValue(String var1);
    }
}

