/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ScheduleByPeriodReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ScheduleByPeriodReport.class);

    public ScheduleByPeriodReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY PERIOD", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        TreeSet sections;
        sLog.debug((Object)"  Sorting sections...");
        Hashtable<String, TreeSet> subject2courseSections = new Hashtable<String, TreeSet>();
        for (ExamInfo examInfo : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : examInfo.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                sections = (TreeSet)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        String[] stringArray = new String[2];
        stringArray[0] = "Date And Time                  Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section     Meeting Times                         Enrl" + (this.iDispRooms ? "  Room         Cap ExCap" : "");
        stringArray[1] = "------------------------------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- -------------------------------------- -----" + (this.iDispRooms ? " ----------- ----- -----" : "");
        this.setHeader(stringArray);
        sLog.debug((Object)"  Printing report...");
        this.printHeader();
        Iterator<ExamPeriod> p = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()).iterator();
        while (p.hasNext()) {
            ExamPeriod examPeriod = p.next();
            this.iPeriodPrinted = false;
            this.setPageName(this.formatPeriod(examPeriod));
            this.setCont(this.formatPeriod(examPeriod));
            for (String subject : new TreeSet(subject2courseSections.keySet())) {
                sections = (TreeSet)subject2courseSections.get(subject);
                this.iSubjectPrinted = false;
                for (ExamInfo.ExamSectionInfo section : sections) {
                    if (!examPeriod.equals(section.getExamAssignment().getPeriod())) continue;
                    if (!this.iDispRooms) {
                        this.println(this.rpad(this.iPeriodPrinted ? "" : this.formatPeriod(examPeriod), 30) + " " + this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 38) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iSubjectPrinted = !this.iNewPage;
                        this.iPeriodPrinted = this.iSubjectPrinted;
                        continue;
                    }
                    if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                        this.println(this.rpad(this.iPeriodPrinted ? "" : this.formatPeriod(examPeriod), 30) + " " + this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.rpad(this.getMeetingTime(section), 38) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5) + " " + this.iNoRoom);
                        this.iSubjectPrinted = !this.iNewPage;
                        this.iPeriodPrinted = this.iSubjectPrinted;
                        continue;
                    }
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.iNrLines) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iPeriodPrinted ? "" : this.formatPeriod(examPeriod), 30) + " " + this.rpad(!firstRoom || this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(!firstRoom ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(!firstRoom ? "" : section.getItype(), 6) + " " : "") + this.lpad(!firstRoom ? "" : section.getSection(), 9) + " " + this.rpad(!firstRoom ? "" : this.getMeetingTime(section), 38) + " " + this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5) + " " + this.formatRoom(room) + " " + this.lpad("" + room.getCapacity(), 5) + " " + this.lpad("" + room.getExamCapacity(), 5));
                        firstRoom = false;
                    }
                    this.iSubjectPrinted = !this.iNewPage;
                    this.iPeriodPrinted = this.iSubjectPrinted;
                }
            }
            this.setCont(null);
            if (!this.iPeriodPrinted || !p.hasNext()) continue;
            this.newPage();
        }
        if (this.iPeriodPrinted) {
            this.lastPage();
        }
    }
}

