/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndStudentReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;

public class ConflictsByCourseAndInstructorReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ConflictsByCourseAndStudentReport.class);
    Hashtable<Long, String> iStudentNames = new Hashtable();

    public ConflictsByCourseAndInstructorReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "CONFLICTS BY COURSE AND INSTRUCTOR", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)"  Sorting sections...");
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)"  Printing report...");
        String[] stringArray = new String[2];
        stringArray[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date    Time   Name                      Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
        stringArray[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------- ------ ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
        this.setHeader(stringArray);
        this.printHeader();
        for (String subject : new TreeSet(subject2courseSections.keySet())) {
            TreeSet sections = (TreeSet)subject2courseSections.get(subject);
            if (this.iSubjectPrinted) {
                this.newPage();
            }
            this.setPageName(subject);
            this.setCont(subject);
            this.iSubjectPrinted = false;
            for (ExamInfo.ExamSectionInfo section : sections) {
                ExamAssignmentInfo exam = section.getExamAssignmentInfo();
                if (exam == null || exam.getPeriod() == null) continue;
                this.iCoursePrinted = false;
                for (ExamInfo.ExamInstructorInfo instructor : exam.getInstructors()) {
                    this.iStudentPrinted = false;
                    if (this.iDirect) {
                        for (ExamAssignmentInfo.DirectConflict directConflict : exam.getInstructorDirectConflicts()) {
                            if (!directConflict.getStudents().contains(instructor.getId())) continue;
                            this.iPeriodPrinted = false;
                            if (directConflict.getOtherExam() != null) {
                                for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!directConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : instructor.getName(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "DIRECT", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                                continue;
                            }
                            if (directConflict.getOtherEventId() == null) continue;
                            if (directConflict.isOtherClass()) {
                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : instructor.getName(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "CLASS", 6) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) + " " : "") + this.lpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                            } else {
                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : instructor.getName(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "EVENT", 6) + " " + this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                            }
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                    if (this.iM2d) {
                        for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getInstructorMoreThanTwoADaysConflicts()) {
                            if (!moreThanTwoADayConflict.getStudents().contains(instructor.getId())) continue;
                            this.iPeriodPrinted = false;
                            for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                if (!otherExam.getInstructors().contains(instructor)) continue;
                                for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                    this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : instructor.getName(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : ">2-DAY", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                            }
                        }
                    }
                    if (!this.iBtb) continue;
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getInstructorBackToBackConflicts()) {
                        if (!backToBackConflict.getStudents().contains(instructor.getId())) continue;
                        this.iPeriodPrinted = false;
                        for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!backToBackConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                            this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : instructor.getName(), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "BTB", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                }
            }
            this.setCont(null);
        }
        if (this.iSubjectPrinted) {
            this.lastPage();
        }
    }
}

