/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.reports;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public class OnlineSectioningReport
implements Runnable {
    protected static Logger sLog = Logger.getLogger(OnlineSectioningReport.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.00000");
    private Report iReport = null;
    protected Map<String, Counter> iCounters = new Hashtable<String, Counter>();
    protected Map<String, Map<String, Map<String, Counter>>> iReports = new Hashtable<String, Map<String, Map<String, Counter>>>();

    public OnlineSectioningReport(Report report) throws Exception {
        this.iReport = report;
    }

    @Override
    public void run() {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
        props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
        props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
        props.setProperty("log4j.logger.net", "INFO");
        PropertyConfigurator.configure((Properties)props);
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
        }
        catch (Exception e) {
            sLog.fatal((Object)("Unable to initialize hibernate: " + e.getMessage()), (Throwable)e);
            return;
        }
        org.hibernate.Session hibSession = new _RootDAO().createNewSession();
        Session session = Session.getSessionUsingInitiativeYearTerm(this.iReport.getCampus(), this.iReport.getYear(), this.iReport.getTerm());
        if (session == null) {
            sLog.fatal((Object)("Academic session not found:" + this.iReport.getTerm() + " " + this.iReport.getYear() + " (" + this.iReport.getCampus() + ")"));
            return;
        }
        sLog.info((Object)("Session: " + session));
        Long sessionId = session.getUniqueId();
        String student = null;
        String filter = "";
        String[] operations = this.iReport.getOperations();
        if (operations == null) {
            filter = "";
        } else if (operations.length == 1) {
            filter = "and l.operation = '" + operations[0] + "'";
        } else {
            filter = "and l.operation in (";
            for (int i = 0; i < operations.length; ++i) {
                filter = filter + (i > 0 ? "," : "") + "'" + operations[i] + "'";
            }
            filter = filter + ")";
        }
        String[] exclude = this.iReport.getExcludeUsers();
        if (exclude != null) {
            filter = filter.isEmpty() ? filter + "l.user not in (" : filter + "and l.user not in(";
            for (int i = 0; i < exclude.length; ++i) {
                filter = filter + (i > 0 ? "," : "") + "'" + exclude[i] + "'";
            }
            filter = filter + ")";
        }
        if (this.iReport.getLastTimeStamp() != null) {
            filter = filter.isEmpty() ? filter + "l.timeStamp < to_timestamp('" + this.iReport.getLastTimeStamp() + "', 'YYYY-MM-DD')" : filter + "and l.timeStamp < to_timestamp('" + this.iReport.getLastTimeStamp() + "', 'YYYY-MM-DD')";
        }
        ArrayList<OnlineSectioningLog.Action> actions = new ArrayList<OnlineSectioningLog.Action>();
        Iterator i = hibSession.createQuery("select l from OnlineSectioningLog l where l.session.uniqueId = :sessionId " + filter + " order by l.student, l.timeStamp").setLong("sessionId", sessionId.longValue()).iterate();
        while (i.hasNext()) {
            OnlineSectioningLog onlineSectioningLog = (OnlineSectioningLog)i.next();
            if (student == null) {
                student = onlineSectioningLog.getStudent();
            } else if (!student.equals(onlineSectioningLog.getStudent())) {
                if (!actions.isEmpty()) {
                    this.iReport.process(this, student, actions);
                }
                actions.clear();
                student = onlineSectioningLog.getStudent();
            }
            try {
                actions.add(OnlineSectioningLog.Action.parseFrom(onlineSectioningLog.getAction()));
            }
            catch (InvalidProtocolBufferException e) {
                sLog.error((Object)("Unable to parse action for " + student + " (op=" + onlineSectioningLog.getOperation() + ", ts=" + onlineSectioningLog.getTimeStamp() + "): " + e.getMessage()));
            }
        }
        if (!actions.isEmpty()) {
            this.iReport.process(this, student, actions);
        }
        for (String string : new TreeSet<String>(this.iCounters.keySet())) {
            sLog.info((Object)(string + ": " + this.iCounters.get(string)));
        }
        for (Map.Entry entry : this.iReports.entrySet()) {
            TreeSet rows = new TreeSet(((Map)entry.getValue()).keySet());
            TreeSet cols = new TreeSet();
            CSVFile csv = new CSVFile();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                cols.addAll(((Map)entry2.getValue()).keySet());
            }
            ArrayList<CSVFile.CSVField> header = new ArrayList<CSVFile.CSVField>();
            header.add(new CSVFile.CSVField(entry.getKey()));
            for (String col : cols) {
                header.add(new CSVFile.CSVField((Object)col));
            }
            csv.setHeader(header);
            for (String row : rows) {
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField((Object)row));
                Map table = (Map)((Map)entry.getValue()).get(row);
                for (String col : cols) {
                    Counter counter = (Counter)table.get(col);
                    line.add(new CSVFile.CSVField((Object)(counter == null ? "" : String.valueOf(counter.sum()))));
                }
                csv.addLine(line);
            }
            try {
                File file = new File(this.iReport.getReportFolder(), (String)entry.getKey() + ".csv");
                sLog.info((Object)("Writing " + file + " ..."));
                csv.save(file);
            }
            catch (IOException iOException) {
                sLog.error((Object)("Unable to write report " + (String)entry.getKey() + ": " + iOException.getMessage()), (Throwable)iOException);
            }
        }
        hibSession.close();
        HibernateUtil.closeHibernate();
    }

    public double inc(String counter, double value) {
        Counter cnt = this.iCounters.get(counter);
        if (cnt == null) {
            cnt = new Counter();
            this.iCounters.put(counter, cnt);
        }
        cnt.inc(value);
        return cnt.sum();
    }

    public void inc(String report, String record, String property, double value) {
        Counter counter;
        Map<String, Counter> line;
        Map<String, Map<String, Counter>> table = this.iReports.get(report);
        if (table == null) {
            table = new Hashtable<String, Map<String, Counter>>();
            this.iReports.put(report, table);
        }
        if ((line = table.get(record)) == null) {
            line = new Hashtable<String, Counter>();
            table.put(record, line);
        }
        if ((counter = line.get(property)) == null) {
            counter = new Counter();
            line.put(property, counter);
        }
        counter.inc(value);
    }

    public static class Counter {
        private double iTotal = 0.0;
        private double iMin = 0.0;
        private double iMax = 0.0;
        private double iTotalSquare = 0.0;
        private int iCount = 0;

        public void inc(double value) {
            if (this.iCount == 0) {
                this.iTotal = value;
                this.iMin = value;
                this.iMax = value;
                this.iTotalSquare = value * value;
            } else {
                this.iTotal += value;
                this.iMin = Math.min(this.iMin, value);
                this.iMax = Math.max(this.iMax, value);
                this.iTotalSquare += value * value;
            }
            ++this.iCount;
        }

        public int count() {
            return this.iCount;
        }

        public double sum() {
            return this.iTotal;
        }

        public double min() {
            return this.iMin;
        }

        public double max() {
            return this.iMax;
        }

        public double rms() {
            return this.iCount == 0 ? 0.0 : Math.sqrt(this.iTotalSquare / (double)this.iCount);
        }

        public double avg() {
            return this.iCount == 0 ? 0.0 : this.iTotal / (double)this.iCount;
        }

        public String toString() {
            return sDF.format(this.sum()) + " (min: " + sDF.format(this.min()) + ", max: " + sDF.format(this.max()) + ", avg: " + sDF.format(this.avg()) + ", rms: " + sDF.format(this.rms()) + ", cnt: " + this.count() + ")";
        }
    }

    public static interface Report {
        public File getReportFolder();

        public String getYear();

        public String getTerm();

        public String getCampus();

        public String[] getOperations();

        public String[] getExcludeUsers();

        public String getLastTimeStamp();

        public void process(OnlineSectioningReport var1, String var2, List<OnlineSectioningLog.Action> var3);
    }
}

