/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import org.cpsolver.coursett.model.TimeLocation;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.model.XExactTimeConversion;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.duration.DurationModel;

@SerializeWith(value=XTimeSerializer.class)
public class XTime
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int iSlot;
    private int iLength;
    private int iBreakTime = 0;
    private int iDays;
    private BitSet iWeeks = null;
    private Long iDatePatternId = null;
    private String iDatePatternName = null;
    transient Integer iFirstMeeting = null;

    public XTime() {
    }

    public XTime(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readExternal(input);
    }

    public XTime(Assignment assignment, XExactTimeConversion conversion, String datePatternFormat) {
        this.iDays = assignment.getDays();
        this.iSlot = assignment.getStartSlot();
        if (assignment.getTimePattern().getType() == 5) {
            DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minPerMtg = dm.getExactTimeMinutesPerMeeting(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays());
            this.iLength = conversion.getLength(minPerMtg);
            this.iBreakTime = conversion.getBreakTime(minPerMtg);
        } else {
            this.iLength = assignment.getTimePattern().getSlotsPerMtg();
            this.iBreakTime = assignment.getTimePattern().getBreakTime();
        }
        this.iDatePatternId = assignment.getDatePattern().getUniqueId();
        this.iDatePatternName = XTime.datePatternName(assignment, datePatternFormat);
        this.iWeeks = assignment.getDatePattern().getPatternBitSet();
    }

    public XTime(DatePattern pattern, String datePatternFormat) {
        this.iDays = 0;
        this.iSlot = 0;
        this.iLength = 0;
        this.iBreakTime = 0;
        this.iDatePatternId = pattern.getUniqueId();
        if ("never".equals(datePatternFormat)) {
            this.iDatePatternName = pattern.getName();
        } else if ("extended".equals(datePatternFormat) && pattern.getType() != 3) {
            this.iDatePatternName = pattern.getName();
        } else if ("alternate".equals(datePatternFormat) && pattern.getType() == 1) {
            this.iDatePatternName = pattern.getName();
        } else {
            Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
            Date first = pattern.getStartDate();
            Date last = pattern.getEndDate();
            this.iDatePatternName = dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
        }
        this.iWeeks = pattern.getPatternBitSet();
    }

    public XTime(FreeTime free, BitSet freeTimePattern) {
        this.iSlot = free.getStartSlot();
        this.iLength = free.getLength();
        this.iDays = free.getDayCode();
        this.iWeeks = freeTimePattern;
    }

    public XTime(TimeLocation time) {
        this.iDays = time.getDayCode();
        this.iSlot = time.getStartSlot();
        this.iLength = time.getLength();
        this.iBreakTime = time.getBreakTime();
        this.iDatePatternId = time.getDatePatternId();
        this.iDatePatternName = time.getDatePatternName();
        this.iWeeks = time.getWeekCode();
    }

    public int getSlot() {
        return this.iSlot;
    }

    public int getLength() {
        return this.iLength;
    }

    public int getDays() {
        return this.iDays;
    }

    public int getBreakTime() {
        return this.iBreakTime;
    }

    public BitSet getWeeks() {
        return this.iWeeks;
    }

    public Long getDatePatternId() {
        return this.iDatePatternId;
    }

    public String getDatePatternName() {
        return this.iDatePatternName;
    }

    public String toDaysString() {
        String ret = "";
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.getDays() & Constants.DAY_CODES[i]) == 0) continue;
            ret = ret + Constants.DAY_NAMES_SHORT[i];
        }
        return ret;
    }

    public String toStartString() {
        int min = this.getSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int h = min / 60;
        int m = min % 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public String toStopString() {
        int min = (this.getSlot() + this.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - this.getBreakTime();
        int h = min / 60;
        int m = min % 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public boolean shareHours(XTime other) {
        return this.getSlot() + this.getLength() > other.getSlot() && other.getSlot() + other.getLength() > this.getSlot();
    }

    public boolean shareDays(XTime other) {
        return (this.getDays() & other.getDays()) != 0;
    }

    public boolean shareWeeks(XTime other) {
        return this.getWeeks() == null ? true : (other.getWeeks() == null ? true : this.getWeeks().intersects(other.getWeeks()));
    }

    public boolean hasIntersection(XTime other) {
        return other != null && this.shareDays(other) && this.shareHours(other) && this.shareWeeks(other);
    }

    public int nrSharedDays(XTime anotherLocation) {
        int ret = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            if ((this.getDays() & Constants.DAY_CODES[i]) == 0 || (anotherLocation.getDays() & Constants.DAY_CODES[i]) == 0) continue;
            ++ret;
        }
        return ret;
    }

    public int nrSharedHours(XTime anotherLocation) {
        int start;
        int end = Math.min(this.getSlot() + this.getLength(), anotherLocation.getSlot() + anotherLocation.getLength());
        return end < (start = Math.max(this.getSlot(), anotherLocation.getSlot())) ? 0 : end - start;
    }

    public int share(XTime other) {
        if (!this.hasIntersection(other)) {
            return 0;
        }
        return this.nrSharedDays(other) * this.nrSharedHours(other) * Constants.SLOT_LENGTH_MIN;
    }

    public Enumeration<Integer> getSlots() {
        return new SlotsEnum();
    }

    public Enumeration<Integer> getStartSlots() {
        return new StartSlotsEnum();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof XTime) {
            XTime x = (XTime)o;
            return this.getDays() == x.getDays() && this.getSlot() == x.getSlot() && this.getLength() == x.getLength() && this.getWeeks().equals(x.getWeeks());
        }
        if (o instanceof TimeLocation) {
            TimeLocation t = (TimeLocation)o;
            return this.getDays() == t.getDayCode() && this.getSlot() == t.getStartSlot() && this.getLength() == t.getLength() && this.getWeeks().equals(t.getWeekCode());
        }
        if (o instanceof CourseRequestInterface.FreeTime) {
            CourseRequestInterface.FreeTime ft = (CourseRequestInterface.FreeTime)o;
            return this.getDays() == ft.getDayCode() && this.getSlot() == ft.getStart() && this.getLength() == ft.getLength();
        }
        return false;
    }

    public String toString() {
        return (this.getDatePatternName() == null ? "" : this.getDatePatternName() + " ") + this.toDaysString() + " " + this.toStartString() + " - " + this.toStopString();
    }

    public static String datePatternName(Assignment assignment, String format) {
        int idx;
        if ("never".equals(format)) {
            return assignment.getDatePattern().getName();
        }
        if ("extended".equals(format) && assignment.getDatePattern().getType() != 3) {
            return assignment.getDatePattern().getName();
        }
        if ("alternate".equals(format) && assignment.getDatePattern().getType() == 1) {
            return assignment.getDatePattern().getName();
        }
        BitSet weekCode = assignment.getDatePattern().getPatternBitSet();
        if (weekCode.isEmpty()) {
            return assignment.getDatePattern().getName();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Session session = assignment.getDatePattern().getSession();
        Date start = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
        cal.setTime(start);
        cal.add(6, idx);
        Date first = null;
        int dayCode = assignment.getDays();
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size() && first == null; ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        first = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        first = cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        if (first == null) {
            return assignment.getDatePattern().getName();
        }
        cal.setTime(start);
        cal.add(6, idx);
        Date last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        last = cal.getTime();
                        break;
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        last = cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        if (last == null) {
            return assignment.getDatePattern().getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        return dpf.format(first) + (first.equals(last) ? "" : " - " + dpf.format(last));
    }

    public TimeLocation toTimeLocation() {
        return new TimeLocation(this.getDays(), this.getSlot(), this.getLength(), 0, 0.0, this.getDatePatternId(), this.getDatePatternName(), this.getWeeks(), this.getBreakTime());
    }

    public int getFirstMeeting(int dayOfWeekOffset) {
        if (this.iFirstMeeting == null) {
            if (this.getDays() != 0) {
                int idx = -1;
                while ((idx = this.getWeeks().nextSetBit(1 + idx)) >= 0) {
                    int dow = (idx + dayOfWeekOffset) % 7;
                    if ((this.getDays() & Constants.DAY_CODES[dow]) == 0) continue;
                    break;
                }
                this.iFirstMeeting = idx;
            } else {
                this.iFirstMeeting = this.getWeeks().nextSetBit(0);
            }
        }
        return this.iFirstMeeting;
    }

    public boolean isPast(int currentDateIdnex, AcademicSessionInfo session) {
        if (currentDateIdnex <= 0) {
            return false;
        }
        int fm = this.getFirstMeeting(session.getDayOfWeekOffset());
        return fm >= 0 && fm < currentDateIdnex;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iSlot = in.readInt();
        this.iLength = in.readInt();
        this.iBreakTime = in.readInt();
        this.iDays = in.readInt();
        this.iWeeks = (BitSet)in.readObject();
        this.iDatePatternId = in.readLong();
        if (this.iDatePatternId < 0L) {
            this.iDatePatternId = null;
        }
        this.iDatePatternName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.iSlot);
        out.writeInt(this.iLength);
        out.writeInt(this.iBreakTime);
        out.writeInt(this.iDays);
        out.writeObject(this.iWeeks);
        out.writeLong(this.iDatePatternId == null ? -1L : this.iDatePatternId);
        out.writeObject(this.iDatePatternName);
    }

    public static class XTimeSerializer
    implements Externalizer<XTime> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XTime object) throws IOException {
            object.writeExternal(output);
        }

        public XTime readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XTime(input);
        }
    }

    private class SlotsEnum
    extends StartSlotsEnum {
        int pos;

        private SlotsEnum() {
            this.pos = 0;
        }

        private boolean nextSlot() {
            if (this.pos + 1 < XTime.this.iLength) {
                ++this.pos;
                return true;
            }
            if (this.nextDay()) {
                this.pos = 0;
                return true;
            }
            return false;
        }

        @Override
        public Integer nextElement() {
            int slot = this.day * 288 + XTime.this.iSlot + this.pos;
            this.hasNext = this.nextSlot();
            return slot;
        }
    }

    private class StartSlotsEnum
    implements Enumeration<Integer> {
        int day = -1;
        boolean hasNext = this.nextDay();

        private StartSlotsEnum() {
        }

        boolean nextDay() {
            do {
                ++this.day;
                if (this.day < Constants.DAY_CODES.length) continue;
                return false;
            } while ((Constants.DAY_CODES[this.day] & XTime.this.iDays) == 0);
            return true;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext;
        }

        @Override
        public Integer nextElement() {
            int slot = this.day * 288 + XTime.this.iSlot;
            this.hasNext = this.nextDay();
            return slot;
        }
    }
}

