/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.reservation.Restriction;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRestrictionId;
import org.unitime.timetable.onlinesectioning.model.XRestrictionType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public abstract class XRestriction
extends XRestrictionId {
    private static final long serialVersionUID = 1L;
    private Set<Long> iConfigs = new HashSet<Long>();
    private Map<Long, Set<Long>> iSections = new HashMap<Long, Set<Long>>();
    private Set<Long> iIds = new HashSet<Long>();

    public XRestriction() {
    }

    public XRestriction(XRestrictionType type, Restriction restriction) {
        super(type, restriction.getOffering().getId(), restriction.getId());
        for (Config config : restriction.getConfigs()) {
            this.iConfigs.add(config.getId());
            this.iIds.add(-config.getId());
        }
        for (Map.Entry entry : restriction.getSections().entrySet()) {
            HashSet<Long> sections = new HashSet<Long>();
            for (Section section : (Set)entry.getValue()) {
                sections.add(section.getId());
                this.iIds.add(section.getId());
            }
            this.iSections.put(((Subpart)entry.getKey()).getId(), sections);
        }
    }

    public abstract boolean isApplicable(XStudent var1, XCourseId var2);

    public Set<Long> getConfigsIds() {
        return this.iConfigs;
    }

    public boolean hasConfigRestriction(Long configId) {
        return this.iIds.contains(-configId.longValue());
    }

    public boolean hasSectionRestriction(Long sectionId) {
        return this.iIds.contains(sectionId);
    }

    public Map<Long, Set<Long>> getSections() {
        return this.iSections;
    }

    public Set<Long> getSectionIds(Long subpartId) {
        return this.iSections.get(subpartId);
    }

    public boolean isIncluded(Long configId, List<XSection> sections) {
        if (this.iConfigs.isEmpty() && this.iSections.isEmpty()) {
            return false;
        }
        if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(configId)) {
            return false;
        }
        for (XSection section : sections) {
            Set<Long> reserved = this.iSections.get(section.getSubpartId());
            if (reserved == null || reserved.contains(section.getSectionId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrConfigs = in.readInt();
        this.iConfigs.clear();
        for (int i = 0; i < nrConfigs; ++i) {
            this.iConfigs.add(in.readLong());
        }
        int nrSubparts = in.readInt();
        this.iSections.clear();
        for (int i = 0; i < nrSubparts; ++i) {
            HashSet<Long> sections = new HashSet<Long>();
            this.iSections.put(in.readLong(), sections);
            int nrSection = in.readInt();
            for (int j = 0; j < nrSection; ++j) {
                sections.add(in.readLong());
            }
        }
        this.iIds.clear();
        int nrIds = in.readInt();
        for (int i = 0; i < nrIds; ++i) {
            this.iIds.add(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iConfigs.size());
        for (Long config : this.iConfigs) {
            out.writeLong(config);
        }
        Set<Map.Entry<Long, Set<Long>>> entries = this.iSections.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<Long, Set<Long>> entry : entries) {
            out.writeLong(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (Long id : entry.getValue()) {
                out.writeLong(id);
            }
        }
        out.writeInt(this.iIds.size());
        for (Long id : this.iIds) {
            out.writeLong(id);
        }
    }
}

