/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.util.Formats;

public class XEStudentEnrollment
implements StudentEnrollmentProvider {
    private static Logger sLog = Logger.getLogger(XEStudentEnrollment.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public XEStudentEnrollment() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getBannerReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getBannerReadTimeout() {
        return ApplicationProperties.getProperty("banner.xe.readTimeout", "60000");
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getBannerRecheck() {
        return ApplicationProperties.getProperty("banner.xe.recheck");
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isBannerWaitlist() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.waitlist", "false"));
    }

    protected float getMaxCredit(boolean admin) {
        String maxCredit;
        if (admin && (maxCredit = ApplicationProperties.getProperty("banner.xe.admin.maxCredit")) != null) {
            return Float.parseFloat(maxCredit);
        }
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxCredit", "-1"));
    }

    protected boolean isCheckMaxHours(boolean admin) {
        String checkMaxHours;
        if (admin && (checkMaxHours = ApplicationProperties.getProperty("banner.xe.admin.checkMaxHours")) != null) {
            return "true".equalsIgnoreCase(checkMaxHours);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.checkMaxHours", "false"));
    }

    protected ConditionalDropType getConditionalAddDrop(boolean admin) {
        String conditionalAddDrop;
        if (admin && (conditionalAddDrop = ApplicationProperties.getProperty("banner.xe.admin.conditionalAddDrop")) != null) {
            return ConditionalDropType.parseType(conditionalAddDrop);
        }
        return ConditionalDropType.parseType(ApplicationProperties.getProperty("banner.xe.conditionalAddDrop"));
    }

    protected boolean throwExceptionWhenNoChange(boolean admin) {
        String conditionalAddDrop;
        if (admin && (conditionalAddDrop = ApplicationProperties.getProperty("banner.xe.admin.errorWhenNoChange")) != null) {
            return "true".equalsIgnoreCase(conditionalAddDrop);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.errorWhenNoChange", "false"));
    }

    protected float getMaxHoursDefault() {
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxHoursDefault", "18"));
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "persona");
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected boolean isPreserveGradeMode() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.keepGradeMode", "false"));
    }

    protected String getResetGradeModesRegExp() {
        return ApplicationProperties.getProperty("banner.xe.resetGradeModes", "H|Q|R");
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && student.getStudentId() != null) {
            return;
        }
        ClientResource resource = null;
        try {
            String pin = helper.getPin();
            if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                pin = student.getPin();
            }
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
            boolean admin = manager & this.isBannerAdmin();
            if (helper.isDebugEnabled()) {
                helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + (admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
            }
            resource = new ClientResource(this.getBannerSite());
            resource.setNext((Uniform)this.iClient);
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
            Gson gson = this.getGson(helper);
            XEInterface.RegisterResponse original = null;
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("bannerId", this.getBannerId(student));
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
            if (admin) {
                String param = this.getAdminParameter();
                resource.addQueryParameter(param, "SB");
                helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
            } else if (pin != null && !pin.isEmpty()) {
                resource.addQueryParameter("altPin", pin);
                helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
            }
            long t0 = System.currentTimeMillis();
            try {
                resource.get(MediaType.APPLICATION_JSON);
            }
            catch (ResourceException exception) {
                helper.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(error.message);
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(error.description);
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(error.errorMessage);
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
            if (current != null && !current.isEmpty()) {
                original = (XEInterface.RegisterResponse)current.get(0);
            }
            if (original != null && helper.isDebugEnabled()) {
                helper.debug("Current registration: " + gson.toJson((Object)original));
            }
            if (original == null || !original.validStudent.booleanValue()) {
                String bannerRecheck = this.getBannerRecheck();
                String reason = null;
                boolean noreason = true;
                boolean recheck = true;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerRecheck == null || !m.matches(bannerRecheck)) {
                            recheck = false;
                        }
                        noreason = false;
                        if ("Your PIN is invalid.".equals(m)) {
                            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED, true);
                            if (pin == null || pin.isEmpty()) continue;
                        }
                        if (reason == null) {
                            reason = m;
                            continue;
                        }
                        reason = reason + "<br>" + m;
                    }
                }
                if (noreason) {
                    reason = "Failed to check student registration eligility.";
                    if (bannerRecheck == null || !reason.matches(bannerRecheck)) {
                        recheck = false;
                    }
                }
                if (recheck) {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT, true);
                } else {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                }
                check.setMessage(reason);
            } else if (student.getStudentId() == null) {
                check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later.");
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                if (this.isCanRequestUpdates()) {
                    ArrayList<XStudent> students = new ArrayList<XStudent>(1);
                    students.add(student);
                    this.requestUpdate(server, helper, students);
                }
            } else {
                OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                HashSet<String> sectionExternalIds = new HashSet<String>();
                for (XRequest request : student.getRequests()) {
                    XCourseRequest r;
                    Object e;
                    helper.getAction().addRequest(OnlineSectioningHelper.toProto(request));
                    if (!(request instanceof XCourseRequest) || (e = (r = (XCourseRequest)request).getEnrollment()) == null) continue;
                    XOffering xOffering = server.getOffering(((XCourseId)e).getOfferingId());
                    for (XSection section : xOffering.getSections((XEnrollment)e)) {
                        stored.addSection(OnlineSectioningHelper.toProto(section, (XEnrollment)e));
                        String extId = section.getExternalId(((XCourseId)e).getCourseId());
                        if (extId == null) continue;
                        sectionExternalIds.add(extId);
                    }
                }
                helper.getAction().addEnrollment(stored);
                OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                String added = "";
                String resetGradeModes = this.getResetGradeModesRegExp();
                if (original.registrations != null) {
                    for (XEInterface.Registration registration : original.registrations) {
                        if (!registration.isRegistered()) continue;
                        if (!sectionExternalIds.remove(registration.courseReferenceNumber) && campus.equals(registration.campus) && !this.eligibilityIgnoreBannerRegistration(server, helper, student, registration)) {
                            added = added + (added.isEmpty() ? "" : ", ") + registration.courseReferenceNumber;
                        }
                        OnlineSectioningLog.Section.Builder section = external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                        if (registration.registrationStatusDate != null) {
                            section.setTimeStamp(registration.registrationStatusDate.getMillis());
                        }
                        if (registration.gradingMode != null && !registration.gradingMode.isEmpty()) {
                            check.addGradeMode(registration.courseReferenceNumber, registration.gradingMode, registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes));
                        }
                        if (registration.creditHour == null) continue;
                        check.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                    }
                }
                helper.getAction().addEnrollment(external);
                String removed = "";
                for (String s : sectionExternalIds) {
                    removed = removed + (removed.isEmpty() ? "" : ", ") + s;
                }
                if (!added.isEmpty() || !removed.isEmpty()) {
                    if (this.updateStudentRegistration(server, helper, student, original.registrations)) {
                        return;
                    }
                    check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later (" + (removed.isEmpty() ? "added " + added : (added.isEmpty() ? "dropped " + removed : "added " + added + ", dropped " + removed)) + ")");
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                    if (this.isCanRequestUpdates()) {
                        ArrayList<XStudent> arrayList = new ArrayList<XStudent>(1);
                        arrayList.add(student);
                        this.requestUpdate(server, helper, arrayList);
                    }
                }
            }
        }
        catch (SectioningException e) {
            helper.info("Banner eligibility failed: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.warn("Banner eligibility failed: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean eligibilityIgnoreBannerRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, XEInterface.Registration reg) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<StudentEnrollmentProvider.EnrollmentFailure> enroll(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<StudentEnrollmentProvider.EnrollmentRequest> enrollments, Set<Long> lockedCourses, OnlineSectioningInterface.GradeModes gradeModes) throws SectioningException {
        ClientResource resource = null;
        try {
            ArrayList<StudentEnrollmentProvider.EnrollmentFailure> fails;
            block169: {
                Object course;
                float maxCredit;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                    pin = student.getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                String campus = this.getBannerCampus(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean admin = manager & this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Enrolling " + student.getName() + " to " + enrollments + " (term: " + term + ", id:" + this.getBannerId(student) + (admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                if ((maxCredit = this.getMaxCredit(admin)) > 0.0f) {
                    float enrolled = 0.0f;
                    for (XRequest xRequest : student.getRequests()) {
                        XCourseRequest cr;
                        if (!(xRequest instanceof XCourseRequest) || (cr = (XCourseRequest)xRequest).getEnrollment() == null) continue;
                        enrolled += cr.getEnrollment().getCredit(server);
                    }
                    float credit = 0.0f;
                    for (StudentEnrollmentProvider.EnrollmentRequest req : enrollments) {
                        credit += req.getCredit();
                    }
                    if (credit > maxCredit && credit > enrolled) {
                        throw new SectioningException(ApplicationProperties.getProperty("banner.xe.messages.maxCredit", "Maximum of {max} hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCredit > enrolled ? maxCredit : enrolled))).replace("{credit}", sCreditFormat.format(Float.valueOf(credit)))).setCanRequestOverride(true);
                    }
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin) {
                    String string = this.getAdminParameter();
                    resource.addQueryParameter(string, "SB");
                    helper.getAction().addOptionBuilder().setKey(string).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long l = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error2 = response.getError();
                        if (error2 != null && error2.message != null) {
                            throw new SectioningException(error2.message);
                        }
                        if (error2 != null && error2.description != null) {
                            throw new SectioningException(error2.description);
                        }
                        if (error2 != null && error2.errorMessage != null) {
                            throw new SectioningException(error2.errorMessage);
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - l);
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("original").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original == null || !original.validStudent.booleanValue()) {
                    String reason = null;
                    if (original != null && original.failureReasons != null) {
                        for (String m : original.failureReasons) {
                            if (reason == null) {
                                reason = m;
                                continue;
                            }
                            reason = reason + "\n" + m;
                        }
                    }
                    throw new SectioningException(reason == null ? "Failed to check student registration status." : reason);
                }
                HashMap<String, XEInterface.Registration> registered = new HashMap<String, XEInterface.Registration>();
                HashSet<String> noadd = new HashSet<String>();
                HashSet<String> nodrop = new HashSet<String>();
                HashMap<String, String> actions = new HashMap<String, String>();
                HashSet<String> notregistered = new HashSet<String>();
                if (helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                HashMap<String, String> code2desc = new HashMap<String, String>();
                if (original.registrations != null) {
                    for (XEInterface.Registration reg : original.registrations) {
                        if (reg.isRegistered()) {
                            registered.put(reg.courseReferenceNumber, reg);
                            if (!reg.canDrop(admin, actions)) {
                                nodrop.add(reg.courseReferenceNumber);
                            }
                            if (reg.gradingMode == null) continue;
                            code2desc.put(reg.gradingMode, reg.gradingModeDescription);
                            continue;
                        }
                        notregistered.add(reg.courseReferenceNumber);
                        if (reg.canAdd(admin)) continue;
                        noadd.add(reg.courseReferenceNumber);
                    }
                }
                if (this.isCheckMaxHours(admin)) {
                    Float maxHours = original.maxHours;
                    if (maxHours == null || maxHours.floatValue() <= 0.0f) {
                        maxHours = Float.valueOf(this.getMaxHoursDefault());
                    }
                    float credit = 0.0f;
                    for (StudentEnrollmentProvider.EnrollmentRequest req : enrollments) {
                        credit += req.getCredit();
                    }
                    if (credit > maxHours.floatValue()) {
                        throw new SectioningException(ApplicationProperties.getProperty("banner.xe.messages.maxHours", "Maximum of {max} hours exceeded.").replace("{max}", sCreditFormat.format(maxHours)).replace("{credit}", sCreditFormat.format(Float.valueOf(credit)))).setCanRequestOverride(true);
                    }
                }
                boolean changed = false;
                boolean hasDrop = false;
                HashMap id2section = new HashMap();
                HashMap<Object, XCourse> id2course = new HashMap<Object, XCourse>();
                HashSet<Object> added = new HashSet<Object>();
                XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, this.getBannerId(student), pin, admin);
                fails = new ArrayList<StudentEnrollmentProvider.EnrollmentFailure>();
                HashSet<Object> failed = new HashSet<Object>();
                HashSet<Object> checked = new HashSet<Object>();
                HashSet<Long> lockedCoursesWithChanges = new HashSet<Long>();
                for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                    XCourse course2 = enrollmentRequest.getCourse();
                    if (lockedCourses.contains(course2.getCourseId()) && !enrollmentRequest.getSections().isEmpty()) {
                        for (XSection section : enrollmentRequest.getSections()) {
                            void var43_115;
                            String id = section.getExternalId(course2.getCourseId());
                            XEInterface.Registration registration = (XEInterface.Registration)registered.get(id);
                            if (registration != null) {
                                void var43_112;
                                List list;
                                if (added.add(id)) {
                                    req.keep(id);
                                }
                                if ((list = (List)id2section.get(id)) == null) {
                                    ArrayList arrayList = new ArrayList();
                                    id2section.put(id, arrayList);
                                }
                                var43_112.add(section);
                                id2course.put(id, course2);
                                enrollmentRequest.setGradeMode(registration.gradingMode);
                                enrollmentRequest.setCreditHour(id, registration.creditHour);
                                continue;
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course2, section, MESSAGES.courseLocked(course2.getCourseName()), false, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_LOCKED.name(), MESSAGES.courseLocked(course2.getCourseName()))));
                            checked.add(id);
                            failed.add(id);
                            List list = (List)id2section.get(id);
                            if (list == null) {
                                ArrayList arrayList = new ArrayList();
                                id2section.put(id, arrayList);
                            }
                            var43_115.add(section);
                            id2course.put(id, course2);
                            lockedCoursesWithChanges.add(course2.getCourseId());
                        }
                        continue;
                    }
                    for (XSection section : enrollmentRequest.getSections()) {
                        void var43_119;
                        String id2 = section.getExternalId(course2.getCourseId());
                        XEInterface.Registration registration = (XEInterface.Registration)registered.get(id2);
                        if (registration == null && (!section.isEnabledForScheduling() || noadd.contains(id2))) {
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course2, section, "Section not available for student scheduling.", false, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED.name(), "Section not available for student scheduling.")));
                            checked.add(id2);
                            failed.add(id2);
                        } else if (registration != null) {
                            if (added.add(id2)) {
                                req.keep(id2);
                            }
                            enrollmentRequest.setGradeMode(registration.gradingMode);
                            enrollmentRequest.setCreditHour(id2, registration.creditHour);
                        } else {
                            changed = true;
                            if (added.add(id2)) {
                                req.add(id2, notregistered.contains(id2));
                            }
                        }
                        List list = (List)id2section.get(id2);
                        if (list == null) {
                            ArrayList arrayList = new ArrayList();
                            id2section.put(id2, arrayList);
                        }
                        var43_119.add(section);
                        id2course.put(id2, course2);
                    }
                }
                for (Map.Entry entry : registered.entrySet()) {
                    String id3 = (String)entry.getKey();
                    if (added.contains(id3)) continue;
                    boolean drop = true;
                    boolean found = false;
                    for (XRequest xRequest : student.getRequests()) {
                        if (!(xRequest instanceof XCourseRequest)) continue;
                        for (XCourseId xCourseId : ((XCourseRequest)xRequest).getCourseIds()) {
                            XOffering offering = server.getOffering(xCourseId.getOfferingId());
                            if (offering == null) continue;
                            for (XConfig xConfig : offering.getConfigs()) {
                                for (XSubpart s : xConfig.getSubparts()) {
                                    for (XSection x : s.getSections()) {
                                        if (!id3.equals(x.getExternalId(xCourseId.getCourseId()))) continue;
                                        found = true;
                                        ArrayList<XSection> sections = (ArrayList<XSection>)id2section.get(id3);
                                        if (sections == null) {
                                            sections = new ArrayList<XSection>();
                                            id2section.put(id3, sections);
                                        }
                                        sections.add(x);
                                        id2course.put(id3, offering.getCourse(xCourseId.getCourseId()));
                                        if (!x.isEnabledForScheduling() || nodrop.contains(id3)) {
                                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(offering.getCourse(xCourseId), x, "Section not available for student scheduling.", true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED.name(), "Section not available for student scheduling.")));
                                            checked.add(id3);
                                            failed.add(id3);
                                            drop = false;
                                        } else if (lockedCoursesWithChanges.contains(xCourseId.getCourseId())) {
                                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(offering.getCourse(xCourseId), x, MESSAGES.courseLocked(xCourseId.getCourseName()), true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_LOCKED.name(), MESSAGES.courseLocked(xCourseId.getCourseName()))));
                                            checked.add(id3);
                                            failed.add(id3);
                                            drop = false;
                                        }
                                        for (StudentEnrollmentProvider.EnrollmentRequest request : enrollments) {
                                            if (!request.getCourse().equals(xCourseId)) continue;
                                            request.setGradeMode(((XEInterface.Registration)entry.getValue()).gradingMode);
                                            request.setCreditHour(id3, ((XEInterface.Registration)entry.getValue()).creditHour);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!found && !campus.equals(((XEInterface.Registration)entry.getValue()).campus)) {
                        if (!added.add(id3)) continue;
                        req.keep(id3);
                        continue;
                    }
                    if (drop) {
                        changed = true;
                        req.drop(id3, actions);
                        hasDrop = true;
                        continue;
                    }
                    if (!added.add(id3)) continue;
                    req.keep(id3);
                }
                switch (this.getConditionalAddDrop(admin)) {
                    case ALWAYS: {
                        req.setConditionalAddDrop(true);
                        break;
                    }
                    case HAS_DROP: {
                        if (!hasDrop) break;
                        req.setConditionalAddDrop(true);
                        break;
                    }
                    case IS_REGISTERED: {
                        if (registered.isEmpty()) break;
                        req.setConditionalAddDrop(true);
                        break;
                    }
                }
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
                if (req.isEmpty() || !changed) {
                    if (!fails.isEmpty()) {
                        for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                            helper.getAction().addMessageBuilder().setText(enrollmentFailure.toString()).setLevel(OnlineSectioningLog.Message.Level.WARN);
                        }
                    }
                    Iterator iterator = fails;
                    return iterator;
                }
                long t1 = System.currentTimeMillis();
                try {
                    resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error3 = response.getError();
                        if (error3 != null && error3.message != null) {
                            throw new SectioningException(error3.message);
                        }
                        if (error3 != null && error3.description != null) {
                            throw new SectioningException(error3.description);
                        }
                        if (error3 != null && error3.errorMessage != null) {
                            throw new SectioningException(error3.errorMessage);
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                }
                XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
                if (response == null || !response.validStudent.booleanValue()) {
                    String reason = null;
                    if (response != null && response.failureReasons != null) {
                        for (String m : response.failureReasons) {
                            if (reason == null) {
                                reason = m;
                                continue;
                            }
                            reason = reason + "\n" + m;
                        }
                    }
                    throw new SectioningException(reason == null ? "Failed to enroll student." : reason);
                }
                HashSet<String> outcome = new HashSet<String>();
                String resetGradeModes = this.getResetGradeModesRegExp();
                if (response.registrations != null) {
                    OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                    external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                    for (XEInterface.Registration registration : response.registrations) {
                        XCourse xCourse;
                        void var46_171;
                        String string = registration.courseReferenceNumber;
                        checked.add(string);
                        ArrayList<StudentEnrollmentProvider.EnrollmentError> errors = new ArrayList<StudentEnrollmentProvider.EnrollmentError>();
                        Object var46_170 = null;
                        if (registration.crnErrors != null) {
                            for (XEInterface.CrnError crnError : registration.crnErrors) {
                                if (var46_171 == null) {
                                    String string2 = crnError.message;
                                } else {
                                    String string3 = (String)var46_171 + "\n" + crnError.message;
                                }
                                errors.add(new StudentEnrollmentProvider.EnrollmentError(crnError.messageType, crnError.message));
                            }
                        }
                        if ("Registered".equals(registration.statusDescription)) {
                            external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                            outcome.add(registration.courseReferenceNumber);
                            if (gradeModes != null && registration.gradingMode != null) {
                                gradeModes.addGradeMode(registration.courseReferenceNumber, new OnlineSectioningInterface.GradeMode(registration.gradingMode, registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes)));
                            }
                            if (gradeModes != null && registration.creditHour != null) {
                                gradeModes.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                            }
                            if (added.contains(string)) {
                                XCourse xCourse2;
                                if (var46_171 == null || (xCourse2 = (XCourse)id2course.get(string)) == null) continue;
                                for (XSection section : (List)id2section.get(string)) {
                                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure(xCourse2, section, (String)var46_171, true, errors));
                                    failed.add(string);
                                }
                                continue;
                            }
                        }
                        if ("Deleted".equals(registration.statusDescription) || "Dropped".equals(registration.statusDescription)) continue;
                        if (var46_171 == null && response.registrationException != null) {
                            String string4 = response.registrationException;
                            errors.add(new StudentEnrollmentProvider.EnrollmentError("Unable to make requested changes so your schedule was not changed.".equals(response.registrationException) ? "IGNORE" : "UNKNOWN", response.registrationException));
                        }
                        if ((xCourse = (XCourse)id2course.get(string)) == null) continue;
                        for (XSection section : (List)id2section.get(string)) {
                            void var46_176;
                            if (var46_176 == null && !failed.add(string)) continue;
                            if (var46_176 == null) {
                                errors.add(new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", added.contains(string) ? "Enrollment failed." : "Drop failed."));
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(xCourse, section, (String)(var46_176 == null ? (added.contains(string) ? "Enrollment failed." : "Drop failed.") : var46_176), "Registered".equals(registration.statusDescription), errors));
                        }
                    }
                    helper.getAction().addEnrollment(external);
                }
                if (response.failedRegistrations != null) {
                    void var42_90;
                    TreeSet<StudentEnrollmentProvider.EnrollmentError> error4 = new TreeSet<StudentEnrollmentProvider.EnrollmentError>();
                    for (XEInterface.FailedRegistration failedRegistration : response.failedRegistrations) {
                        if (failedRegistration.failedCRN != null) {
                            String string = failedRegistration.failedCRN;
                            course = (XCourse)id2course.get(string);
                            if (course != null) {
                                for (XSection xSection : (List)id2section.get(string)) {
                                    if (failedRegistration.failure == null && !failed.add(string)) continue;
                                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, xSection, failedRegistration.failure == null ? "Enrollment failed." : failedRegistration.failure, false, new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", failedRegistration.failure == null ? "Enrollment failed." : failedRegistration.failure)));
                                }
                            }
                            checked.add(string);
                            continue;
                        }
                        if (failedRegistration.failure == null) continue;
                        error4.add(new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", failedRegistration.failure));
                    }
                    Object var42_89 = null;
                    for (StudentEnrollmentProvider.EnrollmentError enrollmentError : error4) {
                        if (var42_90 == null) {
                            String string = enrollmentError.getMessage();
                            continue;
                        }
                        String string = (String)var42_90 + "\n" + enrollmentError.getMessage();
                    }
                    if (response.registrationException != null) {
                        if (var42_90 == null) {
                            String string = response.registrationException;
                        } else {
                            String string = (String)var42_90 + "\n" + response.registrationException;
                        }
                        error4.add(new StudentEnrollmentProvider.EnrollmentError("Unable to make requested changes so your schedule was not changed.".equals(response.registrationException) ? "IGNORE" : "UNKNOWN", response.registrationException));
                    }
                    for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                        course = enrollmentRequest.getCourse();
                        for (XSection xSection : enrollmentRequest.getSections()) {
                            void var42_97;
                            String string = xSection.getExternalId(((XCourseId)course).getCourseId());
                            if (checked.contains(string) || var42_97 == null && !failed.add(string)) continue;
                            if (var42_97 == null) {
                                fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, xSection, "Enrollment failed.", false, new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", "Enrollment failed.")));
                                continue;
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, xSection, (String)var42_97, false, (Collection<StudentEnrollmentProvider.EnrollmentError>)error4));
                        }
                    }
                }
                if (outcome.equals(registered.keySet()) && !fails.isEmpty() && this.throwExceptionWhenNoChange(admin)) {
                    String message = "";
                    for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                        if ("Unable to make requested changes so your schedule was not changed.".equals(enrollmentFailure.getMessage())) continue;
                        message = message + (message.isEmpty() ? "" : "<br>") + enrollmentFailure;
                    }
                    SectioningException sectioningException = new SectioningException(message.replace("\n", " ")).setCanRequestOverride(true);
                    for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                        if (enrollmentFailure.getSection() != null && !"Unable to make requested changes so your schedule was not changed.".equals(enrollmentFailure.getMessage())) {
                            sectioningException.setSectionMessage(enrollmentFailure.getSection().getSectionId(), enrollmentFailure.getMessage());
                        }
                        if (!enrollmentFailure.hasErrors()) continue;
                        for (StudentEnrollmentProvider.EnrollmentError enrollmentError : enrollmentFailure.getErrors()) {
                            if ("IGNORE".equals(enrollmentError.getCode())) continue;
                            sectioningException.addError(new ClassAssignmentInterface.ErrorMessage(enrollmentFailure.getCourse().getCourseName(), enrollmentFailure.getSection().getExternalId(enrollmentFailure.getCourse().getCourseId()), enrollmentError.getCode(), enrollmentError.getMessage()));
                        }
                    }
                    throw sectioningException;
                }
                if (this.isPreserveGradeMode() && response.registrations != null) {
                    XEInterface.RegisterRequest reqGM = new XEInterface.RegisterRequest(this.getBannerTerm(server.getAcademicSession()), this.getBannerId(student), null, true);
                    try {
                        if (resetGradeModes != null && !resetGradeModes.isEmpty()) {
                            block67: for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                                String string = enrollmentRequest.getGradeMode();
                                if (string == null || !string.matches(resetGradeModes)) continue;
                                for (XEInterface.Registration registration : response.registrations) {
                                    if (!"Registered".equals(registration.statusDescription) || !enrollmentRequest.getCourse().equals(id2course.get(registration.courseReferenceNumber)) || registration.gradingMode == null || string.equals(registration.gradingMode)) continue;
                                    enrollmentRequest.resetGradeMode(registration.gradingMode);
                                    helper.info("Resetting grade mode for " + enrollmentRequest.getCourse().getCourseName() + " from " + string + " to " + registration.gradingMode);
                                    continue block67;
                                }
                            }
                        }
                        reqGM.courseReferenceNumbers = new ArrayList<XEInterface.CourseReferenceNumber>();
                        reqGM.actionsAndOptions = new ArrayList<XEInterface.RegisterAction>();
                        block69: for (XEInterface.Registration registration : response.registrations) {
                            if (!"Registered".equals(registration.statusDescription)) continue;
                            reqGM.courseReferenceNumbers.add(new XEInterface.CourseReferenceNumber(registration.courseReferenceNumber));
                            XCourse xCourse = (XCourse)id2course.get(registration.courseReferenceNumber);
                            if (xCourse == null) continue;
                            for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                                if (!enrollmentRequest.getCourse().equals(xCourse)) continue;
                                String string = enrollmentRequest.getGradeMode();
                                if (string == null || string.equals(registration.gradingMode)) continue block69;
                                helper.info("Changing grade mode for " + enrollmentRequest.getCourse().getCourseName() + " " + registration.courseReferenceNumber + " from " + registration.gradingMode + " to " + string);
                                XEInterface.RegisterAction registerAction = new XEInterface.RegisterAction(registration.courseReferenceNumber);
                                registerAction.selectedGradingMode = string;
                                reqGM.actionsAndOptions.add(registerAction);
                                continue block69;
                            }
                        }
                        if (reqGM.actionsAndOptions.isEmpty()) break block169;
                        helper.getAction().addOptionBuilder().setKey("gm_request").setValue(gson.toJson((Object)reqGM));
                        long l2 = System.currentTimeMillis();
                        try {
                            resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(reqGM));
                        }
                        catch (ResourceException resourceException) {
                            helper.getAction().setApiException(resourceException.getMessage());
                            try {
                                XEInterface.ErrorResponse responseGM = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                                helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)responseGM));
                                XEInterface.Error error = responseGM.getError();
                                if (error != null && error.message != null) {
                                    throw new SectioningException(error.message);
                                }
                                if (error != null && error.description != null) {
                                    throw new SectioningException(error.description);
                                }
                                if (error != null && error.errorMessage != null) {
                                    throw new SectioningException(error.errorMessage);
                                }
                                throw resourceException;
                            }
                            catch (SectioningException e) {
                                helper.getAction().setApiException(e.getMessage());
                                throw e;
                            }
                            catch (Throwable t) {
                                throw resourceException;
                            }
                        }
                        finally {
                            helper.getAction().setApiPostTime(helper.getAction().getApiPostTime() + (System.currentTimeMillis() - l2));
                        }
                        XEInterface.RegisterResponse registerResponse = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("gm_response").setValue(gson.toJson((Object)registerResponse));
                        if (registerResponse == null || !registerResponse.validStudent.booleanValue()) {
                            Object reason = null;
                            if (registerResponse != null && registerResponse.failureReasons != null) {
                                for (String string : registerResponse.failureReasons) {
                                    if (reason == null) {
                                        reason = string;
                                        continue;
                                    }
                                    reason = (String)reason + "\n" + string;
                                }
                            }
                            throw new SectioningException((String)(reason == null ? "Failed to change grade modes." : reason));
                        }
                        if (registerResponse.registrations == null) break block169;
                        for (XEInterface.Registration registration : registerResponse.registrations) {
                            if (!"Registered".equals(registration.statusDescription)) continue;
                            if (registration.gradingMode != null) {
                                String string = (String)code2desc.get(registration.gradingMode);
                                gradeModes.addGradeMode(registration.courseReferenceNumber, new OnlineSectioningInterface.GradeMode(registration.gradingMode, string != null ? string : registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes)));
                            }
                            if (registration.creditHour == null) continue;
                            gradeModes.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                        }
                    }
                    catch (Exception exception) {
                        block73: for (XEInterface.RegisterAction registerAction : reqGM.actionsAndOptions) {
                            course = (XCourse)id2course.get(registerAction.courseReferenceNumber);
                            if (course == null) continue;
                            for (XSection xSection : (List)id2section.get(registerAction.courseReferenceNumber)) {
                                for (StudentEnrollmentProvider.EnrollmentFailure ef : fails) {
                                    if (!xSection.equals(ef.getSection())) continue;
                                    ef.addError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_GRADE_MODE.name(), "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + exception.getMessage());
                                    ef.setMessage(ef.getMessage() + "\nFailed to change grade mode for " + registerAction.courseReferenceNumber + ": " + exception.getMessage());
                                    continue block73;
                                }
                            }
                            Iterator iterator = ((List)id2section.get(registerAction.courseReferenceNumber)).iterator();
                            if (!iterator.hasNext()) continue;
                            XSection xSection = (XSection)iterator.next();
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, xSection, "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + exception.getMessage(), true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_GRADE_MODE.name(), "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + exception.getMessage())));
                        }
                    }
                }
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.gradeModeWarnings", "true"))) {
                block76: for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                    if (!enrollmentRequest.hasGradeMode()) continue;
                    String string = enrollmentRequest.getGradeMode();
                    for (XSection section : enrollmentRequest.getSections()) {
                        OnlineSectioningInterface.GradeMode gradeMode = gradeModes.getGradeMode(section.getExternalId(enrollmentRequest.getCourse().getCourseId()));
                        if (gradeMode == null || string.equals(gradeMode.getCode())) continue;
                        fails.add(new StudentEnrollmentProvider.EnrollmentFailure(enrollmentRequest.getCourse(), section, ApplicationProperties.getProperty("banner.xe.warn.gradeModeChanged", "Grade mode changed back to {label}.").replace("{course}", enrollmentRequest.getCourse().getCourseName()).replace("{label}", gradeMode.getLabel()).replace("{code}", gradeMode.getCode()), true).setInfo());
                        continue block76;
                    }
                }
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.creditWarnings", "true"))) {
                for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                    if (!enrollmentRequest.hasCreditHour()) continue;
                    float f = enrollmentRequest.getCreditHour().floatValue();
                    float f2 = 0.0f;
                    XSection creditSection = null;
                    Object var46_198 = null;
                    for (XSection xSection : enrollmentRequest.getSections()) {
                        void var46_199;
                        String crn = xSection.getExternalId(enrollmentRequest.getCourse().getCourseId());
                        if (crn == null || crn.equals(var46_199)) continue;
                        Float credit = gradeModes.getCreditHour(crn);
                        if (credit != null) {
                            f2 += credit.floatValue();
                            if (creditSection == null || credit.floatValue() > 0.0f) {
                                creditSection = xSection;
                            }
                        }
                        String string = crn;
                    }
                    if (!((double)Math.abs(f2 - f) > 0.01) || creditSection == null) continue;
                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure(enrollmentRequest.getCourse(), creditSection, ApplicationProperties.getProperty("banner.xe.warn.creditChanged", "Variable credit changed back to {credit} credit hour(s).").replace("{course}", enrollmentRequest.getCourse().getCourseName()).replace("{credit}", Formats.getNumberFormat("0.#").format(Float.valueOf(f2))), true).setInfo());
                }
            }
            if (helper.isDebugEnabled()) {
                helper.debug("Return: " + fails);
            }
            if (!fails.isEmpty()) {
                for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                    helper.getAction().addMessageBuilder().setText(enrollmentFailure.toString()).setLevel(OnlineSectioningLog.Message.Level.WARN);
                }
            }
            Iterator iterator = fails;
            return iterator;
        }
        catch (SectioningException e) {
            helper.info("Banner enrollment failed: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.warn("Banner enrollment failed: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isAllowWaitListing() {
        return this.isBannerAdmin() && this.isBannerWaitlist();
    }

    @Override
    public boolean requestUpdate(OnlineSectioningServer server, OnlineSectioningHelper helper, Collection<XStudent> students) throws SectioningException {
        return false;
    }

    protected boolean updateStudentRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XEInterface.Registration> registration) throws SectioningException {
        return false;
    }

    @Override
    public boolean isCanRequestUpdates() {
        return false;
    }

    @Override
    public XEnrollment resection(OnlineSectioningServer server, OnlineSectioningHelper helper, SectioningRequest sectioningRequest, XEnrollment enrollment) throws SectioningException {
        ClientResource resource = null;
        try {
            XEInterface.RegisterResponse original;
            XStudent student = sectioningRequest.getStudent();
            XCourseId course = sectioningRequest.getRequest().getCourseIdByOfferingId(sectioningRequest.getOffering().getOfferingId());
            TreeSet<String> idsToAdd = new TreeSet<String>();
            TreeSet<String> idsToDrop = new TreeSet<String>();
            if (sectioningRequest.getLastEnrollment() != null) {
                for (XSection section : sectioningRequest.getOldOffering().getSections(sectioningRequest.getLastEnrollment())) {
                    idsToDrop.add(section.getExternalId(course.getCourseId()));
                }
            }
            if (enrollment != null) {
                for (XSection section : sectioningRequest.getOffering().getSections(enrollment)) {
                    idsToAdd.add(section.getExternalId(course.getCourseId()));
                }
            }
            Object i = idsToDrop.iterator();
            while (i.hasNext()) {
                if (!idsToAdd.remove(i.next())) continue;
                i.remove();
            }
            if (idsToAdd.isEmpty() && idsToDrop.isEmpty()) {
                i = enrollment;
                return i;
            }
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            if (helper.isDebugEnabled()) {
                if (!idsToAdd.isEmpty()) {
                    helper.debug("Enrolling " + student.getName() + " to " + course.getCourseName() + " (term: " + term + ", id:" + this.getBannerId(student) + (idsToDrop.isEmpty() ? "" : ", drop: " + idsToDrop) + ", add: " + idsToAdd + ")");
                } else {
                    helper.debug("Dropping " + student.getName() + " from " + course.getCourseName() + " (term: " + term + ", id:" + this.getBannerId(student) + ", drop: " + idsToDrop + ")");
                }
            }
            resource = new ClientResource(this.getBannerSite());
            resource.setNext((Uniform)this.iClient);
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(true), this.getBannerPassword(true));
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("bannerId", this.getBannerId(student));
            resource.addQueryParameter(this.getAdminParameter(), "SB");
            sectioningRequest.getAction().addOptionBuilder().setKey("term").setValue(term);
            sectioningRequest.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
            Gson gson = this.getGson(helper);
            long t0 = System.currentTimeMillis();
            try {
                resource.get(MediaType.APPLICATION_JSON);
            }
            catch (ResourceException exception) {
                helper.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(error.message);
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(error.description);
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(error.errorMessage);
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                sectioningRequest.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
            sectioningRequest.getAction().addOptionBuilder().setKey("original").setValue(gson.toJson((Object)current));
            XEInterface.RegisterResponse registerResponse = original = current != null && !current.isEmpty() ? (XEInterface.RegisterResponse)current.get(0) : null;
            if (original != null && helper.isDebugEnabled()) {
                helper.debug("Current registration: " + gson.toJson((Object)original));
            }
            if (original == null || !original.validStudent.booleanValue()) {
                String reason = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (reason == null) {
                            reason = m;
                            continue;
                        }
                        reason = reason + "\n" + m;
                    }
                }
                throw new SectioningException(reason == null ? "Failed to check student registration status." : reason);
            }
            XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, this.getBannerId(student), null, true);
            if (this.getConditionalAddDrop(true) != ConditionalDropType.NEVER) {
                req.setConditionalAddDrop(true);
            }
            boolean changed = false;
            HashMap<String, String> actions = new HashMap<String, String>();
            if (original.registrations != null) {
                for (XEInterface.Registration reg : original.registrations) {
                    if (reg.isRegistered()) {
                        if (idsToDrop.contains(reg.courseReferenceNumber)) {
                            if (!reg.canDrop(true, actions)) {
                                throw new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                            }
                            req.drop(reg.courseReferenceNumber, actions);
                            changed = true;
                            continue;
                        }
                        req.keep(reg.courseReferenceNumber);
                        continue;
                    }
                    if (!idsToAdd.remove(reg.courseReferenceNumber)) continue;
                    if (!reg.canAdd(true)) {
                        throw new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                    }
                    req.add(reg.courseReferenceNumber, true);
                }
            }
            for (String id : idsToAdd) {
                req.add(id, false);
                changed = true;
            }
            if (helper.isDebugEnabled()) {
                helper.debug("Request: " + gson.toJson((Object)req));
            }
            sectioningRequest.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
            if (req.isEmpty() || !changed) {
                XEnrollment xEnrollment = enrollment;
                return xEnrollment;
            }
            long t1 = System.currentTimeMillis();
            try {
                resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
            }
            catch (ResourceException exception) {
                helper.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(error.message);
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(error.description);
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(error.errorMessage);
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            }
            XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            sectioningRequest.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
            if (response == null || !response.validStudent.booleanValue()) {
                String reason = null;
                if (response != null && response.failureReasons != null) {
                    for (String m : response.failureReasons) {
                        if (reason == null) {
                            reason = m;
                            continue;
                        }
                        reason = reason + "\n" + m;
                    }
                }
                throw new SectioningException(reason == null ? "Failed to enroll student." : reason);
            }
            XEnrollment ret = new XEnrollment(enrollment == null ? sectioningRequest.getLastEnrollment() : enrollment);
            ret.getSectionIds().clear();
            TreeSet<String> registered = new TreeSet<String>();
            if (response.registrations != null) {
                OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                for (XEInterface.Registration reg : response.registrations) {
                    String id = reg.courseReferenceNumber;
                    List<XSection> sections = sectioningRequest.getOffering().getSections(course.getCourseId(), id);
                    if (!sections.isEmpty() && "Registered".equals(reg.statusDescription)) {
                        for (XSection section : sections) {
                            ret.getSectionIds().add(section.getSectionId());
                        }
                        registered.add(id);
                    }
                    if (!"Registered".equals(reg.statusDescription)) continue;
                    external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(reg.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(reg.subject + " " + reg.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(reg.scheduleType));
                }
                sectioningRequest.getAction().addEnrollment(external);
            }
            if (helper.isDebugEnabled()) {
                helper.debug("Return: " + registered);
            }
            XEnrollment xEnrollment = ret.getSectionIds().isEmpty() ? null : ret;
            return xEnrollment;
        }
        catch (SectioningException e) {
            helper.info("Banner enrollment failed: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.warn("Banner enrollment failed: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    public static enum ConditionalDropType {
        NEVER,
        HAS_DROP,
        IS_REGISTERED,
        RESECTION,
        ALWAYS;


        public static ConditionalDropType parseType(String value) {
            if (value == null) {
                return NEVER;
            }
            try {
                return ConditionalDropType.valueOf(value);
            }
            catch (Exception e) {
                return "true".equalsIgnoreCase(value) ? HAS_DROP : NEVER;
            }
        }
    }
}

