/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;

public class PurdueCourseDetailsProvider
implements CourseDetailsProvider,
CourseUrlProvider {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static Logger sLog = Logger.getLogger(PurdueCourseDetailsProvider.class);
    public static String sUrl = "https://selfservice.mypurdue.purdue.edu/prod/bzwsrch.p_catalog_detail?term=:year:term&subject=:subject&cnbr=:courseNbr&enhanced=Y";
    public static String sDummyUrl = "https://selfservice.mypurdue.purdue.edu/prod/bzwsrch.p_catalog_detail?term=201020&subject=AAE&cnbr=20300&enhanced=Y";
    public static String sContentRE = "(<table [ ]*class=\"[a-z]*\" summary=\"This table lists the course detail for the selected term.\" .*)<table [ ]*class=\"[a-z]*\" summary=\"This is table displays line separator at end of the page.\"";
    public static String[][] sRemoveRE = new String[][]{{"(?i)<a href=\"[^>]*\">", "<b>"}, {"(?i)</a>", "</b>"}, {"(?i)<span class=[\"]?fieldlabeltext[\"]?>", "<b>"}, {"(?i)</span>", "</b>"}, {"(?i) class=\"nttitle\" ", " class=\"unitime-MainTableHeader\" "}, {"(?i) class=\"datadisplaytable\" ", " class=\"unitime-MainTable\" "}};
    private transient ExternalTermProvider iExternalTermProvider = null;
    private Integer iCourseNumberLength = null;

    private String getTerm(AcademicSessionInfo session) throws SectioningException {
        if (session.getTerm().toLowerCase().startsWith("spr")) {
            return "20";
        }
        if (session.getTerm().toLowerCase().startsWith("sum")) {
            return "30";
        }
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return "10";
        }
        throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("academic term " + session.getTerm() + " not known"));
    }

    private String getYear(AcademicSessionInfo session) throws SectioningException {
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return String.valueOf(Integer.parseInt(session.getYear()) + 1);
        }
        return session.getYear();
    }

    @Override
    public URL getCourseUrl(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        try {
            String subjectArea = subject;
            if (this.iExternalTermProvider == null) {
                String clazz = ApplicationProperty.CustomizationExternalTerm.value();
                if (clazz == null || clazz.isEmpty()) {
                    subjectArea = subject;
                }
                try {
                    this.iExternalTermProvider = (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
                    subjectArea = this.iExternalTermProvider.getExternalSubject(session, subject, courseNbr);
                }
                catch (Exception e) {
                    subjectArea = subject;
                }
            } else {
                subjectArea = this.iExternalTermProvider.getExternalSubject(session, subject, courseNbr);
            }
            if (courseNbr.length() > this.getCourseNumberLength()) {
                courseNbr = courseNbr.substring(0, this.getCourseNumberLength());
            }
            return new URL(sUrl.replace(":year", this.getYear(session)).replace(":term", this.getTerm(session)).replace(":initiative", session.getCampus()).replace(":subject", URLEncoder.encode(subjectArea, "utf-8")).replace(":courseNbr", courseNbr));
        }
        catch (MalformedURLException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("course detail url is wrong"), e);
        }
        catch (UnsupportedEncodingException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("course detail url is wrong"), e);
        }
    }

    @Override
    public String getDetails(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        return this.getDetails(this.getCourseUrl(session, subject, courseNbr));
    }

    protected String getDetails(URL courseUrl) throws SectioningException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(courseUrl.openStream(), "utf-8"));
            StringBuffer content = new StringBuffer();
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
            in.close();
            Pattern pattern = Pattern.compile(sContentRE, 11);
            Matcher match = pattern.matcher(content);
            if (!match.find()) {
                throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("unable to parse <a href='" + courseUrl + "'>course detail page</a>"));
            }
            String table = match.group(1);
            for (int i = 0; i < sRemoveRE.length; ++i) {
                table = table.replaceAll(sRemoveRE[i][0], sRemoveRE[i][1]);
            }
            return table;
        }
        catch (IOException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("unable to read <a href='" + courseUrl + "'>course detail page</a>"));
        }
    }

    public int getCourseNumberLength() {
        if (this.iCourseNumberLength == null) {
            this.iCourseNumberLength = Integer.valueOf(ApplicationProperties.getProperty("tmtbl.banner.courseNumberLength", "5"));
        }
        return this.iCourseNumberLength;
    }

    public static void main(String[] args) {
        try {
            System.out.println(new PurdueCourseDetailsProvider().getDetails(new URL(sDummyUrl)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

