/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import org.apache.log4j.Logger;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;

public class Holder<T> {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    String iName;
    ApplicationProperty iProperty;
    String iDefaultProvider = null;
    T iProvider;
    String iProviderClass;
    Logger iLog;

    public Holder(Class<T> name, ApplicationProperty property, Class<? extends T> defaultProvider) {
        this.iLog = Logger.getLogger(name);
        this.iName = name.getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
        this.iProperty = property;
        this.iDefaultProvider = defaultProvider == null ? null : defaultProvider.getName();
    }

    public Holder(Class<T> name, ApplicationProperty property) {
        this(name, property, null);
    }

    private void disposeProvider() {
        if (this.iProvider != null) {
            try {
                this.iLog.info((Object)"Disposing old provider");
                this.iProvider.getClass().getMethod("dispose", new Class[0]).invoke(this.iProvider, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                this.iLog.warn((Object)("Failed to dispose: " + e.getMessage()), (Throwable)e);
            }
        }
        this.iProvider = null;
        this.iProviderClass = null;
    }

    public synchronized T getProvider() {
        String providerClass = this.iProperty.value();
        if (providerClass == null || providerClass.isEmpty()) {
            providerClass = this.iDefaultProvider;
        }
        if (providerClass == null || providerClass.isEmpty()) {
            if (this.iProvider != null) {
                this.disposeProvider();
            }
        } else if (!providerClass.equals(this.iProviderClass)) {
            if (this.iProvider != null) {
                this.disposeProvider();
            }
            this.iProviderClass = providerClass;
            this.iLog.info((Object)("Creating an instance of " + this.iProviderClass));
            try {
                this.iProvider = Class.forName(this.iProviderClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.iLog.error((Object)("Failed to create an instance of " + this.iProviderClass + ": " + e.getMessage()), (Throwable)e);
                throw new SectioningException(MSG.exceptionCustomProvider(this.iName, e.getMessage()), e);
            }
        }
        return this.iProvider;
    }

    public synchronized void release() {
        this.disposeProvider();
    }

    public synchronized boolean hasProvider() {
        return this.getProvider() != null;
    }
}

