/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

public class CustomCriticalCoursesHolder {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public static CriticalCoursesProvider getProvider() {
        return (CriticalCoursesProvider)Customization.CriticalCoursesProvider.getProvider();
    }

    public static void release() {
        Customization.CriticalCoursesProvider.release();
    }

    public static boolean hasProvider() {
        return Customization.CriticalCoursesProvider.hasProvider();
    }

    protected static abstract class Worker
    extends Thread {
        private Iterator<Long> iStudentsIds;
        private Long iSessionId;

        public Worker(int index, Long sessionId, Iterator<Long> studentsIds) {
            this.setName("CriticalCourses-" + (1 + index));
            this.iSessionId = sessionId;
            this.iStudentsIds = studentsIds;
        }

        protected abstract void process(Long var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ApplicationProperties.setSessionId(this.iSessionId);
                while (true) {
                    Long studentId = null;
                    Iterator<Long> iterator = this.iStudentsIds;
                    synchronized (iterator) {
                        if (!this.iStudentsIds.hasNext()) {
                            break;
                        }
                        studentId = this.iStudentsIds.next();
                    }
                    this.process(studentId);
                }
            }
            finally {
                ApplicationProperties.setSessionId(null);
                _RootDAO.closeCurrentThreadSessions();
            }
        }
    }

    public static class CheckCriticalCourses
    implements OnlineSectioningAction<Boolean> {
        private static final long serialVersionUID = 1L;
        private Collection<Long> iStudentIds = null;

        public CheckCriticalCourses forStudents(Long ... studentIds) {
            this.iStudentIds = new ArrayList<Long>();
            for (Long studentId : studentIds) {
                this.iStudentIds.add(studentId);
            }
            return this;
        }

        public CheckCriticalCourses forStudents(Collection<Long> studentIds) {
            this.iStudentIds = studentIds;
            return this;
        }

        public Collection<Long> getStudentIds() {
            return this.iStudentIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean execute(final OnlineSectioningServer server, final OnlineSectioningHelper helper) {
            if (!CustomCriticalCoursesHolder.hasProvider()) {
                return false;
            }
            final ArrayList<Long> reloadIds = new ArrayList<Long>();
            try {
                int nrThreads = server.getConfig().getPropertyInt("CheckCriticalCourses.NrThreads", 10);
                if (nrThreads <= 1 || this.getStudentIds().size() <= 1) {
                    for (Long studentId : this.getStudentIds()) {
                        if (!this.recheckStudent(server, helper, studentId)) continue;
                        reloadIds.add(studentId);
                    }
                } else {
                    ArrayList<1> workers = new ArrayList<1>();
                    Iterator<Long> studentIds = this.getStudentIds().iterator();
                    for (int i = 0; i < nrThreads; ++i) {
                        workers.add(new Worker(i, server.getAcademicSession().getUniqueId(), studentIds){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void process(Long studentId) {
                                if (this.recheckStudent(server, new OnlineSectioningHelper(helper), studentId)) {
                                    List list = reloadIds;
                                    synchronized (list) {
                                        reloadIds.add(studentId);
                                    }
                                }
                            }
                        });
                    }
                    for (Worker worker : workers) {
                        worker.start();
                    }
                    for (Worker worker : workers) {
                        try {
                            worker.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            finally {
                if (!reloadIds.isEmpty() && !(server instanceof DatabaseServer)) {
                    server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
                }
            }
            return !reloadIds.isEmpty();
        }

        protected int isCritical(CourseDemand cd, CriticalCoursesProvider.CriticalCourses critical) {
            if (critical == null || cd.isAlternative().booleanValue()) {
                return 0;
            }
            for (CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOrder() != 0 || critical.isCritical(cr.getCourseOffering()) <= 0) continue;
                return critical.isCritical(cr.getCourseOffering());
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean recheckStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Long studentId) {
            helper.beginTransaction();
            try {
                Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                boolean changed = false;
                if (student != null) {
                    OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(studentId).setExternalId(student.getExternalUniqueId()).setName(helper.getStudentNameFormat().format(student)).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
                    long c0 = OnlineSectioningHelper.getCpuTime();
                    try {
                        int crit;
                        CriticalCoursesProvider.CriticalCourses critical = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(server, helper, new XStudentId(student, helper), action);
                        for (CourseDemand cd : student.getCourseDemands()) {
                            crit = this.isCritical(cd, critical);
                            if (cd.getCritical() != null && cd.getCritical() == crit) continue;
                            cd.setCritical(crit);
                            helper.getHibSession().update((Object)cd);
                            changed = true;
                        }
                        if (student.getAdvisorCourseRequests() != null) {
                            for (AdvisorCourseRequest acr : student.getAdvisorCourseRequests()) {
                                crit = acr.isCritical(critical);
                                if (acr.getCritical() != null && acr.getCritical() == crit) continue;
                                acr.setCritical(crit);
                                helper.getHibSession().update((Object)acr);
                            }
                        }
                        if (changed) {
                            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
                        } else {
                            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                        }
                    }
                    catch (SectioningException e) {
                        action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e.getCause() != null) {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                        } else {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                        }
                    }
                    finally {
                        action.setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        action.setEndTime(System.currentTimeMillis());
                    }
                }
                helper.commitTransaction();
                return changed;
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }

        @Override
        public String name() {
            return "critical-courses";
        }
    }
}

