/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.base.BaseEventDateMapping;
import org.unitime.timetable.model.dao.EventDateMappingDAO;

public class EventDateMapping
extends BaseEventDateMapping
implements Comparable<EventDateMapping> {
    private static final long serialVersionUID = 1L;

    public Date getClassDate() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getSessionBeginDateTime());
        c.add(6, this.getClassDateOffset());
        return c.getTime();
    }

    public void setClassDate(Date classDate) {
        long diff = classDate.getTime() - this.getSession().getSessionBeginDateTime().getTime();
        this.setClassDateOffset((int)Math.round((double)diff / 8.64E7));
    }

    public Date getEventDate() {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(this.getSession().getSessionBeginDateTime());
        c.add(6, this.getEventDateOffset());
        return c.getTime();
    }

    public void setEventDate(Date eventDate) {
        long diff = eventDate.getTime() - this.getSession().getSessionBeginDateTime().getTime();
        this.setEventDateOffset((int)Math.round((double)diff / 8.64E7));
    }

    public static List<EventDateMapping> findAll(Long sessionId) {
        return EventDateMappingDAO.getInstance().getSession().createQuery("from EventDateMapping where session.uniqueId = :sessionId order by classDateOffset").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static boolean hasMapping(Long sessionId) {
        return ((Number)EventDateMappingDAO.getInstance().getSession().createQuery("select count(m) from EventDateMapping m where m.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static Class2EventDateMap getMapping(Long sessionId) {
        return sessionId == null ? null : new Class2EventDateMap(EventDateMapping.findAll(sessionId));
    }

    @Override
    public int compareTo(EventDateMapping m) {
        int cmp = this.getClassDateOffset().compareTo(m.getClassDateOffset());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(m.getUniqueId() == null ? -1L : m.getUniqueId());
    }

    public static class Class2EventDateMap {
        private SimpleDateFormat iDateFormat = new SimpleDateFormat("yyMMdd");
        private Map<String, Date> iClass2EventDates = new HashMap<String, Date>();
        private Map<String, Date> iEvent2ClassDates = new HashMap<String, Date>();

        public Class2EventDateMap() {
        }

        public Class2EventDateMap(List<EventDateMapping> mappings) {
            for (EventDateMapping mapping : mappings) {
                this.addMapping(mapping.getClassDate(), mapping.getEventDate());
            }
        }

        public void addMapping(Date classDate, Date eventDate) {
            this.iClass2EventDates.put(this.iDateFormat.format(classDate), eventDate);
            this.iEvent2ClassDates.put(this.iDateFormat.format(eventDate), classDate);
        }

        public boolean hasEventDate(Date eventDate) {
            return eventDate == null ? false : this.iEvent2ClassDates.containsKey(this.iDateFormat.format(eventDate));
        }

        public Date getClassDate(Date eventDate) {
            Date classDate;
            Date date = classDate = eventDate == null ? null : this.iEvent2ClassDates.get(this.iDateFormat.format(eventDate));
            if (classDate == null && this.hasClassDate(eventDate)) {
                return null;
            }
            return classDate == null ? eventDate : classDate;
        }

        public boolean hasClassDate(Date classDate) {
            return classDate == null ? false : this.iClass2EventDates.containsKey(this.iDateFormat.format(classDate));
        }

        public Date getEventDate(Date classDate) {
            Date eventDate = classDate == null ? null : this.iClass2EventDates.get(this.iDateFormat.format(classDate));
            return eventDate == null ? classDate : eventDate;
        }

        public String toString() {
            return ToolBox.dict2string(this.iClass2EventDates, (int)2);
        }
    }
}

