/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDistributionPref;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.PreferenceGroupDAO;
import org.unitime.timetable.model.dao._RootDAO;

public class DistributionPref
extends BaseDistributionPref {
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 1L;
    public static final String DIST_PREF_REQUEST_ATTR = "distPrefs";

    public DistributionPref() {
    }

    public DistributionPref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        return this.preferenceText(false, false, "<BR>", "<BR>", "");
    }

    public String preferenceText(boolean includeDistrObjects, boolean abbv, String objQuotationLeft, String objSeparator, String objQuotationRight) {
        StringBuffer sb = new StringBuffer((abbv ? this.getAbbreviation() : this.getLabel()).replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        if (includeDistrObjects) {
            if (this.getDistributionObjects() != null && !this.getDistributionObjects().isEmpty()) {
                sb.append(objQuotationLeft);
                Iterator<DistributionObject> it = this.getOrderedSetOfDistributionObjects().iterator();
                while (it.hasNext()) {
                    DistributionObject distObj = it.next();
                    sb.append(distObj.preferenceText());
                    if (!it.hasNext()) continue;
                    sb.append(objSeparator);
                }
                sb.append(objQuotationRight);
            } else if (this.getOwner() instanceof DepartmentalInstructor) {
                sb.append(" (" + ((DepartmentalInstructor)this.getOwner()).getName(DepartmentalInstructor.sNameFormatShort) + ")");
                if (!abbv) {
                    sb.append(objQuotationLeft);
                    Iterator<ClassInstructor> it = ((DepartmentalInstructor)this.getOwner()).getClasses().iterator();
                    while (it.hasNext()) {
                        ClassInstructor ci = it.next();
                        sb.append(ci.getClassInstructing().getClassLabel());
                        if (!it.hasNext()) continue;
                        sb.append(objSeparator);
                    }
                    sb.append(objQuotationRight);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String preferenceHtml(String nameFormat, boolean highlightClassPrefs) {
        Iterator<Comparable> it;
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && highlightClassPrefs) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = " (" + MSG.prefOwnerClass() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = " (" + MSG.prefOwnerSchedulingSubpart() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = " (" + ((DepartmentalInstructor)this.getOwner()).getName(nameFormat != null ? nameFormat : DepartmentalInstructor.sNameFormatShort) + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = " (" + MSG.prefOwnerExamination() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = " (" + ((Department)this.getOwner()).getLabel() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = " (" + MSG.prefOwnerSession() + ")";
        }
        String hint = HtmlUtils.htmlEscape((String)(this.getPrefLevel().getPrefName() + " " + this.getLabel() + owner));
        if (this.getDistributionObjects() != null && !this.getDistributionObjects().isEmpty()) {
            hint = hint + "<ul><li>";
            it = this.getOrderedSetOfDistributionObjects().iterator();
            while (it.hasNext()) {
                DistributionObject distObj = (DistributionObject)it.next();
                hint = hint + HtmlUtils.htmlEscape((String)distObj.preferenceText());
                if (!it.hasNext()) continue;
                hint = hint + "<li>";
            }
            hint = hint + "</ul>";
        } else if (this.getOwner() instanceof DepartmentalInstructor) {
            hint = hint + "<ul><li>";
            it = ((DepartmentalInstructor)this.getOwner()).getClasses().iterator();
            while (it.hasNext()) {
                ClassInstructor ci = (ClassInstructor)it.next();
                hint = hint + HtmlUtils.htmlEscape((String)ci.getClassInstructing().getClassLabel());
                if (!it.hasNext()) continue;
                hint = hint + "<li>";
            }
            hint = hint + "</ul>";
        }
        String description = this.preferenceDescription();
        if (description != null && !description.isEmpty()) {
            hint = hint + "<br>" + HtmlUtils.htmlEscape((String)description.replace("'", "\\'")).replace("\n", "<br>");
        }
        sb.append("onmouseover=\"showGwtHint(this, '" + hint + "');\" onmouseout=\"hideGwtHint();\">");
        sb.append(this.getAbbreviation());
        sb.append("</span>");
        return sb.toString();
    }

    public boolean appliesTo(SchedulingSubpart schedulingSubpart) {
        if (this.getDistributionObjects() == null) {
            return false;
        }
        for (DistributionObject dObj : this.getDistributionObjects()) {
            if (!dObj.getPrefGroup().getUniqueId().equals(schedulingSubpart.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public boolean appliesTo(Class_ aClass) {
        if (this.getDistributionObjects() == null) {
            return false;
        }
        Iterator<DistributionObject> it = null;
        try {
            it = this.getDistributionObjects().iterator();
        }
        catch (ObjectNotFoundException e) {
            Debug.error("Exception " + e.getMessage() + " seen for " + this);
            new _RootDAO().getSession().refresh((Object)this);
            it = this.getDistributionObjects().iterator();
        }
        while (it.hasNext()) {
            DistributionObject dObj = it.next();
            if (dObj.getPrefGroup().getUniqueId().equals(aClass.getUniqueId())) {
                return true;
            }
            SchedulingSubpart ss = null;
            if (Hibernate.isInitialized((Object)dObj.getPrefGroup())) {
                if (dObj.getPrefGroup() instanceof SchedulingSubpart) {
                    ss = (SchedulingSubpart)dObj.getPrefGroup();
                }
            } else {
                PreferenceGroup pg = (PreferenceGroup)new PreferenceGroupDAO().get(dObj.getPrefGroup().getUniqueId());
                if (pg != null && pg instanceof SchedulingSubpart) {
                    ss = (SchedulingSubpart)pg;
                }
            }
            if (ss == null || ss.getClasses() == null || ss.getClasses().size() <= 0) continue;
            Iterator<Class_> it2 = ss.getClasses().iterator();
            while (it2.hasNext()) {
                if (!it2.next().getUniqueId().equals(aClass.getUniqueId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean appliesTo(PreferenceGroup group) {
        if (group instanceof Class_) {
            return this.appliesTo((Class_)group);
        }
        if (group instanceof SchedulingSubpart) {
            return this.appliesTo((SchedulingSubpart)group);
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        DistributionPref p = (DistributionPref)o;
        int cmp = this.getDistributionType().getReference().compareTo(p.getDistributionType().getReference());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(p.getUniqueId() == null ? -1L : p.getUniqueId());
    }

    @Override
    public Object clone() {
        DistributionPref pref = new DistributionPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setDistributionObjects(new HashSet<DistributionObject>(this.getDistributionObjects()));
        pref.setDistributionType(this.getDistributionType());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        return this.equals(other);
    }

    public Set<DistributionObject> getOrderedSetOfDistributionObjects() {
        try {
            return new TreeSet<DistributionObject>(this.getDistributionObjects());
        }
        catch (ObjectNotFoundException ex) {
            new DistributionPrefDAO().getSession().refresh((Object)this);
            return new TreeSet<DistributionObject>(this.getDistributionObjects());
        }
    }

    public String getStructureName() {
        return this.getStructure() == null ? null : this.getStructure().getName();
    }

    public String getStructureDescription() {
        return this.getStructure() == null ? null : this.getStructure().getDescription();
    }

    public static Collection getPreferences(Long sessionId, Long ownerId, boolean useControllingCourseOfferingManager, Long uniqueId) {
        return DistributionPref.getPreferences(sessionId, ownerId, useControllingCourseOfferingManager, uniqueId, null, null);
    }

    public static Collection getPreferences(Long sessionId, Long ownerId, boolean useControllingCourseOfferingManager, Long uniqueId, Long subjectAreaId, String courseNbr) {
        if (sessionId == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct dp ");
        sb.append(" from ");
        sb.append(" DistributionPref as dp ");
        sb.append(" inner join dp.distributionObjects as do, ");
        sb.append(" Class_ as c ");
        sb.append(" inner join c.schedulingSubpart as ss inner join ss.instrOfferingConfig.instructionalOffering as io ");
        if (subjectAreaId != null || ownerId != null || courseNbr != null && !courseNbr.trim().isEmpty()) {
            sb.append(" inner join io.courseOfferings as co ");
        }
        sb.append("where ");
        sb.append(" (c.uniqueId = do.prefGroup.uniqueId or ss.uniqueId = do.prefGroup.uniqueId) and ");
        sb.append(" io.session.uniqueId = :sessionId ");
        if (ownerId != null) {
            sb.append(" and (");
            sb.append("((c.managingDept is not null and c.managingDept.uniqueId = :ownerId )");
            sb.append(" or (c.managingDept is null ");
            sb.append(" and co.isControl = true ");
            sb.append("and co.subjectArea.department.uniqueId = :ownerId))");
            if (useControllingCourseOfferingManager) {
                sb.append(" or (co.isControl = true");
                sb.append(" and co.subjectArea.department.uniqueId = :ownerId)");
            }
            sb.append(")");
        }
        if (uniqueId != null) {
            sb.append(" and (c.uniqueId = :uniqueId or ss.uniqueId = :uniqueId or io.uniqueId = :uniqueId))");
        }
        if (subjectAreaId != null) {
            sb.append(" and co.subjectArea.uniqueId=:subjectAreaId ");
        }
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.trim().length() > 2) {
            sb.append(" and (co.courseNbr ");
            if (courseNbr.indexOf(42) >= 0) {
                sb.append(" like ");
                courseNbr = courseNbr.replace('*', '%');
            } else {
                sb.append(" = ");
            }
            sb.append(":courseNbr or lower(co.title) like lower('%' || :courseNbr || '%'))");
            if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                courseNbr = courseNbr.toUpperCase();
            }
        } else if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            sb.append(" and co.courseNbr ");
            if (courseNbr.indexOf(42) >= 0) {
                sb.append(" like ");
                courseNbr = courseNbr.replace('*', '%');
            } else {
                sb.append(" = ");
            }
            if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                courseNbr = courseNbr.toUpperCase();
            }
            sb.append(":courseNbr");
        }
        Query q = new DistributionPrefDAO().getSession().createQuery(sb.toString());
        q.setLong("sessionId", sessionId.longValue());
        if (ownerId != null) {
            q.setLong("ownerId", ownerId.longValue());
        }
        if (uniqueId != null) {
            q.setLong("uniqueId", uniqueId.longValue());
        }
        if (subjectAreaId != null) {
            q.setLong("subjectAreaId", subjectAreaId.longValue());
        }
        if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            q.setString("courseNbr", courseNbr);
        }
        return q.list();
    }

    public static Collection getInstructorPreferences(Long sessionId, Long ownerId, Long subjectAreaId, String courseNbr) {
        if (sessionId == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct dp ");
        sb.append(" from ");
        sb.append(" DistributionPref as dp, ");
        sb.append(" DepartmentalInstructor as di ");
        if (subjectAreaId != null || courseNbr != null && !courseNbr.isEmpty()) {
            sb.append(" inner join di.classes as ci inner join ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co ");
        }
        sb.append("where ");
        sb.append(" dp.owner = di ");
        sb.append(" and di.department.session.uniqueId = :sessionId ");
        if (subjectAreaId != null) {
            sb.append(" and ci.lead = true ");
            sb.append(" and co.isControl = true ");
            sb.append(" and co.subjectArea.uniqueId = :subjectAreaId ");
        }
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.length() > 2) {
            sb.append(" and (co.courseNbr ");
            if (courseNbr.indexOf(42) >= 0) {
                sb.append(" like ");
                courseNbr = courseNbr.replace('*', '%');
            } else {
                sb.append(" = ");
            }
            sb.append(":courseNbr or lower(co.title) like lower('%' || :courseNbr || '%'))");
            if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                courseNbr = courseNbr.toUpperCase();
            }
        } else if (courseNbr != null && !courseNbr.isEmpty()) {
            sb.append(" and co.courseNbr ");
            if (courseNbr.indexOf(42) >= 0) {
                sb.append(" like ");
                courseNbr = courseNbr.replace('*', '%');
            } else {
                sb.append(" = ");
            }
            sb.append(":courseNbr");
            if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                courseNbr = courseNbr.toUpperCase();
            }
        }
        if (ownerId != null) {
            sb.append(" and di.department.uniqueId = :ownerId ");
        }
        Query q = new DistributionPrefDAO().getSession().createQuery(sb.toString());
        q.setLong("sessionId", sessionId.longValue());
        if (subjectAreaId != null) {
            q.setLong("subjectAreaId", subjectAreaId.longValue());
        }
        if (ownerId != null) {
            q.setLong("ownerId", ownerId.longValue());
        }
        if (courseNbr != null && !courseNbr.isEmpty()) {
            q.setString("courseNbr", courseNbr);
        }
        return q.list();
    }

    @Override
    public boolean weakenHardPreferences() {
        if (PreferenceLevel.sRequired.equals(this.getPrefLevel().getPrefProlog())) {
            if (this.getDistributionType().getAllowedPref().indexOf(48) >= 0) {
                this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
            } else {
                return false;
            }
        }
        if (PreferenceLevel.sProhibited.equals(this.getPrefLevel().getPrefProlog())) {
            if (this.getDistributionType().getAllowedPref().indexOf(52) >= 0) {
                this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
            } else {
                return false;
            }
        }
        return true;
    }

    public static DistributionPref findByIdRolledForwardFrom(Long uidRolledForwardFrom, Long sessionId) {
        return (DistributionPref)new DistributionPrefDAO().getSession().createQuery("select dp from DistributionPref dp, Department d where dp.uniqueIdRolledForwardFrom=:uidRolledFrom and dp.owner=d and d.session.uniqueId=:sessionId").setLong("uidRolledFrom", uidRolledForwardFrom.longValue()).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult();
    }

    @Override
    public String toString() {
        return this.preferenceText(false, false, " ", ", ", "");
    }

    public static <E> Enumeration<List<E>> permutations(final List<E> items, final List<Integer> counts) {
        return new Enumeration<List<E>>(){
            int[] p = null;
            int[] b = null;
            int m = 0;

            @Override
            public boolean hasMoreElements() {
                if (this.p == null) {
                    return true;
                }
                for (int i = 0; i < this.m; ++i) {
                    if (this.p[i] >= this.b[i]) continue;
                    return true;
                }
                return false;
            }

            @Override
            public List<E> nextElement() {
                int i;
                if (this.p == null) {
                    this.m = counts.size();
                    this.p = new int[this.m];
                    this.b = new int[this.m];
                    int c = 0;
                    for (i = 0; i < this.m; ++i) {
                        this.p[i] = c;
                        this.b[i] = (c += ((Integer)counts.get(i)).intValue()) - 1;
                    }
                } else {
                    for (int i2 = this.m - 1; i2 >= 0; --i2) {
                        this.p[i2] = this.p[i2] + 1;
                        for (int j = i2 + 1; j < this.m; ++j) {
                            this.p[j] = this.b[j - 1] + 1;
                        }
                        if (i2 != 0 && this.p[i2] > this.b[i2]) {
                            continue;
                        }
                        break;
                    }
                }
                ArrayList ret = new ArrayList();
                for (i = 0; i < this.m; ++i) {
                    ret.add(items.get(this.p[i]));
                }
                return ret;
            }
        };
    }

    public Structure getStructure() {
        if (this.getGrouping() == null || this.getGrouping() < 0) {
            return null;
        }
        return Structure.values()[this.getGrouping()];
    }

    public void setStructure(Structure structure) {
        this.setGrouping(structure.ordinal());
    }

    public String getLabel() {
        String label = this.getDistributionType().getLabel();
        return this.getStructure() == null ? label : this.getStructure().getLabel(label);
    }

    public String getAbbreviation() {
        String abbv = this.getDistributionType().getAbbreviation();
        return this.getStructure() == null ? abbv : this.getStructure().getAbbreviation(abbv);
    }

    @Override
    public Preference.Type getType() {
        return Preference.Type.DISTRIBUTION;
    }

    public static enum Structure {
        AllClasses,
        Progressive,
        GroupsOfTwo,
        GroupsOfThree,
        GroupsOfFour,
        GroupsOfFive,
        Pairwise,
        OneOfEach;


        public String getDescription() {
            switch (this) {
                case AllClasses: {
                    return MSG.distributionStructureDescriptionAllClasses();
                }
                case Progressive: {
                    return MSG.distributionStructureDescriptionProgressive();
                }
                case GroupsOfTwo: {
                    return MSG.distributionStructureDescriptionGroupsOfTwo();
                }
                case GroupsOfThree: {
                    return MSG.distributionStructureDescriptionGroupsOfThree();
                }
                case GroupsOfFour: {
                    return MSG.distributionStructureDescriptionGroupsOfFour();
                }
                case GroupsOfFive: {
                    return MSG.distributionStructureDescriptionGroupsOfFive();
                }
                case Pairwise: {
                    return MSG.distributionStructureDescriptionPairwise();
                }
                case OneOfEach: {
                    return MSG.distributionStructureDescriptionOneOfEach();
                }
            }
            return null;
        }

        public String getName() {
            switch (this) {
                case AllClasses: {
                    return MSG.distributionStructureNameAllClasses();
                }
                case Progressive: {
                    return MSG.distributionStructureNameProgressive();
                }
                case GroupsOfTwo: {
                    return MSG.distributionStructureNameGroupsOfTwo();
                }
                case GroupsOfThree: {
                    return MSG.distributionStructureNameGroupsOfThree();
                }
                case GroupsOfFour: {
                    return MSG.distributionStructureNameGroupsOfFour();
                }
                case GroupsOfFive: {
                    return MSG.distributionStructureNameGroupsOfFive();
                }
                case Pairwise: {
                    return MSG.distributionStructureNamePairwise();
                }
                case OneOfEach: {
                    return MSG.distributionStructureNameOneOfEach();
                }
            }
            return null;
        }

        public String getLabel(String content) {
            switch (this) {
                case AllClasses: {
                    return MSG.distributionStructureLabelAllClasses(content);
                }
                case Progressive: {
                    return MSG.distributionStructureLabelProgressive(content);
                }
                case GroupsOfTwo: {
                    return MSG.distributionStructureLabelGroupsOfTwo(content);
                }
                case GroupsOfThree: {
                    return MSG.distributionStructureLabelGroupsOfThree(content);
                }
                case GroupsOfFour: {
                    return MSG.distributionStructureLabelGroupsOfFour(content);
                }
                case GroupsOfFive: {
                    return MSG.distributionStructureLabelGroupsOfFive(content);
                }
                case Pairwise: {
                    return MSG.distributionStructureLabelPairwise(content);
                }
                case OneOfEach: {
                    return MSG.distributionStructureLabelOneOfEach(content);
                }
            }
            return content + null;
        }

        public String getAbbreviation(String content) {
            switch (this) {
                case AllClasses: {
                    return MSG.distributionStructureAbbreviationAllClasses(content);
                }
                case Progressive: {
                    return MSG.distributionStructureAbbreviationProgressive(content);
                }
                case GroupsOfTwo: {
                    return MSG.distributionStructureAbbreviationGroupsOfTwo(content);
                }
                case GroupsOfThree: {
                    return MSG.distributionStructureAbbreviationGroupsOfThree(content);
                }
                case GroupsOfFour: {
                    return MSG.distributionStructureAbbreviationGroupsOfFour(content);
                }
                case GroupsOfFive: {
                    return MSG.distributionStructureAbbreviationGroupsOfFive(content);
                }
                case Pairwise: {
                    return MSG.distributionStructureAbbreviationPairwise(content);
                }
                case OneOfEach: {
                    return MSG.distributionStructureAbbreviationOneOfEach(content);
                }
            }
            return content + null;
        }
    }
}

