/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class EventInterface
implements Comparable<EventInterface>,
IsSerializable,
GwtRpcResponse {
    private Long iEventId;
    private String iEventName;
    private EventType iEventType;
    private String iEventEmail;
    private TreeSet<MeetingInterface> iMeetings = null;
    private ContactInterface iContact;
    private SponsoringOrganizationInterface iSponsor;
    private Set<ContactInterface> iInstructors;
    private Set<ContactInterface> iCoordinators;
    private List<ContactInterface> iAdditionalContacts;
    private String iLastChange = null;
    private TreeSet<NoteInterface> iNotes;
    private Date iExpirationDate = null;
    private List<Long> iCourseIds = null;
    private List<String> iCourseNames = null;
    private List<String> iCourseTitles = null;
    private String iInstruction = null;
    private Integer iInstructionType = null;
    private Integer iMaxCapacity = null;
    private Integer iEnrollment;
    private boolean iReqAttendance = false;
    private List<String> iExternalIds = null;
    private String iSectionNumber = null;
    private boolean iCanView = false;
    private boolean iCanEdit = false;
    private List<RelatedObjectInterface> iRelatedObjects = null;
    private Set<EventInterface> iConflicts;
    private String iMessage = null;
    private Date iTimeStamp = null;
    private int iSequence = 0;
    private Set<EventServiceProviderInterface> iRequestedServices = null;
    private Long iClassId = null;
    private Long iSessionId = null;
    public static final int sDefaultEventFlags = EventFlag.SHOW_PUBLISHED_TIME.flag() + EventFlag.SHOW_MAIN_CONTACT.flag() + EventFlag.SHOW_SPONSOR.flag() + EventFlag.SHOW_CAPACITY.flag() + EventFlag.SHOW_TITLE.flag() + EventFlag.SHOW_APPROVAL.flag() + EventFlag.SHOW_MEETING_CONTACTS.flag() + EventFlag.SHOW_REQUESTED_SERVICES.flag() + EventFlag.SHOW_NOTE.flag();

    public Long getId() {
        return this.iEventId;
    }

    public void setId(Long id) {
        this.iEventId = id;
    }

    public String getName() {
        return this.iEventName;
    }

    public void setName(String name) {
        this.iEventName = name;
    }

    public EventType getType() {
        return this.iEventType;
    }

    public void setType(EventType type) {
        this.iEventType = type;
    }

    public SponsoringOrganizationInterface getSponsor() {
        return this.iSponsor;
    }

    public void setSponsor(SponsoringOrganizationInterface sponsor) {
        this.iSponsor = sponsor;
    }

    public boolean hasSponsor() {
        return this.iSponsor != null;
    }

    public String getEmail() {
        return this.iEventEmail;
    }

    public boolean hasEmail() {
        return this.iEventEmail != null && !this.iEventEmail.isEmpty();
    }

    public void setEmail(String email) {
        this.iEventEmail = email;
    }

    public TreeSet<NoteInterface> getNotes() {
        return this.iNotes;
    }

    public boolean hasNotes() {
        return this.iNotes != null && !this.iNotes.isEmpty();
    }

    public void addNote(NoteInterface note) {
        if (this.iNotes == null) {
            this.iNotes = new TreeSet();
        }
        this.iNotes.add(note);
    }

    public boolean hasEventNote() {
        if (this.iNotes == null) {
            return false;
        }
        for (NoteInterface n : this.getNotes()) {
            if (n.getNote() == null || n.getNote().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getEventNote(String linebreak) {
        String note = "";
        if (this.hasNotes()) {
            String last = null;
            for (NoteInterface n : this.getNotes()) {
                if (n.getNote() == null || n.getNote().isEmpty() || n.getNote().equals(last)) continue;
                if (!note.isEmpty()) {
                    note = note + linebreak;
                }
                note = note + n.getNote();
                last = n.getNote();
            }
        }
        return note;
    }

    public NoteInterface getLastNote() {
        if (this.iNotes == null) {
            return null;
        }
        NoteInterface last = null;
        for (NoteInterface n : this.getNotes()) {
            if (n.getDate() == null || n.getType() == null || last != null && last.getDate().compareTo(n.getDate()) > 0) continue;
            last = n;
        }
        return last;
    }

    public String getLastChange() {
        return this.iLastChange;
    }

    public boolean hasLastChange() {
        return this.iLastChange != null && !this.iLastChange.isEmpty();
    }

    public void setLastChange(String lastChange) {
        this.iLastChange = lastChange;
    }

    public boolean hasMaxCapacity() {
        return this.iMaxCapacity != null;
    }

    public Integer getMaxCapacity() {
        return this.iMaxCapacity;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.iMaxCapacity = maxCapacity;
    }

    public boolean hasRequiredAttendance() {
        return this.iReqAttendance;
    }

    public void setRequiredAttendance(boolean reqAttendance) {
        this.iReqAttendance = reqAttendance;
    }

    public boolean hasEnrollment() {
        return this.iEnrollment != null;
    }

    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    public Date getExpirationDate() {
        return this.iExpirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.iExpirationDate = expirationDate;
    }

    public boolean hasExpirationDate() {
        return this.iExpirationDate != null;
    }

    public boolean hasPendingMeetings() {
        if (this.iMeetings == null) {
            return false;
        }
        for (MeetingInterface meeting : this.iMeetings) {
            if (meeting.getApprovalStatus() != ApprovalStatus.Pending) continue;
            return true;
        }
        return false;
    }

    public Set<ContactInterface> getInstructors() {
        return this.iInstructors;
    }

    public void addInstructor(ContactInterface instructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new TreeSet<ContactInterface>();
        }
        this.iInstructors.add(instructor);
    }

    public String getInstructorNames(String separator, GwtMessages messages) {
        if (!this.hasInstructors()) {
            return "";
        }
        String ret = "";
        for (ContactInterface instructor : this.getInstructors()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + instructor.getName(messages);
        }
        return ret;
    }

    public String getInstructorEmails(String separator) {
        if (!this.hasInstructors()) {
            return "";
        }
        String ret = "";
        for (ContactInterface instructor : this.getInstructors()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + (instructor.getEmail() == null ? "" : instructor.getEmail());
        }
        return ret;
    }

    public boolean hasInstructors() {
        return this.iInstructors != null && !this.iInstructors.isEmpty();
    }

    public Set<ContactInterface> getCoordinators() {
        return this.iCoordinators;
    }

    public void addCoordinator(ContactInterface coordinator) {
        if (this.iCoordinators == null) {
            this.iCoordinators = new TreeSet<ContactInterface>();
        }
        this.iCoordinators.add(coordinator);
    }

    public String getCoordinatorNames(String separator, GwtMessages messages) {
        if (!this.hasCoordinators()) {
            return "";
        }
        String ret = "";
        for (ContactInterface coordinator : this.getCoordinators()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + coordinator.getName(messages);
        }
        return ret;
    }

    public String getCoordinatorEmails(String separator) {
        if (!this.hasCoordinators()) {
            return "";
        }
        String ret = "";
        for (ContactInterface coordinator : this.getCoordinators()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + (coordinator.getEmail() == null ? "" : coordinator.getEmail());
        }
        return ret;
    }

    public boolean hasCoordinators() {
        return this.iCoordinators != null && !this.iCoordinators.isEmpty();
    }

    public ContactInterface getContact() {
        return this.iContact;
    }

    public void setContact(ContactInterface contact) {
        this.iContact = contact;
    }

    public boolean hasContact() {
        return this.iContact != null;
    }

    public List<ContactInterface> getAdditionalContacts() {
        return this.iAdditionalContacts;
    }

    public void addAdditionalContact(ContactInterface contact) {
        if (this.iAdditionalContacts == null) {
            this.iAdditionalContacts = new ArrayList<ContactInterface>();
        }
        this.iAdditionalContacts.add(contact);
    }

    public String getAdditionalContactNames(String separator, GwtMessages messages) {
        if (!this.hasAdditionalContacts()) {
            return "";
        }
        String ret = "";
        for (ContactInterface contact : this.getAdditionalContacts()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + contact.getName(messages);
        }
        return ret;
    }

    public boolean hasAdditionalContacts() {
        return this.iAdditionalContacts != null && !this.iAdditionalContacts.isEmpty();
    }

    public boolean hasMeetings() {
        return this.iMeetings != null && !this.iMeetings.isEmpty();
    }

    public void addMeeting(MeetingInterface meeting) {
        if (this.iMeetings == null) {
            this.iMeetings = new TreeSet();
        }
        this.iMeetings.add(meeting);
    }

    public TreeSet<MeetingInterface> getMeetings() {
        return this.iMeetings;
    }

    public void setMeetings(TreeSet<MeetingInterface> meetings) {
        this.iMeetings = meetings;
    }

    public boolean hasMeetingsOfStatus(ApprovalStatus status) {
        if (this.iMeetings == null) {
            return false;
        }
        for (MeetingInterface meeting : this.iMeetings) {
            if (status != meeting.getApprovalStatus()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCourseIds() {
        return this.iCourseIds != null && !this.iCourseIds.isEmpty();
    }

    public void addCourseId(Long id) {
        if (this.iCourseIds == null) {
            this.iCourseIds = new ArrayList<Long>();
        }
        this.iCourseIds.add(id);
    }

    public List<Long> getCourseIds() {
        return this.iCourseIds;
    }

    public Long getCourseId(int index) {
        return this.iCourseIds != null && index < this.iCourseIds.size() ? this.iCourseIds.get(index) : null;
    }

    public boolean hasCourseNames() {
        return this.iCourseNames != null && !this.iCourseNames.isEmpty();
    }

    public void addCourseName(String name) {
        if (this.iCourseNames == null) {
            this.iCourseNames = new ArrayList<String>();
        }
        this.iCourseNames.add(name);
    }

    public List<String> getCourseNames() {
        return this.iCourseNames;
    }

    public boolean hasCourseTitles() {
        return this.iCourseTitles != null && !this.iCourseTitles.isEmpty();
    }

    public void addCourseTitle(String title) {
        if (this.iCourseTitles == null) {
            this.iCourseTitles = new ArrayList<String>();
        }
        this.iCourseTitles.add(title);
    }

    public List<String> getCourseTitles() {
        return this.iCourseTitles;
    }

    public boolean hasInstruction() {
        return this.iInstruction != null && !this.iInstruction.isEmpty();
    }

    public String getInstruction() {
        return this.iInstruction;
    }

    public void setInstruction(String instruction) {
        this.iInstruction = instruction;
    }

    public boolean hasInstructionType() {
        return this.iInstructionType != null;
    }

    public Integer getInstructionType() {
        return this.iInstructionType;
    }

    public void setInstructionType(Integer type) {
        this.iInstructionType = type;
    }

    public boolean hasExternalIds() {
        return this.iExternalIds != null && !this.iExternalIds.isEmpty();
    }

    public List<String> getExternalIds() {
        return this.iExternalIds;
    }

    public void addExternalId(String externalId) {
        if (this.iExternalIds == null) {
            this.iExternalIds = new ArrayList<String>();
        }
        if (!this.iExternalIds.contains(externalId)) {
            this.iExternalIds.add(externalId);
        }
    }

    public boolean hasSectionNumber() {
        return this.iSectionNumber != null && !this.iSectionNumber.isEmpty();
    }

    public String getSectionNumber() {
        return this.iSectionNumber;
    }

    public void setSectionNumber(String sectionNumber) {
        this.iSectionNumber = sectionNumber;
    }

    public boolean hasRelatedObjects() {
        return this.iRelatedObjects != null && !this.iRelatedObjects.isEmpty();
    }

    public void addRelatedObject(RelatedObjectInterface relatedObject) {
        if (this.iRelatedObjects == null) {
            this.iRelatedObjects = new ArrayList<RelatedObjectInterface>();
        }
        this.iRelatedObjects.add(relatedObject);
    }

    public List<RelatedObjectInterface> getRelatedObjects() {
        return this.iRelatedObjects;
    }

    public boolean isCanView() {
        return this.iCanView;
    }

    public void setCanView(boolean canView) {
        this.iCanView = canView;
    }

    public boolean isCanEdit() {
        return this.iCanEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.iCanEdit = canEdit;
    }

    public boolean hasConflicts() {
        return this.iConflicts != null && !this.iConflicts.isEmpty();
    }

    public void addConflict(EventInterface conflict) {
        if (this.iConflicts == null) {
            this.iConflicts = new TreeSet<EventInterface>();
        }
        this.iConflicts.add(conflict);
    }

    public Set<EventInterface> getConflicts() {
        return this.iConflicts;
    }

    public void setConflicts(Set<EventInterface> conflicts) {
        this.iConflicts = conflicts;
    }

    public boolean hasMessage() {
        return this.iMessage != null && !this.iMessage.isEmpty();
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public int getSequence() {
        return this.iSequence;
    }

    public void setSequence(int sequence) {
        this.iSequence = sequence;
    }

    public boolean hasTimeStamp() {
        return this.iTimeStamp != null;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    public boolean hasRequestedServices() {
        return this.iRequestedServices != null && !this.iRequestedServices.isEmpty();
    }

    public Set<EventServiceProviderInterface> getRequestedServices() {
        return this.iRequestedServices;
    }

    public void addRequestedService(EventServiceProviderInterface service) {
        if (this.iRequestedServices == null) {
            this.iRequestedServices = new TreeSet<EventServiceProviderInterface>();
        }
        this.iRequestedServices.add(service);
    }

    public boolean hasRequestedService(Long id) {
        if (this.iRequestedServices == null) {
            return false;
        }
        for (EventServiceProviderInterface service : this.iRequestedServices) {
            if (!service.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public String getRequestedServices(String separator) {
        if (!this.hasRequestedServices()) {
            return "";
        }
        String ret = "";
        for (EventServiceProviderInterface service : this.getRequestedServices()) {
            ret = ret + (ret.isEmpty() ? "" : separator) + service.getLabel();
        }
        return ret;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getClassId() {
        return this.iClassId;
    }

    public void setClassId(Long classId) {
        this.iClassId = classId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EventInterface)) {
            return false;
        }
        return this.getId().equals(((EventInterface)o).getId());
    }

    @Override
    public int compareTo(EventInterface event) {
        int cmp = this.getType().compareTo(event.getType());
        if (cmp != 0) {
            return cmp;
        }
        if (this.hasInstructionType() && event.hasInstructionType() && (cmp = this.getInstructionType().compareTo(event.getInstructionType())) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(event.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId().compareTo(event.getId());
    }

    public String toString() {
        return (Object)((Object)this.getType()) + ": " + this.getName();
    }

    public boolean inConflict(MeetingInterface meeting) {
        if (this.hasMeetings()) {
            for (MeetingInterface m : this.getMeetings()) {
                if (!m.inConflict(meeting)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean inConflict(EventInterface event) {
        if (event.hasMeetings()) {
            for (MeetingInterface meeting : event.getMeetings()) {
                if (!this.inConflict(meeting)) continue;
                return true;
            }
        }
        return false;
    }

    public EventInterface createConflictingEvent(EventInterface event) {
        EventInterface conflict = new EventInterface();
        conflict.setId(event.getId());
        conflict.setCanView(event.isCanView());
        conflict.setContact(event.getContact());
        conflict.setName(event.getName());
        conflict.setType(event.getType());
        conflict.setSponsor(event.getSponsor());
        conflict.setEnrollment(event.getEnrollment());
        conflict.setMaxCapacity(event.getMaxCapacity());
        conflict.setInstruction(event.getInstruction());
        conflict.setInstructionType(event.getInstructionType());
        conflict.setSectionNumber(event.getSectionNumber());
        if (event.hasCourseIds()) {
            for (Long courseId : event.getCourseIds()) {
                conflict.addCourseId(courseId);
            }
        }
        if (event.hasCourseNames()) {
            for (String courseName : event.getCourseNames()) {
                conflict.addCourseName(courseName);
            }
        }
        if (event.hasCourseTitles()) {
            for (String courseTitle : event.getCourseTitles()) {
                conflict.addCourseTitle(courseTitle);
            }
        }
        if (event.hasExternalIds()) {
            for (String extId : event.getExternalIds()) {
                conflict.addExternalId(extId);
            }
        }
        if (event.hasInstructors()) {
            for (ContactInterface instructor : event.getInstructors()) {
                conflict.addInstructor(instructor);
            }
        }
        if (event.hasCoordinators()) {
            for (ContactInterface coordinator : event.getCoordinators()) {
                conflict.addCoordinator(coordinator);
            }
        }
        if (event.hasMeetings()) {
            for (MeetingInterface m : event.getMeetings()) {
                if (!this.inConflict(m)) continue;
                conflict.addMeeting(m);
            }
        }
        return conflict;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static TreeSet<MultiMeetingInterface> getMultiMeetings(Collection<MeetingInterface> meetings, boolean checkPast, boolean checkMeetingContacts) {
        return EventInterface.getMultiMeetings(meetings, checkPast, null, null, checkMeetingContacts);
    }

    public static TreeSet<MultiMeetingInterface> getMultiMeetings(Collection<MeetingInterface> meetings, boolean checkPast, DateFlagsProvider flags, EventType type, boolean checkMeetingContacts) {
        TreeSet<MultiMeetingInterface> ret = new TreeSet<MultiMeetingInterface>();
        HashSet<MeetingInterface> meetingSet = new HashSet<MeetingInterface>(meetings);
        while (!meetingSet.isEmpty()) {
            MeetingInterface meeting = null;
            for (MeetingInterface m : meetingSet) {
                if (meeting != null && meeting.compareTo(m) <= 0) continue;
                meeting = m;
            }
            meetingSet.remove(meeting);
            HashMap<Integer, MeetingInterface> similar = new HashMap<Integer, MeetingInterface>();
            TreeSet<Integer> dow = new TreeSet<Integer>();
            dow.add(meeting.getDayOfWeek());
            SessionMonth.Flag flag = flags == null ? null : flags.getDateFlag(type, meeting.getMeetingDate());
            for (MeetingInterface m : meetingSet) {
                if (!m.getMeetingTime(null).equals(meeting.getMeetingTime(null)) || !m.getLocationName().equals(meeting.getLocationName()) || checkMeetingContacts && !m.sameMeetingContacts(meeting) || checkPast && m.isPast() != meeting.isPast() || checkPast && !m.getStyle().equals(meeting.getStyle()) || m.getApprovalStatus() != meeting.getApprovalStatus() || flags != null && flag != flags.getDateFlag(type, m.getMeetingDate())) continue;
                if (m.getDayOfYear() - meeting.getDayOfYear() < 7) {
                    dow.add(m.getDayOfWeek());
                }
                similar.put(m.getDayOfYear(), m);
            }
            TreeSet<MeetingInterface> multi = new TreeSet<MeetingInterface>();
            multi.add(meeting);
            if (!similar.isEmpty()) {
                int w = meeting.getDayOfWeek();
                int y = meeting.getDayOfYear();
                while (true) {
                    ++y;
                    if (!dow.contains(w = (w + 1) % 7)) continue;
                    MeetingInterface m = (MeetingInterface)similar.get(y);
                    if (m == null) break;
                    multi.add(m);
                    meetingSet.remove(m);
                }
            }
            ret.add(new MultiMeetingInterface(multi, meeting.isPast()));
        }
        return ret;
    }

    public static String toString(int firstDayOfWeek, Collection<MeetingInterface> meetings, GwtConstants constants, String separator, DateFormatter df) {
        String ret = "";
        for (MultiMeetingInterface m : EventInterface.getMultiMeetings(meetings, false, false)) {
            if (!ret.isEmpty()) {
                ret = ret + separator;
            }
            ret = ret + (m.getDays(firstDayOfWeek, constants.shortDays(), constants.shortDays(), "") + " " + (m.isArrangeHours() ? constants.arrangeHours() : (m.getNrMeetings() == 1 ? df.formatLastDate(m.getFirstMeetingDate()) : df.formatFirstDate(m.getFirstMeetingDate()) + " - " + df.formatLastDate(m.getLastMeetingDate()))) + " " + m.getMeetings().first().getMeetingTime(constants) + " " + m.getLocationName()).trim();
        }
        return ret;
    }

    public static class SendStudentEmailsRpcRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private Long iEventId;
        private Set<Long> iStudentIds;
        private String iCC;
        private String iSubject;
        private String iMessage;

        public Long getEventId() {
            return this.iEventId;
        }

        public void setEventId(Long eventId) {
            this.iEventId = eventId;
        }

        public String getCC() {
            return this.iCC;
        }

        public void setCC(String cc) {
            this.iCC = cc;
        }

        public boolean hasCC() {
            return this.iCC != null && !this.iCC.isEmpty();
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public Set<Long> getStudentIds() {
            return this.iStudentIds;
        }

        public void setStudentIds(Set<Long> studentIds) {
            this.iStudentIds = studentIds;
        }
    }

    public static class SaveFilterDefaultRpcRequest
    implements GwtRpcRequest<GwtRpcResponse> {
        private String iName;
        private String iValue;

        public SaveFilterDefaultRpcRequest() {
        }

        public SaveFilterDefaultRpcRequest(String name, String value) {
            this.iName = name;
            this.iValue = value;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        @Override
        public String toString() {
            return this.getName() + " = " + this.getValue();
        }
    }

    public static interface DateFlagsProvider {
        public SessionMonth.Flag getDateFlag(EventType var1, Date var2);
    }

    public static class RequestSessionDetails
    extends EventRpcRequest<GwtRpcResponseList<SessionMonth>> {
        public RequestSessionDetails() {
        }

        public RequestSessionDetails(Long sessionId) {
            this.setSessionId(sessionId);
        }

        @Override
        public String toString() {
            return this.getSessionId().toString();
        }
    }

    public static class SessionMonth
    implements IsSerializable {
        private int iYear;
        private int iMonth;
        private int[] iDays;

        public SessionMonth() {
        }

        public SessionMonth(int year, int month) {
            this.iYear = year;
            this.iMonth = month;
            this.iDays = new int[31];
        }

        public int getYear() {
            return this.iYear;
        }

        public int getMonth() {
            return this.iMonth;
        }

        public boolean hasFlag(int day, Flag f) {
            return (this.iDays[day] & f.flag()) != 0;
        }

        public void setFlag(int day, Flag f) {
            if (!this.hasFlag(day, f)) {
                int n = day;
                this.iDays[n] = this.iDays[n] + f.flag();
            }
        }

        public void clearFlag(int day, Flag f) {
            if (this.hasFlag(day, f)) {
                int n = day;
                this.iDays[n] = this.iDays[n] - f.flag();
            }
        }

        public int getFlags(int day) {
            return this.iDays[day];
        }

        public int getFirst(Flag flag) {
            for (int i = 0; i < this.iDays.length; ++i) {
                if (!this.hasFlag(i, flag)) continue;
                return i;
            }
            return -1;
        }

        public static enum Flag implements IsSerializable
        {
            START,
            END,
            FINALS,
            HOLIDAY,
            BREAK,
            SELECTED,
            DISABLED,
            PAST,
            WEEKEND,
            DATE_MAPPING_CLASS,
            DATE_MAPPING_EVENT,
            CLASSES,
            MIDTERMS;


            public int flag() {
                return 1 << this.ordinal();
            }
        }
    }

    public static enum EventFlag implements IsSerializable
    {
        SHOW_PUBLISHED_TIME,
        SHOW_ALLOCATED_TIME,
        SHOW_SETUP_TIME,
        SHOW_TEARDOWN_TIME,
        SHOW_CAPACITY,
        SHOW_LIMIT,
        SHOW_ENROLLMENT,
        SHOW_MAIN_CONTACT,
        SHOW_SPONSOR,
        SHOW_SECTION,
        SHOW_TITLE,
        SHOW_APPROVAL,
        SHOW_NOTE,
        SHOW_LAST_CHANGE,
        SHOW_MEETING_CONTACTS,
        SHOW_REQUESTED_SERVICES;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }

    public static interface DateFormatter {
        public String formatFirstDate(Date var1);

        public String formatLastDate(Date var1);
    }

    public static class ApproveEventRpcRequest
    extends SaveOrApproveEventRpcRequest {
        private SaveOrApproveEventRpcRequest.Operation iOperation;
        private TreeSet<MeetingInterface> iMeetings;

        @Override
        public SaveOrApproveEventRpcRequest.Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(SaveOrApproveEventRpcRequest.Operation operation) {
            this.iOperation = operation;
        }

        public boolean hasMeetings() {
            return this.iMeetings != null && !this.iMeetings.isEmpty();
        }

        public void addMeeting(MeetingInterface meeting) {
            if (this.iMeetings == null) {
                this.iMeetings = new TreeSet();
            }
            this.iMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getMeetings() {
            return this.iMeetings;
        }

        public static ApproveEventRpcRequest createRequest(SaveOrApproveEventRpcRequest.Operation operation, Long sessionId, EventInterface event, List<MeetingInterface> meetings, String message, boolean emailConfirmation) {
            ApproveEventRpcRequest request = new ApproveEventRpcRequest();
            request.setOperation(operation);
            request.setMessage(message);
            request.setEmailConfirmation(emailConfirmation);
            request.setSessionId(sessionId);
            request.setEvent(event);
            if (meetings != null) {
                for (MeetingInterface meeting : meetings) {
                    request.addMeeting(meeting);
                }
            }
            return request;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.getOperation()) + " " + this.getEvent().getName() + " " + this.getMeetings();
        }
    }

    public static class SaveOrApproveEventRpcResponse
    implements GwtRpcResponse {
        private EventInterface iEvent;
        private List<MessageInterface> iMessages = null;
        private List<NoteInterface> iNotes = null;
        private TreeSet<MeetingInterface> iUpdatedMeetings = null;
        private TreeSet<MeetingInterface> iCreatedMeetings = null;
        private TreeSet<MeetingInterface> iDeletedMeetings = null;
        private TreeSet<MeetingInterface> iCancelledMeetings = null;
        private TreeSet<MeetingInterface> iApprovedMeetings = null;
        private TreeSet<EventServiceProviderInterface> iAddedServices = null;
        private TreeSet<EventServiceProviderInterface> iRemovedServices = null;

        public void setEvent(EventInterface event) {
            this.iEvent = event;
        }

        public boolean hasEvent() {
            return this.iEvent != null;
        }

        public boolean hasEventWithId() {
            return this.iEvent != null && this.iEvent.getId() != null;
        }

        public EventInterface getEvent() {
            return this.iEvent;
        }

        public boolean hasMessages() {
            return this.iMessages != null && !this.iMessages.isEmpty();
        }

        public List<MessageInterface> getMessages() {
            return this.iMessages;
        }

        public void addMessage(MessageInterface.Level level, String message) {
            if (this.iMessages == null) {
                this.iMessages = new ArrayList<MessageInterface>();
            }
            this.iMessages.add(new MessageInterface(level, message));
        }

        public void info(String message) {
            this.addMessage(MessageInterface.Level.INFO, message);
        }

        public void warn(String message) {
            this.addMessage(MessageInterface.Level.WARN, message);
        }

        public void error(String message) {
            this.addMessage(MessageInterface.Level.ERROR, message);
        }

        public List<NoteInterface> getNotes() {
            return this.iNotes;
        }

        public boolean hasNotes() {
            return this.iNotes != null && !this.iNotes.isEmpty();
        }

        public void addNote(NoteInterface note) {
            if (this.iNotes == null) {
                this.iNotes = new ArrayList<NoteInterface>();
            }
            this.iNotes.add(note);
        }

        public boolean hasCreatedMeetings() {
            return this.iCreatedMeetings != null && !this.iCreatedMeetings.isEmpty();
        }

        public void addCreatedMeeting(MeetingInterface meeting) {
            if (this.iCreatedMeetings == null) {
                this.iCreatedMeetings = new TreeSet();
            }
            this.iCreatedMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getCreatedMeetings() {
            return this.iCreatedMeetings;
        }

        public boolean hasUpdatedMeetings() {
            return this.iUpdatedMeetings != null && !this.iUpdatedMeetings.isEmpty();
        }

        public void addUpdatedMeeting(MeetingInterface meeting) {
            if (this.iUpdatedMeetings == null) {
                this.iUpdatedMeetings = new TreeSet();
            }
            this.iUpdatedMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getUpdatedMeetings() {
            return this.iUpdatedMeetings;
        }

        public boolean hasDeletedMeetings() {
            return this.iDeletedMeetings != null && !this.iDeletedMeetings.isEmpty();
        }

        public void addDeletedMeeting(MeetingInterface meeting) {
            if (this.iDeletedMeetings == null) {
                this.iDeletedMeetings = new TreeSet();
            }
            this.iDeletedMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getDeletedMeetings() {
            return this.iDeletedMeetings;
        }

        public boolean hasCancelledMeetings() {
            return this.iCancelledMeetings != null && !this.iCancelledMeetings.isEmpty();
        }

        public void addCancelledMeeting(MeetingInterface meeting) {
            if (this.iCancelledMeetings == null) {
                this.iCancelledMeetings = new TreeSet();
            }
            this.iCancelledMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getCancelledMeetings() {
            return this.iCancelledMeetings;
        }

        public boolean hasApprovedMeetings() {
            return this.iApprovedMeetings != null && !this.iApprovedMeetings.isEmpty();
        }

        public void addApprovedMeeting(MeetingInterface meeting) {
            if (this.iApprovedMeetings == null) {
                this.iApprovedMeetings = new TreeSet();
            }
            this.iApprovedMeetings.add(meeting);
        }

        public TreeSet<MeetingInterface> getApprovedMeetings() {
            return this.iApprovedMeetings;
        }

        public boolean hasAddedServices() {
            return this.iAddedServices != null && !this.iAddedServices.isEmpty();
        }

        public void addService(EventServiceProviderInterface service) {
            if (this.iAddedServices == null) {
                this.iAddedServices = new TreeSet();
            }
            this.iAddedServices.add(service);
        }

        public TreeSet<EventServiceProviderInterface> getAddedServices() {
            return this.iAddedServices;
        }

        public boolean hasRemovedServices() {
            return this.iRemovedServices != null && !this.iRemovedServices.isEmpty();
        }

        public void removeService(EventServiceProviderInterface service) {
            if (this.iRemovedServices == null) {
                this.iRemovedServices = new TreeSet();
            }
            this.iRemovedServices.add(service);
        }

        public TreeSet<EventServiceProviderInterface> getRemovedServices() {
            return this.iRemovedServices;
        }
    }

    public static class MessageInterface
    implements IsSerializable {
        private Level iLevel;
        private String iMessage;

        public MessageInterface() {
        }

        public MessageInterface(Level level, String message) {
            this.iLevel = level;
            this.iMessage = message;
        }

        public Level getLevel() {
            return this.iLevel;
        }

        public boolean isInfo() {
            return this.iLevel == Level.INFO;
        }

        public boolean isWarning() {
            return this.iLevel == Level.WARN;
        }

        public boolean isError() {
            return this.iLevel == Level.ERROR;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public String toString() {
            return (Object)((Object)this.getLevel()) + ": " + this.getMessage();
        }

        public static enum Level implements IsSerializable
        {
            INFO,
            WARN,
            ERROR;

        }
    }

    public static class SaveEventRpcRequest
    extends SaveOrApproveEventRpcRequest {
        @Override
        public SaveOrApproveEventRpcRequest.Operation getOperation() {
            return this.getEvent().hasMeetings() ? (this.getEvent().getId() == null ? SaveOrApproveEventRpcRequest.Operation.CREATE : SaveOrApproveEventRpcRequest.Operation.UPDATE) : SaveOrApproveEventRpcRequest.Operation.DELETE;
        }

        public static SaveEventRpcRequest saveEvent(EventInterface event, Long sessionId, String message, boolean emailConfirmation) {
            SaveEventRpcRequest request = new SaveEventRpcRequest();
            request.setEvent(event);
            request.setSessionId(sessionId);
            request.setMessage(message);
            request.setEmailConfirmation(emailConfirmation);
            return request;
        }

        @Override
        public String toString() {
            return this.getEvent() + (this.getEvent().hasMeetings() ? " " + this.getEvent().getMeetings() : "");
        }
    }

    public static abstract class SaveOrApproveEventRpcRequest
    extends EventRpcRequest<SaveOrApproveEventRpcResponse> {
        private EventInterface iEvent;
        private String iMessage;
        private boolean iEmailConfirmation = true;

        public EventInterface getEvent() {
            return this.iEvent;
        }

        public void setEvent(EventInterface event) {
            this.iEvent = event;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public boolean isEmailConfirmation() {
            return this.iEmailConfirmation;
        }

        public void setEmailConfirmation(boolean emailConfirmation) {
            this.iEmailConfirmation = emailConfirmation;
        }

        public abstract Operation getOperation();

        public static enum Operation implements IsSerializable
        {
            APPROVE,
            REJECT,
            INQUIRE,
            CREATE,
            UPDATE,
            DELETE,
            CANCEL,
            EMAIL;

        }
    }

    public static class EventEnrollmentsRpcRequest
    extends EventRpcRequest<GwtRpcResponseList<ClassAssignmentInterface.Enrollment>> {
        private List<RelatedObjectInterface> iRelatedObjects = null;
        private List<MeetingInterface> iMeetings = null;
        private Long iEventId;

        public boolean hasRelatedObjects() {
            return this.iRelatedObjects != null && !this.iRelatedObjects.isEmpty();
        }

        public void setRelatedObjects(List<RelatedObjectInterface> objects) {
            this.iRelatedObjects = objects;
        }

        public void addRelatedObject(RelatedObjectInterface relatedObject) {
            if (this.iRelatedObjects == null) {
                this.iRelatedObjects = new ArrayList<RelatedObjectInterface>();
            }
            this.iRelatedObjects.add(relatedObject);
        }

        public List<RelatedObjectInterface> getRelatedObjects() {
            return this.iRelatedObjects;
        }

        public boolean hasMeetings() {
            return this.iMeetings != null && !this.iMeetings.isEmpty();
        }

        public void setMeetings(List<MeetingInterface> meetings) {
            this.iMeetings = meetings;
        }

        public void addMeeting(MeetingInterface meeting) {
            if (this.iMeetings == null) {
                this.iMeetings = new ArrayList<MeetingInterface>();
            }
            this.iMeetings.add(meeting);
        }

        public List<MeetingInterface> getMeetings() {
            return this.iMeetings;
        }

        public boolean hasEventId() {
            return this.iEventId != null;
        }

        public Long getEventId() {
            return this.iEventId;
        }

        public void setEventId(Long eventId) {
            this.iEventId = eventId;
        }

        @Override
        public String toString() {
            return "objects=" + (this.hasRelatedObjects() ? this.iRelatedObjects.toString() : "NULL") + ", meetings=" + (this.hasMeetings() ? this.getMeetings().toString() : "NULL");
        }

        public static EventEnrollmentsRpcRequest getEnrollmentsForEvent(Long eventId, Long sessionId) {
            EventEnrollmentsRpcRequest request = new EventEnrollmentsRpcRequest();
            request.setEventId(eventId);
            request.setSessionId(sessionId);
            return request;
        }

        public static EventEnrollmentsRpcRequest getEnrollmentsForRelatedObjects(List<RelatedObjectInterface> objects, List<MeetingInterface> meetings, Long eventId, Long sessionId) {
            EventEnrollmentsRpcRequest request = new EventEnrollmentsRpcRequest();
            request.setRelatedObjects(objects);
            request.setMeetings(meetings);
            request.setEventId(eventId);
            request.setSessionId(sessionId);
            return request;
        }
    }

    public static class RelatedObjectLookupRpcResponse
    implements GwtRpcResponse {
        private RelatedObjectLookupRpcRequest.Level iLevel;
        private Long iUniqueId;
        private String iName;
        private String iText;
        private RelatedObjectInterface iRelatedObject = null;

        public RelatedObjectLookupRpcResponse() {
        }

        public RelatedObjectLookupRpcResponse(RelatedObjectLookupRpcRequest.Level level, Long uniqueId, String name) {
            this(level, uniqueId, name, null, null);
        }

        public RelatedObjectLookupRpcResponse(RelatedObjectLookupRpcRequest.Level level, Long uniqueId, String name, String text) {
            this(level, uniqueId, name, text, null);
        }

        public RelatedObjectLookupRpcResponse(RelatedObjectLookupRpcRequest.Level level, Long uniqueId, String name, RelatedObjectInterface related) {
            this(level, uniqueId, name, null, related);
        }

        public RelatedObjectLookupRpcResponse(RelatedObjectLookupRpcRequest.Level level, Long uniqueId, String name, String text, RelatedObjectInterface related) {
            this.iLevel = level;
            this.iUniqueId = uniqueId;
            this.iName = name;
            this.iText = text;
            this.iRelatedObject = related;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public RelatedObjectLookupRpcRequest.Level getLevel() {
            return this.iLevel;
        }

        public void setLevel(RelatedObjectLookupRpcRequest.Level level) {
            this.iLevel = level;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        public String getLabel() {
            return this.getName() + (this.getText() == null || this.getText().isEmpty() ? "" : " - " + this.getText());
        }

        public boolean hasRelatedObject() {
            return this.iRelatedObject != null;
        }

        public RelatedObjectInterface getRelatedObject() {
            return this.iRelatedObject;
        }

        public void setRelatedObject(RelatedObjectInterface relatedObject) {
            this.iRelatedObject = relatedObject;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RelatedObjectLookupRpcResponse)) {
                return false;
            }
            RelatedObjectLookupRpcResponse r = (RelatedObjectLookupRpcResponse)o;
            return EventInterface.equals((Object)this.getLevel(), (Object)r.getLevel()) && EventInterface.equals(this.getUniqueId(), r.getUniqueId());
        }

        public String toString() {
            return (Object)((Object)this.getLevel()) + "@" + this.getUniqueId() + " " + this.getLabel();
        }
    }

    public static class RelatedObjectLookupRpcRequest
    extends EventRpcRequest<GwtRpcResponseList<RelatedObjectLookupRpcResponse>> {
        private Long iUniqueId;
        private Long iCourseId;
        private Level iLevel;

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Level getLevel() {
            return this.iLevel;
        }

        public void setLevel(Level level) {
            this.iLevel = level;
        }

        @Override
        public String toString() {
            return this.getLevel().name() + "[" + this.getUniqueId() + "]";
        }

        public static RelatedObjectLookupRpcRequest getChildren(Long sessionId, Level level, Long uniqueId) {
            RelatedObjectLookupRpcRequest request = new RelatedObjectLookupRpcRequest();
            request.setSessionId(sessionId);
            request.setLevel(level);
            request.setUniqueId(uniqueId);
            return request;
        }

        public static RelatedObjectLookupRpcRequest getChildren(Long sessionId, RelatedObjectLookupRpcResponse ... response) {
            RelatedObjectLookupRpcRequest request = new RelatedObjectLookupRpcRequest();
            request.setSessionId(sessionId);
            request.setLevel(response[response.length - 1].getLevel());
            request.setUniqueId(response[response.length - 1].getUniqueId());
            for (RelatedObjectLookupRpcResponse r : response) {
                if (r.getLevel() != Level.COURSE) continue;
                request.setCourseId(r.getUniqueId());
            }
            return request;
        }

        public static enum Level implements IsSerializable
        {
            SESSION,
            SUBJECT,
            OFFERING,
            COURSE,
            CONFIG,
            SUBPART,
            CLASS,
            NONE;

        }
    }

    public static class EventRoomAvailabilityRpcResponse
    implements GwtRpcResponse {
        private Map<Integer, Map<Long, Set<MeetingConflictInterface>>> iOverlaps = new HashMap<Integer, Map<Long, Set<MeetingConflictInterface>>>();
        private List<MeetingInterface> iMeetings;

        public void setMeetings(List<MeetingInterface> meetings) {
            this.iMeetings = meetings;
        }

        public boolean hasMeetings() {
            return this.iMeetings != null && !this.iMeetings.isEmpty();
        }

        public List<MeetingInterface> getMeetings() {
            return this.iMeetings;
        }

        public void addOverlap(Integer date, Long locationId, MeetingConflictInterface conflict) {
            Set<MeetingConflictInterface> overlaps;
            Map<Long, Set<MeetingConflictInterface>> loc2overlaps = this.iOverlaps.get(date);
            if (loc2overlaps == null) {
                loc2overlaps = new HashMap<Long, Set<MeetingConflictInterface>>();
                this.iOverlaps.put(date, loc2overlaps);
            }
            if ((overlaps = loc2overlaps.get(locationId)) == null) {
                overlaps = new TreeSet<MeetingConflictInterface>();
                loc2overlaps.put(locationId, overlaps);
            }
            overlaps.add(conflict);
        }

        public boolean hasOverlaps() {
            return this.iOverlaps != null && !this.iOverlaps.isEmpty();
        }

        public boolean isAvailable(Integer date, Long locationId) {
            Set<MeetingConflictInterface> overlaps = this.getOverlaps(date, locationId);
            return overlaps == null || overlaps.isEmpty();
        }

        public Set<MeetingConflictInterface> getOverlaps(Integer date, Long locationId) {
            Map<Long, Set<MeetingConflictInterface>> loc2overlaps = this.iOverlaps.get(date);
            return loc2overlaps == null ? null : loc2overlaps.get(locationId);
        }
    }

    public static class EventRoomAvailabilityRpcRequest
    extends EventRpcRequest<EventRoomAvailabilityRpcResponse> {
        private Long iEventId;
        private EventType iEventType;
        private Integer iStartSlot;
        private Integer iEndSlot;
        private List<Integer> iDates;
        private List<Long> iLocations;
        private List<MeetingInterface> iMeetings;

        public void setStartSlot(Integer startSlot) {
            this.iStartSlot = startSlot;
        }

        public Integer getStartSlot() {
            return this.iStartSlot;
        }

        public void setEndSlot(Integer endSlot) {
            this.iEndSlot = endSlot;
        }

        public Integer getEndSlot() {
            return this.iEndSlot;
        }

        public void setDates(List<Integer> dates) {
            this.iDates = dates;
        }

        public boolean hasDates() {
            return this.iDates != null && !this.iDates.isEmpty();
        }

        public List<Integer> getDates() {
            return this.iDates;
        }

        public void setLocations(List<Long> locations) {
            this.iLocations = locations;
        }

        public boolean hasLocations() {
            return this.iLocations != null && !this.iLocations.isEmpty();
        }

        public List<Long> getLocations() {
            return this.iLocations;
        }

        public void setMeetings(List<MeetingInterface> meetings) {
            this.iMeetings = meetings;
        }

        public boolean hasMeetings() {
            return this.iMeetings != null && !this.iMeetings.isEmpty();
        }

        public List<MeetingInterface> getMeetings() {
            return this.iMeetings;
        }

        public boolean hasEventId() {
            return this.iEventId != null;
        }

        public Long getEventId() {
            return this.iEventId;
        }

        public void setEventId(Long eventId) {
            this.iEventId = eventId;
        }

        public boolean hasEventType() {
            return this.iEventType != null;
        }

        public EventType getEventType() {
            return this.iEventType;
        }

        public void setEventType(EventType type) {
            this.iEventType = type;
        }

        public static EventRoomAvailabilityRpcRequest checkAvailability(int startSlot, int endSlot, List<Integer> dates, List<FilterRpcResponse.Entity> locations, Long eventId, Long sessionId) {
            EventRoomAvailabilityRpcRequest request = new EventRoomAvailabilityRpcRequest();
            request.setStartSlot(startSlot);
            request.setEndSlot(endSlot);
            request.setDates(dates);
            ArrayList<Long> locationIds = new ArrayList<Long>();
            for (FilterRpcResponse.Entity location : locations) {
                locationIds.add(Long.valueOf(location.getProperty("permId", null)));
            }
            request.setLocations(locationIds);
            request.setEventId(eventId);
            request.setSessionId(sessionId);
            return request;
        }

        public static EventRoomAvailabilityRpcRequest checkAvailability(List<MeetingInterface> meetings, Long eventId, EventType eventType, Long sessionId) {
            EventRoomAvailabilityRpcRequest request = new EventRoomAvailabilityRpcRequest();
            request.setMeetings(meetings);
            request.setEventId(eventId);
            request.setEventType(eventType);
            request.setSessionId(sessionId);
            return request;
        }

        @Override
        public String toString() {
            return "sessionId=" + this.getSessionId() + (this.hasMeetings() ? ",meetings=" + this.getMeetings() : ",start=" + this.getStartSlot() + ",end=" + this.getEndSlot() + ",dates=" + this.getDates() + ",locations=" + this.getLocations());
        }
    }

    public static class EventDetailRpcRequest
    extends EventRpcRequest<EventInterface> {
        private Long iEventId;

        public Long getEventId() {
            return this.iEventId;
        }

        public void setEventId(Long eventId) {
            this.iEventId = eventId;
        }

        public static EventDetailRpcRequest requestEventDetails(Long sessionId, Long eventId) {
            EventDetailRpcRequest request = new EventDetailRpcRequest();
            request.setSessionId(sessionId);
            request.setEventId(eventId);
            return request;
        }

        @Override
        public String toString() {
            return "sessionId=" + this.getSessionId() + ",eventId=" + this.getEventId();
        }
    }

    public static class EventPropertiesRpcResponse
    implements GwtRpcResponse {
        private boolean iCanLookupPeople = false;
        private boolean iCanLookupMainContact = false;
        private boolean iCanLookupAdditionalContacts = false;
        private boolean iCanAddEvent = false;
        private boolean iCanAddCourseEvent = false;
        private boolean iCanAddUnavailableEvent = false;
        private boolean iCanExportCSV = false;
        private boolean iCanSetExpirationDate = false;
        private List<SponsoringOrganizationInterface> iSponsoringOrganizations = null;
        private ContactInterface iMainContact = null;
        private Set<StandardEventNoteInterface> iStandardNotes = null;
        private Boolean iEmailConfirmation = null;
        private boolean iCanSaveFilterDefaults = false;
        private Map<String, String> iFilterDefaults = null;
        private Integer iTooEarlySlot = null;
        private boolean iCanEditAcademicTitle = false;
        private boolean iGridDisplayTitle = false;
        private boolean iStudent = false;
        private boolean iViewMeetingContacts = false;
        private boolean iEditMeetingContacts = false;
        private Set<EventServiceProviderInterface> iEventServiceProviders = null;
        private Integer iFirstDayOfWeek = null;
        private boolean iCourseEventDefaultStudentAttendance = false;
        private boolean iExpectedAttendanceRequired = false;
        private boolean iCanEmailStudents = false;

        public boolean isCanLookupPeople() {
            return this.iCanLookupPeople;
        }

        public void setCanLookupPeople(boolean canLookupPeople) {
            this.iCanLookupPeople = canLookupPeople;
        }

        public boolean isCanExportCSV() {
            return this.iCanExportCSV;
        }

        public void setCanExportCSV(boolean canExportCSV) {
            this.iCanExportCSV = canExportCSV;
        }

        public boolean isCanLookupMainContact() {
            return this.iCanLookupMainContact;
        }

        public void setCanLookupMainContact(boolean canLookupContact) {
            this.iCanLookupMainContact = canLookupContact;
        }

        public boolean isCanLookupAdditionalContacts() {
            return this.iCanLookupAdditionalContacts;
        }

        public void setCanLookupAdditionalContacts(boolean canLookupContacts) {
            this.iCanLookupAdditionalContacts = canLookupContacts;
        }

        public boolean isCanAddSpecialEvent() {
            return this.iCanAddEvent;
        }

        public void setCanAddSpecialEvent(boolean canAddEvent) {
            this.iCanAddEvent = canAddEvent;
        }

        public boolean isCanAddCourseEvent() {
            return this.iCanAddCourseEvent;
        }

        public void setCanAddCourseEvent(boolean canAddEvent) {
            this.iCanAddCourseEvent = canAddEvent;
        }

        public boolean isCanAddUnavailableEvent() {
            return this.iCanAddUnavailableEvent;
        }

        public void setCanAddUnavailableEvent(boolean canAddEvent) {
            this.iCanAddUnavailableEvent = canAddEvent;
        }

        public boolean isCanAddEvent() {
            return this.isCanAddSpecialEvent() || this.isCanAddCourseEvent() || this.isCanAddUnavailableEvent();
        }

        public boolean isCanSetExpirationDate() {
            return this.iCanSetExpirationDate;
        }

        public void setCanSetExpirationDate(boolean canSetExpirationDate) {
            this.iCanSetExpirationDate = canSetExpirationDate;
        }

        public boolean hasSponsoringOrganizations() {
            return this.iSponsoringOrganizations != null && !this.iSponsoringOrganizations.isEmpty();
        }

        public List<SponsoringOrganizationInterface> getSponsoringOrganizations() {
            return this.iSponsoringOrganizations;
        }

        public void addSponsoringOrganization(SponsoringOrganizationInterface sponsor) {
            if (this.iSponsoringOrganizations == null) {
                this.iSponsoringOrganizations = new ArrayList<SponsoringOrganizationInterface>();
            }
            this.iSponsoringOrganizations.add(sponsor);
        }

        public boolean hasMainContact() {
            return this.iMainContact != null;
        }

        public ContactInterface getMainContact() {
            return this.iMainContact;
        }

        public void setMainContact(ContactInterface mainContact) {
            this.iMainContact = mainContact;
        }

        public boolean hasStandardNotes() {
            return this.iStandardNotes != null && !this.iStandardNotes.isEmpty();
        }

        public Set<StandardEventNoteInterface> getStandardNotes() {
            return this.iStandardNotes;
        }

        public void addStandardNote(StandardEventNoteInterface note) {
            if (this.iStandardNotes == null) {
                this.iStandardNotes = new TreeSet<StandardEventNoteInterface>();
            }
            this.iStandardNotes.add(note);
        }

        public boolean hasEmailConfirmation() {
            return this.iEmailConfirmation != null;
        }

        public boolean isEmailConfirmation() {
            return this.iEmailConfirmation != null && this.iEmailConfirmation != false;
        }

        public void setEmailConfirmation(Boolean emailConfirmation) {
            this.iEmailConfirmation = emailConfirmation;
        }

        public void setCanSaveFilterDefaults(boolean canSaveFilterDefaults) {
            this.iCanSaveFilterDefaults = canSaveFilterDefaults;
        }

        public boolean isCanSaveFilterDefaults() {
            return this.iCanSaveFilterDefaults;
        }

        public void setFilterDefault(String name, String value) {
            if (value == null) {
                return;
            }
            if (this.iFilterDefaults == null) {
                this.iFilterDefaults = new HashMap<String, String>();
            }
            this.iFilterDefaults.put(name, value);
        }

        public boolean hasFilterDefault(String name) {
            return this.iFilterDefaults != null && this.iFilterDefaults.get(name) != null;
        }

        public String getFilterDefault(String name) {
            return this.iFilterDefaults == null ? null : this.iFilterDefaults.get(name);
        }

        public boolean hasTooEarlySlot() {
            return this.iTooEarlySlot != null && this.iTooEarlySlot > 0;
        }

        public void setTooEarlySlot(int slot) {
            this.iTooEarlySlot = slot;
        }

        public Integer getTooEarlySlot() {
            return this.iTooEarlySlot;
        }

        public boolean isCanEditAcademicTitle() {
            return this.iCanEditAcademicTitle;
        }

        public void setCanEditAcademicTitle(boolean canEditAcademicTitle) {
            this.iCanEditAcademicTitle = canEditAcademicTitle;
        }

        public boolean isGridDisplayTitle() {
            return this.iGridDisplayTitle;
        }

        public void setGridDisplayTitle(boolean gridDisplayTitle) {
            this.iGridDisplayTitle = gridDisplayTitle;
        }

        public boolean isStudent() {
            return this.iStudent;
        }

        public void setStudent(boolean student) {
            this.iStudent = student;
        }

        public boolean isCanViewMeetingContacts() {
            return this.iViewMeetingContacts || this.iEditMeetingContacts;
        }

        public void setCanViewMeetingContacts(boolean viewMeetingContacts) {
            this.iViewMeetingContacts = viewMeetingContacts;
        }

        public boolean isCanEditMeetingContacts() {
            return this.iEditMeetingContacts;
        }

        public void setCanEditMeetingContacts(boolean editMeetingContacts) {
            this.iEditMeetingContacts = editMeetingContacts;
        }

        public boolean hasEventServiceProviders() {
            return this.iEventServiceProviders != null && !this.iEventServiceProviders.isEmpty();
        }

        public Set<EventServiceProviderInterface> getEventServiceProviders() {
            return this.iEventServiceProviders;
        }

        public void addEventServiceProvider(EventServiceProviderInterface provider) {
            if (this.iEventServiceProviders == null) {
                this.iEventServiceProviders = new TreeSet<EventServiceProviderInterface>();
            }
            this.iEventServiceProviders.add(provider);
        }

        public void setFirstDayOfWeek(Integer firstDay) {
            this.iFirstDayOfWeek = firstDay;
        }

        public Integer getFirstDayOfWeek() {
            return this.iFirstDayOfWeek;
        }

        public void setCourseEventDefaultStudentAttendance(boolean courseEventDefaultStudentAttendance) {
            this.iCourseEventDefaultStudentAttendance = courseEventDefaultStudentAttendance;
        }

        public boolean getCourseEventDefaultStudentAttendance() {
            return this.iCourseEventDefaultStudentAttendance;
        }

        public void setExpectedAttendanceRequired(boolean expectedAttendanceRequired) {
            this.iExpectedAttendanceRequired = expectedAttendanceRequired;
        }

        public boolean getExpectedAttendanceRequired() {
            return this.iExpectedAttendanceRequired;
        }

        public void setCanEmailStudents(boolean canEmailStudents) {
            this.iCanEmailStudents = canEmailStudents;
        }

        public boolean getCanEmailStudents() {
            return this.iCanEmailStudents;
        }
    }

    public static class EventServiceProviderInterface
    implements IsSerializable,
    Comparable<EventServiceProviderInterface> {
        private Long iId;
        private String iReference;
        private String iLabel;
        private String iMessage;
        private String iEmail;
        private Long iDepartmentId;
        private Set<Long> iLocationIds = null;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        public boolean hasLocationIds() {
            return this.iLocationIds != null;
        }

        public void setLocationIds(Set<Long> locationIds) {
            this.iLocationIds = locationIds;
        }

        public boolean hasLocation(Long id) {
            return this.iLocationIds == null || id != null && this.iLocationIds.contains(id);
        }

        public boolean hasLocation(ResourceInterface location) {
            return location != null && this.hasLocation(location.getId());
        }

        public String toString() {
            return this.getReference() + ": " + this.getLabel();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof EventServiceProviderInterface)) {
                return false;
            }
            EventServiceProviderInterface n = (EventServiceProviderInterface)o;
            return this.getId().equals(n.getId());
        }

        @Override
        public int compareTo(EventServiceProviderInterface n) {
            return this.toString().compareToIgnoreCase(n.toString());
        }
    }

    public static class StandardEventNoteInterface
    implements IsSerializable,
    Comparable<StandardEventNoteInterface> {
        private Long iId;
        private String iReference;
        private String iNote;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String toString() {
            return this.getReference() + ": " + this.getNote();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof StandardEventNoteInterface)) {
                return false;
            }
            StandardEventNoteInterface n = (StandardEventNoteInterface)o;
            return this.getId().equals(n.getId());
        }

        @Override
        public int compareTo(StandardEventNoteInterface n) {
            return this.toString().compareToIgnoreCase(n.toString());
        }
    }

    public static class EventPropertiesRpcRequest
    extends EventRpcRequest<EventPropertiesRpcResponse> {
        private String iPageName;

        public EventPropertiesRpcRequest() {
        }

        public EventPropertiesRpcRequest(Long sessionId) {
            this.setSessionId(sessionId);
        }

        public String getPageName() {
            return this.iPageName;
        }

        public void setPageName(String pageName) {
            this.iPageName = pageName;
        }

        public static EventPropertiesRpcRequest requestEventProperties(Long sessionId, String pageName) {
            EventPropertiesRpcRequest request = new EventPropertiesRpcRequest(sessionId);
            request.setPageName(pageName);
            return request;
        }

        @Override
        public String toString() {
            return this.getPageName() + "@" + (this.hasSessionId() ? this.getSessionId().toString() : "NULL");
        }
    }

    public static class EncodeQueryRpcResponse
    implements GwtRpcResponse {
        private String iQuery;
        private String iHash = null;

        public EncodeQueryRpcResponse() {
        }

        public EncodeQueryRpcResponse(String query) {
            this.iQuery = query;
        }

        public EncodeQueryRpcResponse(String query, String hash) {
            this.iQuery = query;
            this.iHash = hash;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }

        public boolean hasHash() {
            return this.iHash != null && !this.iHash.isEmpty();
        }

        public String getHash() {
            return this.iHash;
        }

        public void setHash(String hash) {
            this.iHash = hash;
        }
    }

    public static class EncodeQueryRpcRequest
    implements GwtRpcRequest<EncodeQueryRpcResponse> {
        private String iQuery;
        private boolean iHash = false;

        public EncodeQueryRpcRequest() {
        }

        public EncodeQueryRpcRequest(String query) {
            this.iQuery = query;
        }

        public EncodeQueryRpcRequest(String query, boolean hash) {
            this.iQuery = query;
            this.iHash = hash;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }

        public boolean isHash() {
            return this.iHash;
        }

        public void setHash(boolean hash) {
            this.iHash = hash;
        }

        public static EncodeQueryRpcRequest encode(String query) {
            return new EncodeQueryRpcRequest(query);
        }

        public static EncodeQueryRpcRequest encode(String query, boolean hash) {
            return new EncodeQueryRpcRequest(query, hash);
        }

        @Override
        public String toString() {
            return this.getQuery();
        }
    }

    public static class EventLookupRpcRequest
    extends EventRpcRequest<GwtRpcResponseList<EventInterface>> {
        private ResourceType iResourceType;
        private Long iResourceId;
        private String iResourceExternalId;
        private EventFilterRpcRequest iEventFilter;
        private RoomFilterRpcRequest iRoomFilter;
        private int iLimit = -1;

        public ResourceType getResourceType() {
            return this.iResourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.iResourceType = resourceType;
        }

        public Long getResourceId() {
            return this.iResourceId;
        }

        public void setResourceId(Long resourceId) {
            this.iResourceId = resourceId;
        }

        public boolean hasResourceExternalId() {
            return this.iResourceExternalId != null && !this.iResourceExternalId.isEmpty();
        }

        public String getResourceExternalId() {
            return this.iResourceExternalId;
        }

        public void setResourceExternalId(String resourceExternalId) {
            this.iResourceExternalId = resourceExternalId;
        }

        public EventFilterRpcRequest getEventFilter() {
            return this.iEventFilter;
        }

        public void setEventFilter(EventFilterRpcRequest eventFilter) {
            this.iEventFilter = eventFilter;
        }

        public RoomFilterRpcRequest getRoomFilter() {
            return this.iRoomFilter;
        }

        public void setRoomFilter(RoomFilterRpcRequest roomFilter) {
            this.iRoomFilter = roomFilter;
        }

        public boolean hasLimit() {
            return this.iLimit > 0;
        }

        public int getLimit() {
            return this.iLimit;
        }

        public void setLimit(int limit) {
            this.iLimit = limit;
        }

        public static EventLookupRpcRequest findEvents(Long sessionId, ResourceInterface resource, EventFilterRpcRequest eventFilter, RoomFilterRpcRequest roomFilter, int limit) {
            EventLookupRpcRequest request = new EventLookupRpcRequest();
            request.setSessionId(sessionId);
            if (resource != null) {
                request.setResourceType(resource.getType());
                request.setResourceId(resource.getId());
                request.setResourceExternalId(resource.getExternalId());
            } else {
                request.setResourceType(ResourceType.ROOM);
            }
            request.setEventFilter(eventFilter);
            request.setRoomFilter(roomFilter);
            request.setLimit(limit);
            return request;
        }

        @Override
        public String toString() {
            return "sessionId=" + this.getSessionId() + ",resource=" + (Object)((Object)this.getResourceType()) + "@" + (this.hasResourceExternalId() ? this.getResourceExternalId() : this.getResourceId());
        }
    }

    public static class ResourceLookupRpcRequest
    extends EventRpcRequest<GwtRpcResponseList<ResourceInterface>> {
        private ResourceType iResourceType;
        private String iName;
        private Integer iLimit;

        public ResourceType getResourceType() {
            return this.iResourceType;
        }

        public void setResourceType(ResourceType resourceType) {
            this.iResourceType = resourceType;
        }

        public String getName() {
            return this.iName;
        }

        public boolean hasName() {
            return this.iName != null && !this.iName.isEmpty();
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasLimit() {
            return this.iLimit != null && this.iLimit > 0;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        @Override
        public String toString() {
            return this.getResourceType().getLabel() + (this.getName() == null || this.getName().isEmpty() ? "" : "{" + this.getName() + "}");
        }

        public static ResourceLookupRpcRequest findResource(Long sessionId, ResourceType type, String name) {
            ResourceLookupRpcRequest request = new ResourceLookupRpcRequest();
            request.setSessionId(sessionId);
            request.setLimit(1);
            request.setResourceType(type);
            request.setName(name);
            return request;
        }

        public static ResourceLookupRpcRequest findResources(Long sessionId, ResourceType type, String name, int limit) {
            ResourceLookupRpcRequest request = new ResourceLookupRpcRequest();
            request.setSessionId(sessionId);
            request.setLimit(limit);
            request.setResourceType(type);
            request.setName(name);
            return request;
        }
    }

    public static class FilterRpcResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<String, ArrayList<Entity>> iEntities = null;
        private HashMap<String, String> iTypeLabels = null;

        public boolean hasEntities() {
            return this.iEntities != null && !this.iEntities.isEmpty();
        }

        public boolean hasEntities(String type) {
            List<Entity> entities = this.getEntities(type);
            return entities != null && !entities.isEmpty();
        }

        public Set<String> getTypes() {
            return this.iEntities == null ? null : new TreeSet<String>(this.iEntities.keySet());
        }

        public List<Entity> getEntities(String type) {
            return this.iEntities == null ? null : (List)this.iEntities.get(type);
        }

        public void add(String type, Entity entity) {
            ArrayList<Entity> entities;
            if (this.iEntities == null) {
                this.iEntities = new HashMap();
            }
            if ((entities = this.iEntities.get(type)) == null) {
                entities = new ArrayList();
                this.iEntities.put(type, entities);
            }
            entities.add(entity);
        }

        public void add(String type, Collection<Entity> entity) {
            ArrayList<Entity> entities;
            if (this.iEntities == null) {
                this.iEntities = new HashMap();
            }
            if ((entities = this.iEntities.get(type)) == null) {
                entities = new ArrayList<Entity>(entity);
                this.iEntities.put(type, entities);
            } else {
                entities.addAll(entity);
            }
        }

        public void addResult(Entity entity) {
            this.add("results", entity);
        }

        public boolean hasResults() {
            return this.hasEntities("results");
        }

        public List<Entity> getResults() {
            return this.getEntities("results");
        }

        public void addSuggestion(String message, String replacement, String hint) {
            this.add("suggestion", new Entity(0L, replacement, message, "hint", hint));
        }

        public void addSuggestion(String message, String replacement, String hint, String command) {
            this.add("suggestion", new Entity(0L, replacement, message, "hint", hint, "command", command));
        }

        public void addSuggestion(String message, String replacement, String hint, String command, boolean allowMultiple) {
            this.add("suggestion", new Entity(0L, replacement, message, "hint", hint, "command", command, "single", allowMultiple ? "false" : "true"));
        }

        public boolean hasSuggestions() {
            return this.hasEntities("suggestion");
        }

        public List<Entity> getSuggestions() {
            return this.getEntities("suggestion");
        }

        public void setTypeLabel(String type, String label) {
            if (this.iTypeLabels == null) {
                this.iTypeLabels = new HashMap();
            }
            this.iTypeLabels.put(type, label);
        }

        public String getTypeLabel(String type) {
            if (this.iTypeLabels == null) {
                return type;
            }
            String label = this.iTypeLabels.get(type);
            return label == null ? type : label;
        }

        public String toString() {
            return this.iEntities == null ? "null" : this.iEntities.toString();
        }

        public static class Entity
        implements IsSerializable,
        Comparable<Entity>,
        Serializable {
            private static final long serialVersionUID = 1L;
            private Long iUniqueId;
            private String iAbbv;
            private String iName;
            private int iCount = 0;
            private HashMap<String, String> iParams;

            public Entity() {
            }

            public Entity(Long uniqueId, String abbv, String name, String ... properties) {
                this.iUniqueId = uniqueId;
                this.iAbbv = abbv;
                this.iName = name;
                int i = 0;
                while (i + 1 < properties.length) {
                    if (properties[i + 1] != null) {
                        this.setProperty(properties[i], properties[i + 1]);
                    }
                    i += 2;
                }
            }

            public Long getUniqueId() {
                return this.iUniqueId;
            }

            public void setUniqueId(Long uniqueId) {
                this.iUniqueId = uniqueId;
            }

            public String getAbbreviation() {
                return this.iAbbv;
            }

            public void setAbbreviation(String abbreviation) {
                this.iAbbv = abbreviation;
            }

            public String getName() {
                return this.iName;
            }

            public void setName(String name) {
                this.iName = name;
            }

            public int getCount() {
                return this.iCount;
            }

            public void setCount(int count) {
                this.iCount = count;
            }

            public void incCount() {
                ++this.iCount;
            }

            public void setProperty(String property, String value) {
                if (this.iParams == null) {
                    this.iParams = new HashMap();
                }
                this.iParams.put(property, value);
            }

            public String getProperty(String property, String defaultValue) {
                String value = this.iParams == null ? null : this.iParams.get(property);
                return value == null ? defaultValue : value;
            }

            public int hasCode() {
                return this.getUniqueId().hashCode();
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof Entity)) {
                    return false;
                }
                Entity e = (Entity)o;
                return this.getUniqueId().equals(e.getUniqueId()) && this.getName().equals(e.getName());
            }

            @Override
            public int compareTo(Entity e) {
                if (this.getUniqueId() < 0L) {
                    return e.getUniqueId() >= 0L ? -1 : e.getUniqueId().compareTo(this.getUniqueId());
                }
                if (e.getUniqueId() < 0L) {
                    return 1;
                }
                int cmp = this.getProperty("order", "").compareTo(e.getProperty("order", ""));
                if (cmp != 0) {
                    return cmp;
                }
                return TableInterface.NaturalOrderComparator.compare(this.getName(), e.getName());
            }

            public String toString() {
                return this.getName();
            }
        }
    }

    public static class RoomFilterRpcRequest
    extends FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    public static class EventFilterRpcRequest
    extends FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class FilterRpcRequest
    extends EventRpcRequest<FilterRpcResponse>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Command iCommand;
        private String iText;
        private HashMap<String, Set<String>> iOptions;

        public Command getCommand() {
            return this.iCommand;
        }

        public void setCommand(Command command) {
            this.iCommand = command;
        }

        public boolean hasText() {
            return this.iText != null && !this.iText.isEmpty();
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        public Set<String> getOptions(String command) {
            return this.iOptions == null ? null : this.iOptions.get(command);
        }

        public boolean hasOption(String command) {
            Set<String> options = this.getOptions(command);
            return options != null && options.size() == 1;
        }

        public String getOption(String command) {
            Set<String> options = this.getOptions(command);
            return options == null || options.isEmpty() ? null : options.iterator().next();
        }

        public Map<String, Set<String>> getOptions() {
            return this.iOptions;
        }

        public boolean hasOptions() {
            return this.iOptions != null && !this.iOptions.isEmpty();
        }

        public boolean hasOptions(String command) {
            Set<String> options = this.getOptions(command);
            return options != null && !options.isEmpty();
        }

        public void addOption(String command, String value) {
            Set<String> options;
            if (this.iOptions == null) {
                this.iOptions = new HashMap();
            }
            if ((options = this.iOptions.get(command)) == null) {
                options = new HashSet<String>();
                this.iOptions.put(command, options);
            }
            options.add(value);
        }

        public void setOption(String command, String value) {
            Set<String> options;
            if (this.iOptions == null) {
                this.iOptions = new HashMap();
            }
            if ((options = this.iOptions.get(command)) == null) {
                options = new HashSet<String>();
                this.iOptions.put(command, options);
            } else {
                options.clear();
            }
            options.add(value);
        }

        public void setOptions(String command, Collection<String> values) {
            Set<String> options;
            if (this.iOptions == null) {
                this.iOptions = new HashMap();
            }
            if ((options = this.iOptions.get(command)) == null) {
                options = new HashSet<String>();
                this.iOptions.put(command, options);
            } else {
                options.clear();
            }
            options.addAll(values);
        }

        public boolean isEmpty() {
            if (this.hasText()) {
                return false;
            }
            if (this.hasOptions()) {
                int extra = 0;
                if (this.hasOption("user")) {
                    ++extra;
                }
                if (this.hasOption("role")) {
                    ++extra;
                }
                return this.getOptions().size() == extra;
            }
            return true;
        }

        public String toQueryString() {
            String ret = "";
            if (this.hasOptions()) {
                for (Map.Entry<String, Set<String>> option : this.getOptions().entrySet()) {
                    for (String value : option.getValue()) {
                        ret = ret + (ret.isEmpty() ? "" : " ") + option.getKey() + ":\"" + value + "\"";
                    }
                }
            }
            if (this.hasText()) {
                ret = ret + (ret.isEmpty() ? "" : " ") + this.getText();
            }
            return ret;
        }

        @Override
        public String toString() {
            return (this.getCommand() == null ? "NULL" : this.getCommand().name()) + "(" + this.getSessionId() + "," + this.iOptions + "," + this.getText() + ")";
        }

        public static enum Command implements IsSerializable
        {
            LOAD,
            SUGGESTIONS,
            ENUMERATE;

        }
    }

    public static abstract class EventRpcRequest<T extends GwtRpcResponse>
    implements GwtRpcRequest<T> {
        private Long iSessionId;

        public EventRpcRequest() {
        }

        public EventRpcRequest(Long sessionId) {
            this.setSessionId(sessionId);
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }
    }

    public static class SelectionInterface
    implements IsSerializable {
        private Set<Integer> iDays = new TreeSet<Integer>();
        private int iStartSlot;
        private int iLength;
        private Set<ResourceInterface> iLocations = new TreeSet<ResourceInterface>();

        public Set<Integer> getDays() {
            return this.iDays;
        }

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public void setStartSlot(int startSlot) {
            this.iStartSlot = startSlot;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public Set<ResourceInterface> getLocations() {
            return this.iLocations;
        }

        public void addLocation(ResourceInterface location) {
            this.iLocations.add(location);
        }

        public String toString() {
            return "Selection{days:" + this.getDays() + ", start:" + this.getStartSlot() + ", length:" + this.getLength() + ", rooms:" + this.getLocations() + "}";
        }
    }

    public static class RelatedObjectInterface
    implements IsSerializable,
    Comparable<RelatedObjectInterface> {
        private Long iUniqueId;
        private RelatedObjectType iType;
        private List<Long> iCourseIds = null;
        private List<String> iCourseNames = null;
        private List<String> iCourseTitles = null;
        private String iName;
        private String iNote;
        private String iInstruction = null;
        private Integer iInstructionType = null;
        private Integer iMaxCapacity = null;
        private List<ContactInterface> iInstructors;
        private Set<ResourceInterface> iLocations = new TreeSet<ResourceInterface>();
        private String iDate;
        private String iTime;
        private String iConflicts;
        private Integer iDayOfYear;
        private Integer iStartSlot;
        private Integer iEndSlot;
        private List<String> iExternalIds;
        private String iSectionNumber = null;
        private long[] iSelection = null;
        private String iDetailPage = null;

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public RelatedObjectType getType() {
            return this.iType;
        }

        public void setType(RelatedObjectType type) {
            this.iType = type;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasDetailPage() {
            return this.iDetailPage != null && !this.iDetailPage.isEmpty();
        }

        public String getDetailPage() {
            return this.iDetailPage;
        }

        public void setDetailPage(String page) {
            this.iDetailPage = page;
        }

        public boolean hasCourseIds() {
            return this.iCourseIds != null && !this.iCourseIds.isEmpty();
        }

        public void addCourseId(Long id) {
            if (this.iCourseIds == null) {
                this.iCourseIds = new ArrayList<Long>();
            }
            this.iCourseIds.add(id);
        }

        public List<Long> getCourseIds() {
            return this.iCourseIds;
        }

        public Long getCourseId(int index) {
            return this.iCourseIds != null && index < this.iCourseIds.size() ? this.iCourseIds.get(index) : null;
        }

        public boolean hasCourseNames() {
            return this.iCourseNames != null && !this.iCourseNames.isEmpty();
        }

        public void addCourseName(String name) {
            if (this.iCourseNames == null) {
                this.iCourseNames = new ArrayList<String>();
            }
            this.iCourseNames.add(name);
        }

        public List<String> getCourseNames() {
            return this.iCourseNames;
        }

        public boolean hasCourseTitles() {
            return this.iCourseTitles != null && !this.iCourseTitles.isEmpty();
        }

        public void addCourseTitle(String title) {
            if (this.iCourseTitles == null) {
                this.iCourseTitles = new ArrayList<String>();
            }
            this.iCourseTitles.add(title);
        }

        public List<String> getCourseTitles() {
            return this.iCourseTitles;
        }

        public boolean hasInstruction() {
            return this.iInstruction != null && !this.iInstruction.isEmpty();
        }

        public String getInstruction() {
            return this.iInstruction;
        }

        public void setInstruction(String instruction) {
            this.iInstruction = instruction;
        }

        public boolean hasInstructionType() {
            return this.iInstructionType != null;
        }

        public Integer getInstructionType() {
            return this.iInstructionType;
        }

        public void setInstructionType(Integer type) {
            this.iInstructionType = type;
        }

        public boolean hasExternalIds() {
            return this.iExternalIds != null && !this.iExternalIds.isEmpty();
        }

        public List<String> getExternalIds() {
            return this.iExternalIds;
        }

        public void addExternalId(String externalId) {
            if (this.iExternalIds == null) {
                this.iExternalIds = new ArrayList<String>();
            }
            if (!this.iExternalIds.contains(externalId)) {
                this.iExternalIds.add(externalId);
            }
        }

        public boolean hasSectionNumber() {
            return this.iSectionNumber != null && !this.iSectionNumber.isEmpty();
        }

        public String getSectionNumber() {
            return this.iSectionNumber;
        }

        public void setSectionNumber(String sectionNumber) {
            this.iSectionNumber = sectionNumber;
        }

        public Set<ResourceInterface> getLocations() {
            return this.iLocations;
        }

        public boolean hasLocations() {
            return this.iLocations != null && !this.iLocations.isEmpty();
        }

        public void addLocation(ResourceInterface location) {
            this.iLocations.add(location);
        }

        public List<ContactInterface> getInstructors() {
            return this.iInstructors;
        }

        public void addInstructor(ContactInterface instructor) {
            if (this.iInstructors == null) {
                this.iInstructors = new ArrayList<ContactInterface>();
            }
            this.iInstructors.add(instructor);
        }

        public String getInstructorNames(String separator, GwtMessages messages) {
            if (!this.hasInstructors()) {
                return "";
            }
            String ret = "";
            for (ContactInterface instructor : this.getInstructors()) {
                ret = ret + (ret.isEmpty() ? "" : separator) + instructor.getName(messages);
            }
            return ret;
        }

        public boolean hasInstructors() {
            return this.iInstructors != null && !this.iInstructors.isEmpty();
        }

        public boolean hasMaxCapacity() {
            return this.iMaxCapacity != null;
        }

        public Integer getMaxCapacity() {
            return this.iMaxCapacity;
        }

        public void setMaxCapacity(Integer maxCapacity) {
            this.iMaxCapacity = maxCapacity;
        }

        public String getTime() {
            return this.iTime;
        }

        public boolean hasTime() {
            return this.iTime != null && !this.iTime.isEmpty();
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public Integer getStartSlot() {
            return this.iStartSlot;
        }

        public boolean hasStartSlot() {
            return this.iStartSlot != null;
        }

        public void setStartSlot(Integer startSlot) {
            this.iStartSlot = startSlot;
        }

        public Integer getEndSlot() {
            return this.iEndSlot;
        }

        public boolean hasEndSlot() {
            return this.iEndSlot != null;
        }

        public void setEndSlot(Integer endSlot) {
            this.iEndSlot = endSlot;
        }

        public String getDate() {
            return this.iDate;
        }

        public boolean hasDate() {
            return this.iDate != null && !this.iDate.isEmpty();
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public Integer getDayOfYear() {
            return this.iDayOfYear;
        }

        public boolean hasDayOfYear() {
            return this.iDayOfYear != null;
        }

        public void setDayOfYear(Integer dayOfYear) {
            this.iDayOfYear = dayOfYear;
        }

        public String getConflicts() {
            return this.iConflicts;
        }

        public boolean hasConflicts() {
            return this.iConflicts != null && !this.iConflicts.isEmpty();
        }

        public void setConflicts(String conflicts) {
            this.iConflicts = conflicts;
        }

        public long[] getSelection() {
            return this.iSelection;
        }

        public boolean hasSelection() {
            return this.iSelection != null;
        }

        public void setSelection(long[] selection) {
            this.iSelection = selection;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RelatedObjectInterface)) {
                return false;
            }
            RelatedObjectInterface r = (RelatedObjectInterface)o;
            return this.getType() == r.getType() && this.getUniqueId().equals(r.getUniqueId());
        }

        public int hashCode() {
            return this.getUniqueId().hashCode();
        }

        public String toString() {
            return this.getName() + " (" + (Object)((Object)this.getType()) + ")";
        }

        @Override
        public int compareTo(RelatedObjectInterface o) {
            int cmp = this.toString().compareTo(o.toString());
            if (cmp != 0) {
                return cmp;
            }
            return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(o.getUniqueId() == null ? -1L : o.getUniqueId());
        }

        public static enum RelatedObjectType implements IsSerializable
        {
            Offering,
            Course,
            Config,
            Class,
            Examination;

        }
    }

    public static class NoteInterface
    implements IsSerializable,
    Comparable<NoteInterface> {
        private Long iId = null;
        private Date iDate;
        private String iUser;
        private NoteType iType;
        private String iMeetings;
        private String iNote;
        private String iAttachment;
        private String iLink;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Date getDate() {
            return this.iDate;
        }

        public void setDate(Date date) {
            this.iDate = date;
        }

        public String getUser() {
            return this.iUser;
        }

        public void setUser(String user) {
            this.iUser = user;
        }

        public NoteType getType() {
            return this.iType;
        }

        public void setType(NoteType type) {
            this.iType = type;
        }

        public String getMeetings() {
            return this.iMeetings;
        }

        public void setMeetings(String meetings) {
            this.iMeetings = meetings;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasAttachment() {
            return this.iAttachment != null && !this.iAttachment.isEmpty();
        }

        public String getAttachment() {
            return this.iAttachment;
        }

        public void setAttachment(String attachment) {
            this.iAttachment = attachment;
        }

        public boolean hasLink() {
            return this.iLink != null && !this.iLink.isEmpty();
        }

        public String getLink() {
            return this.iLink;
        }

        public void setLink(String link) {
            this.iLink = link;
        }

        @Override
        public int compareTo(NoteInterface note) {
            if (this.getDate() == null) {
                if (this.getDate() != null) {
                    return -1;
                }
            } else {
                if (note.getDate() == null) {
                    return 1;
                }
                if (!this.getDate().equals(note.getDate())) {
                    return this.getDate().compareTo(note.getDate());
                }
            }
            if (this.getType() == null) {
                if (note.getType() != null) {
                    return -1;
                }
            } else {
                if (note.getType() == null) {
                    return 1;
                }
                if (!this.getType().equals((Object)note.getType())) {
                    return this.getType().compareTo(note.getType());
                }
            }
            return (this.getId() == null ? new Long(-1L) : this.getId()).compareTo(note.getId() == null ? -1L : note.getId());
        }

        public static enum NoteType implements IsSerializable
        {
            Create("Create"),
            AddMeetings("Update"),
            Approve("Approve"),
            Reject("Reject"),
            Delete("Delete"),
            Edit("Edit"),
            Inquire("Inquire"),
            Cancel("Cancel"),
            Email("Email");

            private String iName;

            private NoteType(String name) {
                this.iName = name;
            }

            public String getName() {
                return this.iName;
            }

            public String toString() {
                return this.iName;
            }
        }
    }

    public static class SponsoringOrganizationInterface
    implements IsSerializable {
        private String iName;
        private String iEmail;
        private Long iUniqueId;

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasName() {
            return this.iName != null && !this.iName.isEmpty();
        }

        public String getName() {
            return this.iName;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class ContactInterface
    implements IsSerializable,
    Comparable<ContactInterface> {
        private String iFirstName;
        private String iMiddleName;
        private String iLastName;
        private String iTitle;
        private String iFormattedName;
        private String iExternalId;
        private String iEmail;
        private String iPhone;
        private String iResponsibilityAbbreviation;
        private String iResponsibility;

        public ContactInterface() {
        }

        public ContactInterface(PersonInterface person) {
            this.iFirstName = person.getFirstName();
            this.iMiddleName = person.getMiddleName();
            this.iLastName = person.getLastName();
            this.iTitle = person.getAcademicTitle();
            this.iExternalId = person.getId();
            this.iEmail = person.getEmail();
            this.iPhone = person.getPhone();
            this.iFormattedName = person.getFormattedName();
        }

        public void setFirstName(String name) {
            this.iFirstName = name;
        }

        public boolean hasFirstName() {
            return this.iFirstName != null && !this.iFirstName.isEmpty();
        }

        public String getFirstName() {
            return this.iFirstName;
        }

        public void setMiddleName(String name) {
            this.iMiddleName = name;
        }

        public boolean hasMiddleName() {
            return this.iMiddleName != null && !this.iMiddleName.isEmpty();
        }

        public String getMiddleName() {
            return this.iMiddleName;
        }

        public void setLastName(String name) {
            this.iLastName = name;
        }

        public boolean hasLastName() {
            return this.iLastName != null && !this.iLastName.isEmpty();
        }

        public String getLastName() {
            return this.iLastName;
        }

        public void setAcademicTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasAcademicTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getAcademicTitle() {
            return this.iTitle;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setPhone(String phone) {
            this.iPhone = phone;
        }

        public boolean hasPhone() {
            return this.iPhone != null && !this.iPhone.isEmpty();
        }

        public String getPhone() {
            return this.iPhone;
        }

        public void setFormattedName(String name) {
            this.iFormattedName = name;
        }

        public boolean hasFormattedName() {
            return this.iFormattedName != null && !this.iFormattedName.isEmpty();
        }

        public String getFormattedName(boolean includeResponsibility) {
            return this.iFormattedName + (includeResponsibility && this.hasResponsibilityAbbreviation() ? " (" + this.getResponsibilityAbbreviation() + ")" : "");
        }

        public void setResponsibilityAbbreviation(String responsibility) {
            this.iResponsibilityAbbreviation = responsibility;
        }

        public boolean hasResponsibilityAbbreviation() {
            return this.iResponsibilityAbbreviation != null && !this.iResponsibilityAbbreviation.isEmpty();
        }

        public String getResponsibilityAbbreviation() {
            return this.iResponsibilityAbbreviation;
        }

        public void setResponsibility(String responsibility) {
            this.iResponsibility = responsibility;
        }

        public boolean hasResponsibility() {
            return this.iResponsibility != null && !this.iResponsibility.isEmpty();
        }

        public String getResponsibility() {
            return this.iResponsibility;
        }

        public String getName(GwtMessages messages, boolean includeResponsibility) {
            if (this.hasFormattedName()) {
                return this.getFormattedName(includeResponsibility);
            }
            if (messages == null) {
                return this.toString();
            }
            return messages.formatName(this.hasFirstName() ? this.getFirstName() : "", this.hasMiddleName() ? this.getMiddleName() : "", this.hasLastName() ? this.getLastName() : "").trim();
        }

        public String getName(GwtMessages messages) {
            return this.getName(messages, true);
        }

        public String getShortName() {
            String name = "";
            if (this.hasFirstName()) {
                name = name + this.getFirstName().substring(0, 1) + " ";
            }
            if (this.hasMiddleName()) {
                name = name + this.getMiddleName().substring(0, 1) + " ";
            }
            if (this.hasLastName()) {
                name = name + this.getLastName();
            }
            return name.trim();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ContactInterface)) {
                return false;
            }
            if (this.getExternalId() != null) {
                return this.getExternalId().equals(((ContactInterface)o).getExternalId());
            }
            return this.toString().equals(((ContactInterface)o).toString());
        }

        public String toString() {
            if (this.hasFormattedName()) {
                return this.getFormattedName(true);
            }
            return (this.hasLastName() ? this.getLastName() : "") + (this.hasFirstName() || this.hasMiddleName() ? ", " + (this.hasFirstName() ? this.getFirstName() + (this.hasMiddleName() ? " " + this.getMiddleName() : "") : this.getMiddleName()) : "") + (this.hasResponsibility() ? " (" + this.getResponsibility() + ")" : "");
        }

        @Override
        public int compareTo(ContactInterface c) {
            return this.toString().compareToIgnoreCase(c.toString());
        }
    }

    public static class MultiMeetingInterface
    implements Comparable<MultiMeetingInterface>,
    IsSerializable {
        private TreeSet<MeetingInterface> iMeetings;
        private boolean iPast = false;

        public MultiMeetingInterface(TreeSet<MeetingInterface> meetings, boolean past) {
            this.iMeetings = meetings;
            this.iPast = past;
        }

        public boolean isPast() {
            return this.iPast;
        }

        public TreeSet<MeetingInterface> getMeetings() {
            return this.iMeetings;
        }

        @Override
        public int compareTo(MultiMeetingInterface m) {
            return this.getMeetings().first().compareTo(m.getMeetings().first());
        }

        public String getDays() {
            return this.getDays(0, new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}, new String[]{"M", "T", "W", "Th", "F", "S", "Su"}, "Daily");
        }

        public String getDays(int firstDayOfWeek, GwtConstants constants) {
            return this.getDays(firstDayOfWeek, constants.days(), constants.shortDays(), constants.daily());
        }

        public String getDays(int firstDayOfWeek, String[] dayNames, String[] shortDyNames, String daily) {
            if (this.isArrangeHours()) {
                return "";
            }
            int nrDays = 0;
            int dayCode = 0;
            for (MeetingInterface meeting : this.getMeetings()) {
                if (meeting.getMeetingDate() == null) continue;
                int dc = 1 << meeting.getDayOfWeek();
                if ((dayCode & dc) == 0) {
                    ++nrDays;
                }
                dayCode |= dc;
            }
            if (nrDays == 7) {
                return daily;
            }
            String ret = "";
            for (int i = 0; i < 7; ++i) {
                int d = (i + firstDayOfWeek) % 7;
                if ((dayCode & 1 << d) == 0) continue;
                ret = ret + (nrDays == 1 ? dayNames : shortDyNames)[d];
            }
            return ret;
        }

        public boolean isArrangeHours() {
            return this.iMeetings.first().isArrangeHours();
        }

        public Date getFirstMeetingDate() {
            return this.iMeetings.first().getMeetingDate();
        }

        public Date getLastMeetingDate() {
            return this.iMeetings.last().getMeetingDate();
        }

        public String getMeetingTime(GwtConstants constants) {
            return this.iMeetings.first().getMeetingTime(constants);
        }

        public String getAllocatedTime(GwtConstants constants) {
            return this.iMeetings.first().getAllocatedTime(constants);
        }

        public int getNrMeetings() {
            return this.iMeetings.size();
        }

        public String getLocationName() {
            return this.iMeetings.first().getLocationName();
        }

        public String getLocationName(GwtMessages msg) {
            return this.iMeetings.first().getLocationName(msg);
        }

        public String getLocationNameWithHint(GwtMessages msg) {
            return this.iMeetings.first().getLocationNameWithHint(msg);
        }

        public String getLocationCapacity() {
            return this.iMeetings.first().getLocation() == null ? "" : (this.iMeetings.first().getLocation().getSize() == null ? "" : this.iMeetings.first().getLocation().getSize().toString());
        }

        public String getLocationMessage() {
            ResourceInterface location = this.iMeetings.first().getLocation();
            return location == null || !location.hasMessage() ? null : location.getMessage();
        }

        public boolean hasLocation() {
            return this.iMeetings.first().hasLocation();
        }

        public ResourceInterface getLocation() {
            return this.iMeetings.first().getLocation();
        }

        public Date getApprovalDate() {
            Date date = null;
            for (MeetingInterface m : this.iMeetings) {
                if (m.getApprovalDate() == null || date != null && !date.after(m.getApprovalDate())) continue;
                date = m.getApprovalDate();
            }
            return date;
        }

        public ApprovalStatus getApprovalStatus() {
            return this.iMeetings.first().getApprovalStatus();
        }

        public boolean hasMeetingContacts() {
            return this.iMeetings.first().hasMeetingContacts();
        }

        public Set<ContactInterface> getMeetingContacts() {
            return this.iMeetings.first().getMeetingContacts();
        }

        public String getMeetingContacts(String separator, GwtMessages msg) {
            return this.iMeetings.first().getMeetingContacts(separator, msg);
        }

        public String getStyle() {
            return this.iMeetings.first().getStyle();
        }

        public boolean hasStyle() {
            return this.iMeetings.first().hasStyle();
        }
    }

    public static class MeetingConflictInterface
    extends MeetingInterface {
        private Long iEventId;
        private String iEventName;
        private EventType iEventType;
        private Integer iLimit;
        private Integer iEnrollment;
        private SponsoringOrganizationInterface iSponsor;
        private List<ContactInterface> iInstructors;

        public MeetingConflictInterface() {
        }

        public MeetingConflictInterface(MeetingInterface m) {
            super(m);
        }

        public Long getEventId() {
            return this.iEventId;
        }

        public void setEventId(Long id) {
            this.iEventId = id;
        }

        public String getName() {
            return this.iEventName;
        }

        public void setName(String name) {
            this.iEventName = name;
        }

        public EventType getType() {
            return this.iEventType;
        }

        public void setType(EventType type) {
            this.iEventType = type;
        }

        public boolean hasLimit() {
            return this.iLimit != null;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public boolean hasEnrollment() {
            return this.iEnrollment != null;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }

        public SponsoringOrganizationInterface getSponsor() {
            return this.iSponsor;
        }

        public void setSponsor(SponsoringOrganizationInterface sponsor) {
            this.iSponsor = sponsor;
        }

        public boolean hasSponsor() {
            return this.iSponsor != null;
        }

        public List<ContactInterface> getInstructors() {
            return this.iInstructors;
        }

        public void addInstructor(ContactInterface instructor) {
            if (this.iInstructors == null) {
                this.iInstructors = new ArrayList<ContactInterface>();
            }
            this.iInstructors.add(instructor);
        }

        public String getInstructorNames(String separator, GwtMessages messages) {
            if (!this.hasInstructors()) {
                return "";
            }
            String ret = "";
            for (ContactInterface instructor : this.getInstructors()) {
                ret = ret + (ret.isEmpty() ? "" : separator) + instructor.getName(messages);
            }
            return ret;
        }

        public String getInstructorEmails(String separator) {
            if (!this.hasInstructors()) {
                return "";
            }
            String ret = "";
            for (ContactInterface instructor : this.getInstructors()) {
                ret = ret + (ret.isEmpty() ? "" : separator) + (instructor.getEmail() == null ? "" : instructor.getEmail());
            }
            return ret;
        }

        public boolean hasInstructors() {
            return this.iInstructors != null && !this.iInstructors.isEmpty();
        }

        @Override
        public int compareTo(MeetingInterface conflict) {
            int cmp = this.getType().compareTo(((MeetingConflictInterface)conflict).getType());
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.getDayOfYear()).compareTo(conflict.getDayOfYear());
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.getStartSlot()).compareTo(conflict.getStartSlot());
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.getEndSlot()).compareTo(conflict.getEndSlot());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(((MeetingConflictInterface)conflict).getName());
            if (cmp != 0) {
                return cmp;
            }
            return (this.getId() == null ? new Long(-1L) : this.getId()).compareTo(conflict.getId() == null ? new Long(-1L) : conflict.getId());
        }

        @Override
        public String toString() {
            return this.getName() + " " + super.toString();
        }
    }

    public static class MeetingInterface
    implements Comparable<MeetingInterface>,
    IsSerializable {
        private ResourceInterface iLocation;
        private Long iMeetingId;
        private Date iMeetingDate;
        private int iStartSlot;
        private int iEndSlot;
        private int iStartOffset = 0;
        private int iEndOffset = 0;
        private int iDayOfWeek;
        private int iDayOfYear;
        private boolean iPast = false;
        private boolean iCanEdit = false;
        private boolean iCanDelete = false;
        private boolean iCanCancel = false;
        private boolean iCanApprove = false;
        private boolean iCanInquire = false;
        private boolean iAutomaticApproval = false;
        private Integer iGridIndex = null;
        private Date iApprovalDate = null;
        private ApprovalStatus iApprovalStatus = ApprovalStatus.Pending;
        private Long iStartTime;
        private Long iStopTime;
        private Set<MeetingConflictInterface> iConflicts;
        private Set<ContactInterface> iMeetingContacts;
        private String iStyle = null;

        public MeetingInterface() {
        }

        public MeetingInterface(MeetingInterface m) {
            this.setLocation(m.getLocation());
            this.setMeetingDate(m.getMeetingDate());
            this.setId(m.getId());
            this.setStartSlot(m.getStartSlot());
            this.setEndSlot(m.getEndSlot());
            this.setStartOffset(m.getStartOffset());
            this.setEndOffset(m.getEndOffset());
            this.setDayOfWeek(m.getDayOfWeek());
            this.setDayOfYear(m.getDayOfYear());
            this.setPast(m.isPast());
            this.setCanEdit(m.isCanEdit());
            this.setCanDelete(m.isCanDelete());
            this.setCanCancel(m.isCanCancel());
            this.setCanApprove(m.isCanApprove());
            this.setCanInquire(m.isCanInquire());
            this.setGridIndex(m.getGridIndex());
            this.setApprovalDate(m.getApprovalDate());
            this.setApprovalStatus(m.getApprovalStatus());
            this.setStartTime(m.getStartTime());
            this.setStopTime(m.getStopTime());
            this.setConflicts(m.getConflicts());
        }

        public Long getId() {
            return this.iMeetingId;
        }

        public void setId(Long id) {
            this.iMeetingId = id;
        }

        public Date getMeetingDate() {
            return this.iMeetingDate;
        }

        public void setMeetingDate(Date date) {
            this.iMeetingDate = date;
        }

        public int getStartSlot() {
            return this.iStartSlot;
        }

        public void setStartSlot(int slot) {
            this.iStartSlot = slot;
        }

        public int getEndSlot() {
            return this.iEndSlot;
        }

        public void setEndSlot(int slot) {
            this.iEndSlot = slot;
        }

        public int getStartOffset() {
            return this.iStartOffset;
        }

        public void setStartOffset(int offset) {
            this.iStartOffset = offset;
        }

        public int getEndOffset() {
            return this.iEndOffset;
        }

        public void setEndOffset(int offset) {
            this.iEndOffset = offset;
        }

        public int getDayOfWeek() {
            return this.iDayOfWeek;
        }

        public void setDayOfWeek(int dayOfWeek) {
            this.iDayOfWeek = dayOfWeek;
        }

        public int getGridIndex() {
            return this.iGridIndex == null ? this.iDayOfWeek : this.iGridIndex;
        }

        public void setGridIndex(Integer index) {
            this.iGridIndex = index;
        }

        public boolean hasGridIndex() {
            return this.iGridIndex != null;
        }

        public int getDayOfYear() {
            return this.iDayOfYear;
        }

        public void setDayOfYear(int dayOfYear) {
            this.iDayOfYear = dayOfYear;
        }

        public String getStartTime(GwtConstants constants, boolean useOffsets) {
            int min = 5 * this.iStartSlot + (useOffsets ? this.iStartOffset : 0);
            int h = min / 60;
            if (h > 24) {
                h -= 24;
            }
            int m = min % 60;
            if (constants != null && min == 0) {
                return constants.timeMidnight();
            }
            if (constants != null && min == 720) {
                return constants.timeNoon();
            }
            if (constants == null || constants.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getEndTime(GwtConstants constants, boolean useOffsets) {
            int min = 5 * this.iEndSlot + (useOffsets ? this.iEndOffset : 0);
            int h = min / 60;
            if (h > 24) {
                h -= 24;
            }
            int m = min % 60;
            if (constants != null && min == 720) {
                return constants.timeNoon();
            }
            if (constants != null && min == 1440) {
                return constants.timeMidnightEnd();
            }
            if (constants == null || constants.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getMeetingTime(GwtConstants constants) {
            if (this.isArrangeHours()) {
                return "";
            }
            if (constants != null && this.iStartSlot == 0 && this.iStartOffset == 0 && this.iEndSlot == 288 && this.iEndOffset == 0) {
                return constants.timeAllDay();
            }
            return this.getStartTime(constants, true) + " - " + this.getEndTime(constants, true);
        }

        public String getAllocatedTime(GwtConstants constants) {
            if (this.isArrangeHours()) {
                return "";
            }
            if (constants != null && this.iStartSlot == 0 && this.iEndSlot == 288) {
                return constants.timeAllDay();
            }
            return this.getStartTime(constants, false) + " - " + this.getEndTime(constants, false);
        }

        public ResourceInterface getLocation() {
            return this.iLocation;
        }

        public boolean hasLocation() {
            return this.iLocation != null;
        }

        public String getLocationName() {
            return this.iLocation == null ? "" : this.iLocation.getName();
        }

        public String getLocationName(GwtMessages msg) {
            return this.iLocation == null ? "" : this.iLocation.getNameWithDisplayName(msg);
        }

        public String getLocationNameWithHint(GwtMessages msg) {
            return this.iLocation == null ? "" : this.iLocation.getNameWithHint(msg);
        }

        public String getLocationCapacity() {
            return this.iLocation == null ? "" : (this.iLocation.getSize() == null ? "" : this.iLocation.getSize().toString());
        }

        public void setLocation(ResourceInterface resource) {
            this.iLocation = resource;
        }

        public boolean isPast() {
            return this.iPast;
        }

        public void setPast(boolean past) {
            this.iPast = past;
        }

        public boolean isCanEdit() {
            return this.iCanEdit;
        }

        public void setCanEdit(boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean isCanDelete() {
            return this.iCanDelete || this.iMeetingId == null;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isCanCancel() {
            return this.iCanCancel;
        }

        public void setCanCancel(boolean canCancel) {
            this.iCanCancel = canCancel;
        }

        public boolean isCanApprove() {
            return this.iCanApprove;
        }

        public void setCanApprove(boolean canApprove) {
            this.iCanApprove = canApprove;
        }

        public boolean isAutomaticallyApproved() {
            return this.iAutomaticApproval;
        }

        public void setAutomaticallyApproved(boolean automaticApproval) {
            this.iAutomaticApproval = automaticApproval;
        }

        public boolean isApproved() {
            return this.iApprovalStatus == ApprovalStatus.Approved;
        }

        public boolean isCanInquire() {
            return this.iCanInquire;
        }

        public void setCanInquire(boolean canInquire) {
            this.iCanInquire = canInquire;
        }

        public ApprovalStatus getApprovalStatus() {
            return this.iApprovalStatus == null ? ApprovalStatus.Pending : this.iApprovalStatus;
        }

        public void setApprovalStatus(ApprovalStatus status) {
            this.iApprovalStatus = status;
        }

        public void setApprovalStatus(Integer status) {
            this.iApprovalStatus = status == null ? ApprovalStatus.Pending : ApprovalStatus.values()[status];
        }

        public Date getApprovalDate() {
            return this.iApprovalDate;
        }

        public void setApprovalDate(Date date) {
            this.iApprovalDate = date;
        }

        public boolean isArrangeHours() {
            return this.iMeetingDate == null;
        }

        public boolean isAllDay() {
            return this.iStartSlot == 0 && this.iEndSlot == 288;
        }

        public Long getStopTime() {
            return this.iStopTime;
        }

        public void setStopTime(Long stopTime) {
            this.iStopTime = stopTime;
        }

        public Long getStartTime() {
            return this.iStartTime;
        }

        public void setStartTime(Long startTime) {
            this.iStartTime = startTime;
        }

        public String getStyle() {
            return this.iStyle == null ? "" : this.iStyle;
        }

        public boolean hasStyle() {
            return this.iStyle != null && !this.iStyle.isEmpty();
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public boolean hasConflicts() {
            return this.iConflicts != null && !this.iConflicts.isEmpty();
        }

        public boolean inConflict() {
            if (this.iConflicts == null) {
                return false;
            }
            for (MeetingConflictInterface conflict : this.iConflicts) {
                if (conflict.getType() == EventType.Message) continue;
                return true;
            }
            return false;
        }

        public void addConflict(MeetingConflictInterface conflict) {
            if (this.iConflicts == null) {
                this.iConflicts = new TreeSet<MeetingConflictInterface>();
            }
            this.iConflicts.add(conflict);
        }

        public Set<MeetingConflictInterface> getConflicts() {
            return this.iConflicts;
        }

        public void setConflicts(Set<MeetingConflictInterface> conflicts) {
            this.iConflicts = conflicts;
        }

        public boolean hasMeetingContacts() {
            return this.iMeetingContacts != null && !this.iMeetingContacts.isEmpty();
        }

        public void addMeetingContact(ContactInterface contact) {
            if (this.iMeetingContacts == null) {
                this.iMeetingContacts = new TreeSet<ContactInterface>();
            }
            this.iMeetingContacts.add(contact);
        }

        public Set<ContactInterface> getMeetingContacts() {
            return this.iMeetingContacts;
        }

        public void setMeetingContacts(Set<ContactInterface> contacts) {
            this.iMeetingContacts = contacts;
        }

        public boolean sameMeetingContacts(MeetingInterface m) {
            if (this.hasMeetingContacts()) {
                if (m.hasMeetingContacts()) {
                    Iterator<ContactInterface> i1 = this.getMeetingContacts().iterator();
                    Iterator<ContactInterface> i2 = m.getMeetingContacts().iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        ContactInterface c2;
                        ContactInterface c1 = i1.next();
                        if (c1.equals(c2 = i2.next())) continue;
                        return false;
                    }
                    return !i1.hasNext() && !i2.hasNext();
                }
                return false;
            }
            return !m.hasMeetingContacts();
        }

        public String getMeetingContacts(String separator, GwtMessages msg) {
            if (!this.hasMeetingContacts()) {
                return "";
            }
            String ret = "";
            for (ContactInterface c : this.getMeetingContacts()) {
                ret = ret + (ret.isEmpty() ? "" : separator) + c.getName(msg);
            }
            return ret;
        }

        @Override
        public int compareTo(MeetingInterface meeting) {
            int cmp = new Integer(this.getDayOfYear()).compareTo(meeting.getDayOfYear());
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.getStartSlot()).compareTo(meeting.getStartSlot());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getLocationName().compareTo(meeting.getLocationName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId() == null ? (meeting.getId() == null ? 0 : -1) : (meeting.getId() == null ? 1 : this.getId().compareTo(meeting.getId()));
        }

        public int hashCode() {
            return this.getId() == null ? this.toString().hashCode() : this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MeetingInterface)) {
                return false;
            }
            MeetingInterface m = (MeetingInterface)o;
            if (this.getId() != null && m.getId() != null) {
                return this.getId().equals(m.getId());
            }
            return this.getDayOfYear() == m.getDayOfYear() && EventInterface.equals(this.getLocation(), m.getLocation()) && this.getStartSlot() == m.getStartSlot() && this.getEndSlot() == m.getEndSlot();
        }

        public String toString() {
            return (this.getMeetingDate() == null ? "" : 1 + this.getMeetingDate().getMonth() + "/" + this.getMeetingDate().getDate() + " ") + this.getAllocatedTime(null) + (this.getLocation() == null ? "" : " " + this.getLocationName());
        }

        public boolean inConflict(MeetingInterface meeting) {
            return this.getDayOfYear() == meeting.getDayOfYear() && this.getStartSlot() < meeting.getEndSlot() && meeting.getStartSlot() < this.getEndSlot() && this.getLocation() != null && this.getLocation().equals(meeting.getLocation()) && !this.getLocation().isIgnoreRoomCheck();
        }

        public boolean overlapsWith(MeetingInterface meeting) {
            return this.getDayOfYear() == meeting.getDayOfYear() && this.getStartSlot() < meeting.getEndSlot() && meeting.getStartSlot() < this.getEndSlot();
        }
    }

    public static class WeekInterface
    implements IsSerializable {
        private int iDayOfYear;
        private List<DateInterface> iDayNames = new ArrayList<DateInterface>();

        public int getDayOfYear() {
            return this.iDayOfYear;
        }

        public void setDayOfYear(int dayOfYear) {
            this.iDayOfYear = dayOfYear;
        }

        public int getLastDayOfYear() {
            if (this.iDayNames.isEmpty()) {
                return this.getDayOfYear() + 6;
            }
            return Math.max(this.getDayOfYear() + 6, this.iDayNames.get(this.iDayNames.size() - 1).getDay());
        }

        public void addDayName(DateInterface name) {
            this.iDayNames.add(name);
        }

        public List<DateInterface> getDayNames() {
            return this.iDayNames;
        }

        public String getName() {
            return this.getDayNames().get(0) + " - " + this.getDayNames().get(this.getDayNames().size() - 1);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof WeekInterface)) {
                return false;
            }
            return this.getDayOfYear() == ((WeekInterface)o).getDayOfYear();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class DateInterface
    implements IsSerializable {
        String iLabel;
        int iMonth;
        int iDay;

        public DateInterface() {
        }

        public DateInterface(String label, int month, int day) {
            this.iLabel = label;
            this.iMonth = month;
            this.iDay = day;
        }

        public int getMonth() {
            return this.iMonth;
        }

        public void setMonth(int month) {
            this.iMonth = month;
        }

        public int getDay() {
            return this.iDay;
        }

        public void setDay(int day) {
            this.iDay = day;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String toString() {
            return this.getLabel();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return this.getLabel().equals((String)o);
            }
            if (o instanceof DateInterface) {
                DateInterface d = (DateInterface)o;
                return this.getMonth() == d.getMonth() && this.getDay() == d.getDay();
            }
            return false;
        }
    }

    public static class ResourceInterface
    implements IsSerializable,
    Comparable<ResourceInterface> {
        private ResourceType iResourceType;
        private Long iResourceId;
        private String iExternalId;
        private String iAbbreviation;
        private String iResourceName;
        private String iTitle;
        private Integer iSize = null;
        private Double iDistance = null;
        private String iRoomType = null;
        private int iBreakTime = 0;
        private String iMessage = null;
        private boolean iIgnoreRoomCheck = false;
        private String iDisplayName = null;
        private boolean iShowMessageInGrid = false;

        public ResourceInterface() {
        }

        public ResourceInterface(FilterRpcResponse.Entity room) {
            this.setType(ResourceType.ROOM);
            this.setId(room.getUniqueId());
            this.setAbbreviation(room.getAbbreviation());
            this.setName(room.getName());
            String capacity = room.getProperty("capacity", null);
            this.setSize(capacity == null ? null : Integer.valueOf(capacity));
            String distance = room.getProperty("distance", null);
            this.setDistance(distance == null ? null : Double.valueOf(distance));
            this.setRoomType(room.getProperty("type", null));
            this.setBreakTime(Integer.parseInt(room.getProperty("breakTime", "0")));
            this.setMessage(room.getProperty("message", null));
            this.setIgnoreRoomCheck("1".equals(room.getProperty("ignoreRoomCheck", "0")));
            this.setDisplayName(room.getProperty("display", null));
            this.setShowMessageInGrid("1".equals(room.getProperty("gridNote", "0")));
        }

        public ResourceType getType() {
            return this.iResourceType;
        }

        public void setType(ResourceType type) {
            this.iResourceType = type;
        }

        public Long getId() {
            return this.iResourceId;
        }

        public void setId(Long id) {
            this.iResourceId = id;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String id) {
            this.iExternalId = id;
        }

        public boolean hasAbbreviation() {
            return this.iAbbreviation != null && !this.iAbbreviation.isEmpty();
        }

        public String getAbbreviation() {
            return this.iAbbreviation;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbreviation = abbv;
        }

        public String getName() {
            return this.iResourceName;
        }

        public void setName(String name) {
            this.iResourceName = name;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public void setSize(Integer size) {
            this.iSize = size;
        }

        public boolean hasSize() {
            return this.iSize != null;
        }

        public Integer getSize() {
            return this.iSize;
        }

        public void setDistance(Double distance) {
            this.iDistance = distance;
        }

        public boolean hasDistance() {
            return this.iDistance != null && Math.round(this.iDistance) > 0L;
        }

        public Double getDistance() {
            return this.iDistance;
        }

        public void setRoomType(String type) {
            this.iRoomType = type;
        }

        public boolean hasRoomType() {
            return this.iRoomType != null;
        }

        public String getRoomType() {
            return this.iRoomType;
        }

        public int getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(int breakTime) {
            this.iBreakTime = breakTime;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public boolean isIgnoreRoomCheck() {
            return this.iIgnoreRoomCheck;
        }

        public void setIgnoreRoomCheck(boolean ignoreRoomCheck) {
            this.iIgnoreRoomCheck = ignoreRoomCheck;
        }

        public boolean hasDisplayName() {
            return this.iDisplayName != null && !this.iDisplayName.isEmpty();
        }

        public String getDisplayName() {
            return this.iDisplayName;
        }

        public void setDisplayName(String name) {
            this.iDisplayName = name;
        }

        public boolean isShowMessageInGrid() {
            return this.iShowMessageInGrid;
        }

        public void setShowMessageInGrid(boolean showMessageInGrid) {
            this.iShowMessageInGrid = showMessageInGrid;
        }

        public String getNameWithHint(GwtMessages msg) {
            if (this.iResourceName == null || this.iResourceName.isEmpty()) {
                return "";
            }
            return "<span onmouseover=\"showGwtRoomHint(this, '" + this.iResourceId + "', '', '" + (this.iDistance != null ? Long.valueOf(Math.round(this.iDistance)) : "") + "');\" " + (this.isIgnoreRoomCheck() ? "class='unitime-IgnoreRoomCheck' " : "") + "onmouseout=\"hideGwtRoomHint();\">" + this.getNameWithDisplayName(msg) + "</span>";
        }

        public String getNameWithSizeAndHint(GwtMessages msg) {
            if (this.iResourceName == null || this.iResourceName.isEmpty()) {
                return "";
            }
            return "<span onmouseover=\"showGwtRoomHint(this, '" + this.iResourceId + "', '', '" + (this.iDistance != null ? Long.valueOf(Math.round(this.iDistance)) : "") + "');\" " + (this.isIgnoreRoomCheck() ? "class='unitime-IgnoreRoomCheck' " : "") + "onmouseout=\"hideGwtRoomHint();\">" + this.getNameWithSize(msg) + "</span>";
        }

        public String getNameWithDisplayName(GwtMessages msg) {
            if (!this.hasDisplayName()) {
                return this.getName();
            }
            return msg == null ? this.getName() + " (" + this.getDisplayName() + ")" : msg.roomLabelWithDisplayName(this.getName(), this.getDisplayName());
        }

        public String getNameWithSize(GwtMessages msg) {
            if (this.hasDisplayName()) {
                if (this.hasSize() && this.getSize() > 0) {
                    return msg == null ? this.getName() + " (" + this.getDisplayName() + ", " + this.getSize() + ")" : msg.roomLabelWithDisplayNameAndSize(this.getName(), this.getDisplayName(), this.getSize());
                }
                return msg == null ? this.getName() + " (" + this.getDisplayName() + ")" : msg.roomLabelWithDisplayName(this.getName(), this.getDisplayName());
            }
            if (this.hasSize() && this.getSize() > 0) {
                return msg == null ? this.getName() + " (" + this.getSize() + ")" : msg.roomLabelWithSize(this.getName(), this.getSize());
            }
            return this.getName();
        }

        public String toString() {
            return this.getType().getLabel() + " " + this.getName();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ResourceInterface)) {
                return false;
            }
            return ((ResourceInterface)o).getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(ResourceInterface r) {
            int cmp;
            if (this.hasAbbreviation() && r.hasAbbreviation() && (cmp = this.getAbbreviation().compareTo(r.getAbbreviation())) != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(r.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(r.getId());
        }
    }

    public static class IdValueInterface
    implements IsSerializable {
        private String iId;
        private String iValue;
        private boolean iSelected = false;

        public IdValueInterface() {
        }

        public IdValueInterface(String id, String value) {
            this.iId = id;
            this.iValue = value;
        }

        public String getId() {
            return this.iId;
        }

        public void setId(String id) {
            this.iId = id;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public boolean isSelected() {
            return this.iSelected;
        }

        public void setSelected(boolean selected) {
            this.iSelected = selected;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static enum ApprovalStatus implements IsSerializable
    {
        Pending,
        Approved,
        Rejected,
        Cancelled,
        Deleted;


        public String getName(GwtConstants constants) {
            return constants.eventApprovalStatus()[this.ordinal()];
        }

        public int getType() {
            return this.ordinal();
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum EventType implements IsSerializable
    {
        Class,
        FinalExam,
        MidtermExam,
        Course,
        Special,
        Unavailabile,
        Message;


        public String getAbbreviation(GwtConstants constants) {
            return constants.eventTypeAbbv()[this.ordinal()];
        }

        public String getName(GwtConstants constants) {
            return constants.eventTypeName()[this.ordinal()];
        }

        public int getType() {
            return this.ordinal();
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum ResourceType implements IsSerializable
    {
        ROOM("Room Timetable", "room", true),
        SUBJECT("Subject Timetable", "subject", true),
        CURRICULUM("Curriculum Timetable", "curriculum", true),
        DEPARTMENT("Departmental Timetable", "department", true),
        PERSON("Personal Timetable", "person", true),
        COURSE("Course Timetable", "course", false),
        GROUP("Student Group Timetable", "group", true);

        private String iPage;
        private String iLabel;
        private boolean iVisible;

        private ResourceType(String page, String label, boolean visible) {
            this.iPage = page;
            this.iLabel = label;
            this.iVisible = visible;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public String getPageName() {
            return this.iPage;
        }

        public String getResourceType(GwtConstants constants) {
            return constants.resourceType()[this.ordinal()];
        }

        public String getName(GwtConstants constants) {
            return constants.resourceName()[this.ordinal()];
        }

        public boolean isVisible() {
            return this.iVisible;
        }
    }
}

