/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.sectioning.DegreePlanDialog;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;

public class DegreePlanTable
extends UniTimeTable<Object>
implements TakesValue<DegreePlanInterface> {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private DegreePlanInterface iPlan;
    private TakesValue<CourseRequestInterface> iRequests;
    private DegreePlanDialog.AssignmentProvider iAssignments;

    public DegreePlanTable(StudentSectioningPage.Mode mode, TakesValue<CourseRequestInterface> requests, DegreePlanDialog.AssignmentProvider assignments) {
        this.iRequests = requests;
        this.iAssignments = assignments;
        this.addStyleName("unitine-DegreePlanTable");
        this.setAllowSelection(true);
        this.setAllowMultiSelect(false);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hIndent = new UniTimeTableHeader("");
        header.add(hIndent);
        UniTimeTableHeader hName = new UniTimeTableHeader(MESSAGES.colDegreeItemName(), 2);
        header.add(hName);
        UniTimeTableHeader hTitle = new UniTimeTableHeader(MESSAGES.colDegreeItemDescription());
        header.add(hTitle);
        UniTimeTableHeader hLimit = new UniTimeTableHeader(MESSAGES.colLimit());
        header.add(hLimit);
        UniTimeTableHeader hCredit = new UniTimeTableHeader(MESSAGES.colCredit());
        header.add(hCredit);
        UniTimeTableHeader hNote = new UniTimeTableHeader(MESSAGES.colNote());
        header.add(hNote);
        UniTimeTableHeader hReq = new UniTimeTableHeader(MESSAGES.colRequestPriority(), 3);
        header.add(hReq);
        this.addRow(null, header);
    }

    public DegreePlanInterface getValue() {
        return this.iPlan;
    }

    public void setValue(DegreePlanInterface plan) {
        this.iPlan = plan;
        this.clearTable(1);
        if (plan.getGroup() != null) {
            this.fixSelection((CourseRequestInterface)this.iRequests.getValue(), plan.getGroup(), null);
            this.addGroup(1, plan.getGroup().getMaxDepth(), (CourseRequestInterface)this.iRequests.getValue(), plan.getGroup(), null);
        }
        this.updateBackground();
        this.refreshSelection();
    }

    private int toScore(CourseRequestInterface requests, CourseRequestInterface.RequestPriority priority) {
        if (priority == null) {
            return 0;
        }
        int size = requests.getCourses().size() + requests.getAlternatives().size();
        int index = priority.getPriority() - 1 + (priority.isAlternative() ? requests.getCourses().size() : 0);
        return 3 * (size + index) - priority.getChoice();
    }

    protected int getSelectionScore(CourseRequestInterface requests, DegreePlanInterface.DegreeCourseInterface course, ClassAssignmentInterface.CourseAssignment assignment) {
        int ret = 0;
        if (course.isSelected()) {
            ++ret;
        }
        if (assignment != null) {
            CourseRequestInterface.RequestPriority priority = requests.getRequestPriority(assignment);
            ret += this.toScore(requests, priority);
            if (this.isSaved(assignment)) {
                if (this.isLast(assignment)) {
                    ret += 1000;
                }
            } else if (this.isLast(assignment)) {
                ret += 100;
            }
        } else {
            CourseRequestInterface.RequestPriority priority = requests.getRequestPriority(course);
            ret += this.toScore(requests, priority);
        }
        return ret;
    }

    protected int getSelectionScore(CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface unionGroup) {
        int ret = 0;
        if (unionGroup.isSelected()) {
            ++ret;
        }
        if (unionGroup.hasCourses()) {
            int sum = 0;
            for (DegreePlanInterface.DegreeCourseInterface course : unionGroup.getCourses()) {
                if (course.hasCourses()) {
                    double max = 0.0;
                    for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                        max = Math.max(max, (double)this.getSelectionScore(requests, course, ca));
                    }
                    sum = (int)((double)sum + max);
                    continue;
                }
                sum += this.getSelectionScore(requests, course, null);
            }
            ret = (int)((long)ret + Math.round(1.0 / (double)unionGroup.getCourses().size() * (double)sum));
        }
        return ret;
    }

    protected void fixSelection(CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface group, DegreePlanInterface.DegreeGroupInterface parent) {
        ClassAssignmentInterface.CourseAssignment bestCA;
        if (group.isChoice()) {
            int bestSelection = 0;
            DegreePlanInterface.DegreeGroupInterface bestGroup = null;
            DegreePlanInterface.DegreeCourseInterface bestCourse = null;
            bestCA = null;
            if (group.hasCourses()) {
                for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                    if (course.hasCourses()) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            int selection = this.getSelectionScore(requests, course, ca);
                            if (selection <= bestSelection) continue;
                            bestSelection = selection;
                            bestGroup = null;
                            bestCourse = course;
                            bestCA = ca;
                        }
                    } else {
                        int selection = this.getSelectionScore(requests, course, null);
                        if (selection > bestSelection) {
                            bestSelection = selection;
                            bestGroup = null;
                            bestCourse = course;
                            bestCA = null;
                        }
                    }
                    course.setCourseId(null);
                    course.setSelected(false);
                }
            }
            if (group.hasGroups()) {
                for (DegreePlanInterface.DegreeGroupInterface ug : group.getGroups()) {
                    int selection = this.getSelectionScore(requests, ug);
                    if (selection <= bestSelection) continue;
                    bestSelection = selection;
                    bestGroup = ug;
                    bestCourse = null;
                    bestCA = null;
                }
            }
            if (bestGroup != null) {
                bestGroup.setSelected(true);
            } else if (bestCourse != null) {
                bestCourse.setSelected(true);
                bestCourse.setCourseId(bestCA == null ? null : bestCA.getCourseId());
            }
        } else if (parent != null && parent.isChoice()) {
            if (group.hasCourses()) {
                for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                    if (parent.isSelected()) {
                        int bestSelection = 0;
                        bestCA = null;
                        if (course.hasCourses()) {
                            for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                                int selection = this.getSelectionScore(requests, course, ca);
                                if (selection <= bestSelection) continue;
                                bestSelection = selection;
                                bestCA = ca;
                            }
                        }
                        course.setSelected(true);
                        course.setCourseId(bestCA == null ? null : bestCA.getCourseId());
                        continue;
                    }
                    course.setSelected(false);
                    course.setCourseId(null);
                }
            }
        } else if (group.hasCourses()) {
            for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                int bestSelection = -1;
                bestCA = null;
                if (course.hasCourses()) {
                    for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                        int selection = this.getSelectionScore(requests, course, ca);
                        if (selection <= bestSelection) continue;
                        bestSelection = selection;
                        bestCA = ca;
                    }
                }
                course.setSelected(true);
                course.setCourseId(bestCA == null ? null : bestCA.getCourseId());
            }
        }
        if (group.hasGroups()) {
            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                this.fixSelection(requests, g, group);
            }
        }
    }

    protected void addCourse(int depth, int maxDepth, CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface group, DegreePlanInterface.DegreeCourseInterface course) {
        int d;
        P indent;
        ArrayList<Object> row;
        if (!course.hasCourses()) {
            row = new ArrayList<Object>();
            indent = new P("indent");
            for (d = 1; d < depth; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
            }
            for (d = depth + 1; d <= maxDepth; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentBlankSpace()));
            }
            row.add((Object)indent);
            if (group.isChoice()) {
                row.add(new ChoiceButton(group, course));
                row.add(new CourseLabel(MESSAGES.course(course.getSubject(), course.getCourse()), true));
            } else {
                row.add(new CourseLabel(MESSAGES.course(course.getSubject(), course.getCourse()), false));
            }
            row.add((Object)new TitleLabel(course.getTitle() == null ? "" : course.getTitle()));
            row.add(new CourseNotOfferedLabel(MESSAGES.plannedCourseNotOffered(MESSAGES.course(course.getSubject(), course.getCourse()))));
            row.add(new Label());
            this.addRow(course, row);
        } else if (course.getCourses().size() > 1 && !group.isChoice()) {
            row = new ArrayList();
            indent = new P("indent");
            for (d = 1; d < depth; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
            }
            indent.add((Widget)new Image(RESOURCES.indentTopLine()));
            for (d = depth + 2; d <= maxDepth; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentTopSpace()));
            }
            row.add((Object)indent);
            if (group.isChoice() && !course.hasCourses()) {
                row.add(new ChoiceButton(group, course));
                row.add(new GroupTitleCell(course.hasTitle() ? MESSAGES.courseNameWithTitle(course.getSubject(), course.getCourse(), course.getTitle()) : MESSAGES.course(course.getSubject(), course.getCourse()), true));
            } else {
                row.add(new GroupTitleCell(course.hasTitle() ? MESSAGES.courseNameWithTitle(course.getSubject(), course.getCourse(), course.getTitle()) : MESSAGES.course(course.getSubject(), course.getCourse()), false));
            }
            if (course.isCritical()) {
                row.add((Object)new CriticalCell(course));
            } else {
                row.add(new Label());
            }
            this.addRow(course, row);
        }
        if (course.hasCourses()) {
            Iterator<ClassAssignmentInterface.CourseAssignment> i = course.getCourses().iterator();
            while (i.hasNext()) {
                int d2;
                ClassAssignmentInterface.CourseAssignment ca = i.next();
                ArrayList<Object> row2 = new ArrayList<Object>();
                P indent2 = new P("indent");
                for (d2 = 1; d2 < depth; ++d2) {
                    indent2.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                }
                if (course.getCourses().size() == 1 || group.isChoice()) {
                    indent2.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                } else if (i.hasNext()) {
                    indent2.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                } else {
                    indent2.add((Widget)new Image(RESOURCES.indentLastLine()));
                }
                for (d2 = depth + 2; d2 <= maxDepth; ++d2) {
                    indent2.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                }
                row2.add((Object)indent2);
                if (group.isChoice()) {
                    row2.add(new ChoiceButton(group, course, ca, requests));
                    row2.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), true));
                } else if (course.hasMultipleCourses()) {
                    row2.add(new ChoiceButton(course, ca, requests));
                    row2.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), true));
                } else {
                    row2.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), false));
                }
                row2.add((Object)new TitleLabel(ca.getTitle() == null ? "" : ca.getTitle()));
                row2.add(new HTML(ca.getLimit() == null || ca.getLimit() == 0 || ca.getEnrollment() == null ? "" : (ca.getLimit() < 0 ? "&infin;" : ca.getLimit() - ca.getEnrollment() + " / " + ca.getLimit()), false));
                row2.add(new Label(ca.hasCredit() ? ca.getCreditAbbv() : "", false));
                row2.add((Object)new NoteCell(ca.getNote()));
                row2.add((Object)new RequestPriorityCell(requests, ca));
                Image icon = null;
                if (this.isSaved(ca)) {
                    if (this.isLast(ca)) {
                        icon = new Image(RESOURCES.saved());
                        icon.setTitle(MESSAGES.saved(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                    } else {
                        icon = new Image(RESOURCES.unassignment());
                        icon.setTitle(MESSAGES.unassignment(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                    }
                } else if (this.isLast(ca)) {
                    icon = new Image(RESOURCES.assignment());
                    icon.setTitle(MESSAGES.assignment(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                }
                if (icon != null) {
                    icon.addStyleName("icon");
                    row2.add(icon);
                } else {
                    row2.add(new Label());
                }
                if (course.isCritical() && (course.getCourses().size() <= 1 || group.isChoice())) {
                    row2.add((Object)new CriticalCell(course));
                } else {
                    row2.add(new Label());
                }
                this.addRow(ca, row2);
            }
        }
    }

    protected void addGroup(int depth, int maxDepth, CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface group, DegreePlanInterface.DegreeGroupInterface parent) {
        if (depth > 1) {
            int d;
            Iterator<DegreePlanInterface.DegreeItemInterface> row = new ArrayList();
            P indent = new P("indent");
            for (d = 1; d < depth - 1; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
            }
            indent.add((Widget)new Image(RESOURCES.indentTopLine()));
            for (d = depth + 1; d <= maxDepth; ++d) {
                indent.add((Widget)new Image(RESOURCES.indentTopSpace()));
            }
            row.add((DegreePlanInterface.DegreeItemInterface)((Object)indent));
            if (parent != null && parent.isChoice()) {
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new ChoiceButton(parent, group)));
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new GroupTitleCell(group.toString(MESSAGES), true)));
            } else {
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new GroupTitleCell(group.toString(MESSAGES), false)));
            }
            if (group.isCritical()) {
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new CriticalCell(group)));
            } else {
                row.add((DegreePlanInterface.DegreeItemInterface)new Label());
            }
            this.addRow(group, (List<? extends Widget>)((Object)row));
        }
        if (group.hasCourses()) {
            for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                if (!course.isCritical()) continue;
                this.addCourse(depth, maxDepth, requests, group, course);
            }
        }
        if (group.hasGroups()) {
            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                if (!g.isCritical() || depth != 1) continue;
                this.addGroup(depth + 1, maxDepth, requests, g, group);
            }
        }
        if (group.hasCourses()) {
            for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                if (course.isCritical()) continue;
                this.addCourse(depth, maxDepth, requests, group, course);
            }
        }
        if (group.hasGroups()) {
            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                if (g.isCritical() && depth == 1) continue;
                this.addGroup(depth + 1, maxDepth, requests, g, group);
            }
        }
        if (group.hasPlaceHolders()) {
            for (DegreePlanInterface.DegreePlaceHolderInterface p : group.getPlaceHolders()) {
                int d;
                ArrayList<Object> row = new ArrayList<Object>();
                P indent = new P("indent");
                for (d = 1; d < depth; ++d) {
                    indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                }
                for (d = depth + 1; d <= maxDepth; ++d) {
                    indent.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                }
                row.add((Object)indent);
                row.add(new PlaceHolderCell(p.getName()));
                this.addRow(p, row);
            }
        }
        if (depth > 1 && this.getRowCount() > 1) {
            P indent = (P)this.getWidget(this.getRowCount() - 1, 0);
            indent.remove(depth - 2);
            indent.insert((Widget)new Image(RESOURCES.indentLastLine()), depth - 2);
        }
    }

    public void refreshSelection() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getCellCount(i); ++j) {
                Widget w = this.getWidget(i, j);
                if (w == null || !(w instanceof HasRefresh)) continue;
                ((HasRefresh)w).refresh();
            }
        }
    }

    public boolean canChoose(int row) {
        if (row <= 1 || row >= this.getRowCount()) {
            return false;
        }
        Widget w = this.getWidget(row, 1);
        return w != null && w instanceof ChoiceButton;
    }

    public void chooseRow(int row, boolean value) {
        if (row <= 1 || row >= this.getRowCount()) {
            return;
        }
        Widget w = this.getWidget(row, 1);
        if (w != null && w instanceof ChoiceButton) {
            ((ChoiceButton)w).setValue(value, true);
        }
    }

    public boolean isLast(ClassAssignmentInterface.CourseAssignment course) {
        if (this.iAssignments != null && this.iAssignments.getLastAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getLastAssignment().getCourseAssignments()) {
                if (!course.getCourseId().equals(c.getCourseId()) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSaved(ClassAssignmentInterface.CourseAssignment course) {
        if (this.iAssignments != null && this.iAssignments.getSavedAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getSavedAssignment().getCourseAssignments()) {
                if (!course.getCourseId().equals(c.getCourseId()) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isLast(CourseRequestInterface.RequestedCourse course) {
        if (course == null || course.isEmpty()) {
            return false;
        }
        if (this.iAssignments != null && this.iAssignments.getLastAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getLastAssignment().getCourseAssignments()) {
                if (!course.equals(c) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSaved(CourseRequestInterface.RequestedCourse course) {
        if (course == null || course.isEmpty()) {
            return false;
        }
        if (this.iAssignments != null && this.iAssignments.getSavedAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getSavedAssignment().getCourseAssignments()) {
                if (!course.equals(c) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    public CourseRequestInterface createRequests() {
        CourseRequestInterface.RequestedCourse course;
        Iterator<CourseRequestInterface.RequestedCourse> j;
        CourseRequestInterface.Request request;
        CourseRequestInterface requests = (CourseRequestInterface)this.iRequests.getValue();
        Iterator<CourseRequestInterface.Request> i = requests.getCourses().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete()) continue;
            if (request.hasRequestedCourse()) {
                j = request.getRequestedCourse().iterator();
                while (j.hasNext()) {
                    course = j.next();
                    if (this.isLast(course)) {
                        if (!this.iPlan.hasCourse(course) || this.iPlan.isCourseSelected(course)) continue;
                        j.remove();
                        continue;
                    }
                    j.remove();
                }
            }
            if (request.hasRequestedCourse()) continue;
            i.remove();
        }
        i = requests.getAlternatives().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete()) continue;
            if (request.hasRequestedCourse()) {
                j = request.getRequestedCourse().iterator();
                while (j.hasNext()) {
                    course = j.next();
                    if (this.isLast(course)) {
                        if (!this.iPlan.hasCourse(course) || this.iPlan.isCourseSelected(course)) continue;
                        j.remove();
                        continue;
                    }
                    j.remove();
                }
            }
            if (!request.isEmpty()) {
                requests.getCourses().add(request);
            }
            i.remove();
        }
        for (DegreePlanInterface.DegreeCourseInterface course2 : this.iPlan.listSelected(false)) {
            ClassAssignmentInterface.CourseAssignment ca = course2.getSelectedCourse(true);
            if (ca == null) continue;
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            rc.setCourseId(ca.getCourseId());
            rc.setCourseName(CONSTANTS.showCourseTitle() ? MESSAGES.courseNameWithTitle(ca.getSubject(), ca.getCourseNbr(), ca.getTitle()) : MESSAGES.course(ca.getSubject(), ca.getCourseNbr()));
            rc.setCourseTitle(ca.getTitle());
            rc.setCredit(ca.guessCreditRange());
            CourseRequestInterface.RequestPriority p = requests.getRequestPriority(ca);
            List<ClassAssignmentInterface.CourseAssignment> alternatives = this.iPlan.listAlternatives(course2);
            CourseRequestInterface.Request r = new CourseRequestInterface.Request();
            r.addRequestedCourse(rc);
            if (p != null) {
                r = p.getRequest();
                if (r.isReadOnly()) {
                    continue;
                }
            } else {
                requests.getCourses().add(r);
            }
            r.setFilter(this.iPlan.getPlaceHolder(course2));
            r.setAdvisorNote(this.iPlan.getPlaceHolder(course2));
            for (ClassAssignmentInterface.CourseAssignment altCa : alternatives) {
                p = requests.getRequestPriority(altCa);
                if (p != null) continue;
                CourseRequestInterface.RequestedCourse altRc = new CourseRequestInterface.RequestedCourse();
                altRc.setCourseId(altCa.getCourseId());
                altRc.setCourseName(CONSTANTS.showCourseTitle() ? MESSAGES.courseNameWithTitle(altCa.getSubject(), altCa.getCourseNbr(), altCa.getTitle()) : MESSAGES.course(altCa.getSubject(), altCa.getCourseNbr()));
                altRc.setCourseTitle(altCa.getTitle());
                altRc.setCredit(altCa.guessCreditRange());
                r.addRequestedCourse(altRc);
            }
        }
        return requests;
    }

    public void updateBackground() {
        CourseRequestInterface requests = (CourseRequestInterface)this.iRequests.getValue();
        HashSet<String> selectedCourses = new HashSet<String>();
        HashSet<Long> selectedCourseIds = new HashSet<Long>();
        for (DegreePlanInterface.DegreeCourseInterface course : this.iPlan.listSelected(false)) {
            if (course.getId() != null) {
                selectedCourses.add(course.getId());
            }
            if (course.getCourseId() != null) {
                selectedCourseIds.add(course.getCourseId());
            }
            for (ClassAssignmentInterface.CourseAssignment ca : this.iPlan.listAlternatives(course)) {
                selectedCourseIds.add(ca.getCourseId());
            }
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            String color;
            IsSerializable course;
            Object data = this.getData(row);
            if (data != null && data instanceof ClassAssignmentInterface.CourseAssignment) {
                course = (ClassAssignmentInterface.CourseAssignment)data;
                CourseRequestInterface.RequestPriority rp = requests.getRequestPriority((ClassAssignmentInterface.CourseAssignment)course);
                boolean requested = rp != null;
                boolean selected = selectedCourseIds.contains(course.getCourseId());
                String color2 = null;
                if (selected) {
                    if (!requested) {
                        color2 = "#D7FFD7";
                    }
                } else if (requested && rp.getRequest().isCanDelete()) {
                    color2 = "#FFD7D7";
                }
                this.setBackGroundColor(row, color2);
                continue;
            }
            if (data != null && data instanceof DegreePlanInterface.DegreeGroupInterface) {
                DegreePlanInterface.DegreeGroupInterface group = (DegreePlanInterface.DegreeGroupInterface)data;
                if (!group.isChoice()) continue;
                color = null;
                if (!group.hasSelection()) {
                    color = "#FFF0AB";
                }
                this.setBackGroundColor(row, color);
                continue;
            }
            if (data == null || !(data instanceof DegreePlanInterface.DegreeCourseInterface)) continue;
            course = (DegreePlanInterface.DegreeCourseInterface)data;
            color = null;
            if (course.getId() != null && selectedCourses.contains(course.getId()) && course.getCourseId() == null) {
                color = "#FFF0AB";
            }
            this.setBackGroundColor(row, color);
        }
    }

    public static class RequestPriorityCell
    extends Label {
        public RequestPriorityCell(CourseRequestInterface requests, ClassAssignmentInterface.CourseAssignment assignment) {
            CourseRequestInterface.RequestPriority rp = requests.getRequestPriority(assignment);
            this.setText(rp == null ? "" : rp.toString(MESSAGES));
            this.setWordWrap(false);
            this.addStyleName("request");
        }
    }

    public static class NoteCell
    extends Label {
        public NoteCell(String label) {
            super(label == null ? "" : label, false);
            if (label != null && !label.isEmpty()) {
                this.setTitle(label);
            }
            this.addStyleName("note");
        }
    }

    public class ChoiceButton
    extends CheckBox
    implements HasRefresh {
        private DegreePlanInterface.DegreeMultiSelectionInterface iParent;
        private String iId;

        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface parent, DegreePlanInterface.DegreeCourseInterface course) {
            super("");
            if (course.isSelected()) {
                course.setSelected(false);
            }
            this.setEnabled(false);
            this.iParent = parent;
            this.iId = course.getId();
            this.refresh();
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourse())));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ChoiceButton.this.iParent.setMultiSelection(ChoiceButton.this.iId, (Boolean)event.getValue());
                    if (!ChoiceButton.this.iParent.hasMultiSelection() || ChoiceButton.this.iParent.getMultiSelection(ChoiceButton.this.iId) == 0) {
                        if (parent.hasCourses()) {
                            for (DegreePlanInterface.DegreeCourseInterface c : parent.getCourses()) {
                                c.setSelected(ChoiceButton.this.iId.equals(c.getId()) ? (Boolean)event.getValue() : false);
                            }
                        }
                        if (parent.hasGroups()) {
                            for (DegreePlanInterface.DegreeGroupInterface g : parent.getGroups()) {
                                g.setSelected(false);
                            }
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                    DegreePlanTable.this.refreshSelection();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface parent, DegreePlanInterface.DegreeGroupInterface group) {
            super("");
            this.setEnabled(false);
            if (group.hasCourses()) {
                for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                    if (!course.hasCourses()) continue;
                    this.setEnabled(true);
                    break;
                }
            }
            this.iParent = parent;
            this.iId = group.getId();
            if (!this.iParent.hasMultiSelection() && group.isSelected() && this.isEnabled()) {
                this.iParent.setMultiSelection(this.iId, true);
            }
            if (!this.isEnabled() && group.isSelected()) {
                group.setSelected(false);
            }
            this.refresh();
            this.setTitle(MESSAGES.hintChoiceGroupSelection(group.toString(MESSAGES)));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ChoiceButton.this.iParent.setMultiSelection(ChoiceButton.this.iId, (Boolean)event.getValue());
                    if (!ChoiceButton.this.iParent.hasMultiSelection() || ChoiceButton.this.iParent.getMultiSelection(ChoiceButton.this.iId) == 0) {
                        if (parent.hasCourses()) {
                            for (DegreePlanInterface.DegreeCourseInterface c : parent.getCourses()) {
                                c.setSelected(false);
                            }
                        }
                        if (parent.hasGroups()) {
                            for (DegreePlanInterface.DegreeGroupInterface g : parent.getGroups()) {
                                g.setSelected(ChoiceButton.this.iId.equals(g.getId()) ? (Boolean)event.getValue() : false);
                            }
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                    DegreePlanTable.this.refreshSelection();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeCourseInterface parent, final ClassAssignmentInterface.CourseAssignment course, CourseRequestInterface requests) {
            super("");
            this.iParent = parent;
            this.iId = parent.getId() + ":" + course.getCourseId();
            if (!this.iParent.hasMultiSelection() && course.getCourseId().equals(parent.getCourseId())) {
                this.iParent.setMultiSelection(this.iId, true);
                CourseRequestInterface.RequestPriority p = requests.getRequestPriority(course);
                if (p != null) {
                    for (CourseRequestInterface.RequestedCourse rc : p.getRequest().getRequestedCourse()) {
                        if (!parent.hasCourse(rc.getCourseId())) continue;
                        this.iParent.setMultiSelection(parent.getId() + ":" + rc.getCourseId(), true);
                    }
                }
            }
            this.refresh();
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourseNbr())));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ChoiceButton.this.iParent.setMultiSelection(ChoiceButton.this.iId, (Boolean)event.getValue());
                    if (!ChoiceButton.this.iParent.hasMultiSelection() || ChoiceButton.this.iParent.getMultiSelection(ChoiceButton.this.iId) == 0) {
                        if (((Boolean)event.getValue()).booleanValue()) {
                            parent.setCourseId(course.getCourseId());
                        } else {
                            parent.setCourseId(null);
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                    DegreePlanTable.this.refreshSelection();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface group, final DegreePlanInterface.DegreeCourseInterface parent, final ClassAssignmentInterface.CourseAssignment course, CourseRequestInterface requests) {
            super("");
            this.iParent = group;
            this.iId = parent.getId() + ":" + course.getCourseId();
            if (!this.iParent.hasMultiSelection() && course.getCourseId().equals(parent.getCourseId())) {
                this.iParent.setMultiSelection(this.iId, true);
                CourseRequestInterface.RequestPriority p = requests.getRequestPriority(course);
                if (p != null) {
                    for (CourseRequestInterface.RequestedCourse rc : p.getRequest().getRequestedCourse()) {
                        DegreePlanInterface.DegreeCourseInterface c = group.getCourse(rc.getCourseId());
                        if (c == null) continue;
                        this.iParent.setMultiSelection(c.getId() + ":" + rc.getCourseId(), true);
                    }
                }
            }
            this.refresh();
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourseNbr())));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    ChoiceButton.this.iParent.setMultiSelection(ChoiceButton.this.iId, (Boolean)event.getValue());
                    if (!ChoiceButton.this.iParent.hasMultiSelection() || ChoiceButton.this.iParent.getMultiSelection(ChoiceButton.this.iId) == 0) {
                        if (((Boolean)event.getValue()).booleanValue()) {
                            parent.setCourseId(course.getCourseId());
                        } else {
                            parent.setCourseId(null);
                        }
                        if (group.hasCourses()) {
                            for (DegreePlanInterface.DegreeCourseInterface c : group.getCourses()) {
                                c.setSelected(parent.getId().equals(c.getId()) ? (Boolean)event.getValue() : false);
                            }
                        }
                        if (group.hasGroups()) {
                            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                                g.setSelected(false);
                            }
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                    DegreePlanTable.this.refreshSelection();
                }
            });
        }

        @Override
        public void refresh() {
            int selection = this.iParent.getMultiSelection(this.iId);
            this.setValue(selection >= 0);
            this.setText(selection < 0 ? "" : String.valueOf(1 + selection));
        }
    }

    public static interface HasRefresh {
        public void refresh();
    }

    public static class CriticalCell
    extends Image {
        public CriticalCell(final DegreePlanInterface.DegreeCourseInterface course) {
            super(RESOURCES.degreePlanCritical());
            this.setTitle(MESSAGES.hintCriticalCourse(course.getCourseName()));
            this.setAltText(MESSAGES.hintCriticalCourse(course.getCourseName()));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                    UniTimeConfirmationDialog.info(MESSAGES.hintCriticalCourse(course.getCourseName()));
                }
            });
        }

        public CriticalCell(final DegreePlanInterface.DegreeGroupInterface group) {
            super(RESOURCES.degreePlanCritical());
            this.setTitle(MESSAGES.hintCriticalGroup(group.isPlaceHolder() ? group.getDescription() : group.toString(MESSAGES)));
            this.setAltText(MESSAGES.hintCriticalGroup(group.isPlaceHolder() ? group.getDescription() : group.toString(MESSAGES)));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                    UniTimeConfirmationDialog.info(MESSAGES.hintCriticalGroup(group.isPlaceHolder() ? group.getDescription() : group.toString(MESSAGES)));
                }
            });
        }
    }

    public static class PlaceHolderCell
    extends Label
    implements UniTimeTable.HasColSpan {
        public PlaceHolderCell(String label) {
            super(label, false);
            this.addStyleName("placeholder");
            this.setTitle(label);
        }

        @Override
        public int getColSpan() {
            return 9;
        }
    }

    public static class TitleLabel
    extends Label {
        public TitleLabel(String label) {
            super(label, false);
            this.addStyleName("title");
        }
    }

    public static class CourseNotOfferedLabel
    extends Label
    implements UniTimeTable.HasColSpan {
        public CourseNotOfferedLabel(String label) {
            super(label, false);
            this.addStyleName("error");
        }

        @Override
        public int getColSpan() {
            return 5;
        }
    }

    public static class CourseLabel
    extends Label
    implements UniTimeTable.HasColSpan {
        private boolean iHasChoice;

        public CourseLabel(String label, boolean hasChoice) {
            super(label, false);
            this.addStyleName("course");
            this.iHasChoice = hasChoice;
        }

        @Override
        public int getColSpan() {
            return this.iHasChoice ? 1 : 2;
        }
    }

    public static class GroupTitleCell
    extends Label
    implements UniTimeTable.HasColSpan {
        private boolean iHasChoice;

        public GroupTitleCell(String label, boolean hasChoice) {
            super(label, false);
            this.addStyleName("grouplabel");
            this.iHasChoice = hasChoice;
            this.setTitle(label);
        }

        @Override
        public int getColSpan() {
            return this.iHasChoice ? 7 : 8;
        }
    }
}

