/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class CourseDetailsWidget
extends Composite {
    protected static GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private FlowPanel iPanel = new FlowPanel();
    private Image iLoadingImage = new Image(RESOURCES.loading_small());
    private Anchor iAnchor = null;
    private HTML iDetails = null;

    public CourseDetailsWidget(boolean anchor) {
        this.iLoadingImage.setVisible(false);
        this.iPanel.add((Widget)this.iLoadingImage);
        this.iDetails = new HTML("");
        if (anchor) {
            this.iAnchor = new Anchor(MESSAGES.courseCatalogLink());
            this.iAnchor.setVisible(false);
            this.iAnchor.setTarget("_blank");
            this.iPanel.add((Widget)this.iAnchor);
            this.iAnchor.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    if (!CourseDetailsWidget.this.iDetails.getText().isEmpty()) {
                        GwtHint.showHint((Element)CourseDetailsWidget.this.iAnchor.getElement(), (Widget)CourseDetailsWidget.this.iDetails);
                    }
                }
            });
            this.iAnchor.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    GwtHint.hideHint();
                }
            });
            this.iDetails.setStyleName("unitime-CourseDetailsPopup");
        } else {
            this.iPanel.add((Widget)this.iDetails);
        }
        this.initWidget((Widget)this.iPanel);
    }

    public void insert(RootPanel panel) {
        String command = panel.getElement().getInnerText().trim();
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
        try {
            this.reload(new CourseDetailsRpcRequest(Long.parseLong(command)));
        }
        catch (NumberFormatException e) {
            com.google.gwt.user.client.Element subjectElement = DOM.getElementById((String)command.split(",")[0]);
            com.google.gwt.user.client.Element courseElement = DOM.getElementById((String)command.split(",")[1]);
            if ("select".equalsIgnoreCase(subjectElement.getTagName())) {
                final ListBox subjectId = ListBox.wrap((Element)subjectElement);
                final TextBox courseNumber = TextBox.wrap((Element)courseElement);
                courseNumber.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        if (subjectId.getSelectedIndex() >= 0 && !courseNumber.getValue().isEmpty()) {
                            try {
                                CourseDetailsWidget.this.reload(new CourseDetailsRpcRequest(Long.valueOf(subjectId.getValue(subjectId.getSelectedIndex())), courseNumber.getValue()));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                });
                if (subjectId.getSelectedIndex() >= 0 && !courseNumber.getValue().isEmpty()) {
                    try {
                        this.reload(new CourseDetailsRpcRequest(Long.valueOf(subjectId.getValue(subjectId.getSelectedIndex())), courseNumber.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if ("input".equalsIgnoreCase(courseElement.getTagName())) {
                final Hidden subjectId = Hidden.wrap((Element)subjectElement);
                final TextBox courseNumber = TextBox.wrap((Element)courseElement);
                courseNumber.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        if (!courseNumber.getValue().isEmpty()) {
                            try {
                                CourseDetailsWidget.this.reload(new CourseDetailsRpcRequest(Long.valueOf(subjectId.getValue()), courseNumber.getValue()));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                });
                if (!courseNumber.getValue().isEmpty()) {
                    try {
                        this.reload(new CourseDetailsRpcRequest(Long.valueOf(subjectId.getValue()), courseNumber.getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            Hidden subjectId = Hidden.wrap((Element)subjectElement);
            Hidden courseNumber = Hidden.wrap((Element)courseElement);
            this.reload(new CourseDetailsRpcRequest(Long.valueOf(subjectId.getValue()), courseNumber.getValue()));
        }
    }

    private void reload(CourseDetailsRpcRequest request) {
        this.iLoadingImage.setVisible(true);
        if (this.iAnchor != null) {
            this.iAnchor.setVisible(false);
        } else {
            this.iDetails.setVisible(false);
        }
        RPC.execute(request, new AsyncCallback<CourseDetailsRpcResponse>(){

            public void onFailure(Throwable caught) {
                CourseDetailsWidget.this.iLoadingImage.setVisible(false);
            }

            public void onSuccess(CourseDetailsRpcResponse result) {
                CourseDetailsWidget.this.iLoadingImage.setVisible(false);
                if (result != null) {
                    CourseDetailsWidget.this.iDetails.setHTML(result.hasDetails() ? result.getDetails() : "");
                    if (CourseDetailsWidget.this.iAnchor != null) {
                        CourseDetailsWidget.this.iAnchor.setHref(result.getLink());
                        CourseDetailsWidget.this.iAnchor.setVisible(true);
                    } else {
                        CourseDetailsWidget.this.iDetails.setVisible(result.hasDetails());
                    }
                }
            }
        });
    }

    public static class CourseDetailsRpcResponse
    implements GwtRpcResponse {
        private String iLink = null;
        private String iDetails = null;

        public String getLink() {
            return this.iLink;
        }

        public void setLink(String link) {
            this.iLink = link;
        }

        public boolean hasLink() {
            return this.iLink != null && !this.iLink.isEmpty();
        }

        public String getDetails() {
            return this.iDetails;
        }

        public void setDetails(String details) {
            this.iDetails = details;
        }

        public boolean hasDetails() {
            return this.iDetails != null && !this.iDetails.isEmpty();
        }
    }

    public static class CourseDetailsRpcRequest
    implements GwtRpcRequest<CourseDetailsRpcResponse> {
        private Long iCourseId = null;
        private Long iSubjectId = null;
        private String iCourseNumber = null;

        public CourseDetailsRpcRequest() {
        }

        public CourseDetailsRpcRequest(Long courseId) {
            this.setCourseId(courseId);
        }

        public CourseDetailsRpcRequest(Long subjectId, String courseNbr) {
            this.setSubjectId(subjectId);
            this.setCourseNumber(courseNbr);
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public Long getSubjectId() {
            return this.iSubjectId;
        }

        public void setSubjectId(Long subjectId) {
            this.iSubjectId = subjectId;
        }

        public boolean hasSubjectId() {
            return this.iSubjectId != null;
        }

        public String getCourseNumber() {
            return this.iCourseNumber;
        }

        public void setCourseNumber(String courseNbr) {
            this.iCourseNumber = courseNbr;
        }

        public boolean hasCourseNumber() {
            return this.iCourseNumber != null;
        }

        @Override
        public String toString() {
            if (this.hasCourseId()) {
                return this.getCourseId().toString();
            }
            return this.getSubjectId() + " " + this.getCourseNumber();
        }
    }
}

