/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.sectioning.SelectAllCourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFreeTime;
import org.unitime.timetable.gwt.client.widgets.CourseFinderMultipleCourses;
import org.unitime.timetable.gwt.client.widgets.CourseRequestBox;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class AdvisorCourseRequestLine
implements HasValue<CourseRequestInterface.Request> {
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private P iP;
    private P iButtons;
    private boolean iAlternate;
    private int iPriority;
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private List<CourseSelectionBox> iCourses = new ArrayList<CourseSelectionBox>();
    private AdvisorCourseRequestLine iPrevious = null;
    private AdvisorCourseRequestLine iNext = null;
    private Validator<CourseSelection> iValidator = null;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private ImageButton iDelete;
    private UniTimeTextBox iCredit;
    private CheckBox iWaitList;
    private TextArea iNotes;
    private Timer iTimer;

    public AdvisorCourseRequestLine(OnlineSectioningInterface.StudentSectioningContext context, int priority, boolean alternate, Validator<CourseSelection> validator, SpecialRegistrationInterface.SpecialRegistrationContext specreg) {
        this.iP = new P("unitime-AdvisorCourseRequestLine");
        this.iContext = context;
        this.iValidator = validator;
        this.iPriority = priority;
        this.iAlternate = alternate;
        this.iSpecReg = specreg;
        P line = new P("line");
        P title = new P("title");
        title.setText(alternate ? MESSAGES.courseRequestsAlternate(priority + 1) : MESSAGES.courseRequestsPriority(priority + 1));
        line.add((Widget)title);
        CourseSelectionBox box = new CourseSelectionBox(!alternate, false);
        if (alternate) {
            box.setLabel(ARIA.titleRequestedAlternate(1 + priority, String.valueOf((char)(97 + priority))), ARIA.altRequestedAlternateFinder(1 + priority));
            box.setAccessKey((char)(97 + priority));
        } else {
            box.setLabel(ARIA.titleRequestedCourse(1 + priority), ARIA.altRequestedCourseFinder(1 + priority));
            if (priority < 9) {
                box.setAccessKey((char)(49 + priority));
            } else if (priority == 9) {
                box.setAccessKey('0');
            }
        }
        box.addStyleName("course");
        line.add((Widget)box);
        this.iCourses.add(box);
        this.iP.add((Widget)line);
        this.iButtons = new P("unitime-AdvisorCourseRequestButtons");
        P up = new P("blank");
        this.iButtons.add((Widget)up);
        P down = new P("blank");
        this.iButtons.add((Widget)down);
        this.iDelete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
        this.iDelete.addStyleName("unitime-NoPrint");
        this.iDelete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestLine.this.delete();
                ValueChangeEvent.fire((HasValueChangeHandlers)AdvisorCourseRequestLine.this, (Object)AdvisorCourseRequestLine.this.getValue());
            }
        });
        this.iDelete.addStyleName("delete");
        this.iDelete.setAltText(ARIA.altDeleteRequest(priority + 1));
        this.iButtons.add((Widget)this.iDelete);
        this.iCredit = new UniTimeTextBox();
        this.iCredit.addStyleName("unitime-AdvisorCourseRequestCredit");
        this.iCredit.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)AdvisorCourseRequestLine.this, (Object)AdvisorCourseRequestLine.this.getValue());
            }
        });
        this.iCredit.setMaxLength(10);
        this.iNotes = new TextArea();
        this.iNotes.setStyleName("unitime-TextArea");
        this.iNotes.setText("");
        this.iNotes.setHeight("23px");
        this.iNotes.getElement().setAttribute("maxlength", "2048");
        this.iTimer = new Timer(){

            public void run() {
                AdvisorCourseRequestLine.this.resizeNotes();
            }
        };
        this.iNotes.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                AdvisorCourseRequestLine.this.iTimer.schedule(10);
            }
        });
        this.iNotes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                AdvisorCourseRequestLine.this.iTimer.schedule(10);
            }
        });
        if (!alternate) {
            this.iWaitList = new CheckBox();
            this.iWaitList.addStyleName("waitlist");
            this.iNotes.addStyleName("notes-with-waitlist");
        } else {
            this.iNotes.addStyleName("notes-no-waitlist");
        }
    }

    public void insert(FlexTable table, int row) {
        table.setWidget(row, 0, (Widget)this.iP);
        table.getFlexCellFormatter().setColSpan(row, 0, 2);
        table.setWidget(row, 1, (Widget)this.iCredit);
        table.getFlexCellFormatter().getElement(row, 1).getStyle().setWidth(45.0, Style.Unit.PX);
        table.setWidget(row, 2, (Widget)this.iNotes);
        table.getFlexCellFormatter().setColSpan(row, 2, 2);
        if (this.iWaitList != null) {
            table.getFlexCellFormatter().setColSpan(row, 2, 1);
            table.setWidget(row, 3, (Widget)this.iWaitList);
            table.setWidget(row, 4, (Widget)this.iButtons);
            table.getFlexCellFormatter().getElement(row, 4).getStyle().setWidth(75.0, Style.Unit.PX);
        } else {
            table.setWidget(row, 3, (Widget)this.iButtons);
            table.getFlexCellFormatter().getElement(row, 3).getStyle().setWidth(75.0, Style.Unit.PX);
        }
    }

    public void setWaitListVisible(boolean visible) {
        if (this.iWaitList != null) {
            this.iWaitList.setVisible(visible);
            if (visible) {
                this.iNotes.addStyleName("notes-with-waitlist");
                this.iNotes.removeStyleName("notes-no-waitlist");
            } else {
                this.iNotes.addStyleName("notes-no-waitlist");
                this.iNotes.removeStyleName("notes-with-waitlist");
            }
        }
    }

    public void setPrevious(AdvisorCourseRequestLine previous) {
        this.iPrevious = previous;
        if (this.iPrevious == null) {
            if (this.iButtons.getWidget(0) instanceof ImageButton) {
                this.iButtons.remove(0);
                P up = new P("blank");
                this.iButtons.add((Widget)up);
                this.iButtons.insert((Widget)up, 0);
            }
        } else {
            ImageButton up = null;
            if (this.iButtons.getWidget(0) instanceof ImageButton) {
                up = (ImageButton)this.iButtons.getWidget(0);
            } else {
                this.iButtons.remove(0);
                up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
                up.addStyleName("unitime-NoPrint");
                up.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        AdvisorCourseRequestLine.this.up();
                        ValueChangeEvent.fire((HasValueChangeHandlers)AdvisorCourseRequestLine.this, (Object)AdvisorCourseRequestLine.this.getValue());
                    }
                });
                up.addStyleName("up");
                this.iButtons.insert((Widget)up, 0);
            }
            if (this.isAlternate()) {
                if (this.iPrevious.isAlternate()) {
                    up.setAltText(ARIA.altSwapAlternateRequest(this.getPriority() + 1, this.getPriority()));
                } else {
                    up.setAltText(ARIA.altSwapCourseAlternateRequest(this.iPrevious.getPriority() + 1, this.getPriority() + 1));
                }
            } else {
                up.setAltText(ARIA.altSwapCourseRequest(this.getPriority() + 1, this.getPriority()));
            }
        }
    }

    public void setNext(AdvisorCourseRequestLine next) {
        this.iNext = next;
        if (this.iNext == null) {
            if (this.iButtons.getWidget(1) instanceof ImageButton) {
                this.iButtons.remove(1);
                P down = new P("blank");
                this.iButtons.add((Widget)down);
                this.iButtons.insert((Widget)down, 1);
            }
        } else {
            ImageButton down = null;
            if (this.iButtons.getWidget(1) instanceof ImageButton) {
                down = (ImageButton)this.iButtons.getWidget(1);
            } else {
                this.iButtons.remove(1);
                down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
                down.addStyleName("unitime-NoPrint");
                down.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        AdvisorCourseRequestLine.this.down();
                        ValueChangeEvent.fire((HasValueChangeHandlers)AdvisorCourseRequestLine.this, (Object)AdvisorCourseRequestLine.this.getValue());
                    }
                });
                down.addStyleName("down");
                this.iButtons.insert((Widget)down, 1);
            }
            if (this.isAlternate()) {
                down.setAltText(ARIA.altSwapAlternateRequest(this.getPriority() + 1, this.getPriority() + 2));
            } else if (this.iNext.isAlternate()) {
                down.setAltText(ARIA.altSwapCourseAlternateRequest(this.getPriority() + 1, this.iNext.getPriority() + 1));
            } else {
                down.setAltText(ARIA.altSwapCourseRequest(this.getPriority() + 1, this.getPriority() + 2));
            }
        }
    }

    public void up() {
        if (this.iPrevious != null) {
            CourseRequestInterface.Request r = this.getValue();
            this.setValue(this.iPrevious.getValue());
            this.iPrevious.setValue(r);
        }
    }

    public void down() {
        if (this.iNext != null) {
            CourseRequestInterface.Request r = this.getValue();
            this.setValue(this.iNext.getValue());
            this.iNext.setValue(r);
        }
    }

    public void computeCredits() {
        Float minCredit = null;
        Float maxCredit = null;
        for (CourseSelectionBox box : this.iCourses) {
            CourseRequestInterface.RequestedCourse rc = box.getValue();
            if (!rc.hasCredit()) continue;
            if (minCredit == null || minCredit.floatValue() > rc.getCreditMin().floatValue()) {
                minCredit = rc.getCreditMin();
            }
            if (maxCredit != null && !(maxCredit.floatValue() < rc.getCreditMax().floatValue())) continue;
            maxCredit = rc.getCreditMax();
        }
        if (minCredit != null) {
            if (minCredit.floatValue() < maxCredit.floatValue()) {
                this.iCredit.setValue(MESSAGES.creditRange(minCredit.floatValue(), maxCredit.floatValue()));
            } else {
                this.iCredit.setValue(MESSAGES.credit(minCredit.floatValue()));
            }
        }
    }

    public float getCreditMin() {
        String cred = this.iCredit.getValue();
        if (cred.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(cred.replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (cred.contains("-")) {
                try {
                    return Float.parseFloat(cred.substring(0, cred.indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    public float getCreditMax() {
        String cred = this.iCredit.getValue();
        if (cred.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(cred.replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (cred.contains("-")) {
                try {
                    return Float.parseFloat(cred.substring(1 + cred.indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    public List<? extends CourseSelectionBox> getCourses() {
        return this.iCourses;
    }

    public void fixTitles() {
        for (int i = 0; i < this.iP.getWidgetCount(); ++i) {
            P line = (P)this.iP.getWidget(i);
            P title = (P)line.getWidget(0);
            CourseSelectionBox box = (CourseSelectionBox)line.getWidget(1);
            if (i == 0) {
                title.setText(this.isAlternate() ? MESSAGES.courseRequestsAlternate(this.getPriority() + 1) : MESSAGES.courseRequestsPriority(this.getPriority() + 1));
                if (this.isAlternate()) {
                    box.setLabel(ARIA.titleRequestedAlternate(1 + this.getPriority(), String.valueOf((char)(97 + this.getPriority()))), ARIA.altRequestedAlternateFinder(1 + this.getPriority()));
                } else {
                    box.setLabel(ARIA.titleRequestedCourse(1 + this.getPriority()), ARIA.altRequestedCourseFinder(1 + this.getPriority()));
                }
            } else {
                title.setText(MESSAGES.courseRequestsAlternative(i));
                if (this.isAlternate()) {
                    if (i == 1) {
                        box.setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateFirstFinder(1 + this.getPriority()));
                    } else if (i == 2) {
                        box.setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateSecondFinder(1 + this.getPriority()));
                    } else {
                        box.setLabel(ARIA.titleRequestedAlternateNAlternative(i, 1 + this.getPriority()), ARIA.altRequestedNAlternateFinder(i, 1 + this.getPriority()));
                    }
                } else if (i == 1) {
                    box.setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + this.getPriority()), ARIA.altRequestedCourseFirstAlternativeFinder(1 + this.getPriority()));
                } else if (i == 2) {
                    box.setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + this.getPriority()), ARIA.altRequestedCourseSecondAlternativeFinder(1 + this.getPriority()));
                } else {
                    box.setLabel(ARIA.titleRequestedCourseNAlternative(i, 1 + this.getPriority()), ARIA.altRequestedCourseNAlternativeFinder(i, 1 + this.getPriority()));
                }
            }
            box.resizeFilterIfNeeded();
            CourseSelectionEvent.fire((HasHandlers)box, box.getValue());
        }
        this.resizeNotes();
    }

    private void resizeNotes() {
        if (!this.iNotes.getText().isEmpty()) {
            this.iNotes.setHeight(Math.max(23 + 27 * (this.iCourses.size() - 1), this.iNotes.getElement().getScrollHeight()) + "px");
        } else {
            this.iNotes.setHeight(23 + 27 * (this.iCourses.size() - 1) + "px");
        }
    }

    public boolean isAlternate() {
        return this.iAlternate;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public void delete() {
        if (this.iNext != null && this.isAlternate() == this.iNext.isAlternate()) {
            this.setValue(this.iNext.getValue());
            this.iNext.delete();
        } else {
            this.iCourses.get(0).setValue(null);
            this.iCredit.setValue("");
            this.iNotes.setValue((Object)"");
            if (this.iWaitList != null) {
                this.iWaitList.setValue(Boolean.valueOf(false));
            }
            for (int i = this.iCourses.size() - 1; i > 0; --i) {
                this.deleteAlternative(i);
            }
        }
    }

    public void deleteAlternative(int index) {
        this.iCourses.remove(index).dispose();
        this.iP.remove(index);
        this.fixTitles();
    }

    public void insertAlternative(int index) {
        P line = new P("alt-line");
        P title = new P("title");
        title.setText(MESSAGES.courseRequestsAlternative(index));
        line.add((Widget)title);
        CourseSelectionBox box = new CourseSelectionBox(false, true);
        if (this.isAlternate()) {
            if (index == 1) {
                box.setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateFirstFinder(1 + this.getPriority()));
            } else if (index == 2) {
                box.setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + this.getPriority()), ARIA.altRequestedAlternateSecondFinder(1 + this.getPriority()));
            } else {
                box.setLabel(ARIA.titleRequestedAlternateNAlternative(index, 1 + this.getPriority()), ARIA.altRequestedNAlternateFinder(index, 1 + this.getPriority()));
            }
        } else if (index == 1) {
            box.setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + this.getPriority()), ARIA.altRequestedCourseFirstAlternativeFinder(1 + this.getPriority()));
        } else if (index == 2) {
            box.setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + this.getPriority()), ARIA.altRequestedCourseSecondAlternativeFinder(1 + this.getPriority()));
        } else {
            box.setLabel(ARIA.titleRequestedCourseNAlternative(index, 1 + this.getPriority()), ARIA.altRequestedCourseNAlternativeFinder(index, 1 + this.getPriority()));
        }
        box.addStyleName("course");
        line.add((Widget)box);
        this.iCourses.add(box);
        this.iP.insert((Widget)line, index);
        box.setValue(null);
        this.fixTitles();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.Request> handler) {
        return this.iP.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface.Request getValue() {
        CourseRequestInterface.Request ret = new CourseRequestInterface.Request();
        for (CourseSelectionBox box : this.iCourses) {
            CourseRequestInterface.RequestedCourse rc = box.getValue();
            if (rc.isEmpty()) continue;
            ret.addRequestedCourse(rc);
        }
        ret.setFilter(this.iCourses.get(0).getCourseFinder().getFilter());
        ret.setAdvisorCredit(this.iCredit.getValue());
        ret.setAdvisorNote(this.iNotes.getValue());
        if (this.iWaitList == null || !this.iWaitList.isVisible()) {
            ret.setWaitList(null);
        } else {
            ret.setWaitList(this.iWaitList.getValue());
        }
        return ret.isEmpty() && !ret.hasAdvisorCredit() && !ret.hasAdvisorNote() ? null : ret;
    }

    public void setValue(CourseRequestInterface.Request value) {
        this.setValue(value, false);
    }

    public boolean isCanChangeAlternatives() {
        for (CourseSelectionBox box : this.iCourses) {
            if (box.isCanChangePriority()) continue;
            return false;
        }
        return true;
    }

    public void setUpArrowEnabled(boolean enabled) {
        if (this.iButtons.getWidget(0) instanceof ImageButton) {
            ((ImageButton)this.iButtons.getWidget(0)).setEnabled(enabled);
            ((ImageButton)this.iButtons.getWidget(0)).setVisible(enabled);
        }
    }

    public void setDownArrowEnabled(boolean enabled) {
        if (this.iButtons.getWidget(1) instanceof ImageButton) {
            ((ImageButton)this.iButtons.getWidget(1)).setEnabled(enabled);
            ((ImageButton)this.iButtons.getWidget(1)).setVisible(enabled);
        }
    }

    public void setValue(CourseRequestInterface.Request value, boolean fireEvents) {
        boolean enabled;
        if (value == null) {
            this.iCourses.get(0).setValue(null, true);
            for (int i = this.iCourses.size() - 1; i > 0; --i) {
                this.deleteAlternative(i);
            }
            this.iCredit.setValue("");
            this.iNotes.setValue((Object)"");
            if (this.iWaitList != null) {
                this.iWaitList.setValue(Boolean.valueOf(false));
            }
        } else {
            int index = 0;
            if (value.hasRequestedCourse()) {
                for (CourseRequestInterface.RequestedCourse rc : value.getRequestedCourse()) {
                    if (rc.isEmpty()) continue;
                    if (this.iCourses.size() <= index) {
                        this.insertAlternative(index);
                    }
                    this.iCourses.get(index).setValue(rc, true);
                    ++index;
                }
            }
            if (index == 0) {
                this.iCourses.get(0).setValue(null, true);
                ++index;
            } else if (CONSTANTS.courseRequestAutomaticallyAddFirstAlternative() && !this.iAlternate && index == 1 && this.iCourses.get(0).getValue().hasCourseId() && this.iCourses.get(0).getValue().isCanDelete()) {
                this.iCourses.get(index).setValue(null, true);
                ++index;
            }
            for (int i = this.iCourses.size() - 1; i >= index; --i) {
                this.deleteAlternative(i);
            }
            if (value.hasFilter()) {
                this.iCourses.get(0).getCourseFinder().setFilter(value.getFilter());
            }
            this.iCredit.setValue(value.hasAdvisorCredit() ? value.getAdvisorCredit() : "");
            this.iNotes.setValue((Object)(value.hasAdvisorNote() ? value.getAdvisorNote() : ""));
            if (this.iWaitList != null) {
                this.iWaitList.setValue(Boolean.valueOf(value.isWaitList()));
            }
        }
        if (this.iDelete != null) {
            this.iDelete.setVisible(value == null || value.isCanDelete());
        }
        if (this.iPrevious != null) {
            enabled = this.iPrevious.isCanChangeAlternatives() && this.isCanChangeAlternatives();
            this.setUpArrowEnabled(enabled);
            this.iPrevious.setDownArrowEnabled(enabled);
        }
        if (this.iNext != null) {
            enabled = this.iNext.isCanChangeAlternatives() && this.isCanChangeAlternatives();
            this.setDownArrowEnabled(enabled);
            this.iNext.setUpArrowEnabled(enabled);
        }
        this.resizeNotes();
        this.computeCredits();
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public String validate() {
        String failed = null;
        for (CourseSelectionBox box : this.iCourses) {
            String message = box.validate();
            if (failed != null || message == null) continue;
            failed = message;
        }
        return failed;
    }

    public void fireEvent(GwtEvent<?> event) {
        this.iP.fireEvent(event);
    }

    public class CourseSelectionBox
    extends CourseRequestBox {
        private HandlerRegistration iCourseSelectionHandlerRegistration;
        private CourseRequestBox.FilterStatus iStatus;
        private CourseFinderMultipleCourses iCourseFinderMultipleCourses;

        public CourseSelectionBox(boolean allowFreeTime, final boolean alternative) {
            super(CONSTANTS.showCourseTitle(), AdvisorCourseRequestLine.this.iSpecReg);
            if (allowFreeTime) {
                FreeTimeParser parser = new FreeTimeParser();
                this.setFreeTimes(parser);
            }
            this.setCourseFinderFactory(new CourseFinderFactory(){

                @Override
                public CourseFinder createCourseFinder() {
                    CourseFinderDialog finder = alternative ? new CourseFinderDialog() : new SelectAllCourseFinderDialog();
                    CourseSelectionBox.this.iCourseFinderMultipleCourses = new CourseFinderMultipleCourses(CONSTANTS.showCourseTitle(), CONSTANTS.courseFinderSuggestWhenEmpty(), CONSTANTS.courseFinderShowRequired(), AdvisorCourseRequestLine.this.iSpecReg);
                    CourseSelectionBox.this.iCourseFinderMultipleCourses.setDataProvider(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                        @Override
                        public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                            sSectioningService.listCourseOfferings(AdvisorCourseRequestLine.this.iContext, source, null, callback);
                        }
                    });
                    CourseFinderDetails details = new CourseFinderDetails();
                    details.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, String>(){

                        @Override
                        public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<String> callback) {
                            sSectioningService.retrieveCourseDetails(AdvisorCourseRequestLine.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                        }
                    });
                    CourseFinderClasses classes = new CourseFinderClasses(true, AdvisorCourseRequestLine.this.iSpecReg, CourseSelectionBox.this.iCourseFinderMultipleCourses.getRequiredCheckbox());
                    classes.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                        @Override
                        public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                            sSectioningService.listClasses(AdvisorCourseRequestLine.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                        }
                    });
                    CourseSelectionBox.this.iCourseFinderMultipleCourses.setCourseDetails(details, classes);
                    if (CourseSelectionBox.this.getFreeTimes() != null) {
                        CourseFinderFreeTime free = new CourseFinderFreeTime();
                        free.setDataProvider(CourseSelectionBox.this.getFreeTimes());
                        finder.setTabs(CourseSelectionBox.this.iCourseFinderMultipleCourses, free);
                    } else {
                        finder.setTabs(CourseSelectionBox.this.iCourseFinderMultipleCourses);
                    }
                    return finder;
                }
            });
            this.setSuggestions(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                @Override
                public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                    sSectioningService.listCourseOfferings(AdvisorCourseRequestLine.this.iContext, source, 20, callback);
                }
            });
            this.setSectionsProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                @Override
                public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                    sSectioningService.listClasses(AdvisorCourseRequestLine.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                }
            });
            this.iCourseSelectionHandlerRegistration = this.addCourseSelectionHandler(new CourseSelectionHandler(){

                @Override
                public void onCourseSelection(CourseSelectionEvent event) {
                    CourseSelectionBox prev;
                    CourseSelectionBox next;
                    if (event.isValid()) {
                        CourseSelectionBox.this.setError("");
                    }
                    if ((next = CourseSelectionBox.this.getNext()) != null) {
                        if (event.getValue() == null || event.getValue().isFreeTime()) {
                            next.setHint("");
                        } else {
                            next.resizeFilterIfNeeded();
                            if (event.isValid() && next.getValue().isEmpty()) {
                                prev = CourseSelectionBox.this.getPrevious();
                                if (prev != null) {
                                    next.setHint(MESSAGES.courseRequestsHintAlt2(prev.getText(), CourseSelectionBox.this.getText()));
                                } else {
                                    next.setHint(MESSAGES.courseRequestsHintAlt(CourseSelectionBox.this.getText()));
                                }
                            } else {
                                next.setHint("");
                            }
                        }
                    } else if (CONSTANTS.courseRequestAutomaticallyAddFirstAlternative() && !AdvisorCourseRequestLine.this.iAlternate && event.isValid() && event.getValue().isCourse() && event.getValue().isCanDelete() && CourseSelectionBox.this.getIndex() == 0) {
                        AdvisorCourseRequestLine.this.insertAlternative(AdvisorCourseRequestLine.this.getCourses().size());
                    }
                    prev = CourseSelectionBox.this.getPrevious();
                    if (prev != null) {
                        prev.resizeFilterIfNeeded();
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)AdvisorCourseRequestLine.this, (Object)AdvisorCourseRequestLine.this.getValue());
                    AdvisorCourseRequestLine.this.computeCredits();
                }
            });
            this.addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (CourseSelectionBox.this.getIndex() == 0) {
                        if (AdvisorCourseRequestLine.this.isAlternate() && CourseSelectionBox.this.getValue().isFreeTime()) {
                            return MESSAGES.validationAltFreeTime();
                        }
                    } else {
                        if (!CourseSelectionBox.this.getValue().isEmpty() && CourseSelectionBox.this.getPrevious().getValue().isEmpty()) {
                            if (CourseSelectionBox.this.getIndex() == 2) {
                                return MESSAGES.validationSecondAltWithoutFirst();
                            }
                            return MESSAGES.validationNoCourse();
                        }
                        if (!CourseSelectionBox.this.getValue().isEmpty() && CourseSelectionBox.this.getPrevious().getValue().isFreeTime()) {
                            return MESSAGES.validationFreeTimeWithAlt();
                        }
                        if (CourseSelectionBox.this.getValue().isFreeTime()) {
                            return MESSAGES.validationAltFreeTime();
                        }
                    }
                    return null;
                }
            });
            if (AdvisorCourseRequestLine.this.iValidator != null) {
                this.addValidator(AdvisorCourseRequestLine.this.iValidator);
            }
            if (alternative) {
                this.removeClearOperation();
                CourseRequestBox.FilterOperation moveUp = new CourseRequestBox.FilterOperation(RESOURCES.filterSwap(), Character.valueOf('S')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && !filter.getText().isEmpty() && AdvisorCourseRequestLine.this.iCourses.size() != CourseSelectionBox.this.getIndex() + 1);
                    }
                };
                moveUp.setTitle(MESSAGES.altFilterSwapWithAlternative());
                moveUp.setAltText(MESSAGES.altFilterSwapWithAlternative());
                moveUp.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        if (next != null && next.getValue().isCourse()) {
                            CourseRequestInterface.RequestedCourse rc = CourseSelectionBox.this.getValue();
                            CourseSelectionBox.this.setValue(next.getValue(), true);
                            next.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    next.setFocus(true);
                                }
                            });
                            return;
                        }
                        final CourseSelectionBox prev = CourseSelectionBox.this.getPrevious();
                        if (prev != null) {
                            CourseRequestInterface.RequestedCourse rc = prev.getValue();
                            prev.setValue(CourseSelectionBox.this.getValue(), true);
                            CourseSelectionBox.this.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    prev.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(moveUp, true);
                CourseRequestBox.FilterOperation remove = new CourseRequestBox.FilterOperation(RESOURCES.filterRemoveAlternative(), Character.valueOf('X')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && CourseSelectionBox.this.isEnabled());
                    }
                };
                remove.setTitle(MESSAGES.altFilterRemoveAlternative());
                remove.setAltText(MESSAGES.altFilterRemoveAlternative());
                remove.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox prev = CourseSelectionBox.this.getPrevious();
                        AdvisorCourseRequestLine.this.deleteAlternative(CourseSelectionBox.this.getIndex());
                        if (prev != null) {
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    prev.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(remove, false);
                CourseRequestBox.FilterOperation addAlternative = new CourseRequestBox.FilterOperation(RESOURCES.filterAddAlternative(), Character.valueOf('A')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && CourseSelectionBox.this.getValue().isCourse() && AdvisorCourseRequestLine.this.iCourses.size() == CourseSelectionBox.this.getIndex() + 1);
                    }
                };
                addAlternative.setTitle(MESSAGES.altFilterAddAlternative());
                addAlternative.setAltText(MESSAGES.altFilterAddAlternative());
                addAlternative.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        AdvisorCourseRequestLine.this.insertAlternative(AdvisorCourseRequestLine.this.iCourses.size());
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(AdvisorCourseRequestLine.this.iCourses.size() - 1)).setFocus(true);
                            }
                        });
                    }
                });
                this.addOperation(addAlternative, true);
            } else {
                this.removeClearOperation();
                CourseRequestBox.FilterOperation moveDown = new CourseRequestBox.FilterOperation(RESOURCES.filterSwap(), Character.valueOf('S')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && !filter.getText().isEmpty() && next != null && next.getValue().isCourse());
                    }
                };
                moveDown.setTitle(MESSAGES.altFilterSwapWithAlternative());
                moveDown.setAltText(MESSAGES.altFilterSwapWithAlternative());
                moveDown.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CourseSelectionBox next = CourseSelectionBox.this.getNext();
                        if (next != null) {
                            CourseRequestInterface.RequestedCourse rc = CourseSelectionBox.this.getValue();
                            CourseSelectionBox.this.setValue(next.getValue(), true);
                            next.setValue(rc, true);
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    next.setFocus(true);
                                }
                            });
                        }
                    }
                });
                this.addOperation(moveDown, true);
                CourseRequestBox.FilterOperation remove = new CourseRequestBox.FilterOperation(RESOURCES.filterRemoveAlternative(), Character.valueOf('X')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && CourseSelectionBox.this.isEnabled());
                    }
                };
                remove.setTitle(MESSAGES.altFilterClearCourseRequest());
                remove.setAltText(MESSAGES.altFilterClearCourseRequest());
                remove.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (AdvisorCourseRequestLine.this.iCourses.size() > 1) {
                            CourseRequestInterface.RequestedCourse rc = ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(1)).getValue();
                            CourseSelectionBox.this.setValue(rc, true);
                            AdvisorCourseRequestLine.this.deleteAlternative(1);
                        } else if (!CourseSelectionBox.this.getValue().isEmpty()) {
                            CourseSelectionBox.this.setValue(null, true);
                        } else {
                            AdvisorCourseRequestLine.this.delete();
                        }
                    }
                });
                this.addOperation(remove, false);
                CourseRequestBox.FilterOperation addAlternative = new CourseRequestBox.FilterOperation(RESOURCES.filterAddAlternative(), Character.valueOf('A')){

                    @Override
                    public void onBeforeResize(CourseRequestBox.CourseRequestFilterBox filter) {
                        this.setVisible(CourseSelectionBox.this.isCanChangeAlternatives() && CourseSelectionBox.this.getValue().isCourse() && AdvisorCourseRequestLine.this.iCourses.size() == 1);
                    }
                };
                addAlternative.setTitle(MESSAGES.altFilterAddAlternative());
                addAlternative.setAltText(MESSAGES.altFilterAddAlternative());
                addAlternative.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        AdvisorCourseRequestLine.this.insertAlternative(AdvisorCourseRequestLine.this.iCourses.size());
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(AdvisorCourseRequestLine.this.iCourses.size() - 1)).setFocus(true);
                            }
                        });
                    }
                });
                this.addOperation(addAlternative, true);
            }
            this.iStatus = new CourseRequestBox.FilterStatus(this, RESOURCES.requestEnrolled());
            this.iStatus.clearStatus();
            this.addStatus(this.iStatus);
            this.iError.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    CourseSelectionBox.this.iStatus.click();
                }
            });
        }

        @Override
        public void select(CourseRequestInterface.RequestedCourse rc) {
            if (this.isEnabled()) {
                if (this.iCourseFinderMultipleCourses != null && !this.iCourseFinderMultipleCourses.getCheckedCourses().isEmpty()) {
                    List<CourseRequestInterface.RequestedCourse> list = this.iCourseFinderMultipleCourses.getCheckedCourses();
                    int courses = list.size();
                    int index = AdvisorCourseRequestLine.this.iCourses.indexOf(this);
                    if (index == 0 && courses == 1) {
                        courses = 2;
                    }
                    while (AdvisorCourseRequestLine.this.iCourses.size() < courses + index) {
                        AdvisorCourseRequestLine.this.insertAlternative(AdvisorCourseRequestLine.this.iCourses.size());
                    }
                    while (AdvisorCourseRequestLine.this.iCourses.size() > courses + index) {
                        AdvisorCourseRequestLine.this.deleteAlternative(AdvisorCourseRequestLine.this.iCourses.size() - 1);
                    }
                    for (int i = 0; i < courses; ++i) {
                        ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(index + i)).setValue(i < list.size() ? list.get(i) : null, true);
                    }
                } else {
                    this.setValue(rc, true);
                }
            }
        }

        @Override
        protected void openDialog() {
            if (this.iCourseFinderMultipleCourses != null && this.iCourseFinderMultipleCourses.getLastQuery() != null) {
                int index;
                this.getCourseFinder().setFilter(this.iCourseFinderMultipleCourses.getLastQuery());
                ArrayList<CourseRequestInterface.RequestedCourse> list = new ArrayList<CourseRequestInterface.RequestedCourse>();
                for (int i = index = AdvisorCourseRequestLine.this.iCourses.indexOf(this); i < AdvisorCourseRequestLine.this.iCourses.size(); ++i) {
                    CourseSelectionBox box = (CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(i);
                    CourseRequestInterface.RequestedCourse rc = box.getValue();
                    if (rc == null || !rc.isCourse()) continue;
                    list.add(rc);
                }
                if (this.iCourseFinderMultipleCourses.setCheckedCourses(list)) {
                    this.getCourseFinder().setEnabled(this.isEnabled());
                    this.getCourseFinder().findCourse();
                    this.iCourseFinderMultipleCourses.scrollToSelectedRow();
                } else {
                    super.openDialog();
                }
            } else {
                super.openDialog();
            }
        }

        public void setStatus(ImageResource icon, String message) {
            if (this.iStatus != null) {
                this.iStatus.setStatus(icon, message);
                this.iError.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                this.resizeFilterIfNeeded();
            }
        }

        public void clearStatus() {
            if (this.iStatus != null) {
                this.iStatus.clearStatus();
                this.iError.getElement().getStyle().clearCursor();
                this.resizeFilterIfNeeded();
            }
        }

        @Override
        public void setValue(CourseRequestInterface.RequestedCourse rc) {
            CourseSelectionBox prev;
            super.setValue(rc);
            if (rc == null || rc.getStatus() == null) {
                this.clearStatus();
            } else {
                switch (rc.getStatus()) {
                    case ENROLLED: {
                        this.setStatus(RESOURCES.requestEnrolled(), MESSAGES.enrolled(rc.getCourseName()));
                        break;
                    }
                    case OVERRIDE_REJECTED: {
                        this.setStatus(RESOURCES.requestRejected(), MESSAGES.overrideRejected(rc.getCourseName()));
                        break;
                    }
                    case OVERRIDE_PENDING: {
                        this.setStatus(RESOURCES.requestPending(), MESSAGES.overridePending(rc.getCourseName()));
                        break;
                    }
                    case OVERRIDE_CANCELLED: {
                        this.setStatus(RESOURCES.requestCancelled(), MESSAGES.overrideCancelled(rc.getCourseName()));
                        break;
                    }
                    case OVERRIDE_APPROVED: {
                        this.setStatus(RESOURCES.requestSaved(), MESSAGES.overrideApproved(rc.getCourseName()));
                        break;
                    }
                    case NEW_REQUEST: {
                        this.clearStatus();
                        break;
                    }
                    default: {
                        if (rc.isCourse()) {
                            this.setStatus(RESOURCES.requestSaved(), MESSAGES.requested(rc.getCourseName()));
                            break;
                        }
                        if (!rc.isFreeTime()) break;
                        String free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!free.isEmpty()) {
                                free = free + ", ";
                            }
                            free = free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        this.setStatus(RESOURCES.requestSaved(), MESSAGES.requested(CONSTANTS.freePrefix() + free));
                    }
                }
            }
            if (rc != null && rc.isFreeTime()) {
                for (int i = AdvisorCourseRequestLine.this.iCourses.size() - 1; i > 0; --i) {
                    AdvisorCourseRequestLine.this.deleteAlternative(i);
                }
            }
            if ((prev = this.getPrevious()) != null) {
                if (rc != null && rc.isReadOnly() || prev.getValue().isFreeTime()) {
                    this.setHint("");
                } else if (this.getIndex() == 1) {
                    this.setHint(MESSAGES.courseRequestsHintAlt(prev.getText()));
                } else if (this.getIndex() == 2) {
                    this.setHint(MESSAGES.courseRequestsHintAlt2(((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(0)).getText(), ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(1)).getText()));
                } else {
                    this.setHint(MESSAGES.courseRequestsHintAlt3(((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(0)).getText(), ((CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(1)).getText()));
                }
            }
        }

        public int getIndex() {
            return AdvisorCourseRequestLine.this.iCourses.indexOf(this);
        }

        public CourseSelectionBox getPrevious() {
            return this.getIndex() > 0 ? (CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(this.getIndex() - 1) : null;
        }

        public CourseSelectionBox getNext() {
            return this.getIndex() + 1 < AdvisorCourseRequestLine.this.iCourses.size() ? (CourseSelectionBox)AdvisorCourseRequestLine.this.iCourses.get(this.getIndex() + 1) : null;
        }

        public void dispose() {
            this.iCourseSelectionHandlerRegistration.removeHandler();
        }

        public void setErrors(CourseRequestInterface.CheckCoursesResponse messages) {
            String message = null;
            for (CourseRequestInterface.CourseMessage m : messages.getMessages(this.getText())) {
                if (message == null) {
                    message = m.getMessage();
                    continue;
                }
                message = message + "\n" + m.getMessage();
            }
            if (message != null) {
                String note = "";
                if (this.getValue().hasStatusNote()) {
                    note = note + "\n<span class='status-note'>" + this.getValue().getStatusNote() + "</span>";
                }
                if (messages.isError(this.getText())) {
                    this.setError(message + note);
                } else {
                    this.setWarning(message + note);
                }
            } else {
                this.setInfo(null);
            }
        }
    }
}

