/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class PreferencesForm
extends ActionForm {
    private static final long serialVersionUID = -3578647598790726006L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op;
    protected List timePatterns;
    protected List roomGroups;
    protected List roomGroupLevels;
    protected List roomPrefs;
    protected List roomPrefLevels;
    protected List bldgPrefs;
    protected List bldgPrefLevels;
    protected List roomFeaturePrefs;
    protected List roomFeaturePrefLevels;
    protected String timePattern;
    protected List availableTimePatterns;
    protected List distPrefs;
    protected List distPrefLevels;
    protected List datePatternPrefs;
    protected List datePatternPrefLevels;
    protected List coursePrefs;
    protected List coursePrefLevels;
    protected List instructorPrefs;
    protected List instructorPrefLevels;
    protected List attributePrefs;
    protected List attributePrefLevels;
    protected String availability;
    private String nextId;
    private String previousId;
    protected boolean allowHardPrefs;
    private boolean hasNotAvailable;
    protected DynamicListObjectFactory factoryPref = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("-");
        }
    };
    protected DynamicListObjectFactory factoryPrefLevel = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String(PreferenceLevel.PREF_LEVEL_NEUTRAL);
        }
    };
    protected DynamicListObjectFactory factoryPattern = new DynamicListObjectFactory(){

        @Override
        public Object create() {
            return new String("-1");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        List lst = this.getRoomGroups();
        if (!this.checkPrefs(lst)) {
            errors.add("roomGroups", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomGroup()));
        }
        if (!this.checkPrefLevels(this.getRoomGroupLevels(), lst)) {
            errors.add("roomGroups", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomGroupLevel()));
        }
        lst = this.getBldgPrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("bldgPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidBuildingPreference()));
        }
        if (!this.checkPrefLevels(this.getBldgPrefLevels(), lst)) {
            errors.add("bldgPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidBuildingPreferenceLevel()));
        }
        lst = this.getRoomPrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("roomPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomPreference()));
        }
        if (!this.checkPrefLevels(this.getRoomPrefLevels(), lst)) {
            errors.add("roomPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomPreferenceLevel()));
        }
        lst = this.getRoomFeaturePrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("roomFeaturePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomFeaturePreference()));
        }
        if (!this.checkPrefLevels(this.getRoomFeaturePrefLevels(), lst)) {
            errors.add("roomFeaturePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomFeaturePreferenceLevel()));
        }
        lst = this.getDistPrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("distPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidDistributionPreference()));
        }
        if (!this.checkPrefLevels(this.getDistPrefLevels(), lst)) {
            errors.add("distPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidDistributionPreferenceLevel()));
        }
        lst = this.getCoursePrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("coursePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidCoursePreference()));
        }
        if (!this.checkPrefLevels(this.getCoursePrefLevels(), lst)) {
            errors.add("coursePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidCoursePreferenceLevel()));
        }
        lst = this.getInstructorPrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("instructorPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidInstructorPreference()));
        }
        if (!this.checkPrefLevels(this.getInstructorPrefLevels(), lst)) {
            errors.add("instructorPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidInstructorPreferenceLevel()));
        }
        lst = this.getAttributePrefs();
        if (!this.checkPrefs(lst)) {
            errors.add("attributePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidAttributePreference()));
        }
        if (!this.checkPrefLevels(this.getAttributePrefLevels(), lst)) {
            errors.add("attributePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidAttributePreferenceLevel()));
        }
        for (int i = 0; i < this.getTimePatterns().size(); ++i) {
            if (request.getParameter("p" + i + "_hour") == null) continue;
            boolean daySelected = false;
            for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                if (request.getParameter("p" + i + "_d" + j) == null) continue;
                daySelected = true;
            }
            if (!daySelected) {
                errors.add("timePrefs", new ActionMessage("errors.generic", (Object)"No day is selected in time preferences."));
                break;
            }
            if ("".equals(request.getParameter("p" + i + "_hour"))) {
                errors.add("timePrefs", new ActionMessage("errors.generic", (Object)"No time is selected in time preferences."));
                break;
            }
            if ("".equals(request.getParameter("p" + i + "_min"))) {
                errors.add("timePrefs", new ActionMessage("errors.generic", (Object)"No time is selected in time preferences."));
                break;
            }
            if (!"".equals(request.getParameter("p" + i + "_morn"))) continue;
            errors.add("timePrefs", new ActionMessage("errors.generic", (Object)"No time is selected in time preferences."));
            break;
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "";
        this.timePattern = null;
        this.timePatterns = DynamicList.getInstance(new ArrayList(), this.factoryPattern);
        this.availableTimePatterns = DynamicList.getInstance(new ArrayList(), this.factoryPattern);
        this.roomPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.roomPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.bldgPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.bldgPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.roomFeaturePrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.roomFeaturePrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.roomGroups = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.roomGroupLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.distPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.distPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.datePatternPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.datePatternPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.coursePrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.coursePrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.attributePrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.attributePrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.instructorPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
        this.instructorPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
        this.previousId = null;
        this.nextId = null;
        this.allowHardPrefs = true;
        this.hasNotAvailable = false;
        this.addBlankPrefRows();
        this.availability = null;
    }

    public boolean checkPrefs(List ... lst) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < lst[0].size(); ++i) {
            String value = (String)lst[0].get(i);
            if (value == null || value.trim().equals("-")) continue;
            for (int j = 1; j < lst.length; ++j) {
                value = value + "|" + (String)lst[j].get(i);
            }
            if (map.get(value.trim()) != null) {
                return false;
            }
            map.put(value, value);
        }
        return true;
    }

    public boolean checkPrefLevels(List lst, List prefList) {
        for (int i = 0; i < lst.size(); ++i) {
            String id = (String)prefList.get(i);
            String value = (String)lst.get(i);
            if (id == null || id.trim().equals("-") || value != null && !value.trim().equals("-")) continue;
            return false;
        }
        return true;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List getTimePatterns() {
        return this.timePatterns == null ? new Vector() : this.timePatterns;
    }

    public void setTimePatterns(List timePatterns) {
        this.timePatterns = timePatterns;
    }

    public List getAvailableTimePatterns() {
        return this.availableTimePatterns;
    }

    public boolean getCanChooseTimePattern() {
        return this.availableTimePatterns != null;
    }

    public List getAvailableNotSelectedTimePatterns() {
        if (this.timePatterns == null || this.timePatterns.isEmpty()) {
            return this.getAvailableTimePatterns();
        }
        Vector<TimePattern> ret = new Vector<TimePattern>();
        for (TimePattern pattern : this.availableTimePatterns) {
            if (!pattern.getTimePatternModel().isExactTime() && this.timePatterns.contains(pattern.getUniqueId().toString())) continue;
            ret.add(pattern);
        }
        return ret;
    }

    public void setAvailableTimePatterns(List availableTimePatterns) {
        this.availableTimePatterns = availableTimePatterns;
    }

    public String getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(String timePattern) {
        this.timePattern = timePattern;
    }

    public List getRoomGroups() {
        return this.roomGroups;
    }

    public void setRoomGroups(List roomGroups) {
        this.roomGroups = roomGroups;
    }

    public void setRoomGroups(int key, Object value) {
        Debug.debug("setting room group: " + key);
        this.roomGroups.set(key, value);
    }

    public List getRoomGroupLevels() {
        return this.roomGroupLevels;
    }

    public String getRoomGroupLevels(int key) {
        return this.roomGroupLevels.get(key).toString();
    }

    public void setRoomGroupLevels(int key, Object value) {
        this.roomGroupLevels.set(key, value);
    }

    public String getRoomGroups(int key) {
        return this.roomGroups.get(key).toString();
    }

    public void setRoomGroupLevels(List roomGroupLevels) {
        this.roomGroupLevels = roomGroupLevels;
    }

    public List getBldgPrefs() {
        return this.bldgPrefs;
    }

    public String getBldgPrefs(int key) {
        return this.bldgPrefs.get(key).toString();
    }

    public void setBldgPrefs(int key, Object value) {
        this.bldgPrefs.set(key, value);
    }

    public void setBldgPrefs(List bldgPrefs) {
        this.bldgPrefs = bldgPrefs;
    }

    public List getDistPrefs() {
        return this.distPrefs;
    }

    public String getDistPrefs(int key) {
        return this.distPrefs.get(key).toString();
    }

    public void setDistPrefs(int key, Object value) {
        this.distPrefs.set(key, value);
    }

    public void setDistPrefs(List distPrefs) {
        this.distPrefs = distPrefs;
    }

    public List getCoursePrefs() {
        return this.coursePrefs;
    }

    public String getCoursePrefs(int key) {
        return this.coursePrefs.get(key).toString();
    }

    public void setCoursePrefs(int key, Object value) {
        this.coursePrefs.set(key, value);
    }

    public void setCoursePrefs(List coursePrefs) {
        this.coursePrefs = coursePrefs;
    }

    public List getInstructorPrefs() {
        return this.instructorPrefs;
    }

    public String getInstructorPrefs(int key) {
        return this.instructorPrefs.get(key).toString();
    }

    public void setInstructorPrefs(int key, Object value) {
        this.instructorPrefs.set(key, value);
    }

    public void setInstructorPrefs(List instructorPrefs) {
        this.instructorPrefs = instructorPrefs;
    }

    public List getAttributePrefs() {
        return this.attributePrefs;
    }

    public String getAttributePrefs(int key) {
        return this.attributePrefs.get(key).toString();
    }

    public void setAttributePrefs(int key, Object value) {
        this.attributePrefs.set(key, value);
    }

    public void setAttributePrefs(List attributePrefs) {
        this.attributePrefs = attributePrefs;
    }

    public List getRoomPrefs() {
        return this.roomPrefs;
    }

    public String getRoomPrefs(int key) {
        Debug.debug("getting room pref: " + key);
        return this.roomPrefs.get(key).toString();
    }

    public void setRoomPrefs(int key, Object value) {
        Debug.debug("setting room pref: " + key);
        this.roomPrefs.set(key, value);
    }

    public void setRoomPrefs(List roomPrefs) {
        this.roomPrefs = roomPrefs;
    }

    public List getRoomFeaturePrefs() {
        return this.roomFeaturePrefs;
    }

    public String getRoomFeaturePrefs(int key) {
        return this.roomFeaturePrefs.get(key).toString();
    }

    public void setRoomFeaturePrefs(int key, Object value) {
        this.roomFeaturePrefs.set(key, value);
    }

    public void setRoomFeaturePrefs(List roomFeaturePrefs) {
        this.roomFeaturePrefs = roomFeaturePrefs;
    }

    public List getRoomPrefLevels() {
        return this.roomPrefLevels;
    }

    public String getRoomPrefLevels(int key) {
        return this.roomPrefLevels.get(key).toString();
    }

    public void setRoomPrefLevels(int key, Object value) {
        this.roomPrefLevels.set(key, value);
    }

    public void setRoomPrefLevels(List roomPrefLevels) {
        this.roomPrefLevels = roomPrefLevels;
    }

    public List getBldgPrefLevels() {
        return this.bldgPrefLevels;
    }

    public String getBldgPrefLevels(int key) {
        return this.bldgPrefLevels.get(key).toString();
    }

    public void setBldgPrefLevels(int key, Object value) {
        this.bldgPrefLevels.set(key, value);
    }

    public void setBldgPrefLevels(List bldgPrefLevels) {
        this.bldgPrefLevels = bldgPrefLevels;
    }

    public List getDistPrefLevels() {
        return this.distPrefLevels;
    }

    public String getDistPrefLevels(int key) {
        return this.distPrefLevels.get(key).toString();
    }

    public void setDistPrefLevels(int key, Object value) {
        this.distPrefLevels.set(key, value);
    }

    public void setDistPrefLevels(List distPrefLevels) {
        this.distPrefLevels = distPrefLevels;
    }

    public List getCoursePrefLevels() {
        return this.coursePrefLevels;
    }

    public String getCoursePrefLevels(int key) {
        return this.coursePrefLevels.get(key).toString();
    }

    public void setCoursePrefLevels(int key, Object value) {
        this.coursePrefLevels.set(key, value);
    }

    public void setCoursePrefLevels(List coursePrefLevels) {
        this.coursePrefLevels = coursePrefLevels;
    }

    public List getInstructorPrefLevels() {
        return this.instructorPrefLevels;
    }

    public String getInstructorPrefLevels(int key) {
        return this.instructorPrefLevels.get(key).toString();
    }

    public void setInstructorPrefLevels(int key, Object value) {
        this.instructorPrefLevels.set(key, value);
    }

    public void setInstructorPrefLevels(List instructorPrefLevels) {
        this.instructorPrefLevels = instructorPrefLevels;
    }

    public List getAttributePrefLevels() {
        return this.attributePrefLevels;
    }

    public String getAttributePrefLevels(int key) {
        return this.attributePrefLevels.get(key).toString();
    }

    public void setAttributePrefLevels(int key, Object value) {
        this.attributePrefLevels.set(key, value);
    }

    public void setAttributePrefLevels(List attributePrefLevels) {
        this.attributePrefLevels = attributePrefLevels;
    }

    public List getRoomFeaturePrefLevels() {
        return this.roomFeaturePrefLevels;
    }

    public String getRoomFeaturePrefLevels(int key) {
        return this.roomFeaturePrefLevels.get(key).toString();
    }

    public void setRoomFeaturePrefLevels(int key, Object value) {
        this.roomFeaturePrefLevels.set(key, value);
    }

    public void setRoomFeaturePrefLevels(List roomFeaturePrefLevels) {
        this.roomFeaturePrefLevels = roomFeaturePrefLevels;
    }

    public List getDatePatternPrefs() {
        return this.datePatternPrefs;
    }

    public String getDatePatternPrefs(int key) {
        return this.datePatternPrefs.get(key).toString();
    }

    public void setDatePatternPrefs(int key, Object value) {
        this.datePatternPrefs.set(key, value);
    }

    public void setDatePatternPrefs(List datePatternPrefs) {
        this.datePatternPrefs = datePatternPrefs;
    }

    public List getDatePatternPrefLevels() {
        return this.datePatternPrefLevels;
    }

    public String getDatePatternPrefLevels(int key) {
        return this.datePatternPrefLevels.get(key).toString();
    }

    public void setDatePatternPrefLevels(List datePatternPrefLevels) {
        this.datePatternPrefLevels = datePatternPrefLevels;
    }

    public void setDatePatternPrefLevels(int key, Object value) {
        this.datePatternPrefLevels.set(key, value);
    }

    public void addToRoomPrefs(String roomPref, String level) {
        this.roomPrefs.add(roomPref);
        this.roomPrefLevels.add(level);
    }

    public void addToRoomFeatPrefs(String roomFeatPref, String level) {
        this.roomFeaturePrefs.add(roomFeatPref);
        this.roomFeaturePrefLevels.add(level);
    }

    public void addToRoomGroups(String roomGroup, String level) {
        this.roomGroups.add(roomGroup);
        this.roomGroupLevels.add(level);
    }

    public void addToBldgPrefs(String bldgPref, String level) {
        this.bldgPrefs.add(bldgPref);
        this.bldgPrefLevels.add(level);
    }

    public void addToDistPrefs(String distPref, String level) {
        this.distPrefs.add(distPref);
        this.distPrefLevels.add(level);
    }

    public void addToCoursePrefs(String coursePref, String level) {
        this.coursePrefs.add(coursePref);
        this.coursePrefLevels.add(level);
    }

    public void addToInstructorPrefs(String instructorPref, String level) {
        this.instructorPrefs.add(instructorPref);
        this.instructorPrefLevels.add(level);
    }

    public void addToAttributePrefs(String attributePref, String level) {
        this.attributePrefs.add(attributePref);
        this.attributePrefLevels.add(level);
    }

    public void addToDatePatternPrefs(String datePatternPref, String level) {
        this.datePatternPrefs.add(datePatternPref);
        this.datePatternPrefLevels.add(level);
    }

    public void sortDatePatternPrefs(List prefs, List prefLevels, List<DatePattern> patterns) {
        if (prefs.size() == patterns.size()) {
            Collections.sort(patterns);
            List newPrefs = DynamicList.getInstance(new ArrayList(), this.factoryPref);
            List newPrefLevels = DynamicList.getInstance(new ArrayList(), this.factoryPrefLevel);
            newPrefs.addAll(prefs);
            for (int i = 0; i < newPrefs.size(); ++i) {
                String ith_pattern = patterns.get(i).getUniqueId().toString();
                int indexOfPatternInPrefs = prefs.indexOf(ith_pattern);
                newPrefs.set(i, ith_pattern);
                newPrefLevels.set(i, prefLevels.get(indexOfPatternInPrefs));
            }
            prefs.clear();
            prefLevels.clear();
            prefs.addAll(newPrefs);
            prefLevels.addAll(newPrefLevels);
        }
    }

    public void addBlankPrefRows() {
        for (int i = 0; i < 2; ++i) {
            this.addToBldgPrefs("-", "-");
            this.addToRoomPrefs("-", "-");
            this.addToRoomFeatPrefs("-", "-");
            this.addToRoomGroups("-", "-");
            this.addToDistPrefs("-", "-");
            this.addToCoursePrefs("-", "-");
            this.addToAttributePrefs("-", "-");
            this.addToInstructorPrefs("-", "-");
        }
    }

    public void clearPrefs() {
        this.timePatterns.clear();
        this.roomGroups.clear();
        this.bldgPrefs.clear();
        this.bldgPrefLevels.clear();
        this.distPrefs.clear();
        this.distPrefLevels.clear();
        this.roomPrefs.clear();
        this.roomPrefLevels.clear();
        this.roomFeaturePrefs.clear();
        this.roomFeaturePrefLevels.clear();
        this.datePatternPrefs.clear();
        this.datePatternPrefLevels.clear();
        this.coursePrefs.clear();
        this.coursePrefLevels.clear();
        this.instructorPrefs.clear();
        this.instructorPrefLevels.clear();
        this.attributePrefs.clear();
        this.attributePrefLevels.clear();
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getPreviousId() {
        return this.previousId;
    }

    public void setPreviousId(String previousId) {
        this.previousId = previousId;
    }

    public boolean getAllowHardPrefs() {
        return this.allowHardPrefs;
    }

    public void setAllowHardPrefs(boolean allowHardPrefs) {
        this.allowHardPrefs = allowHardPrefs;
    }

    public boolean getHasNotAvailable() {
        return this.hasNotAvailable;
    }

    public void setHasNotAvailable(boolean hasNotAvailable) {
        this.hasNotAvailable = hasNotAvailable;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }
}

