/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InstructionalOfferingListFormInterface;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.comparators.ClassCourseComparator;

public class InstructionalOfferingListForm
extends ActionForm
implements InstructionalOfferingListFormInterface {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = -6985831814265952068L;
    private Map<Long, TreeSet<InstructionalOffering>> instructionalOfferings;
    private Collection subjectAreas;
    private String[] subjectAreaIds;
    private String courseNbr;
    private Boolean showNotOffered;
    private String buttonAction;
    private String subjectAreaAbbv;
    private Boolean isControl;
    private String ctrlInstrOfferingId;
    private Boolean divSec;
    private Boolean demand;
    private Boolean projectedDemand;
    private Boolean minPerWk;
    private Boolean limit;
    private Boolean snapshotLimit;
    private Boolean roomLimit;
    private Boolean manager;
    private Boolean datePattern;
    private Boolean timePattern;
    private Boolean preferences;
    private Boolean instructor;
    private Boolean timetable;
    private Boolean credit;
    private Boolean subpartCredit;
    private Boolean schedulePrintNote;
    private Boolean note;
    private Boolean consent;
    private Boolean title;
    private Boolean exams;
    private String sortBy;
    private Boolean instructorAssignment;
    private Boolean lms;

    @Override
    public Boolean getLms() {
        return this.lms;
    }

    public void setLms(Boolean lms) {
        this.lms = lms;
    }

    public String getCtrlInstrOfferingId() {
        return this.ctrlInstrOfferingId;
    }

    public void setCtrlInstrOfferingId(String ctrlInstrOfferingId) {
        this.ctrlInstrOfferingId = ctrlInstrOfferingId;
    }

    public Boolean getIsControl() {
        return this.isControl;
    }

    public void setIsControl(Boolean isControl) {
        this.isControl = isControl;
    }

    public String getSubjectAreaAbbv() {
        return this.subjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.subjectAreaAbbv = subjectAreaAbbv;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
            courseNbr = courseNbr.toUpperCase();
        }
        this.courseNbr = courseNbr;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.courseNbr = "";
        this.instructionalOfferings = null;
        this.subjectAreas = new ArrayList();
        this.divSec = new Boolean(false);
        this.demand = new Boolean(false);
        this.projectedDemand = new Boolean(false);
        this.minPerWk = new Boolean(false);
        this.limit = new Boolean(false);
        this.snapshotLimit = new Boolean(false);
        this.roomLimit = new Boolean(false);
        this.manager = new Boolean(false);
        this.datePattern = new Boolean(false);
        this.timePattern = new Boolean(false);
        this.preferences = new Boolean(false);
        this.instructor = new Boolean(false);
        this.timetable = new Boolean(false);
        this.credit = new Boolean(false);
        this.subpartCredit = new Boolean(false);
        this.schedulePrintNote = new Boolean(false);
        this.note = new Boolean(false);
        this.title = new Boolean(false);
        this.consent = new Boolean(false);
        this.exams = new Boolean(false);
        this.instructorAssignment = new Boolean(false);
        this.lms = new Boolean(false);
        this.sortBy = ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME);
    }

    public Map<Long, TreeSet<InstructionalOffering>> getInstructionalOfferings() {
        return this.instructionalOfferings;
    }

    public TreeSet<InstructionalOffering> getInstructionalOfferings(Long subjectAreaId) {
        return this.instructionalOfferings == null ? null : this.instructionalOfferings.get(subjectAreaId);
    }

    public void setInstructionalOfferings(Map<Long, TreeSet<InstructionalOffering>> instructionalOfferings) {
        this.instructionalOfferings = instructionalOfferings;
    }

    public Collection getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public Boolean getShowNotOffered() {
        return this.showNotOffered;
    }

    public void setShowNotOffered(Boolean showNotOffered) {
        this.showNotOffered = showNotOffered;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.subjectAreaIds == null || this.subjectAreaIds.length == 0) {
            errors.add("subjectAreaIds", new ActionMessage("errors.required", (Object)MSG.labelSubjectArea()));
        }
        return errors;
    }

    @Override
    public Boolean getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(Boolean datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    public Boolean getDemand() {
        return this.demand;
    }

    public void setDemand(Boolean demand) {
        this.demand = demand;
    }

    @Override
    public Boolean getDivSec() {
        return this.divSec;
    }

    public void setDivSec(Boolean divSec) {
        this.divSec = divSec;
    }

    @Override
    public Boolean getInstructor() {
        return this.instructor;
    }

    public void setInstructor(Boolean instructor) {
        this.instructor = instructor;
    }

    @Override
    public Boolean getLimit() {
        return this.limit;
    }

    public void setLimit(Boolean limit) {
        this.limit = limit;
    }

    @Override
    public Boolean getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public void setSnapshotLimit(Boolean snapshotLimit) {
        this.snapshotLimit = snapshotLimit;
    }

    @Override
    public Boolean getManager() {
        return this.manager;
    }

    public void setManager(Boolean manager) {
        this.manager = manager;
    }

    @Override
    public Boolean getMinPerWk() {
        return this.minPerWk;
    }

    public void setMinPerWk(Boolean minPerWk) {
        this.minPerWk = minPerWk;
    }

    @Override
    public Boolean getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Boolean preferences) {
        this.preferences = preferences;
    }

    @Override
    public Boolean getProjectedDemand() {
        return this.projectedDemand;
    }

    public void setProjectedDemand(Boolean projectedDemand) {
        this.projectedDemand = projectedDemand;
    }

    @Override
    public Boolean getRoomLimit() {
        return this.roomLimit;
    }

    public void setRoomLimit(Boolean roomLimit) {
        this.roomLimit = roomLimit;
    }

    @Override
    public Boolean getTimePattern() {
        return this.timePattern;
    }

    public void setTimePattern(Boolean timePattern) {
        this.timePattern = timePattern;
    }

    @Override
    public Boolean getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Boolean timetable) {
        this.timetable = timetable;
    }

    @Override
    public Boolean getCredit() {
        return this.credit;
    }

    public void setCredit(Boolean credit) {
        this.credit = credit;
    }

    @Override
    public Boolean getSubpartCredit() {
        return this.subpartCredit;
    }

    public void setSubpartCredit(Boolean subpartCredit) {
        this.subpartCredit = subpartCredit;
    }

    @Override
    public Boolean getSchedulePrintNote() {
        return this.schedulePrintNote;
    }

    public void setSchedulePrintNote(Boolean schedulePrintNote) {
        this.schedulePrintNote = schedulePrintNote;
    }

    @Override
    public Boolean getNote() {
        return this.note;
    }

    public void setNote(Boolean note) {
        this.note = note;
    }

    @Override
    public Boolean getConsent() {
        return this.consent;
    }

    public void setConsent(Boolean consent) {
        this.consent = consent;
    }

    @Override
    public Boolean getTitle() {
        return this.title;
    }

    public void setTitle(Boolean title) {
        this.title = title;
    }

    @Override
    public Boolean getExams() {
        return this.exams;
    }

    public void setExams(Boolean exams) {
        this.exams = exams;
    }

    @Override
    public Boolean getInstructorAssignment() {
        return this.instructorAssignment;
    }

    public void setInstructorAssignment(Boolean instructorAssignment) {
        this.instructorAssignment = instructorAssignment;
    }

    protected void finalize() throws Throwable {
        Debug.debug("!!! Finalizing InstructionalOfferingListForm ... ");
        this.instructionalOfferings = null;
        this.subjectAreas = null;
        this.subjectAreaIds = new String[0];
        this.courseNbr = null;
        this.showNotOffered = null;
        this.buttonAction = null;
        this.subjectAreaAbbv = null;
        this.isControl = null;
        this.ctrlInstrOfferingId = null;
        this.divSec = null;
        this.demand = null;
        this.projectedDemand = null;
        this.minPerWk = null;
        this.limit = null;
        this.snapshotLimit = null;
        this.roomLimit = null;
        this.manager = null;
        this.datePattern = null;
        this.timePattern = null;
        this.preferences = null;
        this.instructor = null;
        this.timetable = null;
        this.credit = null;
        this.subpartCredit = null;
        this.schedulePrintNote = null;
        this.note = null;
        this.title = null;
        this.consent = null;
        this.instructorAssignment = null;
        this.lms = null;
        super.finalize();
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String[] getSortByOptions() {
        return ClassCourseComparator.getNames();
    }

    public Boolean getEnrollmentInformation() {
        return new Boolean(this.getDemand() != false && this.getProjectedDemand() != false && this.getLimit() != false && this.getRoomLimit() != false);
    }

    public void setEnrollmentInformation() {
    }

    public Boolean getDateTimeInformation() {
        return new Boolean(this.getDatePattern() != false && this.getMinPerWk() != false && this.getTimePattern() != false);
    }

    public void setDateTimeInformation() {
    }

    public Boolean getCatalogInformation() {
        return new Boolean(this.getTitle() != false && this.getCredit() != false && this.getSubpartCredit() != false && this.getConsent() != false && this.getSchedulePrintNote() != false) != false && this.getLms() != false;
    }

    public void setCatalogInformation() {
    }
}

