/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.FlushMode;
import org.unitime.timetable.dataexchange.EventRelatedImports;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SpecialEvent;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.util.CalendarUtils;

public class EventImport
extends EventRelatedImports {
    private static final String specialEventElementName = "specialEvent";
    private static final String courseRelatedEventElementName = "courseRelatedEvent";
    private static final String meetingElementName = "meeting";
    private static final String noteElementName = "note";
    private static final String eventContactElementName = "eventContact";
    private static final String sponsoringOrgElementName = "sponsoringOrganization";
    private static final String courseElementName = "course";
    private String academicInitiative = null;
    private ExternalUidLookup iLookup = null;

    public EventImport() {
        String className = ApplicationProperty.InstructorExternalIdLookupClass.value();
        if (className != null) {
            try {
                this.iLookup = (ExternalUidLookup)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                this.warn("Unable to instantiate external id lookup: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void loadXml(Element rootElement) throws Exception {
        this.trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
        int loadedCount = 0;
        int recordCount = 0;
        try {
            String rootElementName = "events";
            if (!rootElement.getName().equalsIgnoreCase(rootElementName)) {
                throw new Exception("Given XML file is not a Events load file.");
            }
            this.academicInitiative = this.getRequiredStringAttribute(rootElement, "academicInitiative", rootElementName);
            this.dateFormat = this.getOptionalStringAttribute(rootElement, "dateFormat");
            this.timeFormat = this.getOptionalStringAttribute(rootElement, "timeFormat");
            String created = this.getOptionalStringAttribute(rootElement, "created");
            if (this.timeFormat == null) {
                this.timeFormat = "HHmm";
            }
            this.beginTransaction();
            if (this.session == null) {
                this.session = this.findDefaultSession(this.academicInitiative, new Date());
            }
            if (created != null) {
                this.addNote("Loading Events XML file created on: " + created);
                ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, this.session, created, ChangeLog.Source.DATA_IMPORT_EVENTS, ChangeLog.Operation.CREATE, null, null);
                this.updateChangeList(true);
            }
            Iterator it = rootElement.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                Event event = null;
                if (!element.getName().equalsIgnoreCase(specialEventElementName) && !element.getName().equalsIgnoreCase(courseRelatedEventElementName)) {
                    throw new Exception("Expecting to find a 'specialEvent' or a 'courseRelatedEvent' at this level, instead found '" + element.getName() + "'.");
                }
                if (element.getName().equalsIgnoreCase(specialEventElementName)) {
                    event = this.elementSpecialEvent(element);
                } else if (element.getName().equalsIgnoreCase(courseRelatedEventElementName)) {
                    event = this.elementCourseRelatedEvent(element);
                }
                if (event != null) {
                    ++loadedCount;
                }
                ++recordCount;
                this.flushIfNeeded(true);
                this.updateChangeList(true);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
        this.addNote("Events Added: " + loadedCount + " of " + recordCount + " possible events.");
        this.updateChangeList(true);
        this.reportMissingLocations();
        this.mailLoadResults();
    }

    private Event elementSpecialEvent(Element specialEventElement) throws Exception {
        if (!specialEventElement.getName().equalsIgnoreCase(specialEventElementName)) {
            this.addNote("Not Loading " + specialEventElement.getName() + " Error:  attempted to load as " + specialEventElementName);
            this.addNote("\t " + specialEventElement.getText());
            return null;
        }
        String eventName = null;
        try {
            eventName = this.getRequiredStringAttribute(specialEventElement, "eventName", specialEventElementName);
        }
        catch (Exception e) {
            this.addNote("Not Loading specialEvent Error:  " + e.getMessage());
            this.addNote("\t " + specialEventElement.asXML());
            return null;
        }
        Integer minCapacity = this.getOptionalIntegerAttribute(specialEventElement, "minCapacity");
        Integer maxCapacity = this.getOptionalIntegerAttribute(specialEventElement, "maxCapacity");
        String email = this.getOptionalStringAttribute(specialEventElement, "email");
        SpecialEvent event = new SpecialEvent();
        event.setEventName(eventName);
        event.setMinCapacity(minCapacity);
        event.setMaxCapacity(maxCapacity);
        event.setEmail(email);
        try {
            this.elementMeetings(specialEventElement, event);
            Element eventContactElement = specialEventElement.element(eventContactElementName);
            if (eventContactElement != null) {
                event.setMainContact(this.elementEventContact(eventContactElement));
            }
            this.elementAdditionalEventContacts(specialEventElement, event);
            Element sponsoringOrgElement = specialEventElement.element(sponsoringOrgElementName);
            if (sponsoringOrgElement != null) {
                this.elementSponsoringOrganization(sponsoringOrgElement, event);
            }
            this.elementNotes(specialEventElement, event);
        }
        catch (Exception e) {
            this.addNote("Not Loading specialEvent Error:  " + e.getMessage());
            this.addNote("\t " + specialEventElement.asXML());
            return null;
        }
        this.getHibSession().save((Object)event);
        return event;
    }

    private Event elementCourseRelatedEvent(Element specialEventElement) throws Exception {
        if (!specialEventElement.getName().equalsIgnoreCase(courseRelatedEventElementName)) {
            this.addNote("Not Loading " + specialEventElement.getName() + " Error:  attempted to load as " + courseRelatedEventElementName);
            this.addNote("\t " + specialEventElement.getText());
            return null;
        }
        String eventName = null;
        try {
            eventName = this.getRequiredStringAttribute(specialEventElement, "eventName", courseRelatedEventElementName);
        }
        catch (Exception e) {
            this.addNote("Not Loading courseRelatedEvent Error:  " + e.getMessage());
            this.addNote("\t " + specialEventElement.asXML());
            return null;
        }
        Integer minCapacity = this.getOptionalIntegerAttribute(specialEventElement, "minCapacity");
        Integer maxCapacity = this.getOptionalIntegerAttribute(specialEventElement, "maxCapacity");
        String email = this.getOptionalStringAttribute(specialEventElement, "email");
        Boolean requiredAttendance = this.getOptionalBooleanAttribute(specialEventElement, "attendanceRequired");
        if (requiredAttendance == null) {
            requiredAttendance = new Boolean(false);
        }
        CourseEvent event = new CourseEvent();
        event.setEventName(eventName);
        event.setMinCapacity(minCapacity);
        event.setMaxCapacity(maxCapacity);
        event.setEmail(email);
        event.setReqAttendance(requiredAttendance);
        try {
            this.elementRelatedCourses(specialEventElement, event);
            this.elementMeetings(specialEventElement, event);
            Element eventContactElement = specialEventElement.element(eventContactElementName);
            if (eventContactElement != null) {
                event.setMainContact(this.elementEventContact(eventContactElement));
            }
            this.elementAdditionalEventContacts(specialEventElement, event);
            Element sponsoringOrgElement = specialEventElement.element(sponsoringOrgElementName);
            if (sponsoringOrgElement != null) {
                this.elementSponsoringOrganization(sponsoringOrgElement, event);
            }
            this.elementNotes(specialEventElement, event);
        }
        catch (Exception e) {
            this.addNote("Not Loading courseRelatedEvent Error:  " + e.getMessage());
            this.addNote("\t " + specialEventElement.asXML());
            return null;
        }
        this.getHibSession().save((Object)event);
        return event;
    }

    private void elementMeetings(Element element, Event event) throws Exception {
        String meetingsElementName = "meetings";
        Iterator it = element.elementIterator(meetingsElementName);
        while (it.hasNext()) {
            Element meetingsElement = (Element)it.next();
            Iterator meetingIt = meetingsElement.elementIterator(meetingElementName);
            while (meetingIt.hasNext()) {
                this.elementMeeting((Element)meetingIt.next(), event);
            }
        }
        if (event.getMeetings() == null || event.getMeetings().size() == 0) {
            throw new Exception(meetingsElementName + " element must contain at least one " + meetingElementName + " element");
        }
    }

    private void elementMeeting(Element meetingElement, Event event) throws Exception {
        if (!meetingElement.getName().equalsIgnoreCase(meetingElementName)) {
            throw new Exception("Not Loading " + meetingElement.getName() + " Error:  attempted to load as " + meetingElementName);
        }
        String meetingDateStr = this.getRequiredStringAttribute(meetingElement, "meetingDate", meetingElementName);
        String startTimeStr = this.getRequiredStringAttribute(meetingElement, "startTime", meetingElementName);
        String endTimeStr = this.getRequiredStringAttribute(meetingElement, "endTime", meetingElementName);
        Integer startOffset = this.getOptionalIntegerAttribute(meetingElement, "startOffset");
        Integer endOffset = this.getOptionalIntegerAttribute(meetingElement, "stopOffset");
        String buildingAbbv = this.getOptionalStringAttribute(meetingElement, "buildingAbbv");
        String roomNumber = this.getOptionalStringAttribute(meetingElement, "roomNumber");
        String location = this.getOptionalStringAttribute(meetingElement, "location");
        Boolean classCanOverride = this.getOptionalBooleanAttribute(meetingElement, "callCanOverride");
        String approvedDateStr = this.getOptionalStringAttribute(meetingElement, "approvedDateTime");
        if (classCanOverride == null) {
            classCanOverride = new Boolean(true);
        }
        EventRelatedImports.TimeObject timeObj = new EventRelatedImports.TimeObject(this, startTimeStr, endTimeStr, null);
        Meeting meeting = timeObj.asMeeting();
        meeting.setStartOffset(startOffset);
        meeting.setStopOffset(endOffset);
        meeting.setLocationPermanentId(this.findMeetingLocationPermId(buildingAbbv, roomNumber, location));
        if (meeting.getLocationPermanentId() == null) {
            throw new Exception("Not Loading " + meetingElement.getName() + " Error:  meeting location not found - " + (buildingAbbv != null ? buildingAbbv + (roomNumber != null ? " " + roomNumber : "") : (location != null ? location : "")));
        }
        meeting.setClassCanOverride(classCanOverride);
        meeting.setMeetingDate(CalendarUtils.getDate(meetingDateStr, this.dateFormat));
        if (meeting.getMeetingDate() == null) {
            throw new Exception("Not Loading " + meetingElement.getName() + " Error:  meeting date must not be null");
        }
        if (approvedDateStr != null) {
            Date approvedDate = CalendarUtils.getDate(approvedDateStr, this.dateFormat + " " + this.timeFormat);
            if (approvedDate == null) {
                approvedDate = CalendarUtils.getDate(approvedDateStr, this.dateFormat);
            }
            meeting.setStatus(Meeting.Status.APPROVED);
            meeting.setApprovalDate(approvedDate);
        }
        meeting.setEvent(event);
        event.addTomeetings(meeting);
    }

    private void elementRelatedCourses(Element element, CourseEvent event) throws Exception {
        String relatedCoursesElementName = "relatedCourses";
        Iterator it = element.elementIterator(relatedCoursesElementName);
        while (it.hasNext()) {
            Element relatedCoursesElement = (Element)it.next();
            Iterator courseIt = relatedCoursesElement.elementIterator(courseElementName);
            while (courseIt.hasNext()) {
                this.elementCourse((Element)courseIt.next(), event);
            }
        }
    }

    private void elementCourse(Element courseElement, CourseEvent courseEvent) throws Exception {
        if (!courseElement.getName().equalsIgnoreCase(courseElementName)) {
            throw new Exception("Not Loading " + courseElement.getName() + " Error:  attempted to load as " + courseElementName);
        }
        String relatedExternalIdStr = this.getRequiredStringAttribute(courseElement, "relatedExternalId", courseElementName);
        String relationshipType = this.getRequiredStringAttribute(courseElement, "relationshipType", courseElementName);
        String term = this.getRequiredStringAttribute(courseElement, "term", courseElementName);
        String year = this.getRequiredStringAttribute(courseElement, "year", courseElementName);
        String courseExternalIdStr = this.getOptionalStringAttribute(courseElement, "courseExternalId");
        CourseOffering courseOffering = null;
        if (courseExternalIdStr != null) {
            courseOffering = this.findCourseOfferingFromExternalId(courseExternalIdStr, year, term, this.academicInitiative);
        }
        RelatedCourseInfo rci = new RelatedCourseInfo();
        if (relationshipType.equalsIgnoreCase("class")) {
            Class_ c = this.findClassFromExternalId(relatedExternalIdStr, year, term, this.academicInitiative);
            if (c == null) {
                throw new Exception("Not Loading " + courseElement.getName() + " Error: unable to find a class with an externalId of " + relatedExternalIdStr);
            }
            rci.setOwner(c);
            if (courseOffering == null) {
                rci.setCourse(c.getSchedulingSubpart().getControllingCourseOffering());
            } else {
                rci.setCourse(courseOffering);
            }
        } else if (relationshipType.equalsIgnoreCase("instructionalOffering")) {
            InstructionalOffering io = this.findInstructionalOfferingFromExternalId(relatedExternalIdStr, year, term, this.academicInitiative);
            if (io == null) {
                throw new Exception("Not Loading " + courseElement.getName() + " Error: unable to find a instructional offering with an externalId of " + relatedExternalIdStr);
            }
            rci.setOwner(io);
            if (courseOffering == null) {
                rci.setCourse(io.getControllingCourseOffering());
            } else {
                rci.setCourse(courseOffering);
            }
        } else if (relationshipType.equalsIgnoreCase("courseOffering")) {
            CourseOffering co = this.findCourseOfferingFromExternalId(relatedExternalIdStr, year, term, this.academicInitiative);
            if (co == null) {
                throw new Exception("Not Loading " + courseElement.getName() + " Error: unable to find a course offering with an externalId of " + relatedExternalIdStr);
            }
            rci.setOwner(co);
            rci.setCourse(co);
        }
        rci.setEvent(courseEvent);
        courseEvent.addTorelatedCourses(rci);
    }

    private EventContact elementEventContact(Element eventContactElement) throws Exception {
        if (!eventContactElement.getName().equalsIgnoreCase(eventContactElementName)) {
            throw new Exception("Not Loading " + eventContactElement.getName() + " Error:  attempted to load as " + eventContactElementName);
        }
        String externalId = this.getRequiredStringAttribute(eventContactElement, "externalId", eventContactElementName);
        String firstName = this.getOptionalStringAttribute(eventContactElement, "firstName");
        String middleName = this.getOptionalStringAttribute(eventContactElement, "middleName");
        String lastName = this.getRequiredStringAttribute(eventContactElement, "lastName", eventContactElementName);
        String acadTitle = this.getOptionalStringAttribute(eventContactElement, "acadTitle");
        String email = this.getOptionalStringAttribute(eventContactElement, "email");
        String phone = this.getOptionalStringAttribute(eventContactElement, "phone");
        try {
            Long numId = new Long(externalId);
            if (numId != null && numId > 0L) {
                externalId = numId.toString();
            }
        }
        catch (Exception numId) {
            // empty catch block
        }
        EventContact ec = EventContact.findByExternalUniqueId(externalId);
        if (ec == null) {
            ExternalUidLookup.UserInfo user = null;
            try {
                if (this.iLookup != null) {
                    user = this.iLookup.doLookup(externalId);
                }
            }
            catch (Exception e) {
                this.warn("Failed to lookup " + externalId + ": " + e.getMessage(), e);
            }
            if (user != null) {
                if (email == null) {
                    email = user.getEmail();
                }
                if (firstName == null) {
                    firstName = user.getFirstName();
                }
                if (middleName == null) {
                    middleName = user.getMiddleName();
                }
                if (lastName == null) {
                    lastName = user.getLastName();
                }
                if (phone == null) {
                    phone = user.getLastName();
                }
                if (acadTitle == null) {
                    acadTitle = user.getAcademicTitle();
                }
            }
            ec = new EventContact();
            ec.setFirstName(firstName);
            ec.setMiddleName(middleName);
            ec.setLastName(lastName);
            ec.setAcademicTitle(acadTitle);
            ec.setEmailAddress(email);
            ec.setPhone(phone);
            ec.setExternalUniqueId(externalId);
            this.getHibSession().save((Object)ec);
            this.flush(true);
        }
        return ec;
    }

    private void elementAdditionalEventContacts(Element element, Event event) throws Exception {
        String additionalContactsElementName = "additionalEventContacts";
        Iterator it = element.elementIterator(additionalContactsElementName);
        while (it.hasNext()) {
            Element additionalContactsElement = (Element)it.next();
            EventContact ec = null;
            Iterator eventContactIt = additionalContactsElement.elementIterator(eventContactElementName);
            while (eventContactIt.hasNext()) {
                ec = this.elementEventContact((Element)eventContactIt.next());
                if (ec == null) continue;
                event.getAdditionalContacts().add(ec);
            }
        }
    }

    private void elementSponsoringOrganization(Element sponsoringOrgElement, Event event) throws Exception {
        if (!sponsoringOrgElement.getName().equalsIgnoreCase(sponsoringOrgElementName)) {
            throw new Exception("Not Loading " + sponsoringOrgElement.getName() + " Error:  attempted to load as " + sponsoringOrgElementName);
        }
        String name = this.getRequiredStringAttribute(sponsoringOrgElement, "name", sponsoringOrgElementName);
        if (name != null) {
            SponsoringOrganization sponsoringOrg = this.findSponsoringOrg(name);
            if (sponsoringOrg != null) {
                event.setSponsoringOrganization(sponsoringOrg);
            } else {
                throw new Exception("sponsoringOrganization element matching org not found:  " + name);
            }
        }
    }

    private void elementNotes(Element element, Event event) throws Exception {
        String notesElementName = "notes";
        Iterator it = element.elementIterator(notesElementName);
        while (it.hasNext()) {
            Element notesElement = (Element)it.next();
            Iterator noteIt = notesElement.elementIterator(noteElementName);
            while (noteIt.hasNext()) {
                this.elementNote((Element)noteIt.next(), event);
            }
        }
    }

    private void elementNote(Element noteElement, Event event) throws Exception {
        if (!noteElement.getName().equalsIgnoreCase(noteElementName)) {
            throw new Exception("Not Loading " + noteElement.getName() + " Error:  attempted to load as " + noteElementName);
        }
        String noteText = this.getRequiredStringAttribute(noteElement, "noteText", noteElementName);
        String noteTypeStr = this.getRequiredStringAttribute(noteElement, "noteType", noteElementName);
        String noteTimestampStr = this.getOptionalStringAttribute(noteElement, "timestamp");
        String userName = this.getOptionalStringAttribute(noteElement, "userName");
        String userId = this.getOptionalStringAttribute(noteElement, "userId");
        EventNote note = new EventNote();
        note.setTextNote(noteText);
        if (noteTypeStr.equalsIgnoreCase("create")) {
            note.setNoteType(0);
        } else if (noteTypeStr.equalsIgnoreCase("update")) {
            note.setNoteType(1);
        } else if (noteTypeStr.equalsIgnoreCase("approve")) {
            note.setNoteType(2);
        } else if (noteTypeStr.equalsIgnoreCase("reject")) {
            note.setNoteType(3);
        } else if (noteTypeStr.equalsIgnoreCase("delete")) {
            note.setNoteType(4);
        } else if (noteTypeStr.equalsIgnoreCase("edit")) {
            note.setNoteType(5);
        }
        if (noteTimestampStr == null) {
            note.setTimeStamp(new Date());
        } else {
            note.setTimeStamp(CalendarUtils.getDate(noteTimestampStr, this.dateFormat + " " + this.timeFormat));
        }
        note.setUser(userName);
        note.setUserId(userId);
        note.setEvent(event);
        event.addTonotes(note);
    }

    @Override
    protected String getEmailSubject() {
        return "Event Import Results";
    }

    private Session findDefaultSession(String academicInitiative, Date aDate) {
        return (Session)this.getHibSession().createQuery("from Session as s where s.academicInitiative = :academicInititive and s.eventBeginDate <= :aDate  and s.eventEndDate >= :aDate").setString("academicInititive", academicInitiative).setDate("aDate", aDate).setCacheable(true).uniqueResult();
    }

    private Room findRoom(String buildingAbbv, String roomNumber) {
        List rooms;
        Room room = null;
        if (room == null && (rooms = this.getHibSession().createQuery("select distinct r from Room as r where r.roomNumber=:roomNbr and r.building.abbreviation = :building").setString("building", buildingAbbv).setString("roomNbr", roomNumber).setCacheable(true).setFlushMode(FlushMode.MANUAL).list()) != null && rooms.size() > 0) {
            room = (Room)rooms.iterator().next();
        }
        return room;
    }

    private SponsoringOrganization findSponsoringOrg(String name) {
        SponsoringOrganization sponsoringOrg = null;
        if (sponsoringOrg == null) {
            sponsoringOrg = (SponsoringOrganization)this.getHibSession().createQuery("select distinct so from SponsoringOrganization as so where so.name = :name").setString("name", name).setCacheable(true).setFlushMode(FlushMode.MANUAL).uniqueResult();
        }
        return sponsoringOrg;
    }

    private NonUniversityLocation findLocation(String name) {
        List locations = this.findNonUniversityLocationsWithName(name);
        if (locations == null || locations.size() > 0) {
            return (NonUniversityLocation)locations.iterator().next();
        }
        return null;
    }

    private Long findMeetingLocationPermId(String buildingAbbv, String roomNumber, String location) {
        Room room = this.findRoom(buildingAbbv, roomNumber);
        if (room != null) {
            return room.getPermanentId();
        }
        NonUniversityLocation nonUnivLocation = this.findLocation(location);
        if (nonUnivLocation != null) {
            return nonUnivLocation.getPermanentId();
        }
        return null;
    }

    private Class_ findClassFromExternalId(String externalId, String year, String term, String academicInitiative) {
        if (externalId == null || year == null || term == null || academicInitiative == null) {
            return null;
        }
        return (Class_)this.getHibSession().createQuery("select c from Class_ as c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session as s where s.academicInitiative = :academicInititive and s.academicYear = :aYear and s.academicTerm = :aTerm and c.externalUniqueId = :anExternalId").setString("academicInititive", academicInitiative).setString("aYear", year).setString("aTerm", term).setString("anExternalId", externalId).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    private InstructionalOffering findInstructionalOfferingFromExternalId(String externalId, String year, String term, String academicInitiative) {
        if (externalId == null || year == null || term == null || academicInitiative == null) {
            return null;
        }
        return (InstructionalOffering)this.getHibSession().createQuery("select io from InstructionalOffering as io inner join io.session as s where s.academicInitiative = :academicInititive and s.academicYear = :aYear and s.academicTerm = :aTerm and io.externalUniqueId = :anExternalId").setString("academicInititive", academicInitiative).setString("aYear", year).setString("aTerm", term).setString("anExternalId", externalId).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    private CourseOffering findCourseOfferingFromExternalId(String externalId, String year, String term, String academicInitiative) {
        if (externalId == null || year == null || term == null || academicInitiative == null) {
            return null;
        }
        return (CourseOffering)this.getHibSession().createQuery("select co from CourseOffering as co inner join co.instructionalOffering.session as s where s.academicInitiative = :academicInititive and s.academicYear = :aYear and s.academicTerm = :aTerm and co.externalUniqueId = :anExternalId").setString("academicInititive", academicInitiative).setString("aYear", year).setString("aTerm", term).setString("anExternalId", externalId).setCacheable(true).setMaxResults(1).uniqueResult();
    }
}

