/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.CacheMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.api.JsonApiHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;

public abstract class ApiConnector {
    @Autowired
    protected SessionContext sessionContext;
    @Autowired
    protected ApiToken apiToken;

    public void doGet(ApiHelper helper) throws IOException {
        helper.sendError(501);
    }

    public void doPut(ApiHelper helper) throws IOException {
        helper.sendError(501);
    }

    public void doPost(ApiHelper helper) throws IOException {
        helper.sendError(501);
    }

    public void doDelete(ApiHelper helper) throws IOException {
        helper.sendError(501);
    }

    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new JsonApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    protected abstract String getName();

    protected CacheMode getCacheMode() {
        String cacheMode;
        String string = cacheMode = this.getName() != null && !this.getName().isEmpty() ? ApplicationProperty.ApiCacheMode.value(this.getName()) : null;
        return cacheMode != null ? CacheMode.valueOf(cacheMode) : (this instanceof HasCacheMode ? ((HasCacheMode)((Object)this)).getCacheMode() : null);
    }

    protected void authenticateWithTokenIfNeeded(HttpServletRequest request, HttpServletResponse response) {
        UserContext context;
        if ((!this.sessionContext.isAuthenticated() || this.sessionContext.getUser() instanceof AnonymousUserContext) && request.getParameter("token") != null && ApplicationProperty.ApiCanUseAPIToken.isTrue() && (context = this.apiToken.getContext(request.getParameter("token"))) != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new TokenAuthentication(context));
        }
    }

    protected void revokeTokenAuthenticationIfNeeded(HttpServletRequest request, HttpServletResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.authenticateWithTokenIfNeeded(request, response);
        ApiHelper helper = this.createHelper(request, response);
        try {
            this.doGet(helper);
        }
        finally {
            helper.close();
            this.revokeTokenAuthenticationIfNeeded(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.authenticateWithTokenIfNeeded(request, response);
        ApiHelper helper = this.createHelper(request, response);
        try {
            this.doPut(helper);
        }
        finally {
            helper.close();
            this.revokeTokenAuthenticationIfNeeded(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.authenticateWithTokenIfNeeded(request, response);
        ApiHelper helper = this.createHelper(request, response);
        try {
            this.doPost(helper);
        }
        finally {
            helper.close();
            this.revokeTokenAuthenticationIfNeeded(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.authenticateWithTokenIfNeeded(request, response);
        ApiHelper helper = this.createHelper(request, response);
        try {
            this.doDelete(helper);
        }
        finally {
            helper.close();
            this.revokeTokenAuthenticationIfNeeded(request, response);
        }
    }

    protected static class TokenAuthentication
    implements Authentication {
        private static final long serialVersionUID = 1L;
        private UserContext iContext;

        public TokenAuthentication(UserContext context) {
            this.iContext = context;
        }

        public String getName() {
            return this.iContext.getName();
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return this.iContext.getAuthorities();
        }

        public Object getCredentials() {
            return this.iContext.getPassword();
        }

        public Object getDetails() {
            return null;
        }

        public Object getPrincipal() {
            return this.iContext;
        }

        public boolean isAuthenticated() {
            return true;
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            throw new IllegalArgumentException("Operation not supported.");
        }
    }
}

