/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.form.TimetableForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.timegrid.PdfTimetableGridTable;
import org.unitime.timetable.webutil.timegrid.TimetableGridModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridTable;

@Service(value="/timetable")
public class TimetableAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        TimetableForm myForm = (TimetableForm)form;
        this.sessionContext.checkPermission(Right.TimetableGrid);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null && request.getParameter("resource") != null) {
            op = "Change";
        }
        if ("Change".equals(op) || "Export PDF".equals(op)) {
            this.save(myForm);
        }
        this.load(myForm);
        TimetableGridTable table = this.load(myForm);
        request.setAttribute("table", (Object)table);
        if ("Show".equals(op)) {
            table.setFindString(request.getParameter("filter"));
            myForm.setFind(request.getParameter("filter"));
            if ("i".equals(request.getParameter("mode"))) {
                table.setResourceType(1);
                myForm.setResource("Instructor");
            }
            if ("r".equals(request.getParameter("mode"))) {
                table.setResourceType(0);
                myForm.setResource("Room");
            }
            this.save(myForm);
        }
        myForm.setLoaded(table.reload(request, this.sessionContext, this.courseTimetablingSolverService.getSolver()));
        if ("Export PDF".equals(op)) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "timetable");
            PdfTimetableGridTable.export2Pdf(table, out);
            out.flush();
            out.close();
            return null;
        }
        myForm.setOp("Change");
        return mapping.findForward("showTimetable");
    }

    private TimetableGridTable load(TimetableForm form) throws Exception {
        TimetableGridTable table = new TimetableGridTable();
        table.load(this.sessionContext.getUser());
        form.setResource(TimetableGridModel.sResourceTypes[table.getResourceType()]);
        form.setDay(TimetableGridTable.sDays[table.getDays()]);
        form.setDayMode(TimetableGridTable.sDayMode[table.getDayMode()]);
        form.setFind(table.getFindString());
        form.setOrderBy(TimetableGridTable.sOrderBy[table.getOrderBy()]);
        form.setDispMode(TimetableGridTable.sDispModes[table.getDispMode()]);
        form.setBgColor(TimetableGridModel.sBgModes[table.getBgMode()]);
        form.setWeeks(table.getWeeks(this.sessionContext));
        form.setWeek(table.getWeek());
        form.setShowUselessTimes(table.getShowUselessTimes());
        form.setShowInstructors(table.getShowInstructors());
        form.setShowEvents(table.getShowEvents());
        form.setShowComments(table.getShowComments());
        form.setShowTimes(table.getShowTimes());
        return table;
    }

    public void save(TimetableForm form) throws Exception {
        TimetableGridTable table = new TimetableGridTable();
        table.setResourceType(form.getResourceInt());
        table.setDays(form.getDayInt());
        table.setDayMode(form.getDayModeInt());
        table.setFindString(form.getFind());
        table.setOrderBy(form.getOrderByInt());
        table.setDispMode(form.getDispModeInt());
        table.setBgMode(form.getBgColorInt());
        table.setShowUselessTimes(form.getShowUselessTimes());
        table.setShowInstructors(form.getShowInstructors());
        table.setShowComments(form.getShowComments());
        table.setShowEvents(form.getShowEvents());
        table.setShowTimes(form.getShowTimes());
        if (form.getWeek() != null) {
            table.setWeek(form.getWeek());
        }
        table.save(this.sessionContext.getUser());
    }
}

