/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/subjectList")
public class SubjectListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] stringArray;
        this.sessionContext.checkPermission(Right.SubjectAreas);
        List subjects = SubjectArea.getSubjectAreaList(this.sessionContext.getUser().getCurrentAcademicSessionId());
        boolean dispLastChanges = CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(this.sessionContext.getUser()));
        if ("Export PDF".equals(request.getParameter("op"))) {
            String[] stringArray2;
            int n = dispLastChanges ? 5 : 4;
            String string = "Subject Area List - " + this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel();
            if (dispLastChanges) {
                String[] stringArray3 = new String[5];
                stringArray3[0] = "Abbv";
                stringArray3[1] = "Title";
                stringArray3[2] = "Department";
                stringArray3[3] = "Managers";
                stringArray2 = stringArray3;
                stringArray3[4] = "Last Change";
            } else {
                String[] stringArray4 = new String[4];
                stringArray4[0] = "Abbv";
                stringArray4[1] = "Title";
                stringArray4[2] = "Departmnet";
                stringArray2 = stringArray4;
                stringArray4[3] = "Managers";
            }
            PdfWebTable webTable = new PdfWebTable(n, string, "subjectList.do?ord=%%", stringArray2, new String[]{"left", "left", "left", "left", "right"}, new boolean[]{true, true, true, true, false});
            for (SubjectArea s : subjects) {
                Department d = s.getDepartment();
                String sdName = "";
                for (TimetableManager mgr : s.getManagers()) {
                    if (sdName.length() > 0) {
                        sdName = sdName + "\n";
                    }
                    sdName = sdName + mgr.getFirstName() + " " + mgr.getLastName();
                }
                String lastChangeStr = null;
                Long lastChangeCmp = null;
                if (dispLastChanges) {
                    List changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                    ChangeLog lastChange = changes == null || changes.isEmpty() ? null : (ChangeLog)changes.get(0);
                    lastChangeStr = lastChange == null ? "" : ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName();
                    lastChangeCmp = new Long(lastChange == null ? 0L : lastChange.getTimeStamp().getTime());
                }
                webTable.addLine(null, new String[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode() + (d.getAbbreviation() == null ? "" : ": " + d.getAbbreviation().trim()), sdName == null || sdName.trim().length() == 0 ? "" : sdName, lastChangeStr}, new Comparable[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode(), sdName, lastChangeCmp});
            }
            ExportUtils.exportPDF(webTable, WebTable.getOrder(this.sessionContext, "SubjectList.ord"), response, "subjects");
            return null;
        }
        int n = dispLastChanges ? 5 : 4;
        if (dispLastChanges) {
            String[] stringArray5 = new String[5];
            stringArray5[0] = "Abbv";
            stringArray5[1] = "Title";
            stringArray5[2] = "Department";
            stringArray5[3] = "Managers";
            stringArray = stringArray5;
            stringArray5[4] = "Last Change";
        } else {
            String[] stringArray6 = new String[4];
            stringArray6[0] = "Abbv";
            stringArray6[1] = "Title";
            stringArray6[2] = "Department";
            stringArray = stringArray6;
            stringArray6[3] = "Managers";
        }
        WebTable webTable = new WebTable(n, "", "subjectList.do?ord=%%", stringArray, new String[]{"left", "left", "left", "left", "right"}, new boolean[]{true, true, true, true, false});
        webTable.enableHR("#9CB0CE");
        webTable.setRowStyle("white-space: nowrap");
        WebTable.setOrder(this.sessionContext, "SubjectList.ord", request.getParameter("ord"), 1);
        for (SubjectArea s : subjects) {
            Department d = s.getDepartment();
            String sdName = "";
            for (TimetableManager mgr : s.getManagers()) {
                if (sdName.length() > 0) {
                    sdName = sdName + "<BR>";
                }
                sdName = sdName + mgr.getFirstName() + " " + mgr.getLastName();
            }
            String lastChangeStr = null;
            Long lastChangeCmp = null;
            if (dispLastChanges) {
                List changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                ChangeLog lastChange = changes == null || changes.isEmpty() ? null : (ChangeLog)changes.get(0);
                lastChangeStr = lastChange == null ? "&nbsp;" : "<span title='" + lastChange.getLabel() + "'>" + ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName() + "</span>";
                lastChangeCmp = new Long(lastChange == null ? 0L : lastChange.getTimeStamp().getTime());
            }
            webTable.addLine("onClick=\"document.location.href='subjectAreaEdit.do?op=edit&id=" + s.getUniqueId() + "'\"", new String[]{"<A name='" + s.getUniqueId() + "'>" + s.getSubjectAreaAbbreviation() + "</A>", s.getTitle(), d == null ? "&nbsp;" : "<span title='" + d.getHtmlTitle() + "'>" + d.getDeptCode() + (d.getAbbreviation() == null ? "" : ": " + d.getAbbreviation().trim()) + "</span>", sdName == null || sdName.trim().length() == 0 ? "&nbsp;" : sdName, lastChangeStr}, new Comparable[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode(), sdName, lastChangeCmp});
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "SubjectList.ord")));
        return mapping.findForward("showSubjectList");
    }
}

