/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorListUpdateForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.StaffComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/instructorListUpdate")
public class InstructorListUpdateAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Collection available;
        Collection assigned;
        this.sessionContext.checkPermission(Right.ManageInstructors);
        InstructorListUpdateForm frm = (InstructorListUpdateForm)form;
        MessageResources rsc = this.getResources(request);
        String op = frm.getOp();
        if (op != null && op.equals(rsc.getMessage("button.backToInstructorList"))) {
            response.sendRedirect(response.encodeURL("instructorList.do"));
            return null;
        }
        if (op != null && op.equals(rsc.getMessage("button.update"))) {
            this.update(frm, request);
            response.sendRedirect(response.encodeURL("instructorList.do"));
            return null;
        }
        if (op != null && op.equals(rsc.getMessage("button.applyFilter"))) {
            request.setAttribute("filterApplied", (Object)"1");
        }
        if ((assigned = this.getAssigned()) != null) {
            frm.setAssignedInstr(assigned);
        }
        if ((available = this.getAvailable(frm, request)) != null) {
            frm.setAvailableInstr(available);
        }
        LookupTables.setupPositionTypes(request);
        this.setupFilters(frm, request);
        frm.setInstructors();
        frm.setNameFormat(this.sessionContext.getUser().getProperty(UserProperty.NameFormat));
        return mapping.findForward("showUpdateInstructorList");
    }

    private void setupFilters(InstructorListUpdateForm frm, HttpServletRequest request) {
        String[] defaultPosTypes = new String[]{"ADMIN_STAFF", "CLERICAL_STAFF", "SERVICE_STAFF", "FELLOWSHIP", "UNDRGRD_TEACH_ASST", "EMERITUS OTHER"};
        boolean filterSet = "1".equals(this.sessionContext.getUser().getProperty("instrListFilter", "0"));
        String filterApplied = (String)request.getAttribute("filterApplied");
        if (filterApplied != null && !filterApplied.equals("1")) {
            filterApplied = null;
        }
        if (!filterSet) {
            frm.setDisplayListType("both");
            frm.setDisplayPosType(defaultPosTypes);
        } else if (filterApplied == null) {
            frm.setDisplayListType(this.sessionContext.getUser().getProperty("displayListType"));
            String displayPosType = this.sessionContext.getUser().getProperty("displayPosType");
            if (displayPosType != null) {
                String[] arr = null;
                if (displayPosType.trim().length() == 0) {
                    arr = new String[]{"X"};
                } else {
                    StringTokenizer strTok = new StringTokenizer(displayPosType);
                    arr = new String[strTok.countTokens()];
                    int ct = 0;
                    while (strTok.hasMoreTokens()) {
                        arr[ct++] = strTok.nextToken();
                    }
                }
                frm.setDisplayPosType(arr);
            }
        }
        if (frm.getDisplayListType() == null || frm.getDisplayListType().length() == 0) {
            frm.setDisplayListType("both");
        }
        if (frm.getDisplayPosType() == null) {
            if (filterApplied != null) {
                frm.setDisplayPosType(new String[]{"X"});
            } else {
                frm.setDisplayPosType(defaultPosTypes);
            }
        }
        this.sessionContext.getUser().setProperty("instrListFilter", "1");
        this.sessionContext.getUser().setProperty("displayListType", frm.getDisplayListType());
        this.sessionContext.getUser().setProperty("displayPosType", Constants.arrayToStr(frm.getDisplayPosType(), "", " "));
    }

    private void update(InstructorListUpdateForm frm, HttpServletRequest request) throws Exception {
        Object[] selectedAssigned = frm.getAssignedSelected();
        Object[] selectedNotAssigned = frm.getAvailableSelected();
        Collection assigned = this.getAssigned();
        Collection available = this.getAvailable(frm, request);
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        if (selectedAssigned.length != 0) {
            s1.append(Constants.arrayToStr(selectedAssigned, "", ","));
        }
        if (selectedNotAssigned.length != 0) {
            s2.append(Constants.arrayToStr(selectedNotAssigned, "", ","));
        }
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        HashSet<Class_> updatedClasses = new HashSet<Class_>();
        try {
            tx = hibSession.beginTransaction();
            if (frm.getDisplayListType() != null && (frm.getDisplayListType().equals("assigned") || frm.getDisplayListType().equals("both"))) {
                for (DepartmentalInstructor inst : assigned) {
                    if (s1.indexOf(inst.getUniqueId().toString()) != -1 || !inst.getExams().isEmpty() || !inst.getClasses().isEmpty()) continue;
                    ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_MANAGE, ChangeLog.Operation.DELETE, null, inst.getDepartment());
                    for (ClassInstructor ci : inst.getClasses()) {
                        updatedClasses.add(ci.getClassInstructing());
                        ci.getClassInstructing().getClassInstructors().remove(ci);
                        hibSession.saveOrUpdate((Object)ci);
                        hibSession.delete((Object)ci);
                    }
                    for (Assignment a : inst.getAssignments()) {
                        a.getInstructors().remove(inst);
                        hibSession.saveOrUpdate((Object)a);
                    }
                    inst.getDepartment().getInstructors().remove(inst);
                    hibSession.delete((Object)inst);
                }
            }
            if (frm.getDisplayListType() != null && (frm.getDisplayListType().equals("available") || frm.getDisplayListType().equals("both"))) {
                for (Staff staff : available) {
                    if (s2.indexOf(staff.getUniqueId().toString()) == -1) continue;
                    DepartmentalInstructor inst = new DepartmentalInstructor();
                    inst.setLastName(staff.getLastName());
                    inst.setEmail(staff.getEmail());
                    HttpSession httpSession = request.getSession();
                    String deptId = (String)httpSession.getAttribute(Constants.DEPT_ID_ATTR_NAME);
                    Department d = (Department)new DepartmentDAO().get(new Long(deptId));
                    inst.setDepartment(d);
                    d.getInstructors().add(inst);
                    if (staff.getFirstName() != null) {
                        inst.setFirstName(staff.getFirstName());
                    }
                    if (staff.getMiddleName() != null) {
                        inst.setMiddleName(staff.getMiddleName());
                    }
                    if (staff.getAcademicTitle() != null) {
                        inst.setAcademicTitle(staff.getAcademicTitle());
                    }
                    if (staff.getExternalUniqueId() != null) {
                        inst.setExternalUniqueId(staff.getExternalUniqueId());
                    }
                    if (staff.getPositionType() != null) {
                        inst.setPositionType(staff.getPositionType());
                    }
                    inst.setIgnoreToFar(Boolean.FALSE);
                    hibSession.save((Object)inst);
                    ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_MANAGE, ChangeLog.Operation.CREATE, null, inst.getDepartment());
                }
            }
            tx.commit();
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).newInstance();
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private Collection getAvailable(InstructorListUpdateForm frm, HttpServletRequest request) throws Exception {
        HttpSession httpSession = request.getSession();
        if (httpSession.getAttribute(Constants.DEPT_ID_ATTR_NAME) != null) {
            String deptId = (String)httpSession.getAttribute(Constants.DEPT_ID_ATTR_NAME);
            Department d = (Department)new DepartmentDAO().get(new Long(deptId));
            List available = Staff.getStaffByDept(d.getDeptCode().trim(), this.sessionContext.getUser().getCurrentAcademicSessionId());
            Collections.sort(available, new StaffComparator(2));
            return available;
        }
        return null;
    }

    private Collection getAssigned() throws Exception {
        String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
        if (deptId != null) {
            List<DepartmentalInstructor> assigned = DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
            Collections.sort(assigned, new DepartmentalInstructorComparator(2));
            return assigned;
        }
        return null;
    }
}

